.\" dpkg manual page - deb822(5)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH deb822 5 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
deb822 \- Debian RFC822 control data format
.
.SH DESCRIPTION
The package management system manipulates data represented in a common
format, known as \fIcontrol data\fP, stored in \fIcontrol files\fP.
Control files are used for source packages, binary packages and the
\fB.changes\fP files which control the installation of uploaded
files (\fBdpkg\fP's internal databases are in a similar format).
.
.SH SYNTAX
A control file consists of one or more paragraphs of fields (the paragraphs
are also sometimes referred to as stanzas).
The paragraphs are separated by empty lines.
Parsers may accept lines consisting solely of U+0020 \fBSPACE\fP and
U+0009 \fBTAB\fP as paragraph separators, but control files should use
empty lines.
Some control files allow only one paragraph; others allow several, in which
case each paragraph usually refers to a different package.
(For example, in source packages, the first paragraph refers to the source
package, and later paragraphs refer to binary packages generated from the
source.)
The ordering of the paragraphs in control files is significant.

Each paragraph consists of a series of data fields.
Each field consists of the field name followed by a colon
(U+003A ‘\fB:\fP’), and then the data/value associated with that field.
The field name is composed of US-ASCII characters excluding control
characters, space, and colon (i.e., characters in the ranges
U+0021 ‘\fB!\fP’ through U+0039 ‘\fB9\fP’, and
U+003B ‘\fB;\fP’ through U+007E ‘\fB~\fP’, inclusive).
Field names must not begin with the comment character
(U+0023 ‘\fB#\fP’), nor with the hyphen character
(U+002D ‘\fB\-\fP’).

The field ends at the end of the line or at the end of the last continuation
line (see below).
Horizontal whitespace (U+0020 \fBSPACE\fP and U+0009 \fBTAB\fP) may occur
immediately before or after the value and is ignored there; it is conventional
to put a single space after the colon.
For example, a field might be:
.RS
.nf
Package: dpkg
.fi
.RE
the field name is \fBPackage\fP and the field value \fBdpkg\fP.

Empty field values are only permitted in source package control files
(\fIdebian/control\fP).
Such fields are ignored.

A paragraph must not contain more than one instance of a particular field name.

There are three types of fields:

.RS 0
.TP
.B simple
The field, including its value, must be a single line.
Folding of the field is not permitted.
This is the default field type if the definition of the field does not
specify a different type.
.TP
.B folded
The value of a folded field is a logical line that may span several lines.
The lines after the first are called continuation lines and must start with
a U+0020 \fBSPACE\fP or a U+0009 \fBTAB\fP.
Whitespace, including any newlines, is not significant in the field values
of folded fields.

This folding method is similar to RFC5322, allowing control files that
contain only one paragraph and no multiline fields to be read by parsers
written for RFC5322.
.TP
.B multiline
The value of a multiline field may comprise multiple continuation lines.
The first line of the value, the part on the same line as the field name,
often has special significance or may have to be empty.
Other lines are added following the same syntax as the continuation lines
of the folded fields.
Whitespace, including newlines, is significant in the values of multiline
fields.
.RE

Whitespace must not appear inside names (of packages, architectures, files
or anything else) or version numbers, or between the characters of
multi-character version relationships.

The presence and purpose of a field, and the syntax of its value may differ
between types of control files.

Field names are not case-sensitive, but it is usual to capitalize the field
names using mixed case as shown below.
Field values are case-sensitive unless the description of the field says
otherwise.

Paragraph separators (empty lines) and lines consisting only of
U+0020 \fBSPACE\fP and U+0009 \fBTAB\fP, are not allowed within field
values or between fields.
Empty lines in field values are usually escaped by representing them by a
U+0020 \fBSPACE\fP followed by a dot (U+002E ‘\fB.\fP’).

Lines starting with U+0023 ‘\fB#\fP’, without any preceding whitespace
are comments lines that are only permitted in source package control files
(\fIdebian/control\fP) and in \fBdeb\-origin\fP(5) files.
These comment lines are ignored, even between two continuation lines.
They do not end logical lines.

All control files must be encoded in UTF-8.
.
.\" .SH EXAMPLE
.\" .RS
.\" .nf
.\" .fi
.\" .RE
.
.SH SEE ALSO
.BR RFC822 ,
.BR RFC5322 .
