/* Perform tilde expansion on paths for GDB and gdbserver.

   Copyright (C) 2017-2018 Free Software Foundation, Inc.

   This file is part of GDB.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#ifndef GDB_TILDE_EXPAND_H
#define GDB_TILDE_EXPAND_H

/* Perform path expansion (i.e., tilde expansion) on DIR, and return
   the full path.  */
extern std::string gdb_tilde_expand (const char *dir);

/* Same as GDB_TILDE_EXPAND, but return the full path as a
   gdb::unique_xmalloc_ptr<char>.  */
extern gdb::unique_xmalloc_ptr<char> gdb_tilde_expand_up (const char *dir);

#endif /* ! GDB_TILDE_EXPAND_H */
