static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (radius1, _(\"Radius 1\"), 1.0)                               \n"
"  value_range (0.0, 1000.0)                                                   \n"
"  ui_range (0.0, 10.0)                                                        \n"
"  ui_gamma (1.5)                                                              \n"
"                                                                              \n"
"property_double (radius2, _(\"Radius 2\"), 2.0)                               \n"
"  value_range (0.0, 1000.0)                                                   \n"
"  ui_range (0.0, 20.0)                                                        \n"
"  ui_gamma (1.5)                                                              \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_META                                                          \n"
"#define GEGL_OP_C_SOURCE difference-of-gaussians.c                            \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void attach (GeglOperation *operation)                                 \n"
"{                                                                             \n"
"  GeglNode *gegl = operation->node;                                           \n"
"  GeglNode *input, *output, *subtract, *blur1, *blur2;                        \n"
"                                                                              \n"
"  input    = gegl_node_get_input_proxy (gegl, \"input\");                     \n"
"  output   = gegl_node_get_output_proxy (gegl, \"output\");                   \n"
"                                                                              \n"
"  subtract = gegl_node_new_child (gegl,                                       \n"
"                                  \"operation\", \"gegl:subtract\",           \n"
"                                  NULL);                                      \n"
"                                                                              \n"
"  blur1    = gegl_node_new_child (gegl,                                       \n"
"                                  \"operation\", \"gegl:gaussian-blur\",      \n"
"                                  NULL);                                      \n"
"                                                                              \n"
"  blur2    = gegl_node_new_child (gegl,                                       \n"
"                                  \"operation\", \"gegl:gaussian-blur\",      \n"
"                                  NULL);                                      \n"
"                                                                              \n"
"  gegl_node_link_many (input, blur1, subtract, output, NULL);                 \n"
"  gegl_node_link (input, blur2);                                              \n"
"                                                                              \n"
"  gegl_node_connect_from (subtract, \"aux\", blur2, \"output\");              \n"
"                                                                              \n"
"  gegl_operation_meta_redirect (operation, \"radius1\", blur1, \"std-dev-x\");\n"
"  gegl_operation_meta_redirect (operation, \"radius1\", blur1, \"std-dev-y\");\n"
"  gegl_operation_meta_redirect (operation, \"radius2\", blur2, \"std-dev-x\");\n"
"  gegl_operation_meta_redirect (operation, \"radius2\", blur2, \"std-dev-y\");\n"
"                                                                              \n"
"  gegl_operation_meta_watch_nodes (operation, subtract, blur1, blur2, NULL);  \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class;                                        \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"                                                                              \n"
"  operation_class->attach = attach;                                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:difference-of-gaussians\",                        \n"
"    \"title\",       _(\"Difference of Gaussians\"),                          \n"
"    \"categories\",  \"edge-detect\",                                         \n"
"    \"description\", _(\"Edge detection with control of edge thickness, based \"\n"
"                     \"on the difference of two gaussian blurs\"),            \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
