package eventgrid

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// EventSubscriptionsClient is the azure EventGrid Management Client
type EventSubscriptionsClient struct {
	ManagementClient
}

// NewEventSubscriptionsClient creates an instance of the EventSubscriptionsClient client.
func NewEventSubscriptionsClient(subscriptionID string) EventSubscriptionsClient {
	return NewEventSubscriptionsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewEventSubscriptionsClientWithBaseURI creates an instance of the EventSubscriptionsClient client.
func NewEventSubscriptionsClientWithBaseURI(baseURI string, subscriptionID string) EventSubscriptionsClient {
	return EventSubscriptionsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Create asynchronously creates a new event subscription to the specified scope. Existing event subscriptions cannot
// be updated with this API and should instead use the Update event subscription API. This method may poll for
// completion. Polling can be canceled by passing the cancel channel argument. The channel will be used to cancel
// polling and any outstanding HTTP requests.
//
// scope is the scope of the resource to which the event subscription needs to be created. The scope can be a
// subscription, or a resource group, or a top level resource belonging to a resource provider namespace, or an
// EventGrid topic. For example, use '/subscriptions/{subscriptionId}/' for a subscription,
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for a resource group, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}'
// for a resource, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}'
// for an EventGrid topic. eventSubscriptionName is name of the event subscription to be created. Event subscription
// names must be between 3 and 64 characters in length and use alphanumeric letters only. eventSubscriptionInfo is
// event subscription properties containing the destination and filter information
func (client EventSubscriptionsClient) Create(scope string, eventSubscriptionName string, eventSubscriptionInfo EventSubscription, cancel <-chan struct{}) (<-chan EventSubscription, <-chan error) {
	resultChan := make(chan EventSubscription, 1)
	errChan := make(chan error, 1)
	go func() {
		var err error
		var result EventSubscription
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreatePreparer(scope, eventSubscriptionName, eventSubscriptionInfo, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "Create", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "Create", resp, "Failure sending request")
			return
		}

		result, err = client.CreateResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "Create", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreatePreparer prepares the Create request.
func (client EventSubscriptionsClient) CreatePreparer(scope string, eventSubscriptionName string, eventSubscriptionInfo EventSubscription, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"eventSubscriptionName": autorest.Encode("path", eventSubscriptionName),
		"scope":                 scope,
	}

	const APIVersion = "2017-06-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}", pathParameters),
		autorest.WithJSON(eventSubscriptionInfo),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client EventSubscriptionsClient) CreateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client EventSubscriptionsClient) CreateResponder(resp *http.Response) (result EventSubscription, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete an existing event subscription This method may poll for completion. Polling can be canceled by passing
// the cancel channel argument. The channel will be used to cancel polling and any outstanding HTTP requests.
//
// scope is the scope of the event subscription. The scope can be a subscription, or a resource group, or a top level
// resource belonging to a resource provider namespace, or an EventGrid topic. For example, use
// '/subscriptions/{subscriptionId}/' for a subscription,
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for a resource group, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}'
// for a resource, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}'
// for an EventGrid topic. eventSubscriptionName is name of the event subscription
func (client EventSubscriptionsClient) Delete(scope string, eventSubscriptionName string, cancel <-chan struct{}) (<-chan autorest.Response, <-chan error) {
	resultChan := make(chan autorest.Response, 1)
	errChan := make(chan error, 1)
	go func() {
		var err error
		var result autorest.Response
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.DeletePreparer(scope, eventSubscriptionName, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "Delete", nil, "Failure preparing request")
			return
		}

		resp, err := client.DeleteSender(req)
		if err != nil {
			result.Response = resp
			err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "Delete", resp, "Failure sending request")
			return
		}

		result, err = client.DeleteResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "Delete", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// DeletePreparer prepares the Delete request.
func (client EventSubscriptionsClient) DeletePreparer(scope string, eventSubscriptionName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"eventSubscriptionName": autorest.Encode("path", eventSubscriptionName),
		"scope":                 scope,
	}

	const APIVersion = "2017-06-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client EventSubscriptionsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client EventSubscriptionsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get get properties of an event subscription
//
// scope is the scope of the event subscription. The scope can be a subscription, or a resource group, or a top level
// resource belonging to a resource provider namespace, or an EventGrid topic. For example, use
// '/subscriptions/{subscriptionId}/' for a subscription,
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for a resource group, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}'
// for a resource, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}'
// for an EventGrid topic. eventSubscriptionName is name of the event subscription
func (client EventSubscriptionsClient) Get(scope string, eventSubscriptionName string) (result EventSubscription, err error) {
	req, err := client.GetPreparer(scope, eventSubscriptionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client EventSubscriptionsClient) GetPreparer(scope string, eventSubscriptionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"eventSubscriptionName": autorest.Encode("path", eventSubscriptionName),
		"scope":                 scope,
	}

	const APIVersion = "2017-06-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client EventSubscriptionsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client EventSubscriptionsClient) GetResponder(resp *http.Response) (result EventSubscription, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetFullURL get the full endpoint URL for an event subscription
//
// scope is the scope of the event subscription. The scope can be a subscription, or a resource group, or a top level
// resource belonging to a resource provider namespace, or an EventGrid topic. For example, use
// '/subscriptions/{subscriptionId}/' for a subscription,
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for a resource group, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}'
// for a resource, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}'
// for an EventGrid topic. eventSubscriptionName is name of the event subscription
func (client EventSubscriptionsClient) GetFullURL(scope string, eventSubscriptionName string) (result EventSubscriptionFullURL, err error) {
	req, err := client.GetFullURLPreparer(scope, eventSubscriptionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "GetFullURL", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetFullURLSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "GetFullURL", resp, "Failure sending request")
		return
	}

	result, err = client.GetFullURLResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "GetFullURL", resp, "Failure responding to request")
	}

	return
}

// GetFullURLPreparer prepares the GetFullURL request.
func (client EventSubscriptionsClient) GetFullURLPreparer(scope string, eventSubscriptionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"eventSubscriptionName": autorest.Encode("path", eventSubscriptionName),
		"scope":                 scope,
	}

	const APIVersion = "2017-06-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}/getFullUrl", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetFullURLSender sends the GetFullURL request. The method will close the
// http.Response Body if it receives an error.
func (client EventSubscriptionsClient) GetFullURLSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetFullURLResponder handles the response to the GetFullURL request. The method always
// closes the http.Response Body.
func (client EventSubscriptionsClient) GetFullURLResponder(resp *http.Response) (result EventSubscriptionFullURL, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResource list all event subscriptions that have been created for a specific topic
//
// resourceGroupName is the name of the resource group within the user's subscription. providerNamespace is namespace
// of the provider of the topic resourceTypeName is name of the resource type resourceName is name of the resource
func (client EventSubscriptionsClient) ListByResource(resourceGroupName string, providerNamespace string, resourceTypeName string, resourceName string) (result EventSubscriptionsListResult, err error) {
	req, err := client.ListByResourcePreparer(resourceGroupName, providerNamespace, resourceTypeName, resourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListByResource", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListByResource", resp, "Failure sending request")
		return
	}

	result, err = client.ListByResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListByResource", resp, "Failure responding to request")
	}

	return
}

// ListByResourcePreparer prepares the ListByResource request.
func (client EventSubscriptionsClient) ListByResourcePreparer(resourceGroupName string, providerNamespace string, resourceTypeName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"providerNamespace": autorest.Encode("path", providerNamespace),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"resourceTypeName":  autorest.Encode("path", resourceTypeName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-06-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{providerNamespace}/{resourceTypeName}/{resourceName}/providers/Microsoft.EventGrid/eventSubscriptions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListByResourceSender sends the ListByResource request. The method will close the
// http.Response Body if it receives an error.
func (client EventSubscriptionsClient) ListByResourceSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListByResourceResponder handles the response to the ListByResource request. The method always
// closes the http.Response Body.
func (client EventSubscriptionsClient) ListByResourceResponder(resp *http.Response) (result EventSubscriptionsListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListGlobalByResourceGroup list all global event subscriptions under a specific Azure subscription and resource group
//
// resourceGroupName is the name of the resource group within the user's subscription.
func (client EventSubscriptionsClient) ListGlobalByResourceGroup(resourceGroupName string) (result EventSubscriptionsListResult, err error) {
	req, err := client.ListGlobalByResourceGroupPreparer(resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListGlobalByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListGlobalByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListGlobalByResourceGroup", resp, "Failure sending request")
		return
	}

	result, err = client.ListGlobalByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListGlobalByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListGlobalByResourceGroupPreparer prepares the ListGlobalByResourceGroup request.
func (client EventSubscriptionsClient) ListGlobalByResourceGroupPreparer(resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-06-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/eventSubscriptions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListGlobalByResourceGroupSender sends the ListGlobalByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client EventSubscriptionsClient) ListGlobalByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListGlobalByResourceGroupResponder handles the response to the ListGlobalByResourceGroup request. The method always
// closes the http.Response Body.
func (client EventSubscriptionsClient) ListGlobalByResourceGroupResponder(resp *http.Response) (result EventSubscriptionsListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListGlobalByResourceGroupForTopicType list all global event subscriptions under a resource group for a specific
// topic type.
//
// resourceGroupName is the name of the resource group within the user's subscription. topicTypeName is name of the
// topic type
func (client EventSubscriptionsClient) ListGlobalByResourceGroupForTopicType(resourceGroupName string, topicTypeName string) (result EventSubscriptionsListResult, err error) {
	req, err := client.ListGlobalByResourceGroupForTopicTypePreparer(resourceGroupName, topicTypeName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListGlobalByResourceGroupForTopicType", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListGlobalByResourceGroupForTopicTypeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListGlobalByResourceGroupForTopicType", resp, "Failure sending request")
		return
	}

	result, err = client.ListGlobalByResourceGroupForTopicTypeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListGlobalByResourceGroupForTopicType", resp, "Failure responding to request")
	}

	return
}

// ListGlobalByResourceGroupForTopicTypePreparer prepares the ListGlobalByResourceGroupForTopicType request.
func (client EventSubscriptionsClient) ListGlobalByResourceGroupForTopicTypePreparer(resourceGroupName string, topicTypeName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"topicTypeName":     autorest.Encode("path", topicTypeName),
	}

	const APIVersion = "2017-06-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topicTypes/{topicTypeName}/eventSubscriptions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListGlobalByResourceGroupForTopicTypeSender sends the ListGlobalByResourceGroupForTopicType request. The method will close the
// http.Response Body if it receives an error.
func (client EventSubscriptionsClient) ListGlobalByResourceGroupForTopicTypeSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListGlobalByResourceGroupForTopicTypeResponder handles the response to the ListGlobalByResourceGroupForTopicType request. The method always
// closes the http.Response Body.
func (client EventSubscriptionsClient) ListGlobalByResourceGroupForTopicTypeResponder(resp *http.Response) (result EventSubscriptionsListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListGlobalBySubscription list all aggregated global event subscriptions under a specific Azure subscription
func (client EventSubscriptionsClient) ListGlobalBySubscription() (result EventSubscriptionsListResult, err error) {
	req, err := client.ListGlobalBySubscriptionPreparer()
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListGlobalBySubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListGlobalBySubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListGlobalBySubscription", resp, "Failure sending request")
		return
	}

	result, err = client.ListGlobalBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListGlobalBySubscription", resp, "Failure responding to request")
	}

	return
}

// ListGlobalBySubscriptionPreparer prepares the ListGlobalBySubscription request.
func (client EventSubscriptionsClient) ListGlobalBySubscriptionPreparer() (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-06-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/eventSubscriptions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListGlobalBySubscriptionSender sends the ListGlobalBySubscription request. The method will close the
// http.Response Body if it receives an error.
func (client EventSubscriptionsClient) ListGlobalBySubscriptionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListGlobalBySubscriptionResponder handles the response to the ListGlobalBySubscription request. The method always
// closes the http.Response Body.
func (client EventSubscriptionsClient) ListGlobalBySubscriptionResponder(resp *http.Response) (result EventSubscriptionsListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListGlobalBySubscriptionForTopicType list all global event subscriptions under an Azure subscription for a topic
// type.
//
// topicTypeName is name of the topic type
func (client EventSubscriptionsClient) ListGlobalBySubscriptionForTopicType(topicTypeName string) (result EventSubscriptionsListResult, err error) {
	req, err := client.ListGlobalBySubscriptionForTopicTypePreparer(topicTypeName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListGlobalBySubscriptionForTopicType", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListGlobalBySubscriptionForTopicTypeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListGlobalBySubscriptionForTopicType", resp, "Failure sending request")
		return
	}

	result, err = client.ListGlobalBySubscriptionForTopicTypeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListGlobalBySubscriptionForTopicType", resp, "Failure responding to request")
	}

	return
}

// ListGlobalBySubscriptionForTopicTypePreparer prepares the ListGlobalBySubscriptionForTopicType request.
func (client EventSubscriptionsClient) ListGlobalBySubscriptionForTopicTypePreparer(topicTypeName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
		"topicTypeName":  autorest.Encode("path", topicTypeName),
	}

	const APIVersion = "2017-06-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/topicTypes/{topicTypeName}/eventSubscriptions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListGlobalBySubscriptionForTopicTypeSender sends the ListGlobalBySubscriptionForTopicType request. The method will close the
// http.Response Body if it receives an error.
func (client EventSubscriptionsClient) ListGlobalBySubscriptionForTopicTypeSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListGlobalBySubscriptionForTopicTypeResponder handles the response to the ListGlobalBySubscriptionForTopicType request. The method always
// closes the http.Response Body.
func (client EventSubscriptionsClient) ListGlobalBySubscriptionForTopicTypeResponder(resp *http.Response) (result EventSubscriptionsListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListRegionalByResourceGroup list all event subscriptions from the given location under a specific Azure subscription
// and resource group
//
// resourceGroupName is the name of the resource group within the user's subscription. location is name of the location
func (client EventSubscriptionsClient) ListRegionalByResourceGroup(resourceGroupName string, location string) (result EventSubscriptionsListResult, err error) {
	req, err := client.ListRegionalByResourceGroupPreparer(resourceGroupName, location)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListRegionalByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRegionalByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListRegionalByResourceGroup", resp, "Failure sending request")
		return
	}

	result, err = client.ListRegionalByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListRegionalByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListRegionalByResourceGroupPreparer prepares the ListRegionalByResourceGroup request.
func (client EventSubscriptionsClient) ListRegionalByResourceGroupPreparer(resourceGroupName string, location string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":          autorest.Encode("path", location),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-06-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/locations/{location}/eventSubscriptions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListRegionalByResourceGroupSender sends the ListRegionalByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client EventSubscriptionsClient) ListRegionalByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListRegionalByResourceGroupResponder handles the response to the ListRegionalByResourceGroup request. The method always
// closes the http.Response Body.
func (client EventSubscriptionsClient) ListRegionalByResourceGroupResponder(resp *http.Response) (result EventSubscriptionsListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListRegionalByResourceGroupForTopicType list all event subscriptions from the given location under a specific Azure
// subscription and resource group and topic type
//
// resourceGroupName is the name of the resource group within the user's subscription. location is name of the location
// topicTypeName is name of the topic type
func (client EventSubscriptionsClient) ListRegionalByResourceGroupForTopicType(resourceGroupName string, location string, topicTypeName string) (result EventSubscriptionsListResult, err error) {
	req, err := client.ListRegionalByResourceGroupForTopicTypePreparer(resourceGroupName, location, topicTypeName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListRegionalByResourceGroupForTopicType", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRegionalByResourceGroupForTopicTypeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListRegionalByResourceGroupForTopicType", resp, "Failure sending request")
		return
	}

	result, err = client.ListRegionalByResourceGroupForTopicTypeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListRegionalByResourceGroupForTopicType", resp, "Failure responding to request")
	}

	return
}

// ListRegionalByResourceGroupForTopicTypePreparer prepares the ListRegionalByResourceGroupForTopicType request.
func (client EventSubscriptionsClient) ListRegionalByResourceGroupForTopicTypePreparer(resourceGroupName string, location string, topicTypeName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":          autorest.Encode("path", location),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"topicTypeName":     autorest.Encode("path", topicTypeName),
	}

	const APIVersion = "2017-06-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/locations/{location}/topicTypes/{topicTypeName}/eventSubscriptions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListRegionalByResourceGroupForTopicTypeSender sends the ListRegionalByResourceGroupForTopicType request. The method will close the
// http.Response Body if it receives an error.
func (client EventSubscriptionsClient) ListRegionalByResourceGroupForTopicTypeSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListRegionalByResourceGroupForTopicTypeResponder handles the response to the ListRegionalByResourceGroupForTopicType request. The method always
// closes the http.Response Body.
func (client EventSubscriptionsClient) ListRegionalByResourceGroupForTopicTypeResponder(resp *http.Response) (result EventSubscriptionsListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListRegionalBySubscription list all event subscriptions from the given location under a specific Azure subscription
//
// location is name of the location
func (client EventSubscriptionsClient) ListRegionalBySubscription(location string) (result EventSubscriptionsListResult, err error) {
	req, err := client.ListRegionalBySubscriptionPreparer(location)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListRegionalBySubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRegionalBySubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListRegionalBySubscription", resp, "Failure sending request")
		return
	}

	result, err = client.ListRegionalBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListRegionalBySubscription", resp, "Failure responding to request")
	}

	return
}

// ListRegionalBySubscriptionPreparer prepares the ListRegionalBySubscription request.
func (client EventSubscriptionsClient) ListRegionalBySubscriptionPreparer(location string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-06-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/locations/{location}/eventSubscriptions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListRegionalBySubscriptionSender sends the ListRegionalBySubscription request. The method will close the
// http.Response Body if it receives an error.
func (client EventSubscriptionsClient) ListRegionalBySubscriptionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListRegionalBySubscriptionResponder handles the response to the ListRegionalBySubscription request. The method always
// closes the http.Response Body.
func (client EventSubscriptionsClient) ListRegionalBySubscriptionResponder(resp *http.Response) (result EventSubscriptionsListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListRegionalBySubscriptionForTopicType list all event subscriptions from the given location under a specific Azure
// subscription and topic type.
//
// location is name of the location topicTypeName is name of the topic type
func (client EventSubscriptionsClient) ListRegionalBySubscriptionForTopicType(location string, topicTypeName string) (result EventSubscriptionsListResult, err error) {
	req, err := client.ListRegionalBySubscriptionForTopicTypePreparer(location, topicTypeName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListRegionalBySubscriptionForTopicType", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRegionalBySubscriptionForTopicTypeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListRegionalBySubscriptionForTopicType", resp, "Failure sending request")
		return
	}

	result, err = client.ListRegionalBySubscriptionForTopicTypeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "ListRegionalBySubscriptionForTopicType", resp, "Failure responding to request")
	}

	return
}

// ListRegionalBySubscriptionForTopicTypePreparer prepares the ListRegionalBySubscriptionForTopicType request.
func (client EventSubscriptionsClient) ListRegionalBySubscriptionForTopicTypePreparer(location string, topicTypeName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
		"topicTypeName":  autorest.Encode("path", topicTypeName),
	}

	const APIVersion = "2017-06-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/locations/{location}/topicTypes/{topicTypeName}/eventSubscriptions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListRegionalBySubscriptionForTopicTypeSender sends the ListRegionalBySubscriptionForTopicType request. The method will close the
// http.Response Body if it receives an error.
func (client EventSubscriptionsClient) ListRegionalBySubscriptionForTopicTypeSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListRegionalBySubscriptionForTopicTypeResponder handles the response to the ListRegionalBySubscriptionForTopicType request. The method always
// closes the http.Response Body.
func (client EventSubscriptionsClient) ListRegionalBySubscriptionForTopicTypeResponder(resp *http.Response) (result EventSubscriptionsListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Update asynchronously updates an existing event subscription. This method may poll for completion. Polling can be
// canceled by passing the cancel channel argument. The channel will be used to cancel polling and any outstanding HTTP
// requests.
//
// scope is the scope of existing event subscription. The scope can be a subscription, or a resource group, or a top
// level resource belonging to a resource provider namespace, or an EventGrid topic. For example, use
// '/subscriptions/{subscriptionId}/' for a subscription,
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for a resource group, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}'
// for a resource, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}'
// for an EventGrid topic. eventSubscriptionName is name of the event subscription to be created
// eventSubscriptionUpdateParameters is updated event subscription information
func (client EventSubscriptionsClient) Update(scope string, eventSubscriptionName string, eventSubscriptionUpdateParameters EventSubscriptionUpdateParameters, cancel <-chan struct{}) (<-chan EventSubscription, <-chan error) {
	resultChan := make(chan EventSubscription, 1)
	errChan := make(chan error, 1)
	go func() {
		var err error
		var result EventSubscription
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.UpdatePreparer(scope, eventSubscriptionName, eventSubscriptionUpdateParameters, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "Update", nil, "Failure preparing request")
			return
		}

		resp, err := client.UpdateSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "Update", resp, "Failure sending request")
			return
		}

		result, err = client.UpdateResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsClient", "Update", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// UpdatePreparer prepares the Update request.
func (client EventSubscriptionsClient) UpdatePreparer(scope string, eventSubscriptionName string, eventSubscriptionUpdateParameters EventSubscriptionUpdateParameters, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"eventSubscriptionName": autorest.Encode("path", eventSubscriptionName),
		"scope":                 scope,
	}

	const APIVersion = "2017-06-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}", pathParameters),
		autorest.WithJSON(eventSubscriptionUpdateParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client EventSubscriptionsClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client EventSubscriptionsClient) UpdateResponder(resp *http.Response) (result EventSubscription, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
