package iothub

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AccessRights enumerates the values for access rights.
type AccessRights string

const (
	// DeviceConnect specifies the device connect state for access rights.
	DeviceConnect AccessRights = "DeviceConnect"
	// RegistryRead specifies the registry read state for access rights.
	RegistryRead AccessRights = "RegistryRead"
	// RegistryReadDeviceConnect specifies the registry read device connect
	// state for access rights.
	RegistryReadDeviceConnect AccessRights = "RegistryRead, DeviceConnect"
	// RegistryReadRegistryWrite specifies the registry read registry write
	// state for access rights.
	RegistryReadRegistryWrite AccessRights = "RegistryRead, RegistryWrite"
	// RegistryReadRegistryWriteDeviceConnect specifies the registry read
	// registry write device connect state for access rights.
	RegistryReadRegistryWriteDeviceConnect AccessRights = "RegistryRead, RegistryWrite, DeviceConnect"
	// RegistryReadRegistryWriteServiceConnect specifies the registry read
	// registry write service connect state for access rights.
	RegistryReadRegistryWriteServiceConnect AccessRights = "RegistryRead, RegistryWrite, ServiceConnect"
	// RegistryReadRegistryWriteServiceConnectDeviceConnect specifies the
	// registry read registry write service connect device connect state for
	// access rights.
	RegistryReadRegistryWriteServiceConnectDeviceConnect AccessRights = "RegistryRead, RegistryWrite, ServiceConnect, DeviceConnect"
	// RegistryReadServiceConnect specifies the registry read service connect
	// state for access rights.
	RegistryReadServiceConnect AccessRights = "RegistryRead, ServiceConnect"
	// RegistryReadServiceConnectDeviceConnect specifies the registry read
	// service connect device connect state for access rights.
	RegistryReadServiceConnectDeviceConnect AccessRights = "RegistryRead, ServiceConnect, DeviceConnect"
	// RegistryWrite specifies the registry write state for access rights.
	RegistryWrite AccessRights = "RegistryWrite"
	// RegistryWriteDeviceConnect specifies the registry write device connect
	// state for access rights.
	RegistryWriteDeviceConnect AccessRights = "RegistryWrite, DeviceConnect"
	// RegistryWriteServiceConnect specifies the registry write service
	// connect state for access rights.
	RegistryWriteServiceConnect AccessRights = "RegistryWrite, ServiceConnect"
	// RegistryWriteServiceConnectDeviceConnect specifies the registry write
	// service connect device connect state for access rights.
	RegistryWriteServiceConnectDeviceConnect AccessRights = "RegistryWrite, ServiceConnect, DeviceConnect"
	// ServiceConnect specifies the service connect state for access rights.
	ServiceConnect AccessRights = "ServiceConnect"
	// ServiceConnectDeviceConnect specifies the service connect device
	// connect state for access rights.
	ServiceConnectDeviceConnect AccessRights = "ServiceConnect, DeviceConnect"
)

// Capabilities enumerates the values for capabilities.
type Capabilities string

const (
	// DeviceManagement specifies the device management state for capabilities.
	DeviceManagement Capabilities = "DeviceManagement"
	// None specifies the none state for capabilities.
	None Capabilities = "None"
)

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// Cancelled specifies the cancelled state for job status.
	Cancelled JobStatus = "cancelled"
	// Completed specifies the completed state for job status.
	Completed JobStatus = "completed"
	// Enqueued specifies the enqueued state for job status.
	Enqueued JobStatus = "enqueued"
	// Failed specifies the failed state for job status.
	Failed JobStatus = "failed"
	// Running specifies the running state for job status.
	Running JobStatus = "running"
	// Unknown specifies the unknown state for job status.
	Unknown JobStatus = "unknown"
)

// JobType enumerates the values for job type.
type JobType string

const (
	// JobTypeBackup specifies the job type backup state for job type.
	JobTypeBackup JobType = "backup"
	// JobTypeExport specifies the job type export state for job type.
	JobTypeExport JobType = "export"
	// JobTypeFactoryResetDevice specifies the job type factory reset device
	// state for job type.
	JobTypeFactoryResetDevice JobType = "factoryResetDevice"
	// JobTypeFirmwareUpdate specifies the job type firmware update state for
	// job type.
	JobTypeFirmwareUpdate JobType = "firmwareUpdate"
	// JobTypeImport specifies the job type import state for job type.
	JobTypeImport JobType = "import"
	// JobTypeReadDeviceProperties specifies the job type read device
	// properties state for job type.
	JobTypeReadDeviceProperties JobType = "readDeviceProperties"
	// JobTypeRebootDevice specifies the job type reboot device state for job
	// type.
	JobTypeRebootDevice JobType = "rebootDevice"
	// JobTypeUnknown specifies the job type unknown state for job type.
	JobTypeUnknown JobType = "unknown"
	// JobTypeUpdateDeviceConfiguration specifies the job type update device
	// configuration state for job type.
	JobTypeUpdateDeviceConfiguration JobType = "updateDeviceConfiguration"
	// JobTypeWriteDeviceProperties specifies the job type write device
	// properties state for job type.
	JobTypeWriteDeviceProperties JobType = "writeDeviceProperties"
)

// NameUnavailabilityReason enumerates the values for name unavailability
// reason.
type NameUnavailabilityReason string

const (
	// AlreadyExists specifies the already exists state for name
	// unavailability reason.
	AlreadyExists NameUnavailabilityReason = "AlreadyExists"
	// Invalid specifies the invalid state for name unavailability reason.
	Invalid NameUnavailabilityReason = "Invalid"
)

// OperationMonitoringLevel enumerates the values for operation monitoring
// level.
type OperationMonitoringLevel string

const (
	// OperationMonitoringLevelError specifies the operation monitoring level
	// error state for operation monitoring level.
	OperationMonitoringLevelError OperationMonitoringLevel = "Error"
	// OperationMonitoringLevelInformation specifies the operation monitoring
	// level information state for operation monitoring level.
	OperationMonitoringLevelInformation OperationMonitoringLevel = "Information"
	// OperationMonitoringLevelNone specifies the operation monitoring level
	// none state for operation monitoring level.
	OperationMonitoringLevelNone OperationMonitoringLevel = "None"
)

// SBAccessRights enumerates the values for sb access rights.
type SBAccessRights string

const (
	// Listen specifies the listen state for sb access rights.
	Listen SBAccessRights = "Listen"
	// Manage specifies the manage state for sb access rights.
	Manage SBAccessRights = "Manage"
	// ManageNotificationHub specifies the manage notification hub state for
	// sb access rights.
	ManageNotificationHub SBAccessRights = "ManageNotificationHub"
	// Send specifies the send state for sb access rights.
	Send SBAccessRights = "Send"
)

// ScaleType enumerates the values for scale type.
type ScaleType string

const (
	// ScaleTypeAutomatic specifies the scale type automatic state for scale
	// type.
	ScaleTypeAutomatic ScaleType = "Automatic"
	// ScaleTypeManual specifies the scale type manual state for scale type.
	ScaleTypeManual ScaleType = "Manual"
	// ScaleTypeNone specifies the scale type none state for scale type.
	ScaleTypeNone ScaleType = "None"
)

// Sku enumerates the values for sku.
type Sku string

const (
	// F1 specifies the f1 state for sku.
	F1 Sku = "F1"
	// S1 specifies the s1 state for sku.
	S1 Sku = "S1"
	// S2 specifies the s2 state for sku.
	S2 Sku = "S2"
	// S3 specifies the s3 state for sku.
	S3 Sku = "S3"
)

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// Free specifies the free state for sku tier.
	Free SkuTier = "Free"
	// Standard specifies the standard state for sku tier.
	Standard SkuTier = "Standard"
)

// Capacity is the properties related to the capacity information.
type Capacity struct {
	Minimum   *int64    `json:"minimum,omitempty"`
	Maximum   *int64    `json:"maximum,omitempty"`
	Default   *int64    `json:"default,omitempty"`
	ScaleType ScaleType `json:"scaleType,omitempty"`
}

// CloudToDeviceProperties is the Iot Hub Cloud-To-Device messaging properties.
type CloudToDeviceProperties struct {
	MaxDeliveryCount    *int32              `json:"maxDeliveryCount,omitempty"`
	DefaultTTLAsIso8601 *string             `json:"defaultTtlAsIso8601,omitempty"`
	Feedback            *FeedbackProperties `json:"feedback,omitempty"`
}

// Description is the description of the IotHub.
type Description struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Subscriptionid    *string             `json:"subscriptionid,omitempty"`
	Resourcegroup     *string             `json:"resourcegroup,omitempty"`
	Etag              *string             `json:"etag,omitempty"`
	Properties        *Properties         `json:"properties,omitempty"`
	Sku               *SkuInfo            `json:"sku,omitempty"`
}

// DescriptionListResult is the list of IotHubDescription objects with a next
// link.
type DescriptionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Description `json:"value,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// DescriptionListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client DescriptionListResult) DescriptionListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ErrorDetails is the properties related to the details of an error.
type ErrorDetails struct {
	Code           *string `json:"Code,omitempty"`
	HTTPStatusCode *string `json:"HttpStatusCode,omitempty"`
	Message        *string `json:"Message,omitempty"`
	Details        *string `json:"Details,omitempty"`
}

// EventHubConsumerGroupInfo is the properties indicating the
// EventHubConsumerGroupInfo.
type EventHubConsumerGroupInfo struct {
	autorest.Response `json:"-"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
}

// EventHubConsumerGroupsListResult is the list of eventhub consumer group
// names with a next link.
type EventHubConsumerGroupsListResult struct {
	autorest.Response `json:"-"`
	Value             *[]string `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// EventHubConsumerGroupsListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client EventHubConsumerGroupsListResult) EventHubConsumerGroupsListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// EventHubProperties is the properties of the provisioned event hub used by
// the Iot Hub.
type EventHubProperties struct {
	RetentionTimeInDays           *int64                           `json:"retentionTimeInDays,omitempty"`
	PartitionCount                *int32                           `json:"partitionCount,omitempty"`
	PartitionIds                  *[]string                        `json:"partitionIds,omitempty"`
	Path                          *string                          `json:"path,omitempty"`
	Endpoint                      *string                          `json:"endpoint,omitempty"`
	InternalAuthorizationPolicies *[]SharedAccessAuthorizationRule `json:"internalAuthorizationPolicies,omitempty"`
	AuthorizationPolicies         *[]SharedAccessAuthorizationRule `json:"authorizationPolicies,omitempty"`
}

// ExportDevicesRequest is used to provide parameters when requesting an
// export of all devices in the hub.
type ExportDevicesRequest struct {
	ExportBlobContainerURI *string `json:"ExportBlobContainerUri,omitempty"`
	ExcludeKeys            *bool   `json:"ExcludeKeys,omitempty"`
}

// FeedbackProperties is the Feedback Queue properties.
type FeedbackProperties struct {
	LockDurationAsIso8601 *string `json:"lockDurationAsIso8601,omitempty"`
	TTLAsIso8601          *string `json:"ttlAsIso8601,omitempty"`
	MaxDeliveryCount      *int32  `json:"maxDeliveryCount,omitempty"`
}

// ImportDevicesRequest is used to provide parameters when requesting an
// import of all devices in the hub.
type ImportDevicesRequest struct {
	InputBlobContainerURI  *string `json:"InputBlobContainerUri,omitempty"`
	OutputBlobContainerURI *string `json:"OutputBlobContainerUri,omitempty"`
}

// JobResponse is the properties describing a Job Response.
type JobResponse struct {
	autorest.Response `json:"-"`
	JobID             *string    `json:"jobId,omitempty"`
	StartTimeUtc      *date.Time `json:"startTimeUtc,omitempty"`
	EndTimeUtc        *date.Time `json:"endTimeUtc,omitempty"`
	Type              JobType    `json:"type,omitempty"`
	Status            JobStatus  `json:"status,omitempty"`
	FailureReason     *string    `json:"failureReason,omitempty"`
	StatusMessage     *string    `json:"statusMessage,omitempty"`
	DeviceID          *string    `json:"deviceId,omitempty"`
	ParentJobID       *string    `json:"parentJobId,omitempty"`
}

// JobResponseListResult is the list of JobResponse objects with a next link.
type JobResponseListResult struct {
	autorest.Response `json:"-"`
	Value             *[]JobResponse `json:"value,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// JobResponseListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client JobResponseListResult) JobResponseListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// MessagingEndpointProperties is the properties of the Messaging Endpoints
// used by this IoT Hub.
type MessagingEndpointProperties struct {
	LockDurationAsIso8601 *string `json:"lockDurationAsIso8601,omitempty"`
	TTLAsIso8601          *string `json:"ttlAsIso8601,omitempty"`
	MaxDeliveryCount      *int32  `json:"maxDeliveryCount,omitempty"`
}

// NameAvailabilityInfo is the properties indicating whether a given iothub
// name is available.
type NameAvailabilityInfo struct {
	autorest.Response `json:"-"`
	NameAvailable     *bool                    `json:"nameAvailable,omitempty"`
	Reason            NameUnavailabilityReason `json:"reason,omitempty"`
	Message           *string                  `json:"message,omitempty"`
}

// OperationInputs is operationInputs.
type OperationInputs struct {
	Name *string `json:"Name,omitempty"`
}

// OperationsMonitoringProperties is the Operation Monitoring properties.
type OperationsMonitoringProperties struct {
	Events *map[string]*OperationMonitoringLevel `json:"events,omitempty"`
}

// Properties is the Iot Hub properties.
type Properties struct {
	AuthorizationPolicies          *[]SharedAccessSignatureAuthorizationRule `json:"authorizationPolicies,omitempty"`
	HostName                       *string                                   `json:"hostName,omitempty"`
	EventHubEndpoints              *map[string]*EventHubProperties           `json:"eventHubEndpoints,omitempty"`
	StorageEndpoints               *map[string]*StorageEndpointProperties    `json:"storageEndpoints,omitempty"`
	MessagingEndpoints             *map[string]*MessagingEndpointProperties  `json:"messagingEndpoints,omitempty"`
	EnableFileUploadNotifications  *bool                                     `json:"enableFileUploadNotifications,omitempty"`
	CloudToDevice                  *CloudToDeviceProperties                  `json:"cloudToDevice,omitempty"`
	Comments                       *string                                   `json:"comments,omitempty"`
	OperationsMonitoringProperties *OperationsMonitoringProperties           `json:"operationsMonitoringProperties,omitempty"`
	Features                       Capabilities                              `json:"features,omitempty"`
}

// QuotaMetricInfo is the properties related to quota metrics.
type QuotaMetricInfo struct {
	Name         *string `json:"Name,omitempty"`
	CurrentValue *int64  `json:"CurrentValue,omitempty"`
	MaxValue     *int64  `json:"MaxValue,omitempty"`
}

// QuotaMetricInfoListResult is the list of IotHubQuotaMetricInfo objects with
// a next link.
type QuotaMetricInfoListResult struct {
	autorest.Response `json:"-"`
	Value             *[]QuotaMetricInfo `json:"value,omitempty"`
	NextLink          *string            `json:"nextLink,omitempty"`
}

// QuotaMetricInfoListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client QuotaMetricInfoListResult) QuotaMetricInfoListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RegistryStatistics is the properties related to the registry statistics.
type RegistryStatistics struct {
	autorest.Response   `json:"-"`
	TotalDeviceCount    *int64 `json:"totalDeviceCount,omitempty"`
	EnabledDeviceCount  *int64 `json:"enabledDeviceCount,omitempty"`
	DisabledDeviceCount *int64 `json:"disabledDeviceCount,omitempty"`
}

// Resource is
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// SharedAccessAuthorizationRule is
type SharedAccessAuthorizationRule struct {
	KeyName      *string           `json:"KeyName,omitempty"`
	PrimaryKey   *string           `json:"PrimaryKey,omitempty"`
	IssuerName   *string           `json:"IssuerName,omitempty"`
	SecondaryKey *string           `json:"SecondaryKey,omitempty"`
	ClaimType    *string           `json:"ClaimType,omitempty"`
	ClaimValue   *string           `json:"ClaimValue,omitempty"`
	Rights       *[]SBAccessRights `json:"Rights,omitempty"`
	CreatedTime  *date.Time        `json:"CreatedTime,omitempty"`
	ModifiedTime *date.Time        `json:"ModifiedTime,omitempty"`
	Revision     *int64            `json:"Revision,omitempty"`
}

// SharedAccessSignatureAuthorizationRule is the properties that describe the
// keys to access the IotHub artifacts.
type SharedAccessSignatureAuthorizationRule struct {
	autorest.Response `json:"-"`
	KeyName           *string      `json:"keyName,omitempty"`
	PrimaryKey        *string      `json:"primaryKey,omitempty"`
	SecondaryKey      *string      `json:"secondaryKey,omitempty"`
	Rights            AccessRights `json:"rights,omitempty"`
}

// SharedAccessSignatureAuthorizationRuleListResult is the list of
// authorization rules with a next link.
type SharedAccessSignatureAuthorizationRuleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SharedAccessSignatureAuthorizationRule `json:"value,omitempty"`
	NextLink          *string                                   `json:"nextLink,omitempty"`
}

// SharedAccessSignatureAuthorizationRuleListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SharedAccessSignatureAuthorizationRuleListResult) SharedAccessSignatureAuthorizationRuleListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SkuDescription is the properties related to the Sku.
type SkuDescription struct {
	ResourceType *string   `json:"resourceType,omitempty"`
	Sku          *SkuInfo  `json:"sku,omitempty"`
	Capacity     *Capacity `json:"capacity,omitempty"`
}

// SkuDescriptionListResult is the list of IotHubSkuDescription objects with a
// next link.
type SkuDescriptionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SkuDescription `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// SkuDescriptionListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SkuDescriptionListResult) SkuDescriptionListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SkuInfo is the Sku related information for the hub.
type SkuInfo struct {
	Name     Sku     `json:"name,omitempty"`
	Tier     SkuTier `json:"tier,omitempty"`
	Capacity *int64  `json:"capacity,omitempty"`
}

// StorageEndpointProperties is the properties of the Storage Endpoint for
// file upload.
type StorageEndpointProperties struct {
	SasTTLAsIso8601  *string `json:"sasTtlAsIso8601,omitempty"`
	ConnectionString *string `json:"connectionString,omitempty"`
	ContainerName    *string `json:"containerName,omitempty"`
}
