; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown -mattr=+sse2 | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+avx | FileCheck %s --check-prefix=X64

; These tests just check that the plumbing is in place for @llvm.bswap. The
; actual output is massive at the moment as llvm.bswap is not yet legal.

declare i32 @llvm.bswap.i32(i32) readnone
declare i32 @llvm.bswap.v4i32(i32) readnone

; fold (bswap undef) -> undef
define i32 @test_undef() nounwind {
; X86-LABEL: test_undef:
; X86:       # %bb.0:
; X86-NEXT:    retl
;
; X64-LABEL: test_undef:
; X64:       # %bb.0:
; X64-NEXT:    retq
  %b = call i32 @llvm.bswap.i32(i32 undef)
  ret i32 %b
}

; fold (bswap (bswap x)) -> x
define i32 @test_bswap_bswap(i32 %a0) nounwind {
; X86-LABEL: test_bswap_bswap:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_bswap_bswap:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    retq
  %b = call i32 @llvm.bswap.i32(i32 %a0)
  %c = call i32 @llvm.bswap.i32(i32 %b)
  ret i32 %c
}

define i32 @test_demandedbits_bswap(i32 %a0) nounwind {
; X86-LABEL: test_demandedbits_bswap:
; X86:       # %bb.0:
; X86-NEXT:    movl $-16777216, %eax # imm = 0xFF000000
; X86-NEXT:    orl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    bswapl %eax
; X86-NEXT:    andl $-65536, %eax # imm = 0xFFFF0000
; X86-NEXT:    retl
;
; X64-LABEL: test_demandedbits_bswap:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    orl $-16777216, %eax # imm = 0xFF000000
; X64-NEXT:    bswapl %eax
; X64-NEXT:    andl $-65536, %eax # imm = 0xFFFF0000
; X64-NEXT:    retq
  %b = or i32 %a0, 4278190080
  %c = call i32 @llvm.bswap.i32(i32 %b)
  %d = and i32 %c, 4294901760
  ret i32 %d
}
