// This file was generated by go generate; DO NOT EDIT

package language

import "golang.org/x/text/internal/tag"

// CLDRVersion is the CLDR version from which the tables in this package are derived.
const CLDRVersion = "28"

const numLanguages = 8632

const numScripts = 223

const numRegions = 354

type fromTo struct {
	from uint16
	to   uint16
}

const nonCanonicalUnd = 646
const (
	_af  = 10
	_am  = 17
	_ar  = 21
	_az  = 36
	_bg  = 56
	_bn  = 75
	_ca  = 97
	_cs  = 121
	_da  = 128
	_de  = 133
	_el  = 153
	_en  = 154
	_es  = 156
	_et  = 158
	_fa  = 163
	_fi  = 167
	_fil = 169
	_fr  = 174
	_gu  = 210
	_he  = 223
	_hi  = 224
	_hr  = 237
	_hu  = 241
	_hy  = 242
	_id  = 247
	_is  = 257
	_it  = 258
	_ja  = 262
	_ka  = 272
	_kk  = 302
	_km  = 306
	_kn  = 308
	_ko  = 309
	_ky  = 332
	_lo  = 356
	_lt  = 360
	_lv  = 367
	_mk  = 395
	_ml  = 396
	_mn  = 398
	_mo  = 401
	_mr  = 405
	_ms  = 409
	_mul = 413
	_my  = 420
	_nb  = 430
	_ne  = 435
	_nl  = 444
	_no  = 448
	_pa  = 469
	_pl  = 485
	_pt  = 493
	_ro  = 513
	_ru  = 517
	_sh  = 547
	_si  = 550
	_sk  = 552
	_sl  = 554
	_sq  = 568
	_sr  = 569
	_sv  = 581
	_sw  = 582
	_ta  = 591
	_te  = 598
	_th  = 603
	_tl  = 614
	_tn  = 617
	_tr  = 621
	_uk  = 643
	_ur  = 649
	_uz  = 650
	_vi  = 655
	_zh  = 704
	_zu  = 706
	_jbo = 264
	_ami = 1029
	_bnn = 1736
	_hak = 220
	_tlh = 13846
	_lb  = 339
	_nv  = 457
	_pwn = 11434
	_tao = 13567
	_tay = 13577
	_tsu = 14041
	_nn  = 446
	_sfb = 13008
	_vgt = 15080
	_sgg = 13039
	_cmn = 2386
	_nan = 427
	_hsn = 239
)

const langPrivateStart = 0x2d05

const langPrivateEnd = 0x2f0c

// lang holds an alphabetically sorted list of ISO-639 language identifiers.
// All entries are 4 bytes. The index of the identifier (divided by 4) is the language tag.
// For 2-byte language identifiers, the two successive bytes have the following meaning:
//     - if the first letter of the 2- and 3-letter ISO codes are the same:
//       the second and third letter of the 3-letter ISO code.
//     - otherwise: a 0 and a by 2 bits right-shifted index into altLangISO3.
// For 3-byte language identifiers the 4th byte is 0.
var lang tag.Index = "" + // Size: 2840 bytes
	"---\x00aaarabbkabr\x00ace\x00ach\x00ada\x00ady\x00aeveaeb\x00affragq\x00" +
	"aho\x00akkaakk\x00aln\x00alt\x00ammhamo\x00anrgaoz\x00arraarc\x00arn\x00" +
	"aro\x00arq\x00ary\x00arz\x00assmasa\x00ase\x00ast\x00atj\x00avvaawa\x00a" +
	"yymazzebaakbal\x00ban\x00bap\x00bar\x00bas\x00bax\x00bbc\x00bbj\x00bci" +
	"\x00beelbej\x00bem\x00bew\x00bez\x00bfd\x00bfq\x00bft\x00bfy\x00bgulbgc" +
	"\x00bgn\x00bgx\x00bhihbhb\x00bhi\x00bhk\x00bho\x00biisbik\x00bin\x00bjj" +
	"\x00bjn\x00bkm\x00bku\x00blt\x00bmambmq\x00bnenboodbpy\x00bqi\x00bqv\x00" +
	"brrebra\x00brh\x00brx\x00bsosbsq\x00bss\x00bto\x00btv\x00bua\x00buc\x00b" +
	"ug\x00bum\x00bvb\x00byn\x00byv\x00bze\x00caatcch\x00ccp\x00ceheceb\x00cg" +
	"g\x00chhachk\x00chm\x00cho\x00chp\x00chr\x00cja\x00cjm\x00ckb\x00cooscop" +
	"\x00cps\x00crrecrj\x00crk\x00crl\x00crm\x00crs\x00csescsb\x00csw\x00ctd" +
	"\x00cuhucvhvcyymdaandak\x00dar\x00dav\x00dcc\x00deeuden\x00dgr\x00dje" +
	"\x00dnj\x00doi\x00dsb\x00dtm\x00dtp\x00dua\x00dvivdyo\x00dyu\x00dzzoebu" +
	"\x00eeweefi\x00egl\x00egy\x00eky\x00elllenngeopoes\x00\x05esu\x00etstett" +
	"\x00euusewo\x00ext\x00faasfan\x00ffulffm\x00fiinfia\x00fil\x00fit\x00fji" +
	"jfoaofon\x00frrafrc\x00frp\x00frr\x00frs\x00fud\x00fuq\x00fur\x00fuv\x00" +
	"fvr\x00fyrygalegaa\x00gag\x00gan\x00gay\x00gbm\x00gbz\x00gcr\x00gdlagez" +
	"\x00ggn\x00gil\x00gjk\x00gju\x00gllgglk\x00gnrngom\x00gon\x00gor\x00gos" +
	"\x00got\x00grc\x00grt\x00gsw\x00guujgub\x00guc\x00gur\x00guw\x00guz\x00g" +
	"vlvgvr\x00gwi\x00haauhak\x00haw\x00haz\x00heebhiinhif\x00hil\x00hlu\x00h" +
	"md\x00hnd\x00hne\x00hnj\x00hnn\x00hno\x00homohoc\x00hoj\x00hrrvhsb\x00hs" +
	"n\x00htathuunhyyehzerianaiba\x00ibb\x00idndieleigboiiiiikpkikt\x00ilo" +
	"\x00inndinh\x00iodoisslittaiukuiw\x00\x03izh\x00japnjam\x00jbo\x00jgo" +
	"\x00ji\x00\x06jmc\x00jml\x00jut\x00jvavjwavkaatkaa\x00kab\x00kac\x00kaj" +
	"\x00kam\x00kao\x00kbd\x00kcg\x00kck\x00kde\x00kdt\x00kea\x00ken\x00kfo" +
	"\x00kfr\x00kfy\x00kgonkge\x00kgp\x00kha\x00khb\x00khn\x00khq\x00kht\x00k" +
	"hw\x00kiikkiu\x00kjuakjg\x00kkazkkj\x00klalkln\x00kmhmkmb\x00knankoorkoi" +
	"\x00kok\x00kos\x00kpe\x00kraukrc\x00kri\x00krj\x00krl\x00kru\x00ksasksb" +
	"\x00ksf\x00ksh\x00kuurkum\x00kvomkvr\x00kvx\x00kw\x00\x01kxm\x00kxp\x00k" +
	"yirlaatlab\x00lad\x00lag\x00lah\x00laj\x00lbtzlbe\x00lbw\x00lcp\x00lep" +
	"\x00lez\x00lgugliimlif\x00lij\x00lis\x00ljp\x00lki\x00lkt\x00lmn\x00lmo" +
	"\x00lninloaolol\x00loz\x00lrc\x00ltitltg\x00luublua\x00luo\x00luy\x00luz" +
	"\x00lvavlwl\x00lzh\x00lzz\x00mad\x00maf\x00mag\x00mai\x00mak\x00man\x00m" +
	"as\x00maz\x00mdf\x00mdh\x00mdr\x00men\x00mer\x00mfa\x00mfe\x00mglgmgh" +
	"\x00mgo\x00mgp\x00mgy\x00mhahmirimin\x00mis\x00mkkdmlalmls\x00mnonmni" +
	"\x00mnw\x00moolmoe\x00moh\x00mos\x00mrarmrd\x00mrj\x00mru\x00mssamtltmtr" +
	"\x00mua\x00mul\x00mus\x00mvy\x00mwk\x00mwr\x00mwv\x00mxc\x00myyamyv\x00m" +
	"yx\x00myz\x00mzn\x00naaunah\x00nan\x00nap\x00naq\x00nbobnch\x00nddendc" +
	"\x00nds\x00neepnew\x00ngdongl\x00nhe\x00nhw\x00nij\x00niu\x00njo\x00nlld" +
	"nmg\x00nnnonnh\x00noornod\x00noe\x00non\x00nqo\x00nrblnsk\x00nso\x00nus" +
	"\x00nvavnxq\x00nyyanym\x00nyn\x00nzi\x00occiojjiomrmorriosssotk\x00paanp" +
	"ag\x00pal\x00pam\x00pap\x00pau\x00pcd\x00pcm\x00pdc\x00pdt\x00peo\x00pfl" +
	"\x00phn\x00pilipka\x00pko\x00plolpms\x00pnt\x00pon\x00pra\x00prd\x00prg" +
	"\x00psusptorpuu\x00quuequc\x00qug\x00raj\x00rcf\x00rej\x00rgn\x00ria\x00" +
	"rif\x00rjs\x00rkt\x00rmohrmf\x00rmo\x00rmt\x00rmu\x00rnunrng\x00roonrob" +
	"\x00rof\x00rtm\x00ruusrue\x00rug\x00rw\x00\x04rwk\x00ryu\x00saansaf\x00s" +
	"ah\x00saq\x00sas\x00sat\x00saz\x00sbp\x00scrdsck\x00scn\x00sco\x00scs" +
	"\x00sdndsdc\x00sdh\x00semesef\x00seh\x00sei\x00ses\x00sgagsga\x00sgs\x00" +
	"sh\x00\x02shi\x00shn\x00siinsid\x00sklkskr\x00sllvsli\x00sly\x00smmosma" +
	"\x00smi\x00smj\x00smn\x00smp\x00sms\x00snnasnk\x00soomsou\x00sqqisrrpsrb" +
	"\x00srn\x00srr\x00srx\x00ssswssy\x00stotstq\x00suunsuk\x00sus\x00svwesww" +
	"aswb\x00swc\x00swg\x00swv\x00sxn\x00syl\x00syr\x00szl\x00taamtaj\x00tbw" +
	"\x00tcy\x00tdd\x00tdg\x00tdh\x00teeltem\x00teo\x00tet\x00tggkthhathl\x00" +
	"thq\x00thr\x00tiirtig\x00tiv\x00tkuktkl\x00tkr\x00tkt\x00tlgltly\x00tmh" +
	"\x00tnsntoontog\x00tpi\x00trurtru\x00trv\x00tssotsd\x00tsf\x00tsg\x00tsj" +
	"\x00ttatttj\x00tts\x00ttt\x00tum\x00tvl\x00twwitwq\x00tyahtyv\x00tzm\x00" +
	"udm\x00ugiguga\x00ukkruli\x00umb\x00und\x00unr\x00unx\x00urrduzzbvai\x00" +
	"veenvec\x00vep\x00viievic\x00vls\x00vmf\x00vmw\x00voolvot\x00vro\x00vun" +
	"\x00walnwae\x00wal\x00war\x00wbp\x00wbq\x00wbr\x00wls\x00wni\x00woolwtm" +
	"\x00wuu\x00xav\x00xcr\x00xhhoxlc\x00xld\x00xmf\x00xmn\x00xmr\x00xna\x00x" +
	"nr\x00xog\x00xpr\x00xsa\x00xsr\x00yao\x00yap\x00yav\x00ybb\x00yiidyooryr" +
	"l\x00yua\x00zahazag\x00zbl\x00zdj\x00zea\x00zgh\x00zhhozmi\x00zuulzxx" +
	"\x00zza\x00\xff\xff\xff\xff"

const langNoIndexOffset = 709

// langNoIndex is a bit vector of all 3-letter language codes that are not used as an index
// in lookup tables. The language ids for these language codes are derived directly
// from the letters and are not consecutive.
// Size: 2197 bytes, 2197 elements
var langNoIndex = [2197]uint8{
	// Entry 0 - 3F
	0xff, 0xfd, 0xfd, 0xfe, 0xef, 0xf7, 0xbf, 0xd2,
	0xfb, 0xbf, 0xfe, 0xfa, 0xb7, 0x1d, 0x3c, 0x57,
	0x6f, 0x97, 0x73, 0xf8, 0xff, 0xef, 0xff, 0x70,
	0xaf, 0x03, 0xff, 0xff, 0xcf, 0x05, 0x85, 0x62,
	0xe9, 0xbf, 0xfd, 0xff, 0xff, 0xf7, 0xfd, 0x77,
	0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3,
	0xc9, 0xff, 0xff, 0xff, 0x4d, 0xb8, 0x0a, 0x6a,
	0x7e, 0xfa, 0xe3, 0xfe, 0x7e, 0xff, 0x77, 0xff,
	// Entry 40 - 7F
	0xff, 0xff, 0xff, 0xdf, 0x2b, 0xf4, 0xf1, 0xe0,
	0x5d, 0xe7, 0x9f, 0x14, 0x07, 0x20, 0xdf, 0xed,
	0x9f, 0x3f, 0xc9, 0x21, 0xf8, 0x3f, 0x94, 0xf7,
	0x7e, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff,
	0xff, 0xff, 0x5f, 0xfc, 0xdb, 0xfd, 0xbf, 0xb5,
	0x7b, 0xdf, 0x7f, 0xf7, 0xeb, 0xfe, 0xff, 0xa7,
	0xbd, 0xff, 0x7f, 0xf7, 0xff, 0xef, 0xef, 0xef,
	0xff, 0xff, 0x9f, 0xff, 0xff, 0xef, 0xff, 0xdf,
	// Entry 80 - BF
	0xff, 0xff, 0xf3, 0xff, 0xfb, 0x2f, 0xff, 0xff,
	0xfb, 0xee, 0xff, 0xbd, 0xdb, 0xff, 0xdf, 0xf7,
	0xff, 0xfa, 0xfd, 0xff, 0x7e, 0xaf, 0x7b, 0xfe,
	0x7f, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xdf, 0xff,
	0xff, 0xdf, 0xfb, 0xff, 0xfd, 0xfc, 0xfb, 0xff,
	0xff, 0xff, 0xff, 0xf7, 0x7f, 0xbf, 0xfd, 0xd5,
	0xa5, 0x77, 0x40, 0xff, 0x9c, 0xc1, 0x41, 0x2c,
	0x08, 0x24, 0x41, 0x00, 0x50, 0x40, 0x00, 0x80,
	// Entry C0 - FF
	0xfb, 0x4a, 0xf2, 0x9f, 0xb4, 0x42, 0x41, 0x96,
	0x9b, 0x14, 0x88, 0xf6, 0x7b, 0xe7, 0x17, 0x56,
	0x55, 0x7d, 0x0e, 0x1c, 0x37, 0x71, 0xf3, 0xef,
	0x97, 0xff, 0x5d, 0x38, 0x64, 0x08, 0x00, 0x10,
	0xbc, 0x87, 0xaf, 0xdf, 0xff, 0xf7, 0x73, 0x35,
	0x3e, 0x87, 0xc7, 0xdf, 0xff, 0x00, 0x81, 0x00,
	0xb0, 0x05, 0x80, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x40, 0x00, 0x40, 0x92, 0x21, 0xd0, 0xbf, 0x5d,
	// Entry 100 - 13F
	0xfd, 0xde, 0xfe, 0x5e, 0x00, 0x00, 0x02, 0x64,
	0x8d, 0x19, 0xc1, 0xdf, 0x79, 0x22, 0x00, 0x00,
	0x00, 0xdf, 0x6d, 0xdc, 0x26, 0xe5, 0xd9, 0xf3,
	0xfe, 0xff, 0xfd, 0xcb, 0x9f, 0x14, 0x01, 0x0c,
	0x86, 0x00, 0xd1, 0x00, 0xf0, 0xc5, 0x67, 0x5f,
	0x56, 0x89, 0x5e, 0xb7, 0xec, 0xef, 0x03, 0x00,
	0x02, 0x00, 0x00, 0x00, 0xc0, 0x77, 0xda, 0x57,
	0x90, 0x69, 0x01, 0x2c, 0x16, 0x79, 0xe4, 0xff,
	// Entry 140 - 17F
	0xff, 0x7f, 0x00, 0x00, 0x00, 0x01, 0x08, 0x46,
	0x00, 0x00, 0x00, 0xb0, 0x14, 0x03, 0x50, 0x16,
	0x0a, 0x00, 0x01, 0x00, 0x00, 0x00, 0x11, 0x09,
	0x00, 0x00, 0x60, 0x10, 0x00, 0x00, 0x00, 0x10,
	0x00, 0x00, 0x44, 0x00, 0x00, 0x10, 0x00, 0x04,
	0x08, 0x00, 0x00, 0x04, 0x00, 0x80, 0x28, 0x04,
	0x00, 0x00, 0x50, 0xd5, 0x2d, 0x00, 0x64, 0x35,
	0x24, 0x53, 0xf5, 0xd4, 0xbd, 0xe2, 0xcd, 0x03,
	// Entry 180 - 1BF
	0x00, 0x80, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x17, 0x39, 0x01, 0xd9, 0x57, 0x98,
	0x21, 0x98, 0xa5, 0x00, 0x00, 0x01, 0x40, 0x82,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x40, 0x00, 0x44, 0x00, 0x00, 0xb0, 0xfe,
	0xa9, 0x39, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
	// Entry 1C0 - 1FF
	0x00, 0x01, 0x28, 0x05, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x20, 0x04, 0xa6, 0x08, 0x04, 0x00, 0x08,
	0x01, 0x50, 0x00, 0x00, 0x08, 0x11, 0x86, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x06, 0x55,
	0x02, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x60,
	0x3b, 0x83, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xbe, 0xdf, 0xff, 0xfe, 0xbf,
	// Entry 200 - 23F
	0xdf, 0xc7, 0x83, 0x82, 0xc0, 0xff, 0xdf, 0x27,
	0xcf, 0x5f, 0xe7, 0x01, 0x10, 0x20, 0xb2, 0xc5,
	0xa4, 0x45, 0x25, 0x9b, 0x03, 0xcf, 0xf0, 0xdf,
	0x03, 0xc4, 0x00, 0x10, 0x01, 0x0e, 0x01, 0xe3,
	0x92, 0x54, 0xdb, 0x38, 0xf1, 0x7f, 0xf7, 0x6d,
	0xf9, 0xff, 0x1c, 0x7d, 0x04, 0x08, 0x00, 0x01,
	0x21, 0x12, 0x6c, 0x5f, 0xdd, 0x0f, 0x85, 0x4f,
	0x40, 0x40, 0x00, 0x04, 0xf9, 0xfd, 0xbd, 0xd4,
	// Entry 240 - 27F
	0xe8, 0x13, 0xf4, 0x27, 0xa3, 0x0d, 0x00, 0x00,
	0x20, 0x7b, 0x39, 0x02, 0x05, 0x84, 0x00, 0xf0,
	0xbf, 0x7f, 0xda, 0x00, 0x18, 0x04, 0x81, 0x00,
	0x00, 0x00, 0x80, 0x10, 0x94, 0x1c, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x40, 0x00, 0x04,
	0x08, 0xb4, 0x7c, 0xa5, 0x0c, 0x40, 0x00, 0x00,
	0x11, 0x04, 0x04, 0x6c, 0x00, 0x20, 0x70, 0xff,
	0xfb, 0x7f, 0x60, 0x00, 0x05, 0x9b, 0xdd, 0x6e,
	// Entry 280 - 2BF
	0x03, 0x00, 0x11, 0x00, 0x00, 0x00, 0x40, 0x05,
	0xb5, 0xb6, 0x80, 0x08, 0x04, 0x00, 0x04, 0x51,
	0xe2, 0xff, 0xfd, 0x3f, 0x05, 0x09, 0x08, 0x05,
	0x40, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
	0x08, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x02, 0x60,
	0xe5, 0x48, 0x14, 0x89, 0x20, 0xc0, 0x47, 0x80,
	0x07, 0x00, 0x00, 0x00, 0xcc, 0x50, 0x40, 0x24,
	0x85, 0x47, 0x84, 0x40, 0x20, 0x10, 0x00, 0x20,
	// Entry 2C0 - 2FF
	0x02, 0x50, 0x88, 0x11, 0x00, 0xd1, 0x6c, 0xee,
	0x50, 0x03, 0x1d, 0x11, 0x69, 0x06, 0x59, 0xe9,
	0x33, 0x08, 0x00, 0x20, 0x05, 0x40, 0x10, 0x00,
	0x00, 0x00, 0x50, 0x44, 0x96, 0x49, 0xd6, 0x5d,
	0xa7, 0x81, 0x45, 0x97, 0xfb, 0x00, 0x10, 0x00,
	0x08, 0x00, 0x80, 0x00, 0x40, 0x45, 0x00, 0x01,
	0x02, 0x00, 0x01, 0x40, 0x80, 0x00, 0x04, 0x08,
	0xf8, 0xeb, 0xf6, 0x39, 0xc4, 0x89, 0x16, 0x00,
	// Entry 300 - 33F
	0x00, 0x0c, 0x04, 0x01, 0x20, 0x20, 0xdd, 0xa2,
	0x01, 0x00, 0x00, 0x00, 0x12, 0x04, 0x00, 0x00,
	0x04, 0x10, 0xf0, 0x9d, 0x95, 0x13, 0x04, 0x80,
	0x00, 0x00, 0xd0, 0x12, 0x40, 0x00, 0x10, 0xb0,
	0x10, 0x62, 0x4c, 0xd2, 0x02, 0x01, 0x0a, 0x00,
	0x46, 0x04, 0x00, 0x08, 0x02, 0x00, 0x20, 0xc0,
	0x00, 0x80, 0x06, 0x00, 0x08, 0x00, 0x00, 0x00,
	0x00, 0xf0, 0xd8, 0x6f, 0x15, 0x02, 0x08, 0x00,
	// Entry 340 - 37F
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x10, 0x01,
	0x00, 0x10, 0x00, 0x00, 0x00, 0xf8, 0x85, 0xe3,
	0xdd, 0xff, 0xff, 0xff, 0xbb, 0xff, 0x7f, 0xfb,
	0xff, 0xfc, 0xfe, 0xdf, 0xff, 0xff, 0xff, 0xf6,
	0xfb, 0xfe, 0xf7, 0x1f, 0xff, 0xb3, 0xed, 0xff,
	0xdb, 0xed, 0xff, 0xfe, 0xff, 0xfe, 0xdf, 0xff,
	0xff, 0xff, 0xf7, 0xff, 0xfd, 0xff, 0xff, 0xff,
	0xfd, 0xff, 0xdf, 0xaf, 0x9c, 0xff, 0xfb, 0xff,
	// Entry 380 - 3BF
	0xff, 0xff, 0xff, 0xff, 0xef, 0xd2, 0xbb, 0xdf,
	0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xef,
	0xfd, 0xff, 0xff, 0xf7, 0xfd, 0xff, 0xff, 0xff,
	0xef, 0xdb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x5f, 0xd3, 0x7b, 0xfd, 0xd9, 0xdf, 0xef,
	0xbc, 0x18, 0x05, 0x2c, 0xff, 0x07, 0xf0, 0xff,
	0xf7, 0x5f, 0x00, 0x08, 0x00, 0xc3, 0x3d, 0x1b,
	0x06, 0xe6, 0x72, 0xf0, 0xdd, 0x3c, 0x7f, 0x44,
	// Entry 3C0 - 3FF
	0x02, 0x30, 0x9f, 0x7a, 0x16, 0xfd, 0xff, 0x57,
	0xf2, 0xff, 0x39, 0xff, 0xf2, 0x1e, 0x95, 0xf7,
	0xf7, 0xff, 0x45, 0x80, 0x01, 0x02, 0x00, 0x00,
	0x40, 0x54, 0x9f, 0x8a, 0xd9, 0xd9, 0x0e, 0x11,
	0x84, 0x51, 0xc0, 0xf3, 0xfb, 0x47, 0x00, 0x01,
	0x05, 0xd1, 0x50, 0x58, 0x00, 0x00, 0x00, 0x10,
	0x04, 0x02, 0x00, 0x00, 0x0a, 0x00, 0x17, 0xd2,
	0xf9, 0xfd, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff,
	// Entry 400 - 43F
	0xd7, 0x6f, 0xff, 0xff, 0xdf, 0x7d, 0xbb, 0xff,
	0xff, 0xff, 0xf7, 0xf3, 0xef, 0xff, 0xff, 0xf7,
	0xff, 0xdf, 0xdb, 0x77, 0xff, 0xff, 0x7f, 0xff,
	0xff, 0xff, 0xef, 0xff, 0xbc, 0xff, 0xff, 0xfb,
	0xff, 0xfb, 0xff, 0xde, 0x76, 0xbd, 0xff, 0xf7,
	0xff, 0xff, 0xf7, 0xff, 0xff, 0xdf, 0xf3, 0xbf,
	0xef, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x7f, 0xde,
	0xf7, 0xbb, 0xef, 0xf7, 0xff, 0xfb, 0xbf, 0xdf,
	// Entry 440 - 47F
	0xfd, 0xfe, 0xff, 0xff, 0xfe, 0xff, 0x5f, 0x7d,
	0x7f, 0xff, 0xff, 0xf7, 0xe5, 0xfc, 0xff, 0xfd,
	0x7f, 0x7f, 0xff, 0x9e, 0xae, 0xff, 0xee, 0xff,
	0x7f, 0xf7, 0x7b, 0x02, 0x82, 0x04, 0xff, 0xf7,
	0xff, 0xbf, 0xd7, 0xef, 0xfe, 0xdf, 0xf7, 0xfe,
	0xe2, 0x8e, 0xe7, 0xff, 0xf7, 0xff, 0x56, 0xbd,
	0xcd, 0xff, 0xfb, 0xff, 0xff, 0xdf, 0xef, 0xff,
	0xe5, 0xdf, 0x7d, 0x0f, 0xa7, 0x51, 0x04, 0x44,
	// Entry 480 - 4BF
	0x13, 0xd0, 0x5d, 0xaf, 0xa6, 0xfd, 0xb9, 0xff,
	0x43, 0x5d, 0x5b, 0xff, 0xff, 0xbf, 0x3f, 0x20,
	0x14, 0x00, 0x57, 0x51, 0x82, 0x65, 0xf5, 0x49,
	0xe2, 0xff, 0xfc, 0xdf, 0x00, 0x05, 0xc5, 0x05,
	0x00, 0x22, 0x00, 0x74, 0x69, 0x10, 0x08, 0x04,
	0x41, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x51, 0x60, 0x05, 0x04, 0x01, 0x00, 0x00,
	0x06, 0x01, 0x20, 0x00, 0x18, 0x01, 0x92, 0xb1,
	// Entry 4C0 - 4FF
	0xfd, 0x67, 0x4b, 0x06, 0x95, 0x02, 0x57, 0xed,
	0xfb, 0x4c, 0x9d, 0x7b, 0x83, 0x04, 0x62, 0x40,
	0x00, 0x15, 0x42, 0x00, 0x00, 0x00, 0x54, 0x83,
	0xf9, 0x5f, 0x10, 0x8c, 0xc9, 0x46, 0xde, 0xf7,
	0x13, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x10, 0x00,
	0x01, 0x40, 0x00, 0xf0, 0x5b, 0xf4, 0xbe, 0x7d,
	0xba, 0xcf, 0xf7, 0xaf, 0x42, 0x04, 0x84, 0x41,
	// Entry 500 - 53F
	0xb0, 0xff, 0x79, 0x7a, 0x04, 0x00, 0x00, 0x49,
	0x2d, 0x14, 0x25, 0x77, 0xed, 0xf1, 0xbf, 0xef,
	0x3f, 0x00, 0x00, 0x02, 0xc6, 0xa0, 0x1e, 0xfc,
	0xbb, 0xff, 0xfd, 0xfb, 0xb7, 0xfd, 0xf5, 0xff,
	0xfd, 0xfc, 0xd5, 0xed, 0x47, 0xf4, 0x7f, 0x10,
	0x01, 0x01, 0x84, 0x6d, 0xff, 0xf7, 0xdd, 0xf9,
	0x5f, 0x05, 0x86, 0xef, 0xf5, 0x77, 0xbd, 0x3c,
	0x00, 0x00, 0x00, 0x43, 0x71, 0x42, 0x00, 0x40,
	// Entry 540 - 57F
	0x00, 0x00, 0x01, 0x43, 0x19, 0x00, 0x08, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	// Entry 580 - 5BF
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xab, 0xbd, 0xe7, 0x57, 0xee, 0x13, 0x5d,
	0x09, 0xc1, 0x40, 0x21, 0xfa, 0x17, 0x01, 0x80,
	0x00, 0x00, 0x00, 0x00, 0xf0, 0xde, 0xff, 0xbf,
	0x00, 0x23, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
	0x00, 0x30, 0x95, 0xe3, 0x10, 0x00, 0x00, 0x00,
	0x11, 0x04, 0x16, 0x00, 0x01, 0x02, 0x00, 0x81,
	0xa3, 0x01, 0x50, 0x00, 0x00, 0x83, 0x11, 0x40,
	// Entry 5C0 - 5FF
	0x00, 0x00, 0x00, 0xf0, 0xdd, 0x7b, 0x7e, 0x02,
	0xaa, 0x10, 0x5d, 0xd8, 0x52, 0x00, 0x80, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x10, 0x02, 0x02,
	0x09, 0x00, 0x10, 0x02, 0x10, 0x61, 0x5a, 0x9d,
	0x31, 0x00, 0x00, 0x00, 0x01, 0x50, 0x02, 0x20,
	0x00, 0x00, 0x01, 0x00, 0x42, 0x00, 0x00, 0x00,
	0x00, 0x1f, 0xdf, 0xf2, 0xfd, 0xff, 0xfd, 0x3f,
	0x9f, 0x18, 0xcf, 0x9c, 0xbf, 0xaf, 0x5f, 0xfe,
	// Entry 600 - 63F
	0x7b, 0x4b, 0x40, 0x10, 0xe1, 0xfd, 0xaf, 0xfd,
	0xb7, 0xf7, 0xff, 0xf3, 0xdf, 0xff, 0x6f, 0xf1,
	0x7b, 0xf1, 0x7f, 0xdf, 0x7f, 0xbf, 0xfe, 0xb7,
	0xee, 0x1c, 0xfb, 0xdb, 0xef, 0xdf, 0xff, 0xfd,
	0x7e, 0xbe, 0x57, 0xff, 0x6f, 0x81, 0x76, 0x1f,
	0xd4, 0x77, 0xf5, 0xfd, 0xff, 0xff, 0xeb, 0xfe,
	0xbf, 0x5f, 0x57, 0x1b, 0xeb, 0x5f, 0x50, 0x18,
	0x02, 0xfa, 0xff, 0x9d, 0x15, 0x97, 0x15, 0x0f,
	// Entry 640 - 67F
	0x75, 0xc4, 0x7d, 0x81, 0x82, 0xf1, 0xd7, 0x7e,
	0xff, 0xff, 0xff, 0xef, 0xff, 0xfd, 0xdd, 0xde,
	0xbc, 0xfd, 0xf6, 0x5f, 0x7a, 0x1f, 0x40, 0x98,
	0x02, 0xff, 0xe3, 0xff, 0xf3, 0xd6, 0xf2, 0xff,
	0xfb, 0xdf, 0x7d, 0x50, 0x1e, 0x15, 0x7b, 0xb4,
	0xf5, 0xbe, 0xff, 0xff, 0xf3, 0xf7, 0xff, 0xf7,
	0x7f, 0xff, 0xff, 0xbe, 0xdb, 0xf7, 0xd7, 0xf9,
	0xef, 0x2f, 0x80, 0xbf, 0xc5, 0xff, 0xff, 0xf3,
	// Entry 680 - 6BF
	0x97, 0x9d, 0xff, 0xff, 0xf7, 0xcf, 0xfd, 0xbf,
	0xde, 0x7f, 0x06, 0x1d, 0x57, 0xff, 0xf8, 0xda,
	0x5d, 0xcf, 0x7d, 0x16, 0xb9, 0xea, 0x69, 0xa0,
	0x1a, 0x20, 0x00, 0x30, 0x02, 0x04, 0x24, 0x48,
	0x04, 0x00, 0x00, 0x40, 0xd4, 0x02, 0x04, 0x00,
	0x00, 0x04, 0x00, 0x04, 0x00, 0x20, 0x01, 0x06,
	0x50, 0x00, 0x08, 0x00, 0x00, 0x00, 0x24, 0x00,
	0x04, 0x00, 0x10, 0x8c, 0x58, 0xd5, 0x0d, 0x0f,
	// Entry 6C0 - 6FF
	0x14, 0x4d, 0xf1, 0x16, 0x44, 0xd1, 0x42, 0x08,
	0x40, 0x00, 0x00, 0x40, 0x00, 0x08, 0x00, 0x00,
	0x00, 0xdc, 0xff, 0xeb, 0x1f, 0x58, 0x08, 0x41,
	0x04, 0xa0, 0x04, 0x00, 0x30, 0x12, 0x40, 0x22,
	0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x80, 0x10, 0x10, 0xaf,
	0x6f, 0x93, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x80, 0x80, 0x25, 0x00, 0x00,
	// Entry 700 - 73F
	0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
	0x80, 0x86, 0xc2, 0x02, 0x00, 0x00, 0x00, 0x01,
	0xdf, 0x18, 0x00, 0x00, 0x02, 0xf0, 0xfd, 0x79,
	0x3b, 0x00, 0x25, 0x00, 0x00, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
	0x03, 0x00, 0x09, 0x20, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x81, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 740 - 77F
	0x00, 0x00, 0x00, 0xef, 0xf7, 0xfd, 0xcf, 0x7e,
	0xa0, 0x11, 0x10, 0x00, 0x00, 0x92, 0x01, 0x44,
	0xcd, 0xf9, 0x5e, 0x00, 0x01, 0x00, 0x30, 0x14,
	0x04, 0x55, 0x10, 0x01, 0x04, 0xf6, 0x3f, 0x7a,
	0x05, 0x04, 0x00, 0xb0, 0x80, 0x00, 0x55, 0x55,
	0x97, 0x7c, 0x9f, 0x71, 0xcc, 0x78, 0xd1, 0x43,
	0xf5, 0x57, 0x67, 0x14, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x2c, 0xf7, 0xdb, 0x1f, 0x50, 0x60,
	// Entry 780 - 7BF
	0x03, 0x68, 0x01, 0x10, 0x8b, 0x38, 0xaa, 0x01,
	0x00, 0x00, 0x30, 0x00, 0x24, 0x44, 0x00, 0x00,
	0x10, 0x03, 0x11, 0x02, 0x01, 0x00, 0x00, 0xf0,
	0xb5, 0xff, 0xd5, 0xd7, 0xbc, 0x70, 0xd6, 0x78,
	0x78, 0x15, 0x50, 0x00, 0xa4, 0x84, 0xe9, 0x41,
	0x00, 0x00, 0x00, 0x6b, 0x39, 0x52, 0x74, 0x00,
	0xe8, 0x30, 0x90, 0x6a, 0x92, 0x00, 0x00, 0x02,
	0xff, 0xef, 0xff, 0x4f, 0x85, 0x53, 0xf4, 0xed,
	// Entry 7C0 - 7FF
	0xdd, 0xbf, 0x72, 0x19, 0xc7, 0x0c, 0xf5, 0x42,
	0x54, 0xdd, 0x77, 0x14, 0x00, 0x80, 0xc0, 0x56,
	0xcc, 0x16, 0x9e, 0xfb, 0x35, 0x7d, 0xef, 0xff,
	0xbd, 0xa4, 0xaf, 0x01, 0x44, 0x18, 0x01, 0x5d,
	0x4e, 0x4a, 0x08, 0x50, 0x28, 0x30, 0xe0, 0x80,
	0x10, 0x20, 0x24, 0x00, 0xff, 0x3f, 0xdf, 0x67,
	0xfe, 0x01, 0x06, 0x88, 0x0a, 0x40, 0x16, 0x01,
	0x01, 0x15, 0x2b, 0x3e, 0x01, 0x00, 0x00, 0x10,
	// Entry 800 - 83F
	0x90, 0x69, 0x45, 0x02, 0x02, 0x01, 0xe1, 0xbf,
	0xbf, 0x03, 0x00, 0x00, 0x10, 0xd4, 0xa7, 0xd1,
	0x54, 0x9e, 0x44, 0xdf, 0xfd, 0x8f, 0x66, 0xb3,
	0x55, 0x20, 0xd4, 0xc3, 0xd8, 0x30, 0x3d, 0x80,
	0x00, 0x00, 0x00, 0x4c, 0xd4, 0x10, 0xc5, 0x84,
	0x6e, 0x50, 0x00, 0x22, 0x50, 0x7e, 0xbf, 0xdb,
	0x07, 0x00, 0x20, 0x10, 0x84, 0xb2, 0x45, 0x10,
	0x06, 0x44, 0x00, 0x00, 0x12, 0x02, 0x11, 0x00,
	// Entry 840 - 87F
	0xf0, 0xfb, 0xfd, 0x3f, 0x05, 0x00, 0x12, 0x81,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x02, 0x28,
	0x84, 0x00, 0x33, 0xc0, 0x23, 0x24, 0x00, 0x00,
	0x00, 0xcb, 0xe4, 0x3a, 0x42, 0xc8, 0x14, 0xf1,
	0xef, 0xff, 0x7f, 0x16, 0x01, 0x01, 0x84, 0x50,
	0x07, 0xfc, 0xff, 0xff, 0x0f, 0x01, 0x00, 0x40,
	0x10, 0x38, 0x01, 0x01, 0x1c, 0x12, 0x40, 0xe1,
	// Entry 880 - 8BF
	0x76, 0x16, 0x08, 0x03, 0x10, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x24,
	0x0a, 0x00, 0x80, 0x00, 0x00,
}

// altLangISO3 holds an alphabetically sorted list of 3-letter language code alternatives
// to 2-letter language codes that cannot be derived using the method described above.
// Each 3-letter code is followed by its 1-byte langID.
var altLangISO3 tag.Index = "---\x00cor\x00hbs\x01heb\x02kin\x03spa\x04yid\x05\xff\xff\xff\xff"

// altLangIndex is used to convert indexes in altLangISO3 to langIDs.
// Size: 12 bytes, 6 elements
var altLangIndex = [6]uint16{
	0x0149, 0x0223, 0x0104, 0x0208, 0x009c, 0x010a,
}

// langAliasMap maps langIDs to their suggested replacements.
// Size: 556 bytes, 139 elements
var langAliasMap = [139]fromTo{
	0:   {from: 0xfe, to: 0xf7},
	1:   {from: 0x104, to: 0xdf},
	2:   {from: 0x10a, to: 0x2b6},
	3:   {from: 0x10f, to: 0x10e},
	4:   {from: 0x191, to: 0x201},
	5:   {from: 0x1ae, to: 0x1c0},
	6:   {from: 0x223, to: 0x239},
	7:   {from: 0x266, to: 0xa9},
	8:   {from: 0x272, to: 0x250},
	9:   {from: 0x27b, to: 0xd},
	10:  {from: 0x2d1, to: 0x2d7},
	11:  {from: 0x322, to: 0x92},
	12:  {from: 0x3c3, to: 0x1c44},
	13:  {from: 0x3e4, to: 0x238},
	14:  {from: 0x3f5, to: 0x238},
	15:  {from: 0x480, to: 0x15},
	16:  {from: 0x48b, to: 0xf2},
	17:  {from: 0x4d1, to: 0x1f34},
	18:  {from: 0x546, to: 0x23},
	19:  {from: 0x54c, to: 0x272e},
	20:  {from: 0x558, to: 0x24},
	21:  {from: 0x579, to: 0xa0},
	22:  {from: 0x59f, to: 0x26},
	23:  {from: 0x5a8, to: 0x42},
	24:  {from: 0x656, to: 0xc76},
	25:  {from: 0x782, to: 0x1a4},
	26:  {from: 0x7c9, to: 0x16d},
	27:  {from: 0x7d0, to: 0x59},
	28:  {from: 0x851, to: 0x30b5},
	29:  {from: 0x8cb, to: 0x2c0},
	30:  {from: 0x908, to: 0x23ed},
	31:  {from: 0x911, to: 0x956},
	32:  {from: 0x92e, to: 0x24d},
	33:  {from: 0x94f, to: 0x3fbc},
	34:  {from: 0x952, to: 0x2c0},
	35:  {from: 0xa4c, to: 0x73},
	36:  {from: 0xa9b, to: 0x79},
	37:  {from: 0xb5b, to: 0x8a},
	38:  {from: 0xb6a, to: 0x1a1},
	39:  {from: 0xb8b, to: 0xb8e},
	40:  {from: 0xb91, to: 0x2c4},
	41:  {from: 0xc72, to: 0x1ded},
	42:  {from: 0xc81, to: 0x2c2d},
	43:  {from: 0xccc, to: 0x1bc},
	44:  {from: 0xe63, to: 0x9e},
	45:  {from: 0xe97, to: 0x178},
	46:  {from: 0xf33, to: 0xfb},
	47:  {from: 0x100c, to: 0xd},
	48:  {from: 0x11b7, to: 0xae},
	49:  {from: 0x1203, to: 0xa5},
	50:  {from: 0x12b2, to: 0xb2e},
	51:  {from: 0x12b6, to: 0x1d1},
	52:  {from: 0x12c5, to: 0x1458},
	53:  {from: 0x1313, to: 0x110},
	54:  {from: 0x1316, to: 0x85},
	55:  {from: 0x1336, to: 0x3a42},
	56:  {from: 0x13fd, to: 0xcb},
	57:  {from: 0x145b, to: 0x99},
	58:  {from: 0x1493, to: 0x278b},
	59:  {from: 0x14ab, to: 0xc9},
	60:  {from: 0x150d, to: 0x12b7},
	61:  {from: 0x159c, to: 0x1549},
	62:  {from: 0x15a9, to: 0x1686},
	63:  {from: 0x161d, to: 0x23d},
	64:  {from: 0x170c, to: 0x1a94},
	65:  {from: 0x1807, to: 0x2943},
	66:  {from: 0x181d, to: 0x101},
	67:  {from: 0x18ed, to: 0x103},
	68:  {from: 0x1919, to: 0x12a8},
	69:  {from: 0x1dd0, to: 0x1e70},
	70:  {from: 0x1ded, to: 0x18e},
	71:  {from: 0x1e76, to: 0x144},
	72:  {from: 0x1e81, to: 0x13a},
	73:  {from: 0x1e85, to: 0x121},
	74:  {from: 0x1e8c, to: 0x137},
	75:  {from: 0x1ea2, to: 0x1f7e},
	76:  {from: 0x1ec8, to: 0x146},
	77:  {from: 0x1f79, to: 0x4231},
	78:  {from: 0x1f87, to: 0x3716},
	79:  {from: 0x1ff5, to: 0x6bd},
	80:  {from: 0x20a9, to: 0x2fb9},
	81:  {from: 0x2115, to: 0x30f8},
	82:  {from: 0x2205, to: 0x16f},
	83:  {from: 0x2277, to: 0x18b},
	84:  {from: 0x2283, to: 0x188},
	85:  {from: 0x228d, to: 0x199},
	86:  {from: 0x22e3, to: 0x8ee},
	87:  {from: 0x233c, to: 0x69},
	88:  {from: 0x23d1, to: 0x178},
	89:  {from: 0x245c, to: 0x2447},
	90:  {from: 0x248c, to: 0x1f2},
	91:  {from: 0x24ba, to: 0x3a42},
	92:  {from: 0x24f8, to: 0x2447},
	93:  {from: 0x2682, to: 0x25ca},
	94:  {from: 0x26a7, to: 0x1b3},
	95:  {from: 0x28ad, to: 0x1d0},
	96:  {from: 0x298f, to: 0x1d2},
	97:  {from: 0x29d2, to: 0x3a42},
	98:  {from: 0x2a8f, to: 0x1ec},
	99:  {from: 0x2aa6, to: 0x32a},
	100: {from: 0x2ada, to: 0xa3},
	101: {from: 0x2adb, to: 0xa3},
	102: {from: 0x2b92, to: 0x182},
	103: {from: 0x2bad, to: 0x2b28},
	104: {from: 0x2bb4, to: 0x151},
	105: {from: 0x2bf8, to: 0x2015},
	106: {from: 0x2c82, to: 0x2c6a},
	107: {from: 0x2f26, to: 0x1ef},
	108: {from: 0x30f9, to: 0x3121},
	109: {from: 0x31bd, to: 0x201},
	110: {from: 0x3281, to: 0x1663},
	111: {from: 0x3379, to: 0x228},
	112: {from: 0x33eb, to: 0x131},
	113: {from: 0x3409, to: 0x213},
	114: {from: 0x3490, to: 0x246},
	115: {from: 0x35be, to: 0x2a2e},
	116: {from: 0x35c2, to: 0x4c},
	117: {from: 0x35c5, to: 0x2fbb},
	118: {from: 0x35ff, to: 0x3739},
	119: {from: 0x3625, to: 0x3d53},
	120: {from: 0x3648, to: 0x2c2d},
	121: {from: 0x36ef, to: 0x268},
	122: {from: 0x38e1, to: 0xb24},
	123: {from: 0x390b, to: 0xe8d},
	124: {from: 0x3a2c, to: 0x28a},
	125: {from: 0x3d50, to: 0x7f},
	126: {from: 0x4051, to: 0x306},
	127: {from: 0x410b, to: 0x139},
	128: {from: 0x415e, to: 0x345e},
	129: {from: 0x4160, to: 0x86},
	130: {from: 0x4242, to: 0x30b5},
	131: {from: 0x4276, to: 0x2b6},
	132: {from: 0x435d, to: 0x219c},
	133: {from: 0x4370, to: 0x246f},
	134: {from: 0x43a3, to: 0x4641},
	135: {from: 0x4441, to: 0x4433},
	136: {from: 0x44d1, to: 0x44d8},
	137: {from: 0x46a9, to: 0x199},
	138: {from: 0x473a, to: 0x2ba},
}

// Size: 139 bytes, 139 elements
var langAliasTypes = [139]langAliasType{
	// Entry 0 - 3F
	0, 0, 0, 0, 0, 1, 2, 2, 0, 1, 0, 0, 1, 2, 1, 1,
	2, 0, 1, 0, 1, 2, 1, 1, 0, 2, 1, 1, 0, 2, 0, 0,
	1, 0, 1, 1, 2, 1, 1, 1, 1, 0, 0, 2, 1, 1, 1, 1,
	2, 1, 0, 1, 1, 2, 2, 0, 1, 2, 0, 1, 1, 1, 1, 1,
	// Entry 40 - 7F
	0, 0, 2, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1,
	0, 0, 1, 2, 2, 2, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1,
	1, 0, 1, 0, 2, 1, 1, 0, 1, 0, 0, 1, 1, 2, 0, 2,
	1, 1, 1, 0, 2, 0, 0, 0, 0, 1, 1, 0, 1, 2, 0, 1,
	// Entry 80 - BF
	0, 1, 0, 1, 0, 0, 0, 0, 1, 1, 1,
}

const (
	_Latn = 79
	_Hani = 48
	_Hans = 50
	_Hant = 51
	_Qaaa = 125
	_Qaai = 133
	_Qabx = 174
	_Zinh = 218
	_Zyyy = 222
	_Zzzz = 223
)

// script is an alphabetically sorted list of ISO 15924 codes. The index
// of the script in the string, divided by 4, is the internal scriptID.
var script tag.Index = "" + // Size: 900 bytes
	"----AdlmAfakAghbAhomArabAranArmiArmnAvstBaliBamuBassBatkBengBlisBopoBrah" +
	"BraiBugiBuhdCakmCansCariChamCherCirtCoptCprtCyrlCyrsDevaDsrtDuplEgydEgyh" +
	"EgypElbaEthiGeokGeorGlagGothGranGrekGujrGuruHangHaniHanoHansHantHatrHebr" +
	"HiraHluwHmngHrktHungIndsItalJavaJpanJurcKaliKanaKharKhmrKhojKitlKitsKnda" +
	"KoreKpelKthiLanaLaooLatfLatgLatnLepcLimbLinaLinbLisuLomaLyciLydiMahjMand" +
	"ManiMarcMayaMendMercMeroMlymModiMongMoonMrooMteiMultMymrNarbNbatNkgbNkoo" +
	"NshuOgamOlckOrkhOryaOsgeOsmaPalmPaucPermPhagPhliPhlpPhlvPhnxPlrdPrtiQaaa" +
	"QaabQaacQaadQaaeQaafQaagQaahQaaiQaajQaakQaalQaamQaanQaaoQaapQaaqQaarQaas" +
	"QaatQaauQaavQaawQaaxQaayQaazQabaQabbQabcQabdQabeQabfQabgQabhQabiQabjQabk" +
	"QablQabmQabnQaboQabpQabqQabrQabsQabtQabuQabvQabwQabxRjngRoroRunrSamrSara" +
	"SarbSaurSgnwShawShrdSiddSindSinhSoraSundSyloSyrcSyreSyrjSyrnTagbTakrTale" +
	"TaluTamlTangTavtTeluTengTfngTglgThaaThaiTibtTirhUgarVaiiVispWaraWoleXpeo" +
	"XsuxYiiiZinhZmthZsymZxxxZyyyZzzz\xff\xff\xff\xff"

// suppressScript is an index from langID to the dominant script for that language,
// if it exists.  If a script is given, it should be suppressed from the language tag.
// Size: 709 bytes, 709 elements
var suppressScript = [709]uint8{
	// Entry 0 - 3F
	0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x26, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 40 - 7F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f,
	// Entry 80 - BF
	0x4f, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0xce,
	0x00, 0x00, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x2c, 0x4f, 0x4f, 0x4f, 0x00, 0x4f, 0x00,
	0x4f, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x4f,
	0x00, 0x00, 0x00, 0x4f, 0x4f, 0x00, 0x4f, 0x00,
	0x00, 0x4f, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x4f, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry C0 - FF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f,
	0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x4f, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35,
	0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x4f, 0x00,
	0x4f, 0x4f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x4f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x00,
	// Entry 100 - 13F
	0x00, 0x4f, 0x4f, 0x00, 0x35, 0x00, 0x3e, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x00,
	0x4f, 0x00, 0x43, 0x00, 0x47, 0x48, 0x00, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 140 - 17F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x4f, 0x4c, 0x00, 0x00, 0x00,
	0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x00,
	// Entry 180 - 1BF
	0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x4f,
	0x00, 0x00, 0x00, 0x1d, 0x60, 0x00, 0x00, 0x00,
	0x00, 0x4f, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00,
	0x00, 0x4f, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x67, 0x00, 0x00, 0x00,
	0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x00,
	0x4f, 0x00, 0x4f, 0x1f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x4f, 0x00, 0x4f, 0x00, 0x4f, 0x00,
	// Entry 1C0 - 1FF
	0x4f, 0x00, 0x00, 0x00, 0x6b, 0x4f, 0x00, 0x4f,
	0x00, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x4f, 0x70, 0x00, 0x00, 0x2e, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x05, 0x4f, 0x00, 0x4f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x4f,
	// Entry 200 - 23F
	0x00, 0x4f, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00,
	0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbb, 0x00,
	0x4f, 0x00, 0x4f, 0x00, 0x00, 0x4f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x00,
	0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x00,
	// Entry 240 - 27F
	0x4f, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x4f, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc7,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0x4f,
	0x00, 0x00, 0x00, 0xcf, 0x00, 0x00, 0x00, 0x26,
	0x00, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x4f, 0x00,
	0x4f, 0x4f, 0x4f, 0x00, 0x4f, 0x4f, 0x00, 0x00,
	0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 280 - 2BF
	0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x05, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x4f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
	// Entry 2C0 - 2FF
	0x00, 0x00, 0x4f, 0x00, 0x00,
}

const (
	_001 = 1
	_419 = 30
	_BR  = 64
	_CA  = 72
	_ES  = 109
	_GB  = 121
	_MD  = 186
	_PT  = 236
	_UK  = 304
	_US  = 306
	_ZZ  = 354
	_XA  = 320
	_XC  = 322
	_XK  = 330
)

// isoRegionOffset needs to be added to the index of regionISO to obtain the regionID
// for 2-letter ISO codes. (The first isoRegionOffset regionIDs are reserved for
// the UN.M49 codes used for groups.)
const isoRegionOffset = 31

// regionTypes defines the status of a region for various standards.
// Size: 355 bytes, 355 elements
var regionTypes = [355]uint8{
	// Entry 0 - 3F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	// Entry 40 - 7F
	0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x04, 0x00,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06,
	0x04, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06, 0x04,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06, 0x04,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	// Entry 80 - BF
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x00, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00,
	// Entry C0 - FF
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06, 0x06,
	0x06, 0x06, 0x00, 0x06, 0x04, 0x06, 0x06, 0x06,
	0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06, 0x06,
	0x00, 0x06, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	// Entry 100 - 13F
	0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x02, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06,
	// Entry 140 - 17F
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x04, 0x06, 0x06, 0x04, 0x06, 0x06,
	0x04, 0x06, 0x05,
}

// regionISO holds a list of alphabetically sorted 2-letter ISO region codes.
// Each 2-letter codes is followed by two bytes with the following meaning:
//     - [A-Z}{2}: the first letter of the 2-letter code plus these two
//                 letters form the 3-letter ISO code.
//     - 0, n:     index into altRegionISO3.
var regionISO tag.Index = "" + // Size: 1300 bytes
	"AAAAACSCADNDAEREAFFGAGTGAIIAALLBAMRMANNTAOGOAQTAARRGASSMATUTAUUSAWBWAXLA" +
	"AZZEBAIHBBRBBDGDBEELBFFABGGRBHHRBIDIBJENBLLMBMMUBNRNBOOLBQESBRRABSHSBTTN" +
	"BUURBVVTBWWABYLRBZLZCAANCCCKCDODCFAFCGOGCHHECIIVCKOKCLHLCMMRCNHNCOOLCPPT" +
	"CRRICS\x00\x00CTTECUUBCVPVCWUWCXXRCYYPCZZEDDDRDEEUDGGADJJIDKNKDMMADOOMDY" +
	"HYDZZAEA  ECCUEESTEGGYEHSHERRIESSPETTHEU\x00\x03FIINFJJIFKLKFMSMFOROFQ" +
	"\x00\x18FRRAFXXXGAABGBBRGDRDGEEOGFUFGGGYGHHAGIIBGLRLGMMBGNINGPLPGQNQGRRC" +
	"GS\x00\x06GTTMGUUMGWNBGYUYHKKGHMMDHNNDHRRVHTTIHUUNHVVOIC  IDDNIERLILSRIM" +
	"MNINNDIOOTIQRQIRRNISSLITTAJEEYJMAMJOORJPPNJTTNKEENKGGZKHHMKIIRKM\x00\x09" +
	"KNNAKP\x00\x0cKRORKWWTKY\x00\x0fKZAZLAAOLBBNLCCALIIELKKALRBRLSSOLTTULUUX" +
	"LVVALYBYMAARMCCOMDDAMENEMFAFMGDGMHHLMIIDMKKDMLLIMMMRMNNGMOACMPNPMQTQMRRT" +
	"MSSRMTLTMUUSMVDVMWWIMXEXMYYSMZOZNAAMNCCLNEERNFFKNGGANHHBNIICNLLDNOORNPPL" +
	"NQ\x00\x1eNRRUNTTZNUIUNZZLOMMNPAANPCCIPEERPFYFPGNGPHHLPKAKPLOLPM\x00\x12" +
	"PNCNPRRIPSSEPTRTPUUSPWLWPYRYPZCZQAATQMMMQNNNQOOOQPPPQQQQQRRRQSSSQTTTQU" +
	"\x00\x03QVVVQWWWQXXXQYYYQZZZREEURHHOROOURS\x00\x15RUUSRWWASAAUSBLBSCYCSD" +
	"DNSEWESGGPSHHNSIVNSJJMSKVKSLLESMMRSNENSOOMSRURSSSDSTTPSUUNSVLVSXXMSYYRSZ" +
	"WZTAAATCCATDCDTF\x00\x18TGGOTHHATJJKTKKLTLLSTMKMTNUNTOONTPMPTRURTTTOTVUV" +
	"TWWNTZZAUAKRUGGAUK  UMMIUSSAUYRYUZZBVAATVCCTVDDRVEENVGGBVIIRVNNMVUUTWFLF" +
	"WKAKWSSMXAAAXBBBXCCCXDDDXEEEXFFFXGGGXHHHXIIIXJJJXKKKXLLLXMMMXNNNXOOOXPPP" +
	"XQQQXRRRXSSSXTTTXUUUXVVVXWWWXXXXXYYYXZZZYDMDYEEMYT\x00\x1bYUUGZAAFZMMBZR" +
	"ARZWWEZZZZ\xff\xff\xff\xff"

// altRegionISO3 holds a list of 3-letter region codes that cannot be
// mapped to 2-letter codes using the default algorithm. This is a short list.
var altRegionISO3 string = "SCGQUUSGSCOMPRKCYMSPMSRBATFMYTATN"

// altRegionIDs holds a list of regionIDs the positions of which match those
// of the 3-letter ISO codes in altRegionISO3.
// Size: 22 bytes, 11 elements
var altRegionIDs = [11]uint16{
	0x0056, 0x006f, 0x0086, 0x00a6, 0x00a8, 0x00ab, 0x00e8, 0x0103,
	0x011f, 0x015c, 0x00da,
}

// Size: 80 bytes, 20 elements
var regionOldMap = [20]fromTo{
	0:  {from: 0x43, to: 0xc2},
	1:  {from: 0x57, to: 0xa5},
	2:  {from: 0x5e, to: 0x5f},
	3:  {from: 0x65, to: 0x3a},
	4:  {from: 0x77, to: 0x76},
	5:  {from: 0x91, to: 0x36},
	6:  {from: 0xa1, to: 0x131},
	7:  {from: 0xbf, to: 0x131},
	8:  {from: 0xd5, to: 0x13c},
	9:  {from: 0xda, to: 0x2a},
	10: {from: 0xed, to: 0x131},
	11: {from: 0xf0, to: 0xe0},
	12: {from: 0xfa, to: 0x6f},
	13: {from: 0x101, to: 0x161},
	14: {from: 0x128, to: 0x124},
	15: {from: 0x130, to: 0x79},
	16: {from: 0x137, to: 0x13b},
	17: {from: 0x13e, to: 0x131},
	18: {from: 0x15a, to: 0x15b},
	19: {from: 0x160, to: 0x4a},
}

// m49 maps regionIDs to UN.M49 codes. The first isoRegionOffset entries are
// codes indicating collections of regions.
// Size: 710 bytes, 355 elements
var m49 = [355]int16{
	// Entry 0 - 3F
	0, 1, 2, 3, 5, 9, 11, 13,
	14, 15, 17, 18, 19, 21, 29, 30,
	34, 35, 39, 53, 54, 57, 61, 142,
	143, 145, 150, 151, 154, 155, 419, 958,
	0, 20, 784, 4, 28, 660, 8, 51,
	530, 24, 10, 32, 16, 40, 36, 533,
	248, 31, 70, 52, 50, 56, 854, 100,
	48, 108, 204, 652, 60, 96, 68, 535,
	// Entry 40 - 7F
	76, 44, 64, 104, 74, 72, 112, 84,
	124, 166, 180, 140, 178, 756, 384, 184,
	152, 120, 156, 170, 0, 188, 891, 296,
	192, 132, 531, 162, 196, 203, 278, 276,
	0, 262, 208, 212, 214, 204, 12, 0,
	218, 233, 818, 732, 232, 724, 231, 967,
	246, 242, 238, 583, 234, 0, 250, 249,
	266, 826, 308, 268, 254, 831, 288, 292,
	// Entry 80 - BF
	304, 270, 324, 312, 226, 300, 239, 320,
	316, 624, 328, 344, 334, 340, 191, 332,
	348, 854, 0, 360, 372, 376, 833, 356,
	86, 368, 364, 352, 380, 832, 388, 400,
	392, 581, 404, 417, 116, 296, 174, 659,
	408, 410, 414, 136, 398, 418, 422, 662,
	438, 144, 430, 426, 440, 442, 428, 434,
	504, 492, 498, 499, 663, 450, 584, 581,
	// Entry C0 - FF
	807, 466, 104, 496, 446, 580, 474, 478,
	500, 470, 480, 462, 454, 484, 458, 508,
	516, 540, 562, 574, 566, 548, 558, 528,
	578, 524, 10, 520, 536, 570, 554, 512,
	591, 0, 604, 258, 598, 608, 586, 616,
	666, 612, 630, 275, 620, 581, 585, 600,
	591, 634, 959, 960, 961, 962, 963, 964,
	965, 966, 967, 968, 969, 970, 971, 972,
	// Entry 100 - 13F
	638, 716, 642, 688, 643, 646, 682, 90,
	690, 729, 752, 702, 654, 705, 744, 703,
	694, 674, 686, 706, 740, 728, 678, 810,
	222, 534, 760, 748, 0, 796, 148, 260,
	768, 764, 762, 772, 626, 795, 788, 776,
	626, 792, 780, 798, 158, 834, 804, 800,
	826, 581, 840, 858, 860, 336, 670, 704,
	862, 92, 850, 704, 548, 876, 581, 882,
	// Entry 140 - 17F
	973, 974, 975, 976, 977, 978, 979, 980,
	981, 982, 983, 984, 985, 986, 987, 988,
	989, 990, 991, 992, 993, 994, 995, 996,
	997, 998, 720, 887, 175, 891, 710, 894,
	180, 716, 999,
}

// m49Index gives indexes into fromM49 based on the three most significant bits
// of a 10-bit UN.M49 code. To search an UN.M49 code in fromM49, search in
//    fromM49[m49Index[msb39(code)]:m49Index[msb3(code)+1]]
// for an entry where the first 7 bits match the 7 lsb of the UN.M49 code.
// The region code is stored in the 9 lsb of the indexed value.
// Size: 18 bytes, 9 elements
var m49Index = [9]int16{
	0, 59, 107, 142, 180, 219, 258, 290,
	332,
}

// fromM49 contains entries to map UN.M49 codes to regions. See m49Index for details.
// Size: 664 bytes, 332 elements
var fromM49 = [332]uint16{
	// Entry 0 - 3F
	0x0201, 0x0402, 0x0603, 0x0823, 0x0a04, 0x1026, 0x1205, 0x142a,
	0x1606, 0x1866, 0x1a07, 0x1c08, 0x1e09, 0x202c, 0x220a, 0x240b,
	0x260c, 0x2821, 0x2a0d, 0x3029, 0x3824, 0x3a0e, 0x3c0f, 0x3e31,
	0x402b, 0x4410, 0x4611, 0x482e, 0x4e12, 0x502d, 0x5841, 0x6038,
	0x6434, 0x6627, 0x6833, 0x6a13, 0x6c14, 0x7035, 0x7215, 0x783c,
	0x7a16, 0x8042, 0x883e, 0x8c32, 0x9045, 0x9444, 0x9840, 0xa847,
	0xac98, 0xb507, 0xb939, 0xc03d, 0xc837, 0xd0c2, 0xd839, 0xe046,
	0xe8a4, 0xf051, 0xf848, 0x0859, 0x10ab, 0x184b, 0x1c17, 0x1e18,
	// Entry 40 - 7F
	0x20b1, 0x2219, 0x291e, 0x2c1a, 0x2e1b, 0x3050, 0x341c, 0x361d,
	0x3852, 0x3d2c, 0x445b, 0x4c49, 0x5453, 0x5ca6, 0x5f5c, 0x644c,
	0x684a, 0x704f, 0x7855, 0x7e8e, 0x8058, 0x885c, 0x965d, 0x983a,
	0xa062, 0xa863, 0xac64, 0xb468, 0xbd18, 0xc484, 0xcc6e, 0xce6e,
	0xd06c, 0xd269, 0xd474, 0xdc72, 0xde86, 0xe471, 0xec70, 0xf030,
	0xf277, 0xf476, 0xfc7c, 0x04e3, 0x091f, 0x0c61, 0x1478, 0x187b,
	0x1c81, 0x26eb, 0x285f, 0x2c5e, 0x305f, 0x407e, 0x487f, 0x50a5,
	0x5885, 0x6080, 0x687a, 0x7083, 0x7888, 0x8087, 0x8882, 0x908a,
	// Entry 80 - BF
	0x988f, 0x9c8c, 0xa135, 0xa88d, 0xb08b, 0xb890, 0xc09b, 0xc897,
	0xd093, 0xd89a, 0xe099, 0xe894, 0xf095, 0xf89c, 0x004e, 0x089e,
	0x10a0, 0x1cac, 0x209f, 0x28a2, 0x30a8, 0x34a9, 0x3caa, 0x42a3,
	0x44ad, 0x461e, 0x4cae, 0x54b3, 0x58b6, 0x5cb2, 0x64b7, 0x6cb0,
	0x70b4, 0x74b5, 0x7cc4, 0x84bd, 0x8ccc, 0x94ce, 0x9ccb, 0xa4c1,
	0xacc9, 0xb4c6, 0xbcc7, 0xc0ca, 0xc8cd, 0xd8b9, 0xe0c3, 0xe4ba,
	0xe6bb, 0xe8c8, 0xf0b8, 0xf8cf, 0x00df, 0x08d0, 0x10db, 0x18d9,
	0x20d7, 0x2428, 0x265a, 0x2a2f, 0x2d19, 0x2e3f, 0x30dc, 0x38d1,
	// Entry C0 - FF
	0x493c, 0x54de, 0x5cd6, 0x64d2, 0x6cd4, 0x74dd, 0x7cd3, 0x84d8,
	0x88c5, 0x8b31, 0x8e73, 0x90be, 0x92ee, 0x94e6, 0x9ee0, 0xace4,
	0xb0ef, 0xb8e2, 0xc0e5, 0xc8e9, 0xd0e7, 0xd8ec, 0xe089, 0xe524,
	0xecea, 0xf4f1, 0xfd00, 0x0502, 0x0704, 0x0d05, 0x183b, 0x1d0c,
	0x26a7, 0x2825, 0x2caf, 0x2ebc, 0x34e8, 0x3d36, 0x4511, 0x4d16,
	0x5506, 0x5d12, 0x6103, 0x6508, 0x6d10, 0x7d0b, 0x7f0f, 0x813b,
	0x830d, 0x8513, 0x8d5e, 0x9961, 0xa15a, 0xa86d, 0xb115, 0xb309,
	0xb86b, 0xc109, 0xc914, 0xd10e, 0xd91b, 0xe10a, 0xe84d, 0xf11a,
	// Entry 100 - 13F
	0xf522, 0xf921, 0x0120, 0x0923, 0x1127, 0x192a, 0x2022, 0x2926,
	0x3129, 0x3725, 0x391d, 0x3d2b, 0x412f, 0x492e, 0x4ec0, 0x5517,
	0x646a, 0x7479, 0x7e7d, 0x809d, 0x8296, 0x852d, 0x9132, 0xa53a,
	0xac36, 0xb533, 0xb934, 0xbd38, 0xd93d, 0xe53f, 0xed5b, 0xef5b,
	0xf656, 0xfd5f, 0x7c1f, 0x7ef2, 0x80f3, 0x82f4, 0x84f5, 0x86f6,
	0x88f7, 0x8af8, 0x8cf9, 0x8e6f, 0x90fb, 0x92fc, 0x94fd, 0x96fe,
	0x98ff, 0x9b40, 0x9d41, 0x9f42, 0xa143, 0xa344, 0xa545, 0xa746,
	0xa947, 0xab48, 0xad49, 0xaf4a, 0xb14b, 0xb34c, 0xb54d, 0xb74e,
	// Entry 140 - 17F
	0xb94f, 0xbb50, 0xbd51, 0xbf52, 0xc153, 0xc354, 0xc555, 0xc756,
	0xc957, 0xcb58, 0xcd59, 0xcf62,
}

// Size: 1311 bytes
var variantIndex = map[string]uint8{
	"1606nict": 0x0,
	"1694acad": 0x1,
	"1901":     0x2,
	"1959acad": 0x3,
	"1994":     0x3f,
	"1996":     0x4,
	"alalc97":  0x41,
	"aluku":    0x5,
	"arevela":  0x6,
	"arevmda":  0x7,
	"baku1926": 0x8,
	"balanka":  0x9,
	"barla":    0xa,
	"bauddha":  0xb,
	"biscayan": 0xc,
	"biske":    0x3a,
	"bohoric":  0xd,
	"boont":    0xe,
	"dajnko":   0xf,
	"ekavsk":   0x10,
	"emodeng":  0x11,
	"fonipa":   0x42,
	"fonupa":   0x43,
	"fonxsamp": 0x44,
	"hepburn":  0x12,
	"heploc":   0x40,
	"hognorsk": 0x13,
	"ijekavsk": 0x14,
	"itihasa":  0x15,
	"jauer":    0x16,
	"jyutping": 0x17,
	"kkcor":    0x18,
	"kociewie": 0x19,
	"kscor":    0x1a,
	"laukika":  0x1b,
	"lipaw":    0x3b,
	"luna1918": 0x1c,
	"metelko":  0x1d,
	"monoton":  0x1e,
	"ndyuka":   0x1f,
	"nedis":    0x20,
	"njiva":    0x3c,
	"nulik":    0x21,
	"osojs":    0x3d,
	"oxendict": 0x22,
	"pamaka":   0x23,
	"petr1708": 0x24,
	"pinyin":   0x25,
	"polyton":  0x26,
	"puter":    0x27,
	"rigik":    0x28,
	"rozaj":    0x29,
	"rumgr":    0x2a,
	"scotland": 0x2b,
	"scouse":   0x2c,
	"solba":    0x3e,
	"sotav":    0x2d,
	"surmiran": 0x2e,
	"sursilv":  0x2f,
	"sutsilv":  0x30,
	"tarask":   0x31,
	"uccor":    0x32,
	"ucrcor":   0x33,
	"ulster":   0x34,
	"unifon":   0x35,
	"vaidika":  0x36,
	"valencia": 0x37,
	"vallader": 0x38,
	"wadegile": 0x39,
}

// variantNumSpecialized is the number of specialized variants in variants.
const variantNumSpecialized = 65

// nRegionGroups is the number of region groups.
const nRegionGroups = 32

type likelyLangRegion struct {
	lang   uint16
	region uint16
}

// likelyScript is a lookup table, indexed by scriptID, for the most likely
// languages and regions given a script.
// Size: 900 bytes, 225 elements
var likelyScript = [225]likelyLangRegion{
	3:   {lang: 0x158, region: 0x104},
	4:   {lang: 0xc, region: 0x97},
	5:   {lang: 0x15, region: 0x6a},
	7:   {lang: 0x16, region: 0x9a},
	8:   {lang: 0xf2, region: 0x27},
	9:   {lang: 0x8, region: 0x9a},
	10:  {lang: 0x27, region: 0x93},
	11:  {lang: 0x2b, region: 0x51},
	12:  {lang: 0x55, region: 0xb2},
	13:  {lang: 0x2c, region: 0x93},
	14:  {lang: 0x4b, region: 0x34},
	16:  {lang: 0x2c0, region: 0x12c},
	17:  {lang: 0x1e3, region: 0x97},
	18:  {lang: 0xae, region: 0x76},
	19:  {lang: 0x5b, region: 0x93},
	20:  {lang: 0x47, region: 0xe5},
	21:  {lang: 0x63, region: 0x34},
	22:  {lang: 0x73, region: 0x48},
	23:  {lang: 0x2a5, region: 0x129},
	24:  {lang: 0x6e, region: 0x13b},
	25:  {lang: 0x6c, region: 0x132},
	27:  {lang: 0x71, region: 0x6a},
	28:  {lang: 0xcf, region: 0x5c},
	29:  {lang: 0x205, region: 0x104},
	31:  {lang: 0xe0, region: 0x97},
	33:  {lang: 0xae, region: 0x76},
	36:  {lang: 0x97, region: 0x6a},
	37:  {lang: 0x238, region: 0x26},
	38:  {lang: 0x11, region: 0x6e},
	40:  {lang: 0x110, region: 0x7b},
	41:  {lang: 0x7d, region: 0x37},
	42:  {lang: 0xce, region: 0x12e},
	43:  {lang: 0x20b, region: 0x97},
	44:  {lang: 0x99, region: 0x85},
	45:  {lang: 0xd2, region: 0x97},
	46:  {lang: 0x1d5, region: 0x97},
	47:  {lang: 0x135, region: 0xa9},
	48:  {lang: 0x2c0, region: 0x52},
	49:  {lang: 0xe8, region: 0xe5},
	50:  {lang: 0x2c0, region: 0x52},
	51:  {lang: 0x2c0, region: 0x12c},
	52:  {lang: 0x18a, region: 0x99},
	53:  {lang: 0xdf, region: 0x95},
	54:  {lang: 0x106, region: 0xa0},
	55:  {lang: 0xe3, region: 0x129},
	56:  {lang: 0xe7, region: 0xad},
	58:  {lang: 0xf1, region: 0x90},
	60:  {lang: 0x9f, region: 0x9c},
	61:  {lang: 0x10e, region: 0x93},
	62:  {lang: 0x106, region: 0xa0},
	64:  {lang: 0x98, region: 0xc2},
	65:  {lang: 0x106, region: 0xa0},
	66:  {lang: 0x1e9, region: 0xe6},
	67:  {lang: 0x132, region: 0xa4},
	68:  {lang: 0x218, region: 0x97},
	71:  {lang: 0x134, region: 0x97},
	72:  {lang: 0x135, region: 0xa9},
	74:  {lang: 0x3c, region: 0x97},
	75:  {lang: 0x1c1, region: 0x121},
	76:  {lang: 0x164, region: 0xad},
	80:  {lang: 0x157, region: 0x97},
	81:  {lang: 0x15b, region: 0x97},
	82:  {lang: 0x14e, region: 0x85},
	83:  {lang: 0xcf, region: 0x85},
	84:  {lang: 0x15d, region: 0x52},
	86:  {lang: 0x2a7, region: 0x129},
	87:  {lang: 0x2a8, region: 0x129},
	88:  {lang: 0xe0, region: 0x97},
	89:  {lang: 0x1a7, region: 0x9a},
	90:  {lang: 0x2aa, region: 0x52},
	93:  {lang: 0x17e, region: 0x110},
	94:  {lang: 0x2ab, region: 0x109},
	95:  {lang: 0x2ab, region: 0x109},
	96:  {lang: 0x18c, region: 0x97},
	97:  {lang: 0x195, region: 0x97},
	98:  {lang: 0x18e, region: 0x52},
	100: {lang: 0x198, region: 0x34},
	101: {lang: 0x18f, region: 0x97},
	102: {lang: 0x229, region: 0xe6},
	103: {lang: 0x1a4, region: 0xc2},
	104: {lang: 0x2ac, region: 0x106},
	105: {lang: 0x16, region: 0x9f},
	107: {lang: 0x178, region: 0x82},
	109: {lang: 0x221, region: 0x94},
	110: {lang: 0x210, region: 0x97},
	111: {lang: 0x1d4, region: 0xc3},
	112: {lang: 0x1d2, region: 0x97},
	114: {lang: 0x236, region: 0x113},
	115: {lang: 0x16, region: 0x11a},
	116: {lang: 0x7c, region: 0xc2},
	117: {lang: 0x146, region: 0x104},
	118: {lang: 0x171, region: 0x52},
	119: {lang: 0x1d7, region: 0x9a},
	120: {lang: 0x1d7, region: 0x52},
	122: {lang: 0x1e1, region: 0xae},
	123: {lang: 0xe4, region: 0x52},
	124: {lang: 0x2af, region: 0x9a},
	175: {lang: 0x1f4, region: 0x93},
	177: {lang: 0x1c3, region: 0x10a},
	178: {lang: 0x232, region: 0x95},
	180: {lang: 0x2b0, region: 0x15b},
	181: {lang: 0x211, region: 0x97},
	182: {lang: 0x1e, region: 0x132},
	183: {lang: 0x9a, region: 0x79},
	184: {lang: 0x20b, region: 0x97},
	185: {lang: 0x20b, region: 0x97},
	186: {lang: 0x218, region: 0x97},
	187: {lang: 0x226, region: 0xb1},
	188: {lang: 0x23a, region: 0x97},
	189: {lang: 0x242, region: 0x93},
	190: {lang: 0x24c, region: 0x34},
	191: {lang: 0x24d, region: 0x99},
	195: {lang: 0x251, region: 0xe5},
	196: {lang: 0x8a, region: 0x97},
	197: {lang: 0x253, region: 0x52},
	198: {lang: 0x125, region: 0x52},
	199: {lang: 0x24f, region: 0x97},
	201: {lang: 0x48, region: 0x13b},
	202: {lang: 0x256, region: 0x97},
	204: {lang: 0x2bf, region: 0xb8},
	205: {lang: 0xa9, region: 0xe5},
	206: {lang: 0x8f, region: 0xcb},
	207: {lang: 0x25b, region: 0x121},
	208: {lang: 0x4c, region: 0x52},
	209: {lang: 0x176, region: 0x97},
	210: {lang: 0x282, region: 0x11a},
	211: {lang: 0x28b, region: 0xb2},
	213: {lang: 0xeb, region: 0x97},
	215: {lang: 0x1df, region: 0x9a},
	216: {lang: 0xe, region: 0x99},
	217: {lang: 0xfa, region: 0x52},
}

type likelyScriptRegion struct {
	region uint16
	script uint8
	flags  uint8
}

// likelyLang is a lookup table, indexed by langID, for the most likely
// scripts and regions given incomplete information. If more entries exist for a
// given language, region and script are the index and size respectively
// of the list in likelyLangList.
// Size: 2836 bytes, 709 elements
var likelyLang = [709]likelyScriptRegion{
	0:   {region: 0x132, script: 0x4f, flags: 0x0},
	1:   {region: 0x6e, script: 0x4f, flags: 0x0},
	2:   {region: 0x7b, script: 0x1d, flags: 0x0},
	3:   {region: 0x7e, script: 0x4f, flags: 0x0},
	4:   {region: 0x93, script: 0x4f, flags: 0x0},
	5:   {region: 0x12f, script: 0x4f, flags: 0x0},
	6:   {region: 0x7e, script: 0x4f, flags: 0x0},
	7:   {region: 0x104, script: 0x1d, flags: 0x0},
	8:   {region: 0x9a, script: 0x9, flags: 0x0},
	9:   {region: 0x126, script: 0x5, flags: 0x0},
	10:  {region: 0x15e, script: 0x4f, flags: 0x0},
	11:  {region: 0x51, script: 0x4f, flags: 0x0},
	12:  {region: 0x97, script: 0x4, flags: 0x0},
	13:  {region: 0x7e, script: 0x4f, flags: 0x0},
	14:  {region: 0x99, script: 0xd8, flags: 0x0},
	15:  {region: 0x14a, script: 0x4f, flags: 0x0},
	16:  {region: 0x104, script: 0x1d, flags: 0x0},
	17:  {region: 0x6e, script: 0x26, flags: 0x0},
	18:  {region: 0xd4, script: 0x4f, flags: 0x0},
	20:  {region: 0x93, script: 0x4f, flags: 0x0},
	21:  {region: 0x6a, script: 0x5, flags: 0x0},
	22:  {region: 0x0, script: 0x3, flags: 0x1},
	23:  {region: 0x50, script: 0x4f, flags: 0x0},
	24:  {region: 0x3e, script: 0x4f, flags: 0x0},
	25:  {region: 0x66, script: 0x5, flags: 0x0},
	26:  {region: 0xb8, script: 0x5, flags: 0x0},
	27:  {region: 0x6a, script: 0x5, flags: 0x0},
	28:  {region: 0x97, script: 0xe, flags: 0x0},
	29:  {region: 0x12d, script: 0x4f, flags: 0x0},
	30:  {region: 0x132, script: 0xb6, flags: 0x0},
	31:  {region: 0x6d, script: 0x4f, flags: 0x0},
	32:  {region: 0x48, script: 0x4f, flags: 0x0},
	33:  {region: 0x104, script: 0x1d, flags: 0x0},
	34:  {region: 0x97, script: 0x1f, flags: 0x0},
	35:  {region: 0x3e, script: 0x4f, flags: 0x0},
	36:  {region: 0x3, script: 0x5, flags: 0x1},
	37:  {region: 0x104, script: 0x1d, flags: 0x0},
	38:  {region: 0xe6, script: 0x5, flags: 0x0},
	39:  {region: 0x93, script: 0x4f, flags: 0x0},
	40:  {region: 0xd9, script: 0x1f, flags: 0x0},
	41:  {region: 0x2d, script: 0x4f, flags: 0x0},
	42:  {region: 0x51, script: 0x4f, flags: 0x0},
	43:  {region: 0x51, script: 0xb, flags: 0x0},
	44:  {region: 0x93, script: 0x4f, flags: 0x0},
	45:  {region: 0x51, script: 0x4f, flags: 0x0},
	46:  {region: 0x4e, script: 0x4f, flags: 0x0},
	47:  {region: 0x46, script: 0x1d, flags: 0x0},
	48:  {region: 0x109, script: 0x5, flags: 0x0},
	49:  {region: 0x15f, script: 0x4f, flags: 0x0},
	50:  {region: 0x93, script: 0x4f, flags: 0x0},
	51:  {region: 0x12d, script: 0x4f, flags: 0x0},
	52:  {region: 0x51, script: 0x4f, flags: 0x0},
	53:  {region: 0x97, script: 0xc7, flags: 0x0},
	54:  {region: 0xe6, script: 0x5, flags: 0x0},
	55:  {region: 0x97, script: 0x1f, flags: 0x0},
	56:  {region: 0x37, script: 0x1d, flags: 0x0},
	57:  {region: 0x97, script: 0x1f, flags: 0x0},
	58:  {region: 0xe6, script: 0x5, flags: 0x0},
	59:  {region: 0x129, script: 0x2c, flags: 0x0},
	60:  {region: 0x97, script: 0x4a, flags: 0x0},
	61:  {region: 0x97, script: 0x1f, flags: 0x0},
	62:  {region: 0x97, script: 0x1f, flags: 0x0},
	63:  {region: 0xe5, script: 0x4f, flags: 0x0},
	64:  {region: 0x97, script: 0x1f, flags: 0x0},
	65:  {region: 0x13c, script: 0x4f, flags: 0x0},
	66:  {region: 0xe5, script: 0x4f, flags: 0x0},
	67:  {region: 0xd4, script: 0x4f, flags: 0x0},
	68:  {region: 0x97, script: 0x1f, flags: 0x0},
	69:  {region: 0x93, script: 0x4f, flags: 0x0},
	70:  {region: 0x51, script: 0x4f, flags: 0x0},
	71:  {region: 0xe5, script: 0x4f, flags: 0x0},
	72:  {region: 0x13b, script: 0xc9, flags: 0x0},
	73:  {region: 0xc1, script: 0x4f, flags: 0x0},
	74:  {region: 0xc1, script: 0x4f, flags: 0x0},
	75:  {region: 0x34, script: 0xe, flags: 0x0},
	76:  {region: 0x52, script: 0xd0, flags: 0x0},
	77:  {region: 0x97, script: 0xe, flags: 0x0},
	78:  {region: 0x9a, script: 0x5, flags: 0x0},
	79:  {region: 0x4e, script: 0x4f, flags: 0x0},
	80:  {region: 0x76, script: 0x4f, flags: 0x0},
	81:  {region: 0x97, script: 0x1f, flags: 0x0},
	82:  {region: 0xe6, script: 0x5, flags: 0x0},
	83:  {region: 0x97, script: 0x1f, flags: 0x0},
	84:  {region: 0x32, script: 0x4f, flags: 0x0},
	85:  {region: 0xb2, script: 0xc, flags: 0x0},
	86:  {region: 0x51, script: 0x4f, flags: 0x0},
	87:  {region: 0xe5, script: 0x4f, flags: 0x0},
	88:  {region: 0xe6, script: 0x1f, flags: 0x0},
	89:  {region: 0x104, script: 0x1d, flags: 0x0},
	90:  {region: 0x15c, script: 0x4f, flags: 0x0},
	91:  {region: 0x93, script: 0x4f, flags: 0x0},
	92:  {region: 0x51, script: 0x4f, flags: 0x0},
	93:  {region: 0x84, script: 0x4f, flags: 0x0},
	94:  {region: 0x6c, script: 0x26, flags: 0x0},
	95:  {region: 0x51, script: 0x4f, flags: 0x0},
	96:  {region: 0xc1, script: 0x4f, flags: 0x0},
	97:  {region: 0x6d, script: 0x4f, flags: 0x0},
	98:  {region: 0xd4, script: 0x4f, flags: 0x0},
	99:  {region: 0x8, script: 0x2, flags: 0x1},
	100: {region: 0x104, script: 0x1d, flags: 0x0},
	101: {region: 0xe5, script: 0x4f, flags: 0x0},
	102: {region: 0x12f, script: 0x4f, flags: 0x0},
	103: {region: 0x88, script: 0x4f, flags: 0x0},
	104: {region: 0x73, script: 0x4f, flags: 0x0},
	105: {region: 0x104, script: 0x1d, flags: 0x0},
	106: {region: 0x132, script: 0x4f, flags: 0x0},
	107: {region: 0x48, script: 0x4f, flags: 0x0},
	108: {region: 0x132, script: 0x19, flags: 0x0},
	109: {region: 0xa4, script: 0x5, flags: 0x0},
	110: {region: 0x13b, script: 0x18, flags: 0x0},
	111: {region: 0x99, script: 0x5, flags: 0x0},
	112: {region: 0x76, script: 0x4f, flags: 0x0},
	113: {region: 0x6a, script: 0x1b, flags: 0x0},
	114: {region: 0xe5, script: 0x4f, flags: 0x0},
	115: {region: 0x48, script: 0x16, flags: 0x0},
	116: {region: 0x48, script: 0x16, flags: 0x0},
	117: {region: 0x48, script: 0x16, flags: 0x0},
	118: {region: 0x48, script: 0x16, flags: 0x0},
	119: {region: 0x48, script: 0x16, flags: 0x0},
	120: {region: 0x108, script: 0x4f, flags: 0x0},
	121: {region: 0x5d, script: 0x4f, flags: 0x0},
	122: {region: 0xe7, script: 0x4f, flags: 0x0},
	123: {region: 0x48, script: 0x16, flags: 0x0},
	124: {region: 0xc2, script: 0x74, flags: 0x0},
	125: {region: 0xa, script: 0x2, flags: 0x1},
	126: {region: 0x104, script: 0x1d, flags: 0x0},
	127: {region: 0x79, script: 0x4f, flags: 0x0},
	128: {region: 0x62, script: 0x4f, flags: 0x0},
	129: {region: 0x132, script: 0x4f, flags: 0x0},
	130: {region: 0x104, script: 0x1d, flags: 0x0},
	131: {region: 0xa2, script: 0x4f, flags: 0x0},
	132: {region: 0x97, script: 0x5, flags: 0x0},
	133: {region: 0x5f, script: 0x4f, flags: 0x0},
	134: {region: 0x48, script: 0x4f, flags: 0x0},
	135: {region: 0x48, script: 0x4f, flags: 0x0},
	136: {region: 0xd2, script: 0x4f, flags: 0x0},
	137: {region: 0x4e, script: 0x4f, flags: 0x0},
	138: {region: 0x97, script: 0x5, flags: 0x0},
	139: {region: 0x5f, script: 0x4f, flags: 0x0},
	140: {region: 0xc1, script: 0x4f, flags: 0x0},
	141: {region: 0xce, script: 0x4f, flags: 0x0},
	142: {region: 0x51, script: 0x4f, flags: 0x0},
	143: {region: 0xcb, script: 0xce, flags: 0x0},
	144: {region: 0x112, script: 0x4f, flags: 0x0},
	145: {region: 0x36, script: 0x4f, flags: 0x0},
	146: {region: 0x42, script: 0xd0, flags: 0x0},
	147: {region: 0xa2, script: 0x4f, flags: 0x0},
	148: {region: 0x7e, script: 0x4f, flags: 0x0},
	149: {region: 0xd4, script: 0x4f, flags: 0x0},
	150: {region: 0x9c, script: 0x4f, flags: 0x0},
	151: {region: 0x6a, script: 0x24, flags: 0x0},
	152: {region: 0xc2, script: 0x40, flags: 0x0},
	153: {region: 0x85, script: 0x2c, flags: 0x0},
	154: {region: 0xc, script: 0x2, flags: 0x1},
	155: {region: 0x1, script: 0x4f, flags: 0x0},
	156: {region: 0x6d, script: 0x4f, flags: 0x0},
	157: {region: 0x132, script: 0x4f, flags: 0x0},
	158: {region: 0x69, script: 0x4f, flags: 0x0},
	159: {region: 0x9c, script: 0x3c, flags: 0x0},
	160: {region: 0x6d, script: 0x4f, flags: 0x0},
	161: {region: 0x51, script: 0x4f, flags: 0x0},
	162: {region: 0x6d, script: 0x4f, flags: 0x0},
	163: {region: 0x9a, script: 0x5, flags: 0x0},
	164: {region: 0x84, script: 0x4f, flags: 0x0},
	165: {region: 0x112, script: 0x4f, flags: 0x0},
	166: {region: 0xc1, script: 0x4f, flags: 0x0},
	167: {region: 0x70, script: 0x4f, flags: 0x0},
	168: {region: 0x109, script: 0x5, flags: 0x0},
	169: {region: 0xe5, script: 0x4f, flags: 0x0},
	170: {region: 0x10a, script: 0x4f, flags: 0x0},
	171: {region: 0x71, script: 0x4f, flags: 0x0},
	172: {region: 0x74, script: 0x4f, flags: 0x0},
	173: {region: 0x3a, script: 0x4f, flags: 0x0},
	174: {region: 0x76, script: 0x4f, flags: 0x0},
	175: {region: 0x132, script: 0x4f, flags: 0x0},
	176: {region: 0x76, script: 0x4f, flags: 0x0},
	177: {region: 0x5f, script: 0x4f, flags: 0x0},
	178: {region: 0x5f, script: 0x4f, flags: 0x0},
	179: {region: 0x13d, script: 0x4f, flags: 0x0},
	180: {region: 0xd2, script: 0x4f, flags: 0x0},
	181: {region: 0x9c, script: 0x4f, flags: 0x0},
	182: {region: 0xd4, script: 0x4f, flags: 0x0},
	183: {region: 0x109, script: 0x4f, flags: 0x0},
	184: {region: 0xd7, script: 0x4f, flags: 0x0},
	185: {region: 0x94, script: 0x4f, flags: 0x0},
	186: {region: 0x7e, script: 0x4f, flags: 0x0},
	187: {region: 0xba, script: 0x4f, flags: 0x0},
	188: {region: 0x52, script: 0x32, flags: 0x0},
	189: {region: 0x93, script: 0x4f, flags: 0x0},
	190: {region: 0x97, script: 0x1f, flags: 0x0},
	191: {region: 0x9a, script: 0x5, flags: 0x0},
	192: {region: 0x7c, script: 0x4f, flags: 0x0},
	193: {region: 0x79, script: 0x4f, flags: 0x0},
	194: {region: 0x6e, script: 0x26, flags: 0x0},
	195: {region: 0xd9, script: 0x1f, flags: 0x0},
	196: {region: 0xa5, script: 0x4f, flags: 0x0},
	197: {region: 0xe6, script: 0x5, flags: 0x0},
	198: {region: 0xe6, script: 0x5, flags: 0x0},
	199: {region: 0x6d, script: 0x4f, flags: 0x0},
	200: {region: 0x9a, script: 0x5, flags: 0x0},
	201: {region: 0xef, script: 0x4f, flags: 0x0},
	202: {region: 0x97, script: 0x1f, flags: 0x0},
	203: {region: 0x97, script: 0xca, flags: 0x0},
	204: {region: 0x93, script: 0x4f, flags: 0x0},
	205: {region: 0xd7, script: 0x4f, flags: 0x0},
	206: {region: 0x12e, script: 0x2a, flags: 0x0},
	207: {region: 0xe, script: 0x2, flags: 0x1},
	208: {region: 0x97, script: 0xe, flags: 0x0},
	209: {region: 0x4d, script: 0x4f, flags: 0x0},
	210: {region: 0x97, script: 0x2d, flags: 0x0},
	211: {region: 0x40, script: 0x4f, flags: 0x0},
	212: {region: 0x53, script: 0x4f, flags: 0x0},
	213: {region: 0x7e, script: 0x4f, flags: 0x0},
	215: {region: 0xa2, script: 0x4f, flags: 0x0},
	216: {region: 0x96, script: 0x4f, flags: 0x0},
	217: {region: 0xd9, script: 0x1f, flags: 0x0},
	218: {region: 0x48, script: 0x4f, flags: 0x0},
	219: {region: 0x10, script: 0x3, flags: 0x1},
	220: {region: 0x52, script: 0x32, flags: 0x0},
	221: {region: 0x132, script: 0x4f, flags: 0x0},
	222: {region: 0x23, script: 0x5, flags: 0x0},
	223: {region: 0x95, script: 0x35, flags: 0x0},
	224: {region: 0x97, script: 0x1f, flags: 0x0},
	225: {region: 0x71, script: 0x4f, flags: 0x0},
	226: {region: 0xe5, script: 0x4f, flags: 0x0},
	227: {region: 0x129, script: 0x37, flags: 0x0},
	228: {region: 0x52, script: 0x7b, flags: 0x0},
	229: {region: 0xe6, script: 0x5, flags: 0x0},
	230: {region: 0x97, script: 0x1f, flags: 0x0},
	231: {region: 0xad, script: 0x38, flags: 0x0},
	232: {region: 0xe5, script: 0x4f, flags: 0x0},
	233: {region: 0xe6, script: 0x5, flags: 0x0},
	234: {region: 0xe4, script: 0x4f, flags: 0x0},
	235: {region: 0x97, script: 0x1f, flags: 0x0},
	236: {region: 0x97, script: 0x1f, flags: 0x0},
	237: {region: 0x8e, script: 0x4f, flags: 0x0},
	238: {region: 0x5f, script: 0x4f, flags: 0x0},
	239: {region: 0x52, script: 0x32, flags: 0x0},
	240: {region: 0x8f, script: 0x4f, flags: 0x0},
	241: {region: 0x90, script: 0x4f, flags: 0x0},
	242: {region: 0x27, script: 0x8, flags: 0x0},
	243: {region: 0xd0, script: 0x4f, flags: 0x0},
	244: {region: 0x76, script: 0x4f, flags: 0x0},
	245: {region: 0xce, script: 0x4f, flags: 0x0},
	246: {region: 0xd4, script: 0x4f, flags: 0x0},
	247: {region: 0x93, script: 0x4f, flags: 0x0},
	249: {region: 0xd4, script: 0x4f, flags: 0x0},
	250: {region: 0x52, script: 0xd9, flags: 0x0},
	251: {region: 0x132, script: 0x4f, flags: 0x0},
	252: {region: 0x48, script: 0x4f, flags: 0x0},
	253: {region: 0xe5, script: 0x4f, flags: 0x0},
	254: {region: 0x93, script: 0x4f, flags: 0x0},
	255: {region: 0x104, script: 0x1d, flags: 0x0},
	257: {region: 0x9b, script: 0x4f, flags: 0x0},
	258: {region: 0x9c, script: 0x4f, flags: 0x0},
	259: {region: 0x48, script: 0x16, flags: 0x0},
	260: {region: 0x95, script: 0x35, flags: 0x0},
	261: {region: 0x104, script: 0x4f, flags: 0x0},
	262: {region: 0xa0, script: 0x3e, flags: 0x0},
	263: {region: 0x9e, script: 0x4f, flags: 0x0},
	265: {region: 0x51, script: 0x4f, flags: 0x0},
	266: {region: 0x12e, script: 0x35, flags: 0x0},
	267: {region: 0x12d, script: 0x4f, flags: 0x0},
	268: {region: 0xd9, script: 0x1f, flags: 0x0},
	269: {region: 0x62, script: 0x4f, flags: 0x0},
	270: {region: 0x93, script: 0x4f, flags: 0x0},
	271: {region: 0x93, script: 0x4f, flags: 0x0},
	272: {region: 0x7b, script: 0x28, flags: 0x0},
	273: {region: 0x134, script: 0x1d, flags: 0x0},
	274: {region: 0x66, script: 0x4f, flags: 0x0},
	275: {region: 0xc2, script: 0x4f, flags: 0x0},
	276: {region: 0xd4, script: 0x4f, flags: 0x0},
	277: {region: 0xa2, script: 0x4f, flags: 0x0},
	278: {region: 0xc1, script: 0x4f, flags: 0x0},
	279: {region: 0x104, script: 0x1d, flags: 0x0},
	280: {region: 0xd4, script: 0x4f, flags: 0x0},
	281: {region: 0x161, script: 0x4f, flags: 0x0},
	282: {region: 0x12d, script: 0x4f, flags: 0x0},
	283: {region: 0x121, script: 0xcf, flags: 0x0},
	284: {region: 0x59, script: 0x4f, flags: 0x0},
	285: {region: 0x51, script: 0x4f, flags: 0x0},
	286: {region: 0x4e, script: 0x4f, flags: 0x0},
	287: {region: 0x97, script: 0x1f, flags: 0x0},
	288: {region: 0x97, script: 0x1f, flags: 0x0},
	289: {region: 0x4a, script: 0x4f, flags: 0x0},
	290: {region: 0x93, script: 0x4f, flags: 0x0},
	291: {region: 0x40, script: 0x4f, flags: 0x0},
	292: {region: 0x97, script: 0x4f, flags: 0x0},
	293: {region: 0x52, script: 0xc6, flags: 0x0},
	294: {region: 0x97, script: 0x1f, flags: 0x0},
	295: {region: 0xc1, script: 0x4f, flags: 0x0},
	296: {region: 0x97, script: 0x67, flags: 0x0},
	297: {region: 0xe6, script: 0x5, flags: 0x0},
	298: {region: 0xa2, script: 0x4f, flags: 0x0},
	299: {region: 0x129, script: 0x4f, flags: 0x0},
	300: {region: 0xd0, script: 0x4f, flags: 0x0},
	301: {region: 0xad, script: 0x4c, flags: 0x0},
	302: {region: 0x13, script: 0x6, flags: 0x1},
	303: {region: 0x51, script: 0x4f, flags: 0x0},
	304: {region: 0x80, script: 0x4f, flags: 0x0},
	305: {region: 0xa2, script: 0x4f, flags: 0x0},
	306: {region: 0xa4, script: 0x43, flags: 0x0},
	307: {region: 0x29, script: 0x4f, flags: 0x0},
	308: {region: 0x97, script: 0x47, flags: 0x0},
	309: {region: 0xa9, script: 0x48, flags: 0x0},
	310: {region: 0x104, script: 0x1d, flags: 0x0},
	311: {region: 0x97, script: 0x1f, flags: 0x0},
	312: {region: 0x73, script: 0x4f, flags: 0x0},
	313: {region: 0xb2, script: 0x4f, flags: 0x0},
	315: {region: 0x104, script: 0x1d, flags: 0x0},
	316: {region: 0x110, script: 0x4f, flags: 0x0},
	317: {region: 0xe5, script: 0x4f, flags: 0x0},
	318: {region: 0x104, script: 0x4f, flags: 0x0},
	319: {region: 0x97, script: 0x1f, flags: 0x0},
	320: {region: 0x97, script: 0x5, flags: 0x0},
	321: {region: 0x12d, script: 0x4f, flags: 0x0},
	322: {region: 0x51, script: 0x4f, flags: 0x0},
	323: {region: 0x5f, script: 0x4f, flags: 0x0},
	324: {region: 0x19, script: 0x3, flags: 0x1},
	325: {region: 0x104, script: 0x1d, flags: 0x0},
	326: {region: 0x104, script: 0x1d, flags: 0x0},
	327: {region: 0x93, script: 0x4f, flags: 0x0},
	328: {region: 0xe6, script: 0x5, flags: 0x0},
	329: {region: 0x79, script: 0x4f, flags: 0x0},
	330: {region: 0x121, script: 0xcf, flags: 0x0},
	331: {region: 0xe6, script: 0x5, flags: 0x0},
	332: {region: 0x1c, script: 0x5, flags: 0x1},
	333: {region: 0x135, script: 0x4f, flags: 0x0},
	334: {region: 0x85, script: 0x52, flags: 0x0},
	335: {region: 0x95, script: 0x35, flags: 0x0},
	336: {region: 0x12d, script: 0x4f, flags: 0x0},
	337: {region: 0xe6, script: 0x5, flags: 0x0},
	338: {region: 0x12f, script: 0x4f, flags: 0x0},
	339: {region: 0xb5, script: 0x4f, flags: 0x0},
	340: {region: 0x104, script: 0x1d, flags: 0x0},
	341: {region: 0x93, script: 0x4f, flags: 0x0},
	342: {region: 0x52, script: 0xcf, flags: 0x0},
	343: {region: 0x97, script: 0x50, flags: 0x0},
	344: {region: 0x104, script: 0x1d, flags: 0x0},
	345: {region: 0x12f, script: 0x4f, flags: 0x0},
	346: {region: 0xd7, script: 0x4f, flags: 0x0},
	347: {region: 0x21, script: 0x2, flags: 0x1},
	348: {region: 0x9c, script: 0x4f, flags: 0x0},
	349: {region: 0x52, script: 0x54, flags: 0x0},
	350: {region: 0x93, script: 0x4f, flags: 0x0},
	351: {region: 0x9a, script: 0x5, flags: 0x0},
	352: {region: 0x132, script: 0x4f, flags: 0x0},
	353: {region: 0x97, script: 0xca, flags: 0x0},
	354: {region: 0x9c, script: 0x4f, flags: 0x0},
	355: {region: 0x4a, script: 0x4f, flags: 0x0},
	356: {region: 0xad, script: 0x4c, flags: 0x0},
	357: {region: 0x4a, script: 0x4f, flags: 0x0},
	358: {region: 0x15f, script: 0x4f, flags: 0x0},
	359: {region: 0x9a, script: 0x5, flags: 0x0},
	360: {region: 0xb4, script: 0x4f, flags: 0x0},
	361: {region: 0xb6, script: 0x4f, flags: 0x0},
	362: {region: 0x4a, script: 0x4f, flags: 0x0},
	363: {region: 0x4a, script: 0x4f, flags: 0x0},
	364: {region: 0xa2, script: 0x4f, flags: 0x0},
	365: {region: 0xa2, script: 0x4f, flags: 0x0},
	366: {region: 0x9a, script: 0x5, flags: 0x0},
	367: {region: 0xb6, script: 0x4f, flags: 0x0},
	368: {region: 0x121, script: 0xcf, flags: 0x0},
	369: {region: 0x52, script: 0x32, flags: 0x0},
	370: {region: 0x129, script: 0x4f, flags: 0x0},
	371: {region: 0x93, script: 0x4f, flags: 0x0},
	372: {region: 0x51, script: 0x4f, flags: 0x0},
	373: {region: 0x97, script: 0x1f, flags: 0x0},
	374: {region: 0x97, script: 0x1f, flags: 0x0},
	375: {region: 0x93, script: 0x4f, flags: 0x0},
	376: {region: 0x23, script: 0x3, flags: 0x1},
	377: {region: 0xa2, script: 0x4f, flags: 0x0},
	378: {region: 0xcd, script: 0x4f, flags: 0x0},
	379: {region: 0x104, script: 0x1d, flags: 0x0},
	380: {region: 0xe5, script: 0x4f, flags: 0x0},
	381: {region: 0x93, script: 0x4f, flags: 0x0},
	382: {region: 0x110, script: 0x4f, flags: 0x0},
	383: {region: 0xa2, script: 0x4f, flags: 0x0},
	384: {region: 0x121, script: 0x5, flags: 0x0},
	385: {region: 0xca, script: 0x4f, flags: 0x0},
	386: {region: 0xbd, script: 0x4f, flags: 0x0},
	387: {region: 0xcf, script: 0x4f, flags: 0x0},
	388: {region: 0x51, script: 0x4f, flags: 0x0},
	389: {region: 0xd9, script: 0x1f, flags: 0x0},
	390: {region: 0x12d, script: 0x4f, flags: 0x0},
	391: {region: 0xbe, script: 0x4f, flags: 0x0},
	392: {region: 0xde, script: 0x4f, flags: 0x0},
	393: {region: 0x93, script: 0x4f, flags: 0x0},
	394: {region: 0x99, script: 0x34, flags: 0x0},
	395: {region: 0xc0, script: 0x1d, flags: 0x0},
	396: {region: 0x97, script: 0x60, flags: 0x0},
	397: {region: 0x109, script: 0x4f, flags: 0x0},
	398: {region: 0x26, script: 0x3, flags: 0x1},
	399: {region: 0x97, script: 0xe, flags: 0x0},
	400: {region: 0xc2, script: 0x67, flags: 0x0},
	402: {region: 0x48, script: 0x4f, flags: 0x0},
	403: {region: 0x48, script: 0x4f, flags: 0x0},
	404: {region: 0x36, script: 0x4f, flags: 0x0},
	405: {region: 0x97, script: 0x1f, flags: 0x0},
	406: {region: 0xd9, script: 0x1f, flags: 0x0},
	407: {region: 0x104, script: 0x1d, flags: 0x0},
	408: {region: 0x34, script: 0x64, flags: 0x0},
	409: {region: 0x29, script: 0x3, flags: 0x1},
	410: {region: 0xc9, script: 0x4f, flags: 0x0},
	411: {region: 0x97, script: 0x1f, flags: 0x0},
	412: {region: 0x51, script: 0x4f, flags: 0x0},
	414: {region: 0x132, script: 0x4f, flags: 0x0},
	415: {region: 0xe6, script: 0x5, flags: 0x0},
	416: {region: 0xc1, script: 0x4f, flags: 0x0},
	417: {region: 0x97, script: 0x1f, flags: 0x0},
	418: {region: 0x93, script: 0x4f, flags: 0x0},
	419: {region: 0x161, script: 0x4f, flags: 0x0},
	420: {region: 0xc2, script: 0x67, flags: 0x0},
	421: {region: 0x104, script: 0x1d, flags: 0x0},
	422: {region: 0x12f, script: 0x4f, flags: 0x0},
	423: {region: 0x9a, script: 0x59, flags: 0x0},
	424: {region: 0x9a, script: 0x5, flags: 0x0},
	425: {region: 0xdb, script: 0x4f, flags: 0x0},
	427: {region: 0x52, script: 0x32, flags: 0x0},
	428: {region: 0x9c, script: 0x4f, flags: 0x0},
	429: {region: 0xd0, script: 0x4f, flags: 0x0},
	430: {region: 0xd8, script: 0x4f, flags: 0x0},
	431: {region: 0xcd, script: 0x4f, flags: 0x0},
	432: {region: 0x161, script: 0x4f, flags: 0x0},
	433: {region: 0xcf, script: 0x4f, flags: 0x0},
	434: {region: 0x5f, script: 0x4f, flags: 0x0},
	435: {region: 0xd9, script: 0x1f, flags: 0x0},
	436: {region: 0xd9, script: 0x1f, flags: 0x0},
	437: {region: 0xd0, script: 0x4f, flags: 0x0},
	438: {region: 0xcf, script: 0x4f, flags: 0x0},
	439: {region: 0xcd, script: 0x4f, flags: 0x0},
	440: {region: 0xcd, script: 0x4f, flags: 0x0},
	441: {region: 0x93, script: 0x4f, flags: 0x0},
	442: {region: 0xdd, script: 0x4f, flags: 0x0},
	443: {region: 0x97, script: 0x4f, flags: 0x0},
	444: {region: 0xd7, script: 0x4f, flags: 0x0},
	445: {region: 0x51, script: 0x4f, flags: 0x0},
	446: {region: 0xd8, script: 0x4f, flags: 0x0},
	447: {region: 0x51, script: 0x4f, flags: 0x0},
	448: {region: 0xd8, script: 0x4f, flags: 0x0},
	449: {region: 0x121, script: 0x4b, flags: 0x0},
	450: {region: 0x97, script: 0x1f, flags: 0x0},
	451: {region: 0x10a, script: 0xb1, flags: 0x0},
	452: {region: 0x82, script: 0x6b, flags: 0x0},
	453: {region: 0x15e, script: 0x4f, flags: 0x0},
	454: {region: 0x48, script: 0x16, flags: 0x0},
	455: {region: 0x15e, script: 0x4f, flags: 0x0},
	456: {region: 0x115, script: 0x4f, flags: 0x0},
	457: {region: 0x132, script: 0x4f, flags: 0x0},
	458: {region: 0x52, script: 0x4f, flags: 0x0},
	459: {region: 0xcc, script: 0x4f, flags: 0x0},
	460: {region: 0x12d, script: 0x4f, flags: 0x0},
	461: {region: 0x12f, script: 0x4f, flags: 0x0},
	462: {region: 0x7e, script: 0x4f, flags: 0x0},
	463: {region: 0x76, script: 0x4f, flags: 0x0},
	465: {region: 0x6e, script: 0x4f, flags: 0x0},
	466: {region: 0x97, script: 0x70, flags: 0x0},
	467: {region: 0x7b, script: 0x1d, flags: 0x0},
	468: {region: 0xc3, script: 0x6f, flags: 0x0},
	469: {region: 0x2c, script: 0x3, flags: 0x1},
	470: {region: 0xe5, script: 0x4f, flags: 0x0},
	471: {region: 0x2f, script: 0x2, flags: 0x1},
	472: {region: 0xe5, script: 0x4f, flags: 0x0},
	473: {region: 0x2f, script: 0x4f, flags: 0x0},
	474: {region: 0xee, script: 0x4f, flags: 0x0},
	475: {region: 0x76, script: 0x4f, flags: 0x0},
	476: {region: 0xd4, script: 0x4f, flags: 0x0},
	477: {region: 0x132, script: 0x4f, flags: 0x0},
	478: {region: 0x48, script: 0x4f, flags: 0x0},
	479: {region: 0x9a, script: 0xd7, flags: 0x0},
	480: {region: 0x5f, script: 0x4f, flags: 0x0},
	481: {region: 0xae, script: 0x7a, flags: 0x0},
	483: {region: 0x97, script: 0x11, flags: 0x0},
	484: {region: 0xa2, script: 0x4f, flags: 0x0},
	485: {region: 0xe7, script: 0x4f, flags: 0x0},
	486: {region: 0x9c, script: 0x4f, flags: 0x0},
	487: {region: 0x85, script: 0x2c, flags: 0x0},
	488: {region: 0x73, script: 0x4f, flags: 0x0},
	489: {region: 0xe6, script: 0x42, flags: 0x0},
	490: {region: 0x9a, script: 0x5, flags: 0x0},
	491: {region: 0x1, script: 0x4f, flags: 0x0},
	492: {region: 0x23, script: 0x5, flags: 0x0},
	493: {region: 0x40, script: 0x4f, flags: 0x0},
	494: {region: 0x78, script: 0x4f, flags: 0x0},
	495: {region: 0xe2, script: 0x4f, flags: 0x0},
	496: {region: 0x87, script: 0x4f, flags: 0x0},
	497: {region: 0x68, script: 0x4f, flags: 0x0},
	498: {region: 0x97, script: 0x1f, flags: 0x0},
	499: {region: 0x100, script: 0x4f, flags: 0x0},
	500: {region: 0x93, script: 0x4f, flags: 0x0},
	501: {region: 0x9c, script: 0x4f, flags: 0x0},
	502: {region: 0x97, script: 0x4f, flags: 0x0},
	503: {region: 0x31, script: 0x2, flags: 0x1},
	504: {region: 0xd9, script: 0x1f, flags: 0x0},
	505: {region: 0x34, script: 0xe, flags: 0x0},
	506: {region: 0x4d, script: 0x4f, flags: 0x0},
	507: {region: 0x70, script: 0x4f, flags: 0x0},
	508: {region: 0x4d, script: 0x4f, flags: 0x0},
	509: {region: 0x9a, script: 0x5, flags: 0x0},
	510: {region: 0x10a, script: 0x4f, flags: 0x0},
	511: {region: 0x39, script: 0x4f, flags: 0x0},
	512: {region: 0xcf, script: 0x4f, flags: 0x0},
	513: {region: 0x102, script: 0x4f, flags: 0x0},
	514: {region: 0x93, script: 0x4f, flags: 0x0},
	515: {region: 0x12d, script: 0x4f, flags: 0x0},
	516: {region: 0x71, script: 0x4f, flags: 0x0},
	517: {region: 0x104, script: 0x1d, flags: 0x0},
	518: {region: 0x12e, script: 0x1d, flags: 0x0},
	519: {region: 0x107, script: 0x4f, flags: 0x0},
	520: {region: 0x105, script: 0x4f, flags: 0x0},
	521: {region: 0x12d, script: 0x4f, flags: 0x0},
	522: {region: 0xa0, script: 0x41, flags: 0x0},
	523: {region: 0x97, script: 0x1f, flags: 0x0},
	524: {region: 0x7e, script: 0x4f, flags: 0x0},
	525: {region: 0x104, script: 0x1d, flags: 0x0},
	526: {region: 0xa2, script: 0x4f, flags: 0x0},
	527: {region: 0x93, script: 0x4f, flags: 0x0},
	528: {region: 0x97, script: 0x4f, flags: 0x0},
	529: {region: 0x97, script: 0xb5, flags: 0x0},
	530: {region: 0x12d, script: 0x4f, flags: 0x0},
	531: {region: 0x9c, script: 0x4f, flags: 0x0},
	532: {region: 0x97, script: 0x1f, flags: 0x0},
	533: {region: 0x9c, script: 0x4f, flags: 0x0},
	534: {region: 0x79, script: 0x4f, flags: 0x0},
	535: {region: 0x48, script: 0x4f, flags: 0x0},
	536: {region: 0x33, script: 0x4, flags: 0x1},
	537: {region: 0x9c, script: 0x4f, flags: 0x0},
	538: {region: 0x9a, script: 0x5, flags: 0x0},
	539: {region: 0xd8, script: 0x4f, flags: 0x0},
	540: {region: 0x4e, script: 0x4f, flags: 0x0},
	541: {region: 0xcf, script: 0x4f, flags: 0x0},
	542: {region: 0xcd, script: 0x4f, flags: 0x0},
	543: {region: 0xc1, script: 0x4f, flags: 0x0},
	544: {region: 0x4b, script: 0x4f, flags: 0x0},
	545: {region: 0x94, script: 0x6d, flags: 0x0},
	546: {region: 0xb4, script: 0x4f, flags: 0x0},
	548: {region: 0xb8, script: 0xcc, flags: 0x0},
	549: {region: 0xc2, script: 0x67, flags: 0x0},
	550: {region: 0xb1, script: 0xbb, flags: 0x0},
	551: {region: 0x6e, script: 0x4f, flags: 0x0},
	552: {region: 0x10f, script: 0x4f, flags: 0x0},
	553: {region: 0xe6, script: 0x5, flags: 0x0},
	554: {region: 0x10d, script: 0x4f, flags: 0x0},
	555: {region: 0xe7, script: 0x4f, flags: 0x0},
	556: {region: 0x93, script: 0x4f, flags: 0x0},
	557: {region: 0x13f, script: 0x4f, flags: 0x0},
	558: {region: 0x10a, script: 0x4f, flags: 0x0},
	560: {region: 0x10a, script: 0x4f, flags: 0x0},
	561: {region: 0x70, script: 0x4f, flags: 0x0},
	562: {region: 0x95, script: 0xb2, flags: 0x0},
	563: {region: 0x70, script: 0x4f, flags: 0x0},
	564: {region: 0x161, script: 0x4f, flags: 0x0},
	565: {region: 0xc1, script: 0x4f, flags: 0x0},
	566: {region: 0x113, script: 0x4f, flags: 0x0},
	567: {region: 0x121, script: 0xcf, flags: 0x0},
	568: {region: 0x26, script: 0x4f, flags: 0x0},
	569: {region: 0x37, script: 0x5, flags: 0x1},
	570: {region: 0x97, script: 0xbc, flags: 0x0},
	571: {region: 0x114, script: 0x4f, flags: 0x0},
	572: {region: 0x112, script: 0x4f, flags: 0x0},
	573: {region: 0x97, script: 0x1f, flags: 0x0},
	574: {region: 0x15e, script: 0x4f, flags: 0x0},
	575: {region: 0x6c, script: 0x4f, flags: 0x0},
	576: {region: 0x15e, script: 0x4f, flags: 0x0},
	577: {region: 0x5f, script: 0x4f, flags: 0x0},
	578: {region: 0x93, script: 0x4f, flags: 0x0},
	579: {region: 0x12d, script: 0x4f, flags: 0x0},
	580: {region: 0x82, script: 0x4f, flags: 0x0},
	581: {region: 0x10a, script: 0x4f, flags: 0x0},
	582: {region: 0x12d, script: 0x4f, flags: 0x0},
	583: {region: 0x15c, script: 0x5, flags: 0x0},
	584: {region: 0x4a, script: 0x4f, flags: 0x0},
	585: {region: 0x5f, script: 0x4f, flags: 0x0},
	586: {region: 0x97, script: 0x1f, flags: 0x0},
	587: {region: 0x93, script: 0x4f, flags: 0x0},
	588: {region: 0x34, script: 0xe, flags: 0x0},
	589: {region: 0x99, script: 0xbf, flags: 0x0},
	590: {region: 0xe7, script: 0x4f, flags: 0x0},
	591: {region: 0x97, script: 0xc7, flags: 0x0},
	592: {region: 0xd9, script: 0x1f, flags: 0x0},
	593: {region: 0xe5, script: 0x4f, flags: 0x0},
	594: {region: 0x97, script: 0x47, flags: 0x0},
	595: {region: 0x52, script: 0xc5, flags: 0x0},
	596: {region: 0xd9, script: 0x1f, flags: 0x0},
	597: {region: 0xd9, script: 0x1f, flags: 0x0},
	598: {region: 0x97, script: 0xca, flags: 0x0},
	599: {region: 0x110, script: 0x4f, flags: 0x0},
	600: {region: 0x12f, script: 0x4f, flags: 0x0},
	601: {region: 0x124, script: 0x4f, flags: 0x0},
	602: {region: 0x3c, script: 0x3, flags: 0x1},
	603: {region: 0x121, script: 0xcf, flags: 0x0},
	604: {region: 0xd9, script: 0x1f, flags: 0x0},
	605: {region: 0xd9, script: 0x1f, flags: 0x0},
	606: {region: 0xd9, script: 0x1f, flags: 0x0},
	607: {region: 0x6e, script: 0x26, flags: 0x0},
	608: {region: 0x6c, script: 0x26, flags: 0x0},
	609: {region: 0xd4, script: 0x4f, flags: 0x0},
	610: {region: 0x125, script: 0x4f, flags: 0x0},
	611: {region: 0x123, script: 0x4f, flags: 0x0},
	612: {region: 0x31, script: 0x4f, flags: 0x0},
	613: {region: 0xd9, script: 0x1f, flags: 0x0},
	614: {region: 0xe5, script: 0x4f, flags: 0x0},
	615: {region: 0x31, script: 0x4f, flags: 0x0},
	616: {region: 0xd2, script: 0x4f, flags: 0x0},
	617: {region: 0x15e, script: 0x4f, flags: 0x0},
	618: {region: 0x127, script: 0x4f, flags: 0x0},
	619: {region: 0xcc, script: 0x4f, flags: 0x0},
	620: {region: 0xe4, script: 0x4f, flags: 0x0},
	621: {region: 0x129, script: 0x4f, flags: 0x0},
	622: {region: 0x129, script: 0x4f, flags: 0x0},
	623: {region: 0x12c, script: 0x4f, flags: 0x0},
	624: {region: 0x15e, script: 0x4f, flags: 0x0},
	625: {region: 0x85, script: 0x2c, flags: 0x0},
	626: {region: 0xd9, script: 0x1f, flags: 0x0},
	627: {region: 0xe5, script: 0x4f, flags: 0x0},
	628: {region: 0x42, script: 0xd0, flags: 0x0},
	629: {region: 0x104, script: 0x1d, flags: 0x0},
	630: {region: 0x12f, script: 0x4f, flags: 0x0},
	631: {region: 0x121, script: 0xcf, flags: 0x0},
	632: {region: 0x31, script: 0x4f, flags: 0x0},
	633: {region: 0xcc, script: 0x4f, flags: 0x0},
	634: {region: 0x12b, script: 0x4f, flags: 0x0},
	636: {region: 0xd2, script: 0x4f, flags: 0x0},
	637: {region: 0xe3, script: 0x4f, flags: 0x0},
	638: {region: 0x104, script: 0x1d, flags: 0x0},
	639: {region: 0xb8, script: 0x4f, flags: 0x0},
	640: {region: 0x104, script: 0x1d, flags: 0x0},
	641: {region: 0x3f, script: 0x4, flags: 0x1},
	642: {region: 0x11a, script: 0xd2, flags: 0x0},
	643: {region: 0x12e, script: 0x1d, flags: 0x0},
	644: {region: 0x73, script: 0x4f, flags: 0x0},
	645: {region: 0x29, script: 0x4f, flags: 0x0},
	647: {region: 0x43, script: 0x3, flags: 0x1},
	648: {region: 0x97, script: 0xe, flags: 0x0},
	649: {region: 0xe6, script: 0x5, flags: 0x0},
	650: {region: 0x46, script: 0x4, flags: 0x1},
	651: {region: 0xb2, script: 0xd3, flags: 0x0},
	652: {region: 0x15e, script: 0x4f, flags: 0x0},
	653: {region: 0x9c, script: 0x4f, flags: 0x0},
	654: {region: 0x104, script: 0x4f, flags: 0x0},
	655: {region: 0x13b, script: 0x4f, flags: 0x0},
	656: {region: 0x119, script: 0x4f, flags: 0x0},
	657: {region: 0x35, script: 0x4f, flags: 0x0},
	658: {region: 0x5f, script: 0x4f, flags: 0x0},
	659: {region: 0xcf, script: 0x4f, flags: 0x0},
	660: {region: 0x1, script: 0x4f, flags: 0x0},
	661: {region: 0x104, script: 0x4f, flags: 0x0},
	662: {region: 0x69, script: 0x4f, flags: 0x0},
	663: {region: 0x12d, script: 0x4f, flags: 0x0},
	664: {region: 0x35, script: 0x4f, flags: 0x0},
	665: {region: 0x4d, script: 0x4f, flags: 0x0},
	666: {region: 0x6e, script: 0x26, flags: 0x0},
	667: {region: 0xe5, script: 0x4f, flags: 0x0},
	668: {region: 0x2e, script: 0x4f, flags: 0x0},
	669: {region: 0x97, script: 0xca, flags: 0x0},
	670: {region: 0x97, script: 0x1f, flags: 0x0},
	671: {region: 0x13d, script: 0x4f, flags: 0x0},
	672: {region: 0xa6, script: 0x5, flags: 0x0},
	673: {region: 0x112, script: 0x4f, flags: 0x0},
	674: {region: 0x97, script: 0x1f, flags: 0x0},
	675: {region: 0x52, script: 0x32, flags: 0x0},
	676: {region: 0x40, script: 0x4f, flags: 0x0},
	677: {region: 0x129, script: 0x17, flags: 0x0},
	678: {region: 0x15e, script: 0x4f, flags: 0x0},
	679: {region: 0x129, script: 0x56, flags: 0x0},
	680: {region: 0x129, script: 0x57, flags: 0x0},
	681: {region: 0x7b, script: 0x28, flags: 0x0},
	682: {region: 0x52, script: 0x5a, flags: 0x0},
	683: {region: 0x109, script: 0x5e, flags: 0x0},
	684: {region: 0x106, script: 0x68, flags: 0x0},
	685: {region: 0x97, script: 0x1f, flags: 0x0},
	686: {region: 0x12f, script: 0x4f, flags: 0x0},
	687: {region: 0x9a, script: 0x7c, flags: 0x0},
	688: {region: 0x15b, script: 0xb4, flags: 0x0},
	689: {region: 0xd9, script: 0x1f, flags: 0x0},
	690: {region: 0xcf, script: 0x4f, flags: 0x0},
	691: {region: 0x73, script: 0x4f, flags: 0x0},
	692: {region: 0x51, script: 0x4f, flags: 0x0},
	693: {region: 0x51, script: 0x4f, flags: 0x0},
	694: {region: 0x1, script: 0x35, flags: 0x0},
	695: {region: 0xd4, script: 0x4f, flags: 0x0},
	696: {region: 0x40, script: 0x4f, flags: 0x0},
	697: {region: 0xcd, script: 0x4f, flags: 0x0},
	698: {region: 0x52, script: 0x4f, flags: 0x0},
	699: {region: 0x109, script: 0x4f, flags: 0x0},
	701: {region: 0xa6, script: 0x5, flags: 0x0},
	702: {region: 0xd7, script: 0x4f, flags: 0x0},
	703: {region: 0xb8, script: 0xcc, flags: 0x0},
	704: {region: 0x4a, script: 0x13, flags: 0x1},
	705: {region: 0xce, script: 0x4f, flags: 0x0},
	706: {region: 0x15e, script: 0x4f, flags: 0x0},
	708: {region: 0x129, script: 0x4f, flags: 0x0},
}

// likelyLangList holds lists info associated with likelyLang.
// Size: 372 bytes, 93 elements
var likelyLangList = [93]likelyScriptRegion{
	0:  {region: 0x9a, script: 0x7, flags: 0x0},
	1:  {region: 0x9f, script: 0x69, flags: 0x2},
	2:  {region: 0x11a, script: 0x73, flags: 0x2},
	3:  {region: 0x31, script: 0x4f, flags: 0x0},
	4:  {region: 0x99, script: 0x5, flags: 0x4},
	5:  {region: 0x9a, script: 0x5, flags: 0x4},
	6:  {region: 0x104, script: 0x1d, flags: 0x4},
	7:  {region: 0x9a, script: 0x5, flags: 0x2},
	8:  {region: 0x97, script: 0xe, flags: 0x0},
	9:  {region: 0x34, script: 0x15, flags: 0x2},
	10: {region: 0x104, script: 0x1d, flags: 0x0},
	11: {region: 0x37, script: 0x29, flags: 0x2},
	12: {region: 0x132, script: 0x4f, flags: 0x0},
	13: {region: 0x79, script: 0xb7, flags: 0x2},
	14: {region: 0x5c, script: 0x1c, flags: 0x0},
	15: {region: 0x85, script: 0x53, flags: 0x2},
	16: {region: 0xd4, script: 0x4f, flags: 0x0},
	17: {region: 0x51, script: 0x5, flags: 0x4},
	18: {region: 0x109, script: 0x5, flags: 0x4},
	19: {region: 0xac, script: 0x1d, flags: 0x0},
	20: {region: 0x23, script: 0x5, flags: 0x4},
	21: {region: 0x52, script: 0x5, flags: 0x4},
	22: {region: 0x9a, script: 0x5, flags: 0x4},
	23: {region: 0xc3, script: 0x5, flags: 0x4},
	24: {region: 0x52, script: 0x5, flags: 0x2},
	25: {region: 0x129, script: 0x4f, flags: 0x0},
	26: {region: 0xae, script: 0x5, flags: 0x4},
	27: {region: 0x99, script: 0x5, flags: 0x2},
	28: {region: 0xa3, script: 0x1d, flags: 0x0},
	29: {region: 0x52, script: 0x5, flags: 0x4},
	30: {region: 0x129, script: 0x4f, flags: 0x4},
	31: {region: 0x52, script: 0x5, flags: 0x2},
	32: {region: 0x129, script: 0x4f, flags: 0x2},
	33: {region: 0xd9, script: 0x1f, flags: 0x0},
	34: {region: 0x97, script: 0x51, flags: 0x2},
	35: {region: 0x81, script: 0x4f, flags: 0x0},
	36: {region: 0x82, script: 0x6b, flags: 0x4},
	37: {region: 0x82, script: 0x6b, flags: 0x2},
	38: {region: 0xc3, script: 0x1d, flags: 0x0},
	39: {region: 0x52, script: 0x62, flags: 0x4},
	40: {region: 0x52, script: 0x62, flags: 0x2},
	41: {region: 0xce, script: 0x4f, flags: 0x0},
	42: {region: 0x49, script: 0x5, flags: 0x4},
	43: {region: 0x93, script: 0x5, flags: 0x4},
	44: {region: 0x97, script: 0x2e, flags: 0x0},
	45: {region: 0xe6, script: 0x5, flags: 0x4},
	46: {region: 0xe6, script: 0x5, flags: 0x2},
	47: {region: 0x9a, script: 0x77, flags: 0x0},
	48: {region: 0x52, script: 0x78, flags: 0x2},
	49: {region: 0xb8, script: 0xcc, flags: 0x0},
	50: {region: 0xd7, script: 0x4f, flags: 0x4},
	51: {region: 0xe6, script: 0x5, flags: 0x0},
	52: {region: 0x97, script: 0x1f, flags: 0x2},
	53: {region: 0x97, script: 0x44, flags: 0x2},
	54: {region: 0x97, script: 0xba, flags: 0x2},
	55: {region: 0x103, script: 0x1d, flags: 0x0},
	56: {region: 0xbb, script: 0x4f, flags: 0x4},
	57: {region: 0x102, script: 0x4f, flags: 0x4},
	58: {region: 0x104, script: 0x4f, flags: 0x4},
	59: {region: 0x129, script: 0x4f, flags: 0x4},
	60: {region: 0x122, script: 0x1d, flags: 0x0},
	61: {region: 0xe6, script: 0x5, flags: 0x4},
	62: {region: 0xe6, script: 0x5, flags: 0x2},
	63: {region: 0x52, script: 0x5, flags: 0x0},
	64: {region: 0xac, script: 0x1d, flags: 0x4},
	65: {region: 0xc3, script: 0x1d, flags: 0x4},
	66: {region: 0xac, script: 0x1d, flags: 0x2},
	67: {region: 0x97, script: 0xe, flags: 0x0},
	68: {region: 0xd9, script: 0x1f, flags: 0x4},
	69: {region: 0xd9, script: 0x1f, flags: 0x2},
	70: {region: 0x134, script: 0x4f, flags: 0x0},
	71: {region: 0x23, script: 0x5, flags: 0x4},
	72: {region: 0x52, script: 0x1d, flags: 0x4},
	73: {region: 0x23, script: 0x5, flags: 0x2},
	74: {region: 0x52, script: 0x32, flags: 0x0},
	75: {region: 0x2e, script: 0x33, flags: 0x4},
	76: {region: 0x3d, script: 0x33, flags: 0x4},
	77: {region: 0x79, script: 0x33, flags: 0x4},
	78: {region: 0x7c, script: 0x33, flags: 0x4},
	79: {region: 0x8b, script: 0x33, flags: 0x4},
	80: {region: 0x93, script: 0x33, flags: 0x4},
	81: {region: 0xc4, script: 0x33, flags: 0x4},
	82: {region: 0xce, script: 0x33, flags: 0x4},
	83: {region: 0xe0, script: 0x33, flags: 0x4},
	84: {region: 0xe3, script: 0x33, flags: 0x4},
	85: {region: 0xe5, script: 0x33, flags: 0x4},
	86: {region: 0x114, script: 0x33, flags: 0x4},
	87: {region: 0x121, script: 0x33, flags: 0x4},
	88: {region: 0x12c, script: 0x33, flags: 0x4},
	89: {region: 0x132, script: 0x33, flags: 0x4},
	90: {region: 0x13b, script: 0x33, flags: 0x4},
	91: {region: 0x12c, script: 0x10, flags: 0x2},
	92: {region: 0x12c, script: 0x33, flags: 0x2},
}

type likelyLangScript struct {
	lang   uint16
	script uint8
	flags  uint8
}

// likelyRegion is a lookup table, indexed by regionID, for the most likely
// languages and scripts given incomplete information. If more entries exist
// for a given regionID, lang and script are the index and size respectively
// of the list in likelyRegionList.
// TODO: exclude containers and user-definable regions from the list.
// Size: 1420 bytes, 355 elements
var likelyRegion = [355]likelyLangScript{
	33:  {lang: 0x61, script: 0x4f, flags: 0x0},
	34:  {lang: 0x15, script: 0x5, flags: 0x0},
	35:  {lang: 0x0, script: 0x2, flags: 0x1},
	38:  {lang: 0x2, script: 0x2, flags: 0x1},
	39:  {lang: 0x4, script: 0x2, flags: 0x1},
	41:  {lang: 0x1ed, script: 0x4f, flags: 0x0},
	42:  {lang: 0x0, script: 0x4f, flags: 0x0},
	43:  {lang: 0x9c, script: 0x4f, flags: 0x0},
	44:  {lang: 0x22d, script: 0x4f, flags: 0x0},
	45:  {lang: 0x85, script: 0x4f, flags: 0x0},
	47:  {lang: 0x1bc, script: 0x4f, flags: 0x0},
	48:  {lang: 0x245, script: 0x4f, flags: 0x0},
	49:  {lang: 0x24, script: 0x4f, flags: 0x0},
	50:  {lang: 0x6, script: 0x2, flags: 0x1},
	52:  {lang: 0x4b, script: 0xe, flags: 0x0},
	53:  {lang: 0x1bc, script: 0x4f, flags: 0x0},
	54:  {lang: 0xae, script: 0x4f, flags: 0x0},
	55:  {lang: 0x38, script: 0x1d, flags: 0x0},
	56:  {lang: 0x15, script: 0x5, flags: 0x0},
	57:  {lang: 0x1ff, script: 0x4f, flags: 0x0},
	58:  {lang: 0xae, script: 0x4f, flags: 0x0},
	59:  {lang: 0xae, script: 0x4f, flags: 0x0},
	61:  {lang: 0x199, script: 0x4f, flags: 0x0},
	62:  {lang: 0x9c, script: 0x4f, flags: 0x0},
	63:  {lang: 0x1d9, script: 0x4f, flags: 0x0},
	64:  {lang: 0x1ed, script: 0x4f, flags: 0x0},
	66:  {lang: 0x8, script: 0x2, flags: 0x1},
	68:  {lang: 0x0, script: 0x4f, flags: 0x0},
	70:  {lang: 0x2f, script: 0x1d, flags: 0x0},
	72:  {lang: 0x2b6, script: 0x35, flags: 0x2},
	73:  {lang: 0x199, script: 0x5, flags: 0x2},
	74:  {lang: 0x246, script: 0x4f, flags: 0x0},
	75:  {lang: 0xae, script: 0x4f, flags: 0x0},
	76:  {lang: 0xae, script: 0x4f, flags: 0x0},
	77:  {lang: 0x85, script: 0x4f, flags: 0x0},
	78:  {lang: 0xae, script: 0x4f, flags: 0x0},
	80:  {lang: 0x9c, script: 0x4f, flags: 0x0},
	81:  {lang: 0xae, script: 0x4f, flags: 0x0},
	82:  {lang: 0xa, script: 0x4, flags: 0x1},
	83:  {lang: 0x9c, script: 0x4f, flags: 0x0},
	84:  {lang: 0x0, script: 0x4f, flags: 0x0},
	85:  {lang: 0x9c, script: 0x4f, flags: 0x0},
	88:  {lang: 0x9c, script: 0x4f, flags: 0x0},
	89:  {lang: 0x1ed, script: 0x4f, flags: 0x0},
	90:  {lang: 0x1d9, script: 0x4f, flags: 0x0},
	92:  {lang: 0xe, script: 0x2, flags: 0x1},
	93:  {lang: 0x79, script: 0x4f, flags: 0x0},
	95:  {lang: 0x85, script: 0x4f, flags: 0x0},
	97:  {lang: 0x1, script: 0x4f, flags: 0x0},
	98:  {lang: 0x80, script: 0x4f, flags: 0x0},
	100: {lang: 0x9c, script: 0x4f, flags: 0x0},
	102: {lang: 0x10, script: 0x2, flags: 0x1},
	103: {lang: 0x9c, script: 0x4f, flags: 0x0},
	104: {lang: 0x9c, script: 0x4f, flags: 0x0},
	105: {lang: 0x9e, script: 0x4f, flags: 0x0},
	106: {lang: 0x15, script: 0x5, flags: 0x0},
	107: {lang: 0x15, script: 0x5, flags: 0x0},
	108: {lang: 0x25f, script: 0x26, flags: 0x0},
	109: {lang: 0x9c, script: 0x4f, flags: 0x0},
	110: {lang: 0x12, script: 0x2, flags: 0x1},
	112: {lang: 0xa7, script: 0x4f, flags: 0x0},
	113: {lang: 0xe1, script: 0x1f, flags: 0x2},
	116: {lang: 0xac, script: 0x4f, flags: 0x0},
	118: {lang: 0xae, script: 0x4f, flags: 0x0},
	120: {lang: 0xae, script: 0x4f, flags: 0x0},
	121: {lang: 0x14, script: 0x2, flags: 0x1},
	123: {lang: 0x16, script: 0x3, flags: 0x1},
	124: {lang: 0xae, script: 0x4f, flags: 0x0},
	126: {lang: 0xd, script: 0x4f, flags: 0x0},
	128: {lang: 0x130, script: 0x4f, flags: 0x0},
	130: {lang: 0xae, script: 0x4f, flags: 0x0},
	131: {lang: 0xae, script: 0x4f, flags: 0x0},
	132: {lang: 0x9c, script: 0x4f, flags: 0x0},
	133: {lang: 0x19, script: 0x2, flags: 0x1},
	134: {lang: 0x0, script: 0x4f, flags: 0x0},
	135: {lang: 0x9c, script: 0x4f, flags: 0x0},
	137: {lang: 0x1ed, script: 0x4f, flags: 0x0},
	139: {lang: 0x2c0, script: 0x33, flags: 0x0},
	140: {lang: 0x0, script: 0x4f, flags: 0x0},
	141: {lang: 0x9c, script: 0x4f, flags: 0x0},
	142: {lang: 0xed, script: 0x4f, flags: 0x0},
	143: {lang: 0xf0, script: 0x4f, flags: 0x0},
	144: {lang: 0xf1, script: 0x4f, flags: 0x0},
	146: {lang: 0x9c, script: 0x4f, flags: 0x0},
	147: {lang: 0x1b, script: 0x2, flags: 0x1},
	149: {lang: 0xdf, script: 0x35, flags: 0x0},
	151: {lang: 0x1d, script: 0x3, flags: 0x1},
	153: {lang: 0x15, script: 0x5, flags: 0x0},
	154: {lang: 0x20, script: 0x2, flags: 0x1},
	155: {lang: 0x101, script: 0x4f, flags: 0x0},
	156: {lang: 0x102, script: 0x4f, flags: 0x0},
	159: {lang: 0x15, script: 0x5, flags: 0x0},
	160: {lang: 0x106, script: 0x3e, flags: 0x0},
	162: {lang: 0x246, script: 0x4f, flags: 0x0},
	163: {lang: 0x14c, script: 0x1d, flags: 0x0},
	164: {lang: 0x22, script: 0x3, flags: 0x1},
	166: {lang: 0x25, script: 0x2, flags: 0x1},
	168: {lang: 0x135, script: 0x48, flags: 0x0},
	169: {lang: 0x135, script: 0x48, flags: 0x0},
	170: {lang: 0x15, script: 0x5, flags: 0x0},
	172: {lang: 0x205, script: 0x1d, flags: 0x0},
	173: {lang: 0x27, script: 0x2, flags: 0x1},
	174: {lang: 0x15, script: 0x5, flags: 0x0},
	176: {lang: 0x85, script: 0x4f, flags: 0x0},
	177: {lang: 0x226, script: 0xbb, flags: 0x0},
	179: {lang: 0x240, script: 0x4f, flags: 0x0},
	180: {lang: 0x168, script: 0x4f, flags: 0x0},
	181: {lang: 0xae, script: 0x4f, flags: 0x0},
	182: {lang: 0x16f, script: 0x4f, flags: 0x0},
	183: {lang: 0x15, script: 0x5, flags: 0x0},
	184: {lang: 0x29, script: 0x2, flags: 0x1},
	185: {lang: 0xae, script: 0x4f, flags: 0x0},
	186: {lang: 0x2b, script: 0x2, flags: 0x1},
	187: {lang: 0x239, script: 0x4f, flags: 0x0},
	188: {lang: 0xae, script: 0x4f, flags: 0x0},
	189: {lang: 0x182, script: 0x4f, flags: 0x0},
	192: {lang: 0x2d, script: 0x2, flags: 0x1},
	193: {lang: 0x49, script: 0x4f, flags: 0x0},
	194: {lang: 0x2f, script: 0x2, flags: 0x1},
	195: {lang: 0x31, script: 0x2, flags: 0x1},
	196: {lang: 0x33, script: 0x2, flags: 0x1},
	198: {lang: 0xae, script: 0x4f, flags: 0x0},
	199: {lang: 0x35, script: 0x2, flags: 0x1},
	201: {lang: 0x19a, script: 0x4f, flags: 0x0},
	202: {lang: 0x37, script: 0x3, flags: 0x1},
	203: {lang: 0x8f, script: 0xce, flags: 0x0},
	205: {lang: 0x9c, script: 0x4f, flags: 0x0},
	206: {lang: 0x199, script: 0x4f, flags: 0x0},
	207: {lang: 0x1ed, script: 0x4f, flags: 0x0},
	208: {lang: 0xa, script: 0x4f, flags: 0x0},
	209: {lang: 0xae, script: 0x4f, flags: 0x0},
	210: {lang: 0xdb, script: 0x4f, flags: 0x0},
	212: {lang: 0xdb, script: 0x5, flags: 0x2},
	214: {lang: 0x9c, script: 0x4f, flags: 0x0},
	215: {lang: 0x1bc, script: 0x4f, flags: 0x0},
	216: {lang: 0x1ae, script: 0x4f, flags: 0x0},
	217: {lang: 0x1b3, script: 0x1f, flags: 0x0},
	223: {lang: 0x15, script: 0x5, flags: 0x0},
	224: {lang: 0x9c, script: 0x4f, flags: 0x0},
	226: {lang: 0x9c, script: 0x4f, flags: 0x0},
	227: {lang: 0xae, script: 0x4f, flags: 0x0},
	228: {lang: 0x26c, script: 0x4f, flags: 0x0},
	229: {lang: 0xa9, script: 0x4f, flags: 0x0},
	230: {lang: 0x3a, script: 0x3, flags: 0x1},
	231: {lang: 0x3d, script: 0x2, flags: 0x1},
	232: {lang: 0xae, script: 0x4f, flags: 0x0},
	234: {lang: 0x9c, script: 0x4f, flags: 0x0},
	235: {lang: 0x15, script: 0x5, flags: 0x0},
	236: {lang: 0x1ed, script: 0x4f, flags: 0x0},
	238: {lang: 0x1da, script: 0x4f, flags: 0x0},
	239: {lang: 0xc9, script: 0x4f, flags: 0x0},
	241: {lang: 0x15, script: 0x5, flags: 0x0},
	256: {lang: 0xae, script: 0x4f, flags: 0x0},
	258: {lang: 0x3f, script: 0x2, flags: 0x1},
	259: {lang: 0x239, script: 0x1d, flags: 0x0},
	260: {lang: 0x41, script: 0x2, flags: 0x1},
	261: {lang: 0x208, script: 0x4f, flags: 0x0},
	262: {lang: 0x15, script: 0x5, flags: 0x0},
	264: {lang: 0xae, script: 0x4f, flags: 0x0},
	265: {lang: 0x15, script: 0x5, flags: 0x0},
	266: {lang: 0x43, script: 0x2, flags: 0x1},
	269: {lang: 0x22a, script: 0x4f, flags: 0x0},
	270: {lang: 0x1ae, script: 0x4f, flags: 0x0},
	271: {lang: 0x45, script: 0x2, flags: 0x1},
	273: {lang: 0x102, script: 0x4f, flags: 0x0},
	274: {lang: 0xae, script: 0x4f, flags: 0x0},
	275: {lang: 0x236, script: 0x4f, flags: 0x0},
	276: {lang: 0x1bc, script: 0x4f, flags: 0x0},
	278: {lang: 0x1ed, script: 0x4f, flags: 0x0},
	280: {lang: 0x9c, script: 0x4f, flags: 0x0},
	282: {lang: 0x47, script: 0x2, flags: 0x1},
	286: {lang: 0xae, script: 0x4f, flags: 0x0},
	287: {lang: 0xae, script: 0x4f, flags: 0x0},
	288: {lang: 0xae, script: 0x4f, flags: 0x0},
	289: {lang: 0x49, script: 0x3, flags: 0x1},
	290: {lang: 0x4c, script: 0x2, flags: 0x1},
	291: {lang: 0x263, script: 0x4f, flags: 0x0},
	292: {lang: 0x1ed, script: 0x4f, flags: 0x0},
	293: {lang: 0x262, script: 0x4f, flags: 0x0},
	294: {lang: 0x4e, script: 0x2, flags: 0x1},
	295: {lang: 0x26a, script: 0x4f, flags: 0x0},
	297: {lang: 0x50, script: 0x4, flags: 0x1},
	299: {lang: 0x27a, script: 0x4f, flags: 0x0},
	300: {lang: 0x54, script: 0x2, flags: 0x1},
	301: {lang: 0x246, script: 0x4f, flags: 0x0},
	302: {lang: 0x56, script: 0x3, flags: 0x1},
	303: {lang: 0x246, script: 0x4f, flags: 0x0},
	306: {lang: 0x2b6, script: 0x35, flags: 0x2},
	307: {lang: 0x9c, script: 0x4f, flags: 0x0},
	308: {lang: 0x28a, script: 0x4f, flags: 0x0},
	309: {lang: 0x102, script: 0x4f, flags: 0x0},
	312: {lang: 0x9c, script: 0x4f, flags: 0x0},
	315: {lang: 0x28f, script: 0x4f, flags: 0x0},
	316: {lang: 0x41, script: 0x4f, flags: 0x0},
	317: {lang: 0xae, script: 0x4f, flags: 0x0},
	319: {lang: 0x22d, script: 0x4f, flags: 0x0},
	330: {lang: 0x59, script: 0x2, flags: 0x1},
	347: {lang: 0x15, script: 0x5, flags: 0x0},
	348: {lang: 0x5b, script: 0x2, flags: 0x1},
	353: {lang: 0x234, script: 0x4f, flags: 0x0},
}

// likelyRegionList holds lists info associated with likelyRegion.
// Size: 372 bytes, 93 elements
var likelyRegionList = [93]likelyLangScript{
	0:  {lang: 0xa3, script: 0x5, flags: 0x0},
	1:  {lang: 0x262, script: 0x4f, flags: 0x0},
	2:  {lang: 0x238, script: 0x4f, flags: 0x0},
	3:  {lang: 0x18b, script: 0x1d, flags: 0x0},
	4:  {lang: 0xf2, script: 0x8, flags: 0x0},
	5:  {lang: 0x144, script: 0x4f, flags: 0x0},
	6:  {lang: 0x54, script: 0x4f, flags: 0x0},
	7:  {lang: 0x239, script: 0x1d, flags: 0x0},
	8:  {lang: 0x92, script: 0xd0, flags: 0x0},
	9:  {lang: 0x1b3, script: 0x1f, flags: 0x0},
	10: {lang: 0x2c0, script: 0x32, flags: 0x0},
	11: {lang: 0x281, script: 0x5, flags: 0x0},
	12: {lang: 0x2ba, script: 0x4f, flags: 0x0},
	13: {lang: 0x156, script: 0xcf, flags: 0x0},
	14: {lang: 0x99, script: 0x2c, flags: 0x0},
	15: {lang: 0x26d, script: 0x4f, flags: 0x0},
	16: {lang: 0x15, script: 0x5, flags: 0x0},
	17: {lang: 0xae, script: 0x4f, flags: 0x0},
	18: {lang: 0x11, script: 0x26, flags: 0x0},
	19: {lang: 0x9a, script: 0x4f, flags: 0x0},
	20: {lang: 0x140, script: 0x5, flags: 0x2},
	21: {lang: 0x2b6, script: 0x35, flags: 0x2},
	22: {lang: 0x110, script: 0x28, flags: 0x0},
	23: {lang: 0x2, script: 0x1d, flags: 0x0},
	24: {lang: 0x144, script: 0x4f, flags: 0x0},
	25: {lang: 0x99, script: 0x2c, flags: 0x0},
	26: {lang: 0x18b, script: 0x1d, flags: 0x0},
	27: {lang: 0xf7, script: 0x4f, flags: 0x0},
	28: {lang: 0x199, script: 0x5, flags: 0x0},
	29: {lang: 0xe0, script: 0x1f, flags: 0x0},
	30: {lang: 0x289, script: 0x5, flags: 0x0},
	31: {lang: 0x128, script: 0x67, flags: 0x0},
	32: {lang: 0xa3, script: 0x5, flags: 0x0},
	33: {lang: 0x262, script: 0x4f, flags: 0x0},
	34: {lang: 0x132, script: 0x43, flags: 0x0},
	35: {lang: 0x6d, script: 0x5, flags: 0x0},
	36: {lang: 0x11b, script: 0xcf, flags: 0x0},
	37: {lang: 0x15, script: 0x5, flags: 0x0},
	38: {lang: 0xae, script: 0x4f, flags: 0x0},
	39: {lang: 0x164, script: 0x4c, flags: 0x0},
	40: {lang: 0x11b, script: 0xcf, flags: 0x0},
	41: {lang: 0x15, script: 0x5, flags: 0x0},
	42: {lang: 0xae, script: 0x4f, flags: 0x0},
	43: {lang: 0x201, script: 0x4f, flags: 0x0},
	44: {lang: 0x283, script: 0x1d, flags: 0x0},
	45: {lang: 0x18b, script: 0x1d, flags: 0x0},
	46: {lang: 0x238, script: 0x4f, flags: 0x0},
	47: {lang: 0x1a4, script: 0x67, flags: 0x0},
	48: {lang: 0x113, script: 0x4f, flags: 0x0},
	49: {lang: 0x18e, script: 0x1d, flags: 0x0},
	50: {lang: 0x12e, script: 0x5, flags: 0x0},
	51: {lang: 0x2c0, script: 0x33, flags: 0x0},
	52: {lang: 0x1ed, script: 0x4f, flags: 0x0},
	53: {lang: 0x15, script: 0x5, flags: 0x0},
	54: {lang: 0xae, script: 0x4f, flags: 0x0},
	55: {lang: 0x181, script: 0x4f, flags: 0x0},
	56: {lang: 0x289, script: 0x5, flags: 0x0},
	57: {lang: 0x40, script: 0x1f, flags: 0x0},
	58: {lang: 0x289, script: 0x5, flags: 0x0},
	59: {lang: 0x289, script: 0x5, flags: 0x0},
	60: {lang: 0x58, script: 0x1f, flags: 0x0},
	61: {lang: 0x1e5, script: 0x4f, flags: 0x0},
	62: {lang: 0x2f, script: 0x1d, flags: 0x0},
	63: {lang: 0x201, script: 0x4f, flags: 0x0},
	64: {lang: 0x38, script: 0x1d, flags: 0x0},
	65: {lang: 0x205, script: 0x1d, flags: 0x0},
	66: {lang: 0x13e, script: 0x4f, flags: 0x0},
	67: {lang: 0x245, script: 0x4f, flags: 0x0},
	68: {lang: 0x2b6, script: 0x35, flags: 0x0},
	69: {lang: 0x228, script: 0x4f, flags: 0x0},
	70: {lang: 0x283, script: 0x1d, flags: 0x0},
	71: {lang: 0x15, script: 0x5, flags: 0x0},
	72: {lang: 0xae, script: 0x4f, flags: 0x0},
	73: {lang: 0x25b, script: 0xcf, flags: 0x0},
	74: {lang: 0x180, script: 0x5, flags: 0x0},
	75: {lang: 0x190, script: 0x67, flags: 0x0},
	76: {lang: 0x25a, script: 0x1d, flags: 0x0},
	77: {lang: 0xa3, script: 0x5, flags: 0x0},
	78: {lang: 0x15, script: 0x5, flags: 0x0},
	79: {lang: 0xae, script: 0x4f, flags: 0x0},
	80: {lang: 0x26d, script: 0x4f, flags: 0x0},
	81: {lang: 0x24, script: 0x5, flags: 0x0},
	82: {lang: 0x117, script: 0x1d, flags: 0x0},
	83: {lang: 0x3b, script: 0x2c, flags: 0x0},
	84: {lang: 0x2c0, script: 0x33, flags: 0x0},
	85: {lang: 0x26f, script: 0x4f, flags: 0x0},
	86: {lang: 0x283, script: 0x1d, flags: 0x0},
	87: {lang: 0x2b6, script: 0x35, flags: 0x0},
	88: {lang: 0x1e5, script: 0x4f, flags: 0x0},
	89: {lang: 0x238, script: 0x4f, flags: 0x0},
	90: {lang: 0x239, script: 0x1d, flags: 0x0},
	91: {lang: 0xae, script: 0x4f, flags: 0x0},
	92: {lang: 0x247, script: 0x5, flags: 0x0},
}

type likelyTag struct {
	lang   uint16
	region uint16
	script uint8
}

// Size: 192 bytes, 32 elements
var likelyRegionGroup = [32]likelyTag{
	1:  {lang: 0x9a, region: 0xd4, script: 0x4f},
	2:  {lang: 0x9a, region: 0x132, script: 0x4f},
	3:  {lang: 0x1ed, region: 0x40, script: 0x4f},
	4:  {lang: 0x9a, region: 0x2e, script: 0x4f},
	5:  {lang: 0x9a, region: 0xd4, script: 0x4f},
	6:  {lang: 0x9c, region: 0xcd, script: 0x4f},
	7:  {lang: 0x246, region: 0x12d, script: 0x4f},
	8:  {lang: 0x15, region: 0x6a, script: 0x5},
	9:  {lang: 0x246, region: 0x4a, script: 0x4f},
	10: {lang: 0x9a, region: 0x15e, script: 0x4f},
	11: {lang: 0x9a, region: 0x132, script: 0x4f},
	12: {lang: 0x9a, region: 0x132, script: 0x4f},
	13: {lang: 0x9c, region: 0x58, script: 0x4f},
	14: {lang: 0x2c0, region: 0x52, script: 0x32},
	15: {lang: 0xe0, region: 0x97, script: 0x1f},
	16: {lang: 0xf7, region: 0x93, script: 0x4f},
	17: {lang: 0x102, region: 0x9c, script: 0x4f},
	18: {lang: 0x9a, region: 0x2e, script: 0x4f},
	19: {lang: 0x9a, region: 0xe4, script: 0x4f},
	20: {lang: 0x9a, region: 0x88, script: 0x4f},
	21: {lang: 0x22d, region: 0x13f, script: 0x4f},
	22: {lang: 0x2c0, region: 0x52, script: 0x32},
	23: {lang: 0x28a, region: 0x134, script: 0x4f},
	24: {lang: 0x15, region: 0x106, script: 0x5},
	25: {lang: 0x205, region: 0x104, script: 0x1d},
	26: {lang: 0x205, region: 0x104, script: 0x1d},
	27: {lang: 0x9a, region: 0x79, script: 0x4f},
	28: {lang: 0x85, region: 0x5f, script: 0x4f},
	29: {lang: 0x9c, region: 0x1e, script: 0x4f},
	30: {lang: 0x9a, region: 0x98, script: 0x4f},
	31: {lang: 0x9a, region: 0x79, script: 0x4f},
}

type mutualIntelligibility struct {
	want   uint16
	have   uint16
	conf   uint8
	oneway bool
}

type scriptIntelligibility struct {
	lang uint16
	want uint8
	have uint8
	conf uint8
}

// matchLang holds pairs of langIDs of base languages that are typically
// mutually intelligible. Each pair is associated with a confidence and
// whether the intelligibility goes one or both ways.
// Size: 708 bytes, 118 elements
var matchLang = [118]mutualIntelligibility{
	0:   {want: 0x1c0, have: 0x1ae, conf: 0x2, oneway: false},
	1:   {want: 0x144, have: 0x6f, conf: 0x2, oneway: false},
	2:   {want: 0xed, have: 0x54, conf: 0x2, oneway: false},
	3:   {want: 0x223, have: 0x54, conf: 0x2, oneway: false},
	4:   {want: 0x239, have: 0x54, conf: 0x2, oneway: false},
	5:   {want: 0x223, have: 0xed, conf: 0x2, oneway: false},
	6:   {want: 0x239, have: 0xed, conf: 0x2, oneway: false},
	7:   {want: 0x223, have: 0x239, conf: 0x2, oneway: false},
	8:   {want: 0x23f, have: 0x1, conf: 0x2, oneway: false},
	9:   {want: 0xd1, have: 0x85, conf: 0x2, oneway: true},
	10:  {want: 0x153, have: 0x85, conf: 0x2, oneway: true},
	11:  {want: 0x80, have: 0x1c0, conf: 0x2, oneway: false},
	12:  {want: 0x80, have: 0x1ae, conf: 0x2, oneway: false},
	13:  {want: 0x6f, have: 0x144, conf: 0x2, oneway: false},
	14:  {want: 0x2, have: 0x205, conf: 0x2, oneway: true},
	15:  {want: 0x5, have: 0x9a, conf: 0x2, oneway: true},
	16:  {want: 0xa, have: 0x1bc, conf: 0x2, oneway: true},
	17:  {want: 0xd, have: 0x9a, conf: 0x2, oneway: true},
	18:  {want: 0x23, have: 0x9c, conf: 0x2, oneway: true},
	19:  {want: 0x24, have: 0x205, conf: 0x2, oneway: true},
	20:  {want: 0x2f, have: 0x205, conf: 0x2, oneway: true},
	21:  {want: 0x31, have: 0x9a, conf: 0x2, oneway: true},
	22:  {want: 0x3c, have: 0xe0, conf: 0x2, oneway: true},
	23:  {want: 0x4b, have: 0x9a, conf: 0x2, oneway: true},
	24:  {want: 0x50, have: 0xae, conf: 0x2, oneway: true},
	25:  {want: 0x65, have: 0xa9, conf: 0x2, oneway: true},
	26:  {want: 0x6c, have: 0x9a, conf: 0x2, oneway: true},
	27:  {want: 0x6f, have: 0x15, conf: 0x2, oneway: true},
	28:  {want: 0x70, have: 0xae, conf: 0x2, oneway: true},
	29:  {want: 0x78, have: 0xae, conf: 0x2, oneway: true},
	30:  {want: 0x7f, have: 0x9a, conf: 0x2, oneway: true},
	31:  {want: 0x94, have: 0x9a, conf: 0x2, oneway: true},
	32:  {want: 0x9b, have: 0x9a, conf: 0x2, oneway: true},
	33:  {want: 0x9e, have: 0xa7, conf: 0x2, oneway: true},
	34:  {want: 0xa0, have: 0x9c, conf: 0x2, oneway: true},
	35:  {want: 0xac, have: 0x80, conf: 0x2, oneway: true},
	36:  {want: 0xb8, have: 0x1bc, conf: 0x2, oneway: true},
	37:  {want: 0xb9, have: 0x9a, conf: 0x2, oneway: true},
	38:  {want: 0xba, have: 0x9a, conf: 0x2, oneway: true},
	39:  {want: 0xc1, have: 0x9a, conf: 0x2, oneway: true},
	40:  {want: 0xc7, have: 0x9c, conf: 0x2, oneway: true},
	41:  {want: 0xc9, have: 0x9c, conf: 0x2, oneway: true},
	42:  {want: 0xd2, have: 0xe0, conf: 0x2, oneway: true},
	43:  {want: 0xdb, have: 0x9a, conf: 0x2, oneway: true},
	44:  {want: 0xdd, have: 0x9a, conf: 0x2, oneway: true},
	45:  {want: 0xf0, have: 0xae, conf: 0x2, oneway: true},
	46:  {want: 0xf2, have: 0x205, conf: 0x2, oneway: true},
	47:  {want: 0xf4, have: 0x9a, conf: 0x2, oneway: true},
	48:  {want: 0xf9, have: 0x9a, conf: 0x2, oneway: true},
	49:  {want: 0x101, have: 0x9a, conf: 0x2, oneway: true},
	50:  {want: 0x10e, have: 0xf7, conf: 0x2, oneway: true},
	51:  {want: 0x110, have: 0x9a, conf: 0x2, oneway: true},
	52:  {want: 0x121, have: 0xae, conf: 0x2, oneway: true},
	53:  {want: 0x12e, have: 0x205, conf: 0x2, oneway: true},
	54:  {want: 0x132, have: 0x9a, conf: 0x2, oneway: true},
	55:  {want: 0x134, have: 0x9a, conf: 0x2, oneway: true},
	56:  {want: 0x13c, have: 0x9a, conf: 0x2, oneway: true},
	57:  {want: 0x144, have: 0x26d, conf: 0x2, oneway: true},
	58:  {want: 0x14c, have: 0x205, conf: 0x2, oneway: true},
	59:  {want: 0x14d, have: 0x102, conf: 0x2, oneway: true},
	60:  {want: 0x159, have: 0x9a, conf: 0x2, oneway: true},
	61:  {want: 0x163, have: 0xae, conf: 0x2, oneway: true},
	62:  {want: 0x164, have: 0x9a, conf: 0x2, oneway: true},
	63:  {want: 0x166, have: 0x9a, conf: 0x2, oneway: true},
	64:  {want: 0x16b, have: 0xae, conf: 0x2, oneway: true},
	65:  {want: 0x181, have: 0x9a, conf: 0x2, oneway: true},
	66:  {want: 0x182, have: 0xae, conf: 0x2, oneway: true},
	67:  {want: 0x188, have: 0x9a, conf: 0x2, oneway: true},
	68:  {want: 0x18b, have: 0x38, conf: 0x2, oneway: true},
	69:  {want: 0x18c, have: 0x9a, conf: 0x2, oneway: true},
	70:  {want: 0x18e, have: 0x205, conf: 0x2, oneway: true},
	71:  {want: 0x195, have: 0xe0, conf: 0x2, oneway: true},
	72:  {want: 0x199, have: 0xf7, conf: 0x2, oneway: true},
	73:  {want: 0x19a, have: 0x9a, conf: 0x2, oneway: true},
	74:  {want: 0x1a4, have: 0x9a, conf: 0x2, oneway: true},
	75:  {want: 0x1b3, have: 0x9a, conf: 0x2, oneway: true},
	76:  {want: 0x1be, have: 0x1ae, conf: 0x2, oneway: false},
	77:  {want: 0x1be, have: 0x1c0, conf: 0x2, oneway: true},
	78:  {want: 0x1c7, have: 0x9a, conf: 0x2, oneway: true},
	79:  {want: 0x1cb, have: 0x9a, conf: 0x2, oneway: true},
	80:  {want: 0x1cd, have: 0x9a, conf: 0x2, oneway: true},
	81:  {want: 0x1cf, have: 0xae, conf: 0x2, oneway: true},
	82:  {want: 0x1d1, have: 0x9a, conf: 0x2, oneway: true},
	83:  {want: 0x1d2, have: 0x9a, conf: 0x2, oneway: true},
	84:  {want: 0x1d5, have: 0x9a, conf: 0x2, oneway: true},
	85:  {want: 0x1dc, have: 0x9a, conf: 0x2, oneway: true},
	86:  {want: 0x1ec, have: 0x9a, conf: 0x2, oneway: true},
	87:  {want: 0x1ef, have: 0x9c, conf: 0x2, oneway: true},
	88:  {want: 0x1fa, have: 0x85, conf: 0x2, oneway: true},
	89:  {want: 0x1ff, have: 0x9a, conf: 0x2, oneway: true},
	90:  {want: 0x208, have: 0xae, conf: 0x2, oneway: true},
	91:  {want: 0x20b, have: 0xe0, conf: 0x2, oneway: true},
	92:  {want: 0x218, have: 0x9a, conf: 0x2, oneway: true},
	93:  {want: 0x226, have: 0x9a, conf: 0x2, oneway: true},
	94:  {want: 0x234, have: 0x9a, conf: 0x2, oneway: true},
	95:  {want: 0x236, have: 0x9a, conf: 0x2, oneway: true},
	96:  {want: 0x238, have: 0x9a, conf: 0x2, oneway: true},
	97:  {want: 0x240, have: 0x9a, conf: 0x2, oneway: true},
	98:  {want: 0x242, have: 0xf7, conf: 0x2, oneway: true},
	99:  {want: 0x246, have: 0x9a, conf: 0x2, oneway: true},
	100: {want: 0x24f, have: 0x9a, conf: 0x2, oneway: true},
	101: {want: 0x256, have: 0x9a, conf: 0x2, oneway: true},
	102: {want: 0x25a, have: 0x205, conf: 0x2, oneway: true},
	103: {want: 0x25f, have: 0x9a, conf: 0x2, oneway: true},
	104: {want: 0x262, have: 0x205, conf: 0x2, oneway: true},
	105: {want: 0x3616, have: 0x9a, conf: 0x2, oneway: true},
	106: {want: 0x269, have: 0x9a, conf: 0x2, oneway: true},
	107: {want: 0x26a, have: 0x9a, conf: 0x2, oneway: true},
	108: {want: 0x275, have: 0x205, conf: 0x2, oneway: true},
	109: {want: 0x279, have: 0x9a, conf: 0x2, oneway: true},
	110: {want: 0x281, have: 0x2c0, conf: 0x2, oneway: true},
	111: {want: 0x289, have: 0x9a, conf: 0x2, oneway: true},
	112: {want: 0x28a, have: 0x205, conf: 0x2, oneway: true},
	113: {want: 0x2a1, have: 0xae, conf: 0x2, oneway: true},
	114: {want: 0x2a6, have: 0x9a, conf: 0x2, oneway: true},
	115: {want: 0x2b6, have: 0x9a, conf: 0x2, oneway: true},
	116: {want: 0x2b7, have: 0x9a, conf: 0x2, oneway: true},
	117: {want: 0x2c2, have: 0x9a, conf: 0x2, oneway: true},
}

// matchScript holds pairs of scriptIDs where readers of one script
// can typically also read the other. Each is associated with a confidence.
// Size: 24 bytes, 4 elements
var matchScript = [4]scriptIntelligibility{
	0: {lang: 0x239, want: 0x4f, have: 0x1d, conf: 0x2},
	1: {lang: 0x239, want: 0x1d, have: 0x4f, conf: 0x2},
	2: {lang: 0x0, want: 0x32, have: 0x33, conf: 0x1},
	3: {lang: 0x0, want: 0x33, have: 0x32, conf: 0x1},
}

// Size: 128 bytes, 32 elements
var regionContainment = [32]uint32{
	0xffffffff, 0x000007a2, 0x00003044, 0x00000008,
	0x403c0010, 0x00000020, 0x00000040, 0x00000080,
	0x00000100, 0x00000200, 0x00000400, 0x2000384c,
	0x00001000, 0x00002000, 0x00004000, 0x00008000,
	0x00010000, 0x00020000, 0x00040000, 0x00080000,
	0x00100000, 0x00200000, 0x01c1c000, 0x00800000,
	0x01000000, 0x1e020000, 0x04000000, 0x08000000,
	0x10000000, 0x20002048, 0x40000000, 0x80000000,
}

// regionInclusion maps region identifiers to sets of regions in regionInclusionBits,
// where each set holds all groupings that are directly connected in a region
// containment graph.
// Size: 355 bytes, 355 elements
var regionInclusion = [355]uint8{
	// Entry 0 - 3F
	0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06,
	0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e,
	0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,
	0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x20,
	0x21, 0x22, 0x23, 0x24, 0x25, 0x25, 0x22, 0x23,
	0x25, 0x26, 0x21, 0x27, 0x28, 0x29, 0x2a, 0x25,
	0x2b, 0x23, 0x22, 0x25, 0x24, 0x29, 0x2c, 0x2d,
	0x23, 0x2e, 0x2c, 0x25, 0x2f, 0x30, 0x27, 0x25,
	// Entry 40 - 7F
	0x27, 0x25, 0x24, 0x30, 0x21, 0x31, 0x32, 0x33,
	0x2f, 0x21, 0x26, 0x26, 0x26, 0x34, 0x2c, 0x28,
	0x27, 0x26, 0x35, 0x27, 0x21, 0x33, 0x22, 0x20,
	0x25, 0x2c, 0x25, 0x21, 0x36, 0x2d, 0x34, 0x29,
	0x21, 0x2e, 0x37, 0x25, 0x25, 0x20, 0x38, 0x38,
	0x27, 0x37, 0x38, 0x38, 0x2e, 0x39, 0x2e, 0x1f,
	0x37, 0x3a, 0x27, 0x3b, 0x2b, 0x20, 0x29, 0x34,
	0x26, 0x37, 0x25, 0x23, 0x27, 0x2b, 0x2c, 0x22,
	// Entry 80 - BF
	0x2f, 0x2c, 0x2c, 0x25, 0x26, 0x39, 0x21, 0x33,
	0x3b, 0x2c, 0x27, 0x35, 0x21, 0x33, 0x39, 0x25,
	0x2d, 0x20, 0x38, 0x30, 0x37, 0x23, 0x2b, 0x24,
	0x21, 0x23, 0x24, 0x2b, 0x39, 0x2b, 0x25, 0x23,
	0x35, 0x20, 0x2e, 0x3c, 0x30, 0x3b, 0x2e, 0x25,
	0x35, 0x35, 0x23, 0x25, 0x3c, 0x30, 0x23, 0x25,
	0x34, 0x24, 0x2c, 0x31, 0x37, 0x29, 0x37, 0x38,
	0x38, 0x34, 0x32, 0x22, 0x25, 0x2e, 0x3b, 0x20,
	// Entry C0 - FF
	0x22, 0x2c, 0x30, 0x35, 0x35, 0x3b, 0x25, 0x2c,
	0x25, 0x39, 0x2e, 0x24, 0x2e, 0x33, 0x30, 0x2e,
	0x31, 0x3a, 0x2c, 0x2a, 0x2c, 0x20, 0x33, 0x29,
	0x2b, 0x24, 0x20, 0x3b, 0x23, 0x28, 0x2a, 0x23,
	0x33, 0x20, 0x27, 0x28, 0x3a, 0x30, 0x24, 0x2d,
	0x2f, 0x28, 0x25, 0x23, 0x39, 0x20, 0x3b, 0x27,
	0x20, 0x23, 0x20, 0x20, 0x1e, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	// Entry 100 - 13F
	0x2e, 0x20, 0x2d, 0x22, 0x32, 0x2e, 0x23, 0x3a,
	0x2e, 0x38, 0x37, 0x30, 0x2c, 0x39, 0x2b, 0x2d,
	0x2c, 0x22, 0x2c, 0x2e, 0x27, 0x38, 0x26, 0x32,
	0x33, 0x25, 0x23, 0x31, 0x21, 0x25, 0x26, 0x21,
	0x2c, 0x30, 0x3c, 0x28, 0x30, 0x3c, 0x38, 0x28,
	0x30, 0x23, 0x25, 0x28, 0x35, 0x2e, 0x32, 0x2e,
	0x20, 0x21, 0x2f, 0x27, 0x3c, 0x22, 0x25, 0x20,
	0x27, 0x25, 0x25, 0x30, 0x3a, 0x28, 0x20, 0x28,
	// Entry 140 - 17F
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x23, 0x23, 0x2e, 0x22, 0x31, 0x2e,
	0x26, 0x2e, 0x20,
}

// regionInclusionBits is an array of bit vectors where every vector represents
// a set of region groupings.  These sets are used to compute the distance
// between two regions for the purpose of language matching.
// Size: 288 bytes, 72 elements
var regionInclusionBits = [72]uint32{
	// Entry 0 - 1F
	0x82400813, 0x000007a3, 0x00003844, 0x20000808,
	0x403c0011, 0x00000022, 0x20000844, 0x00000082,
	0x00000102, 0x00000202, 0x00000402, 0x2000384d,
	0x00001804, 0x20002804, 0x00404000, 0x00408000,
	0x00410000, 0x02020000, 0x00040010, 0x00080010,
	0x00100010, 0x00200010, 0x01c1c001, 0x00c00000,
	0x01400000, 0x1e020001, 0x06000000, 0x0a000000,
	0x12000000, 0x20002848, 0x40000010, 0x80000001,
	// Entry 20 - 3F
	0x00000001, 0x40000000, 0x00020000, 0x01000000,
	0x00008000, 0x00002000, 0x00000200, 0x00000008,
	0x00200000, 0x90000000, 0x00040000, 0x08000000,
	0x00000020, 0x84000000, 0x00000080, 0x00001000,
	0x00010000, 0x00000400, 0x04000000, 0x00000040,
	0x10000000, 0x00004000, 0x81000000, 0x88000000,
	0x00000100, 0x80020000, 0x00080000, 0x00100000,
	0x00800000, 0xffffffff, 0x82400fb3, 0xc27c0813,
	// Entry 40 - 5F
	0xa240385f, 0x83c1c813, 0x9e420813, 0x92000001,
	0x86000001, 0x81400001, 0x8a000001, 0x82020001,
}

// regionInclusionNext marks, for each entry in regionInclusionBits, the set of
// all groups that are reachable from the groups set in the respective entry.
// Size: 72 bytes, 72 elements
var regionInclusionNext = [72]uint8{
	// Entry 0 - 3F
	0x3d, 0x3e, 0x0b, 0x0b, 0x3f, 0x01, 0x0b, 0x01,
	0x01, 0x01, 0x01, 0x40, 0x0b, 0x0b, 0x16, 0x16,
	0x16, 0x19, 0x04, 0x04, 0x04, 0x04, 0x41, 0x16,
	0x16, 0x42, 0x19, 0x19, 0x19, 0x0b, 0x04, 0x00,
	0x00, 0x1e, 0x11, 0x18, 0x0f, 0x0d, 0x09, 0x03,
	0x15, 0x43, 0x12, 0x1b, 0x05, 0x44, 0x07, 0x0c,
	0x10, 0x0a, 0x1a, 0x06, 0x1c, 0x0e, 0x45, 0x46,
	0x08, 0x47, 0x13, 0x14, 0x17, 0x3d, 0x3d, 0x3d,
	// Entry 40 - 7F
	0x3d, 0x3d, 0x3d, 0x42, 0x42, 0x41, 0x42, 0x42,
}

type parentRel struct {
	lang       uint16
	script     uint8
	maxScript  uint8
	toRegion   uint16
	fromRegion []uint16
}

// Size: 404 bytes, 5 elements
var parents = [5]parentRel{
	0: {lang: 0x9a, script: 0x0, maxScript: 0x4f, toRegion: 0x1, fromRegion: []uint16{0x1a, 0x24, 0x25, 0x2e, 0x33, 0x35, 0x3c, 0x41, 0x45, 0x47, 0x48, 0x49, 0x4f, 0x51, 0x5b, 0x5c, 0x60, 0x63, 0x6c, 0x71, 0x72, 0x73, 0x79, 0x7a, 0x7d, 0x7e, 0x7f, 0x81, 0x8a, 0x8b, 0x94, 0x95, 0x96, 0x97, 0x98, 0x9d, 0x9e, 0xa2, 0xa5, 0xa7, 0xab, 0xaf, 0xb2, 0xb3, 0xbd, 0xc4, 0xc8, 0xc9, 0xca, 0xcc, 0xce, 0xd0, 0xd3, 0xd4, 0xdb, 0xdd, 0xde, 0xe4, 0xe5, 0xe6, 0xe9, 0xee, 0x105, 0x107, 0x108, 0x109, 0x10b, 0x10c, 0x110, 0x115, 0x119, 0x11b, 0x11d, 0x123, 0x127, 0x12a, 0x12b, 0x12d, 0x12f, 0x136, 0x139, 0x13c, 0x13f, 0x15e, 0x15f, 0x161}},
	1: {lang: 0x9a, script: 0x0, maxScript: 0x4f, toRegion: 0x1a, fromRegion: []uint16{0x2d, 0x4d, 0x5f, 0x62, 0x70, 0xd7, 0x10a, 0x10d}},
	2: {lang: 0x9c, script: 0x0, maxScript: 0x4f, toRegion: 0x1e, fromRegion: []uint16{0x2b, 0x3e, 0x50, 0x53, 0x55, 0x58, 0x64, 0x68, 0x87, 0x8d, 0xcd, 0xd6, 0xe0, 0xe2, 0xea, 0xef, 0x118, 0x132, 0x133, 0x138}},
	3: {lang: 0x1ed, script: 0x0, maxScript: 0x4f, toRegion: 0xec, fromRegion: []uint16{0x29, 0x59, 0x89, 0xc4, 0xcf, 0x116, 0x124}},
	4: {lang: 0x2c0, script: 0x33, maxScript: 0x33, toRegion: 0x8b, fromRegion: []uint16{0xc4}},
}

// Total table size 19949 bytes (19KiB); checksum: 13F4A4EF
