#!/usr/bin/env python3
# Copyright 2012-2017 Canonical Ltd.  This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

"""Command-line interface for the MAAS provisioning component."""

import sys

from provisioningserver import security
import provisioningserver.boot.install_grub
import provisioningserver.cluster_config_command
import provisioningserver.register_command
import provisioningserver.support_dump
import provisioningserver.upgrade_cluster
import provisioningserver.utils.arp
import provisioningserver.utils.avahi
import provisioningserver.utils.beaconing
import provisioningserver.utils.dhcp
import provisioningserver.utils.scan_network
from provisioningserver.utils.script import MainScript
import provisioningserver.utils.send_beacons


COMMON_COMMANDS = {
    'observe-arp': provisioningserver.utils.arp,
    'observe-beacons': provisioningserver.utils.beaconing,
    'observe-mdns': provisioningserver.utils.avahi,
    'observe-dhcp': provisioningserver.utils.dhcp,
    'send-beacons': provisioningserver.utils.send_beacons,
    'scan-network': provisioningserver.utils.scan_network,
}

RACK_ONLY_COMMANDS = {
    'check-for-shared-secret': security.CheckForSharedSecretScript,
    'config': provisioningserver.cluster_config_command,
    'install-shared-secret': security.InstallSharedSecretScript,
    'install-uefi-config': provisioningserver.boot.install_grub,
    'register': provisioningserver.register_command,
    'support-dump': provisioningserver.support_dump,
    'upgrade-cluster': provisioningserver.upgrade_cluster,
}


main = MainScript(__doc__)

commands = COMMON_COMMANDS.copy()

# If 'maas-common' isn't being executed, add rack-specific commands in addition
# to the generic set of commands.
if not sys.argv[0].endswith('/maas-common'):
    commands.update(RACK_ONLY_COMMANDS)

for name, command in sorted(commands.items()):
    main.register(name, command)
main()
