# Copyright 2016 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

"""Autofill expected data by field type. This matches the default profile.
"""

DEFAULT = {
    # Personal Information categorization types.
    'NAME_FIRST': 'Donald',
    'NAME_MIDDLE': 'Craig',
    'NAME_LAST': 'Figgleburg',
    'NAME_MIDDLE_INITIAL': 'C',
    'NAME_FULL': 'Donald Craig Figgleburg',
    'NAME_SUFFIX': '',
    'EMAIL_ADDRESS': 'donald@figgleburg.com',
    'PHONE_HOME_NUMBER': '6701234',
    'PHONE_HOME_CITY_CODE': '650',
    'PHONE_HOME_COUNTRY_CODE': '+1',
    'PHONE_HOME_CITY_AND_NUMBER': '6506701234',
    'PHONE_HOME_WHOLE_NUMBER': '+16506701234',
    'ADDRESS_HOME_LINE1': '314 Oceanwalk Rd.',
    'ADDRESS_HOME_LINE2': 'Apt. 4',
    'ADDRESS_HOME_APPT_NUM': '4',
    'ADDRESS_HOME_CITY': 'Mountain View',
    'ADDRESS_HOME_STATE': 'California',
    'ADDRESS_HOME_ZIP': '94035',
    'ADDRESS_HOME_COUNTRY': 'United States',
    'ADDRESS_BILLING_LINE1': '314 Oceanwalk Rd.',
    'ADDRESS_BILLING_LINE2': 'Apt. 4',
    'ADDRESS_BILLING_APPT_NUM': '4',
    'ADDRESS_BILLING_CITY': 'Mountain View',
    'ADDRESS_BILLING_STATE': 'California',
    'ADDRESS_BILLING_ZIP': '94035',
    'ADDRESS_BILLING_COUNTRY': 'United States',
    'CREDIT_CARD_NAME': 'Donald Figgleburg',
    'CREDIT_CARD_NUMBER': '5432123498764567',
    'CREDIT_CARD_EXP_MONTH': '05',
    'CREDIT_CARD_EXP_2_DIGIT_YEAR': '21',
    'CREDIT_CARD_EXP_4_DIGIT_YEAR': '2021',
    'CREDIT_CARD_EXP_DATE_2_DIGIT_YEAR': '05/21',
    'CREDIT_CARD_EXP_DATE_4_DIGIT_YEAR': '05/2021',
    'CREDIT_CARD_TYPE': '',
    'CREDIT_CARD_VERIFICATION_CODE': '',
    'COMPANY_NAME': 'Frtizerg Inc.',

    # Generic fieldtype having default value to use, used only by autocheckout
    # experiment. These field types exist for select merchant pages. Field
    # mappings for these pages are generated by autocheckout's buildstorage
    # script.
    'FIELD_WITH_DEFAULT_VALUE': '',
    'PHONE_BILLING_NUMBER': '',
    'PHONE_BILLING_CITY_CODE': '',
    'PHONE_BILLING_COUNTRY_CODE': '',
    'PHONE_BILLING_CITY_AND_NUMBER': '',
    'PHONE_BILLING_WHOLE_NUMBER': '',
    'NAME_BILLING_FIRST': '',
    'NAME_BILLING_MIDDLE': '',
    'NAME_BILLING_LAST': '',
    'NAME_BILLING_MIDDLE_INITIAL': '',
    'NAME_BILLING_FULL': '',
    'NAME_BILLING_SUFFIX': '',

    # Includes of the lines of a street address, including newlines, e.g.
    #   123 Main Street,
    #   Apt. #42
    'ADDRESS_HOME_STREET_ADDRESS': '314 Oceanwalk Rd.\nApt. 4',
    'ADDRESS_BILLING_STREET_ADDRESS': '314 Oceanwalk Rd.\nApt. 4',

    'ACCOUNT_CREATION_PASSWORD': '',

    # The third line of the street address.
    'ADDRESS_HOME_LINE3': '',
    'ADDRESS_BILLING_LINE3': ''
}
