// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT.
//   GENERATED BY generate_character_composer_data.py
//   FROM character_composer_sequences.txt

#ifndef CHARACTER_COMPOSER_DATA_H_
#define CHARACTER_COMPOSER_DATA_H_

static const uint16_t kCompositionsTree[] = {

    // offset 0x0000:
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0019,          // number of entries
    0x0000,  // U+0000
    0x0036,
    0x0300,  // combining grave accent
    0x26F2,
    0x0301,  // combining acute accent
    0x28D0,
    0x0302,  // combining circumflex accent
    0x2B62,
    0x0303,  // combining tilde
    0x2CCC,
    0x0304,  // combining macron
    0x2E50,
    0x0306,  // combining breve
    0x2F6C,
    0x0307,  // combining dot above
    0x3022,
    0x0308,  // combining diaeresis
    0x30FA,
    0x0309,  // combining hook above
    0x31F2,
    0x030A,  // combining ring above
    0x32D2,
    0x030B,  // combining double acute accent
    0x32F6,
    0x030C,  // combining caron
    0x330C,
    0x030F,  // combining double grave accent
    0x33A8,
    0x0311,  // combining inverted breve
    0x33C8,
    0x0313,  // combining comma above
    0x33E4,
    0x0314,  // combining reversed comma above
    0x3404,
    0x031B,  // combining horn
    0x3428,
    0x0323,  // combining dot below
    0x3498,
    0x0327,  // combining cedilla
    0x3562,
    0x0328,  // combining ogonek
    0x35B6,
    0x0338,  // combining long solidus overlay
    0x35E2,
    0x0345,  // combining greek ypogegrammeni
    0x3656,
    0x3099,  // combining katakana-hiragana voiced sound mark
    0x3A30,
    0x309A,  // combining katakana-hiragana semi-voiced sound mark
    0x3A94,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0036:
    //   prefix:
    //     Compose
    //   internal character table
    0x00E6,          // number of entries
    0x0020,  // space
    0x0206,
    0x0021,  // exclamation mark
    0x0220,
    0x0022,  // quotation mark
    0x0296,
    0x0023,  // number sign
    0x0356,
    0x0025,  // percent sign
    0x0360,
    0x0027,  // apostrophe
    0x0366,
    0x0028,  // left parenthesis
    0x05BA,
    0x0029,  // right parenthesis
    0x0D88,
    0x002A,  // asterisk
    0x0DAC,
    0x002B,  // plus sign
    0x0DBA,
    0x002C,  // comma
    0x0DCA,
    0x002D,  // hyphen-minus
    0x0E10,
    0x002E,  // full stop
    0x0E54,
    0x002F,  // solidus
    0x0EFE,
    0x0030,  // digit zero
    0x0F4A,
    0x0031,  // digit one
    0x0F5E,
    0x0032,  // digit two
    0x0F74,
    0x0033,  // digit three
    0x0F82,
    0x0034,  // digit four
    0x0F92,
    0x0035,  // digit five
    0x0F98,
    0x0037,  // digit seven
    0x0FA0,
    0x003A,  // colon
    0x0FA6,
    0x003B,  // semicolon
    0x0FB0,
    0x003C,  // less-than sign
    0x0FC8,
    0x003D,  // equals sign
    0x1002,
    0x003E,  // greater-than sign
    0x102E,
    0x003F,  // question mark
    0x1052,
    0x0041,  // capital a
    0x10D6,
    0x0042,  // capital b
    0x10FA,
    0x0043,  // capital c
    0x1100,
    0x0044,  // capital d
    0x112A,
    0x0045,  // capital e
    0x1136,
    0x0046,  // capital f
    0x1154,
    0x0047,  // capital g
    0x115C,
    0x0049,  // capital i
    0x116A,
    0x004B,  // capital k
    0x1186,
    0x004C,  // capital l
    0x118C,
    0x004D,  // capital m
    0x119E,
    0x004E,  // capital n
    0x11A4,
    0x004F,  // capital o
    0x11BA,
    0x0050,  // capital p
    0x11E6,
    0x0052,  // capital r
    0x11F2,
    0x0053,  // capital s
    0x1200,
    0x0054,  // capital t
    0x1220,
    0x0055,  // capital u
    0x1232,
    0x0056,  // capital v
    0x12C2,
    0x0057,  // capital w
    0x12C8,
    0x0058,  // capital x
    0x12D0,
    0x0059,  // capital y
    0x12DA,
    0x005A,  // capital z
    0x12EC,
    0x005E,  // circumflex accent
    0x12F6,
    0x005F,  // low line
    0x13CC,
    0x0060,  // grave accent
    0x14D4,
    0x0061,  // letter a
    0x1692,
    0x0062,  // letter b
    0x16B4,
    0x0063,  // letter c
    0x172C,
    0x0064,  // letter d
    0x179E,
    0x0065,  // letter e
    0x17AA,
    0x0066,  // letter f
    0x17CA,
    0x0067,  // letter g
    0x17D4,
    0x0069,  // letter i
    0x17E2,
    0x006B,  // letter k
    0x17FE,
    0x006C,  // letter l
    0x1806,
    0x006D,  // letter m
    0x1818,
    0x006E,  // letter n
    0x1822,
    0x006F,  // letter o
    0x1832,
    0x0070,  // letter p
    0x1874,
    0x0072,  // letter r
    0x187C,
    0x0073,  // letter s
    0x1886,
    0x0074,  // letter t
    0x18A6,
    0x0075,  // letter u
    0x18B8,
    0x0076,  // letter v
    0x18D8,
    0x0077,  // letter w
    0x18E2,
    0x0078,  // letter x
    0x18E8,
    0x0079,  // letter y
    0x18F4,
    0x007A,  // letter z
    0x1906,
    0x007C,  // vertical line
    0x1910,
    0x007E,  // tilde
    0x1918,
    0x00A8,  // diaeresis
    0x1A4E,
    0x00AF,  // macron
    0x1A78,
    0x00B4,  // acute accent
    0x1B58,
    0x00B8,  // cedilla
    0x1DAA,
    0x02D8,  // breve
    0x1DDA,
    0x0391,  // capital alpha
    0x1DE2,
    0x0395,  // capital epsilon
    0x1DE8,
    0x0397,  // capital eta
    0x1DEE,
    0x0399,  // capital iota
    0x1DF4,
    0x039F,  // capital omicron
    0x1DFC,
    0x03A5,  // capital upsilon
    0x1E02,
    0x03A9,  // capital omega
    0x1E0A,
    0x03B1,  // letter alpha
    0x1E10,
    0x03B5,  // letter epsilon
    0x1E16,
    0x03B7,  // letter eta
    0x1E1C,
    0x03B9,  // letter iota
    0x1E22,
    0x03BF,  // letter omicron
    0x21E2,
    0x03C5,  // letter upsilon
    0x21E8,
    0x03C9,  // letter omega
    0x21F0,
    0x0415,  // cyrillic capital ie
    0x21F6,
    0x041D,  // cyrillic capital en
    0x21FC,
    0x0421,  // cyrillic capital es
    0x2204,
    0x043F,  // cyrillic small pe
    0x220A,
    0x05B4,  // hebrew point hiriq
    0x2210,
    0x05B7,  // hebrew point patah
    0x2216,
    0x05B8,  // hebrew point qamats
    0x221E,
    0x05B9,  // hebrew point holam
    0x2224,
    0x05BC,  // hebrew point dagesh or mapiq
    0x222A,
    0x061F,  // arabic question mark
    0x225A,
    0x0621,  // arabic hamza
    0x2264,
    0x0622,  // arabic alef with madda above
    0x2274,
    0x0653,  // arabic maddah above
    0x2284,
    0x0654,  // arabic hamza above
    0x228A,
    0x0655,  // arabic hamza below
    0x229A,
    0x093C,  // devanagari sign nukta
    0x22A0,
    0x09BC,  // bengali sign nukta
    0x22BA,
    0x09C7,  // bengali vowel sign e
    0x22C4,
    0x0A3C,  // gurmukhi sign nukta
    0x22CC,
    0x0B3C,  // oriya sign nukta
    0x22DC,
    0x0B47,  // oriya vowel sign e
    0x22E4,
    0x0BC7,  // tamil vowel sign ee
    0x22EE,
    0x0BD7,  // tamil au length mark
    0x22F4,
    0x0C46,  // telugu vowel sign e
    0x22FA,
    0x0CBF,  // kannada vowel sign i
    0x2300,
    0x0CC6,  // kannada vowel sign e
    0x2306,
    0x0CCA,  // kannada vowel sign o
    0x2310,
    0x0D46,  // malayalam vowel sign e
    0x2316,
    0x0D47,  // malayalam vowel sign ee
    0x231E,
    0x0DDC,  // sinhala vowel sign kombuva haa aela-pilla
    0x2324,
    0x0E39,  // thai character sara uu
    0x232A,
    0x0F71,  // tibetan vowel sign aa
    0x2334,
    0x0F90,  // tibetan subjoined ka
    0x233E,
    0x0F92,  // tibetan subjoined ga
    0x2344,
    0x0F9C,  // tibetan subjoined dda
    0x234A,
    0x0FA1,  // tibetan subjoined da
    0x2350,
    0x0FA6,  // tibetan subjoined ba
    0x2356,
    0x0FAB,  // tibetan subjoined dza
    0x235C,
    0x0FB2,  // tibetan subjoined ra
    0x2362,
    0x0FB3,  // tibetan subjoined la
    0x2368,
    0x0FB5,  // tibetan subjoined ssa
    0x236E,
    0x0FB7,  // tibetan subjoined ha
    0x2374,
    0x102E,  // myanmar vowel sign ii
    0x2382,
    0x1100,  // hangul choseong kiyeok
    0x2388,
    0x1102,  // hangul choseong nieun
    0x238E,
    0x1103,  // hangul choseong tikeut
    0x239A,
    0x1105,  // hangul choseong rieul
    0x23A2,
    0x1106,  // hangul choseong mieum
    0x23AE,
    0x1107,  // hangul choseong pieup
    0x23B6,
    0x1108,  // hangul choseong ssangpieup
    0x23DA,
    0x1109,  // hangul choseong sios
    0x23E0,
    0x110A,  // hangul choseong ssangsios
    0x2404,
    0x110B,  // hangul choseong ieung
    0x240A,
    0x110C,  // hangul choseong cieuc
    0x2424,
    0x110E,  // hangul choseong chieuch
    0x242C,
    0x1111,  // hangul choseong phieuph
    0x2434,
    0x1112,  // hangul choseong hieuh
    0x243C,
    0x1121,  // hangul choseong pieup-sios
    0x2442,
    0x1132,  // hangul choseong sios-pieup
    0x2450,
    0x113C,  // hangul choseong chitueumsios
    0x2456,
    0x113E,  // hangul choseong ceongchieumsios
    0x245C,
    0x114E,  // hangul choseong chitueumcieuc
    0x2462,
    0x1150,  // hangul choseong ceongchieumcieuc
    0x2468,
    0x1161,  // hangul jungseong a
    0x246E,
    0x1163,  // hangul jungseong ya
    0x2478,
    0x1165,  // hangul jungseong eo
    0x2482,
    0x1167,  // hangul jungseong yeo
    0x248E,
    0x1169,  // hangul jungseong o
    0x2498,
    0x116A,  // hangul jungseong wa
    0x24AC,
    0x116D,  // hangul jungseong yo
    0x24B2,
    0x116E,  // hangul jungseong u
    0x24C0,
    0x116F,  // hangul jungseong weo
    0x24D4,
    0x1172,  // hangul jungseong yu
    0x24DC,
    0x1173,  // hangul jungseong eu
    0x24EE,
    0x1174,  // hangul jungseong yi
    0x24F8,
    0x1175,  // hangul jungseong i
    0x24FE,
    0x119E,  // hangul jungseong araea
    0x250E,
    0x11A8,  // hangul jongseong kiyeok
    0x251A,
    0x11AA,  // hangul jongseong kiyeok-sios
    0x2526,
    0x11AB,  // hangul jongseong nieun
    0x252C,
    0x11AE,  // hangul jongseong tikeut
    0x253E,
    0x11AF,  // hangul jongseong rieul
    0x2546,
    0x11B0,  // hangul jongseong rieul-kiyeok
    0x2572,
    0x11B1,  // hangul jongseong rieul-mieum
    0x2578,
    0x11B2,  // hangul jongseong rieul-pieup
    0x2580,
    0x11B3,  // hangul jongseong rieul-sios
    0x258A,
    0x11B7,  // hangul jongseong mieum
    0x2590,
    0x11B8,  // hangul jongseong pieup
    0x25A6,
    0x11BA,  // hangul jongseong sios
    0x25B4,
    0x11BC,  // hangul jongseong ieung
    0x25C2,
    0x11C1,  // hangul jongseong phieuph
    0x25CE,
    0x11C2,  // hangul jongseong hieuh
    0x25D6,
    0x11CE,  // hangul jongseong rieul-tikeut
    0x25E2,
    0x11DD,  // hangul jongseong mieum-sios
    0x25E8,
    0x11EC,  // hangul jongseong ieung-kiyeok
    0x25EE,
    0x11F0,  // hangul jongseong yesieung
    0x25F4,
    0x1FBF,  // psili
    0x25FC,
    0x1FFE,  // dasia
    0x260E,
    0x2203,  // there exists
    0x2620,
    0x2208,  // element of
    0x2626,
    0x220B,  // contains as member
    0x262C,
    0x2223,  // divides
    0x2632,
    0x2225,  // parallel to
    0x2638,
    0x223C,  // tilde operator
    0x263E,
    0x2243,  // asymptotically equal to
    0x2644,
    0x2248,  // almost equal to
    0x264A,
    0x224D,  // equivalent to
    0x2650,
    0x2261,  // identical to
    0x2656,
    0x2264,  // less-than or equal to
    0x265C,
    0x2265,  // greater-than or equal to
    0x2662,
    0x2272,  // less-than or equivalent to
    0x2668,
    0x2273,  // greater-than or equivalent to
    0x266E,
    0x2276,  // less-than or greater-than
    0x2674,
    0x2277,  // greater-than or less-than
    0x267A,
    0x227A,  // precedes
    0x2680,
    0x227B,  // succeeds
    0x2686,
    0x227C,  // precedes or equal to
    0x268C,
    0x227D,  // succeeds or equal to
    0x2692,
    0x2282,  // subset of
    0x2698,
    0x2283,  // superset of
    0x269E,
    0x2286,  // subset of or equal to
    0x26A4,
    0x2287,  // superset of or equal to
    0x26AA,
    0x2291,  // square image of or equal to
    0x26B0,
    0x2292,  // square original of or equal to
    0x26B6,
    0x22A2,  // right tack
    0x26BC,
    0x22A8,  // true
    0x26C2,
    0x22A9,  // forces
    0x26C8,
    0x22AB,  // double vertical bar double right turnstile
    0x26CE,
    0x22B2,  // normal subgroup of
    0x26D4,
    0x22B3,  // contains as normal subgroup
    0x26DA,
    0x22B4,  // normal subgroup of or equal to
    0x26E0,
    0x22B5,  // contains as normal subgroup or equal to
    0x26E6,
    0x2ADD,  // nonforking
    0x26EC,
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0206:
    //   prefix:
    //     Compose
    //     <space>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000B,          // number of entries
    0x0020,  // space
    0x00A0,  // -> no-break space
    0x0027,  // apostrophe
    0x0027,  // -> apostrophe
    0x0028,  // left parenthesis
    0x02D8,  // -> breve
    0x002C,  // comma
    0x00B8,  // -> cedilla
    0x002D,  // hyphen-minus
    0x007E,  // -> tilde
    0x002E,  // full stop
    0x2008,  // -> punctuation space
    0x003C,  // less-than sign
    0x02C7,  // -> caron
    0x003E,  // greater-than sign
    0x005E,  // -> circumflex accent
    0x005E,  // circumflex accent
    0x005E,  // -> circumflex accent
    0x0060,  // grave accent
    0x0060,  // -> grave accent
    0x007E,  // tilde
    0x007E,  // -> tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0220:
    //   prefix:
    //     Compose
    //     <exclamation mark>
    //   internal character table
    0x0001,          // number of entries
    0x002B,  // plus sign
    0x027E,
    //   leaf character table
    0x002B,          // number of entries
    0x0021,  // exclamation mark
    0x00A1,  // -> inverted exclamation mark
    0x003F,  // question mark
    0x203D,  // -> interrobang
    0x0041,  // capital a
    0x1EA0,  // -> capital a with dot below
    0x0042,  // capital b
    0x1E04,  // -> capital b with dot below
    0x0044,  // capital d
    0x1E0C,  // -> capital d with dot below
    0x0045,  // capital e
    0x1EB8,  // -> capital e with dot below
    0x0048,  // capital h
    0x1E24,  // -> capital h with dot below
    0x0049,  // capital i
    0x1ECA,  // -> capital i with dot below
    0x004B,  // capital k
    0x1E32,  // -> capital k with dot below
    0x004C,  // capital l
    0x1E36,  // -> capital l with dot below
    0x004D,  // capital m
    0x1E42,  // -> capital m with dot below
    0x004E,  // capital n
    0x1E46,  // -> capital n with dot below
    0x004F,  // capital o
    0x1ECC,  // -> capital o with dot below
    0x0050,  // capital p
    0x00B6,  // -> pilcrow sign
    0x0052,  // capital r
    0x1E5A,  // -> capital r with dot below
    0x0053,  // capital s
    0x1E62,  // -> capital s with dot below
    0x0054,  // capital t
    0x1E6C,  // -> capital t with dot below
    0x0055,  // capital u
    0x1EE4,  // -> capital u with dot below
    0x0056,  // capital v
    0x1E7E,  // -> capital v with dot below
    0x0057,  // capital w
    0x1E88,  // -> capital w with dot below
    0x0059,  // capital y
    0x1EF4,  // -> capital y with dot below
    0x005A,  // capital z
    0x1E92,  // -> capital z with dot below
    0x005E,  // circumflex accent
    0x00A6,  // -> broken bar
    0x0061,  // letter a
    0x1EA1,  // -> letter a with dot below
    0x0062,  // letter b
    0x1E05,  // -> letter b with dot below
    0x0064,  // letter d
    0x1E0D,  // -> letter d with dot below
    0x0065,  // letter e
    0x1EB9,  // -> letter e with dot below
    0x0068,  // letter h
    0x1E25,  // -> letter h with dot below
    0x0069,  // letter i
    0x1ECB,  // -> letter i with dot below
    0x006B,  // letter k
    0x1E33,  // -> letter k with dot below
    0x006C,  // letter l
    0x1E37,  // -> letter l with dot below
    0x006D,  // letter m
    0x1E43,  // -> letter m with dot below
    0x006E,  // letter n
    0x1E47,  // -> letter n with dot below
    0x006F,  // letter o
    0x1ECD,  // -> letter o with dot below
    0x0070,  // letter p
    0x00B6,  // -> pilcrow sign
    0x0072,  // letter r
    0x1E5B,  // -> letter r with dot below
    0x0073,  // letter s
    0x1E63,  // -> letter s with dot below
    0x0074,  // letter t
    0x1E6D,  // -> letter t with dot below
    0x0075,  // letter u
    0x1EE5,  // -> letter u with dot below
    0x0076,  // letter v
    0x1E7F,  // -> letter v with dot below
    0x0077,  // letter w
    0x1E89,  // -> letter w with dot below
    0x0079,  // letter y
    0x1EF5,  // -> letter y with dot below
    0x007A,  // letter z
    0x1E93,  // -> letter z with dot below
    //   internal dead_key table
    0x0001,          // number of entries
    0x031B,  // combining horn
    0x028A,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x027E:
    //   prefix:
    //     Compose
    //     <exclamation mark>
    //     <plus sign>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EE2,  // -> capital o with horn and dot below
    0x0055,  // capital u
    0x1EF0,  // -> capital u with horn and dot below
    0x006F,  // letter o
    0x1EE3,  // -> letter o with horn and dot below
    0x0075,  // letter u
    0x1EF1,  // -> letter u with horn and dot below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x028A:
    //   prefix:
    //     Compose
    //     <exclamation mark>
    //     Dead<combining horn>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EE2,  // -> capital o with horn and dot below
    0x0055,  // capital u
    0x1EF0,  // -> capital u with horn and dot below
    0x006F,  // letter o
    0x1EE3,  // -> letter o with horn and dot below
    0x0075,  // letter u
    0x1EF1,  // -> letter u with horn and dot below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0296:
    //   prefix:
    //     Compose
    //     <quotation mark>
    //   internal character table
    0x0004,          // number of entries
    0x0027,  // apostrophe
    0x0324,
    0x005F,  // low line
    0x032E,
    0x007E,  // tilde
    0x0336,
    0x00AF,  // macron
    0x033E,
    //   leaf character table
    0x003E,          // number of entries
    0x0022,  // quotation mark
    0x00A8,  // -> diaeresis
    0x0027,  // apostrophe
    0x0344,  // -> combining greek dialytika tonos
    0x002C,  // comma
    0x201E,  // -> double low-9 quotation mark
    0x002F,  // solidus
    0x301E,  // -> double prime quotation mark
    0x003C,  // less-than sign
    0x201C,  // -> left double quotation mark
    0x003E,  // greater-than sign
    0x201D,  // -> right double quotation mark
    0x0041,  // capital a
    0x00C4,  // -> capital a with diaeresis
    0x0045,  // capital e
    0x00CB,  // -> capital e with diaeresis
    0x0048,  // capital h
    0x1E26,  // -> capital h with diaeresis
    0x0049,  // capital i
    0x00CF,  // -> capital i with diaeresis
    0x004F,  // capital o
    0x00D6,  // -> capital o with diaeresis
    0x0055,  // capital u
    0x00DC,  // -> capital u with diaeresis
    0x0057,  // capital w
    0x1E84,  // -> capital w with diaeresis
    0x0058,  // capital x
    0x1E8C,  // -> capital x with diaeresis
    0x0059,  // capital y
    0x0178,  // -> capital y with diaeresis
    0x005C,  // reverse solidus
    0x301D,  // -> reversed double prime quotation mark
    0x0061,  // letter a
    0x00E4,  // -> letter a with diaeresis
    0x0065,  // letter e
    0x00EB,  // -> letter e with diaeresis
    0x0068,  // letter h
    0x1E27,  // -> letter h with diaeresis
    0x0069,  // letter i
    0x00EF,  // -> letter i with diaeresis
    0x006F,  // letter o
    0x00F6,  // -> letter o with diaeresis
    0x0074,  // letter t
    0x1E97,  // -> letter t with diaeresis
    0x0075,  // letter u
    0x00FC,  // -> letter u with diaeresis
    0x0077,  // letter w
    0x1E85,  // -> letter w with diaeresis
    0x0078,  // letter x
    0x1E8D,  // -> letter x with diaeresis
    0x0079,  // letter y
    0x00FF,  // -> letter y with diaeresis
    0x00B4,  // acute accent
    0x0344,  // -> combining greek dialytika tonos
    0x00D5,  // capital o with tilde
    0x1E4E,  // -> capital o with tilde and diaeresis
    0x00F5,  // letter o with tilde
    0x1E4F,  // -> letter o with tilde and diaeresis
    0x014C,  // capital o with macron
    0x03D4,  // -> upsilon with diaeresis and hook symbol
    0x016A,  // capital u with macron
    0x1E7A,  // -> capital u with macron and diaeresis
    0x016B,  // letter u with macron
    0x1E7B,  // -> letter u with macron and diaeresis
    0x0399,  // capital iota
    0x03AA,  // -> capital iota with dialytika
    0x03A5,  // capital upsilon
    0x03AB,  // -> capital upsilon with dialytika
    0x03B9,  // letter iota
    0x03CA,  // -> letter iota with dialytika
    0x03C5,  // letter upsilon
    0x03CB,  // -> letter upsilon with dialytika
    0x0406,  // cyrillic capital byelorussian-ukrainian i
    0x0407,  // -> cyrillic capital yi
    0x0410,  // cyrillic capital a
    0x04D2,  // -> cyrillic capital a with diaeresis
    0x0415,  // cyrillic capital ie
    0x0401,  // -> cyrillic capital io
    0x0416,  // cyrillic capital zhe
    0x04DC,  // -> cyrillic capital zhe with diaeresis
    0x0417,  // cyrillic capital ze
    0x04DE,  // -> cyrillic capital ze with diaeresis
    0x0418,  // cyrillic capital i
    0x04E4,  // -> cyrillic capital i with diaeresis
    0x041E,  // cyrillic capital o
    0x04E6,  // -> cyrillic capital o with diaeresis
    0x0423,  // cyrillic capital u
    0x04F0,  // -> cyrillic capital u with diaeresis
    0x0427,  // cyrillic capital che
    0x04F4,  // -> cyrillic capital che with diaeresis
    0x042B,  // cyrillic capital yeru
    0x04F8,  // -> cyrillic capital yeru with diaeresis
    0x042D,  // cyrillic capital e
    0x04EC,  // -> cyrillic capital e with diaeresis
    0x0430,  // cyrillic small a
    0x04D3,  // -> cyrillic small a with diaeresis
    0x0435,  // cyrillic small ie
    0x0451,  // -> cyrillic small io
    0x0436,  // cyrillic small zhe
    0x04DD,  // -> cyrillic small zhe with diaeresis
    0x0437,  // cyrillic small ze
    0x04DF,  // -> cyrillic small ze with diaeresis
    0x0438,  // cyrillic small i
    0x04E5,  // -> cyrillic small i with diaeresis
    0x043E,  // cyrillic small o
    0x04E7,  // -> cyrillic small o with diaeresis
    0x0443,  // cyrillic small u
    0x04F1,  // -> cyrillic small u with diaeresis
    0x0447,  // cyrillic small che
    0x04F5,  // -> cyrillic small che with diaeresis
    0x044B,  // cyrillic small yeru
    0x04F9,  // -> cyrillic small yeru with diaeresis
    0x044D,  // cyrillic small e
    0x04ED,  // -> cyrillic small e with diaeresis
    0x0456,  // cyrillic small byelorussian-ukrainian i
    0x0457,  // -> cyrillic small yi
    0x04E8,  // cyrillic capital barred o
    0x04EA,  // -> cyrillic capital barred o with diaeresis
    0x04E9,  // cyrillic small barred o
    0x04EB,  // -> cyrillic small barred o with diaeresis
    0x30EA,  // katakana ri
    0x04DA,  // -> cyrillic capital schwa with diaeresis
    0x30EB,  // katakana ru
    0x04DB,  // -> cyrillic small schwa with diaeresis
    //   internal dead_key table
    0x0002,          // number of entries
    0x0303,  // combining tilde
    0x0346,
    0x0304,  // combining macron
    0x034E,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x0301,  // combining acute accent
    0x0344,  // -> combining greek dialytika tonos

    // offset 0x0324:
    //   prefix:
    //     Compose
    //     <quotation mark>
    //     <apostrophe>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x0020,  // space
    0x0385,  // -> dialytika tonos
    0x03B9,  // letter iota
    0x0390,  // -> letter iota with dialytika and tonos
    0x03C5,  // letter upsilon
    0x03B0,  // -> letter upsilon with dialytika and tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x032E:
    //   prefix:
    //     Compose
    //     <quotation mark>
    //     <low line>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0055,  // capital u
    0x1E7A,  // -> capital u with macron and diaeresis
    0x0075,  // letter u
    0x1E7B,  // -> letter u with macron and diaeresis
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0336:
    //   prefix:
    //     Compose
    //     <quotation mark>
    //     <tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x1E4E,  // -> capital o with tilde and diaeresis
    0x006F,  // letter o
    0x1E4F,  // -> letter o with tilde and diaeresis
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x033E:
    //   prefix:
    //     Compose
    //     <quotation mark>
    //     <macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0055,  // capital u
    0x1E7A,  // -> capital u with macron and diaeresis
    0x0075,  // letter u
    0x1E7B,  // -> letter u with macron and diaeresis
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0346:
    //   prefix:
    //     Compose
    //     <quotation mark>
    //     Dead<combining tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x1E4E,  // -> capital o with tilde and diaeresis
    0x006F,  // letter o
    0x1E4F,  // -> letter o with tilde and diaeresis
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x034E:
    //   prefix:
    //     Compose
    //     <quotation mark>
    //     Dead<combining macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0055,  // capital u
    0x1E7A,  // -> capital u with macron and diaeresis
    0x0075,  // letter u
    0x1E7B,  // -> letter u with macron and diaeresis
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0356:
    //   prefix:
    //     Compose
    //     <number sign>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x0023,  // number sign
    0x266F,  // -> music sharp sign
    0x0062,  // letter b
    0x266D,  // -> music flat sign
    0x0066,  // letter f
    0x266E,  // -> music natural sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0360:
    //   prefix:
    //     Compose
    //     <percent sign>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x006F,  // letter o
    0x2030,  // -> per mille sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0366:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //   internal character table
    0x000B,          // number of entries
    0x0022,  // quotation mark
    0x0478,
    0x0028,  // left parenthesis
    0x048A,
    0x0029,  // right parenthesis
    0x04AA,
    0x002B,  // plus sign
    0x04C8,
    0x002F,  // solidus
    0x04D4,
    0x005E,  // circumflex accent
    0x04DC,
    0x005F,  // low line
    0x04EC,
    0x0062,  // letter b
    0x04F8,
    0x007E,  // tilde
    0x0500,
    0x00AF,  // macron
    0x050C,
    0x00B8,  // cedilla
    0x0518,
    //   leaf character table
    0x0072,          // number of entries
    0x0020,  // space
    0x0027,  // -> apostrophe
    0x0027,  // apostrophe
    0x00B4,  // -> acute accent
    0x002C,  // comma
    0x201A,  // -> single low-9 quotation mark
    0x003C,  // less-than sign
    0x2018,  // -> left single quotation mark
    0x003E,  // greater-than sign
    0x2019,  // -> right single quotation mark
    0x0041,  // capital a
    0x00C1,  // -> capital a with acute
    0x0043,  // capital c
    0x00C7,  // -> capital c with cedilla
    0x0045,  // capital e
    0x00C9,  // -> capital e with acute
    0x0047,  // capital g
    0x01F4,  // -> capital g with acute
    0x0049,  // capital i
    0x00CD,  // -> capital i with acute
    0x004B,  // capital k
    0x1E30,  // -> capital k with acute
    0x004C,  // capital l
    0x0139,  // -> capital l with acute
    0x004D,  // capital m
    0x1E3E,  // -> capital m with acute
    0x004E,  // capital n
    0x0143,  // -> capital n with acute
    0x004F,  // capital o
    0x00D3,  // -> capital o with acute
    0x0050,  // capital p
    0x1E54,  // -> capital p with acute
    0x0052,  // capital r
    0x0154,  // -> capital r with acute
    0x0053,  // capital s
    0x015A,  // -> capital s with acute
    0x0055,  // capital u
    0x00DA,  // -> capital u with acute
    0x0057,  // capital w
    0x1E82,  // -> capital w with acute
    0x0059,  // capital y
    0x00DD,  // -> capital y with acute
    0x005A,  // capital z
    0x0179,  // -> capital z with acute
    0x0061,  // letter a
    0x00E1,  // -> letter a with acute
    0x0063,  // letter c
    0x00E7,  // -> letter c with cedilla
    0x0065,  // letter e
    0x00E9,  // -> letter e with acute
    0x0067,  // letter g
    0x01F5,  // -> letter g with acute
    0x0069,  // letter i
    0x00ED,  // -> letter i with acute
    0x006B,  // letter k
    0x1E31,  // -> letter k with acute
    0x006C,  // letter l
    0x013A,  // -> letter l with acute
    0x006D,  // letter m
    0x1E3F,  // -> letter m with acute
    0x006E,  // letter n
    0x0144,  // -> letter n with acute
    0x006F,  // letter o
    0x00F3,  // -> letter o with acute
    0x0070,  // letter p
    0x1E55,  // -> letter p with acute
    0x0072,  // letter r
    0x0155,  // -> letter r with acute
    0x0073,  // letter s
    0x015B,  // -> letter s with acute
    0x0075,  // letter u
    0x00FA,  // -> letter u with acute
    0x0077,  // letter w
    0x1E83,  // -> letter w with acute
    0x0079,  // letter y
    0x00FD,  // -> letter y with acute
    0x007A,  // letter z
    0x017A,  // -> letter z with acute
    0x00C2,  // capital a with circumflex
    0x1EA4,  // -> capital a with circumflex and acute
    0x00C5,  // capital a with ring above
    0x01FA,  // -> capital a with ring above and acute
    0x00C6,  // capital ae
    0x01FC,  // -> capital ae with acute
    0x00C7,  // capital c with cedilla
    0x1E08,  // -> capital c with cedilla and acute
    0x00CA,  // capital e with circumflex
    0x1EBE,  // -> capital e with circumflex and acute
    0x00CF,  // capital i with diaeresis
    0x1E2E,  // -> capital i with diaeresis and acute
    0x00D4,  // capital o with circumflex
    0x1ED0,  // -> capital o with circumflex and acute
    0x00D5,  // capital o with tilde
    0x1E4C,  // -> capital o with tilde and acute
    0x00D8,  // capital o with stroke
    0x01FE,  // -> capital o with stroke and acute
    0x00DC,  // capital u with diaeresis
    0x01D7,  // -> capital u with diaeresis and acute
    0x00E2,  // letter a with circumflex
    0x1EA5,  // -> letter a with circumflex and acute
    0x00E5,  // letter a with ring above
    0x01FB,  // -> letter a with ring above and acute
    0x00E6,  // letter ae
    0x01FD,  // -> letter ae with acute
    0x00E7,  // letter c with cedilla
    0x1E09,  // -> letter c with cedilla and acute
    0x00EA,  // letter e with circumflex
    0x1EBF,  // -> letter e with circumflex and acute
    0x00EF,  // letter i with diaeresis
    0x1E2F,  // -> letter i with diaeresis and acute
    0x00F4,  // letter o with circumflex
    0x1ED1,  // -> letter o with circumflex and acute
    0x00F5,  // letter o with tilde
    0x1E4D,  // -> letter o with tilde and acute
    0x00F8,  // letter o with stroke
    0x01FF,  // -> letter o with stroke and acute
    0x00FC,  // letter u with diaeresis
    0x01D8,  // -> letter u with diaeresis and acute
    0x0102,  // capital a with breve
    0x1EAE,  // -> capital a with breve and acute
    0x0103,  // letter a with breve
    0x1EAF,  // -> letter a with breve and acute
    0x0112,  // capital e with macron
    0x1E16,  // -> capital e with macron and acute
    0x0113,  // letter e with macron
    0x1E17,  // -> letter e with macron and acute
    0x014C,  // capital o with macron
    0x1E52,  // -> capital o with macron and acute
    0x014D,  // letter o with macron
    0x1E53,  // -> letter o with macron and acute
    0x0168,  // capital u with tilde
    0x1E78,  // -> capital u with tilde and acute
    0x0169,  // letter u with tilde
    0x1E79,  // -> letter u with tilde and acute
    0x0391,  // capital alpha
    0x0386,  // -> capital alpha with tonos
    0x0395,  // capital epsilon
    0x0388,  // -> capital epsilon with tonos
    0x0397,  // capital eta
    0x0389,  // -> capital eta with tonos
    0x0399,  // capital iota
    0x038A,  // -> capital iota with tonos
    0x039F,  // capital omicron
    0x038C,  // -> capital omicron with tonos
    0x03A5,  // capital upsilon
    0x038E,  // -> capital upsilon with tonos
    0x03A9,  // capital omega
    0x038F,  // -> capital omega with tonos
    0x03B1,  // letter alpha
    0x03AC,  // -> letter alpha with tonos
    0x03B5,  // letter epsilon
    0x03AD,  // -> letter epsilon with tonos
    0x03B7,  // letter eta
    0x03AE,  // -> letter eta with tonos
    0x03B9,  // letter iota
    0x03AF,  // -> letter iota with tonos
    0x03BF,  // letter omicron
    0x03CC,  // -> letter omicron with tonos
    0x03C5,  // letter upsilon
    0x03CD,  // -> letter upsilon with tonos
    0x03C9,  // letter omega
    0x03CE,  // -> letter omega with tonos
    0x03CA,  // letter iota with dialytika
    0x0390,  // -> letter iota with dialytika and tonos
    0x03CB,  // letter upsilon with dialytika
    0x03B0,  // -> letter upsilon with dialytika and tonos
    0x0413,  // cyrillic capital ghe
    0x0403,  // -> cyrillic capital gje
    0x041A,  // cyrillic capital ka
    0x040C,  // -> cyrillic capital kje
    0x0433,  // cyrillic small ghe
    0x0453,  // -> cyrillic small gje
    0x043A,  // cyrillic small ka
    0x045C,  // -> cyrillic small kje
    0x1F00,  // letter alpha with psili
    0x1F04,  // -> letter alpha with psili and oxia
    0x1F01,  // letter alpha with dasia
    0x1F05,  // -> letter alpha with dasia and oxia
    0x1F08,  // capital alpha with psili
    0x1F0C,  // -> capital alpha with psili and oxia
    0x1F09,  // capital alpha with dasia
    0x1F0D,  // -> capital alpha with dasia and oxia
    0x1F10,  // letter epsilon with psili
    0x1F14,  // -> letter epsilon with psili and oxia
    0x1F11,  // letter epsilon with dasia
    0x1F15,  // -> letter epsilon with dasia and oxia
    0x1F18,  // capital epsilon with psili
    0x1F1C,  // -> capital epsilon with psili and oxia
    0x1F19,  // capital epsilon with dasia
    0x1F1D,  // -> capital epsilon with dasia and oxia
    0x1F20,  // letter eta with psili
    0x1F24,  // -> letter eta with psili and oxia
    0x1F21,  // letter eta with dasia
    0x1F25,  // -> letter eta with dasia and oxia
    0x1F28,  // capital eta with psili
    0x1F2C,  // -> capital eta with psili and oxia
    0x1F29,  // capital eta with dasia
    0x1F2D,  // -> capital eta with dasia and oxia
    0x1F30,  // letter iota with psili
    0x1F34,  // -> letter iota with psili and oxia
    0x1F31,  // letter iota with dasia
    0x1F35,  // -> letter iota with dasia and oxia
    0x1F38,  // capital iota with psili
    0x1F3C,  // -> capital iota with psili and oxia
    0x1F39,  // capital iota with dasia
    0x1F3D,  // -> capital iota with dasia and oxia
    0x1F40,  // letter omicron with psili
    0x1F44,  // -> letter omicron with psili and oxia
    0x1F41,  // letter omicron with dasia
    0x1F45,  // -> letter omicron with dasia and oxia
    0x1F48,  // capital omicron with psili
    0x1F4C,  // -> capital omicron with psili and oxia
    0x1F49,  // capital omicron with dasia
    0x1F4D,  // -> capital omicron with dasia and oxia
    0x1F50,  // letter upsilon with psili
    0x1F54,  // -> letter upsilon with psili and oxia
    0x1F51,  // letter upsilon with dasia
    0x1F55,  // -> letter upsilon with dasia and oxia
    0x1F59,  // capital upsilon with dasia
    0x1F5D,  // -> capital upsilon with dasia and oxia
    0x1F60,  // letter omega with psili
    0x1F64,  // -> letter omega with psili and oxia
    0x1F61,  // letter omega with dasia
    0x1F65,  // -> letter omega with dasia and oxia
    0x1F68,  // capital omega with psili
    0x1F6C,  // -> capital omega with psili and oxia
    0x1F69,  // capital omega with dasia
    0x1F6D,  // -> capital omega with dasia and oxia
    //   internal dead_key table
    0x000A,          // number of entries
    0x0302,  // combining circumflex accent
    0x0520,
    0x0303,  // combining tilde
    0x0530,
    0x0304,  // combining macron
    0x053C,
    0x0306,  // combining breve
    0x0548,
    0x0308,  // combining diaeresis
    0x0550,
    0x030A,  // combining ring above
    0x0560,
    0x0313,  // combining comma above
    0x0568,
    0x0314,  // combining reversed comma above
    0x0586,
    0x031B,  // combining horn
    0x05A6,
    0x0327,  // combining cedilla
    0x05B2,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0478:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     <quotation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0007,          // number of entries
    0x0020,  // space
    0x0385,  // -> dialytika tonos
    0x0049,  // capital i
    0x1E2E,  // -> capital i with diaeresis and acute
    0x0055,  // capital u
    0x01D7,  // -> capital u with diaeresis and acute
    0x0069,  // letter i
    0x1E2F,  // -> letter i with diaeresis and acute
    0x0075,  // letter u
    0x01D8,  // -> letter u with diaeresis and acute
    0x03B9,  // letter iota
    0x0390,  // -> letter iota with dialytika and tonos
    0x03C5,  // letter upsilon
    0x03B0,  // -> letter upsilon with dialytika and tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x048A:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000E,          // number of entries
    0x0391,  // capital alpha
    0x1F0D,  // -> capital alpha with dasia and oxia
    0x0395,  // capital epsilon
    0x1F1D,  // -> capital epsilon with dasia and oxia
    0x0397,  // capital eta
    0x1F2D,  // -> capital eta with dasia and oxia
    0x0399,  // capital iota
    0x1F3D,  // -> capital iota with dasia and oxia
    0x039F,  // capital omicron
    0x1F4D,  // -> capital omicron with dasia and oxia
    0x03A5,  // capital upsilon
    0x1F5D,  // -> capital upsilon with dasia and oxia
    0x03A9,  // capital omega
    0x1F6D,  // -> capital omega with dasia and oxia
    0x03B1,  // letter alpha
    0x1F05,  // -> letter alpha with dasia and oxia
    0x03B5,  // letter epsilon
    0x1F15,  // -> letter epsilon with dasia and oxia
    0x03B7,  // letter eta
    0x1F25,  // -> letter eta with dasia and oxia
    0x03B9,  // letter iota
    0x1F35,  // -> letter iota with dasia and oxia
    0x03BF,  // letter omicron
    0x1F45,  // -> letter omicron with dasia and oxia
    0x03C5,  // letter upsilon
    0x1F55,  // -> letter upsilon with dasia and oxia
    0x03C9,  // letter omega
    0x1F65,  // -> letter omega with dasia and oxia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x04AA:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000D,          // number of entries
    0x0391,  // capital alpha
    0x1F0C,  // -> capital alpha with psili and oxia
    0x0395,  // capital epsilon
    0x1F1C,  // -> capital epsilon with psili and oxia
    0x0397,  // capital eta
    0x1F2C,  // -> capital eta with psili and oxia
    0x0399,  // capital iota
    0x1F3C,  // -> capital iota with psili and oxia
    0x039F,  // capital omicron
    0x1F4C,  // -> capital omicron with psili and oxia
    0x03A9,  // capital omega
    0x1F6C,  // -> capital omega with psili and oxia
    0x03B1,  // letter alpha
    0x1F04,  // -> letter alpha with psili and oxia
    0x03B5,  // letter epsilon
    0x1F14,  // -> letter epsilon with psili and oxia
    0x03B7,  // letter eta
    0x1F24,  // -> letter eta with psili and oxia
    0x03B9,  // letter iota
    0x1F34,  // -> letter iota with psili and oxia
    0x03BF,  // letter omicron
    0x1F44,  // -> letter omicron with psili and oxia
    0x03C5,  // letter upsilon
    0x1F54,  // -> letter upsilon with psili and oxia
    0x03C9,  // letter omega
    0x1F64,  // -> letter omega with psili and oxia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x04C8:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     <plus sign>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EDA,  // -> capital o with horn and acute
    0x0055,  // capital u
    0x1EE8,  // -> capital u with horn and acute
    0x006F,  // letter o
    0x1EDB,  // -> letter o with horn and acute
    0x0075,  // letter u
    0x1EE9,  // -> letter u with horn and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x04D4:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     <solidus>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x01FE,  // -> capital o with stroke and acute
    0x006F,  // letter o
    0x01FF,  // -> letter o with stroke and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x04DC:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     <circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EA4,  // -> capital a with circumflex and acute
    0x0045,  // capital e
    0x1EBE,  // -> capital e with circumflex and acute
    0x004F,  // capital o
    0x1ED0,  // -> capital o with circumflex and acute
    0x0061,  // letter a
    0x1EA5,  // -> letter a with circumflex and acute
    0x0065,  // letter e
    0x1EBF,  // -> letter e with circumflex and acute
    0x006F,  // letter o
    0x1ED1,  // -> letter o with circumflex and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x04EC:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     <low line>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0045,  // capital e
    0x1E16,  // -> capital e with macron and acute
    0x004F,  // capital o
    0x1E52,  // -> capital o with macron and acute
    0x0065,  // letter e
    0x1E17,  // -> letter e with macron and acute
    0x006F,  // letter o
    0x1E53,  // -> letter o with macron and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x04F8:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     <latin small letter b>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EAE,  // -> capital a with breve and acute
    0x0061,  // letter a
    0x1EAF,  // -> letter a with breve and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0500:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     <tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1E4C,  // -> capital o with tilde and acute
    0x0055,  // capital u
    0x1E78,  // -> capital u with tilde and acute
    0x006F,  // letter o
    0x1E4D,  // -> letter o with tilde and acute
    0x0075,  // letter u
    0x1E79,  // -> letter u with tilde and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x050C:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     <macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0045,  // capital e
    0x1E16,  // -> capital e with macron and acute
    0x004F,  // capital o
    0x1E52,  // -> capital o with macron and acute
    0x0065,  // letter e
    0x1E17,  // -> letter e with macron and acute
    0x006F,  // letter o
    0x1E53,  // -> letter o with macron and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0518:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     <cedilla>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0043,  // capital c
    0x1E08,  // -> capital c with cedilla and acute
    0x0063,  // letter c
    0x1E09,  // -> letter c with cedilla and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0520:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     Dead<combining circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EA4,  // -> capital a with circumflex and acute
    0x0045,  // capital e
    0x1EBE,  // -> capital e with circumflex and acute
    0x004F,  // capital o
    0x1ED0,  // -> capital o with circumflex and acute
    0x0061,  // letter a
    0x1EA5,  // -> letter a with circumflex and acute
    0x0065,  // letter e
    0x1EBF,  // -> letter e with circumflex and acute
    0x006F,  // letter o
    0x1ED1,  // -> letter o with circumflex and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0530:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     Dead<combining tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1E4C,  // -> capital o with tilde and acute
    0x0055,  // capital u
    0x1E78,  // -> capital u with tilde and acute
    0x006F,  // letter o
    0x1E4D,  // -> letter o with tilde and acute
    0x0075,  // letter u
    0x1E79,  // -> letter u with tilde and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x053C:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     Dead<combining macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0045,  // capital e
    0x1E16,  // -> capital e with macron and acute
    0x004F,  // capital o
    0x1E52,  // -> capital o with macron and acute
    0x0065,  // letter e
    0x1E17,  // -> letter e with macron and acute
    0x006F,  // letter o
    0x1E53,  // -> letter o with macron and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0548:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     Dead<combining breve>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EAE,  // -> capital a with breve and acute
    0x0061,  // letter a
    0x1EAF,  // -> letter a with breve and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0550:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     Dead<combining diaeresis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0049,  // capital i
    0x1E2E,  // -> capital i with diaeresis and acute
    0x0055,  // capital u
    0x01D7,  // -> capital u with diaeresis and acute
    0x0069,  // letter i
    0x1E2F,  // -> letter i with diaeresis and acute
    0x0075,  // letter u
    0x01D8,  // -> letter u with diaeresis and acute
    0x03B9,  // letter iota
    0x0390,  // -> letter iota with dialytika and tonos
    0x03C5,  // letter upsilon
    0x03B0,  // -> letter upsilon with dialytika and tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0560:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     Dead<combining ring above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x01FA,  // -> capital a with ring above and acute
    0x0061,  // letter a
    0x01FB,  // -> letter a with ring above and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0568:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000D,          // number of entries
    0x0391,  // capital alpha
    0x1F0C,  // -> capital alpha with psili and oxia
    0x0395,  // capital epsilon
    0x1F1C,  // -> capital epsilon with psili and oxia
    0x0397,  // capital eta
    0x1F2C,  // -> capital eta with psili and oxia
    0x0399,  // capital iota
    0x1F3C,  // -> capital iota with psili and oxia
    0x039F,  // capital omicron
    0x1F4C,  // -> capital omicron with psili and oxia
    0x03A9,  // capital omega
    0x1F6C,  // -> capital omega with psili and oxia
    0x03B1,  // letter alpha
    0x1F04,  // -> letter alpha with psili and oxia
    0x03B5,  // letter epsilon
    0x1F14,  // -> letter epsilon with psili and oxia
    0x03B7,  // letter eta
    0x1F24,  // -> letter eta with psili and oxia
    0x03B9,  // letter iota
    0x1F34,  // -> letter iota with psili and oxia
    0x03BF,  // letter omicron
    0x1F44,  // -> letter omicron with psili and oxia
    0x03C5,  // letter upsilon
    0x1F54,  // -> letter upsilon with psili and oxia
    0x03C9,  // letter omega
    0x1F64,  // -> letter omega with psili and oxia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0586:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000E,          // number of entries
    0x0391,  // capital alpha
    0x1F0D,  // -> capital alpha with dasia and oxia
    0x0395,  // capital epsilon
    0x1F1D,  // -> capital epsilon with dasia and oxia
    0x0397,  // capital eta
    0x1F2D,  // -> capital eta with dasia and oxia
    0x0399,  // capital iota
    0x1F3D,  // -> capital iota with dasia and oxia
    0x039F,  // capital omicron
    0x1F4D,  // -> capital omicron with dasia and oxia
    0x03A5,  // capital upsilon
    0x1F5D,  // -> capital upsilon with dasia and oxia
    0x03A9,  // capital omega
    0x1F6D,  // -> capital omega with dasia and oxia
    0x03B1,  // letter alpha
    0x1F05,  // -> letter alpha with dasia and oxia
    0x03B5,  // letter epsilon
    0x1F15,  // -> letter epsilon with dasia and oxia
    0x03B7,  // letter eta
    0x1F25,  // -> letter eta with dasia and oxia
    0x03B9,  // letter iota
    0x1F35,  // -> letter iota with dasia and oxia
    0x03BF,  // letter omicron
    0x1F45,  // -> letter omicron with dasia and oxia
    0x03C5,  // letter upsilon
    0x1F55,  // -> letter upsilon with dasia and oxia
    0x03C9,  // letter omega
    0x1F65,  // -> letter omega with dasia and oxia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x05A6:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     Dead<combining horn>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EDA,  // -> capital o with horn and acute
    0x0055,  // capital u
    0x1EE8,  // -> capital u with horn and acute
    0x006F,  // letter o
    0x1EDB,  // -> letter o with horn and acute
    0x0075,  // letter u
    0x1EE9,  // -> letter u with horn and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x05B2:
    //   prefix:
    //     Compose
    //     <apostrophe>
    //     Dead<combining cedilla>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0043,  // capital c
    0x1E08,  // -> capital c with cedilla and acute
    0x0063,  // letter c
    0x1E09,  // -> letter c with cedilla and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x05BA:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //   internal character table
    0x00AD,          // number of entries
    0x0020,  // space
    0x074A,
    0x0030,  // digit zero
    0x07A8,
    0x0031,  // digit one
    0x07AE,
    0x0032,  // digit two
    0x080C,
    0x0033,  // digit three
    0x086A,
    0x0034,  // digit four
    0x08C8,
    0x0035,  // digit five
    0x0926,
    0x0036,  // digit six
    0x0934,
    0x0037,  // digit seven
    0x093A,
    0x0038,  // digit eight
    0x0940,
    0x0039,  // digit nine
    0x0946,
    0x0041,  // capital a
    0x094C,
    0x0042,  // capital b
    0x0952,
    0x0043,  // capital c
    0x0958,
    0x0044,  // capital d
    0x095E,
    0x0045,  // capital e
    0x0964,
    0x0046,  // capital f
    0x096A,
    0x0047,  // capital g
    0x0970,
    0x0048,  // capital h
    0x0976,
    0x0049,  // capital i
    0x097C,
    0x004A,  // capital j
    0x0982,
    0x004B,  // capital k
    0x0988,
    0x004C,  // capital l
    0x098E,
    0x004D,  // capital m
    0x0994,
    0x004E,  // capital n
    0x099A,
    0x004F,  // capital o
    0x09A0,
    0x0050,  // capital p
    0x09A6,
    0x0051,  // capital q
    0x09AC,
    0x0052,  // capital r
    0x09B2,
    0x0053,  // capital s
    0x09B8,
    0x0054,  // capital t
    0x09BE,
    0x0055,  // capital u
    0x09C4,
    0x0056,  // capital v
    0x09CA,
    0x0057,  // capital w
    0x09D0,
    0x0058,  // capital x
    0x09D6,
    0x0059,  // capital y
    0x09DC,
    0x005A,  // capital z
    0x09E2,
    0x0061,  // letter a
    0x09E8,
    0x0062,  // letter b
    0x09EE,
    0x0063,  // letter c
    0x09F4,
    0x0064,  // letter d
    0x09FA,
    0x0065,  // letter e
    0x0A00,
    0x0066,  // letter f
    0x0A06,
    0x0067,  // letter g
    0x0A0C,
    0x0068,  // letter h
    0x0A12,
    0x0069,  // letter i
    0x0A18,
    0x006A,  // letter j
    0x0A1E,
    0x006B,  // letter k
    0x0A24,
    0x006C,  // letter l
    0x0A2A,
    0x006D,  // letter m
    0x0A30,
    0x006E,  // letter n
    0x0A36,
    0x006F,  // letter o
    0x0A3C,
    0x0070,  // letter p
    0x0A42,
    0x0071,  // letter q
    0x0A48,
    0x0072,  // letter r
    0x0A4E,
    0x0073,  // letter s
    0x0A54,
    0x0074,  // letter t
    0x0A5A,
    0x0075,  // letter u
    0x0A60,
    0x0076,  // letter v
    0x0A66,
    0x0077,  // letter w
    0x0A6C,
    0x0078,  // letter x
    0x0A72,
    0x0079,  // letter y
    0x0A78,
    0x007A,  // letter z
    0x0A7E,
    0x1100,  // hangul choseong kiyeok
    0x0A84,
    0x1102,  // hangul choseong nieun
    0x0A92,
    0x1103,  // hangul choseong tikeut
    0x0AA0,
    0x1105,  // hangul choseong rieul
    0x0AAE,
    0x1106,  // hangul choseong mieum
    0x0ABC,
    0x1107,  // hangul choseong pieup
    0x0ACA,
    0x1109,  // hangul choseong sios
    0x0AD8,
    0x110B,  // hangul choseong ieung
    0x0AE6,
    0x110C,  // hangul choseong cieuc
    0x0AF4,
    0x110E,  // hangul choseong chieuch
    0x0B02,
    0x110F,  // hangul choseong khieukh
    0x0B10,
    0x1110,  // hangul choseong thieuth
    0x0B1E,
    0x1111,  // hangul choseong phieuph
    0x0B2C,
    0x1112,  // hangul choseong hieuh
    0x0B3A,
    0x30A2,  // katakana a
    0x0B48,
    0x30A4,  // katakana i
    0x0B4E,
    0x30A6,  // katakana u
    0x0B54,
    0x30A8,  // katakana e
    0x0B5A,
    0x30AA,  // katakana o
    0x0B60,
    0x30AB,  // katakana ka
    0x0B66,
    0x30AD,  // katakana ki
    0x0B6C,
    0x30AF,  // katakana ku
    0x0B72,
    0x30B1,  // katakana ke
    0x0B78,
    0x30B3,  // katakana ko
    0x0B7E,
    0x30B5,  // katakana sa
    0x0B84,
    0x30B7,  // katakana si
    0x0B8A,
    0x30B9,  // katakana su
    0x0B90,
    0x30BB,  // katakana se
    0x0B96,
    0x30BD,  // katakana so
    0x0B9C,
    0x30BF,  // katakana ta
    0x0BA2,
    0x30C1,  // katakana ti
    0x0BA8,
    0x30C4,  // katakana tu
    0x0BAE,
    0x30C6,  // katakana te
    0x0BB4,
    0x30C8,  // katakana to
    0x0BBA,
    0x30CA,  // katakana na
    0x0BC0,
    0x30CB,  // katakana ni
    0x0BC6,
    0x30CC,  // katakana nu
    0x0BCC,
    0x30CD,  // katakana ne
    0x0BD2,
    0x30CE,  // katakana no
    0x0BD8,
    0x30CF,  // katakana ha
    0x0BDE,
    0x30D2,  // katakana hi
    0x0BE4,
    0x30D5,  // katakana hu
    0x0BEA,
    0x30D8,  // katakana he
    0x0BF0,
    0x30DB,  // katakana ho
    0x0BF6,
    0x30DE,  // katakana ma
    0x0BFC,
    0x30DF,  // katakana mi
    0x0C02,
    0x30E0,  // katakana mu
    0x0C08,
    0x30E1,  // katakana me
    0x0C0E,
    0x30E2,  // katakana mo
    0x0C14,
    0x30E4,  // katakana ya
    0x0C1A,
    0x30E6,  // katakana yu
    0x0C20,
    0x30E8,  // katakana yo
    0x0C26,
    0x30E9,  // katakana ra
    0x0C2C,
    0x30EA,  // katakana ri
    0x0C32,
    0x30EB,  // katakana ru
    0x0C38,
    0x30EC,  // katakana re
    0x0C3E,
    0x30ED,  // katakana ro
    0x0C44,
    0x30EF,  // katakana wa
    0x0C4A,
    0x30F0,  // katakana wi
    0x0C50,
    0x30F1,  // katakana we
    0x0C56,
    0x30F2,  // katakana wo
    0x0C5C,
    0x4E00,  // cjk unified ideograph-4e00
    0x0C62,
    0x4E03,  // cjk unified ideograph-4e03
    0x0C68,
    0x4E09,  // cjk unified ideograph-4e09
    0x0C6E,
    0x4E0A,  // cjk unified ideograph-4e0a
    0x0C74,
    0x4E0B,  // cjk unified ideograph-4e0b
    0x0C7A,
    0x4E2D,  // cjk unified ideograph-4e2d
    0x0C80,
    0x4E5D,  // cjk unified ideograph-4e5d
    0x0C86,
    0x4E8C,  // cjk unified ideograph-4e8c
    0x0C8C,
    0x4E94,  // cjk unified ideograph-4e94
    0x0C92,
    0x4F01,  // cjk unified ideograph-4f01
    0x0C98,
    0x4F11,  // cjk unified ideograph-4f11
    0x0C9E,
    0x512A,  // cjk unified ideograph-512a
    0x0CA4,
    0x516B,  // cjk unified ideograph-516b
    0x0CAA,
    0x516D,  // cjk unified ideograph-516d
    0x0CB0,
    0x5199,  // cjk unified ideograph-5199
    0x0CB6,
    0x52B4,  // cjk unified ideograph-52b4
    0x0CBC,
    0x533B,  // cjk unified ideograph-533b
    0x0CC2,
    0x5341,  // cjk unified ideograph-5341
    0x0CC8,
    0x5354,  // cjk unified ideograph-5354
    0x0CCE,
    0x5370,  // cjk unified ideograph-5370
    0x0CD4,
    0x53F3,  // cjk unified ideograph-53f3
    0x0CDA,
    0x540D,  // cjk unified ideograph-540d
    0x0CE0,
    0x56DB,  // cjk unified ideograph-56db
    0x0CE6,
    0x571F,  // cjk unified ideograph-571f
    0x0CEC,
    0x591C,  // cjk unified ideograph-591c
    0x0CF2,
    0x5973,  // cjk unified ideograph-5973
    0x0CF8,
    0x5B66,  // cjk unified ideograph-5b66
    0x0CFE,
    0x5B97,  // cjk unified ideograph-5b97
    0x0D04,
    0x5DE6,  // cjk unified ideograph-5de6
    0x0D0A,
    0x65E5,  // cjk unified ideograph-65e5
    0x0D10,
    0x6708,  // cjk unified ideograph-6708
    0x0D16,
    0x6709,  // cjk unified ideograph-6709
    0x0D1C,
    0x6728,  // cjk unified ideograph-6728
    0x0D22,
    0x682A,  // cjk unified ideograph-682a
    0x0D28,
    0x6B63,  // cjk unified ideograph-6b63
    0x0D2E,
    0x6C34,  // cjk unified ideograph-6c34
    0x0D34,
    0x6CE8,  // cjk unified ideograph-6ce8
    0x0D3A,
    0x706B,  // cjk unified ideograph-706b
    0x0D40,
    0x7279,  // cjk unified ideograph-7279
    0x0D46,
    0x7537,  // cjk unified ideograph-7537
    0x0D4C,
    0x76E3,  // cjk unified ideograph-76e3
    0x0D52,
    0x793E,  // cjk unified ideograph-793e
    0x0D58,
    0x795D,  // cjk unified ideograph-795d
    0x0D5E,
    0x79D8,  // cjk unified ideograph-79d8
    0x0D64,
    0x8CA1,  // cjk unified ideograph-8ca1
    0x0D6A,
    0x8CC7,  // cjk unified ideograph-8cc7
    0x0D70,
    0x9069,  // cjk unified ideograph-9069
    0x0D76,
    0x91D1,  // cjk unified ideograph-91d1
    0x0D7C,
    0x9805,  // cjk unified ideograph-9805
    0x0D82,
    //   leaf character table
    0x0019,          // number of entries
    0x0020,  // space
    0x02D8,  // -> breve
    0x0028,  // left parenthesis
    0x005B,  // -> left square bracket
    0x002D,  // hyphen-minus
    0x007B,  // -> left curly bracket
    0x0041,  // capital a
    0x0102,  // -> capital a with breve
    0x0047,  // capital g
    0x011E,  // -> capital g with breve
    0x0061,  // letter a
    0x0103,  // -> letter a with breve
    0x0063,  // letter c
    0x00A9,  // -> copyright sign
    0x0067,  // letter g
    0x011F,  // -> letter g with breve
    0x0072,  // letter r
    0x00AE,  // -> registered sign
    0x0391,  // capital alpha
    0x1F09,  // -> capital alpha with dasia
    0x0395,  // capital epsilon
    0x1F19,  // -> capital epsilon with dasia
    0x0397,  // capital eta
    0x1F29,  // -> capital eta with dasia
    0x0399,  // capital iota
    0x1F39,  // -> capital iota with dasia
    0x039F,  // capital omicron
    0x1F49,  // -> capital omicron with dasia
    0x03A1,  // capital rho
    0x1FEC,  // -> capital rho with dasia
    0x03A5,  // capital upsilon
    0x1F59,  // -> capital upsilon with dasia
    0x03A9,  // capital omega
    0x1F69,  // -> capital omega with dasia
    0x03B1,  // letter alpha
    0x1F01,  // -> letter alpha with dasia
    0x03B5,  // letter epsilon
    0x1F11,  // -> letter epsilon with dasia
    0x03B7,  // letter eta
    0x1F21,  // -> letter eta with dasia
    0x03B9,  // letter iota
    0x1F31,  // -> letter iota with dasia
    0x03BF,  // letter omicron
    0x1F41,  // -> letter omicron with dasia
    0x03C1,  // letter rho
    0x1FE5,  // -> letter rho with dasia
    0x03C5,  // letter upsilon
    0x1F51,  // -> letter upsilon with dasia
    0x03C9,  // letter omega
    0x1F61,  // -> letter omega with dasia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x074A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <space>
    //   internal character table
    0x000B,          // number of entries
    0x0020,  // space
    0x0766,
    0x0030,  // digit zero
    0x076C,
    0x0031,  // digit one
    0x0772,
    0x0032,  // digit two
    0x0778,
    0x0033,  // digit three
    0x077E,
    0x0034,  // digit four
    0x0784,
    0x0035,  // digit five
    0x078A,
    0x0036,  // digit six
    0x0790,
    0x0037,  // digit seven
    0x0796,
    0x0038,  // digit eight
    0x079C,
    0x0039,  // digit nine
    0x07A2,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x2461,  // -> circled digit two
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0766:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <space>
    //     <space>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3252,  // -> circled number twenty two
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x076C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <space>
    //     <digit zero>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x2473,  // -> circled number twenty
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0772:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <space>
    //     <digit one>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3251,  // -> circled number twenty one
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0778:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <space>
    //     <digit two>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3252,  // -> circled number twenty two
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x077E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <space>
    //     <digit three>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3253,  // -> circled number twenty three
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0784:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <space>
    //     <digit four>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3254,  // -> circled number twenty four
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x078A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <space>
    //     <digit five>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3255,  // -> circled number twenty five
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0790:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <space>
    //     <digit six>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3256,  // -> circled number twenty six
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0796:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <space>
    //     <digit seven>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3257,  // -> circled number twenty seven
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x079C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <space>
    //     <digit eight>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3258,  // -> circled number twenty eight
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x07A2:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <space>
    //     <digit nine>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3259,  // -> circled number twenty nine
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x07A8:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit zero>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24EA,  // -> circled digit zero
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x07AE:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit one>
    //   internal character table
    0x000B,          // number of entries
    0x0020,  // space
    0x07CA,
    0x0030,  // digit zero
    0x07D0,
    0x0031,  // digit one
    0x07D6,
    0x0032,  // digit two
    0x07DC,
    0x0033,  // digit three
    0x07E2,
    0x0034,  // digit four
    0x07E8,
    0x0035,  // digit five
    0x07EE,
    0x0036,  // digit six
    0x07F4,
    0x0037,  // digit seven
    0x07FA,
    0x0038,  // digit eight
    0x0800,
    0x0039,  // digit nine
    0x0806,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x2460,  // -> circled digit one
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x07CA:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit one>
    //     <space>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x246B,  // -> circled number twelve
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x07D0:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit one>
    //     <digit zero>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x2469,  // -> circled number ten
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x07D6:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit one>
    //     <digit one>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x246A,  // -> circled number eleven
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x07DC:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit one>
    //     <digit two>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x246B,  // -> circled number twelve
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x07E2:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit one>
    //     <digit three>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x246C,  // -> circled number thirteen
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x07E8:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit one>
    //     <digit four>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x246D,  // -> circled number fourteen
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x07EE:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit one>
    //     <digit five>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x246E,  // -> circled number fifteen
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x07F4:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit one>
    //     <digit six>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x246F,  // -> circled number sixteen
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x07FA:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit one>
    //     <digit seven>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x2470,  // -> circled number seventeen
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0800:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit one>
    //     <digit eight>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x2471,  // -> circled number eighteen
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0806:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit one>
    //     <digit nine>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x2472,  // -> circled number nineteen
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x080C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit two>
    //   internal character table
    0x000B,          // number of entries
    0x0020,  // space
    0x0828,
    0x0030,  // digit zero
    0x082E,
    0x0031,  // digit one
    0x0834,
    0x0032,  // digit two
    0x083A,
    0x0033,  // digit three
    0x0840,
    0x0034,  // digit four
    0x0846,
    0x0035,  // digit five
    0x084C,
    0x0036,  // digit six
    0x0852,
    0x0037,  // digit seven
    0x0858,
    0x0038,  // digit eight
    0x085E,
    0x0039,  // digit nine
    0x0864,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x2461,  // -> circled digit two
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0828:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit two>
    //     <space>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3252,  // -> circled number twenty two
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x082E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit two>
    //     <digit zero>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x2473,  // -> circled number twenty
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0834:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit two>
    //     <digit one>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3251,  // -> circled number twenty one
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x083A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit two>
    //     <digit two>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3252,  // -> circled number twenty two
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0840:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit two>
    //     <digit three>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3253,  // -> circled number twenty three
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0846:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit two>
    //     <digit four>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3254,  // -> circled number twenty four
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x084C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit two>
    //     <digit five>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3255,  // -> circled number twenty five
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0852:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit two>
    //     <digit six>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3256,  // -> circled number twenty six
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0858:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit two>
    //     <digit seven>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3257,  // -> circled number twenty seven
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x085E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit two>
    //     <digit eight>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3258,  // -> circled number twenty eight
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0864:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit two>
    //     <digit nine>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3259,  // -> circled number twenty nine
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x086A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit three>
    //   internal character table
    0x000B,          // number of entries
    0x0020,  // space
    0x0886,
    0x0030,  // digit zero
    0x088C,
    0x0031,  // digit one
    0x0892,
    0x0032,  // digit two
    0x0898,
    0x0033,  // digit three
    0x089E,
    0x0034,  // digit four
    0x08A4,
    0x0035,  // digit five
    0x08AA,
    0x0036,  // digit six
    0x08B0,
    0x0037,  // digit seven
    0x08B6,
    0x0038,  // digit eight
    0x08BC,
    0x0039,  // digit nine
    0x08C2,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x2462,  // -> circled digit three
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0886:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit three>
    //     <space>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x325C,  // -> circled number thirty two
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x088C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit three>
    //     <digit zero>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x325A,  // -> circled number thirty
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0892:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit three>
    //     <digit one>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x325B,  // -> circled number thirty one
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0898:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit three>
    //     <digit two>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x325C,  // -> circled number thirty two
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x089E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit three>
    //     <digit three>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x325D,  // -> circled number thirty three
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x08A4:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit three>
    //     <digit four>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x325E,  // -> circled number thirty four
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x08AA:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit three>
    //     <digit five>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x325F,  // -> circled number thirty five
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x08B0:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit three>
    //     <digit six>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32B1,  // -> circled number thirty six
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x08B6:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit three>
    //     <digit seven>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32B2,  // -> circled number thirty seven
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x08BC:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit three>
    //     <digit eight>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32B3,  // -> circled number thirty eight
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x08C2:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit three>
    //     <digit nine>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32B4,  // -> circled number thirty nine
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x08C8:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit four>
    //   internal character table
    0x000B,          // number of entries
    0x0020,  // space
    0x08E4,
    0x0030,  // digit zero
    0x08EA,
    0x0031,  // digit one
    0x08F0,
    0x0032,  // digit two
    0x08F6,
    0x0033,  // digit three
    0x08FC,
    0x0034,  // digit four
    0x0902,
    0x0035,  // digit five
    0x0908,
    0x0036,  // digit six
    0x090E,
    0x0037,  // digit seven
    0x0914,
    0x0038,  // digit eight
    0x091A,
    0x0039,  // digit nine
    0x0920,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x2463,  // -> circled digit four
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x08E4:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit four>
    //     <space>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32B7,  // -> circled number forty two
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x08EA:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit four>
    //     <digit zero>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32B5,  // -> circled number forty
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x08F0:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit four>
    //     <digit one>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32B6,  // -> circled number forty one
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x08F6:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit four>
    //     <digit two>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32B7,  // -> circled number forty two
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x08FC:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit four>
    //     <digit three>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32B8,  // -> circled number forty three
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0902:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit four>
    //     <digit four>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32B9,  // -> circled number forty four
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0908:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit four>
    //     <digit five>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32BA,  // -> circled number forty five
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x090E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit four>
    //     <digit six>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32BB,  // -> circled number forty six
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0914:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit four>
    //     <digit seven>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32BC,  // -> circled number forty seven
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x091A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit four>
    //     <digit eight>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32BD,  // -> circled number forty eight
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0920:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit four>
    //     <digit nine>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32BE,  // -> circled number forty nine
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0926:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit five>
    //   internal character table
    0x0001,          // number of entries
    0x0030,  // digit zero
    0x092E,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x2464,  // -> circled digit five
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x092E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit five>
    //     <digit zero>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32BF,  // -> circled number fifty
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0934:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit six>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x2465,  // -> circled digit six
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x093A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit seven>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x2466,  // -> circled digit seven
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0940:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit eight>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x2467,  // -> circled digit eight
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0946:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <digit nine>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x2468,  // -> circled digit nine
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x094C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24B6,  // -> circled latin capital a
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0952:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter b>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24B7,  // -> circled latin capital b
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0958:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter c>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24B8,  // -> circled latin capital c
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x095E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter d>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24B9,  // -> circled latin capital d
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0964:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter e>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24BA,  // -> circled latin capital e
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x096A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter f>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24BB,  // -> circled latin capital f
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0970:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter g>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24BC,  // -> circled latin capital g
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0976:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter h>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24BD,  // -> circled latin capital h
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x097C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter i>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24BE,  // -> circled latin capital i
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0982:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter j>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24BF,  // -> circled latin capital j
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0988:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter k>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24C0,  // -> circled latin capital k
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x098E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter l>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24C1,  // -> circled latin capital l
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0994:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter m>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24C2,  // -> circled latin capital m
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x099A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter n>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24C3,  // -> circled latin capital n
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x09A0:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter o>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24C4,  // -> circled latin capital o
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x09A6:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter p>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24C5,  // -> circled latin capital p
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x09AC:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter q>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24C6,  // -> circled latin capital q
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x09B2:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter r>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24C7,  // -> circled latin capital r
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x09B8:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter s>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24C8,  // -> circled latin capital s
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x09BE:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter t>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24C9,  // -> circled latin capital t
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x09C4:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter u>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24CA,  // -> circled latin capital u
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x09CA:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter v>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24CB,  // -> circled latin capital v
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x09D0:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter w>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24CC,  // -> circled latin capital w
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x09D6:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter x>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24CD,  // -> circled latin capital x
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x09DC:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter y>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24CE,  // -> circled latin capital y
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x09E2:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin capital letter z>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24CF,  // -> circled latin capital z
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x09E8:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24D0,  // -> circled latin small a
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x09EE:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter b>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24D1,  // -> circled latin small b
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x09F4:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter c>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24D2,  // -> circled latin small c
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x09FA:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter d>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24D3,  // -> circled latin small d
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A00:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter e>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24D4,  // -> circled latin small e
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A06:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter f>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24D5,  // -> circled latin small f
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A0C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter g>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24D6,  // -> circled latin small g
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A12:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter h>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24D7,  // -> circled latin small h
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A18:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter i>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24D8,  // -> circled latin small i
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A1E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter j>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24D9,  // -> circled latin small j
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A24:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter k>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24DA,  // -> circled latin small k
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A2A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter l>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24DB,  // -> circled latin small l
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A30:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter m>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24DC,  // -> circled latin small m
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A36:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter n>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24DD,  // -> circled latin small n
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A3C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter o>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24DE,  // -> circled latin small o
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A42:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter p>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24DF,  // -> circled latin small p
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A48:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter q>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24E0,  // -> circled latin small q
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A4E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter r>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24E1,  // -> circled latin small r
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A54:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter s>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24E2,  // -> circled latin small s
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A5A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter t>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24E3,  // -> circled latin small t
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A60:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter u>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24E4,  // -> circled latin small u
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A66:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter v>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24E5,  // -> circled latin small v
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A6C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter w>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24E6,  // -> circled latin small w
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A72:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter x>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24E7,  // -> circled latin small x
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A78:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter y>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24E8,  // -> circled latin small y
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A7E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <latin small letter z>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x24E9,  // -> circled latin small z
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A84:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong kiyeok>
    //   internal character table
    0x0001,          // number of entries
    0x1161,  // hangul jungseong a
    0x0A8C,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3260,  // -> circled hangul kiyeok
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A8C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong kiyeok>
    //     <hangul jungseong a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x326E,  // -> circled hangul kiyeok a
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A92:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong nieun>
    //   internal character table
    0x0001,          // number of entries
    0x1161,  // hangul jungseong a
    0x0A9A,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3261,  // -> circled hangul nieun
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0A9A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong nieun>
    //     <hangul jungseong a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x326F,  // -> circled hangul nieun a
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0AA0:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong tikeut>
    //   internal character table
    0x0001,          // number of entries
    0x1161,  // hangul jungseong a
    0x0AA8,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3262,  // -> circled hangul tikeut
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0AA8:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong tikeut>
    //     <hangul jungseong a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3270,  // -> circled hangul tikeut a
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0AAE:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong rieul>
    //   internal character table
    0x0001,          // number of entries
    0x1161,  // hangul jungseong a
    0x0AB6,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3263,  // -> circled hangul rieul
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0AB6:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong rieul>
    //     <hangul jungseong a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3271,  // -> circled hangul rieul a
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0ABC:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong mieum>
    //   internal character table
    0x0001,          // number of entries
    0x1161,  // hangul jungseong a
    0x0AC4,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3264,  // -> circled hangul mieum
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0AC4:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong mieum>
    //     <hangul jungseong a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3272,  // -> circled hangul mieum a
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0ACA:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong pieup>
    //   internal character table
    0x0001,          // number of entries
    0x1161,  // hangul jungseong a
    0x0AD2,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3265,  // -> circled hangul pieup
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0AD2:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong pieup>
    //     <hangul jungseong a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3273,  // -> circled hangul pieup a
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0AD8:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong sios>
    //   internal character table
    0x0001,          // number of entries
    0x1161,  // hangul jungseong a
    0x0AE0,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3266,  // -> circled hangul sios
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0AE0:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong sios>
    //     <hangul jungseong a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3274,  // -> circled hangul sios a
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0AE6:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong ieung>
    //   internal character table
    0x0001,          // number of entries
    0x1161,  // hangul jungseong a
    0x0AEE,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3267,  // -> circled hangul ieung
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0AEE:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong ieung>
    //     <hangul jungseong a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3275,  // -> circled hangul ieung a
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0AF4:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong cieuc>
    //   internal character table
    0x0001,          // number of entries
    0x1161,  // hangul jungseong a
    0x0AFC,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3268,  // -> circled hangul cieuc
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0AFC:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong cieuc>
    //     <hangul jungseong a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3276,  // -> circled hangul cieuc a
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B02:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong chieuch>
    //   internal character table
    0x0001,          // number of entries
    0x1161,  // hangul jungseong a
    0x0B0A,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3269,  // -> circled hangul chieuch
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B0A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong chieuch>
    //     <hangul jungseong a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3277,  // -> circled hangul chieuch a
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B10:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong khieukh>
    //   internal character table
    0x0001,          // number of entries
    0x1161,  // hangul jungseong a
    0x0B18,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x326A,  // -> circled hangul khieukh
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B18:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong khieukh>
    //     <hangul jungseong a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3278,  // -> circled hangul khieukh a
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B1E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong thieuth>
    //   internal character table
    0x0001,          // number of entries
    0x1161,  // hangul jungseong a
    0x0B26,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x326B,  // -> circled hangul thieuth
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B26:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong thieuth>
    //     <hangul jungseong a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3279,  // -> circled hangul thieuth a
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B2C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong phieuph>
    //   internal character table
    0x0001,          // number of entries
    0x1161,  // hangul jungseong a
    0x0B34,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x326C,  // -> circled hangul phieuph
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B34:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong phieuph>
    //     <hangul jungseong a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x327A,  // -> circled hangul phieuph a
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B3A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong hieuh>
    //   internal character table
    0x0001,          // number of entries
    0x1161,  // hangul jungseong a
    0x0B42,
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x326D,  // -> circled hangul hieuh
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B42:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <hangul choseong hieuh>
    //     <hangul jungseong a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x327B,  // -> circled hangul hieuh a
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B48:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32D0,  // -> circled katakana a
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B4E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter i>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32D1,  // -> circled katakana i
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B54:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter u>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32D2,  // -> circled katakana u
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B5A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter e>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32D3,  // -> circled katakana e
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B60:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter o>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32D4,  // -> circled katakana o
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B66:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter ka>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32D5,  // -> circled katakana ka
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B6C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter ki>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32D6,  // -> circled katakana ki
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B72:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter ku>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32D7,  // -> circled katakana ku
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B78:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter ke>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32D8,  // -> circled katakana ke
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B7E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter ko>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32D9,  // -> circled katakana ko
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B84:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter sa>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32DA,  // -> circled katakana sa
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B8A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter si>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32DB,  // -> circled katakana si
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B90:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter su>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32DC,  // -> circled katakana su
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B96:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter se>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32DD,  // -> circled katakana se
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0B9C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter so>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32DE,  // -> circled katakana so
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0BA2:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter ta>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32DF,  // -> circled katakana ta
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0BA8:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter ti>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32E0,  // -> circled katakana ti
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0BAE:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter tu>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32E1,  // -> circled katakana tu
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0BB4:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter te>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32E2,  // -> circled katakana te
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0BBA:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32E3,  // -> circled katakana to
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0BC0:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter na>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32E4,  // -> circled katakana na
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0BC6:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter ni>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32E5,  // -> circled katakana ni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0BCC:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter nu>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32E6,  // -> circled katakana nu
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0BD2:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter ne>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32E7,  // -> circled katakana ne
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0BD8:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter no>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32E8,  // -> circled katakana no
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0BDE:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter ha>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32E9,  // -> circled katakana ha
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0BE4:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter hi>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32EA,  // -> circled katakana hi
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0BEA:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter hu>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32EB,  // -> circled katakana hu
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0BF0:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter he>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32EC,  // -> circled katakana he
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0BF6:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter ho>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32ED,  // -> circled katakana ho
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0BFC:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter ma>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32EE,  // -> circled katakana ma
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C02:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter mi>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32EF,  // -> circled katakana mi
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C08:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter mu>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32F0,  // -> circled katakana mu
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C0E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter me>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32F1,  // -> circled katakana me
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C14:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter mo>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32F2,  // -> circled katakana mo
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C1A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter ya>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32F3,  // -> circled katakana ya
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C20:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter yu>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32F4,  // -> circled katakana yu
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C26:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter yo>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32F5,  // -> circled katakana yo
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C2C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter ra>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32F6,  // -> circled katakana ra
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C32:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter ri>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32F7,  // -> circled katakana ri
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C38:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter ru>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32F8,  // -> circled katakana ru
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C3E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter re>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32F9,  // -> circled katakana re
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C44:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter ro>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32FA,  // -> circled katakana ro
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C4A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter wa>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32FB,  // -> circled katakana wa
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C50:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter wi>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32FC,  // -> circled katakana wi
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C56:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter we>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32FD,  // -> circled katakana we
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C5C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <katakana letter wo>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32FE,  // -> circled katakana wo
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C62:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-4e00>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3280,  // -> circled ideograph one
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C68:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-4e03>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3286,  // -> circled ideograph seven
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C6E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-4e09>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3282,  // -> circled ideograph three
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C74:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-4e0a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32A4,  // -> circled ideograph high
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C7A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-4e0b>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32A6,  // -> circled ideograph low
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C80:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-4e2d>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32A5,  // -> circled ideograph centre
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C86:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-4e5d>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3288,  // -> circled ideograph nine
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C8C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-4e8c>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3281,  // -> circled ideograph two
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C92:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-4e94>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3284,  // -> circled ideograph five
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C98:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-4f01>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32AD,  // -> circled ideograph enterprise
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0C9E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-4f11>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32A1,  // -> circled ideograph rest
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0CA4:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-512a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x329D,  // -> circled ideograph excellent
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0CAA:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-516b>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3287,  // -> circled ideograph eight
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0CB0:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-516d>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3285,  // -> circled ideograph six
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0CB6:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-5199>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32A2,  // -> circled ideograph copy
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0CBC:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-52b4>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3298,  // -> circled ideograph labor
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0CC2:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-533b>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32A9,  // -> circled ideograph medicine
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0CC8:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-5341>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3289,  // -> circled ideograph ten
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0CCE:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-5354>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32AF,  // -> circled ideograph alliance
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0CD4:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-5370>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x329E,  // -> circled ideograph print
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0CDA:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-53f3>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32A8,  // -> circled ideograph right
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0CE0:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-540d>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3294,  // -> circled ideograph name
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0CE6:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-56db>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3283,  // -> circled ideograph four
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0CEC:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-571f>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x328F,  // -> circled ideograph earth
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0CF2:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-591c>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32B0,  // -> circled ideograph night
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0CF8:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-5973>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x329B,  // -> circled ideograph female
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0CFE:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-5b66>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32AB,  // -> circled ideograph study
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D04:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-5b97>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32AA,  // -> circled ideograph religion
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D0A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-5de6>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32A7,  // -> circled ideograph left
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D10:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-65e5>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3290,  // -> circled ideograph sun
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D16:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-6708>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x328A,  // -> circled ideograph moon
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D1C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-6709>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3292,  // -> circled ideograph have
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D22:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-6728>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x328D,  // -> circled ideograph wood
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D28:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-682a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3291,  // -> circled ideograph stock
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D2E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-6b63>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32A3,  // -> circled ideograph correct
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D34:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-6c34>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x328C,  // -> circled ideograph water
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D3A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-6ce8>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x329F,  // -> circled ideograph attention
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D40:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-706b>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x328B,  // -> circled ideograph fire
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D46:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-7279>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3295,  // -> circled ideograph special
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D4C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-7537>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x329A,  // -> circled ideograph male
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D52:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-76e3>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32AC,  // -> circled ideograph supervise
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D58:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-793e>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3293,  // -> circled ideograph society
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D5E:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-795d>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3297,  // -> circled ideograph congratulation
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D64:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-79d8>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3299,  // -> circled ideograph secret
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D6A:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-8ca1>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x3296,  // -> circled ideograph financial
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D70:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-8cc7>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32AE,  // -> circled ideograph resource
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D76:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-9069>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x329C,  // -> circled ideograph suitable
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D7C:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-91d1>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x328E,  // -> circled ideograph metal
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D82:
    //   prefix:
    //     Compose
    //     <left parenthesis>
    //     <cjk unified ideograph-9805>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0029,  // right parenthesis
    0x32A0,  // -> circled ideograph item
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0D88:
    //   prefix:
    //     Compose
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0010,          // number of entries
    0x0029,  // right parenthesis
    0x005D,  // -> right square bracket
    0x002D,  // hyphen-minus
    0x007D,  // -> right curly bracket
    0x0391,  // capital alpha
    0x1F08,  // -> capital alpha with psili
    0x0395,  // capital epsilon
    0x1F18,  // -> capital epsilon with psili
    0x0397,  // capital eta
    0x1F28,  // -> capital eta with psili
    0x0399,  // capital iota
    0x1F38,  // -> capital iota with psili
    0x039F,  // capital omicron
    0x1F48,  // -> capital omicron with psili
    0x03A9,  // capital omega
    0x1F68,  // -> capital omega with psili
    0x03B1,  // letter alpha
    0x1F00,  // -> letter alpha with psili
    0x03B5,  // letter epsilon
    0x1F10,  // -> letter epsilon with psili
    0x03B7,  // letter eta
    0x1F20,  // -> letter eta with psili
    0x03B9,  // letter iota
    0x1F30,  // -> letter iota with psili
    0x03BF,  // letter omicron
    0x1F40,  // -> letter omicron with psili
    0x03C1,  // letter rho
    0x1FE4,  // -> letter rho with psili
    0x03C5,  // letter upsilon
    0x1F50,  // -> letter upsilon with psili
    0x03C9,  // letter omega
    0x1F60,  // -> letter omega with psili
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0DAC:
    //   prefix:
    //     Compose
    //     <asterisk>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0005,          // number of entries
    0x0030,  // digit zero
    0x00B0,  // -> degree sign
    0x0041,  // capital a
    0x00C5,  // -> capital a with ring above
    0x0055,  // capital u
    0x016E,  // -> capital u with ring above
    0x0061,  // letter a
    0x00E5,  // -> letter a with ring above
    0x0075,  // letter u
    0x016F,  // -> letter u with ring above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0DBA:
    //   prefix:
    //     Compose
    //     <plus sign>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x002B,  // plus sign
    0x0023,  // -> number sign
    0x002D,  // hyphen-minus
    0x00B1,  // -> plus-minus sign
    0x004F,  // capital o
    0x01A0,  // -> capital o with horn
    0x0055,  // capital u
    0x01AF,  // -> capital u with horn
    0x006F,  // letter o
    0x01A1,  // -> letter o with horn
    0x0075,  // letter u
    0x01B0,  // -> letter u with horn
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0DCA:
    //   prefix:
    //     Compose
    //     <comma>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0021,          // number of entries
    0x0020,  // space
    0x00B8,  // -> cedilla
    0x0022,  // quotation mark
    0x201E,  // -> double low-9 quotation mark
    0x0027,  // apostrophe
    0x201A,  // -> single low-9 quotation mark
    0x002C,  // comma
    0x00B8,  // -> cedilla
    0x002D,  // hyphen-minus
    0x00AC,  // -> not sign
    0x0041,  // capital a
    0x0104,  // -> capital a with ogonek
    0x0043,  // capital c
    0x00C7,  // -> capital c with cedilla
    0x0044,  // capital d
    0x1E10,  // -> capital d with cedilla
    0x0045,  // capital e
    0x0118,  // -> capital e with ogonek
    0x0047,  // capital g
    0x0122,  // -> capital g with cedilla
    0x0048,  // capital h
    0x1E28,  // -> capital h with cedilla
    0x0049,  // capital i
    0x012E,  // -> capital i with ogonek
    0x004B,  // capital k
    0x0136,  // -> capital k with cedilla
    0x004C,  // capital l
    0x013B,  // -> capital l with cedilla
    0x004E,  // capital n
    0x0145,  // -> capital n with cedilla
    0x0052,  // capital r
    0x0156,  // -> capital r with cedilla
    0x0053,  // capital s
    0x015E,  // -> capital s with cedilla
    0x0054,  // capital t
    0x0162,  // -> capital t with cedilla
    0x0055,  // capital u
    0x0172,  // -> capital u with ogonek
    0x0061,  // letter a
    0x0105,  // -> letter a with ogonek
    0x0063,  // letter c
    0x00E7,  // -> letter c with cedilla
    0x0064,  // letter d
    0x1E11,  // -> letter d with cedilla
    0x0065,  // letter e
    0x0119,  // -> letter e with ogonek
    0x0067,  // letter g
    0x0123,  // -> letter g with cedilla
    0x0068,  // letter h
    0x1E29,  // -> letter h with cedilla
    0x0069,  // letter i
    0x012F,  // -> letter i with ogonek
    0x006B,  // letter k
    0x0137,  // -> letter k with cedilla
    0x006C,  // letter l
    0x013C,  // -> letter l with cedilla
    0x006E,  // letter n
    0x0146,  // -> letter n with cedilla
    0x0072,  // letter r
    0x0157,  // -> letter r with cedilla
    0x0073,  // letter s
    0x015F,  // -> letter s with cedilla
    0x0074,  // letter t
    0x0163,  // -> letter t with cedilla
    0x0075,  // letter u
    0x0173,  // -> letter u with ogonek
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0E10:
    //   prefix:
    //     Compose
    //     <hyphen-minus>
    //   internal character table
    0x0001,          // number of entries
    0x002D,  // hyphen-minus
    0x0E4A,
    //   leaf character table
    0x001A,          // number of entries
    0x0020,  // space
    0x007E,  // -> tilde
    0x0028,  // left parenthesis
    0x007B,  // -> left curly bracket
    0x0029,  // right parenthesis
    0x007D,  // -> right curly bracket
    0x002B,  // plus sign
    0x00B1,  // -> plus-minus sign
    0x002C,  // comma
    0x00AC,  // -> not sign
    0x003A,  // colon
    0x00F7,  // -> division sign
    0x003E,  // greater-than sign
    0x2192,  // -> rightwards arrow
    0x0041,  // capital a
    0x00C3,  // -> capital a with tilde
    0x0044,  // capital d
    0x0110,  // -> capital d with stroke
    0x0045,  // capital e
    0x0112,  // -> capital e with macron
    0x0049,  // capital i
    0x012A,  // -> capital i with macron
    0x004C,  // capital l
    0x00A3,  // -> pound sign
    0x004E,  // capital n
    0x00D1,  // -> capital n with tilde
    0x004F,  // capital o
    0x00D5,  // -> capital o with tilde
    0x0055,  // capital u
    0x016A,  // -> capital u with macron
    0x0059,  // capital y
    0x00A5,  // -> yen sign
    0x005E,  // circumflex accent
    0x00AF,  // -> macron
    0x0061,  // letter a
    0x0101,  // -> letter a with macron
    0x0064,  // letter d
    0x0111,  // -> letter d with stroke
    0x0065,  // letter e
    0x0113,  // -> letter e with macron
    0x0069,  // letter i
    0x012B,  // -> letter i with macron
    0x006C,  // letter l
    0x00A3,  // -> pound sign
    0x006E,  // letter n
    0x00F1,  // -> letter n with tilde
    0x006F,  // letter o
    0x014D,  // -> letter o with macron
    0x0075,  // letter u
    0x016B,  // -> letter u with macron
    0x0079,  // letter y
    0x00A5,  // -> yen sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0E4A:
    //   prefix:
    //     Compose
    //     <hyphen-minus>
    //     <hyphen-minus>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x0020,  // space
    0x00AD,  // -> soft hyphen
    0x002D,  // hyphen-minus
    0x2014,  // -> em dash
    0x002E,  // full stop
    0x2013,  // -> en dash
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0E54:
    //   prefix:
    //     Compose
    //     <full stop>
    //   internal character table
    0x0003,          // number of entries
    0x0021,  // exclamation mark
    0x0ECE,
    0x0027,  // apostrophe
    0x0ED6,
    0x00B4,  // acute accent
    0x0EDE,
    //   leaf character table
    0x0035,          // number of entries
    0x002D,  // hyphen-minus
    0x00B7,  // -> middle dot
    0x002E,  // full stop
    0x2026,  // -> horizontal ellipsis
    0x003C,  // less-than sign
    0x2039,  // -> single left-pointing angle quotation mark
    0x003D,  // equals sign
    0x2022,  // -> bullet
    0x003E,  // greater-than sign
    0x203A,  // -> single right-pointing angle quotation mark
    0x0041,  // capital a
    0x0226,  // -> capital a with dot above
    0x0042,  // capital b
    0x1E02,  // -> capital b with dot above
    0x0043,  // capital c
    0x010A,  // -> capital c with dot above
    0x0044,  // capital d
    0x1E0A,  // -> capital d with dot above
    0x0045,  // capital e
    0x0116,  // -> capital e with dot above
    0x0046,  // capital f
    0x1E1E,  // -> capital f with dot above
    0x0047,  // capital g
    0x0120,  // -> capital g with dot above
    0x0048,  // capital h
    0x1E22,  // -> capital h with dot above
    0x0049,  // capital i
    0x0130,  // -> capital i with dot above
    0x004D,  // capital m
    0x1E40,  // -> capital m with dot above
    0x004E,  // capital n
    0x1E44,  // -> capital n with dot above
    0x004F,  // capital o
    0x022E,  // -> capital o with dot above
    0x0050,  // capital p
    0x1E56,  // -> capital p with dot above
    0x0052,  // capital r
    0x1E58,  // -> capital r with dot above
    0x0053,  // capital s
    0x1E60,  // -> capital s with dot above
    0x0054,  // capital t
    0x1E6A,  // -> capital t with dot above
    0x0057,  // capital w
    0x1E86,  // -> capital w with dot above
    0x0058,  // capital x
    0x1E8A,  // -> capital x with dot above
    0x0059,  // capital y
    0x1E8E,  // -> capital y with dot above
    0x005A,  // capital z
    0x017B,  // -> capital z with dot above
    0x005E,  // circumflex accent
    0x00B7,  // -> middle dot
    0x0061,  // letter a
    0x0227,  // -> letter a with dot above
    0x0062,  // letter b
    0x1E03,  // -> letter b with dot above
    0x0063,  // letter c
    0x010B,  // -> letter c with dot above
    0x0064,  // letter d
    0x1E0B,  // -> letter d with dot above
    0x0065,  // letter e
    0x0117,  // -> letter e with dot above
    0x0066,  // letter f
    0x1E1F,  // -> letter f with dot above
    0x0067,  // letter g
    0x0121,  // -> letter g with dot above
    0x0068,  // letter h
    0x1E23,  // -> letter h with dot above
    0x0069,  // letter i
    0x0131,  // -> letter dotless i
    0x006D,  // letter m
    0x1E41,  // -> letter m with dot above
    0x006E,  // letter n
    0x1E45,  // -> letter n with dot above
    0x006F,  // letter o
    0x022F,  // -> letter o with dot above
    0x0070,  // letter p
    0x1E57,  // -> letter p with dot above
    0x0072,  // letter r
    0x1E59,  // -> letter r with dot above
    0x0073,  // letter s
    0x1E61,  // -> letter s with dot above
    0x0074,  // letter t
    0x1E6B,  // -> letter t with dot above
    0x0077,  // letter w
    0x1E87,  // -> letter w with dot above
    0x0078,  // letter x
    0x1E8B,  // -> letter x with dot above
    0x0079,  // letter y
    0x1E8F,  // -> letter y with dot above
    0x007A,  // letter z
    0x017C,  // -> letter z with dot above
    0x015A,  // capital s with acute
    0x1E64,  // -> capital s with acute and dot above
    0x015B,  // letter s with acute
    0x1E65,  // -> letter s with acute and dot above
    0x0160,  // capital s with caron
    0x1E66,  // -> capital s with caron and dot above
    0x0161,  // letter s with caron
    0x1E67,  // -> letter s with caron and dot above
    0x017F,  // letter long s
    0x1E9B,  // -> letter long s with dot above
    0x1E62,  // capital s with dot below
    0x1E68,  // -> capital s with dot below and dot above
    0x1E63,  // letter s with dot below
    0x1E69,  // -> letter s with dot below and dot above
    //   internal dead_key table
    0x0003,          // number of entries
    0x0301,  // combining acute accent
    0x0EE6,
    0x030C,  // combining caron
    0x0EEE,
    0x0323,  // combining dot below
    0x0EF6,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0ECE:
    //   prefix:
    //     Compose
    //     <full stop>
    //     <exclamation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0053,  // capital s
    0x1E68,  // -> capital s with dot below and dot above
    0x0073,  // letter s
    0x1E69,  // -> letter s with dot below and dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0ED6:
    //   prefix:
    //     Compose
    //     <full stop>
    //     <apostrophe>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0053,  // capital s
    0x1E64,  // -> capital s with acute and dot above
    0x0073,  // letter s
    0x1E65,  // -> letter s with acute and dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0EDE:
    //   prefix:
    //     Compose
    //     <full stop>
    //     <acute accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0053,  // capital s
    0x1E64,  // -> capital s with acute and dot above
    0x0073,  // letter s
    0x1E65,  // -> letter s with acute and dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0EE6:
    //   prefix:
    //     Compose
    //     <full stop>
    //     Dead<combining acute accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0053,  // capital s
    0x1E64,  // -> capital s with acute and dot above
    0x0073,  // letter s
    0x1E65,  // -> letter s with acute and dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0EEE:
    //   prefix:
    //     Compose
    //     <full stop>
    //     Dead<combining caron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0053,  // capital s
    0x1E66,  // -> capital s with caron and dot above
    0x0073,  // letter s
    0x1E67,  // -> letter s with caron and dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0EF6:
    //   prefix:
    //     Compose
    //     <full stop>
    //     Dead<combining dot below>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0053,  // capital s
    0x1E68,  // -> capital s with dot below and dot above
    0x0073,  // letter s
    0x1E69,  // -> letter s with dot below and dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0EFE:
    //   prefix:
    //     Compose
    //     <solidus>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0024,          // number of entries
    0x002F,  // solidus
    0x005C,  // -> reverse solidus
    0x003C,  // less-than sign
    0x005C,  // -> reverse solidus
    0x003D,  // equals sign
    0x2260,  // -> not equal to
    0x0043,  // capital c
    0x20A1,  // -> colon sign
    0x0044,  // capital d
    0x0110,  // -> capital d with stroke
    0x0047,  // capital g
    0x01E4,  // -> capital g with stroke
    0x0048,  // capital h
    0x0126,  // -> capital h with stroke
    0x0049,  // capital i
    0x0197,  // -> capital i with stroke
    0x004C,  // capital l
    0x0141,  // -> capital l with stroke
    0x004F,  // capital o
    0x00D8,  // -> capital o with stroke
    0x0054,  // capital t
    0x0166,  // -> capital t with stroke
    0x0055,  // capital u
    0x00B5,  // -> micro sign
    0x005A,  // capital z
    0x01B5,  // -> capital z with stroke
    0x005E,  // circumflex accent
    0x007C,  // -> vertical line
    0x0062,  // letter b
    0x0180,  // -> letter b with stroke
    0x0063,  // letter c
    0x00A2,  // -> cent sign
    0x0064,  // letter d
    0x0111,  // -> letter d with stroke
    0x0067,  // letter g
    0x01E5,  // -> letter g with stroke
    0x0068,  // letter h
    0x0127,  // -> letter h with stroke
    0x0069,  // letter i
    0x0268,  // -> letter i with stroke
    0x006C,  // letter l
    0x0142,  // -> letter l with stroke
    0x006D,  // letter m
    0x20A5,  // -> mill sign
    0x006F,  // letter o
    0x00F8,  // -> letter o with stroke
    0x0074,  // letter t
    0x0167,  // -> letter t with stroke
    0x0075,  // letter u
    0x00B5,  // -> micro sign
    0x007A,  // letter z
    0x01B6,  // -> letter z with stroke
    0x0294,  // letter glottal stop
    0x02A1,  // -> letter glottal stop with stroke
    0x0413,  // cyrillic capital ghe
    0x0492,  // -> cyrillic capital ghe with stroke
    0x041A,  // cyrillic capital ka
    0x049E,  // -> cyrillic capital ka with stroke
    0x0433,  // cyrillic small ghe
    0x0493,  // -> cyrillic small ghe with stroke
    0x043A,  // cyrillic small ka
    0x049F,  // -> cyrillic small ka with stroke
    0x2190,  // leftwards arrow
    0x219A,  // -> leftwards arrow with stroke
    0x2192,  // rightwards arrow
    0x219B,  // -> rightwards arrow with stroke
    0x2194,  // left right arrow
    0x21AE,  // -> left right arrow with stroke
    0x30C3,  // katakana small tu
    0x04B1,  // -> cyrillic small straight u with stroke
    0x30E7,  // katakana small yo
    0x04B0,  // -> cyrillic capital straight u with stroke
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0F4A:
    //   prefix:
    //     Compose
    //     <digit zero>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0008,          // number of entries
    0x002A,  // asterisk
    0x00B0,  // -> degree sign
    0x0043,  // capital c
    0x00A9,  // -> copyright sign
    0x0053,  // capital s
    0x00A7,  // -> section sign
    0x0058,  // capital x
    0x00A4,  // -> currency sign
    0x005E,  // circumflex accent
    0x00B0,  // -> degree sign
    0x0063,  // letter c
    0x00A9,  // -> copyright sign
    0x0073,  // letter s
    0x00A7,  // -> section sign
    0x0078,  // letter x
    0x00A4,  // -> currency sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0F5E:
    //   prefix:
    //     Compose
    //     <digit one>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0009,          // number of entries
    0x0032,  // digit two
    0x00BD,  // -> vulgar fraction one half
    0x0033,  // digit three
    0x2153,  // -> vulgar fraction one third
    0x0034,  // digit four
    0x00BC,  // -> vulgar fraction one quarter
    0x0035,  // digit five
    0x2155,  // -> vulgar fraction one fifth
    0x0036,  // digit six
    0x2159,  // -> vulgar fraction one sixth
    0x0038,  // digit eight
    0x215B,  // -> vulgar fraction one eighth
    0x0053,  // capital s
    0x00B9,  // -> superscript one
    0x005E,  // circumflex accent
    0x00B9,  // -> superscript one
    0x0073,  // letter s
    0x00B9,  // -> superscript one
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0F74:
    //   prefix:
    //     Compose
    //     <digit two>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0005,          // number of entries
    0x0033,  // digit three
    0x2154,  // -> vulgar fraction two thirds
    0x0035,  // digit five
    0x2156,  // -> vulgar fraction two fifths
    0x0053,  // capital s
    0x00B2,  // -> superscript two
    0x005E,  // circumflex accent
    0x00B2,  // -> superscript two
    0x0073,  // letter s
    0x00B2,  // -> superscript two
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0F82:
    //   prefix:
    //     Compose
    //     <digit three>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0034,  // digit four
    0x00BE,  // -> vulgar fraction three quarters
    0x0035,  // digit five
    0x2157,  // -> vulgar fraction three fifths
    0x0038,  // digit eight
    0x215C,  // -> vulgar fraction three eighths
    0x0053,  // capital s
    0x00B3,  // -> superscript three
    0x005E,  // circumflex accent
    0x00B3,  // -> superscript three
    0x0073,  // letter s
    0x00B3,  // -> superscript three
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0F92:
    //   prefix:
    //     Compose
    //     <digit four>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0035,  // digit five
    0x2158,  // -> vulgar fraction four fifths
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0F98:
    //   prefix:
    //     Compose
    //     <digit five>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0036,  // digit six
    0x215A,  // -> vulgar fraction five sixths
    0x0038,  // digit eight
    0x215D,  // -> vulgar fraction five eighths
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0FA0:
    //   prefix:
    //     Compose
    //     <digit seven>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0038,  // digit eight
    0x215E,  // -> vulgar fraction seven eighths
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0FA6:
    //   prefix:
    //     Compose
    //     <colon>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x0028,  // left parenthesis
    0x2639,  // -> white frowning face
    0x0029,  // right parenthesis
    0x263A,  // -> white smiling face
    0x002D,  // hyphen-minus
    0x00F7,  // -> division sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0FB0:
    //   prefix:
    //     Compose
    //     <semicolon>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000A,          // number of entries
    0x0041,  // capital a
    0x0104,  // -> capital a with ogonek
    0x0045,  // capital e
    0x0118,  // -> capital e with ogonek
    0x0049,  // capital i
    0x012E,  // -> capital i with ogonek
    0x004F,  // capital o
    0x01EA,  // -> capital o with ogonek
    0x0055,  // capital u
    0x0172,  // -> capital u with ogonek
    0x0061,  // letter a
    0x0105,  // -> letter a with ogonek
    0x0065,  // letter e
    0x0119,  // -> letter e with ogonek
    0x0069,  // letter i
    0x012F,  // -> letter i with ogonek
    0x006F,  // letter o
    0x01EB,  // -> letter o with ogonek
    0x0075,  // letter u
    0x0173,  // -> letter u with ogonek
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x0FC8:
    //   prefix:
    //     Compose
    //     <less-than sign>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x001B,          // number of entries
    0x0020,  // space
    0x02C7,  // -> caron
    0x0022,  // quotation mark
    0x201C,  // -> left double quotation mark
    0x0027,  // apostrophe
    0x2018,  // -> left single quotation mark
    0x002D,  // hyphen-minus
    0x2190,  // -> leftwards arrow
    0x002F,  // solidus
    0x005C,  // -> reverse solidus
    0x0033,  // digit three
    0x2665,  // -> black heart suit
    0x003C,  // less-than sign
    0x00AB,  // -> left-pointing double angle quotation mark
    0x003D,  // equals sign
    0x2264,  // -> less-than or equal to
    0x0043,  // capital c
    0x010C,  // -> capital c with caron
    0x0044,  // capital d
    0x010E,  // -> capital d with caron
    0x0045,  // capital e
    0x011A,  // -> capital e with caron
    0x004C,  // capital l
    0x013D,  // -> capital l with caron
    0x004E,  // capital n
    0x0147,  // -> capital n with caron
    0x0052,  // capital r
    0x0158,  // -> capital r with caron
    0x0053,  // capital s
    0x0160,  // -> capital s with caron
    0x0054,  // capital t
    0x0164,  // -> capital t with caron
    0x005A,  // capital z
    0x017D,  // -> capital z with caron
    0x0063,  // letter c
    0x010D,  // -> letter c with caron
    0x0064,  // letter d
    0x010F,  // -> letter d with caron
    0x0065,  // letter e
    0x011B,  // -> letter e with caron
    0x006C,  // letter l
    0x013E,  // -> letter l with caron
    0x006E,  // letter n
    0x0148,  // -> letter n with caron
    0x0072,  // letter r
    0x0159,  // -> letter r with caron
    0x0073,  // letter s
    0x0161,  // -> letter s with caron
    0x0074,  // letter t
    0x0165,  // -> letter t with caron
    0x007A,  // letter z
    0x017E,  // -> letter z with caron
    0x0338,  // combining long solidus overlay
    0x226E,  // -> not less-than
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1002:
    //   prefix:
    //     Compose
    //     <equals sign>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0014,          // number of entries
    0x002F,  // solidus
    0x2260,  // -> not equal to
    0x0043,  // capital c
    0x20AC,  // -> euro sign
    0x0045,  // capital e
    0x20AC,  // -> euro sign
    0x004C,  // capital l
    0x20A4,  // -> lira sign
    0x004E,  // capital n
    0x20A6,  // -> naira sign
    0x004F,  // capital o
    0x0150,  // -> capital o with double acute
    0x0055,  // capital u
    0x0170,  // -> capital u with double acute
    0x0057,  // capital w
    0x20A9,  // -> won sign
    0x0059,  // capital y
    0x00A5,  // -> yen sign
    0x0063,  // letter c
    0x20AC,  // -> euro sign
    0x0065,  // letter e
    0x20AC,  // -> euro sign
    0x006C,  // letter l
    0x00A3,  // -> pound sign
    0x006F,  // letter o
    0x0151,  // -> letter o with double acute
    0x0075,  // letter u
    0x0171,  // -> letter u with double acute
    0x0079,  // letter y
    0x00A5,  // -> yen sign
    0x0338,  // combining long solidus overlay
    0x2260,  // -> not equal to
    0x0415,  // cyrillic capital ie
    0x20AC,  // -> euro sign
    0x0421,  // cyrillic capital es
    0x20AC,  // -> euro sign
    0x0423,  // cyrillic capital u
    0x04F2,  // -> cyrillic capital u with double acute
    0x0443,  // cyrillic small u
    0x04F3,  // -> cyrillic small u with double acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x102E:
    //   prefix:
    //     Compose
    //     <greater-than sign>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0010,          // number of entries
    0x0020,  // space
    0x005E,  // -> circumflex accent
    0x0022,  // quotation mark
    0x201D,  // -> right double quotation mark
    0x0027,  // apostrophe
    0x2019,  // -> right single quotation mark
    0x003D,  // equals sign
    0x2265,  // -> greater-than or equal to
    0x003E,  // greater-than sign
    0x00BB,  // -> right-pointing double angle quotation mark
    0x0041,  // capital a
    0x00C2,  // -> capital a with circumflex
    0x0045,  // capital e
    0x00CA,  // -> capital e with circumflex
    0x0049,  // capital i
    0x00CE,  // -> capital i with circumflex
    0x004F,  // capital o
    0x00D4,  // -> capital o with circumflex
    0x0055,  // capital u
    0x00DB,  // -> capital u with circumflex
    0x0061,  // letter a
    0x00E2,  // -> letter a with circumflex
    0x0065,  // letter e
    0x00EA,  // -> letter e with circumflex
    0x0069,  // letter i
    0x00EE,  // -> letter i with circumflex
    0x006F,  // letter o
    0x00F4,  // -> letter o with circumflex
    0x0075,  // letter u
    0x00FB,  // -> letter u with circumflex
    0x0338,  // combining long solidus overlay
    0x226F,  // -> not greater-than
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1052:
    //   prefix:
    //     Compose
    //     <question mark>
    //   internal character table
    0x0003,          // number of entries
    0x002B,  // plus sign
    0x108E,
    0x005E,  // circumflex accent
    0x109A,
    0x0062,  // letter b
    0x10AA,
    //   leaf character table
    0x0016,          // number of entries
    0x0021,  // exclamation mark
    0x2E18,  // -> inverted interrobang
    0x003F,  // question mark
    0x00BF,  // -> inverted question mark
    0x0041,  // capital a
    0x1EA2,  // -> capital a with hook above
    0x0045,  // capital e
    0x1EBA,  // -> capital e with hook above
    0x0049,  // capital i
    0x1EC8,  // -> capital i with hook above
    0x004F,  // capital o
    0x1ECE,  // -> capital o with hook above
    0x0055,  // capital u
    0x1EE6,  // -> capital u with hook above
    0x0059,  // capital y
    0x1EF6,  // -> capital y with hook above
    0x0061,  // letter a
    0x1EA3,  // -> letter a with hook above
    0x0065,  // letter e
    0x1EBB,  // -> letter e with hook above
    0x0069,  // letter i
    0x1EC9,  // -> letter i with hook above
    0x006F,  // letter o
    0x1ECF,  // -> letter o with hook above
    0x0075,  // letter u
    0x1EE7,  // -> letter u with hook above
    0x0079,  // letter y
    0x1EF7,  // -> letter y with hook above
    0x00C2,  // capital a with circumflex
    0x1EA8,  // -> capital a with circumflex and hook above
    0x00CA,  // capital e with circumflex
    0x1EC2,  // -> capital e with circumflex and hook above
    0x00D4,  // capital o with circumflex
    0x1ED4,  // -> capital o with circumflex and hook above
    0x00E2,  // letter a with circumflex
    0x1EA9,  // -> letter a with circumflex and hook above
    0x00EA,  // letter e with circumflex
    0x1EC3,  // -> letter e with circumflex and hook above
    0x00F4,  // letter o with circumflex
    0x1ED5,  // -> letter o with circumflex and hook above
    0x0102,  // capital a with breve
    0x1EB2,  // -> capital a with breve and hook above
    0x0103,  // letter a with breve
    0x1EB3,  // -> letter a with breve and hook above
    //   internal dead_key table
    0x0003,          // number of entries
    0x0302,  // combining circumflex accent
    0x10B2,
    0x0306,  // combining breve
    0x10C2,
    0x031B,  // combining horn
    0x10CA,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x108E:
    //   prefix:
    //     Compose
    //     <question mark>
    //     <plus sign>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EDE,  // -> capital o with horn and hook above
    0x0055,  // capital u
    0x1EEC,  // -> capital u with horn and hook above
    0x006F,  // letter o
    0x1EDF,  // -> letter o with horn and hook above
    0x0075,  // letter u
    0x1EED,  // -> letter u with horn and hook above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x109A:
    //   prefix:
    //     Compose
    //     <question mark>
    //     <circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EA8,  // -> capital a with circumflex and hook above
    0x0045,  // capital e
    0x1EC2,  // -> capital e with circumflex and hook above
    0x004F,  // capital o
    0x1ED4,  // -> capital o with circumflex and hook above
    0x0061,  // letter a
    0x1EA9,  // -> letter a with circumflex and hook above
    0x0065,  // letter e
    0x1EC3,  // -> letter e with circumflex and hook above
    0x006F,  // letter o
    0x1ED5,  // -> letter o with circumflex and hook above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x10AA:
    //   prefix:
    //     Compose
    //     <question mark>
    //     <latin small letter b>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB2,  // -> capital a with breve and hook above
    0x0061,  // letter a
    0x1EB3,  // -> letter a with breve and hook above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x10B2:
    //   prefix:
    //     Compose
    //     <question mark>
    //     Dead<combining circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EA8,  // -> capital a with circumflex and hook above
    0x0045,  // capital e
    0x1EC2,  // -> capital e with circumflex and hook above
    0x004F,  // capital o
    0x1ED4,  // -> capital o with circumflex and hook above
    0x0061,  // letter a
    0x1EA9,  // -> letter a with circumflex and hook above
    0x0065,  // letter e
    0x1EC3,  // -> letter e with circumflex and hook above
    0x006F,  // letter o
    0x1ED5,  // -> letter o with circumflex and hook above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x10C2:
    //   prefix:
    //     Compose
    //     <question mark>
    //     Dead<combining breve>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB2,  // -> capital a with breve and hook above
    0x0061,  // letter a
    0x1EB3,  // -> letter a with breve and hook above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x10CA:
    //   prefix:
    //     Compose
    //     <question mark>
    //     Dead<combining horn>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EDE,  // -> capital o with horn and hook above
    0x0055,  // capital u
    0x1EEC,  // -> capital u with horn and hook above
    0x006F,  // letter o
    0x1EDF,  // -> letter o with horn and hook above
    0x0075,  // letter u
    0x1EED,  // -> letter u with horn and hook above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x10D6:
    //   prefix:
    //     Compose
    //     <latin capital letter a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0010,          // number of entries
    0x0022,  // quotation mark
    0x00C4,  // -> capital a with diaeresis
    0x0027,  // apostrophe
    0x00C1,  // -> capital a with acute
    0x0028,  // left parenthesis
    0x0102,  // -> capital a with breve
    0x002A,  // asterisk
    0x00C5,  // -> capital a with ring above
    0x002C,  // comma
    0x0104,  // -> capital a with ogonek
    0x002D,  // hyphen-minus
    0x00C3,  // -> capital a with tilde
    0x003E,  // greater-than sign
    0x00C2,  // -> capital a with circumflex
    0x0041,  // capital a
    0x00C5,  // -> capital a with ring above
    0x0045,  // capital e
    0x00C6,  // -> capital ae
    0x0054,  // capital t
    0x0040,  // -> commercial at
    0x005E,  // circumflex accent
    0x00C2,  // -> capital a with circumflex
    0x005F,  // low line
    0x00AA,  // -> feminine ordinal indicator
    0x0060,  // grave accent
    0x00C0,  // -> capital a with grave
    0x007E,  // tilde
    0x00C3,  // -> capital a with tilde
    0x00A8,  // diaeresis
    0x00C4,  // -> capital a with diaeresis
    0x00B4,  // acute accent
    0x00C1,  // -> capital a with acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x10FA:
    //   prefix:
    //     Compose
    //     <latin capital letter b>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x002E,  // full stop
    0x1E02,  // -> capital b with dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1100:
    //   prefix:
    //     Compose
    //     <latin capital letter c>
    //   internal character table
    0x0001,          // number of entries
    0x0043,  // capital c
    0x111E,
    //   leaf character table
    0x000C,          // number of entries
    0x0027,  // apostrophe
    0x0106,  // -> capital c with acute
    0x002C,  // comma
    0x00C7,  // -> capital c with cedilla
    0x002E,  // full stop
    0x010A,  // -> capital c with dot above
    0x002F,  // solidus
    0x20A1,  // -> colon sign
    0x0030,  // digit zero
    0x00A9,  // -> copyright sign
    0x003C,  // less-than sign
    0x010C,  // -> capital c with caron
    0x003D,  // equals sign
    0x20AC,  // -> euro sign
    0x0045,  // capital e
    0x20A0,  // -> euro-currency sign
    0x004F,  // capital o
    0x00A9,  // -> copyright sign
    0x006F,  // letter o
    0x00A9,  // -> copyright sign
    0x0072,  // letter r
    0x20A2,  // -> cruzeiro sign
    0x007C,  // vertical line
    0x00A2,  // -> cent sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x111E:
    //   prefix:
    //     Compose
    //     <latin capital letter c>
    //     <latin capital letter c>
    //   internal character table
    0x0001,          // number of entries
    0x0043,  // capital c
    0x1124,
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1124:
    //   prefix:
    //     Compose
    //     <latin capital letter c>
    //     <latin capital letter c>
    //     <latin capital letter c>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0050,  // capital p
    0x262D,  // -> hammer and sickle
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x112A:
    //   prefix:
    //     Compose
    //     <latin capital letter d>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x002D,  // hyphen-minus
    0x0110,  // -> capital d with stroke
    0x002E,  // full stop
    0x1E0A,  // -> capital d with dot above
    0x003C,  // less-than sign
    0x010E,  // -> capital d with caron
    0x0048,  // capital h
    0x00D0,  // -> capital eth
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1136:
    //   prefix:
    //     Compose
    //     <latin capital letter e>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000D,          // number of entries
    0x0022,  // quotation mark
    0x00CB,  // -> capital e with diaeresis
    0x0027,  // apostrophe
    0x00C9,  // -> capital e with acute
    0x002C,  // comma
    0x0118,  // -> capital e with ogonek
    0x002D,  // hyphen-minus
    0x0112,  // -> capital e with macron
    0x002E,  // full stop
    0x0116,  // -> capital e with dot above
    0x003C,  // less-than sign
    0x011A,  // -> capital e with caron
    0x003D,  // equals sign
    0x20AC,  // -> euro sign
    0x003E,  // greater-than sign
    0x00CA,  // -> capital e with circumflex
    0x005E,  // circumflex accent
    0x00CA,  // -> capital e with circumflex
    0x005F,  // low line
    0x0112,  // -> capital e with macron
    0x0060,  // grave accent
    0x00C8,  // -> capital e with grave
    0x00A8,  // diaeresis
    0x00CB,  // -> capital e with diaeresis
    0x00B4,  // acute accent
    0x00C9,  // -> capital e with acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1154:
    //   prefix:
    //     Compose
    //     <latin capital letter f>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x002E,  // full stop
    0x1E1E,  // -> capital f with dot above
    0x0072,  // letter r
    0x20A3,  // -> french franc sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x115C:
    //   prefix:
    //     Compose
    //     <latin capital letter g>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0005,          // number of entries
    0x0028,  // left parenthesis
    0x011E,  // -> capital g with breve
    0x002C,  // comma
    0x0122,  // -> capital g with cedilla
    0x002E,  // full stop
    0x0120,  // -> capital g with dot above
    0x0055,  // capital u
    0x011E,  // -> capital g with breve
    0x02D8,  // breve
    0x011E,  // -> capital g with breve
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x116A:
    //   prefix:
    //     Compose
    //     <latin capital letter i>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000C,          // number of entries
    0x0022,  // quotation mark
    0x00CF,  // -> capital i with diaeresis
    0x0027,  // apostrophe
    0x00CD,  // -> capital i with acute
    0x002C,  // comma
    0x012E,  // -> capital i with ogonek
    0x002D,  // hyphen-minus
    0x012A,  // -> capital i with macron
    0x002E,  // full stop
    0x0130,  // -> capital i with dot above
    0x003E,  // greater-than sign
    0x00CE,  // -> capital i with circumflex
    0x005E,  // circumflex accent
    0x00CE,  // -> capital i with circumflex
    0x005F,  // low line
    0x012A,  // -> capital i with macron
    0x0060,  // grave accent
    0x00CC,  // -> capital i with grave
    0x007E,  // tilde
    0x0128,  // -> capital i with tilde
    0x00A8,  // diaeresis
    0x00CF,  // -> capital i with diaeresis
    0x00B4,  // acute accent
    0x00CD,  // -> capital i with acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1186:
    //   prefix:
    //     Compose
    //     <latin capital letter k>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x002C,  // comma
    0x0136,  // -> capital k with cedilla
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x118C:
    //   prefix:
    //     Compose
    //     <latin capital letter l>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0007,          // number of entries
    0x0027,  // apostrophe
    0x0139,  // -> capital l with acute
    0x002C,  // comma
    0x013B,  // -> capital l with cedilla
    0x002D,  // hyphen-minus
    0x00A3,  // -> pound sign
    0x002F,  // solidus
    0x0141,  // -> capital l with stroke
    0x003C,  // less-than sign
    0x013D,  // -> capital l with caron
    0x003D,  // equals sign
    0x00A3,  // -> pound sign
    0x0056,  // capital v
    0x007C,  // -> vertical line
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x119E:
    //   prefix:
    //     Compose
    //     <latin capital letter m>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x002E,  // full stop
    0x1E40,  // -> capital m with dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x11A4:
    //   prefix:
    //     Compose
    //     <latin capital letter n>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0009,          // number of entries
    0x0027,  // apostrophe
    0x0143,  // -> capital n with acute
    0x002C,  // comma
    0x0145,  // -> capital n with cedilla
    0x002D,  // hyphen-minus
    0x00D1,  // -> capital n with tilde
    0x003C,  // less-than sign
    0x0147,  // -> capital n with caron
    0x003D,  // equals sign
    0x20A6,  // -> naira sign
    0x0047,  // capital g
    0x014A,  // -> capital eng
    0x004F,  // capital o
    0x2116,  // -> numero sign
    0x006F,  // letter o
    0x2116,  // -> numero sign
    0x007E,  // tilde
    0x00D1,  // -> capital n with tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x11BA:
    //   prefix:
    //     Compose
    //     <latin capital letter o>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0014,          // number of entries
    0x0022,  // quotation mark
    0x00D6,  // -> capital o with diaeresis
    0x0027,  // apostrophe
    0x00D3,  // -> capital o with acute
    0x002D,  // hyphen-minus
    0x00D5,  // -> capital o with tilde
    0x002F,  // solidus
    0x00D8,  // -> capital o with stroke
    0x003E,  // greater-than sign
    0x00D4,  // -> capital o with circumflex
    0x0041,  // capital a
    0x24B6,  // -> circled latin capital a
    0x0043,  // capital c
    0x00A9,  // -> copyright sign
    0x0045,  // capital e
    0x0152,  // -> capital ligature oe
    0x0052,  // capital r
    0x00AE,  // -> registered sign
    0x0053,  // capital s
    0x00A7,  // -> section sign
    0x0058,  // capital x
    0x00A4,  // -> currency sign
    0x005E,  // circumflex accent
    0x00D4,  // -> capital o with circumflex
    0x005F,  // low line
    0x00BA,  // -> masculine ordinal indicator
    0x0060,  // grave accent
    0x00D2,  // -> capital o with grave
    0x0063,  // letter c
    0x00A9,  // -> copyright sign
    0x0072,  // letter r
    0x00AE,  // -> registered sign
    0x0078,  // letter x
    0x00A4,  // -> currency sign
    0x007E,  // tilde
    0x00D5,  // -> capital o with tilde
    0x00A8,  // diaeresis
    0x00D6,  // -> capital o with diaeresis
    0x00B4,  // acute accent
    0x00D3,  // -> capital o with acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x11E6:
    //   prefix:
    //     Compose
    //     <latin capital letter p>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0021,  // exclamation mark
    0x00B6,  // -> pilcrow sign
    0x002E,  // full stop
    0x1E56,  // -> capital p with dot above
    0x0050,  // capital p
    0x00B6,  // -> pilcrow sign
    0x0074,  // letter t
    0x20A7,  // -> peseta sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x11F2:
    //   prefix:
    //     Compose
    //     <latin capital letter r>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0005,          // number of entries
    0x0027,  // apostrophe
    0x0154,  // -> capital r with acute
    0x002C,  // comma
    0x0156,  // -> capital r with cedilla
    0x003C,  // less-than sign
    0x0158,  // -> capital r with caron
    0x004F,  // capital o
    0x00AE,  // -> registered sign
    0x0073,  // letter s
    0x20A8,  // -> rupee sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1200:
    //   prefix:
    //     Compose
    //     <latin capital letter s>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000E,          // number of entries
    0x0021,  // exclamation mark
    0x00A7,  // -> section sign
    0x0027,  // apostrophe
    0x015A,  // -> capital s with acute
    0x002C,  // comma
    0x015E,  // -> capital s with cedilla
    0x002E,  // full stop
    0x1E60,  // -> capital s with dot above
    0x0030,  // digit zero
    0x00A7,  // -> section sign
    0x0031,  // digit one
    0x00B9,  // -> superscript one
    0x0032,  // digit two
    0x00B2,  // -> superscript two
    0x0033,  // digit three
    0x00B3,  // -> superscript three
    0x003C,  // less-than sign
    0x0160,  // -> capital s with caron
    0x004D,  // capital m
    0x2120,  // -> service mark
    0x004F,  // capital o
    0x00A7,  // -> section sign
    0x0053,  // capital s
    0x1E9E,  // -> capital sharp s
    0x006D,  // letter m
    0x2120,  // -> service mark
    0x00B8,  // cedilla
    0x015E,  // -> capital s with cedilla
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1220:
    //   prefix:
    //     Compose
    //     <latin capital letter t>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0007,          // number of entries
    0x002D,  // hyphen-minus
    0x0166,  // -> capital t with stroke
    0x002E,  // full stop
    0x1E6A,  // -> capital t with dot above
    0x002F,  // solidus
    0x0166,  // -> capital t with stroke
    0x003C,  // less-than sign
    0x0164,  // -> capital t with caron
    0x0048,  // capital h
    0x00DE,  // -> capital thorn
    0x004D,  // capital m
    0x2122,  // -> trade mark sign
    0x006D,  // letter m
    0x2122,  // -> trade mark sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1232:
    //   prefix:
    //     Compose
    //     <latin capital letter u>
    //   internal character table
    0x0003,          // number of entries
    0x0021,  // exclamation mark
    0x129A,
    0x002C,  // comma
    0x12A2,
    0x00B8,  // cedilla
    0x12AA,
    //   leaf character table
    0x002D,          // number of entries
    0x0022,  // quotation mark
    0x00DC,  // -> capital u with diaeresis
    0x0027,  // apostrophe
    0x00DA,  // -> capital u with acute
    0x002A,  // asterisk
    0x016E,  // -> capital u with ring above
    0x002C,  // comma
    0x0172,  // -> capital u with ogonek
    0x002D,  // hyphen-minus
    0x016A,  // -> capital u with macron
    0x002F,  // solidus
    0x00B5,  // -> micro sign
    0x003E,  // greater-than sign
    0x00DB,  // -> capital u with circumflex
    0x0041,  // capital a
    0x0102,  // -> capital a with breve
    0x0045,  // capital e
    0x0114,  // -> capital e with breve
    0x0047,  // capital g
    0x011E,  // -> capital g with breve
    0x0049,  // capital i
    0x012C,  // -> capital i with breve
    0x004F,  // capital o
    0x014E,  // -> capital o with breve
    0x0055,  // capital u
    0x016C,  // -> capital u with breve
    0x005E,  // circumflex accent
    0x00DB,  // -> capital u with circumflex
    0x005F,  // low line
    0x016A,  // -> capital u with macron
    0x0060,  // grave accent
    0x00D9,  // -> capital u with grave
    0x0061,  // letter a
    0x0103,  // -> letter a with breve
    0x0065,  // letter e
    0x0115,  // -> letter e with breve
    0x0067,  // letter g
    0x011F,  // -> letter g with breve
    0x0069,  // letter i
    0x012D,  // -> letter i with breve
    0x006F,  // letter o
    0x014F,  // -> letter o with breve
    0x0075,  // letter u
    0x016D,  // -> letter u with breve
    0x007E,  // tilde
    0x0168,  // -> capital u with tilde
    0x00A8,  // diaeresis
    0x00DC,  // -> capital u with diaeresis
    0x00B4,  // acute accent
    0x00DA,  // -> capital u with acute
    0x0228,  // capital e with cedilla
    0x1E1C,  // -> capital e with cedilla and breve
    0x0229,  // letter e with cedilla
    0x1E1D,  // -> letter e with cedilla and breve
    0x0391,  // capital alpha
    0x1FB8,  // -> capital alpha with vrachy
    0x0399,  // capital iota
    0x1FD8,  // -> capital iota with vrachy
    0x03A5,  // capital upsilon
    0x1FE8,  // -> capital upsilon with vrachy
    0x03B1,  // letter alpha
    0x1FB0,  // -> letter alpha with vrachy
    0x03B9,  // letter iota
    0x1FD0,  // -> letter iota with vrachy
    0x03C5,  // letter upsilon
    0x1FE0,  // -> letter upsilon with vrachy
    0x0410,  // cyrillic capital a
    0x04D0,  // -> cyrillic capital a with breve
    0x0415,  // cyrillic capital ie
    0x04D6,  // -> cyrillic capital ie with breve
    0x0416,  // cyrillic capital zhe
    0x04C1,  // -> cyrillic capital zhe with breve
    0x0418,  // cyrillic capital i
    0x0419,  // -> cyrillic capital short i
    0x0423,  // cyrillic capital u
    0x040E,  // -> cyrillic capital short u
    0x0430,  // cyrillic small a
    0x04D1,  // -> cyrillic small a with breve
    0x0435,  // cyrillic small ie
    0x04D7,  // -> cyrillic small ie with breve
    0x0436,  // cyrillic small zhe
    0x04C2,  // -> cyrillic small zhe with breve
    0x0438,  // cyrillic small i
    0x0439,  // -> cyrillic small short i
    0x0443,  // cyrillic small u
    0x045E,  // -> cyrillic small short u
    0x1EA0,  // capital a with dot below
    0x1EB6,  // -> capital a with breve and dot below
    0x1EA1,  // letter a with dot below
    0x1EB7,  // -> letter a with breve and dot below
    //   internal dead_key table
    0x0002,          // number of entries
    0x0323,  // combining dot below
    0x12B2,
    0x0327,  // combining cedilla
    0x12BA,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x129A:
    //   prefix:
    //     Compose
    //     <latin capital letter u>
    //     <exclamation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB6,  // -> capital a with breve and dot below
    0x0061,  // letter a
    0x1EB7,  // -> letter a with breve and dot below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x12A2:
    //   prefix:
    //     Compose
    //     <latin capital letter u>
    //     <comma>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0045,  // capital e
    0x1E1C,  // -> capital e with cedilla and breve
    0x0065,  // letter e
    0x1E1D,  // -> letter e with cedilla and breve
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x12AA:
    //   prefix:
    //     Compose
    //     <latin capital letter u>
    //     <cedilla>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0045,  // capital e
    0x1E1C,  // -> capital e with cedilla and breve
    0x0065,  // letter e
    0x1E1D,  // -> letter e with cedilla and breve
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x12B2:
    //   prefix:
    //     Compose
    //     <latin capital letter u>
    //     Dead<combining dot below>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB6,  // -> capital a with breve and dot below
    0x0061,  // letter a
    0x1EB7,  // -> letter a with breve and dot below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x12BA:
    //   prefix:
    //     Compose
    //     <latin capital letter u>
    //     Dead<combining cedilla>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0045,  // capital e
    0x1E1C,  // -> capital e with cedilla and breve
    0x0065,  // letter e
    0x1E1D,  // -> letter e with cedilla and breve
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x12C2:
    //   prefix:
    //     Compose
    //     <latin capital letter v>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x004C,  // capital l
    0x007C,  // -> vertical line
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x12C8:
    //   prefix:
    //     Compose
    //     <latin capital letter w>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x003D,  // equals sign
    0x20A9,  // -> won sign
    0x005E,  // circumflex accent
    0x0174,  // -> capital w with circumflex
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x12D0:
    //   prefix:
    //     Compose
    //     <latin capital letter x>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x0030,  // digit zero
    0x00A4,  // -> currency sign
    0x004F,  // capital o
    0x00A4,  // -> currency sign
    0x006F,  // letter o
    0x00A4,  // -> currency sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x12DA:
    //   prefix:
    //     Compose
    //     <latin capital letter y>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0007,          // number of entries
    0x0022,  // quotation mark
    0x0178,  // -> capital y with diaeresis
    0x0027,  // apostrophe
    0x00DD,  // -> capital y with acute
    0x002D,  // hyphen-minus
    0x00A5,  // -> yen sign
    0x003D,  // equals sign
    0x00A5,  // -> yen sign
    0x005E,  // circumflex accent
    0x0176,  // -> capital y with circumflex
    0x00A8,  // diaeresis
    0x0178,  // -> capital y with diaeresis
    0x00B4,  // acute accent
    0x00DD,  // -> capital y with acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x12EC:
    //   prefix:
    //     Compose
    //     <latin capital letter z>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x0027,  // apostrophe
    0x0179,  // -> capital z with acute
    0x002E,  // full stop
    0x017B,  // -> capital z with dot above
    0x003C,  // less-than sign
    0x017D,  // -> capital z with caron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x12F6:
    //   prefix:
    //     Compose
    //     <circumflex accent>
    //   internal character table
    0x0002,          // number of entries
    0x0021,  // exclamation mark
    0x1384,
    0x005F,  // low line
    0x1394,
    //   leaf character table
    0x0042,          // number of entries
    0x0020,  // space
    0x00B2,  // -> superscript two
    0x0028,  // left parenthesis
    0x207D,  // -> superscript left parenthesis
    0x0029,  // right parenthesis
    0x207E,  // -> superscript right parenthesis
    0x002B,  // plus sign
    0x207A,  // -> superscript plus sign
    0x002D,  // hyphen-minus
    0x00AF,  // -> macron
    0x002E,  // full stop
    0x00B7,  // -> middle dot
    0x002F,  // solidus
    0x007C,  // -> vertical line
    0x0030,  // digit zero
    0x2070,  // -> superscript zero
    0x0031,  // digit one
    0x00B9,  // -> superscript one
    0x0032,  // digit two
    0x00B2,  // -> superscript two
    0x0033,  // digit three
    0x00B3,  // -> superscript three
    0x0034,  // digit four
    0x2074,  // -> superscript four
    0x0035,  // digit five
    0x2075,  // -> superscript five
    0x0036,  // digit six
    0x2076,  // -> superscript six
    0x0037,  // digit seven
    0x2077,  // -> superscript seven
    0x0038,  // digit eight
    0x2078,  // -> superscript eight
    0x0039,  // digit nine
    0x2079,  // -> superscript nine
    0x003D,  // equals sign
    0x207C,  // -> superscript equals sign
    0x0041,  // capital a
    0x00C2,  // -> capital a with circumflex
    0x0043,  // capital c
    0x0108,  // -> capital c with circumflex
    0x0045,  // capital e
    0x00CA,  // -> capital e with circumflex
    0x0047,  // capital g
    0x011C,  // -> capital g with circumflex
    0x0048,  // capital h
    0x0124,  // -> capital h with circumflex
    0x0049,  // capital i
    0x00CE,  // -> capital i with circumflex
    0x004A,  // capital j
    0x0134,  // -> capital j with circumflex
    0x004F,  // capital o
    0x00D4,  // -> capital o with circumflex
    0x0053,  // capital s
    0x015C,  // -> capital s with circumflex
    0x0055,  // capital u
    0x00DB,  // -> capital u with circumflex
    0x0057,  // capital w
    0x0174,  // -> capital w with circumflex
    0x0059,  // capital y
    0x0176,  // -> capital y with circumflex
    0x005A,  // capital z
    0x1E90,  // -> capital z with circumflex
    0x005F,  // low line
    0x00AF,  // -> macron
    0x0061,  // letter a
    0x00E2,  // -> letter a with circumflex
    0x0063,  // letter c
    0x0109,  // -> letter c with circumflex
    0x0065,  // letter e
    0x00EA,  // -> letter e with circumflex
    0x0067,  // letter g
    0x011D,  // -> letter g with circumflex
    0x0068,  // letter h
    0x0125,  // -> letter h with circumflex
    0x0069,  // letter i
    0x00EE,  // -> letter i with circumflex
    0x006A,  // letter j
    0x0135,  // -> letter j with circumflex
    0x006F,  // letter o
    0x00F4,  // -> letter o with circumflex
    0x0073,  // letter s
    0x015D,  // -> letter s with circumflex
    0x0075,  // letter u
    0x00FB,  // -> letter u with circumflex
    0x0077,  // letter w
    0x0175,  // -> letter w with circumflex
    0x0079,  // letter y
    0x0177,  // -> letter y with circumflex
    0x007A,  // letter z
    0x1E91,  // -> letter z with circumflex
    0x1EA0,  // capital a with dot below
    0x1EAC,  // -> capital a with circumflex and dot below
    0x1EA1,  // letter a with dot below
    0x1EAD,  // -> letter a with circumflex and dot below
    0x1EB8,  // capital e with dot below
    0x1EC6,  // -> capital e with circumflex and dot below
    0x1EB9,  // letter e with dot below
    0x1EC7,  // -> letter e with circumflex and dot below
    0x1ECC,  // capital o with dot below
    0x1ED8,  // -> capital o with circumflex and dot below
    0x1ECD,  // letter o with dot below
    0x1ED9,  // -> letter o with circumflex and dot below
    0x2212,  // minus sign
    0x207B,  // -> superscript minus
    0x4E00,  // cjk unified ideograph-4e00
    0x3192,  // -> ideographic annotation one mark
    0x4E01,  // cjk unified ideograph-4e01
    0x319C,  // -> ideographic annotation fourth mark
    0x4E09,  // cjk unified ideograph-4e09
    0x3194,  // -> ideographic annotation three mark
    0x4E0A,  // cjk unified ideograph-4e0a
    0x3196,  // -> ideographic annotation top mark
    0x4E0B,  // cjk unified ideograph-4e0b
    0x3198,  // -> ideographic annotation bottom mark
    0x4E19,  // cjk unified ideograph-4e19
    0x319B,  // -> ideographic annotation third mark
    0x4E2D,  // cjk unified ideograph-4e2d
    0x3197,  // -> ideographic annotation middle mark
    0x4E59,  // cjk unified ideograph-4e59
    0x319A,  // -> ideographic annotation second mark
    0x4E8C,  // cjk unified ideograph-4e8c
    0x3193,  // -> ideographic annotation two mark
    0x4EBA,  // cjk unified ideograph-4eba
    0x319F,  // -> ideographic annotation man mark
    0x56DB,  // cjk unified ideograph-56db
    0x3195,  // -> ideographic annotation four mark
    0x5730,  // cjk unified ideograph-5730
    0x319E,  // -> ideographic annotation earth mark
    0x5929,  // cjk unified ideograph-5929
    0x319D,  // -> ideographic annotation heaven mark
    0x7532,  // cjk unified ideograph-7532
    0x3199,  // -> ideographic annotation first mark
    //   internal dead_key table
    0x0001,          // number of entries
    0x0323,  // combining dot below
    0x13BC,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1384:
    //   prefix:
    //     Compose
    //     <circumflex accent>
    //     <exclamation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EAC,  // -> capital a with circumflex and dot below
    0x0045,  // capital e
    0x1EC6,  // -> capital e with circumflex and dot below
    0x004F,  // capital o
    0x1ED8,  // -> capital o with circumflex and dot below
    0x0061,  // letter a
    0x1EAD,  // -> letter a with circumflex and dot below
    0x0065,  // letter e
    0x1EC7,  // -> letter e with circumflex and dot below
    0x006F,  // letter o
    0x1ED9,  // -> letter o with circumflex and dot below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1394:
    //   prefix:
    //     Compose
    //     <circumflex accent>
    //     <low line>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0012,          // number of entries
    0x0061,  // letter a
    0x00AA,  // -> feminine ordinal indicator
    0x0068,  // letter h
    0x02B0,  // -> modifier small h
    0x0069,  // letter i
    0x2071,  // -> superscript latin small i
    0x006A,  // letter j
    0x02B2,  // -> modifier small j
    0x006C,  // letter l
    0x02E1,  // -> modifier small l
    0x006E,  // letter n
    0x207F,  // -> superscript latin small n
    0x006F,  // letter o
    0x00BA,  // -> masculine ordinal indicator
    0x0072,  // letter r
    0x02B3,  // -> modifier small r
    0x0073,  // letter s
    0x02E2,  // -> modifier small s
    0x0077,  // letter w
    0x02B7,  // -> modifier small w
    0x0078,  // letter x
    0x02E3,  // -> modifier small x
    0x0079,  // letter y
    0x02B8,  // -> modifier small y
    0x0263,  // letter gamma
    0x02E0,  // -> modifier small gamma
    0x0266,  // letter h with hook
    0x02B1,  // -> modifier small h with hook
    0x0279,  // letter turned r
    0x02B4,  // -> modifier small turned r
    0x027B,  // letter turned r with hook
    0x02B5,  // -> modifier small turned r with hook
    0x0281,  // letter small capital inverted r
    0x02B6,  // -> modifier small capital inverted r
    0x0295,  // letter pharyngeal voiced fricative
    0x02E4,  // -> modifier small reversed glottal stop
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x13BC:
    //   prefix:
    //     Compose
    //     <circumflex accent>
    //     Dead<combining dot below>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EAC,  // -> capital a with circumflex and dot below
    0x0045,  // capital e
    0x1EC6,  // -> capital e with circumflex and dot below
    0x004F,  // capital o
    0x1ED8,  // -> capital o with circumflex and dot below
    0x0061,  // letter a
    0x1EAD,  // -> letter a with circumflex and dot below
    0x0065,  // letter e
    0x1EC7,  // -> letter e with circumflex and dot below
    0x006F,  // letter o
    0x1ED9,  // -> letter o with circumflex and dot below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x13CC:
    //   prefix:
    //     Compose
    //     <low line>
    //   internal character table
    0x0005,          // number of entries
    0x0021,  // exclamation mark
    0x1464,
    0x0022,  // quotation mark
    0x1470,
    0x002E,  // full stop
    0x1480,
    0x003B,  // semicolon
    0x148C,
    0x007E,  // tilde
    0x1494,
    //   leaf character table
    0x0040,          // number of entries
    0x0020,  // space
    0x2082,  // -> subscript two
    0x0028,  // left parenthesis
    0x208D,  // -> subscript left parenthesis
    0x0029,  // right parenthesis
    0x208E,  // -> subscript right parenthesis
    0x002B,  // plus sign
    0x208A,  // -> subscript plus sign
    0x0030,  // digit zero
    0x2080,  // -> subscript zero
    0x0031,  // digit one
    0x2081,  // -> subscript one
    0x0032,  // digit two
    0x2082,  // -> subscript two
    0x0033,  // digit three
    0x2083,  // -> subscript three
    0x0034,  // digit four
    0x2084,  // -> subscript four
    0x0035,  // digit five
    0x2085,  // -> subscript five
    0x0036,  // digit six
    0x2086,  // -> subscript six
    0x0037,  // digit seven
    0x2087,  // -> subscript seven
    0x0038,  // digit eight
    0x2088,  // -> subscript eight
    0x0039,  // digit nine
    0x2089,  // -> subscript nine
    0x003D,  // equals sign
    0x208C,  // -> subscript equals sign
    0x0041,  // capital a
    0x0100,  // -> capital a with macron
    0x0045,  // capital e
    0x0112,  // -> capital e with macron
    0x0047,  // capital g
    0x1E20,  // -> capital g with macron
    0x0049,  // capital i
    0x012A,  // -> capital i with macron
    0x004F,  // capital o
    0x014C,  // -> capital o with macron
    0x0055,  // capital u
    0x016A,  // -> capital u with macron
    0x0059,  // capital y
    0x0232,  // -> capital y with macron
    0x005E,  // circumflex accent
    0x00AF,  // -> macron
    0x005F,  // low line
    0x00AF,  // -> macron
    0x0061,  // letter a
    0x0101,  // -> letter a with macron
    0x0065,  // letter e
    0x0113,  // -> letter e with macron
    0x0067,  // letter g
    0x1E21,  // -> letter g with macron
    0x0069,  // letter i
    0x012B,  // -> letter i with macron
    0x006F,  // letter o
    0x014D,  // -> letter o with macron
    0x0075,  // letter u
    0x016B,  // -> letter u with macron
    0x0079,  // letter y
    0x0233,  // -> letter y with macron
    0x00C4,  // capital a with diaeresis
    0x01DE,  // -> capital a with diaeresis and macron
    0x00C6,  // capital ae
    0x01E2,  // -> capital ae with macron
    0x00D5,  // capital o with tilde
    0x022C,  // -> capital o with tilde and macron
    0x00D6,  // capital o with diaeresis
    0x022A,  // -> capital o with diaeresis and macron
    0x00DC,  // capital u with diaeresis
    0x01D5,  // -> capital u with diaeresis and macron
    0x00E4,  // letter a with diaeresis
    0x01DF,  // -> letter a with diaeresis and macron
    0x00E6,  // letter ae
    0x01E3,  // -> letter ae with macron
    0x00F5,  // letter o with tilde
    0x022D,  // -> letter o with tilde and macron
    0x00F6,  // letter o with diaeresis
    0x022B,  // -> letter o with diaeresis and macron
    0x00FC,  // letter u with diaeresis
    0x01D6,  // -> letter u with diaeresis and macron
    0x0119,  // letter e with ogonek
    0x01EC,  // -> capital o with ogonek and macron
    0x01EB,  // letter o with ogonek
    0x01ED,  // -> letter o with ogonek and macron
    0x0226,  // capital a with dot above
    0x01E0,  // -> capital a with dot above and macron
    0x0227,  // letter a with dot above
    0x01E1,  // -> letter a with dot above and macron
    0x022E,  // capital o with dot above
    0x0230,  // -> capital o with dot above and macron
    0x022F,  // letter o with dot above
    0x0231,  // -> letter o with dot above and macron
    0x0391,  // capital alpha
    0x1FB9,  // -> capital alpha with macron
    0x0399,  // capital iota
    0x1FD9,  // -> capital iota with macron
    0x03A5,  // capital upsilon
    0x1FE9,  // -> capital upsilon with macron
    0x03B1,  // letter alpha
    0x1FB1,  // -> letter alpha with macron
    0x03B9,  // letter iota
    0x1FD1,  // -> letter iota with macron
    0x03C5,  // letter upsilon
    0x1FE1,  // -> letter upsilon with macron
    0x0418,  // cyrillic capital i
    0x04E2,  // -> cyrillic capital i with macron
    0x0423,  // cyrillic capital u
    0x04EE,  // -> cyrillic capital u with macron
    0x0438,  // cyrillic small i
    0x04E3,  // -> cyrillic small i with macron
    0x0443,  // cyrillic small u
    0x04EF,  // -> cyrillic small u with macron
    0x0BBE,  // tamil vowel sign aa
    0x0BCA,  // -> tamil vowel sign o
    0x0BD7,  // tamil au length mark
    0x0BCC,  // -> tamil vowel sign au
    0x1E36,  // capital l with dot below
    0x1E38,  // -> capital l with dot below and macron
    0x1E37,  // letter l with dot below
    0x1E39,  // -> letter l with dot below and macron
    0x1E5A,  // capital r with dot below
    0x1E5C,  // -> capital r with dot below and macron
    0x1E5B,  // letter r with dot below
    0x1E5D,  // -> letter r with dot below and macron
    0x2212,  // minus sign
    0x208B,  // -> subscript minus
    //   internal dead_key table
    0x0005,          // number of entries
    0x0303,  // combining tilde
    0x149C,
    0x0307,  // combining dot above
    0x14A4,
    0x0308,  // combining diaeresis
    0x14B0,
    0x0323,  // combining dot below
    0x14C0,
    0x0328,  // combining ogonek
    0x14CC,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1464:
    //   prefix:
    //     Compose
    //     <low line>
    //     <exclamation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004C,  // capital l
    0x1E38,  // -> capital l with dot below and macron
    0x0052,  // capital r
    0x1E5C,  // -> capital r with dot below and macron
    0x006C,  // letter l
    0x1E39,  // -> letter l with dot below and macron
    0x0072,  // letter r
    0x1E5D,  // -> letter r with dot below and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1470:
    //   prefix:
    //     Compose
    //     <low line>
    //     <quotation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x01DE,  // -> capital a with diaeresis and macron
    0x004F,  // capital o
    0x022A,  // -> capital o with diaeresis and macron
    0x0055,  // capital u
    0x01D5,  // -> capital u with diaeresis and macron
    0x0061,  // letter a
    0x01DF,  // -> letter a with diaeresis and macron
    0x006F,  // letter o
    0x022B,  // -> letter o with diaeresis and macron
    0x0075,  // letter u
    0x01D6,  // -> letter u with diaeresis and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1480:
    //   prefix:
    //     Compose
    //     <low line>
    //     <full stop>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0041,  // capital a
    0x01E0,  // -> capital a with dot above and macron
    0x004F,  // capital o
    0x0230,  // -> capital o with dot above and macron
    0x0061,  // letter a
    0x01E1,  // -> letter a with dot above and macron
    0x006F,  // letter o
    0x0231,  // -> letter o with dot above and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x148C:
    //   prefix:
    //     Compose
    //     <low line>
    //     <semicolon>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x01EC,  // -> capital o with ogonek and macron
    0x006F,  // letter o
    0x01ED,  // -> letter o with ogonek and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1494:
    //   prefix:
    //     Compose
    //     <low line>
    //     <tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x022C,  // -> capital o with tilde and macron
    0x006F,  // letter o
    0x022D,  // -> letter o with tilde and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x149C:
    //   prefix:
    //     Compose
    //     <low line>
    //     Dead<combining tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x022C,  // -> capital o with tilde and macron
    0x006F,  // letter o
    0x022D,  // -> letter o with tilde and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x14A4:
    //   prefix:
    //     Compose
    //     <low line>
    //     Dead<combining dot above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0041,  // capital a
    0x01E0,  // -> capital a with dot above and macron
    0x004F,  // capital o
    0x0230,  // -> capital o with dot above and macron
    0x0061,  // letter a
    0x01E1,  // -> letter a with dot above and macron
    0x006F,  // letter o
    0x0231,  // -> letter o with dot above and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x14B0:
    //   prefix:
    //     Compose
    //     <low line>
    //     Dead<combining diaeresis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x01DE,  // -> capital a with diaeresis and macron
    0x004F,  // capital o
    0x022A,  // -> capital o with diaeresis and macron
    0x0055,  // capital u
    0x01D5,  // -> capital u with diaeresis and macron
    0x0061,  // letter a
    0x01DF,  // -> letter a with diaeresis and macron
    0x006F,  // letter o
    0x022B,  // -> letter o with diaeresis and macron
    0x0075,  // letter u
    0x01D6,  // -> letter u with diaeresis and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x14C0:
    //   prefix:
    //     Compose
    //     <low line>
    //     Dead<combining dot below>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004C,  // capital l
    0x1E38,  // -> capital l with dot below and macron
    0x0052,  // capital r
    0x1E5C,  // -> capital r with dot below and macron
    0x006C,  // letter l
    0x1E39,  // -> letter l with dot below and macron
    0x0072,  // letter r
    0x1E5D,  // -> letter r with dot below and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x14CC:
    //   prefix:
    //     Compose
    //     <low line>
    //     Dead<combining ogonek>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x01EC,  // -> capital o with ogonek and macron
    0x006F,  // letter o
    0x01ED,  // -> letter o with ogonek and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x14D4:
    //   prefix:
    //     Compose
    //     <grave accent>
    //   internal character table
    0x0008,          // number of entries
    0x0022,  // quotation mark
    0x1592,
    0x0028,  // left parenthesis
    0x159E,
    0x0029,  // right parenthesis
    0x15BE,
    0x002B,  // plus sign
    0x15DC,
    0x005E,  // circumflex accent
    0x15E8,
    0x005F,  // low line
    0x15F8,
    0x0062,  // letter b
    0x1604,
    0x00AF,  // macron
    0x160C,
    //   leaf character table
    0x004E,          // number of entries
    0x0020,  // space
    0x0060,  // -> grave accent
    0x0041,  // capital a
    0x00C0,  // -> capital a with grave
    0x0045,  // capital e
    0x00C8,  // -> capital e with grave
    0x0049,  // capital i
    0x00CC,  // -> capital i with grave
    0x004E,  // capital n
    0x01F8,  // -> capital n with grave
    0x004F,  // capital o
    0x00D2,  // -> capital o with grave
    0x0055,  // capital u
    0x00D9,  // -> capital u with grave
    0x0057,  // capital w
    0x1E80,  // -> capital w with grave
    0x0059,  // capital y
    0x1EF2,  // -> capital y with grave
    0x0061,  // letter a
    0x00E0,  // -> letter a with grave
    0x0065,  // letter e
    0x00E8,  // -> letter e with grave
    0x0069,  // letter i
    0x00EC,  // -> letter i with grave
    0x006E,  // letter n
    0x01F9,  // -> letter n with grave
    0x006F,  // letter o
    0x00F2,  // -> letter o with grave
    0x0075,  // letter u
    0x00F9,  // -> letter u with grave
    0x0077,  // letter w
    0x1E81,  // -> letter w with grave
    0x0079,  // letter y
    0x1EF3,  // -> letter y with grave
    0x00C2,  // capital a with circumflex
    0x1EA6,  // -> capital a with circumflex and grave
    0x00CA,  // capital e with circumflex
    0x1EC0,  // -> capital e with circumflex and grave
    0x00D4,  // capital o with circumflex
    0x1ED2,  // -> capital o with circumflex and grave
    0x00DC,  // capital u with diaeresis
    0x01DB,  // -> capital u with diaeresis and grave
    0x00E2,  // letter a with circumflex
    0x1EA7,  // -> letter a with circumflex and grave
    0x00EA,  // letter e with circumflex
    0x1EC1,  // -> letter e with circumflex and grave
    0x00F4,  // letter o with circumflex
    0x1ED3,  // -> letter o with circumflex and grave
    0x00FC,  // letter u with diaeresis
    0x01DC,  // -> letter u with diaeresis and grave
    0x0102,  // capital a with breve
    0x1EB0,  // -> capital a with breve and grave
    0x0103,  // letter a with breve
    0x1EB1,  // -> letter a with breve and grave
    0x0112,  // capital e with macron
    0x1E14,  // -> capital e with macron and grave
    0x0113,  // letter e with macron
    0x1E15,  // -> letter e with macron and grave
    0x014C,  // capital o with macron
    0x1E50,  // -> capital o with macron and grave
    0x014D,  // letter o with macron
    0x1E51,  // -> letter o with macron and grave
    0x0391,  // capital alpha
    0x1FBA,  // -> capital alpha with varia
    0x0395,  // capital epsilon
    0x1FC8,  // -> capital epsilon with varia
    0x0397,  // capital eta
    0x1FCA,  // -> capital eta with varia
    0x0399,  // capital iota
    0x1FDA,  // -> capital iota with varia
    0x039F,  // capital omicron
    0x1FF8,  // -> capital omicron with varia
    0x03A5,  // capital upsilon
    0x1FEA,  // -> capital upsilon with varia
    0x03A9,  // capital omega
    0x1FFA,  // -> capital omega with varia
    0x03B1,  // letter alpha
    0x1F70,  // -> letter alpha with varia
    0x03B5,  // letter epsilon
    0x1F72,  // -> letter epsilon with varia
    0x03B7,  // letter eta
    0x1F74,  // -> letter eta with varia
    0x03B9,  // letter iota
    0x1F76,  // -> letter iota with varia
    0x03BF,  // letter omicron
    0x1F78,  // -> letter omicron with varia
    0x03C5,  // letter upsilon
    0x1F7A,  // -> letter upsilon with varia
    0x03C9,  // letter omega
    0x1F7C,  // -> letter omega with varia
    0x03CA,  // letter iota with dialytika
    0x1FD2,  // -> letter iota with dialytika and varia
    0x03CB,  // letter upsilon with dialytika
    0x1FE2,  // -> letter upsilon with dialytika and varia
    0x0415,  // cyrillic capital ie
    0x0400,  // -> cyrillic capital ie with grave
    0x0418,  // cyrillic capital i
    0x040D,  // -> cyrillic capital i with grave
    0x0435,  // cyrillic small ie
    0x0450,  // -> cyrillic small ie with grave
    0x0438,  // cyrillic small i
    0x045D,  // -> cyrillic small i with grave
    0x1F00,  // letter alpha with psili
    0x1F02,  // -> letter alpha with psili and varia
    0x1F01,  // letter alpha with dasia
    0x1F03,  // -> letter alpha with dasia and varia
    0x1F08,  // capital alpha with psili
    0x1F0A,  // -> capital alpha with psili and varia
    0x1F09,  // capital alpha with dasia
    0x1F0B,  // -> capital alpha with dasia and varia
    0x1F10,  // letter epsilon with psili
    0x1F12,  // -> letter epsilon with psili and varia
    0x1F11,  // letter epsilon with dasia
    0x1F13,  // -> letter epsilon with dasia and varia
    0x1F18,  // capital epsilon with psili
    0x1F1A,  // -> capital epsilon with psili and varia
    0x1F19,  // capital epsilon with dasia
    0x1F1B,  // -> capital epsilon with dasia and varia
    0x1F20,  // letter eta with psili
    0x1F22,  // -> letter eta with psili and varia
    0x1F21,  // letter eta with dasia
    0x1F23,  // -> letter eta with dasia and varia
    0x1F28,  // capital eta with psili
    0x1F2A,  // -> capital eta with psili and varia
    0x1F29,  // capital eta with dasia
    0x1F2B,  // -> capital eta with dasia and varia
    0x1F30,  // letter iota with psili
    0x1F32,  // -> letter iota with psili and varia
    0x1F31,  // letter iota with dasia
    0x1F33,  // -> letter iota with dasia and varia
    0x1F38,  // capital iota with psili
    0x1F3A,  // -> capital iota with psili and varia
    0x1F39,  // capital iota with dasia
    0x1F3B,  // -> capital iota with dasia and varia
    0x1F40,  // letter omicron with psili
    0x1F42,  // -> letter omicron with psili and varia
    0x1F41,  // letter omicron with dasia
    0x1F43,  // -> letter omicron with dasia and varia
    0x1F48,  // capital omicron with psili
    0x1F4A,  // -> capital omicron with psili and varia
    0x1F49,  // capital omicron with dasia
    0x1F4B,  // -> capital omicron with dasia and varia
    0x1F50,  // letter upsilon with psili
    0x1F52,  // -> letter upsilon with psili and varia
    0x1F51,  // letter upsilon with dasia
    0x1F53,  // -> letter upsilon with dasia and varia
    0x1F59,  // capital upsilon with dasia
    0x1F5B,  // -> capital upsilon with dasia and varia
    0x1F60,  // letter omega with psili
    0x1F62,  // -> letter omega with psili and varia
    0x1F61,  // letter omega with dasia
    0x1F63,  // -> letter omega with dasia and varia
    0x1F68,  // capital omega with psili
    0x1F6A,  // -> capital omega with psili and varia
    0x1F69,  // capital omega with dasia
    0x1F6B,  // -> capital omega with dasia and varia
    //   internal dead_key table
    0x0007,          // number of entries
    0x0302,  // combining circumflex accent
    0x1618,
    0x0304,  // combining macron
    0x1628,
    0x0306,  // combining breve
    0x1634,
    0x0308,  // combining diaeresis
    0x163C,
    0x0313,  // combining comma above
    0x1648,
    0x0314,  // combining reversed comma above
    0x1666,
    0x031B,  // combining horn
    0x1686,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1592:
    //   prefix:
    //     Compose
    //     <grave accent>
    //     <quotation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0055,  // capital u
    0x01DB,  // -> capital u with diaeresis and grave
    0x0075,  // letter u
    0x01DC,  // -> letter u with diaeresis and grave
    0x03B9,  // letter iota
    0x1FD2,  // -> letter iota with dialytika and varia
    0x03C5,  // letter upsilon
    0x1FE2,  // -> letter upsilon with dialytika and varia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x159E:
    //   prefix:
    //     Compose
    //     <grave accent>
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000E,          // number of entries
    0x0391,  // capital alpha
    0x1F0B,  // -> capital alpha with dasia and varia
    0x0395,  // capital epsilon
    0x1F1B,  // -> capital epsilon with dasia and varia
    0x0397,  // capital eta
    0x1F2B,  // -> capital eta with dasia and varia
    0x0399,  // capital iota
    0x1F3B,  // -> capital iota with dasia and varia
    0x039F,  // capital omicron
    0x1F4B,  // -> capital omicron with dasia and varia
    0x03A5,  // capital upsilon
    0x1F5B,  // -> capital upsilon with dasia and varia
    0x03A9,  // capital omega
    0x1F6B,  // -> capital omega with dasia and varia
    0x03B1,  // letter alpha
    0x1F03,  // -> letter alpha with dasia and varia
    0x03B5,  // letter epsilon
    0x1F13,  // -> letter epsilon with dasia and varia
    0x03B7,  // letter eta
    0x1F23,  // -> letter eta with dasia and varia
    0x03B9,  // letter iota
    0x1F33,  // -> letter iota with dasia and varia
    0x03BF,  // letter omicron
    0x1F43,  // -> letter omicron with dasia and varia
    0x03C5,  // letter upsilon
    0x1F53,  // -> letter upsilon with dasia and varia
    0x03C9,  // letter omega
    0x1F63,  // -> letter omega with dasia and varia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x15BE:
    //   prefix:
    //     Compose
    //     <grave accent>
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000D,          // number of entries
    0x0391,  // capital alpha
    0x1F0A,  // -> capital alpha with psili and varia
    0x0395,  // capital epsilon
    0x1F1A,  // -> capital epsilon with psili and varia
    0x0397,  // capital eta
    0x1F2A,  // -> capital eta with psili and varia
    0x0399,  // capital iota
    0x1F3A,  // -> capital iota with psili and varia
    0x039F,  // capital omicron
    0x1F4A,  // -> capital omicron with psili and varia
    0x03A9,  // capital omega
    0x1F6A,  // -> capital omega with psili and varia
    0x03B1,  // letter alpha
    0x1F02,  // -> letter alpha with psili and varia
    0x03B5,  // letter epsilon
    0x1F12,  // -> letter epsilon with psili and varia
    0x03B7,  // letter eta
    0x1F22,  // -> letter eta with psili and varia
    0x03B9,  // letter iota
    0x1F32,  // -> letter iota with psili and varia
    0x03BF,  // letter omicron
    0x1F42,  // -> letter omicron with psili and varia
    0x03C5,  // letter upsilon
    0x1F52,  // -> letter upsilon with psili and varia
    0x03C9,  // letter omega
    0x1F62,  // -> letter omega with psili and varia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x15DC:
    //   prefix:
    //     Compose
    //     <grave accent>
    //     <plus sign>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EDC,  // -> capital o with horn and grave
    0x0055,  // capital u
    0x1EEA,  // -> capital u with horn and grave
    0x006F,  // letter o
    0x1EDD,  // -> letter o with horn and grave
    0x0075,  // letter u
    0x1EEB,  // -> letter u with horn and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x15E8:
    //   prefix:
    //     Compose
    //     <grave accent>
    //     <circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EA6,  // -> capital a with circumflex and grave
    0x0045,  // capital e
    0x1EC0,  // -> capital e with circumflex and grave
    0x004F,  // capital o
    0x1ED2,  // -> capital o with circumflex and grave
    0x0061,  // letter a
    0x1EA7,  // -> letter a with circumflex and grave
    0x0065,  // letter e
    0x1EC1,  // -> letter e with circumflex and grave
    0x006F,  // letter o
    0x1ED3,  // -> letter o with circumflex and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x15F8:
    //   prefix:
    //     Compose
    //     <grave accent>
    //     <low line>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0045,  // capital e
    0x1E14,  // -> capital e with macron and grave
    0x004F,  // capital o
    0x1E50,  // -> capital o with macron and grave
    0x0065,  // letter e
    0x1E15,  // -> letter e with macron and grave
    0x006F,  // letter o
    0x1E51,  // -> letter o with macron and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1604:
    //   prefix:
    //     Compose
    //     <grave accent>
    //     <latin small letter b>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB0,  // -> capital a with breve and grave
    0x0061,  // letter a
    0x1EB1,  // -> letter a with breve and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x160C:
    //   prefix:
    //     Compose
    //     <grave accent>
    //     <macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0045,  // capital e
    0x1E14,  // -> capital e with macron and grave
    0x004F,  // capital o
    0x1E50,  // -> capital o with macron and grave
    0x0065,  // letter e
    0x1E15,  // -> letter e with macron and grave
    0x006F,  // letter o
    0x1E51,  // -> letter o with macron and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1618:
    //   prefix:
    //     Compose
    //     <grave accent>
    //     Dead<combining circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EA6,  // -> capital a with circumflex and grave
    0x0045,  // capital e
    0x1EC0,  // -> capital e with circumflex and grave
    0x004F,  // capital o
    0x1ED2,  // -> capital o with circumflex and grave
    0x0061,  // letter a
    0x1EA7,  // -> letter a with circumflex and grave
    0x0065,  // letter e
    0x1EC1,  // -> letter e with circumflex and grave
    0x006F,  // letter o
    0x1ED3,  // -> letter o with circumflex and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1628:
    //   prefix:
    //     Compose
    //     <grave accent>
    //     Dead<combining macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0045,  // capital e
    0x1E14,  // -> capital e with macron and grave
    0x004F,  // capital o
    0x1E50,  // -> capital o with macron and grave
    0x0065,  // letter e
    0x1E15,  // -> letter e with macron and grave
    0x006F,  // letter o
    0x1E51,  // -> letter o with macron and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1634:
    //   prefix:
    //     Compose
    //     <grave accent>
    //     Dead<combining breve>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB0,  // -> capital a with breve and grave
    0x0061,  // letter a
    0x1EB1,  // -> letter a with breve and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x163C:
    //   prefix:
    //     Compose
    //     <grave accent>
    //     Dead<combining diaeresis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0055,  // capital u
    0x01DB,  // -> capital u with diaeresis and grave
    0x0075,  // letter u
    0x01DC,  // -> letter u with diaeresis and grave
    0x03B9,  // letter iota
    0x1FD2,  // -> letter iota with dialytika and varia
    0x03C5,  // letter upsilon
    0x1FE2,  // -> letter upsilon with dialytika and varia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1648:
    //   prefix:
    //     Compose
    //     <grave accent>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000D,          // number of entries
    0x0391,  // capital alpha
    0x1F0A,  // -> capital alpha with psili and varia
    0x0395,  // capital epsilon
    0x1F1A,  // -> capital epsilon with psili and varia
    0x0397,  // capital eta
    0x1F2A,  // -> capital eta with psili and varia
    0x0399,  // capital iota
    0x1F3A,  // -> capital iota with psili and varia
    0x039F,  // capital omicron
    0x1F4A,  // -> capital omicron with psili and varia
    0x03A9,  // capital omega
    0x1F6A,  // -> capital omega with psili and varia
    0x03B1,  // letter alpha
    0x1F02,  // -> letter alpha with psili and varia
    0x03B5,  // letter epsilon
    0x1F12,  // -> letter epsilon with psili and varia
    0x03B7,  // letter eta
    0x1F22,  // -> letter eta with psili and varia
    0x03B9,  // letter iota
    0x1F32,  // -> letter iota with psili and varia
    0x03BF,  // letter omicron
    0x1F42,  // -> letter omicron with psili and varia
    0x03C5,  // letter upsilon
    0x1F52,  // -> letter upsilon with psili and varia
    0x03C9,  // letter omega
    0x1F62,  // -> letter omega with psili and varia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1666:
    //   prefix:
    //     Compose
    //     <grave accent>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000E,          // number of entries
    0x0391,  // capital alpha
    0x1F0B,  // -> capital alpha with dasia and varia
    0x0395,  // capital epsilon
    0x1F1B,  // -> capital epsilon with dasia and varia
    0x0397,  // capital eta
    0x1F2B,  // -> capital eta with dasia and varia
    0x0399,  // capital iota
    0x1F3B,  // -> capital iota with dasia and varia
    0x039F,  // capital omicron
    0x1F4B,  // -> capital omicron with dasia and varia
    0x03A5,  // capital upsilon
    0x1F5B,  // -> capital upsilon with dasia and varia
    0x03A9,  // capital omega
    0x1F6B,  // -> capital omega with dasia and varia
    0x03B1,  // letter alpha
    0x1F03,  // -> letter alpha with dasia and varia
    0x03B5,  // letter epsilon
    0x1F13,  // -> letter epsilon with dasia and varia
    0x03B7,  // letter eta
    0x1F23,  // -> letter eta with dasia and varia
    0x03B9,  // letter iota
    0x1F33,  // -> letter iota with dasia and varia
    0x03BF,  // letter omicron
    0x1F43,  // -> letter omicron with dasia and varia
    0x03C5,  // letter upsilon
    0x1F53,  // -> letter upsilon with dasia and varia
    0x03C9,  // letter omega
    0x1F63,  // -> letter omega with dasia and varia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1686:
    //   prefix:
    //     Compose
    //     <grave accent>
    //     Dead<combining horn>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EDC,  // -> capital o with horn and grave
    0x0055,  // capital u
    0x1EEA,  // -> capital u with horn and grave
    0x006F,  // letter o
    0x1EDD,  // -> letter o with horn and grave
    0x0075,  // letter u
    0x1EEB,  // -> letter u with horn and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1692:
    //   prefix:
    //     Compose
    //     <latin small letter a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000F,          // number of entries
    0x0022,  // quotation mark
    0x00E4,  // -> letter a with diaeresis
    0x0027,  // apostrophe
    0x00E1,  // -> letter a with acute
    0x0028,  // left parenthesis
    0x0103,  // -> letter a with breve
    0x002A,  // asterisk
    0x00E5,  // -> letter a with ring above
    0x002C,  // comma
    0x0105,  // -> letter a with ogonek
    0x002D,  // hyphen-minus
    0x0101,  // -> letter a with macron
    0x003E,  // greater-than sign
    0x00E2,  // -> letter a with circumflex
    0x005E,  // circumflex accent
    0x00E2,  // -> letter a with circumflex
    0x005F,  // low line
    0x00AA,  // -> feminine ordinal indicator
    0x0060,  // grave accent
    0x00E0,  // -> letter a with grave
    0x0061,  // letter a
    0x00E5,  // -> letter a with ring above
    0x0065,  // letter e
    0x00E6,  // -> letter ae
    0x007E,  // tilde
    0x00E3,  // -> letter a with tilde
    0x00A8,  // diaeresis
    0x00E4,  // -> letter a with diaeresis
    0x00B4,  // acute accent
    0x00E1,  // -> letter a with acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x16B4:
    //   prefix:
    //     Compose
    //     <latin small letter b>
    //   internal character table
    0x0003,          // number of entries
    0x0021,  // exclamation mark
    0x1704,
    0x002C,  // comma
    0x170C,
    0x00B8,  // cedilla
    0x1714,
    //   leaf character table
    0x0021,          // number of entries
    0x002E,  // full stop
    0x1E03,  // -> letter b with dot above
    0x0041,  // capital a
    0x0102,  // -> capital a with breve
    0x0045,  // capital e
    0x0114,  // -> capital e with breve
    0x0047,  // capital g
    0x011E,  // -> capital g with breve
    0x0049,  // capital i
    0x012C,  // -> capital i with breve
    0x004F,  // capital o
    0x014E,  // -> capital o with breve
    0x0055,  // capital u
    0x016C,  // -> capital u with breve
    0x0061,  // letter a
    0x0103,  // -> letter a with breve
    0x0065,  // letter e
    0x0115,  // -> letter e with breve
    0x0067,  // letter g
    0x011F,  // -> letter g with breve
    0x0069,  // letter i
    0x012D,  // -> letter i with breve
    0x006F,  // letter o
    0x014F,  // -> letter o with breve
    0x0075,  // letter u
    0x016D,  // -> letter u with breve
    0x0228,  // capital e with cedilla
    0x1E1C,  // -> capital e with cedilla and breve
    0x0229,  // letter e with cedilla
    0x1E1D,  // -> letter e with cedilla and breve
    0x0391,  // capital alpha
    0x1FB8,  // -> capital alpha with vrachy
    0x0399,  // capital iota
    0x1FD8,  // -> capital iota with vrachy
    0x03A5,  // capital upsilon
    0x1FE8,  // -> capital upsilon with vrachy
    0x03B1,  // letter alpha
    0x1FB0,  // -> letter alpha with vrachy
    0x03B9,  // letter iota
    0x1FD0,  // -> letter iota with vrachy
    0x03C5,  // letter upsilon
    0x1FE0,  // -> letter upsilon with vrachy
    0x0410,  // cyrillic capital a
    0x04D0,  // -> cyrillic capital a with breve
    0x0415,  // cyrillic capital ie
    0x04D6,  // -> cyrillic capital ie with breve
    0x0416,  // cyrillic capital zhe
    0x04C1,  // -> cyrillic capital zhe with breve
    0x0418,  // cyrillic capital i
    0x0419,  // -> cyrillic capital short i
    0x0423,  // cyrillic capital u
    0x040E,  // -> cyrillic capital short u
    0x0430,  // cyrillic small a
    0x04D1,  // -> cyrillic small a with breve
    0x0435,  // cyrillic small ie
    0x04D7,  // -> cyrillic small ie with breve
    0x0436,  // cyrillic small zhe
    0x04C2,  // -> cyrillic small zhe with breve
    0x0438,  // cyrillic small i
    0x0439,  // -> cyrillic small short i
    0x0443,  // cyrillic small u
    0x045E,  // -> cyrillic small short u
    0x1EA0,  // capital a with dot below
    0x1EB6,  // -> capital a with breve and dot below
    0x1EA1,  // letter a with dot below
    0x1EB7,  // -> letter a with breve and dot below
    //   internal dead_key table
    0x0002,          // number of entries
    0x0323,  // combining dot below
    0x171C,
    0x0327,  // combining cedilla
    0x1724,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1704:
    //   prefix:
    //     Compose
    //     <latin small letter b>
    //     <exclamation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB6,  // -> capital a with breve and dot below
    0x0061,  // letter a
    0x1EB7,  // -> letter a with breve and dot below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x170C:
    //   prefix:
    //     Compose
    //     <latin small letter b>
    //     <comma>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0045,  // capital e
    0x1E1C,  // -> capital e with cedilla and breve
    0x0065,  // letter e
    0x1E1D,  // -> letter e with cedilla and breve
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1714:
    //   prefix:
    //     Compose
    //     <latin small letter b>
    //     <cedilla>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0045,  // capital e
    0x1E1C,  // -> capital e with cedilla and breve
    0x0065,  // letter e
    0x1E1D,  // -> letter e with cedilla and breve
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x171C:
    //   prefix:
    //     Compose
    //     <latin small letter b>
    //     Dead<combining dot below>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB6,  // -> capital a with breve and dot below
    0x0061,  // letter a
    0x1EB7,  // -> letter a with breve and dot below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1724:
    //   prefix:
    //     Compose
    //     <latin small letter b>
    //     Dead<combining cedilla>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0045,  // capital e
    0x1E1C,  // -> capital e with cedilla and breve
    0x0065,  // letter e
    0x1E1D,  // -> letter e with cedilla and breve
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x172C:
    //   prefix:
    //     Compose
    //     <latin small letter c>
    //   internal character table
    0x0001,          // number of entries
    0x0022,  // quotation mark
    0x178E,
    //   leaf character table
    0x002D,          // number of entries
    0x0027,  // apostrophe
    0x0107,  // -> letter c with acute
    0x002C,  // comma
    0x00E7,  // -> letter c with cedilla
    0x002E,  // full stop
    0x010B,  // -> letter c with dot above
    0x002F,  // solidus
    0x00A2,  // -> cent sign
    0x0030,  // digit zero
    0x00A9,  // -> copyright sign
    0x003C,  // less-than sign
    0x010D,  // -> letter c with caron
    0x003D,  // equals sign
    0x20AC,  // -> euro sign
    0x0041,  // capital a
    0x01CD,  // -> capital a with caron
    0x0043,  // capital c
    0x010C,  // -> capital c with caron
    0x0044,  // capital d
    0x010E,  // -> capital d with caron
    0x0045,  // capital e
    0x011A,  // -> capital e with caron
    0x0047,  // capital g
    0x01E6,  // -> capital g with caron
    0x0048,  // capital h
    0x021E,  // -> capital h with caron
    0x0049,  // capital i
    0x01CF,  // -> capital i with caron
    0x004B,  // capital k
    0x01E8,  // -> capital k with caron
    0x004C,  // capital l
    0x013D,  // -> capital l with caron
    0x004E,  // capital n
    0x0147,  // -> capital n with caron
    0x004F,  // capital o
    0x01D1,  // -> capital o with caron
    0x0052,  // capital r
    0x0158,  // -> capital r with caron
    0x0053,  // capital s
    0x0160,  // -> capital s with caron
    0x0054,  // capital t
    0x0164,  // -> capital t with caron
    0x0055,  // capital u
    0x01D3,  // -> capital u with caron
    0x005A,  // capital z
    0x017D,  // -> capital z with caron
    0x0061,  // letter a
    0x01CE,  // -> letter a with caron
    0x0063,  // letter c
    0x010D,  // -> letter c with caron
    0x0064,  // letter d
    0x010F,  // -> letter d with caron
    0x0065,  // letter e
    0x011B,  // -> letter e with caron
    0x0067,  // letter g
    0x01E7,  // -> letter g with caron
    0x0068,  // letter h
    0x021F,  // -> letter h with caron
    0x0069,  // letter i
    0x01D0,  // -> letter i with caron
    0x006A,  // letter j
    0x01F0,  // -> letter j with caron
    0x006B,  // letter k
    0x01E9,  // -> letter k with caron
    0x006C,  // letter l
    0x013E,  // -> letter l with caron
    0x006E,  // letter n
    0x0148,  // -> letter n with caron
    0x006F,  // letter o
    0x01D2,  // -> letter o with caron
    0x0072,  // letter r
    0x0159,  // -> letter r with caron
    0x0073,  // letter s
    0x0161,  // -> letter s with caron
    0x0074,  // letter t
    0x0165,  // -> letter t with caron
    0x0075,  // letter u
    0x01D4,  // -> letter u with caron
    0x007A,  // letter z
    0x017E,  // -> letter z with caron
    0x007C,  // vertical line
    0x00A2,  // -> cent sign
    0x00DC,  // capital u with diaeresis
    0x01D9,  // -> capital u with diaeresis and caron
    0x00FC,  // letter u with diaeresis
    0x01DA,  // -> letter u with diaeresis and caron
    0x0292,  // letter ezh
    0x01EF,  // -> letter ezh with caron
    0x02C7,  // caron
    0x01EE,  // -> capital ezh with caron
    //   internal dead_key table
    0x0001,          // number of entries
    0x0308,  // combining diaeresis
    0x1796,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x178E:
    //   prefix:
    //     Compose
    //     <latin small letter c>
    //     <quotation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0055,  // capital u
    0x01D9,  // -> capital u with diaeresis and caron
    0x0075,  // letter u
    0x01DA,  // -> letter u with diaeresis and caron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1796:
    //   prefix:
    //     Compose
    //     <latin small letter c>
    //     Dead<combining diaeresis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0055,  // capital u
    0x01D9,  // -> capital u with diaeresis and caron
    0x0075,  // letter u
    0x01DA,  // -> letter u with diaeresis and caron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x179E:
    //   prefix:
    //     Compose
    //     <latin small letter d>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x002D,  // hyphen-minus
    0x20AB,  // -> dong sign
    0x002E,  // full stop
    0x1E0B,  // -> letter d with dot above
    0x003C,  // less-than sign
    0x010F,  // -> letter d with caron
    0x0068,  // letter h
    0x00F0,  // -> letter eth
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x17AA:
    //   prefix:
    //     Compose
    //     <latin small letter e>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000E,          // number of entries
    0x0022,  // quotation mark
    0x00EB,  // -> letter e with diaeresis
    0x0027,  // apostrophe
    0x00E9,  // -> letter e with acute
    0x002C,  // comma
    0x0119,  // -> letter e with ogonek
    0x002D,  // hyphen-minus
    0x0113,  // -> letter e with macron
    0x002E,  // full stop
    0x0117,  // -> letter e with dot above
    0x003C,  // less-than sign
    0x011B,  // -> letter e with caron
    0x003D,  // equals sign
    0x20AC,  // -> euro sign
    0x003E,  // greater-than sign
    0x00EA,  // -> letter e with circumflex
    0x005E,  // circumflex accent
    0x00EA,  // -> letter e with circumflex
    0x005F,  // low line
    0x0113,  // -> letter e with macron
    0x0060,  // grave accent
    0x00E8,  // -> letter e with grave
    0x0065,  // letter e
    0x0259,  // -> letter schwa
    0x00A8,  // diaeresis
    0x00EB,  // -> letter e with diaeresis
    0x00B4,  // acute accent
    0x00E9,  // -> letter e with acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x17CA:
    //   prefix:
    //     Compose
    //     <latin small letter f>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x002E,  // full stop
    0x1E1F,  // -> letter f with dot above
    0x0053,  // capital s
    0x017F,  // -> letter long s
    0x0073,  // letter s
    0x017F,  // -> letter long s
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x17D4:
    //   prefix:
    //     Compose
    //     <latin small letter g>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0005,          // number of entries
    0x0028,  // left parenthesis
    0x011F,  // -> letter g with breve
    0x002C,  // comma
    0x0123,  // -> letter g with cedilla
    0x002E,  // full stop
    0x0121,  // -> letter g with dot above
    0x0055,  // capital u
    0x011F,  // -> letter g with breve
    0x02D8,  // breve
    0x011F,  // -> letter g with breve
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x17E2:
    //   prefix:
    //     Compose
    //     <latin small letter i>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000C,          // number of entries
    0x0022,  // quotation mark
    0x00EF,  // -> letter i with diaeresis
    0x0027,  // apostrophe
    0x00ED,  // -> letter i with acute
    0x002C,  // comma
    0x012F,  // -> letter i with ogonek
    0x002D,  // hyphen-minus
    0x012B,  // -> letter i with macron
    0x002E,  // full stop
    0x0131,  // -> letter dotless i
    0x003E,  // greater-than sign
    0x00EE,  // -> letter i with circumflex
    0x005E,  // circumflex accent
    0x00EE,  // -> letter i with circumflex
    0x005F,  // low line
    0x012B,  // -> letter i with macron
    0x0060,  // grave accent
    0x00EC,  // -> letter i with grave
    0x007E,  // tilde
    0x0129,  // -> letter i with tilde
    0x00A8,  // diaeresis
    0x00EF,  // -> letter i with diaeresis
    0x00B4,  // acute accent
    0x00ED,  // -> letter i with acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x17FE:
    //   prefix:
    //     Compose
    //     <latin small letter k>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x002C,  // comma
    0x0137,  // -> letter k with cedilla
    0x006B,  // letter k
    0x0138,  // -> letter kra
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1806:
    //   prefix:
    //     Compose
    //     <latin small letter l>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0007,          // number of entries
    0x0027,  // apostrophe
    0x013A,  // -> letter l with acute
    0x002C,  // comma
    0x013C,  // -> letter l with cedilla
    0x002D,  // hyphen-minus
    0x00A3,  // -> pound sign
    0x002F,  // solidus
    0x0142,  // -> letter l with stroke
    0x003C,  // less-than sign
    0x013E,  // -> letter l with caron
    0x003D,  // equals sign
    0x00A3,  // -> pound sign
    0x0076,  // letter v
    0x007C,  // -> vertical line
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1818:
    //   prefix:
    //     Compose
    //     <latin small letter m>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x002E,  // full stop
    0x1E41,  // -> letter m with dot above
    0x002F,  // solidus
    0x20A5,  // -> mill sign
    0x0075,  // letter u
    0x00B5,  // -> micro sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1822:
    //   prefix:
    //     Compose
    //     <latin small letter n>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0027,  // apostrophe
    0x0144,  // -> letter n with acute
    0x002C,  // comma
    0x0146,  // -> letter n with cedilla
    0x002D,  // hyphen-minus
    0x00F1,  // -> letter n with tilde
    0x003C,  // less-than sign
    0x0148,  // -> letter n with caron
    0x0067,  // letter g
    0x014B,  // -> letter eng
    0x007E,  // tilde
    0x00F1,  // -> letter n with tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1832:
    //   prefix:
    //     Compose
    //     <latin small letter o>
    //   internal character table
    0x0001,          // number of entries
    0x0027,  // apostrophe
    0x186C,
    //   leaf character table
    0x001A,          // number of entries
    0x0022,  // quotation mark
    0x00F6,  // -> letter o with diaeresis
    0x0027,  // apostrophe
    0x00F3,  // -> letter o with acute
    0x002D,  // hyphen-minus
    0x014D,  // -> letter o with macron
    0x002F,  // solidus
    0x00F8,  // -> letter o with stroke
    0x003E,  // greater-than sign
    0x00F4,  // -> letter o with circumflex
    0x0041,  // capital a
    0x00C5,  // -> capital a with ring above
    0x0043,  // capital c
    0x00A9,  // -> copyright sign
    0x0052,  // capital r
    0x00AE,  // -> registered sign
    0x0055,  // capital u
    0x016E,  // -> capital u with ring above
    0x0058,  // capital x
    0x00A4,  // -> currency sign
    0x005E,  // circumflex accent
    0x00F4,  // -> letter o with circumflex
    0x005F,  // low line
    0x00BA,  // -> masculine ordinal indicator
    0x0060,  // grave accent
    0x00F2,  // -> letter o with grave
    0x0061,  // letter a
    0x00E5,  // -> letter a with ring above
    0x0063,  // letter c
    0x00A9,  // -> copyright sign
    0x0065,  // letter e
    0x0153,  // -> ligature oe
    0x006F,  // letter o
    0x00B0,  // -> degree sign
    0x0072,  // letter r
    0x00AE,  // -> registered sign
    0x0073,  // letter s
    0x00A7,  // -> section sign
    0x0075,  // letter u
    0x016F,  // -> letter u with ring above
    0x0077,  // letter w
    0x1E98,  // -> letter w with ring above
    0x0078,  // letter x
    0x00A4,  // -> currency sign
    0x0079,  // letter y
    0x1E99,  // -> letter y with ring above
    0x007E,  // tilde
    0x00F5,  // -> letter o with tilde
    0x00A8,  // diaeresis
    0x00F6,  // -> letter o with diaeresis
    0x00B4,  // acute accent
    0x00F3,  // -> letter o with acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x186C:
    //   prefix:
    //     Compose
    //     <latin small letter o>
    //     <apostrophe>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x01FA,  // -> capital a with ring above and acute
    0x0061,  // letter a
    0x01FB,  // -> letter a with ring above and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1874:
    //   prefix:
    //     Compose
    //     <latin small letter p>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0021,  // exclamation mark
    0x00B6,  // -> pilcrow sign
    0x002E,  // full stop
    0x1E57,  // -> letter p with dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x187C:
    //   prefix:
    //     Compose
    //     <latin small letter r>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x0027,  // apostrophe
    0x0155,  // -> letter r with acute
    0x002C,  // comma
    0x0157,  // -> letter r with cedilla
    0x003C,  // less-than sign
    0x0159,  // -> letter r with caron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1886:
    //   prefix:
    //     Compose
    //     <latin small letter s>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000E,          // number of entries
    0x0021,  // exclamation mark
    0x00A7,  // -> section sign
    0x0027,  // apostrophe
    0x015B,  // -> letter s with acute
    0x002C,  // comma
    0x015F,  // -> letter s with cedilla
    0x002E,  // full stop
    0x1E61,  // -> letter s with dot above
    0x0030,  // digit zero
    0x00A7,  // -> section sign
    0x0031,  // digit one
    0x00B9,  // -> superscript one
    0x0032,  // digit two
    0x00B2,  // -> superscript two
    0x0033,  // digit three
    0x00B3,  // -> superscript three
    0x003C,  // less-than sign
    0x0161,  // -> letter s with caron
    0x004D,  // capital m
    0x2120,  // -> service mark
    0x006D,  // letter m
    0x2120,  // -> service mark
    0x006F,  // letter o
    0x00A7,  // -> section sign
    0x0073,  // letter s
    0x00DF,  // -> letter sharp s
    0x00B8,  // cedilla
    0x015F,  // -> letter s with cedilla
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x18A6:
    //   prefix:
    //     Compose
    //     <latin small letter t>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0007,          // number of entries
    0x002D,  // hyphen-minus
    0x0167,  // -> letter t with stroke
    0x002E,  // full stop
    0x1E6B,  // -> letter t with dot above
    0x002F,  // solidus
    0x0167,  // -> letter t with stroke
    0x003C,  // less-than sign
    0x0165,  // -> letter t with caron
    0x004D,  // capital m
    0x2122,  // -> trade mark sign
    0x0068,  // letter h
    0x00FE,  // -> letter thorn
    0x006D,  // letter m
    0x2122,  // -> trade mark sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x18B8:
    //   prefix:
    //     Compose
    //     <latin small letter u>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000E,          // number of entries
    0x0022,  // quotation mark
    0x00FC,  // -> letter u with diaeresis
    0x0027,  // apostrophe
    0x00FA,  // -> letter u with acute
    0x002A,  // asterisk
    0x016F,  // -> letter u with ring above
    0x002C,  // comma
    0x0173,  // -> letter u with ogonek
    0x002D,  // hyphen-minus
    0x016B,  // -> letter u with macron
    0x002F,  // solidus
    0x00B5,  // -> micro sign
    0x003E,  // greater-than sign
    0x00FB,  // -> letter u with circumflex
    0x005E,  // circumflex accent
    0x00FB,  // -> letter u with circumflex
    0x005F,  // low line
    0x016B,  // -> letter u with macron
    0x0060,  // grave accent
    0x00F9,  // -> letter u with grave
    0x0075,  // letter u
    0x016D,  // -> letter u with breve
    0x007E,  // tilde
    0x0169,  // -> letter u with tilde
    0x00A8,  // diaeresis
    0x00FC,  // -> letter u with diaeresis
    0x00B4,  // acute accent
    0x00FA,  // -> letter u with acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x18D8:
    //   prefix:
    //     Compose
    //     <latin small letter v>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x005A,  // capital z
    0x017D,  // -> capital z with caron
    0x006C,  // letter l
    0x007C,  // -> vertical line
    0x007A,  // letter z
    0x017E,  // -> letter z with caron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x18E2:
    //   prefix:
    //     Compose
    //     <latin small letter w>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x005E,  // circumflex accent
    0x0175,  // -> letter w with circumflex
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x18E8:
    //   prefix:
    //     Compose
    //     <latin small letter x>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0030,  // digit zero
    0x00A4,  // -> currency sign
    0x004F,  // capital o
    0x00A4,  // -> currency sign
    0x006F,  // letter o
    0x00A4,  // -> currency sign
    0x0078,  // letter x
    0x00D7,  // -> multiplication sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x18F4:
    //   prefix:
    //     Compose
    //     <latin small letter y>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0007,          // number of entries
    0x0022,  // quotation mark
    0x00FF,  // -> letter y with diaeresis
    0x0027,  // apostrophe
    0x00FD,  // -> letter y with acute
    0x002D,  // hyphen-minus
    0x00A5,  // -> yen sign
    0x003D,  // equals sign
    0x00A5,  // -> yen sign
    0x005E,  // circumflex accent
    0x0177,  // -> letter y with circumflex
    0x00A8,  // diaeresis
    0x00FF,  // -> letter y with diaeresis
    0x00B4,  // acute accent
    0x00FD,  // -> letter y with acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1906:
    //   prefix:
    //     Compose
    //     <latin small letter z>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x0027,  // apostrophe
    0x017A,  // -> letter z with acute
    0x002E,  // full stop
    0x017C,  // -> letter z with dot above
    0x003C,  // less-than sign
    0x017E,  // -> letter z with caron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1910:
    //   prefix:
    //     Compose
    //     <vertical line>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0043,  // capital c
    0x00A2,  // -> cent sign
    0x0063,  // letter c
    0x00A2,  // -> cent sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1918:
    //   prefix:
    //     Compose
    //     <tilde>
    //   internal character table
    0x0006,          // number of entries
    0x0022,  // quotation mark
    0x199A,
    0x0028,  // left parenthesis
    0x19A2,
    0x0029,  // right parenthesis
    0x19BA,
    0x002B,  // plus sign
    0x19D0,
    0x005E,  // circumflex accent
    0x19DC,
    0x0062,  // letter b
    0x19EC,
    //   leaf character table
    0x0033,          // number of entries
    0x0020,  // space
    0x007E,  // -> tilde
    0x0041,  // capital a
    0x00C3,  // -> capital a with tilde
    0x0045,  // capital e
    0x1EBC,  // -> capital e with tilde
    0x0049,  // capital i
    0x0128,  // -> capital i with tilde
    0x004E,  // capital n
    0x00D1,  // -> capital n with tilde
    0x004F,  // capital o
    0x00D5,  // -> capital o with tilde
    0x0055,  // capital u
    0x0168,  // -> capital u with tilde
    0x0056,  // capital v
    0x1E7C,  // -> capital v with tilde
    0x0059,  // capital y
    0x1EF8,  // -> capital y with tilde
    0x0061,  // letter a
    0x00E3,  // -> letter a with tilde
    0x0065,  // letter e
    0x1EBD,  // -> letter e with tilde
    0x0069,  // letter i
    0x0129,  // -> letter i with tilde
    0x006E,  // letter n
    0x00F1,  // -> letter n with tilde
    0x006F,  // letter o
    0x00F5,  // -> letter o with tilde
    0x0075,  // letter u
    0x0169,  // -> letter u with tilde
    0x0076,  // letter v
    0x1E7D,  // -> letter v with tilde
    0x0079,  // letter y
    0x1EF9,  // -> letter y with tilde
    0x00C2,  // capital a with circumflex
    0x1EAA,  // -> capital a with circumflex and tilde
    0x00CA,  // capital e with circumflex
    0x1EC4,  // -> capital e with circumflex and tilde
    0x00D4,  // capital o with circumflex
    0x1ED6,  // -> capital o with circumflex and tilde
    0x00E2,  // letter a with circumflex
    0x1EAB,  // -> letter a with circumflex and tilde
    0x00EA,  // letter e with circumflex
    0x1EC5,  // -> letter e with circumflex and tilde
    0x00F4,  // letter o with circumflex
    0x1ED7,  // -> letter o with circumflex and tilde
    0x0102,  // capital a with breve
    0x1EB4,  // -> capital a with breve and tilde
    0x0103,  // letter a with breve
    0x1EB5,  // -> letter a with breve and tilde
    0x03B1,  // letter alpha
    0x1FB6,  // -> letter alpha with perispomeni
    0x03B7,  // letter eta
    0x1FC6,  // -> letter eta with perispomeni
    0x03B9,  // letter iota
    0x1FD6,  // -> letter iota with perispomeni
    0x03C5,  // letter upsilon
    0x1FE6,  // -> letter upsilon with perispomeni
    0x03C9,  // letter omega
    0x1FF6,  // -> letter omega with perispomeni
    0x03CA,  // letter iota with dialytika
    0x1FD7,  // -> letter iota with dialytika and perispomeni
    0x03CB,  // letter upsilon with dialytika
    0x1FE7,  // -> letter upsilon with dialytika and perispomeni
    0x1F00,  // letter alpha with psili
    0x1F06,  // -> letter alpha with psili and perispomeni
    0x1F01,  // letter alpha with dasia
    0x1F07,  // -> letter alpha with dasia and perispomeni
    0x1F08,  // capital alpha with psili
    0x1F0E,  // -> capital alpha with psili and perispomeni
    0x1F09,  // capital alpha with dasia
    0x1F0F,  // -> capital alpha with dasia and perispomeni
    0x1F20,  // letter eta with psili
    0x1F26,  // -> letter eta with psili and perispomeni
    0x1F21,  // letter eta with dasia
    0x1F27,  // -> letter eta with dasia and perispomeni
    0x1F28,  // capital eta with psili
    0x1F2E,  // -> capital eta with psili and perispomeni
    0x1F29,  // capital eta with dasia
    0x1F2F,  // -> capital eta with dasia and perispomeni
    0x1F30,  // letter iota with psili
    0x1F36,  // -> letter iota with psili and perispomeni
    0x1F31,  // letter iota with dasia
    0x1F37,  // -> letter iota with dasia and perispomeni
    0x1F38,  // capital iota with psili
    0x1F3E,  // -> capital iota with psili and perispomeni
    0x1F39,  // capital iota with dasia
    0x1F3F,  // -> capital iota with dasia and perispomeni
    0x1F50,  // letter upsilon with psili
    0x1F56,  // -> letter upsilon with psili and perispomeni
    0x1F51,  // letter upsilon with dasia
    0x1F57,  // -> letter upsilon with dasia and perispomeni
    0x1F59,  // capital upsilon with dasia
    0x1F5F,  // -> capital upsilon with dasia and perispomeni
    0x1F60,  // letter omega with psili
    0x1F66,  // -> letter omega with psili and perispomeni
    0x1F61,  // letter omega with dasia
    0x1F67,  // -> letter omega with dasia and perispomeni
    0x1F68,  // capital omega with psili
    0x1F6E,  // -> capital omega with psili and perispomeni
    0x1F69,  // capital omega with dasia
    0x1F6F,  // -> capital omega with dasia and perispomeni
    //   internal dead_key table
    0x0006,          // number of entries
    0x0302,  // combining circumflex accent
    0x19F4,
    0x0306,  // combining breve
    0x1A04,
    0x0308,  // combining diaeresis
    0x1A0C,
    0x0313,  // combining comma above
    0x1A14,
    0x0314,  // combining reversed comma above
    0x1A2A,
    0x031B,  // combining horn
    0x1A42,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x199A:
    //   prefix:
    //     Compose
    //     <tilde>
    //     <quotation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x03B9,  // letter iota
    0x1FD7,  // -> letter iota with dialytika and perispomeni
    0x03C5,  // letter upsilon
    0x1FE7,  // -> letter upsilon with dialytika and perispomeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x19A2:
    //   prefix:
    //     Compose
    //     <tilde>
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000A,          // number of entries
    0x0391,  // capital alpha
    0x1F0F,  // -> capital alpha with dasia and perispomeni
    0x0397,  // capital eta
    0x1F2F,  // -> capital eta with dasia and perispomeni
    0x0399,  // capital iota
    0x1F3F,  // -> capital iota with dasia and perispomeni
    0x03A5,  // capital upsilon
    0x1F5F,  // -> capital upsilon with dasia and perispomeni
    0x03A9,  // capital omega
    0x1F6F,  // -> capital omega with dasia and perispomeni
    0x03B1,  // letter alpha
    0x1F07,  // -> letter alpha with dasia and perispomeni
    0x03B7,  // letter eta
    0x1F27,  // -> letter eta with dasia and perispomeni
    0x03B9,  // letter iota
    0x1F37,  // -> letter iota with dasia and perispomeni
    0x03C5,  // letter upsilon
    0x1F57,  // -> letter upsilon with dasia and perispomeni
    0x03C9,  // letter omega
    0x1F67,  // -> letter omega with dasia and perispomeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x19BA:
    //   prefix:
    //     Compose
    //     <tilde>
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0009,          // number of entries
    0x0391,  // capital alpha
    0x1F0E,  // -> capital alpha with psili and perispomeni
    0x0397,  // capital eta
    0x1F2E,  // -> capital eta with psili and perispomeni
    0x0399,  // capital iota
    0x1F3E,  // -> capital iota with psili and perispomeni
    0x03A9,  // capital omega
    0x1F6E,  // -> capital omega with psili and perispomeni
    0x03B1,  // letter alpha
    0x1F06,  // -> letter alpha with psili and perispomeni
    0x03B7,  // letter eta
    0x1F26,  // -> letter eta with psili and perispomeni
    0x03B9,  // letter iota
    0x1F36,  // -> letter iota with psili and perispomeni
    0x03C5,  // letter upsilon
    0x1F56,  // -> letter upsilon with psili and perispomeni
    0x03C9,  // letter omega
    0x1F66,  // -> letter omega with psili and perispomeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x19D0:
    //   prefix:
    //     Compose
    //     <tilde>
    //     <plus sign>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EE0,  // -> capital o with horn and tilde
    0x0055,  // capital u
    0x1EEE,  // -> capital u with horn and tilde
    0x006F,  // letter o
    0x1EE1,  // -> letter o with horn and tilde
    0x0075,  // letter u
    0x1EEF,  // -> letter u with horn and tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x19DC:
    //   prefix:
    //     Compose
    //     <tilde>
    //     <circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EAA,  // -> capital a with circumflex and tilde
    0x0045,  // capital e
    0x1EC4,  // -> capital e with circumflex and tilde
    0x004F,  // capital o
    0x1ED6,  // -> capital o with circumflex and tilde
    0x0061,  // letter a
    0x1EAB,  // -> letter a with circumflex and tilde
    0x0065,  // letter e
    0x1EC5,  // -> letter e with circumflex and tilde
    0x006F,  // letter o
    0x1ED7,  // -> letter o with circumflex and tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x19EC:
    //   prefix:
    //     Compose
    //     <tilde>
    //     <latin small letter b>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB4,  // -> capital a with breve and tilde
    0x0061,  // letter a
    0x1EB5,  // -> letter a with breve and tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x19F4:
    //   prefix:
    //     Compose
    //     <tilde>
    //     Dead<combining circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EAA,  // -> capital a with circumflex and tilde
    0x0045,  // capital e
    0x1EC4,  // -> capital e with circumflex and tilde
    0x004F,  // capital o
    0x1ED6,  // -> capital o with circumflex and tilde
    0x0061,  // letter a
    0x1EAB,  // -> letter a with circumflex and tilde
    0x0065,  // letter e
    0x1EC5,  // -> letter e with circumflex and tilde
    0x006F,  // letter o
    0x1ED7,  // -> letter o with circumflex and tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1A04:
    //   prefix:
    //     Compose
    //     <tilde>
    //     Dead<combining breve>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB4,  // -> capital a with breve and tilde
    0x0061,  // letter a
    0x1EB5,  // -> letter a with breve and tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1A0C:
    //   prefix:
    //     Compose
    //     <tilde>
    //     Dead<combining diaeresis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x03B9,  // letter iota
    0x1FD7,  // -> letter iota with dialytika and perispomeni
    0x03C5,  // letter upsilon
    0x1FE7,  // -> letter upsilon with dialytika and perispomeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1A14:
    //   prefix:
    //     Compose
    //     <tilde>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0009,          // number of entries
    0x0391,  // capital alpha
    0x1F0E,  // -> capital alpha with psili and perispomeni
    0x0397,  // capital eta
    0x1F2E,  // -> capital eta with psili and perispomeni
    0x0399,  // capital iota
    0x1F3E,  // -> capital iota with psili and perispomeni
    0x03A9,  // capital omega
    0x1F6E,  // -> capital omega with psili and perispomeni
    0x03B1,  // letter alpha
    0x1F06,  // -> letter alpha with psili and perispomeni
    0x03B7,  // letter eta
    0x1F26,  // -> letter eta with psili and perispomeni
    0x03B9,  // letter iota
    0x1F36,  // -> letter iota with psili and perispomeni
    0x03C5,  // letter upsilon
    0x1F56,  // -> letter upsilon with psili and perispomeni
    0x03C9,  // letter omega
    0x1F66,  // -> letter omega with psili and perispomeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1A2A:
    //   prefix:
    //     Compose
    //     <tilde>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000A,          // number of entries
    0x0391,  // capital alpha
    0x1F0F,  // -> capital alpha with dasia and perispomeni
    0x0397,  // capital eta
    0x1F2F,  // -> capital eta with dasia and perispomeni
    0x0399,  // capital iota
    0x1F3F,  // -> capital iota with dasia and perispomeni
    0x03A5,  // capital upsilon
    0x1F5F,  // -> capital upsilon with dasia and perispomeni
    0x03A9,  // capital omega
    0x1F6F,  // -> capital omega with dasia and perispomeni
    0x03B1,  // letter alpha
    0x1F07,  // -> letter alpha with dasia and perispomeni
    0x03B7,  // letter eta
    0x1F27,  // -> letter eta with dasia and perispomeni
    0x03B9,  // letter iota
    0x1F37,  // -> letter iota with dasia and perispomeni
    0x03C5,  // letter upsilon
    0x1F57,  // -> letter upsilon with dasia and perispomeni
    0x03C9,  // letter omega
    0x1F67,  // -> letter omega with dasia and perispomeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1A42:
    //   prefix:
    //     Compose
    //     <tilde>
    //     Dead<combining horn>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EE0,  // -> capital o with horn and tilde
    0x0055,  // capital u
    0x1EEE,  // -> capital u with horn and tilde
    0x006F,  // letter o
    0x1EE1,  // -> letter o with horn and tilde
    0x0075,  // letter u
    0x1EEF,  // -> letter u with horn and tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1A4E:
    //   prefix:
    //     Compose
    //     <diaeresis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0010,          // number of entries
    0x0027,  // apostrophe
    0x0385,  // -> dialytika tonos
    0x0041,  // capital a
    0x00C4,  // -> capital a with diaeresis
    0x0045,  // capital e
    0x00CB,  // -> capital e with diaeresis
    0x0049,  // capital i
    0x00CF,  // -> capital i with diaeresis
    0x004F,  // capital o
    0x00D6,  // -> capital o with diaeresis
    0x0055,  // capital u
    0x00DC,  // -> capital u with diaeresis
    0x0059,  // capital y
    0x0178,  // -> capital y with diaeresis
    0x0060,  // grave accent
    0x1FED,  // -> dialytika and varia
    0x0061,  // letter a
    0x00E4,  // -> letter a with diaeresis
    0x0065,  // letter e
    0x00EB,  // -> letter e with diaeresis
    0x0069,  // letter i
    0x00EF,  // -> letter i with diaeresis
    0x006F,  // letter o
    0x00F6,  // -> letter o with diaeresis
    0x0075,  // letter u
    0x00FC,  // -> letter u with diaeresis
    0x0079,  // letter y
    0x00FF,  // -> letter y with diaeresis
    0x007E,  // tilde
    0x1FC1,  // -> dialytika and perispomeni
    0x00B4,  // acute accent
    0x0385,  // -> dialytika tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0003,          // number of entries
    0x0300,  // combining grave accent
    0x1FED,  // -> dialytika and varia
    0x0301,  // combining acute accent
    0x0385,  // -> dialytika tonos
    0x0303,  // combining tilde
    0x1FC1,  // -> dialytika and perispomeni

    // offset 0x1A78:
    //   prefix:
    //     Compose
    //     <macron>
    //   internal character table
    0x0005,          // number of entries
    0x0021,  // exclamation mark
    0x1AE8,
    0x0022,  // quotation mark
    0x1AF4,
    0x002E,  // full stop
    0x1B04,
    0x003B,  // semicolon
    0x1B10,
    0x007E,  // tilde
    0x1B18,
    //   leaf character table
    0x002C,          // number of entries
    0x0041,  // capital a
    0x0100,  // -> capital a with macron
    0x0045,  // capital e
    0x0112,  // -> capital e with macron
    0x0047,  // capital g
    0x1E20,  // -> capital g with macron
    0x0049,  // capital i
    0x012A,  // -> capital i with macron
    0x004F,  // capital o
    0x014C,  // -> capital o with macron
    0x0055,  // capital u
    0x016A,  // -> capital u with macron
    0x0059,  // capital y
    0x0232,  // -> capital y with macron
    0x0061,  // letter a
    0x0101,  // -> letter a with macron
    0x0065,  // letter e
    0x0113,  // -> letter e with macron
    0x0067,  // letter g
    0x1E21,  // -> letter g with macron
    0x0069,  // letter i
    0x012B,  // -> letter i with macron
    0x006F,  // letter o
    0x014D,  // -> letter o with macron
    0x0075,  // letter u
    0x016B,  // -> letter u with macron
    0x0079,  // letter y
    0x0233,  // -> letter y with macron
    0x00C4,  // capital a with diaeresis
    0x01DE,  // -> capital a with diaeresis and macron
    0x00C6,  // capital ae
    0x01E2,  // -> capital ae with macron
    0x00D5,  // capital o with tilde
    0x022C,  // -> capital o with tilde and macron
    0x00D6,  // capital o with diaeresis
    0x022A,  // -> capital o with diaeresis and macron
    0x00DC,  // capital u with diaeresis
    0x01D5,  // -> capital u with diaeresis and macron
    0x00E4,  // letter a with diaeresis
    0x01DF,  // -> letter a with diaeresis and macron
    0x00E6,  // letter ae
    0x01E3,  // -> letter ae with macron
    0x00F5,  // letter o with tilde
    0x022D,  // -> letter o with tilde and macron
    0x00F6,  // letter o with diaeresis
    0x022B,  // -> letter o with diaeresis and macron
    0x00FC,  // letter u with diaeresis
    0x01D6,  // -> letter u with diaeresis and macron
    0x0119,  // letter e with ogonek
    0x01EC,  // -> capital o with ogonek and macron
    0x01EB,  // letter o with ogonek
    0x01ED,  // -> letter o with ogonek and macron
    0x0226,  // capital a with dot above
    0x01E0,  // -> capital a with dot above and macron
    0x0227,  // letter a with dot above
    0x01E1,  // -> letter a with dot above and macron
    0x022E,  // capital o with dot above
    0x0230,  // -> capital o with dot above and macron
    0x022F,  // letter o with dot above
    0x0231,  // -> letter o with dot above and macron
    0x0391,  // capital alpha
    0x1FB9,  // -> capital alpha with macron
    0x0399,  // capital iota
    0x1FD9,  // -> capital iota with macron
    0x03A5,  // capital upsilon
    0x1FE9,  // -> capital upsilon with macron
    0x03B1,  // letter alpha
    0x1FB1,  // -> letter alpha with macron
    0x03B9,  // letter iota
    0x1FD1,  // -> letter iota with macron
    0x03C5,  // letter upsilon
    0x1FE1,  // -> letter upsilon with macron
    0x0418,  // cyrillic capital i
    0x04E2,  // -> cyrillic capital i with macron
    0x0423,  // cyrillic capital u
    0x04EE,  // -> cyrillic capital u with macron
    0x0438,  // cyrillic small i
    0x04E3,  // -> cyrillic small i with macron
    0x0443,  // cyrillic small u
    0x04EF,  // -> cyrillic small u with macron
    0x1E36,  // capital l with dot below
    0x1E38,  // -> capital l with dot below and macron
    0x1E37,  // letter l with dot below
    0x1E39,  // -> letter l with dot below and macron
    0x1E5A,  // capital r with dot below
    0x1E5C,  // -> capital r with dot below and macron
    0x1E5B,  // letter r with dot below
    0x1E5D,  // -> letter r with dot below and macron
    //   internal dead_key table
    0x0005,          // number of entries
    0x0303,  // combining tilde
    0x1B20,
    0x0307,  // combining dot above
    0x1B28,
    0x0308,  // combining diaeresis
    0x1B34,
    0x0323,  // combining dot below
    0x1B44,
    0x0328,  // combining ogonek
    0x1B50,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1AE8:
    //   prefix:
    //     Compose
    //     <macron>
    //     <exclamation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004C,  // capital l
    0x1E38,  // -> capital l with dot below and macron
    0x0052,  // capital r
    0x1E5C,  // -> capital r with dot below and macron
    0x006C,  // letter l
    0x1E39,  // -> letter l with dot below and macron
    0x0072,  // letter r
    0x1E5D,  // -> letter r with dot below and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1AF4:
    //   prefix:
    //     Compose
    //     <macron>
    //     <quotation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x01DE,  // -> capital a with diaeresis and macron
    0x004F,  // capital o
    0x022A,  // -> capital o with diaeresis and macron
    0x0055,  // capital u
    0x01D5,  // -> capital u with diaeresis and macron
    0x0061,  // letter a
    0x01DF,  // -> letter a with diaeresis and macron
    0x006F,  // letter o
    0x022B,  // -> letter o with diaeresis and macron
    0x0075,  // letter u
    0x01D6,  // -> letter u with diaeresis and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1B04:
    //   prefix:
    //     Compose
    //     <macron>
    //     <full stop>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0041,  // capital a
    0x01E0,  // -> capital a with dot above and macron
    0x004F,  // capital o
    0x0230,  // -> capital o with dot above and macron
    0x0061,  // letter a
    0x01E1,  // -> letter a with dot above and macron
    0x006F,  // letter o
    0x0231,  // -> letter o with dot above and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1B10:
    //   prefix:
    //     Compose
    //     <macron>
    //     <semicolon>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x01EC,  // -> capital o with ogonek and macron
    0x006F,  // letter o
    0x01ED,  // -> letter o with ogonek and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1B18:
    //   prefix:
    //     Compose
    //     <macron>
    //     <tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x022C,  // -> capital o with tilde and macron
    0x006F,  // letter o
    0x022D,  // -> letter o with tilde and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1B20:
    //   prefix:
    //     Compose
    //     <macron>
    //     Dead<combining tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x022C,  // -> capital o with tilde and macron
    0x006F,  // letter o
    0x022D,  // -> letter o with tilde and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1B28:
    //   prefix:
    //     Compose
    //     <macron>
    //     Dead<combining dot above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0041,  // capital a
    0x01E0,  // -> capital a with dot above and macron
    0x004F,  // capital o
    0x0230,  // -> capital o with dot above and macron
    0x0061,  // letter a
    0x01E1,  // -> letter a with dot above and macron
    0x006F,  // letter o
    0x0231,  // -> letter o with dot above and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1B34:
    //   prefix:
    //     Compose
    //     <macron>
    //     Dead<combining diaeresis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x01DE,  // -> capital a with diaeresis and macron
    0x004F,  // capital o
    0x022A,  // -> capital o with diaeresis and macron
    0x0055,  // capital u
    0x01D5,  // -> capital u with diaeresis and macron
    0x0061,  // letter a
    0x01DF,  // -> letter a with diaeresis and macron
    0x006F,  // letter o
    0x022B,  // -> letter o with diaeresis and macron
    0x0075,  // letter u
    0x01D6,  // -> letter u with diaeresis and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1B44:
    //   prefix:
    //     Compose
    //     <macron>
    //     Dead<combining dot below>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004C,  // capital l
    0x1E38,  // -> capital l with dot below and macron
    0x0052,  // capital r
    0x1E5C,  // -> capital r with dot below and macron
    0x006C,  // letter l
    0x1E39,  // -> letter l with dot below and macron
    0x0072,  // letter r
    0x1E5D,  // -> letter r with dot below and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1B50:
    //   prefix:
    //     Compose
    //     <macron>
    //     Dead<combining ogonek>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x01EC,  // -> capital o with ogonek and macron
    0x006F,  // letter o
    0x01ED,  // -> letter o with ogonek and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1B58:
    //   prefix:
    //     Compose
    //     <acute accent>
    //   internal character table
    0x000C,          // number of entries
    0x0022,  // quotation mark
    0x1C62,
    0x0028,  // left parenthesis
    0x1C72,
    0x0029,  // right parenthesis
    0x1C92,
    0x002B,  // plus sign
    0x1CB0,
    0x002C,  // comma
    0x1CBC,
    0x002F,  // solidus
    0x1CC4,
    0x005E,  // circumflex accent
    0x1CCC,
    0x005F,  // low line
    0x1CDC,
    0x0062,  // letter b
    0x1CE8,
    0x007E,  // tilde
    0x1CF0,
    0x00AF,  // macron
    0x1CFC,
    0x00B8,  // cedilla
    0x1D08,
    //   leaf character table
    0x006D,          // number of entries
    0x0041,  // capital a
    0x00C1,  // -> capital a with acute
    0x0043,  // capital c
    0x0106,  // -> capital c with acute
    0x0045,  // capital e
    0x00C9,  // -> capital e with acute
    0x0047,  // capital g
    0x01F4,  // -> capital g with acute
    0x0049,  // capital i
    0x00CD,  // -> capital i with acute
    0x004B,  // capital k
    0x1E30,  // -> capital k with acute
    0x004C,  // capital l
    0x0139,  // -> capital l with acute
    0x004D,  // capital m
    0x1E3E,  // -> capital m with acute
    0x004E,  // capital n
    0x0143,  // -> capital n with acute
    0x004F,  // capital o
    0x00D3,  // -> capital o with acute
    0x0050,  // capital p
    0x1E54,  // -> capital p with acute
    0x0052,  // capital r
    0x0154,  // -> capital r with acute
    0x0053,  // capital s
    0x015A,  // -> capital s with acute
    0x0055,  // capital u
    0x00DA,  // -> capital u with acute
    0x0057,  // capital w
    0x1E82,  // -> capital w with acute
    0x0059,  // capital y
    0x00DD,  // -> capital y with acute
    0x005A,  // capital z
    0x0179,  // -> capital z with acute
    0x0061,  // letter a
    0x00E1,  // -> letter a with acute
    0x0063,  // letter c
    0x0107,  // -> letter c with acute
    0x0065,  // letter e
    0x00E9,  // -> letter e with acute
    0x0067,  // letter g
    0x01F5,  // -> letter g with acute
    0x0069,  // letter i
    0x00ED,  // -> letter i with acute
    0x006B,  // letter k
    0x1E31,  // -> letter k with acute
    0x006C,  // letter l
    0x013A,  // -> letter l with acute
    0x006D,  // letter m
    0x1E3F,  // -> letter m with acute
    0x006E,  // letter n
    0x0144,  // -> letter n with acute
    0x006F,  // letter o
    0x00F3,  // -> letter o with acute
    0x0070,  // letter p
    0x1E55,  // -> letter p with acute
    0x0072,  // letter r
    0x0155,  // -> letter r with acute
    0x0073,  // letter s
    0x015B,  // -> letter s with acute
    0x0075,  // letter u
    0x00FA,  // -> letter u with acute
    0x0077,  // letter w
    0x1E83,  // -> letter w with acute
    0x0079,  // letter y
    0x00FD,  // -> letter y with acute
    0x007A,  // letter z
    0x017A,  // -> letter z with acute
    0x00C2,  // capital a with circumflex
    0x1EA4,  // -> capital a with circumflex and acute
    0x00C5,  // capital a with ring above
    0x01FA,  // -> capital a with ring above and acute
    0x00C6,  // capital ae
    0x01FC,  // -> capital ae with acute
    0x00C7,  // capital c with cedilla
    0x1E08,  // -> capital c with cedilla and acute
    0x00CA,  // capital e with circumflex
    0x1EBE,  // -> capital e with circumflex and acute
    0x00CF,  // capital i with diaeresis
    0x1E2E,  // -> capital i with diaeresis and acute
    0x00D4,  // capital o with circumflex
    0x1ED0,  // -> capital o with circumflex and acute
    0x00D5,  // capital o with tilde
    0x1E4C,  // -> capital o with tilde and acute
    0x00D8,  // capital o with stroke
    0x01FE,  // -> capital o with stroke and acute
    0x00DC,  // capital u with diaeresis
    0x01D7,  // -> capital u with diaeresis and acute
    0x00E2,  // letter a with circumflex
    0x1EA5,  // -> letter a with circumflex and acute
    0x00E5,  // letter a with ring above
    0x01FB,  // -> letter a with ring above and acute
    0x00E6,  // letter ae
    0x01FD,  // -> letter ae with acute
    0x00E7,  // letter c with cedilla
    0x1E09,  // -> letter c with cedilla and acute
    0x00EA,  // letter e with circumflex
    0x1EBF,  // -> letter e with circumflex and acute
    0x00EF,  // letter i with diaeresis
    0x1E2F,  // -> letter i with diaeresis and acute
    0x00F4,  // letter o with circumflex
    0x1ED1,  // -> letter o with circumflex and acute
    0x00F5,  // letter o with tilde
    0x1E4D,  // -> letter o with tilde and acute
    0x00F8,  // letter o with stroke
    0x01FF,  // -> letter o with stroke and acute
    0x00FC,  // letter u with diaeresis
    0x01D8,  // -> letter u with diaeresis and acute
    0x0102,  // capital a with breve
    0x1EAE,  // -> capital a with breve and acute
    0x0103,  // letter a with breve
    0x1EAF,  // -> letter a with breve and acute
    0x0112,  // capital e with macron
    0x1E16,  // -> capital e with macron and acute
    0x0113,  // letter e with macron
    0x1E17,  // -> letter e with macron and acute
    0x014C,  // capital o with macron
    0x1E52,  // -> capital o with macron and acute
    0x014D,  // letter o with macron
    0x1E53,  // -> letter o with macron and acute
    0x0168,  // capital u with tilde
    0x1E78,  // -> capital u with tilde and acute
    0x0169,  // letter u with tilde
    0x1E79,  // -> letter u with tilde and acute
    0x0391,  // capital alpha
    0x0386,  // -> capital alpha with tonos
    0x0395,  // capital epsilon
    0x0388,  // -> capital epsilon with tonos
    0x0397,  // capital eta
    0x0389,  // -> capital eta with tonos
    0x0399,  // capital iota
    0x038A,  // -> capital iota with tonos
    0x039F,  // capital omicron
    0x038C,  // -> capital omicron with tonos
    0x03A5,  // capital upsilon
    0x038E,  // -> capital upsilon with tonos
    0x03A9,  // capital omega
    0x038F,  // -> capital omega with tonos
    0x03B1,  // letter alpha
    0x03AC,  // -> letter alpha with tonos
    0x03B5,  // letter epsilon
    0x03AD,  // -> letter epsilon with tonos
    0x03B7,  // letter eta
    0x03AE,  // -> letter eta with tonos
    0x03B9,  // letter iota
    0x03AF,  // -> letter iota with tonos
    0x03BF,  // letter omicron
    0x03CC,  // -> letter omicron with tonos
    0x03C5,  // letter upsilon
    0x03CD,  // -> letter upsilon with tonos
    0x03C9,  // letter omega
    0x03CE,  // -> letter omega with tonos
    0x03CA,  // letter iota with dialytika
    0x0390,  // -> letter iota with dialytika and tonos
    0x03CB,  // letter upsilon with dialytika
    0x03B0,  // -> letter upsilon with dialytika and tonos
    0x0413,  // cyrillic capital ghe
    0x0403,  // -> cyrillic capital gje
    0x041A,  // cyrillic capital ka
    0x040C,  // -> cyrillic capital kje
    0x0433,  // cyrillic small ghe
    0x0453,  // -> cyrillic small gje
    0x043A,  // cyrillic small ka
    0x045C,  // -> cyrillic small kje
    0x1F00,  // letter alpha with psili
    0x1F04,  // -> letter alpha with psili and oxia
    0x1F01,  // letter alpha with dasia
    0x1F05,  // -> letter alpha with dasia and oxia
    0x1F08,  // capital alpha with psili
    0x1F0C,  // -> capital alpha with psili and oxia
    0x1F09,  // capital alpha with dasia
    0x1F0D,  // -> capital alpha with dasia and oxia
    0x1F10,  // letter epsilon with psili
    0x1F14,  // -> letter epsilon with psili and oxia
    0x1F11,  // letter epsilon with dasia
    0x1F15,  // -> letter epsilon with dasia and oxia
    0x1F18,  // capital epsilon with psili
    0x1F1C,  // -> capital epsilon with psili and oxia
    0x1F19,  // capital epsilon with dasia
    0x1F1D,  // -> capital epsilon with dasia and oxia
    0x1F20,  // letter eta with psili
    0x1F24,  // -> letter eta with psili and oxia
    0x1F21,  // letter eta with dasia
    0x1F25,  // -> letter eta with dasia and oxia
    0x1F28,  // capital eta with psili
    0x1F2C,  // -> capital eta with psili and oxia
    0x1F29,  // capital eta with dasia
    0x1F2D,  // -> capital eta with dasia and oxia
    0x1F30,  // letter iota with psili
    0x1F34,  // -> letter iota with psili and oxia
    0x1F31,  // letter iota with dasia
    0x1F35,  // -> letter iota with dasia and oxia
    0x1F38,  // capital iota with psili
    0x1F3C,  // -> capital iota with psili and oxia
    0x1F39,  // capital iota with dasia
    0x1F3D,  // -> capital iota with dasia and oxia
    0x1F40,  // letter omicron with psili
    0x1F44,  // -> letter omicron with psili and oxia
    0x1F41,  // letter omicron with dasia
    0x1F45,  // -> letter omicron with dasia and oxia
    0x1F48,  // capital omicron with psili
    0x1F4C,  // -> capital omicron with psili and oxia
    0x1F49,  // capital omicron with dasia
    0x1F4D,  // -> capital omicron with dasia and oxia
    0x1F50,  // letter upsilon with psili
    0x1F54,  // -> letter upsilon with psili and oxia
    0x1F51,  // letter upsilon with dasia
    0x1F55,  // -> letter upsilon with dasia and oxia
    0x1F59,  // capital upsilon with dasia
    0x1F5D,  // -> capital upsilon with dasia and oxia
    0x1F60,  // letter omega with psili
    0x1F64,  // -> letter omega with psili and oxia
    0x1F61,  // letter omega with dasia
    0x1F65,  // -> letter omega with dasia and oxia
    0x1F68,  // capital omega with psili
    0x1F6C,  // -> capital omega with psili and oxia
    0x1F69,  // capital omega with dasia
    0x1F6D,  // -> capital omega with dasia and oxia
    //   internal dead_key table
    0x000A,          // number of entries
    0x0302,  // combining circumflex accent
    0x1D10,
    0x0303,  // combining tilde
    0x1D20,
    0x0304,  // combining macron
    0x1D2C,
    0x0306,  // combining breve
    0x1D38,
    0x0308,  // combining diaeresis
    0x1D40,
    0x030A,  // combining ring above
    0x1D50,
    0x0313,  // combining comma above
    0x1D58,
    0x0314,  // combining reversed comma above
    0x1D76,
    0x031B,  // combining horn
    0x1D96,
    0x0327,  // combining cedilla
    0x1DA2,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1C62:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     <quotation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0049,  // capital i
    0x1E2E,  // -> capital i with diaeresis and acute
    0x0055,  // capital u
    0x01D7,  // -> capital u with diaeresis and acute
    0x0069,  // letter i
    0x1E2F,  // -> letter i with diaeresis and acute
    0x0075,  // letter u
    0x01D8,  // -> letter u with diaeresis and acute
    0x03B9,  // letter iota
    0x0390,  // -> letter iota with dialytika and tonos
    0x03C5,  // letter upsilon
    0x03B0,  // -> letter upsilon with dialytika and tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1C72:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000E,          // number of entries
    0x0391,  // capital alpha
    0x1F0D,  // -> capital alpha with dasia and oxia
    0x0395,  // capital epsilon
    0x1F1D,  // -> capital epsilon with dasia and oxia
    0x0397,  // capital eta
    0x1F2D,  // -> capital eta with dasia and oxia
    0x0399,  // capital iota
    0x1F3D,  // -> capital iota with dasia and oxia
    0x039F,  // capital omicron
    0x1F4D,  // -> capital omicron with dasia and oxia
    0x03A5,  // capital upsilon
    0x1F5D,  // -> capital upsilon with dasia and oxia
    0x03A9,  // capital omega
    0x1F6D,  // -> capital omega with dasia and oxia
    0x03B1,  // letter alpha
    0x1F05,  // -> letter alpha with dasia and oxia
    0x03B5,  // letter epsilon
    0x1F15,  // -> letter epsilon with dasia and oxia
    0x03B7,  // letter eta
    0x1F25,  // -> letter eta with dasia and oxia
    0x03B9,  // letter iota
    0x1F35,  // -> letter iota with dasia and oxia
    0x03BF,  // letter omicron
    0x1F45,  // -> letter omicron with dasia and oxia
    0x03C5,  // letter upsilon
    0x1F55,  // -> letter upsilon with dasia and oxia
    0x03C9,  // letter omega
    0x1F65,  // -> letter omega with dasia and oxia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1C92:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000D,          // number of entries
    0x0391,  // capital alpha
    0x1F0C,  // -> capital alpha with psili and oxia
    0x0395,  // capital epsilon
    0x1F1C,  // -> capital epsilon with psili and oxia
    0x0397,  // capital eta
    0x1F2C,  // -> capital eta with psili and oxia
    0x0399,  // capital iota
    0x1F3C,  // -> capital iota with psili and oxia
    0x039F,  // capital omicron
    0x1F4C,  // -> capital omicron with psili and oxia
    0x03A9,  // capital omega
    0x1F6C,  // -> capital omega with psili and oxia
    0x03B1,  // letter alpha
    0x1F04,  // -> letter alpha with psili and oxia
    0x03B5,  // letter epsilon
    0x1F14,  // -> letter epsilon with psili and oxia
    0x03B7,  // letter eta
    0x1F24,  // -> letter eta with psili and oxia
    0x03B9,  // letter iota
    0x1F34,  // -> letter iota with psili and oxia
    0x03BF,  // letter omicron
    0x1F44,  // -> letter omicron with psili and oxia
    0x03C5,  // letter upsilon
    0x1F54,  // -> letter upsilon with psili and oxia
    0x03C9,  // letter omega
    0x1F64,  // -> letter omega with psili and oxia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1CB0:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     <plus sign>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EDA,  // -> capital o with horn and acute
    0x0055,  // capital u
    0x1EE8,  // -> capital u with horn and acute
    0x006F,  // letter o
    0x1EDB,  // -> letter o with horn and acute
    0x0075,  // letter u
    0x1EE9,  // -> letter u with horn and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1CBC:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     <comma>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0043,  // capital c
    0x1E08,  // -> capital c with cedilla and acute
    0x0063,  // letter c
    0x1E09,  // -> letter c with cedilla and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1CC4:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     <solidus>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x01FE,  // -> capital o with stroke and acute
    0x006F,  // letter o
    0x01FF,  // -> letter o with stroke and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1CCC:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     <circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EA4,  // -> capital a with circumflex and acute
    0x0045,  // capital e
    0x1EBE,  // -> capital e with circumflex and acute
    0x004F,  // capital o
    0x1ED0,  // -> capital o with circumflex and acute
    0x0061,  // letter a
    0x1EA5,  // -> letter a with circumflex and acute
    0x0065,  // letter e
    0x1EBF,  // -> letter e with circumflex and acute
    0x006F,  // letter o
    0x1ED1,  // -> letter o with circumflex and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1CDC:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     <low line>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0045,  // capital e
    0x1E16,  // -> capital e with macron and acute
    0x004F,  // capital o
    0x1E52,  // -> capital o with macron and acute
    0x0065,  // letter e
    0x1E17,  // -> letter e with macron and acute
    0x006F,  // letter o
    0x1E53,  // -> letter o with macron and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1CE8:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     <latin small letter b>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EAE,  // -> capital a with breve and acute
    0x0061,  // letter a
    0x1EAF,  // -> letter a with breve and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1CF0:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     <tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1E4C,  // -> capital o with tilde and acute
    0x0055,  // capital u
    0x1E78,  // -> capital u with tilde and acute
    0x006F,  // letter o
    0x1E4D,  // -> letter o with tilde and acute
    0x0075,  // letter u
    0x1E79,  // -> letter u with tilde and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1CFC:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     <macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0045,  // capital e
    0x1E16,  // -> capital e with macron and acute
    0x004F,  // capital o
    0x1E52,  // -> capital o with macron and acute
    0x0065,  // letter e
    0x1E17,  // -> letter e with macron and acute
    0x006F,  // letter o
    0x1E53,  // -> letter o with macron and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1D08:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     <cedilla>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0043,  // capital c
    0x1E08,  // -> capital c with cedilla and acute
    0x0063,  // letter c
    0x1E09,  // -> letter c with cedilla and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1D10:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     Dead<combining circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EA4,  // -> capital a with circumflex and acute
    0x0045,  // capital e
    0x1EBE,  // -> capital e with circumflex and acute
    0x004F,  // capital o
    0x1ED0,  // -> capital o with circumflex and acute
    0x0061,  // letter a
    0x1EA5,  // -> letter a with circumflex and acute
    0x0065,  // letter e
    0x1EBF,  // -> letter e with circumflex and acute
    0x006F,  // letter o
    0x1ED1,  // -> letter o with circumflex and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1D20:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     Dead<combining tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1E4C,  // -> capital o with tilde and acute
    0x0055,  // capital u
    0x1E78,  // -> capital u with tilde and acute
    0x006F,  // letter o
    0x1E4D,  // -> letter o with tilde and acute
    0x0075,  // letter u
    0x1E79,  // -> letter u with tilde and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1D2C:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     Dead<combining macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0045,  // capital e
    0x1E16,  // -> capital e with macron and acute
    0x004F,  // capital o
    0x1E52,  // -> capital o with macron and acute
    0x0065,  // letter e
    0x1E17,  // -> letter e with macron and acute
    0x006F,  // letter o
    0x1E53,  // -> letter o with macron and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1D38:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     Dead<combining breve>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EAE,  // -> capital a with breve and acute
    0x0061,  // letter a
    0x1EAF,  // -> letter a with breve and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1D40:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     Dead<combining diaeresis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0049,  // capital i
    0x1E2E,  // -> capital i with diaeresis and acute
    0x0055,  // capital u
    0x01D7,  // -> capital u with diaeresis and acute
    0x0069,  // letter i
    0x1E2F,  // -> letter i with diaeresis and acute
    0x0075,  // letter u
    0x01D8,  // -> letter u with diaeresis and acute
    0x03B9,  // letter iota
    0x0390,  // -> letter iota with dialytika and tonos
    0x03C5,  // letter upsilon
    0x03B0,  // -> letter upsilon with dialytika and tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1D50:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     Dead<combining ring above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x01FA,  // -> capital a with ring above and acute
    0x0061,  // letter a
    0x01FB,  // -> letter a with ring above and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1D58:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000D,          // number of entries
    0x0391,  // capital alpha
    0x1F0C,  // -> capital alpha with psili and oxia
    0x0395,  // capital epsilon
    0x1F1C,  // -> capital epsilon with psili and oxia
    0x0397,  // capital eta
    0x1F2C,  // -> capital eta with psili and oxia
    0x0399,  // capital iota
    0x1F3C,  // -> capital iota with psili and oxia
    0x039F,  // capital omicron
    0x1F4C,  // -> capital omicron with psili and oxia
    0x03A9,  // capital omega
    0x1F6C,  // -> capital omega with psili and oxia
    0x03B1,  // letter alpha
    0x1F04,  // -> letter alpha with psili and oxia
    0x03B5,  // letter epsilon
    0x1F14,  // -> letter epsilon with psili and oxia
    0x03B7,  // letter eta
    0x1F24,  // -> letter eta with psili and oxia
    0x03B9,  // letter iota
    0x1F34,  // -> letter iota with psili and oxia
    0x03BF,  // letter omicron
    0x1F44,  // -> letter omicron with psili and oxia
    0x03C5,  // letter upsilon
    0x1F54,  // -> letter upsilon with psili and oxia
    0x03C9,  // letter omega
    0x1F64,  // -> letter omega with psili and oxia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1D76:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000E,          // number of entries
    0x0391,  // capital alpha
    0x1F0D,  // -> capital alpha with dasia and oxia
    0x0395,  // capital epsilon
    0x1F1D,  // -> capital epsilon with dasia and oxia
    0x0397,  // capital eta
    0x1F2D,  // -> capital eta with dasia and oxia
    0x0399,  // capital iota
    0x1F3D,  // -> capital iota with dasia and oxia
    0x039F,  // capital omicron
    0x1F4D,  // -> capital omicron with dasia and oxia
    0x03A5,  // capital upsilon
    0x1F5D,  // -> capital upsilon with dasia and oxia
    0x03A9,  // capital omega
    0x1F6D,  // -> capital omega with dasia and oxia
    0x03B1,  // letter alpha
    0x1F05,  // -> letter alpha with dasia and oxia
    0x03B5,  // letter epsilon
    0x1F15,  // -> letter epsilon with dasia and oxia
    0x03B7,  // letter eta
    0x1F25,  // -> letter eta with dasia and oxia
    0x03B9,  // letter iota
    0x1F35,  // -> letter iota with dasia and oxia
    0x03BF,  // letter omicron
    0x1F45,  // -> letter omicron with dasia and oxia
    0x03C5,  // letter upsilon
    0x1F55,  // -> letter upsilon with dasia and oxia
    0x03C9,  // letter omega
    0x1F65,  // -> letter omega with dasia and oxia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1D96:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     Dead<combining horn>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EDA,  // -> capital o with horn and acute
    0x0055,  // capital u
    0x1EE8,  // -> capital u with horn and acute
    0x006F,  // letter o
    0x1EDB,  // -> letter o with horn and acute
    0x0075,  // letter u
    0x1EE9,  // -> letter u with horn and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1DA2:
    //   prefix:
    //     Compose
    //     <acute accent>
    //     Dead<combining cedilla>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0043,  // capital c
    0x1E08,  // -> capital c with cedilla and acute
    0x0063,  // letter c
    0x1E09,  // -> letter c with cedilla and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1DAA:
    //   prefix:
    //     Compose
    //     <cedilla>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0016,          // number of entries
    0x0043,  // capital c
    0x00C7,  // -> capital c with cedilla
    0x0044,  // capital d
    0x1E10,  // -> capital d with cedilla
    0x0045,  // capital e
    0x0228,  // -> capital e with cedilla
    0x0047,  // capital g
    0x0122,  // -> capital g with cedilla
    0x0048,  // capital h
    0x1E28,  // -> capital h with cedilla
    0x004B,  // capital k
    0x0136,  // -> capital k with cedilla
    0x004C,  // capital l
    0x013B,  // -> capital l with cedilla
    0x004E,  // capital n
    0x0145,  // -> capital n with cedilla
    0x0052,  // capital r
    0x0156,  // -> capital r with cedilla
    0x0053,  // capital s
    0x015E,  // -> capital s with cedilla
    0x0054,  // capital t
    0x0162,  // -> capital t with cedilla
    0x0063,  // letter c
    0x00E7,  // -> letter c with cedilla
    0x0064,  // letter d
    0x1E11,  // -> letter d with cedilla
    0x0065,  // letter e
    0x0229,  // -> letter e with cedilla
    0x0067,  // letter g
    0x0123,  // -> letter g with cedilla
    0x0068,  // letter h
    0x1E29,  // -> letter h with cedilla
    0x006B,  // letter k
    0x0137,  // -> letter k with cedilla
    0x006C,  // letter l
    0x013C,  // -> letter l with cedilla
    0x006E,  // letter n
    0x0146,  // -> letter n with cedilla
    0x0072,  // letter r
    0x0157,  // -> letter r with cedilla
    0x0073,  // letter s
    0x015F,  // -> letter s with cedilla
    0x0074,  // letter t
    0x0163,  // -> letter t with cedilla
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1DDA:
    //   prefix:
    //     Compose
    //     <breve>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0047,  // capital g
    0x011E,  // -> capital g with breve
    0x0067,  // letter g
    0x011F,  // -> letter g with breve
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1DE2:
    //   prefix:
    //     Compose
    //     <greek capital letter alpha>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0027,  // apostrophe
    0x0386,  // -> capital alpha with tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1DE8:
    //   prefix:
    //     Compose
    //     <greek capital letter epsilon>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0027,  // apostrophe
    0x0388,  // -> capital epsilon with tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1DEE:
    //   prefix:
    //     Compose
    //     <greek capital letter eta>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0027,  // apostrophe
    0x0389,  // -> capital eta with tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1DF4:
    //   prefix:
    //     Compose
    //     <greek capital letter iota>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0022,  // quotation mark
    0x03AA,  // -> capital iota with dialytika
    0x0027,  // apostrophe
    0x038A,  // -> capital iota with tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1DFC:
    //   prefix:
    //     Compose
    //     <greek capital letter omicron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0027,  // apostrophe
    0x038C,  // -> capital omicron with tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1E02:
    //   prefix:
    //     Compose
    //     <greek capital letter upsilon>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0022,  // quotation mark
    0x03AB,  // -> capital upsilon with dialytika
    0x0027,  // apostrophe
    0x038E,  // -> capital upsilon with tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1E0A:
    //   prefix:
    //     Compose
    //     <greek capital letter omega>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0027,  // apostrophe
    0x038F,  // -> capital omega with tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1E10:
    //   prefix:
    //     Compose
    //     <greek small letter alpha>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0027,  // apostrophe
    0x03AC,  // -> letter alpha with tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1E16:
    //   prefix:
    //     Compose
    //     <greek small letter epsilon>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0027,  // apostrophe
    0x03AD,  // -> letter epsilon with tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1E1C:
    //   prefix:
    //     Compose
    //     <greek small letter eta>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0027,  // apostrophe
    0x03AE,  // -> letter eta with tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1E22:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //   internal character table
    0x0006,          // number of entries
    0x0027,  // apostrophe
    0x1EBE,
    0x0028,  // left parenthesis
    0x1F28,
    0x0029,  // right parenthesis
    0x1F38,
    0x0060,  // grave accent
    0x1F48,
    0x007E,  // tilde
    0x1FB2,
    0x00B4,  // acute accent
    0x201C,
    //   leaf character table
    0x0041,          // number of entries
    0x0022,  // quotation mark
    0x03CA,  // -> letter iota with dialytika
    0x0027,  // apostrophe
    0x03AF,  // -> letter iota with tonos
    0x0391,  // capital alpha
    0x1FBC,  // -> capital alpha with prosgegrammeni
    0x0397,  // capital eta
    0x1FCC,  // -> capital eta with prosgegrammeni
    0x03A9,  // capital omega
    0x1FFC,  // -> capital omega with prosgegrammeni
    0x03AC,  // letter alpha with tonos
    0x1FB4,  // -> letter alpha with oxia and ypogegrammeni
    0x03AE,  // letter eta with tonos
    0x1FC4,  // -> letter eta with oxia and ypogegrammeni
    0x03B1,  // letter alpha
    0x1FB3,  // -> letter alpha with ypogegrammeni
    0x03B7,  // letter eta
    0x1FC3,  // -> letter eta with ypogegrammeni
    0x03C9,  // letter omega
    0x1FF3,  // -> letter omega with ypogegrammeni
    0x03CE,  // letter omega with tonos
    0x1FF4,  // -> letter omega with oxia and ypogegrammeni
    0x1F00,  // letter alpha with psili
    0x1F80,  // -> letter alpha with psili and ypogegrammeni
    0x1F01,  // letter alpha with dasia
    0x1F81,  // -> letter alpha with dasia and ypogegrammeni
    0x1F02,  // letter alpha with psili and varia
    0x1F82,  // -> letter alpha with psili and varia and ypogegrammeni
    0x1F03,  // letter alpha with dasia and varia
    0x1F83,  // -> letter alpha with dasia and varia and ypogegrammeni
    0x1F04,  // letter alpha with psili and oxia
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x1F05,  // letter alpha with dasia and oxia
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x1F06,  // letter alpha with psili and perispomeni
    0x1F86,  // -> letter alpha with psili and perispomeni and ypogegrammeni
    0x1F07,  // letter alpha with dasia and perispomeni
    0x1F87,  // -> letter alpha with dasia and perispomeni and ypogegrammeni
    0x1F08,  // capital alpha with psili
    0x1F88,  // -> capital alpha with psili and prosgegrammeni
    0x1F09,  // capital alpha with dasia
    0x1F89,  // -> capital alpha with dasia and prosgegrammeni
    0x1F0A,  // capital alpha with psili and varia
    0x1F8A,  // -> capital alpha with psili and varia and prosgegrammeni
    0x1F0B,  // capital alpha with dasia and varia
    0x1F8B,  // -> capital alpha with dasia and varia and prosgegrammeni
    0x1F0C,  // capital alpha with psili and oxia
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x1F0D,  // capital alpha with dasia and oxia
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x1F0E,  // capital alpha with psili and perispomeni
    0x1F8E,  // -> capital alpha with psili and perispomeni and prosgegrammeni
    0x1F0F,  // capital alpha with dasia and perispomeni
    0x1F8F,  // -> capital alpha with dasia and perispomeni and prosgegrammeni
    0x1F20,  // letter eta with psili
    0x1F90,  // -> letter eta with psili and ypogegrammeni
    0x1F21,  // letter eta with dasia
    0x1F91,  // -> letter eta with dasia and ypogegrammeni
    0x1F22,  // letter eta with psili and varia
    0x1F92,  // -> letter eta with psili and varia and ypogegrammeni
    0x1F23,  // letter eta with dasia and varia
    0x1F93,  // -> letter eta with dasia and varia and ypogegrammeni
    0x1F24,  // letter eta with psili and oxia
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x1F25,  // letter eta with dasia and oxia
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x1F26,  // letter eta with psili and perispomeni
    0x1F96,  // -> letter eta with psili and perispomeni and ypogegrammeni
    0x1F27,  // letter eta with dasia and perispomeni
    0x1F97,  // -> letter eta with dasia and perispomeni and ypogegrammeni
    0x1F28,  // capital eta with psili
    0x1F98,  // -> capital eta with psili and prosgegrammeni
    0x1F29,  // capital eta with dasia
    0x1F99,  // -> capital eta with dasia and prosgegrammeni
    0x1F2A,  // capital eta with psili and varia
    0x1F9A,  // -> capital eta with psili and varia and prosgegrammeni
    0x1F2B,  // capital eta with dasia and varia
    0x1F9B,  // -> capital eta with dasia and varia and prosgegrammeni
    0x1F2C,  // capital eta with psili and oxia
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x1F2D,  // capital eta with dasia and oxia
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x1F2E,  // capital eta with psili and perispomeni
    0x1F9E,  // -> capital eta with psili and perispomeni and prosgegrammeni
    0x1F2F,  // capital eta with dasia and perispomeni
    0x1F9F,  // -> capital eta with dasia and perispomeni and prosgegrammeni
    0x1F60,  // letter omega with psili
    0x1FA0,  // -> letter omega with psili and ypogegrammeni
    0x1F61,  // letter omega with dasia
    0x1FA1,  // -> letter omega with dasia and ypogegrammeni
    0x1F62,  // letter omega with psili and varia
    0x1FA2,  // -> letter omega with psili and varia and ypogegrammeni
    0x1F63,  // letter omega with dasia and varia
    0x1FA3,  // -> letter omega with dasia and varia and ypogegrammeni
    0x1F64,  // letter omega with psili and oxia
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    0x1F65,  // letter omega with dasia and oxia
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    0x1F66,  // letter omega with psili and perispomeni
    0x1FA6,  // -> letter omega with psili and perispomeni and ypogegrammeni
    0x1F67,  // letter omega with dasia and perispomeni
    0x1FA7,  // -> letter omega with dasia and perispomeni and ypogegrammeni
    0x1F68,  // capital omega with psili
    0x1FA8,  // -> capital omega with psili and prosgegrammeni
    0x1F69,  // capital omega with dasia
    0x1FA9,  // -> capital omega with dasia and prosgegrammeni
    0x1F6A,  // capital omega with psili and varia
    0x1FAA,  // -> capital omega with psili and varia and prosgegrammeni
    0x1F6B,  // capital omega with dasia and varia
    0x1FAB,  // -> capital omega with dasia and varia and prosgegrammeni
    0x1F6C,  // capital omega with psili and oxia
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x1F6D,  // capital omega with dasia and oxia
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    0x1F6E,  // capital omega with psili and perispomeni
    0x1FAE,  // -> capital omega with psili and perispomeni and prosgegrammeni
    0x1F6F,  // capital omega with dasia and perispomeni
    0x1FAF,  // -> capital omega with dasia and perispomeni and prosgegrammeni
    0x1F70,  // letter alpha with varia
    0x1FB2,  // -> letter alpha with varia and ypogegrammeni
    0x1F74,  // letter eta with varia
    0x1FC2,  // -> letter eta with varia and ypogegrammeni
    0x1F7C,  // letter omega with varia
    0x1FF2,  // -> letter omega with varia and ypogegrammeni
    0x1FB6,  // letter alpha with perispomeni
    0x1FB7,  // -> letter alpha with perispomeni and ypogegrammeni
    0x1FC6,  // letter eta with perispomeni
    0x1FC7,  // -> letter eta with perispomeni and ypogegrammeni
    0x1FF6,  // letter omega with perispomeni
    0x1FF7,  // -> letter omega with perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0005,          // number of entries
    0x0300,  // combining grave accent
    0x2086,
    0x0301,  // combining acute accent
    0x20F0,
    0x0303,  // combining tilde
    0x215A,
    0x0313,  // combining comma above
    0x21C2,
    0x0314,  // combining reversed comma above
    0x21D2,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1EBE:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <apostrophe>
    //   internal character table
    0x0002,          // number of entries
    0x0028,  // left parenthesis
    0x1EE8,
    0x0029,  // right parenthesis
    0x1EF8,
    //   leaf character table
    0x000F,          // number of entries
    0x03B1,  // letter alpha
    0x1FB4,  // -> letter alpha with oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1FC4,  // -> letter eta with oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FF4,  // -> letter omega with oxia and ypogegrammeni
    0x1F00,  // letter alpha with psili
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x1F01,  // letter alpha with dasia
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x1F08,  // capital alpha with psili
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x1F09,  // capital alpha with dasia
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x1F20,  // letter eta with psili
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x1F21,  // letter eta with dasia
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x1F28,  // capital eta with psili
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x1F29,  // capital eta with dasia
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x1F60,  // letter omega with psili
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    0x1F61,  // letter omega with dasia
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    0x1F68,  // capital omega with psili
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x1F69,  // capital omega with dasia
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    //   internal dead_key table
    0x0002,          // number of entries
    0x0313,  // combining comma above
    0x1F08,
    0x0314,  // combining reversed comma above
    0x1F18,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1EE8:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <apostrophe>
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1EF8:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <apostrophe>
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1F08:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <apostrophe>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1F18:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <apostrophe>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1F28:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F89,  // -> capital alpha with dasia and prosgegrammeni
    0x0397,  // capital eta
    0x1F99,  // -> capital eta with dasia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FA9,  // -> capital omega with dasia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F81,  // -> letter alpha with dasia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F91,  // -> letter eta with dasia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA1,  // -> letter omega with dasia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1F38:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F88,  // -> capital alpha with psili and prosgegrammeni
    0x0397,  // capital eta
    0x1F98,  // -> capital eta with psili and prosgegrammeni
    0x03A9,  // capital omega
    0x1FA8,  // -> capital omega with psili and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F80,  // -> letter alpha with psili and ypogegrammeni
    0x03B7,  // letter eta
    0x1F90,  // -> letter eta with psili and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA0,  // -> letter omega with psili and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1F48:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <grave accent>
    //   internal character table
    0x0002,          // number of entries
    0x0028,  // left parenthesis
    0x1F72,
    0x0029,  // right parenthesis
    0x1F82,
    //   leaf character table
    0x000F,          // number of entries
    0x03B1,  // letter alpha
    0x1FB2,  // -> letter alpha with varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1FC2,  // -> letter eta with varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FF2,  // -> letter omega with varia and ypogegrammeni
    0x1F00,  // letter alpha with psili
    0x1F82,  // -> letter alpha with psili and varia and ypogegrammeni
    0x1F01,  // letter alpha with dasia
    0x1F83,  // -> letter alpha with dasia and varia and ypogegrammeni
    0x1F08,  // capital alpha with psili
    0x1F8A,  // -> capital alpha with psili and varia and prosgegrammeni
    0x1F09,  // capital alpha with dasia
    0x1F8B,  // -> capital alpha with dasia and varia and prosgegrammeni
    0x1F20,  // letter eta with psili
    0x1F92,  // -> letter eta with psili and varia and ypogegrammeni
    0x1F21,  // letter eta with dasia
    0x1F93,  // -> letter eta with dasia and varia and ypogegrammeni
    0x1F28,  // capital eta with psili
    0x1F9A,  // -> capital eta with psili and varia and prosgegrammeni
    0x1F29,  // capital eta with dasia
    0x1F9B,  // -> capital eta with dasia and varia and prosgegrammeni
    0x1F60,  // letter omega with psili
    0x1FA2,  // -> letter omega with psili and varia and ypogegrammeni
    0x1F61,  // letter omega with dasia
    0x1FA3,  // -> letter omega with dasia and varia and ypogegrammeni
    0x1F68,  // capital omega with psili
    0x1FAA,  // -> capital omega with psili and varia and prosgegrammeni
    0x1F69,  // capital omega with dasia
    0x1FAB,  // -> capital omega with dasia and varia and prosgegrammeni
    //   internal dead_key table
    0x0002,          // number of entries
    0x0313,  // combining comma above
    0x1F92,
    0x0314,  // combining reversed comma above
    0x1FA2,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1F72:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <grave accent>
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8B,  // -> capital alpha with dasia and varia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9B,  // -> capital eta with dasia and varia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAB,  // -> capital omega with dasia and varia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F83,  // -> letter alpha with dasia and varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F93,  // -> letter eta with dasia and varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA3,  // -> letter omega with dasia and varia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1F82:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <grave accent>
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8A,  // -> capital alpha with psili and varia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9A,  // -> capital eta with psili and varia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAA,  // -> capital omega with psili and varia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F82,  // -> letter alpha with psili and varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F92,  // -> letter eta with psili and varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA2,  // -> letter omega with psili and varia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1F92:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <grave accent>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8A,  // -> capital alpha with psili and varia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9A,  // -> capital eta with psili and varia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAA,  // -> capital omega with psili and varia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F82,  // -> letter alpha with psili and varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F92,  // -> letter eta with psili and varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA2,  // -> letter omega with psili and varia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1FA2:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <grave accent>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8B,  // -> capital alpha with dasia and varia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9B,  // -> capital eta with dasia and varia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAB,  // -> capital omega with dasia and varia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F83,  // -> letter alpha with dasia and varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F93,  // -> letter eta with dasia and varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA3,  // -> letter omega with dasia and varia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1FB2:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <tilde>
    //   internal character table
    0x0002,          // number of entries
    0x0028,  // left parenthesis
    0x1FDC,
    0x0029,  // right parenthesis
    0x1FEC,
    //   leaf character table
    0x000F,          // number of entries
    0x03B1,  // letter alpha
    0x1FB7,  // -> letter alpha with perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1FC7,  // -> letter eta with perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FF7,  // -> letter omega with perispomeni and ypogegrammeni
    0x1F00,  // letter alpha with psili
    0x1F86,  // -> letter alpha with psili and perispomeni and ypogegrammeni
    0x1F01,  // letter alpha with dasia
    0x1F87,  // -> letter alpha with dasia and perispomeni and ypogegrammeni
    0x1F08,  // capital alpha with psili
    0x1F8E,  // -> capital alpha with psili and perispomeni and prosgegrammeni
    0x1F09,  // capital alpha with dasia
    0x1F8F,  // -> capital alpha with dasia and perispomeni and prosgegrammeni
    0x1F20,  // letter eta with psili
    0x1F96,  // -> letter eta with psili and perispomeni and ypogegrammeni
    0x1F21,  // letter eta with dasia
    0x1F97,  // -> letter eta with dasia and perispomeni and ypogegrammeni
    0x1F28,  // capital eta with psili
    0x1F9E,  // -> capital eta with psili and perispomeni and prosgegrammeni
    0x1F29,  // capital eta with dasia
    0x1F9F,  // -> capital eta with dasia and perispomeni and prosgegrammeni
    0x1F60,  // letter omega with psili
    0x1FA6,  // -> letter omega with psili and perispomeni and ypogegrammeni
    0x1F61,  // letter omega with dasia
    0x1FA7,  // -> letter omega with dasia and perispomeni and ypogegrammeni
    0x1F68,  // capital omega with psili
    0x1FAE,  // -> capital omega with psili and perispomeni and prosgegrammeni
    0x1F69,  // capital omega with dasia
    0x1FAF,  // -> capital omega with dasia and perispomeni and prosgegrammeni
    //   internal dead_key table
    0x0002,          // number of entries
    0x0313,  // combining comma above
    0x1FFC,
    0x0314,  // combining reversed comma above
    0x200C,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1FDC:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <tilde>
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8F,  // -> capital alpha with dasia and perispomeni and prosgegrammeni
    0x0397,  // capital eta
    0x1F9F,  // -> capital eta with dasia and perispomeni and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAF,  // -> capital omega with dasia and perispomeni and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F87,  // -> letter alpha with dasia and perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1F97,  // -> letter eta with dasia and perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA7,  // -> letter omega with dasia and perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1FEC:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <tilde>
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8E,  // -> capital alpha with psili and perispomeni and prosgegrammeni
    0x0397,  // capital eta
    0x1F9E,  // -> capital eta with psili and perispomeni and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAE,  // -> capital omega with psili and perispomeni and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F86,  // -> letter alpha with psili and perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1F96,  // -> letter eta with psili and perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA6,  // -> letter omega with psili and perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x1FFC:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <tilde>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8E,  // -> capital alpha with psili and perispomeni and prosgegrammeni
    0x0397,  // capital eta
    0x1F9E,  // -> capital eta with psili and perispomeni and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAE,  // -> capital omega with psili and perispomeni and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F86,  // -> letter alpha with psili and perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1F96,  // -> letter eta with psili and perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA6,  // -> letter omega with psili and perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x200C:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <tilde>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8F,  // -> capital alpha with dasia and perispomeni and prosgegrammeni
    0x0397,  // capital eta
    0x1F9F,  // -> capital eta with dasia and perispomeni and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAF,  // -> capital omega with dasia and perispomeni and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F87,  // -> letter alpha with dasia and perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1F97,  // -> letter eta with dasia and perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA7,  // -> letter omega with dasia and perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x201C:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <acute accent>
    //   internal character table
    0x0002,          // number of entries
    0x0028,  // left parenthesis
    0x2046,
    0x0029,  // right parenthesis
    0x2056,
    //   leaf character table
    0x000F,          // number of entries
    0x03B1,  // letter alpha
    0x1FB4,  // -> letter alpha with oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1FC4,  // -> letter eta with oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FF4,  // -> letter omega with oxia and ypogegrammeni
    0x1F00,  // letter alpha with psili
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x1F01,  // letter alpha with dasia
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x1F08,  // capital alpha with psili
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x1F09,  // capital alpha with dasia
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x1F20,  // letter eta with psili
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x1F21,  // letter eta with dasia
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x1F28,  // capital eta with psili
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x1F29,  // capital eta with dasia
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x1F60,  // letter omega with psili
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    0x1F61,  // letter omega with dasia
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    0x1F68,  // capital omega with psili
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x1F69,  // capital omega with dasia
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    //   internal dead_key table
    0x0002,          // number of entries
    0x0313,  // combining comma above
    0x2066,
    0x0314,  // combining reversed comma above
    0x2076,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2046:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <acute accent>
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2056:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <acute accent>
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2066:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <acute accent>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2076:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     <acute accent>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2086:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     Dead<combining grave accent>
    //   internal character table
    0x0002,          // number of entries
    0x0028,  // left parenthesis
    0x20B0,
    0x0029,  // right parenthesis
    0x20C0,
    //   leaf character table
    0x000F,          // number of entries
    0x03B1,  // letter alpha
    0x1FB2,  // -> letter alpha with varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1FC2,  // -> letter eta with varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FF2,  // -> letter omega with varia and ypogegrammeni
    0x1F00,  // letter alpha with psili
    0x1F82,  // -> letter alpha with psili and varia and ypogegrammeni
    0x1F01,  // letter alpha with dasia
    0x1F83,  // -> letter alpha with dasia and varia and ypogegrammeni
    0x1F08,  // capital alpha with psili
    0x1F8A,  // -> capital alpha with psili and varia and prosgegrammeni
    0x1F09,  // capital alpha with dasia
    0x1F8B,  // -> capital alpha with dasia and varia and prosgegrammeni
    0x1F20,  // letter eta with psili
    0x1F92,  // -> letter eta with psili and varia and ypogegrammeni
    0x1F21,  // letter eta with dasia
    0x1F93,  // -> letter eta with dasia and varia and ypogegrammeni
    0x1F28,  // capital eta with psili
    0x1F9A,  // -> capital eta with psili and varia and prosgegrammeni
    0x1F29,  // capital eta with dasia
    0x1F9B,  // -> capital eta with dasia and varia and prosgegrammeni
    0x1F60,  // letter omega with psili
    0x1FA2,  // -> letter omega with psili and varia and ypogegrammeni
    0x1F61,  // letter omega with dasia
    0x1FA3,  // -> letter omega with dasia and varia and ypogegrammeni
    0x1F68,  // capital omega with psili
    0x1FAA,  // -> capital omega with psili and varia and prosgegrammeni
    0x1F69,  // capital omega with dasia
    0x1FAB,  // -> capital omega with dasia and varia and prosgegrammeni
    //   internal dead_key table
    0x0002,          // number of entries
    0x0313,  // combining comma above
    0x20D0,
    0x0314,  // combining reversed comma above
    0x20E0,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x20B0:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     Dead<combining grave accent>
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8B,  // -> capital alpha with dasia and varia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9B,  // -> capital eta with dasia and varia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAB,  // -> capital omega with dasia and varia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F83,  // -> letter alpha with dasia and varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F93,  // -> letter eta with dasia and varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA3,  // -> letter omega with dasia and varia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x20C0:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     Dead<combining grave accent>
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8A,  // -> capital alpha with psili and varia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9A,  // -> capital eta with psili and varia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAA,  // -> capital omega with psili and varia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F82,  // -> letter alpha with psili and varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F92,  // -> letter eta with psili and varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA2,  // -> letter omega with psili and varia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x20D0:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     Dead<combining grave accent>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8A,  // -> capital alpha with psili and varia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9A,  // -> capital eta with psili and varia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAA,  // -> capital omega with psili and varia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F82,  // -> letter alpha with psili and varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F92,  // -> letter eta with psili and varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA2,  // -> letter omega with psili and varia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x20E0:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     Dead<combining grave accent>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8B,  // -> capital alpha with dasia and varia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9B,  // -> capital eta with dasia and varia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAB,  // -> capital omega with dasia and varia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F83,  // -> letter alpha with dasia and varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F93,  // -> letter eta with dasia and varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA3,  // -> letter omega with dasia and varia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x20F0:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     Dead<combining acute accent>
    //   internal character table
    0x0002,          // number of entries
    0x0028,  // left parenthesis
    0x211A,
    0x0029,  // right parenthesis
    0x212A,
    //   leaf character table
    0x000F,          // number of entries
    0x03B1,  // letter alpha
    0x1FB4,  // -> letter alpha with oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1FC4,  // -> letter eta with oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FF4,  // -> letter omega with oxia and ypogegrammeni
    0x1F00,  // letter alpha with psili
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x1F01,  // letter alpha with dasia
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x1F08,  // capital alpha with psili
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x1F09,  // capital alpha with dasia
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x1F20,  // letter eta with psili
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x1F21,  // letter eta with dasia
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x1F28,  // capital eta with psili
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x1F29,  // capital eta with dasia
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x1F60,  // letter omega with psili
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    0x1F61,  // letter omega with dasia
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    0x1F68,  // capital omega with psili
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x1F69,  // capital omega with dasia
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    //   internal dead_key table
    0x0002,          // number of entries
    0x0313,  // combining comma above
    0x213A,
    0x0314,  // combining reversed comma above
    0x214A,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x211A:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     Dead<combining acute accent>
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x212A:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     Dead<combining acute accent>
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x213A:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     Dead<combining acute accent>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x214A:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     Dead<combining acute accent>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x215A:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     Dead<combining tilde>
    //   internal character table
    0x0002,          // number of entries
    0x0028,  // left parenthesis
    0x2184,
    0x0029,  // right parenthesis
    0x2194,
    //   leaf character table
    0x000F,          // number of entries
    0x03B1,  // letter alpha
    0x1FB7,  // -> letter alpha with perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1FC7,  // -> letter eta with perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FF7,  // -> letter omega with perispomeni and ypogegrammeni
    0x1F00,  // letter alpha with psili
    0x1F86,  // -> letter alpha with psili and perispomeni and ypogegrammeni
    0x1F01,  // letter alpha with dasia
    0x1F87,  // -> letter alpha with dasia and perispomeni and ypogegrammeni
    0x1F08,  // capital alpha with psili
    0x1F8E,  // -> capital alpha with psili and perispomeni and prosgegrammeni
    0x1F09,  // capital alpha with dasia
    0x1F8F,  // -> capital alpha with dasia and perispomeni and prosgegrammeni
    0x1F20,  // letter eta with psili
    0x1F96,  // -> letter eta with psili and perispomeni and ypogegrammeni
    0x1F21,  // letter eta with dasia
    0x1F97,  // -> letter eta with dasia and perispomeni and ypogegrammeni
    0x1F28,  // capital eta with psili
    0x1F9E,  // -> capital eta with psili and perispomeni and prosgegrammeni
    0x1F29,  // capital eta with dasia
    0x1F9F,  // -> capital eta with dasia and perispomeni and prosgegrammeni
    0x1F60,  // letter omega with psili
    0x1FA6,  // -> letter omega with psili and perispomeni and ypogegrammeni
    0x1F61,  // letter omega with dasia
    0x1FA7,  // -> letter omega with dasia and perispomeni and ypogegrammeni
    0x1F68,  // capital omega with psili
    0x1FAE,  // -> capital omega with psili and perispomeni and prosgegrammeni
    0x1F69,  // capital omega with dasia
    0x1FAF,  // -> capital omega with dasia and perispomeni and prosgegrammeni
    //   internal dead_key table
    0x0002,          // number of entries
    0x0313,  // combining comma above
    0x21A4,
    0x0314,  // combining reversed comma above
    0x21B4,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2184:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     Dead<combining tilde>
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8F,  // -> capital alpha with dasia and perispomeni and prosgegrammeni
    0x0397,  // capital eta
    0x1F9F,  // -> capital eta with dasia and perispomeni and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAF,  // -> capital omega with dasia and perispomeni and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F87,  // -> letter alpha with dasia and perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1F97,  // -> letter eta with dasia and perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA7,  // -> letter omega with dasia and perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2194:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     Dead<combining tilde>
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8E,  // -> capital alpha with psili and perispomeni and prosgegrammeni
    0x0397,  // capital eta
    0x1F9E,  // -> capital eta with psili and perispomeni and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAE,  // -> capital omega with psili and perispomeni and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F86,  // -> letter alpha with psili and perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1F96,  // -> letter eta with psili and perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA6,  // -> letter omega with psili and perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x21A4:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     Dead<combining tilde>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8E,  // -> capital alpha with psili and perispomeni and prosgegrammeni
    0x0397,  // capital eta
    0x1F9E,  // -> capital eta with psili and perispomeni and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAE,  // -> capital omega with psili and perispomeni and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F86,  // -> letter alpha with psili and perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1F96,  // -> letter eta with psili and perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA6,  // -> letter omega with psili and perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x21B4:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     Dead<combining tilde>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0005,          // number of entries
    0x0391,  // capital alpha
    0x1F8F,  // -> capital alpha with dasia and perispomeni and prosgegrammeni
    0x0397,  // capital eta
    0x1F9F,  // -> capital eta with dasia and perispomeni and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAF,  // -> capital omega with dasia and perispomeni and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F87,  // -> letter alpha with dasia and perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1F97,  // -> letter eta with dasia and perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x21C2:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F88,  // -> capital alpha with psili and prosgegrammeni
    0x0397,  // capital eta
    0x1F98,  // -> capital eta with psili and prosgegrammeni
    0x03A9,  // capital omega
    0x1FA8,  // -> capital omega with psili and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F80,  // -> letter alpha with psili and ypogegrammeni
    0x03B7,  // letter eta
    0x1F90,  // -> letter eta with psili and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA0,  // -> letter omega with psili and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x21D2:
    //   prefix:
    //     Compose
    //     <greek small letter iota>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F89,  // -> capital alpha with dasia and prosgegrammeni
    0x0397,  // capital eta
    0x1F99,  // -> capital eta with dasia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FA9,  // -> capital omega with dasia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F81,  // -> letter alpha with dasia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F91,  // -> letter eta with dasia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA1,  // -> letter omega with dasia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x21E2:
    //   prefix:
    //     Compose
    //     <greek small letter omicron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0027,  // apostrophe
    0x03CC,  // -> letter omicron with tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x21E8:
    //   prefix:
    //     Compose
    //     <greek small letter upsilon>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0022,  // quotation mark
    0x03CB,  // -> letter upsilon with dialytika
    0x0027,  // apostrophe
    0x03CD,  // -> letter upsilon with tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x21F0:
    //   prefix:
    //     Compose
    //     <greek small letter omega>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0027,  // apostrophe
    0x03CE,  // -> letter omega with tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x21F6:
    //   prefix:
    //     Compose
    //     <cyrillic capital letter ie>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x003D,  // equals sign
    0x20AC,  // -> euro sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x21FC:
    //   prefix:
    //     Compose
    //     <cyrillic capital letter en>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x041E,  // cyrillic capital o
    0x2116,  // -> numero sign
    0x043E,  // cyrillic small o
    0x2116,  // -> numero sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2204:
    //   prefix:
    //     Compose
    //     <cyrillic capital letter es>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x003D,  // equals sign
    0x20AC,  // -> euro sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x220A:
    //   prefix:
    //     Compose
    //     <cyrillic small letter pe>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0430,  // cyrillic small a
    0x00A7,  // -> section sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2210:
    //   prefix:
    //     Compose
    //     <hebrew point hiriq>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x05D9,  // hebrew yod
    0xFB1D,  // -> hebrew yod with hiriq
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2216:
    //   prefix:
    //     Compose
    //     <hebrew point patah>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x05D0,  // hebrew alef
    0xFB2E,  // -> hebrew alef with patah
    0x0652,  // arabic sukun
    0xFB1F,  // -> hebrew ligature yiddish yod yod patah
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x221E:
    //   prefix:
    //     Compose
    //     <hebrew point qamats>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x05D0,  // hebrew alef
    0xFB2F,  // -> hebrew alef with qamats
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2224:
    //   prefix:
    //     Compose
    //     <hebrew point holam>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x05D5,  // hebrew vav
    0xFB4B,  // -> hebrew vav with holam
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x222A:
    //   prefix:
    //     Compose
    //     <hebrew point dagesh or mapiq>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0016,          // number of entries
    0x05D0,  // hebrew alef
    0xFB30,  // -> hebrew alef with mapiq
    0x05D1,  // hebrew bet
    0xFB31,  // -> hebrew bet with dagesh
    0x05D2,  // hebrew gimel
    0xFB32,  // -> hebrew gimel with dagesh
    0x05D3,  // hebrew dalet
    0xFB33,  // -> hebrew dalet with dagesh
    0x05D4,  // hebrew he
    0xFB34,  // -> hebrew he with mapiq
    0x05D5,  // hebrew vav
    0xFB35,  // -> hebrew vav with dagesh
    0x05D6,  // hebrew zayin
    0xFB36,  // -> hebrew zayin with dagesh
    0x05D8,  // hebrew tet
    0xFB38,  // -> hebrew tet with dagesh
    0x05D9,  // hebrew yod
    0xFB39,  // -> hebrew yod with dagesh
    0x05DA,  // hebrew final kaf
    0xFB3A,  // -> hebrew final kaf with dagesh
    0x05DB,  // hebrew kaf
    0xFB3B,  // -> hebrew kaf with dagesh
    0x05DC,  // hebrew lamed
    0xFB3C,  // -> hebrew lamed with dagesh
    0x05DE,  // hebrew mem
    0xFB3E,  // -> hebrew mem with dagesh
    0x05E0,  // hebrew nun
    0xFB40,  // -> hebrew nun with dagesh
    0x05E1,  // hebrew samekh
    0xFB41,  // -> hebrew samekh with dagesh
    0x05E3,  // hebrew final pe
    0xFB43,  // -> hebrew final pe with dagesh
    0x05E4,  // hebrew pe
    0xFB44,  // -> hebrew pe with dagesh
    0x05E6,  // hebrew tsadi
    0xFB46,  // -> hebrew tsadi with dagesh
    0x05E7,  // hebrew qof
    0xFB47,  // -> hebrew qof with dagesh
    0x05E8,  // hebrew resh
    0xFB48,  // -> hebrew resh with dagesh
    0x05E9,  // hebrew shin
    0xFB49,  // -> hebrew shin with dagesh
    0x05EA,  // hebrew tav
    0xFB4A,  // -> hebrew tav with dagesh
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x225A:
    //   prefix:
    //     Compose
    //     <arabic question mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x05D1,  // hebrew bet
    0xFB4C,  // -> hebrew bet with rafe
    0x05DB,  // hebrew kaf
    0xFB4D,  // -> hebrew kaf with rafe
    0x05E4,  // hebrew pe
    0xFB4E,  // -> hebrew pe with rafe
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2264:
    //   prefix:
    //     Compose
    //     <arabic letter hamza>
    //   internal character table
    0x0001,          // number of entries
    0x05BC,  // hebrew point dagesh or mapiq
    0x226E,
    //   leaf character table
    0x0002,          // number of entries
    0x05E9,  // hebrew shin
    0xFB2A,  // -> hebrew shin with shin dot
    0xFB49,  // hebrew shin with dagesh
    0xFB2C,  // -> hebrew shin with dagesh and shin dot
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x226E:
    //   prefix:
    //     Compose
    //     <arabic letter hamza>
    //     <hebrew point dagesh or mapiq>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x05E9,  // hebrew shin
    0xFB2C,  // -> hebrew shin with dagesh and shin dot
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2274:
    //   prefix:
    //     Compose
    //     <arabic letter alef with madda above>
    //   internal character table
    0x0001,          // number of entries
    0x05BC,  // hebrew point dagesh or mapiq
    0x227E,
    //   leaf character table
    0x0002,          // number of entries
    0x05E9,  // hebrew shin
    0xFB2B,  // -> hebrew shin with sin dot
    0xFB49,  // hebrew shin with dagesh
    0xFB2D,  // -> hebrew shin with dagesh and sin dot
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x227E:
    //   prefix:
    //     Compose
    //     <arabic letter alef with madda above>
    //     <hebrew point dagesh or mapiq>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x05E9,  // hebrew shin
    0xFB2D,  // -> hebrew shin with dagesh and sin dot
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2284:
    //   prefix:
    //     Compose
    //     <arabic maddah above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0627,  // arabic alef
    0x0622,  // -> arabic alef with madda above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x228A:
    //   prefix:
    //     Compose
    //     <arabic hamza above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0430,  // cyrillic small a
    0x06C2,  // -> arabic heh goal with hamza above
    0x0440,  // cyrillic small er
    0x06D3,  // -> arabic yeh barree with hamza above
    0x0443,  // cyrillic small u
    0x06C0,  // -> arabic heh with yeh above
    0x0627,  // arabic alef
    0x0623,  // -> arabic alef with hamza above
    0x0648,  // arabic waw
    0x0624,  // -> arabic waw with hamza above
    0x064A,  // arabic yeh
    0x0626,  // -> arabic yeh with hamza above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x229A:
    //   prefix:
    //     Compose
    //     <arabic hamza below>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0627,  // arabic alef
    0x0625,  // -> arabic alef with hamza below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x22A0:
    //   prefix:
    //     Compose
    //     <devanagari sign nukta>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000B,          // number of entries
    0x0915,  // devanagari ka
    0x0958,  // -> devanagari qa
    0x0916,  // devanagari kha
    0x0959,  // -> devanagari khha
    0x0917,  // devanagari ga
    0x095A,  // -> devanagari ghha
    0x091C,  // devanagari ja
    0x095B,  // -> devanagari za
    0x0921,  // devanagari dda
    0x095C,  // -> devanagari dddha
    0x0922,  // devanagari ddha
    0x095D,  // -> devanagari rha
    0x0928,  // devanagari na
    0x0929,  // -> devanagari nnna
    0x092B,  // devanagari pha
    0x095E,  // -> devanagari fa
    0x092F,  // devanagari ya
    0x095F,  // -> devanagari yya
    0x0930,  // devanagari ra
    0x0931,  // -> devanagari rra
    0x0933,  // devanagari lla
    0x0934,  // -> devanagari llla
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x22BA:
    //   prefix:
    //     Compose
    //     <bengali sign nukta>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x09A1,  // bengali dda
    0x09DC,  // -> bengali rra
    0x09A2,  // bengali ddha
    0x09DD,  // -> bengali rha
    0x09AF,  // bengali ya
    0x09DF,  // -> bengali yya
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x22C4:
    //   prefix:
    //     Compose
    //     <bengali vowel sign e>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x09BE,  // bengali vowel sign aa
    0x09CB,  // -> bengali vowel sign o
    0x09D7,  // bengali au length mark
    0x09CC,  // -> bengali vowel sign au
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x22CC:
    //   prefix:
    //     Compose
    //     <gurmukhi sign nukta>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0A16,  // gurmukhi kha
    0x0A59,  // -> gurmukhi khha
    0x0A17,  // gurmukhi ga
    0x0A5A,  // -> gurmukhi ghha
    0x0A1C,  // gurmukhi ja
    0x0A5B,  // -> gurmukhi za
    0x0A2B,  // gurmukhi pha
    0x0A5E,  // -> gurmukhi fa
    0x0A32,  // gurmukhi la
    0x0A33,  // -> gurmukhi lla
    0x0A38,  // gurmukhi sa
    0x0A36,  // -> gurmukhi sha
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x22DC:
    //   prefix:
    //     Compose
    //     <oriya sign nukta>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0B21,  // oriya dda
    0x0B5C,  // -> oriya rra
    0x0B22,  // oriya ddha
    0x0B5D,  // -> oriya rha
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x22E4:
    //   prefix:
    //     Compose
    //     <oriya vowel sign e>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x0B3E,  // oriya vowel sign aa
    0x0B4B,  // -> oriya vowel sign o
    0x0B56,  // oriya ai length mark
    0x0B48,  // -> oriya vowel sign ai
    0x0B57,  // oriya au length mark
    0x0B4C,  // -> oriya vowel sign au
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x22EE:
    //   prefix:
    //     Compose
    //     <tamil vowel sign ee>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0BBE,  // tamil vowel sign aa
    0x0BCB,  // -> tamil vowel sign oo
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x22F4:
    //   prefix:
    //     Compose
    //     <tamil au length mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0B92,  // tamil o
    0x0B94,  // -> tamil au
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x22FA:
    //   prefix:
    //     Compose
    //     <telugu vowel sign e>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0C56,  // telugu ai length mark
    0x0C48,  // -> telugu vowel sign ai
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2300:
    //   prefix:
    //     Compose
    //     <kannada vowel sign i>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0CD5,  // kannada length mark
    0x0CC0,  // -> kannada vowel sign ii
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2306:
    //   prefix:
    //     Compose
    //     <kannada vowel sign e>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x0CC2,  // kannada vowel sign uu
    0x0CCA,  // -> kannada vowel sign o
    0x0CD5,  // kannada length mark
    0x0CC7,  // -> kannada vowel sign ee
    0x0CD6,  // kannada ai length mark
    0x0CC8,  // -> kannada vowel sign ai
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2310:
    //   prefix:
    //     Compose
    //     <kannada vowel sign o>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0CD5,  // kannada length mark
    0x0CCB,  // -> kannada vowel sign oo
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2316:
    //   prefix:
    //     Compose
    //     <malayalam vowel sign e>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0D3E,  // malayalam vowel sign aa
    0x0D4A,  // -> malayalam vowel sign o
    0x0D57,  // malayalam au length mark
    0x0D4C,  // -> malayalam vowel sign au
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x231E:
    //   prefix:
    //     Compose
    //     <malayalam vowel sign ee>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0D3E,  // malayalam vowel sign aa
    0x0D4B,  // -> malayalam vowel sign oo
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2324:
    //   prefix:
    //     Compose
    //     <sinhala vowel sign kombuva haa aela-pilla>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0E2A,  // thai character so sua
    0x0DDD,  // -> sinhala vowel sign kombuva haa diga aela-pilla
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x232A:
    //   prefix:
    //     Compose
    //     <thai character sara uu>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x0E2A,  // thai character so sua
    0x0DDA,  // -> sinhala vowel sign diga kombuva
    0x0E2F,  // thai character paiyannoi
    0x0DDC,  // -> sinhala vowel sign kombuva haa aela-pilla
    0x0E3F,  // thai currency symbol baht
    0x0DDE,  // -> sinhala vowel sign kombuva haa gayanukitta
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2334:
    //   prefix:
    //     Compose
    //     <tibetan vowel sign aa>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x0F72,  // tibetan vowel sign i
    0x0F73,  // -> tibetan vowel sign ii
    0x0F74,  // tibetan vowel sign u
    0x0F75,  // -> tibetan vowel sign uu
    0x0F80,  // tibetan vowel sign reversed i
    0x0F81,  // -> tibetan vowel sign reversed ii
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x233E:
    //   prefix:
    //     Compose
    //     <tibetan subjoined letter ka>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0FB5,  // tibetan subjoined ssa
    0x0FB9,  // -> tibetan subjoined kssa
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2344:
    //   prefix:
    //     Compose
    //     <tibetan subjoined letter ga>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0FB7,  // tibetan subjoined ha
    0x0F93,  // -> tibetan subjoined gha
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x234A:
    //   prefix:
    //     Compose
    //     <tibetan subjoined letter dda>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0FB7,  // tibetan subjoined ha
    0x0F9D,  // -> tibetan subjoined ddha
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2350:
    //   prefix:
    //     Compose
    //     <tibetan subjoined letter da>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0FB7,  // tibetan subjoined ha
    0x0FA2,  // -> tibetan subjoined dha
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2356:
    //   prefix:
    //     Compose
    //     <tibetan subjoined letter ba>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0FB7,  // tibetan subjoined ha
    0x0FA7,  // -> tibetan subjoined bha
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x235C:
    //   prefix:
    //     Compose
    //     <tibetan subjoined letter dza>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0FB7,  // tibetan subjoined ha
    0x0FAC,  // -> tibetan subjoined dzha
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2362:
    //   prefix:
    //     Compose
    //     <tibetan subjoined letter ra>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0F80,  // tibetan vowel sign reversed i
    0x0F76,  // -> tibetan vowel sign vocalic r
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2368:
    //   prefix:
    //     Compose
    //     <tibetan subjoined letter la>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0F80,  // tibetan vowel sign reversed i
    0x0F78,  // -> tibetan vowel sign vocalic l
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x236E:
    //   prefix:
    //     Compose
    //     <tibetan subjoined letter ssa>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0F40,  // tibetan ka
    0x0F69,  // -> tibetan kssa
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2374:
    //   prefix:
    //     Compose
    //     <tibetan subjoined letter ha>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0005,          // number of entries
    0x0F42,  // tibetan ga
    0x0F43,  // -> tibetan gha
    0x0F4C,  // tibetan dda
    0x0F4D,  // -> tibetan ddha
    0x0F51,  // tibetan da
    0x0F52,  // -> tibetan dha
    0x0F56,  // tibetan ba
    0x0F57,  // -> tibetan bha
    0x0F5B,  // tibetan dza
    0x0F5C,  // -> tibetan dzha
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2382:
    //   prefix:
    //     Compose
    //     <myanmar vowel sign ii>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x1025,  // myanmar u
    0x1026,  // -> myanmar uu
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2388:
    //   prefix:
    //     Compose
    //     <hangul choseong kiyeok>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x1100,  // hangul choseong kiyeok
    0x1101,  // -> hangul choseong ssangkiyeok
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x238E:
    //   prefix:
    //     Compose
    //     <hangul choseong nieun>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x1100,  // hangul choseong kiyeok
    0x1113,  // -> hangul choseong nieun-kiyeok
    0x1102,  // hangul choseong nieun
    0x1114,  // -> hangul choseong ssangnieun
    0x1103,  // hangul choseong tikeut
    0x1115,  // -> hangul choseong nieun-tikeut
    0x1107,  // hangul choseong pieup
    0x1116,  // -> hangul choseong nieun-pieup
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x239A:
    //   prefix:
    //     Compose
    //     <hangul choseong tikeut>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x1100,  // hangul choseong kiyeok
    0x1117,  // -> hangul choseong tikeut-kiyeok
    0x1103,  // hangul choseong tikeut
    0x1104,  // -> hangul choseong ssangtikeut
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x23A2:
    //   prefix:
    //     Compose
    //     <hangul choseong rieul>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x1102,  // hangul choseong nieun
    0x1118,  // -> hangul choseong rieul-nieun
    0x1105,  // hangul choseong rieul
    0x1119,  // -> hangul choseong ssangrieul
    0x110B,  // hangul choseong ieung
    0x111B,  // -> hangul choseong kapyeounrieul
    0x1112,  // hangul choseong hieuh
    0x111A,  // -> hangul choseong rieul-hieuh
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x23AE:
    //   prefix:
    //     Compose
    //     <hangul choseong mieum>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x1107,  // hangul choseong pieup
    0x111C,  // -> hangul choseong mieum-pieup
    0x110B,  // hangul choseong ieung
    0x111D,  // -> hangul choseong kapyeounmieum
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x23B6:
    //   prefix:
    //     Compose
    //     <hangul choseong pieup>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0010,          // number of entries
    0x1100,  // hangul choseong kiyeok
    0x111E,  // -> hangul choseong pieup-kiyeok
    0x1102,  // hangul choseong nieun
    0x111F,  // -> hangul choseong pieup-nieun
    0x1103,  // hangul choseong tikeut
    0x1120,  // -> hangul choseong pieup-tikeut
    0x1107,  // hangul choseong pieup
    0x1108,  // -> hangul choseong ssangpieup
    0x1109,  // hangul choseong sios
    0x1121,  // -> hangul choseong pieup-sios
    0x110A,  // hangul choseong ssangsios
    0x1125,  // -> hangul choseong pieup-ssangsios
    0x110B,  // hangul choseong ieung
    0x112B,  // -> hangul choseong kapyeounpieup
    0x110C,  // hangul choseong cieuc
    0x1127,  // -> hangul choseong pieup-cieuc
    0x110E,  // hangul choseong chieuch
    0x1128,  // -> hangul choseong pieup-chieuch
    0x1110,  // hangul choseong thieuth
    0x1129,  // -> hangul choseong pieup-thieuth
    0x1111,  // hangul choseong phieuph
    0x112A,  // -> hangul choseong pieup-phieuph
    0x112B,  // hangul choseong kapyeounpieup
    0x112C,  // -> hangul choseong kapyeounssangpieup
    0x112D,  // hangul choseong sios-kiyeok
    0x1122,  // -> hangul choseong pieup-sios-kiyeok
    0x112F,  // hangul choseong sios-tikeut
    0x1123,  // -> hangul choseong pieup-sios-tikeut
    0x1132,  // hangul choseong sios-pieup
    0x1124,  // -> hangul choseong pieup-sios-pieup
    0x1136,  // hangul choseong sios-cieuc
    0x1126,  // -> hangul choseong pieup-sios-cieuc
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x23DA:
    //   prefix:
    //     Compose
    //     <hangul choseong ssangpieup>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x110B,  // hangul choseong ieung
    0x112C,  // -> hangul choseong kapyeounssangpieup
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x23E0:
    //   prefix:
    //     Compose
    //     <hangul choseong sios>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0010,          // number of entries
    0x1100,  // hangul choseong kiyeok
    0x112D,  // -> hangul choseong sios-kiyeok
    0x1102,  // hangul choseong nieun
    0x112E,  // -> hangul choseong sios-nieun
    0x1103,  // hangul choseong tikeut
    0x112F,  // -> hangul choseong sios-tikeut
    0x1105,  // hangul choseong rieul
    0x1130,  // -> hangul choseong sios-rieul
    0x1106,  // hangul choseong mieum
    0x1131,  // -> hangul choseong sios-mieum
    0x1107,  // hangul choseong pieup
    0x1132,  // -> hangul choseong sios-pieup
    0x1109,  // hangul choseong sios
    0x110A,  // -> hangul choseong ssangsios
    0x110A,  // hangul choseong ssangsios
    0x1134,  // -> hangul choseong sios-ssangsios
    0x110B,  // hangul choseong ieung
    0x1135,  // -> hangul choseong sios-ieung
    0x110C,  // hangul choseong cieuc
    0x1136,  // -> hangul choseong sios-cieuc
    0x110E,  // hangul choseong chieuch
    0x1137,  // -> hangul choseong sios-chieuch
    0x110F,  // hangul choseong khieukh
    0x1138,  // -> hangul choseong sios-khieukh
    0x1110,  // hangul choseong thieuth
    0x1139,  // -> hangul choseong sios-thieuth
    0x1111,  // hangul choseong phieuph
    0x113A,  // -> hangul choseong sios-phieuph
    0x1112,  // hangul choseong hieuh
    0x113B,  // -> hangul choseong sios-hieuh
    0x111E,  // hangul choseong pieup-kiyeok
    0x1133,  // -> hangul choseong sios-pieup-kiyeok
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2404:
    //   prefix:
    //     Compose
    //     <hangul choseong ssangsios>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x1109,  // hangul choseong sios
    0x1134,  // -> hangul choseong sios-ssangsios
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x240A:
    //   prefix:
    //     Compose
    //     <hangul choseong ieung>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000B,          // number of entries
    0x1100,  // hangul choseong kiyeok
    0x1141,  // -> hangul choseong ieung-kiyeok
    0x1103,  // hangul choseong tikeut
    0x1142,  // -> hangul choseong ieung-tikeut
    0x1106,  // hangul choseong mieum
    0x1143,  // -> hangul choseong ieung-mieum
    0x1107,  // hangul choseong pieup
    0x1144,  // -> hangul choseong ieung-pieup
    0x1109,  // hangul choseong sios
    0x1145,  // -> hangul choseong ieung-sios
    0x110B,  // hangul choseong ieung
    0x1147,  // -> hangul choseong ssangieung
    0x110C,  // hangul choseong cieuc
    0x1148,  // -> hangul choseong ieung-cieuc
    0x110E,  // hangul choseong chieuch
    0x1149,  // -> hangul choseong ieung-chieuch
    0x1110,  // hangul choseong thieuth
    0x114A,  // -> hangul choseong ieung-thieuth
    0x1111,  // hangul choseong phieuph
    0x114B,  // -> hangul choseong ieung-phieuph
    0x1140,  // hangul choseong pansios
    0x1146,  // -> hangul choseong ieung-pansios
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2424:
    //   prefix:
    //     Compose
    //     <hangul choseong cieuc>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x110B,  // hangul choseong ieung
    0x114D,  // -> hangul choseong cieuc-ieung
    0x110C,  // hangul choseong cieuc
    0x110D,  // -> hangul choseong ssangcieuc
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x242C:
    //   prefix:
    //     Compose
    //     <hangul choseong chieuch>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x110F,  // hangul choseong khieukh
    0x1152,  // -> hangul choseong chieuch-khieukh
    0x1112,  // hangul choseong hieuh
    0x1153,  // -> hangul choseong chieuch-hieuh
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2434:
    //   prefix:
    //     Compose
    //     <hangul choseong phieuph>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x1107,  // hangul choseong pieup
    0x1156,  // -> hangul choseong phieuph-pieup
    0x110B,  // hangul choseong ieung
    0x1157,  // -> hangul choseong kapyeounphieuph
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x243C:
    //   prefix:
    //     Compose
    //     <hangul choseong hieuh>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x1112,  // hangul choseong hieuh
    0x1158,  // -> hangul choseong ssanghieuh
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2442:
    //   prefix:
    //     Compose
    //     <hangul choseong pieup-sios>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0005,          // number of entries
    0x1100,  // hangul choseong kiyeok
    0x1122,  // -> hangul choseong pieup-sios-kiyeok
    0x1103,  // hangul choseong tikeut
    0x1123,  // -> hangul choseong pieup-sios-tikeut
    0x1107,  // hangul choseong pieup
    0x1124,  // -> hangul choseong pieup-sios-pieup
    0x1109,  // hangul choseong sios
    0x1125,  // -> hangul choseong pieup-ssangsios
    0x110C,  // hangul choseong cieuc
    0x1126,  // -> hangul choseong pieup-sios-cieuc
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2450:
    //   prefix:
    //     Compose
    //     <hangul choseong sios-pieup>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x1100,  // hangul choseong kiyeok
    0x1133,  // -> hangul choseong sios-pieup-kiyeok
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2456:
    //   prefix:
    //     Compose
    //     <hangul choseong chitueumsios>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x113C,  // hangul choseong chitueumsios
    0x113D,  // -> hangul choseong chitueumssangsios
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x245C:
    //   prefix:
    //     Compose
    //     <hangul choseong ceongchieumsios>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x113E,  // hangul choseong ceongchieumsios
    0x113F,  // -> hangul choseong ceongchieumssangsios
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2462:
    //   prefix:
    //     Compose
    //     <hangul choseong chitueumcieuc>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x114E,  // hangul choseong chitueumcieuc
    0x114F,  // -> hangul choseong chitueumssangcieuc
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2468:
    //   prefix:
    //     Compose
    //     <hangul choseong ceongchieumcieuc>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x1150,  // hangul choseong ceongchieumcieuc
    0x1151,  // -> hangul choseong ceongchieumssangcieuc
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x246E:
    //   prefix:
    //     Compose
    //     <hangul jungseong a>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x1169,  // hangul jungseong o
    0x1176,  // -> hangul jungseong a-o
    0x116E,  // hangul jungseong u
    0x1177,  // -> hangul jungseong a-u
    0x1175,  // hangul jungseong i
    0x1162,  // -> hangul jungseong ae
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2478:
    //   prefix:
    //     Compose
    //     <hangul jungseong ya>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x1169,  // hangul jungseong o
    0x1178,  // -> hangul jungseong ya-o
    0x116D,  // hangul jungseong yo
    0x1179,  // -> hangul jungseong ya-yo
    0x1175,  // hangul jungseong i
    0x1164,  // -> hangul jungseong yae
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2482:
    //   prefix:
    //     Compose
    //     <hangul jungseong eo>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x1169,  // hangul jungseong o
    0x117A,  // -> hangul jungseong eo-o
    0x116E,  // hangul jungseong u
    0x117B,  // -> hangul jungseong eo-u
    0x1173,  // hangul jungseong eu
    0x117C,  // -> hangul jungseong eo-eu
    0x1175,  // hangul jungseong i
    0x1166,  // -> hangul jungseong e
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x248E:
    //   prefix:
    //     Compose
    //     <hangul jungseong yeo>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x1169,  // hangul jungseong o
    0x117D,  // -> hangul jungseong yeo-o
    0x116E,  // hangul jungseong u
    0x117E,  // -> hangul jungseong yeo-u
    0x1175,  // hangul jungseong i
    0x1168,  // -> hangul jungseong ye
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2498:
    //   prefix:
    //     Compose
    //     <hangul jungseong o>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0008,          // number of entries
    0x1161,  // hangul jungseong a
    0x116A,  // -> hangul jungseong wa
    0x1162,  // hangul jungseong ae
    0x116B,  // -> hangul jungseong wae
    0x1165,  // hangul jungseong eo
    0x117F,  // -> hangul jungseong o-eo
    0x1166,  // hangul jungseong e
    0x1180,  // -> hangul jungseong o-e
    0x1168,  // hangul jungseong ye
    0x1181,  // -> hangul jungseong o-ye
    0x1169,  // hangul jungseong o
    0x1182,  // -> hangul jungseong o-o
    0x116E,  // hangul jungseong u
    0x1183,  // -> hangul jungseong o-u
    0x1175,  // hangul jungseong i
    0x116C,  // -> hangul jungseong oe
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x24AC:
    //   prefix:
    //     Compose
    //     <hangul jungseong wa>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x1175,  // hangul jungseong i
    0x116B,  // -> hangul jungseong wae
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x24B2:
    //   prefix:
    //     Compose
    //     <hangul jungseong yo>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0005,          // number of entries
    0x1163,  // hangul jungseong ya
    0x1184,  // -> hangul jungseong yo-ya
    0x1164,  // hangul jungseong yae
    0x1185,  // -> hangul jungseong yo-yae
    0x1167,  // hangul jungseong yeo
    0x1186,  // -> hangul jungseong yo-yeo
    0x1169,  // hangul jungseong o
    0x1187,  // -> hangul jungseong yo-o
    0x1175,  // hangul jungseong i
    0x1188,  // -> hangul jungseong yo-i
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x24C0:
    //   prefix:
    //     Compose
    //     <hangul jungseong u>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0008,          // number of entries
    0x1161,  // hangul jungseong a
    0x1189,  // -> hangul jungseong u-a
    0x1162,  // hangul jungseong ae
    0x118A,  // -> hangul jungseong u-ae
    0x1165,  // hangul jungseong eo
    0x116F,  // -> hangul jungseong weo
    0x1166,  // hangul jungseong e
    0x1170,  // -> hangul jungseong we
    0x1168,  // hangul jungseong ye
    0x118C,  // -> hangul jungseong u-ye
    0x116E,  // hangul jungseong u
    0x118D,  // -> hangul jungseong u-u
    0x1175,  // hangul jungseong i
    0x1171,  // -> hangul jungseong wi
    0x117C,  // hangul jungseong eo-eu
    0x118B,  // -> hangul jungseong u-eo-eu
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x24D4:
    //   prefix:
    //     Compose
    //     <hangul jungseong weo>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x1173,  // hangul jungseong eu
    0x118B,  // -> hangul jungseong u-eo-eu
    0x1175,  // hangul jungseong i
    0x1170,  // -> hangul jungseong we
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x24DC:
    //   prefix:
    //     Compose
    //     <hangul jungseong yu>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0007,          // number of entries
    0x1161,  // hangul jungseong a
    0x118E,  // -> hangul jungseong yu-a
    0x1165,  // hangul jungseong eo
    0x118F,  // -> hangul jungseong yu-eo
    0x1166,  // hangul jungseong e
    0x1190,  // -> hangul jungseong yu-e
    0x1167,  // hangul jungseong yeo
    0x1191,  // -> hangul jungseong yu-yeo
    0x1168,  // hangul jungseong ye
    0x1192,  // -> hangul jungseong yu-ye
    0x116E,  // hangul jungseong u
    0x1193,  // -> hangul jungseong yu-u
    0x1175,  // hangul jungseong i
    0x1194,  // -> hangul jungseong yu-i
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x24EE:
    //   prefix:
    //     Compose
    //     <hangul jungseong eu>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x116E,  // hangul jungseong u
    0x1195,  // -> hangul jungseong eu-u
    0x1173,  // hangul jungseong eu
    0x1196,  // -> hangul jungseong eu-eu
    0x1175,  // hangul jungseong i
    0x1174,  // -> hangul jungseong yi
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x24F8:
    //   prefix:
    //     Compose
    //     <hangul jungseong yi>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x116E,  // hangul jungseong u
    0x1197,  // -> hangul jungseong yi-u
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x24FE:
    //   prefix:
    //     Compose
    //     <hangul jungseong i>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x1161,  // hangul jungseong a
    0x1198,  // -> hangul jungseong i-a
    0x1163,  // hangul jungseong ya
    0x1199,  // -> hangul jungseong i-ya
    0x1169,  // hangul jungseong o
    0x119A,  // -> hangul jungseong i-o
    0x116E,  // hangul jungseong u
    0x119B,  // -> hangul jungseong i-u
    0x1173,  // hangul jungseong eu
    0x119C,  // -> hangul jungseong i-eu
    0x119E,  // hangul jungseong araea
    0x119D,  // -> hangul jungseong i-araea
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x250E:
    //   prefix:
    //     Compose
    //     <hangul jungseong araea>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x1165,  // hangul jungseong eo
    0x119F,  // -> hangul jungseong araea-eo
    0x116E,  // hangul jungseong u
    0x11A0,  // -> hangul jungseong araea-u
    0x1175,  // hangul jungseong i
    0x11A1,  // -> hangul jungseong araea-i
    0x119E,  // hangul jungseong araea
    0x11A2,  // -> hangul jungseong ssangaraea
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x251A:
    //   prefix:
    //     Compose
    //     <hangul jongseong kiyeok>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x11A8,  // hangul jongseong kiyeok
    0x11A9,  // -> hangul jongseong ssangkiyeok
    0x11AF,  // hangul jongseong rieul
    0x11C3,  // -> hangul jongseong kiyeok-rieul
    0x11BA,  // hangul jongseong sios
    0x11AA,  // -> hangul jongseong kiyeok-sios
    0x11E7,  // hangul jongseong sios-kiyeok
    0x11C4,  // -> hangul jongseong kiyeok-sios-kiyeok
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2526:
    //   prefix:
    //     Compose
    //     <hangul jongseong kiyeok-sios>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x11A8,  // hangul jongseong kiyeok
    0x11C4,  // -> hangul jongseong kiyeok-sios-kiyeok
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x252C:
    //   prefix:
    //     Compose
    //     <hangul jongseong nieun>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0007,          // number of entries
    0x11A8,  // hangul jongseong kiyeok
    0x11C5,  // -> hangul jongseong nieun-kiyeok
    0x11AE,  // hangul jongseong tikeut
    0x11C6,  // -> hangul jongseong nieun-tikeut
    0x11BA,  // hangul jongseong sios
    0x11C7,  // -> hangul jongseong nieun-sios
    0x11BD,  // hangul jongseong cieuc
    0x11AC,  // -> hangul jongseong nieun-cieuc
    0x11C0,  // hangul jongseong thieuth
    0x11C9,  // -> hangul jongseong nieun-thieuth
    0x11C2,  // hangul jongseong hieuh
    0x11AD,  // -> hangul jongseong nieun-hieuh
    0x11EB,  // hangul jongseong pansios
    0x11C8,  // -> hangul jongseong nieun-pansios
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x253E:
    //   prefix:
    //     Compose
    //     <hangul jongseong tikeut>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x11A8,  // hangul jongseong kiyeok
    0x11CA,  // -> hangul jongseong tikeut-kiyeok
    0x11AF,  // hangul jongseong rieul
    0x11CB,  // -> hangul jongseong tikeut-rieul
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2546:
    //   prefix:
    //     Compose
    //     <hangul jongseong rieul>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0014,          // number of entries
    0x11A8,  // hangul jongseong kiyeok
    0x11B0,  // -> hangul jongseong rieul-kiyeok
    0x11AA,  // hangul jongseong kiyeok-sios
    0x11CC,  // -> hangul jongseong rieul-kiyeok-sios
    0x11AB,  // hangul jongseong nieun
    0x11CD,  // -> hangul jongseong rieul-nieun
    0x11AE,  // hangul jongseong tikeut
    0x11CE,  // -> hangul jongseong rieul-tikeut
    0x11AF,  // hangul jongseong rieul
    0x11D0,  // -> hangul jongseong ssangrieul
    0x11B7,  // hangul jongseong mieum
    0x11B1,  // -> hangul jongseong rieul-mieum
    0x11B8,  // hangul jongseong pieup
    0x11B2,  // -> hangul jongseong rieul-pieup
    0x11B9,  // hangul jongseong pieup-sios
    0x11D3,  // -> hangul jongseong rieul-pieup-sios
    0x11BA,  // hangul jongseong sios
    0x11B3,  // -> hangul jongseong rieul-sios
    0x11BB,  // hangul jongseong ssangsios
    0x11D6,  // -> hangul jongseong rieul-ssangsios
    0x11BF,  // hangul jongseong khieukh
    0x11D8,  // -> hangul jongseong rieul-khieukh
    0x11C0,  // hangul jongseong thieuth
    0x11B4,  // -> hangul jongseong rieul-thieuth
    0x11C1,  // hangul jongseong phieuph
    0x11B5,  // -> hangul jongseong rieul-phieuph
    0x11C2,  // hangul jongseong hieuh
    0x11B6,  // -> hangul jongseong rieul-hieuh
    0x11DA,  // hangul jongseong mieum-kiyeok
    0x11D1,  // -> hangul jongseong rieul-mieum-kiyeok
    0x11DD,  // hangul jongseong mieum-sios
    0x11D2,  // -> hangul jongseong rieul-mieum-sios
    0x11E5,  // hangul jongseong pieup-hieuh
    0x11D4,  // -> hangul jongseong rieul-pieup-hieuh
    0x11E6,  // hangul jongseong kapyeounpieup
    0x11D5,  // -> hangul jongseong rieul-kapyeounpieup
    0x11EB,  // hangul jongseong pansios
    0x11D7,  // -> hangul jongseong rieul-pansios
    0x11F9,  // hangul jongseong yeorinhieuh
    0x11D9,  // -> hangul jongseong rieul-yeorinhieuh
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2572:
    //   prefix:
    //     Compose
    //     <hangul jongseong rieul-kiyeok>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x11BA,  // hangul jongseong sios
    0x11CC,  // -> hangul jongseong rieul-kiyeok-sios
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2578:
    //   prefix:
    //     Compose
    //     <hangul jongseong rieul-mieum>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x11A8,  // hangul jongseong kiyeok
    0x11D1,  // -> hangul jongseong rieul-mieum-kiyeok
    0x11BA,  // hangul jongseong sios
    0x11D2,  // -> hangul jongseong rieul-mieum-sios
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2580:
    //   prefix:
    //     Compose
    //     <hangul jongseong rieul-pieup>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0003,          // number of entries
    0x11BA,  // hangul jongseong sios
    0x11D3,  // -> hangul jongseong rieul-pieup-sios
    0x11BC,  // hangul jongseong ieung
    0x11D5,  // -> hangul jongseong rieul-kapyeounpieup
    0x11C2,  // hangul jongseong hieuh
    0x11D4,  // -> hangul jongseong rieul-pieup-hieuh
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x258A:
    //   prefix:
    //     Compose
    //     <hangul jongseong rieul-sios>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x11BA,  // hangul jongseong sios
    0x11D6,  // -> hangul jongseong rieul-ssangsios
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2590:
    //   prefix:
    //     Compose
    //     <hangul jongseong mieum>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0009,          // number of entries
    0x11A8,  // hangul jongseong kiyeok
    0x11DA,  // -> hangul jongseong mieum-kiyeok
    0x11AF,  // hangul jongseong rieul
    0x11DB,  // -> hangul jongseong mieum-rieul
    0x11B8,  // hangul jongseong pieup
    0x11DC,  // -> hangul jongseong mieum-pieup
    0x11BA,  // hangul jongseong sios
    0x11DD,  // -> hangul jongseong mieum-sios
    0x11BB,  // hangul jongseong ssangsios
    0x11DE,  // -> hangul jongseong mieum-ssangsios
    0x11BC,  // hangul jongseong ieung
    0x11E2,  // -> hangul jongseong kapyeounmieum
    0x11BE,  // hangul jongseong chieuch
    0x11E0,  // -> hangul jongseong mieum-chieuch
    0x11C2,  // hangul jongseong hieuh
    0x11E1,  // -> hangul jongseong mieum-hieuh
    0x11EB,  // hangul jongseong pansios
    0x11DF,  // -> hangul jongseong mieum-pansios
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x25A6:
    //   prefix:
    //     Compose
    //     <hangul jongseong pieup>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0005,          // number of entries
    0x11AF,  // hangul jongseong rieul
    0x11E3,  // -> hangul jongseong pieup-rieul
    0x11BA,  // hangul jongseong sios
    0x11B9,  // -> hangul jongseong pieup-sios
    0x11BC,  // hangul jongseong ieung
    0x11E6,  // -> hangul jongseong kapyeounpieup
    0x11C1,  // hangul jongseong phieuph
    0x11E4,  // -> hangul jongseong pieup-phieuph
    0x11C2,  // hangul jongseong hieuh
    0x11E5,  // -> hangul jongseong pieup-hieuh
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x25B4:
    //   prefix:
    //     Compose
    //     <hangul jongseong sios>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0005,          // number of entries
    0x11A8,  // hangul jongseong kiyeok
    0x11E7,  // -> hangul jongseong sios-kiyeok
    0x11AE,  // hangul jongseong tikeut
    0x11E8,  // -> hangul jongseong sios-tikeut
    0x11AF,  // hangul jongseong rieul
    0x11E9,  // -> hangul jongseong sios-rieul
    0x11B8,  // hangul jongseong pieup
    0x11EA,  // -> hangul jongseong sios-pieup
    0x11BA,  // hangul jongseong sios
    0x11BB,  // -> hangul jongseong ssangsios
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x25C2:
    //   prefix:
    //     Compose
    //     <hangul jongseong ieung>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x11A8,  // hangul jongseong kiyeok
    0x11EC,  // -> hangul jongseong ieung-kiyeok
    0x11A9,  // hangul jongseong ssangkiyeok
    0x11ED,  // -> hangul jongseong ieung-ssangkiyeok
    0x11BC,  // hangul jongseong ieung
    0x11EE,  // -> hangul jongseong ssangieung
    0x11BF,  // hangul jongseong khieukh
    0x11EF,  // -> hangul jongseong ieung-khieukh
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x25CE:
    //   prefix:
    //     Compose
    //     <hangul jongseong phieuph>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x11B8,  // hangul jongseong pieup
    0x11F3,  // -> hangul jongseong phieuph-pieup
    0x11BC,  // hangul jongseong ieung
    0x11F4,  // -> hangul jongseong kapyeounphieuph
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x25D6:
    //   prefix:
    //     Compose
    //     <hangul jongseong hieuh>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x11AB,  // hangul jongseong nieun
    0x11F5,  // -> hangul jongseong hieuh-nieun
    0x11AF,  // hangul jongseong rieul
    0x11F6,  // -> hangul jongseong hieuh-rieul
    0x11B7,  // hangul jongseong mieum
    0x11F7,  // -> hangul jongseong hieuh-mieum
    0x11B8,  // hangul jongseong pieup
    0x11F8,  // -> hangul jongseong hieuh-pieup
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x25E2:
    //   prefix:
    //     Compose
    //     <hangul jongseong rieul-tikeut>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x11C2,  // hangul jongseong hieuh
    0x11CF,  // -> hangul jongseong rieul-tikeut-hieuh
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x25E8:
    //   prefix:
    //     Compose
    //     <hangul jongseong mieum-sios>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x11BA,  // hangul jongseong sios
    0x11DE,  // -> hangul jongseong mieum-ssangsios
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x25EE:
    //   prefix:
    //     Compose
    //     <hangul jongseong ieung-kiyeok>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x11A8,  // hangul jongseong kiyeok
    0x11ED,  // -> hangul jongseong ieung-ssangkiyeok
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x25F4:
    //   prefix:
    //     Compose
    //     <hangul jongseong yesieung>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x11BA,  // hangul jongseong sios
    0x11F1,  // -> hangul jongseong yesieung-sios
    0x11EB,  // hangul jongseong pansios
    0x11F2,  // -> hangul jongseong yesieung-pansios
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x25FC:
    //   prefix:
    //     Compose
    //     <greek psili>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0027,  // apostrophe
    0x1FCE,  // -> psili and oxia
    0x0060,  // grave accent
    0x1FCD,  // -> psili and varia
    0x007E,  // tilde
    0x1FCF,  // -> psili and perispomeni
    0x00B4,  // acute accent
    0x1FCE,  // -> psili and oxia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0003,          // number of entries
    0x0300,  // combining grave accent
    0x1FCD,  // -> psili and varia
    0x0301,  // combining acute accent
    0x1FCE,  // -> psili and oxia
    0x0303,  // combining tilde
    0x1FCF,  // -> psili and perispomeni

    // offset 0x260E:
    //   prefix:
    //     Compose
    //     <greek dasia>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0027,  // apostrophe
    0x1FDE,  // -> dasia and oxia
    0x0060,  // grave accent
    0x1FDD,  // -> dasia and varia
    0x007E,  // tilde
    0x1FDF,  // -> dasia and perispomeni
    0x00B4,  // acute accent
    0x1FDE,  // -> dasia and oxia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0003,          // number of entries
    0x0300,  // combining grave accent
    0x1FDD,  // -> dasia and varia
    0x0301,  // combining acute accent
    0x1FDE,  // -> dasia and oxia
    0x0303,  // combining tilde
    0x1FDF,  // -> dasia and perispomeni

    // offset 0x2620:
    //   prefix:
    //     Compose
    //     <there exists>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2204,  // -> there does not exist
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2626:
    //   prefix:
    //     Compose
    //     <element of>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2209,  // -> not an element of
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x262C:
    //   prefix:
    //     Compose
    //     <contains as member>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x220C,  // -> does not contain as member
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2632:
    //   prefix:
    //     Compose
    //     <divides>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2224,  // -> does not divide
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2638:
    //   prefix:
    //     Compose
    //     <parallel to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2226,  // -> not parallel to
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x263E:
    //   prefix:
    //     Compose
    //     <tilde operator>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2247,  // -> neither approximately nor actually equal to
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2644:
    //   prefix:
    //     Compose
    //     <asymptotically equal to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2244,  // -> not asymptotically equal to
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x264A:
    //   prefix:
    //     Compose
    //     <almost equal to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2249,  // -> not almost equal to
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2650:
    //   prefix:
    //     Compose
    //     <equivalent to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x226D,  // -> not equivalent to
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2656:
    //   prefix:
    //     Compose
    //     <identical to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2262,  // -> not identical to
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x265C:
    //   prefix:
    //     Compose
    //     <less-than or equal to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2270,  // -> neither less-than nor equal to
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2662:
    //   prefix:
    //     Compose
    //     <greater-than or equal to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2271,  // -> neither greater-than nor equal to
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2668:
    //   prefix:
    //     Compose
    //     <less-than or equivalent to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2274,  // -> neither less-than nor equivalent to
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x266E:
    //   prefix:
    //     Compose
    //     <greater-than or equivalent to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2275,  // -> neither greater-than nor equivalent to
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2674:
    //   prefix:
    //     Compose
    //     <less-than or greater-than>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2278,  // -> neither less-than nor greater-than
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x267A:
    //   prefix:
    //     Compose
    //     <greater-than or less-than>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2279,  // -> neither greater-than nor less-than
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2680:
    //   prefix:
    //     Compose
    //     <precedes>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2280,  // -> does not precede
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2686:
    //   prefix:
    //     Compose
    //     <succeeds>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2281,  // -> does not succeed
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x268C:
    //   prefix:
    //     Compose
    //     <precedes or equal to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x22E0,  // -> does not precede or equal
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2692:
    //   prefix:
    //     Compose
    //     <succeeds or equal to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x22E1,  // -> does not succeed or equal
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2698:
    //   prefix:
    //     Compose
    //     <subset of>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2284,  // -> not a subset of
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x269E:
    //   prefix:
    //     Compose
    //     <superset of>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2285,  // -> not a superset of
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x26A4:
    //   prefix:
    //     Compose
    //     <subset of or equal to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2288,  // -> neither a subset of nor equal to
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x26AA:
    //   prefix:
    //     Compose
    //     <superset of or equal to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2289,  // -> neither a superset of nor equal to
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x26B0:
    //   prefix:
    //     Compose
    //     <square image of or equal to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x22E2,  // -> not square image of or equal to
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x26B6:
    //   prefix:
    //     Compose
    //     <square original of or equal to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x22E3,  // -> not square original of or equal to
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x26BC:
    //   prefix:
    //     Compose
    //     <right tack>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x22AC,  // -> does not prove
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x26C2:
    //   prefix:
    //     Compose
    //     <true>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x22AD,  // -> not true
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x26C8:
    //   prefix:
    //     Compose
    //     <forces>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x22AE,  // -> does not force
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x26CE:
    //   prefix:
    //     Compose
    //     <double vertical bar double right turnstile>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x22AF,  // -> negated double vertical bar double right turnstile
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x26D4:
    //   prefix:
    //     Compose
    //     <normal subgroup of>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x22EA,  // -> not normal subgroup of
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x26DA:
    //   prefix:
    //     Compose
    //     <contains as normal subgroup>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x22EB,  // -> does not contain as normal subgroup
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x26E0:
    //   prefix:
    //     Compose
    //     <normal subgroup of or equal to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x22EC,  // -> not normal subgroup of or equal to
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x26E6:
    //   prefix:
    //     Compose
    //     <contains as normal subgroup or equal to>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x22ED,  // -> does not contain as normal subgroup or equal
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x26EC:
    //   prefix:
    //     Compose
    //     <nonforking>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x2ADC,  // -> forking
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x26F2:
    //   prefix:
    //     Dead<combining grave accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0055,          // number of entries
    0x0020,  // space
    0x0060,  // -> grave accent
    0x0041,  // capital a
    0x00C0,  // -> capital a with grave
    0x0045,  // capital e
    0x00C8,  // -> capital e with grave
    0x0049,  // capital i
    0x00CC,  // -> capital i with grave
    0x004E,  // capital n
    0x01F8,  // -> capital n with grave
    0x004F,  // capital o
    0x00D2,  // -> capital o with grave
    0x0055,  // capital u
    0x00D9,  // -> capital u with grave
    0x0056,  // capital v
    0x01DB,  // -> capital u with diaeresis and grave
    0x0057,  // capital w
    0x1E80,  // -> capital w with grave
    0x0059,  // capital y
    0x1EF2,  // -> capital y with grave
    0x0061,  // letter a
    0x00E0,  // -> letter a with grave
    0x0065,  // letter e
    0x00E8,  // -> letter e with grave
    0x0069,  // letter i
    0x00EC,  // -> letter i with grave
    0x006E,  // letter n
    0x01F9,  // -> letter n with grave
    0x006F,  // letter o
    0x00F2,  // -> letter o with grave
    0x0075,  // letter u
    0x00F9,  // -> letter u with grave
    0x0076,  // letter v
    0x01DC,  // -> letter u with diaeresis and grave
    0x0077,  // letter w
    0x1E81,  // -> letter w with grave
    0x0079,  // letter y
    0x1EF3,  // -> letter y with grave
    0x00A0,  // no-break space
    0x0300,  // -> combining grave accent
    0x00C2,  // capital a with circumflex
    0x1EA6,  // -> capital a with circumflex and grave
    0x00CA,  // capital e with circumflex
    0x1EC0,  // -> capital e with circumflex and grave
    0x00D4,  // capital o with circumflex
    0x1ED2,  // -> capital o with circumflex and grave
    0x00DC,  // capital u with diaeresis
    0x01DB,  // -> capital u with diaeresis and grave
    0x00E2,  // letter a with circumflex
    0x1EA7,  // -> letter a with circumflex and grave
    0x00EA,  // letter e with circumflex
    0x1EC1,  // -> letter e with circumflex and grave
    0x00F4,  // letter o with circumflex
    0x1ED3,  // -> letter o with circumflex and grave
    0x00FC,  // letter u with diaeresis
    0x01DC,  // -> letter u with diaeresis and grave
    0x0102,  // capital a with breve
    0x1EB0,  // -> capital a with breve and grave
    0x0103,  // letter a with breve
    0x1EB1,  // -> letter a with breve and grave
    0x0104,  // capital a with ogonek
    0x1EDD,  // -> letter o with horn and grave
    0x0112,  // capital e with macron
    0x1E14,  // -> capital e with macron and grave
    0x0113,  // letter e with macron
    0x1E15,  // -> letter e with macron and grave
    0x014C,  // capital o with macron
    0x1E50,  // -> capital o with macron and grave
    0x014D,  // letter o with macron
    0x1E51,  // -> letter o with macron and grave
    0x017B,  // capital z with dot above
    0x1EEA,  // -> capital u with horn and grave
    0x01A0,  // capital o with horn
    0x1EDC,  // -> capital o with horn and grave
    0x01B0,  // letter u with horn
    0x1EEB,  // -> letter u with horn and grave
    0x0391,  // capital alpha
    0x1FBA,  // -> capital alpha with varia
    0x0395,  // capital epsilon
    0x1FC8,  // -> capital epsilon with varia
    0x0397,  // capital eta
    0x1FCA,  // -> capital eta with varia
    0x0399,  // capital iota
    0x1FDA,  // -> capital iota with varia
    0x039F,  // capital omicron
    0x1FF8,  // -> capital omicron with varia
    0x03A5,  // capital upsilon
    0x1FEA,  // -> capital upsilon with varia
    0x03A9,  // capital omega
    0x1FFA,  // -> capital omega with varia
    0x03B1,  // letter alpha
    0x1F70,  // -> letter alpha with varia
    0x03B5,  // letter epsilon
    0x1F72,  // -> letter epsilon with varia
    0x03B7,  // letter eta
    0x1F74,  // -> letter eta with varia
    0x03B9,  // letter iota
    0x1F76,  // -> letter iota with varia
    0x03BF,  // letter omicron
    0x1F78,  // -> letter omicron with varia
    0x03C5,  // letter upsilon
    0x1F7A,  // -> letter upsilon with varia
    0x03C9,  // letter omega
    0x1F7C,  // -> letter omega with varia
    0x03CA,  // letter iota with dialytika
    0x1FD2,  // -> letter iota with dialytika and varia
    0x03CB,  // letter upsilon with dialytika
    0x1FE2,  // -> letter upsilon with dialytika and varia
    0x0415,  // cyrillic capital ie
    0x0400,  // -> cyrillic capital ie with grave
    0x0418,  // cyrillic capital i
    0x040D,  // -> cyrillic capital i with grave
    0x0435,  // cyrillic small ie
    0x0450,  // -> cyrillic small ie with grave
    0x0438,  // cyrillic small i
    0x045D,  // -> cyrillic small i with grave
    0x1F00,  // letter alpha with psili
    0x1F02,  // -> letter alpha with psili and varia
    0x1F01,  // letter alpha with dasia
    0x1F03,  // -> letter alpha with dasia and varia
    0x1F08,  // capital alpha with psili
    0x1F0A,  // -> capital alpha with psili and varia
    0x1F09,  // capital alpha with dasia
    0x1F0B,  // -> capital alpha with dasia and varia
    0x1F10,  // letter epsilon with psili
    0x1F12,  // -> letter epsilon with psili and varia
    0x1F11,  // letter epsilon with dasia
    0x1F13,  // -> letter epsilon with dasia and varia
    0x1F18,  // capital epsilon with psili
    0x1F1A,  // -> capital epsilon with psili and varia
    0x1F19,  // capital epsilon with dasia
    0x1F1B,  // -> capital epsilon with dasia and varia
    0x1F20,  // letter eta with psili
    0x1F22,  // -> letter eta with psili and varia
    0x1F21,  // letter eta with dasia
    0x1F23,  // -> letter eta with dasia and varia
    0x1F28,  // capital eta with psili
    0x1F2A,  // -> capital eta with psili and varia
    0x1F29,  // capital eta with dasia
    0x1F2B,  // -> capital eta with dasia and varia
    0x1F30,  // letter iota with psili
    0x1F32,  // -> letter iota with psili and varia
    0x1F31,  // letter iota with dasia
    0x1F33,  // -> letter iota with dasia and varia
    0x1F38,  // capital iota with psili
    0x1F3A,  // -> capital iota with psili and varia
    0x1F39,  // capital iota with dasia
    0x1F3B,  // -> capital iota with dasia and varia
    0x1F40,  // letter omicron with psili
    0x1F42,  // -> letter omicron with psili and varia
    0x1F41,  // letter omicron with dasia
    0x1F43,  // -> letter omicron with dasia and varia
    0x1F48,  // capital omicron with psili
    0x1F4A,  // -> capital omicron with psili and varia
    0x1F49,  // capital omicron with dasia
    0x1F4B,  // -> capital omicron with dasia and varia
    0x1F50,  // letter upsilon with psili
    0x1F52,  // -> letter upsilon with psili and varia
    0x1F51,  // letter upsilon with dasia
    0x1F53,  // -> letter upsilon with dasia and varia
    0x1F59,  // capital upsilon with dasia
    0x1F5B,  // -> capital upsilon with dasia and varia
    0x1F60,  // letter omega with psili
    0x1F62,  // -> letter omega with psili and varia
    0x1F61,  // letter omega with dasia
    0x1F63,  // -> letter omega with dasia and varia
    0x1F68,  // capital omega with psili
    0x1F6A,  // -> capital omega with psili and varia
    0x1F69,  // capital omega with dasia
    0x1F6B,  // -> capital omega with dasia and varia
    //   internal dead_key table
    0x0008,          // number of entries
    0x0000,  // U+0000
    0x27B2,
    0x0302,  // combining circumflex accent
    0x2856,
    0x0304,  // combining macron
    0x2866,
    0x0306,  // combining breve
    0x2872,
    0x0308,  // combining diaeresis
    0x287A,
    0x0313,  // combining comma above
    0x2886,
    0x0314,  // combining reversed comma above
    0x28A4,
    0x031B,  // combining horn
    0x28C4,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x0300,  // combining grave accent
    0x0060,  // -> grave accent

    // offset 0x27B2:
    //   prefix:
    //     Dead<combining grave accent>
    //     Compose
    //   internal character table
    0x0009,          // number of entries
    0x0022,  // quotation mark
    0x27C8,
    0x0028,  // left parenthesis
    0x27D4,
    0x0029,  // right parenthesis
    0x27F4,
    0x002B,  // plus sign
    0x2812,
    0x0055,  // capital u
    0x281E,
    0x005E,  // circumflex accent
    0x2826,
    0x005F,  // low line
    0x2836,
    0x0062,  // letter b
    0x2842,
    0x00AF,  // macron
    0x284A,
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x27C8:
    //   prefix:
    //     Dead<combining grave accent>
    //     Compose
    //     <quotation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0055,  // capital u
    0x01DB,  // -> capital u with diaeresis and grave
    0x0075,  // letter u
    0x01DC,  // -> letter u with diaeresis and grave
    0x03B9,  // letter iota
    0x1FD2,  // -> letter iota with dialytika and varia
    0x03C5,  // letter upsilon
    0x1FE2,  // -> letter upsilon with dialytika and varia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x27D4:
    //   prefix:
    //     Dead<combining grave accent>
    //     Compose
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000E,          // number of entries
    0x0391,  // capital alpha
    0x1F0B,  // -> capital alpha with dasia and varia
    0x0395,  // capital epsilon
    0x1F1B,  // -> capital epsilon with dasia and varia
    0x0397,  // capital eta
    0x1F2B,  // -> capital eta with dasia and varia
    0x0399,  // capital iota
    0x1F3B,  // -> capital iota with dasia and varia
    0x039F,  // capital omicron
    0x1F4B,  // -> capital omicron with dasia and varia
    0x03A5,  // capital upsilon
    0x1F5B,  // -> capital upsilon with dasia and varia
    0x03A9,  // capital omega
    0x1F6B,  // -> capital omega with dasia and varia
    0x03B1,  // letter alpha
    0x1F03,  // -> letter alpha with dasia and varia
    0x03B5,  // letter epsilon
    0x1F13,  // -> letter epsilon with dasia and varia
    0x03B7,  // letter eta
    0x1F23,  // -> letter eta with dasia and varia
    0x03B9,  // letter iota
    0x1F33,  // -> letter iota with dasia and varia
    0x03BF,  // letter omicron
    0x1F43,  // -> letter omicron with dasia and varia
    0x03C5,  // letter upsilon
    0x1F53,  // -> letter upsilon with dasia and varia
    0x03C9,  // letter omega
    0x1F63,  // -> letter omega with dasia and varia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x27F4:
    //   prefix:
    //     Dead<combining grave accent>
    //     Compose
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000D,          // number of entries
    0x0391,  // capital alpha
    0x1F0A,  // -> capital alpha with psili and varia
    0x0395,  // capital epsilon
    0x1F1A,  // -> capital epsilon with psili and varia
    0x0397,  // capital eta
    0x1F2A,  // -> capital eta with psili and varia
    0x0399,  // capital iota
    0x1F3A,  // -> capital iota with psili and varia
    0x039F,  // capital omicron
    0x1F4A,  // -> capital omicron with psili and varia
    0x03A9,  // capital omega
    0x1F6A,  // -> capital omega with psili and varia
    0x03B1,  // letter alpha
    0x1F02,  // -> letter alpha with psili and varia
    0x03B5,  // letter epsilon
    0x1F12,  // -> letter epsilon with psili and varia
    0x03B7,  // letter eta
    0x1F22,  // -> letter eta with psili and varia
    0x03B9,  // letter iota
    0x1F32,  // -> letter iota with psili and varia
    0x03BF,  // letter omicron
    0x1F42,  // -> letter omicron with psili and varia
    0x03C5,  // letter upsilon
    0x1F52,  // -> letter upsilon with psili and varia
    0x03C9,  // letter omega
    0x1F62,  // -> letter omega with psili and varia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2812:
    //   prefix:
    //     Dead<combining grave accent>
    //     Compose
    //     <plus sign>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EDC,  // -> capital o with horn and grave
    0x0055,  // capital u
    0x1EEA,  // -> capital u with horn and grave
    0x006F,  // letter o
    0x1EDD,  // -> letter o with horn and grave
    0x0075,  // letter u
    0x1EEB,  // -> letter u with horn and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x281E:
    //   prefix:
    //     Dead<combining grave accent>
    //     Compose
    //     <latin capital letter u>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB0,  // -> capital a with breve and grave
    0x0061,  // letter a
    0x1EB1,  // -> letter a with breve and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2826:
    //   prefix:
    //     Dead<combining grave accent>
    //     Compose
    //     <circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EA6,  // -> capital a with circumflex and grave
    0x0045,  // capital e
    0x1EC0,  // -> capital e with circumflex and grave
    0x004F,  // capital o
    0x1ED2,  // -> capital o with circumflex and grave
    0x0061,  // letter a
    0x1EA7,  // -> letter a with circumflex and grave
    0x0065,  // letter e
    0x1EC1,  // -> letter e with circumflex and grave
    0x006F,  // letter o
    0x1ED3,  // -> letter o with circumflex and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2836:
    //   prefix:
    //     Dead<combining grave accent>
    //     Compose
    //     <low line>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0045,  // capital e
    0x1E14,  // -> capital e with macron and grave
    0x004F,  // capital o
    0x1E50,  // -> capital o with macron and grave
    0x0065,  // letter e
    0x1E15,  // -> letter e with macron and grave
    0x006F,  // letter o
    0x1E51,  // -> letter o with macron and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2842:
    //   prefix:
    //     Dead<combining grave accent>
    //     Compose
    //     <latin small letter b>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB0,  // -> capital a with breve and grave
    0x0061,  // letter a
    0x1EB1,  // -> letter a with breve and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x284A:
    //   prefix:
    //     Dead<combining grave accent>
    //     Compose
    //     <macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0045,  // capital e
    0x1E14,  // -> capital e with macron and grave
    0x004F,  // capital o
    0x1E50,  // -> capital o with macron and grave
    0x0065,  // letter e
    0x1E15,  // -> letter e with macron and grave
    0x006F,  // letter o
    0x1E51,  // -> letter o with macron and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2856:
    //   prefix:
    //     Dead<combining grave accent>
    //     Dead<combining circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EA6,  // -> capital a with circumflex and grave
    0x0045,  // capital e
    0x1EC0,  // -> capital e with circumflex and grave
    0x004F,  // capital o
    0x1ED2,  // -> capital o with circumflex and grave
    0x0061,  // letter a
    0x1EA7,  // -> letter a with circumflex and grave
    0x0065,  // letter e
    0x1EC1,  // -> letter e with circumflex and grave
    0x006F,  // letter o
    0x1ED3,  // -> letter o with circumflex and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2866:
    //   prefix:
    //     Dead<combining grave accent>
    //     Dead<combining macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0045,  // capital e
    0x1E14,  // -> capital e with macron and grave
    0x004F,  // capital o
    0x1E50,  // -> capital o with macron and grave
    0x0065,  // letter e
    0x1E15,  // -> letter e with macron and grave
    0x006F,  // letter o
    0x1E51,  // -> letter o with macron and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2872:
    //   prefix:
    //     Dead<combining grave accent>
    //     Dead<combining breve>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB0,  // -> capital a with breve and grave
    0x0061,  // letter a
    0x1EB1,  // -> letter a with breve and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x287A:
    //   prefix:
    //     Dead<combining grave accent>
    //     Dead<combining diaeresis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0055,  // capital u
    0x01DB,  // -> capital u with diaeresis and grave
    0x0075,  // letter u
    0x01DC,  // -> letter u with diaeresis and grave
    0x03B9,  // letter iota
    0x1FD2,  // -> letter iota with dialytika and varia
    0x03C5,  // letter upsilon
    0x1FE2,  // -> letter upsilon with dialytika and varia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2886:
    //   prefix:
    //     Dead<combining grave accent>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000D,          // number of entries
    0x0391,  // capital alpha
    0x1F0A,  // -> capital alpha with psili and varia
    0x0395,  // capital epsilon
    0x1F1A,  // -> capital epsilon with psili and varia
    0x0397,  // capital eta
    0x1F2A,  // -> capital eta with psili and varia
    0x0399,  // capital iota
    0x1F3A,  // -> capital iota with psili and varia
    0x039F,  // capital omicron
    0x1F4A,  // -> capital omicron with psili and varia
    0x03A9,  // capital omega
    0x1F6A,  // -> capital omega with psili and varia
    0x03B1,  // letter alpha
    0x1F02,  // -> letter alpha with psili and varia
    0x03B5,  // letter epsilon
    0x1F12,  // -> letter epsilon with psili and varia
    0x03B7,  // letter eta
    0x1F22,  // -> letter eta with psili and varia
    0x03B9,  // letter iota
    0x1F32,  // -> letter iota with psili and varia
    0x03BF,  // letter omicron
    0x1F42,  // -> letter omicron with psili and varia
    0x03C5,  // letter upsilon
    0x1F52,  // -> letter upsilon with psili and varia
    0x03C9,  // letter omega
    0x1F62,  // -> letter omega with psili and varia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x28A4:
    //   prefix:
    //     Dead<combining grave accent>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000E,          // number of entries
    0x0391,  // capital alpha
    0x1F0B,  // -> capital alpha with dasia and varia
    0x0395,  // capital epsilon
    0x1F1B,  // -> capital epsilon with dasia and varia
    0x0397,  // capital eta
    0x1F2B,  // -> capital eta with dasia and varia
    0x0399,  // capital iota
    0x1F3B,  // -> capital iota with dasia and varia
    0x039F,  // capital omicron
    0x1F4B,  // -> capital omicron with dasia and varia
    0x03A5,  // capital upsilon
    0x1F5B,  // -> capital upsilon with dasia and varia
    0x03A9,  // capital omega
    0x1F6B,  // -> capital omega with dasia and varia
    0x03B1,  // letter alpha
    0x1F03,  // -> letter alpha with dasia and varia
    0x03B5,  // letter epsilon
    0x1F13,  // -> letter epsilon with dasia and varia
    0x03B7,  // letter eta
    0x1F23,  // -> letter eta with dasia and varia
    0x03B9,  // letter iota
    0x1F33,  // -> letter iota with dasia and varia
    0x03BF,  // letter omicron
    0x1F43,  // -> letter omicron with dasia and varia
    0x03C5,  // letter upsilon
    0x1F53,  // -> letter upsilon with dasia and varia
    0x03C9,  // letter omega
    0x1F63,  // -> letter omega with dasia and varia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x28C4:
    //   prefix:
    //     Dead<combining grave accent>
    //     Dead<combining horn>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EDC,  // -> capital o with horn and grave
    0x0055,  // capital u
    0x1EEA,  // -> capital u with horn and grave
    0x006F,  // letter o
    0x1EDD,  // -> letter o with horn and grave
    0x0075,  // letter u
    0x1EEB,  // -> letter u with horn and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x28D0:
    //   prefix:
    //     Dead<combining acute accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0074,          // number of entries
    0x0020,  // space
    0x0027,  // -> apostrophe
    0x0041,  // capital a
    0x00C1,  // -> capital a with acute
    0x0043,  // capital c
    0x00C7,  // -> capital c with cedilla
    0x0045,  // capital e
    0x00C9,  // -> capital e with acute
    0x0047,  // capital g
    0x01F4,  // -> capital g with acute
    0x0049,  // capital i
    0x00CD,  // -> capital i with acute
    0x004B,  // capital k
    0x1E30,  // -> capital k with acute
    0x004C,  // capital l
    0x0139,  // -> capital l with acute
    0x004D,  // capital m
    0x1E3E,  // -> capital m with acute
    0x004E,  // capital n
    0x0143,  // -> capital n with acute
    0x004F,  // capital o
    0x00D3,  // -> capital o with acute
    0x0050,  // capital p
    0x1E54,  // -> capital p with acute
    0x0052,  // capital r
    0x0154,  // -> capital r with acute
    0x0053,  // capital s
    0x015A,  // -> capital s with acute
    0x0055,  // capital u
    0x00DA,  // -> capital u with acute
    0x0056,  // capital v
    0x01D7,  // -> capital u with diaeresis and acute
    0x0057,  // capital w
    0x1E82,  // -> capital w with acute
    0x0059,  // capital y
    0x00DD,  // -> capital y with acute
    0x005A,  // capital z
    0x0179,  // -> capital z with acute
    0x0061,  // letter a
    0x00E1,  // -> letter a with acute
    0x0063,  // letter c
    0x00E7,  // -> letter c with cedilla
    0x0065,  // letter e
    0x00E9,  // -> letter e with acute
    0x0067,  // letter g
    0x01F5,  // -> letter g with acute
    0x0069,  // letter i
    0x00ED,  // -> letter i with acute
    0x006B,  // letter k
    0x1E31,  // -> letter k with acute
    0x006C,  // letter l
    0x013A,  // -> letter l with acute
    0x006D,  // letter m
    0x1E3F,  // -> letter m with acute
    0x006E,  // letter n
    0x0144,  // -> letter n with acute
    0x006F,  // letter o
    0x00F3,  // -> letter o with acute
    0x0070,  // letter p
    0x1E55,  // -> letter p with acute
    0x0072,  // letter r
    0x0155,  // -> letter r with acute
    0x0073,  // letter s
    0x015B,  // -> letter s with acute
    0x0075,  // letter u
    0x00FA,  // -> letter u with acute
    0x0077,  // letter w
    0x1E83,  // -> letter w with acute
    0x0079,  // letter y
    0x00FD,  // -> letter y with acute
    0x007A,  // letter z
    0x017A,  // -> letter z with acute
    0x00A0,  // no-break space
    0x0301,  // -> combining acute accent
    0x00C2,  // capital a with circumflex
    0x1EA4,  // -> capital a with circumflex and acute
    0x00C5,  // capital a with ring above
    0x01FA,  // -> capital a with ring above and acute
    0x00C6,  // capital ae
    0x01FC,  // -> capital ae with acute
    0x00C7,  // capital c with cedilla
    0x1E08,  // -> capital c with cedilla and acute
    0x00CA,  // capital e with circumflex
    0x1EBE,  // -> capital e with circumflex and acute
    0x00CF,  // capital i with diaeresis
    0x1E2E,  // -> capital i with diaeresis and acute
    0x00D4,  // capital o with circumflex
    0x1ED0,  // -> capital o with circumflex and acute
    0x00D5,  // capital o with tilde
    0x1E4C,  // -> capital o with tilde and acute
    0x00D8,  // capital o with stroke
    0x01FE,  // -> capital o with stroke and acute
    0x00DC,  // capital u with diaeresis
    0x01D7,  // -> capital u with diaeresis and acute
    0x00E2,  // letter a with circumflex
    0x1EA5,  // -> letter a with circumflex and acute
    0x00E5,  // letter a with ring above
    0x01FB,  // -> letter a with ring above and acute
    0x00E6,  // letter ae
    0x01FD,  // -> letter ae with acute
    0x00E7,  // letter c with cedilla
    0x1E09,  // -> letter c with cedilla and acute
    0x00EA,  // letter e with circumflex
    0x1EBF,  // -> letter e with circumflex and acute
    0x00EF,  // letter i with diaeresis
    0x1E2F,  // -> letter i with diaeresis and acute
    0x00F4,  // letter o with circumflex
    0x1ED1,  // -> letter o with circumflex and acute
    0x00F5,  // letter o with tilde
    0x1E4D,  // -> letter o with tilde and acute
    0x00F8,  // letter o with stroke
    0x01FF,  // -> letter o with stroke and acute
    0x00FC,  // letter u with diaeresis
    0x01D8,  // -> letter u with diaeresis and acute
    0x0102,  // capital a with breve
    0x1EAE,  // -> capital a with breve and acute
    0x0103,  // letter a with breve
    0x1EAF,  // -> letter a with breve and acute
    0x0104,  // capital a with ogonek
    0x1EDB,  // -> letter o with horn and acute
    0x0112,  // capital e with macron
    0x1E16,  // -> capital e with macron and acute
    0x0113,  // letter e with macron
    0x1E17,  // -> letter e with macron and acute
    0x014C,  // capital o with macron
    0x1E52,  // -> capital o with macron and acute
    0x014D,  // letter o with macron
    0x1E53,  // -> letter o with macron and acute
    0x0168,  // capital u with tilde
    0x1E78,  // -> capital u with tilde and acute
    0x0169,  // letter u with tilde
    0x1E79,  // -> letter u with tilde and acute
    0x017B,  // capital z with dot above
    0x1EE8,  // -> capital u with horn and acute
    0x01A0,  // capital o with horn
    0x1EDA,  // -> capital o with horn and acute
    0x01B0,  // letter u with horn
    0x1EE9,  // -> letter u with horn and acute
    0x0391,  // capital alpha
    0x0386,  // -> capital alpha with tonos
    0x0395,  // capital epsilon
    0x0388,  // -> capital epsilon with tonos
    0x0397,  // capital eta
    0x0389,  // -> capital eta with tonos
    0x0399,  // capital iota
    0x038A,  // -> capital iota with tonos
    0x039F,  // capital omicron
    0x038C,  // -> capital omicron with tonos
    0x03A5,  // capital upsilon
    0x038E,  // -> capital upsilon with tonos
    0x03A9,  // capital omega
    0x038F,  // -> capital omega with tonos
    0x03B1,  // letter alpha
    0x03AC,  // -> letter alpha with tonos
    0x03B5,  // letter epsilon
    0x03AD,  // -> letter epsilon with tonos
    0x03B7,  // letter eta
    0x03AE,  // -> letter eta with tonos
    0x03B9,  // letter iota
    0x03AF,  // -> letter iota with tonos
    0x03BF,  // letter omicron
    0x03CC,  // -> letter omicron with tonos
    0x03C5,  // letter upsilon
    0x03CD,  // -> letter upsilon with tonos
    0x03C9,  // letter omega
    0x03CE,  // -> letter omega with tonos
    0x03CA,  // letter iota with dialytika
    0x0390,  // -> letter iota with dialytika and tonos
    0x03CB,  // letter upsilon with dialytika
    0x03B0,  // -> letter upsilon with dialytika and tonos
    0x0413,  // cyrillic capital ghe
    0x0403,  // -> cyrillic capital gje
    0x041A,  // cyrillic capital ka
    0x040C,  // -> cyrillic capital kje
    0x0433,  // cyrillic small ghe
    0x0453,  // -> cyrillic small gje
    0x043A,  // cyrillic small ka
    0x045C,  // -> cyrillic small kje
    0x1F00,  // letter alpha with psili
    0x1F04,  // -> letter alpha with psili and oxia
    0x1F01,  // letter alpha with dasia
    0x1F05,  // -> letter alpha with dasia and oxia
    0x1F08,  // capital alpha with psili
    0x1F0C,  // -> capital alpha with psili and oxia
    0x1F09,  // capital alpha with dasia
    0x1F0D,  // -> capital alpha with dasia and oxia
    0x1F10,  // letter epsilon with psili
    0x1F14,  // -> letter epsilon with psili and oxia
    0x1F11,  // letter epsilon with dasia
    0x1F15,  // -> letter epsilon with dasia and oxia
    0x1F18,  // capital epsilon with psili
    0x1F1C,  // -> capital epsilon with psili and oxia
    0x1F19,  // capital epsilon with dasia
    0x1F1D,  // -> capital epsilon with dasia and oxia
    0x1F20,  // letter eta with psili
    0x1F24,  // -> letter eta with psili and oxia
    0x1F21,  // letter eta with dasia
    0x1F25,  // -> letter eta with dasia and oxia
    0x1F28,  // capital eta with psili
    0x1F2C,  // -> capital eta with psili and oxia
    0x1F29,  // capital eta with dasia
    0x1F2D,  // -> capital eta with dasia and oxia
    0x1F30,  // letter iota with psili
    0x1F34,  // -> letter iota with psili and oxia
    0x1F31,  // letter iota with dasia
    0x1F35,  // -> letter iota with dasia and oxia
    0x1F38,  // capital iota with psili
    0x1F3C,  // -> capital iota with psili and oxia
    0x1F39,  // capital iota with dasia
    0x1F3D,  // -> capital iota with dasia and oxia
    0x1F40,  // letter omicron with psili
    0x1F44,  // -> letter omicron with psili and oxia
    0x1F41,  // letter omicron with dasia
    0x1F45,  // -> letter omicron with dasia and oxia
    0x1F48,  // capital omicron with psili
    0x1F4C,  // -> capital omicron with psili and oxia
    0x1F49,  // capital omicron with dasia
    0x1F4D,  // -> capital omicron with dasia and oxia
    0x1F50,  // letter upsilon with psili
    0x1F54,  // -> letter upsilon with psili and oxia
    0x1F51,  // letter upsilon with dasia
    0x1F55,  // -> letter upsilon with dasia and oxia
    0x1F59,  // capital upsilon with dasia
    0x1F5D,  // -> capital upsilon with dasia and oxia
    0x1F60,  // letter omega with psili
    0x1F64,  // -> letter omega with psili and oxia
    0x1F61,  // letter omega with dasia
    0x1F65,  // -> letter omega with dasia and oxia
    0x1F68,  // capital omega with psili
    0x1F6C,  // -> capital omega with psili and oxia
    0x1F69,  // capital omega with dasia
    0x1F6D,  // -> capital omega with dasia and oxia
    //   internal dead_key table
    0x000D,          // number of entries
    0x0000,  // U+0000
    0x29D8,
    0x0302,  // combining circumflex accent
    0x2AB6,
    0x0303,  // combining tilde
    0x2AC6,
    0x0304,  // combining macron
    0x2AD2,
    0x0306,  // combining breve
    0x2ADE,
    0x0307,  // combining dot above
    0x2AE6,
    0x0308,  // combining diaeresis
    0x2AEE,
    0x030A,  // combining ring above
    0x2B00,
    0x0313,  // combining comma above
    0x2B08,
    0x0314,  // combining reversed comma above
    0x2B26,
    0x031B,  // combining horn
    0x2B46,
    0x0327,  // combining cedilla
    0x2B52,
    0x0338,  // combining long solidus overlay
    0x2B5A,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x0301,  // combining acute accent
    0x00B4,  // -> acute accent

    // offset 0x29D8:
    //   prefix:
    //     Dead<combining acute accent>
    //     Compose
    //   internal character table
    0x000E,          // number of entries
    0x0022,  // quotation mark
    0x29F8,
    0x0028,  // left parenthesis
    0x2A08,
    0x0029,  // right parenthesis
    0x2A28,
    0x002B,  // plus sign
    0x2A46,
    0x002C,  // comma
    0x2A52,
    0x002F,  // solidus
    0x2A5A,
    0x0055,  // capital u
    0x2A62,
    0x005E,  // circumflex accent
    0x2A6A,
    0x005F,  // low line
    0x2A7A,
    0x0062,  // letter b
    0x2A86,
    0x006F,  // letter o
    0x2A8E,
    0x007E,  // tilde
    0x2A96,
    0x00AF,  // macron
    0x2AA2,
    0x00B8,  // cedilla
    0x2AAE,
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x29F8:
    //   prefix:
    //     Dead<combining acute accent>
    //     Compose
    //     <quotation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0049,  // capital i
    0x1E2E,  // -> capital i with diaeresis and acute
    0x0055,  // capital u
    0x01D7,  // -> capital u with diaeresis and acute
    0x0069,  // letter i
    0x1E2F,  // -> letter i with diaeresis and acute
    0x0075,  // letter u
    0x01D8,  // -> letter u with diaeresis and acute
    0x03B9,  // letter iota
    0x0390,  // -> letter iota with dialytika and tonos
    0x03C5,  // letter upsilon
    0x03B0,  // -> letter upsilon with dialytika and tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2A08:
    //   prefix:
    //     Dead<combining acute accent>
    //     Compose
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000E,          // number of entries
    0x0391,  // capital alpha
    0x1F0D,  // -> capital alpha with dasia and oxia
    0x0395,  // capital epsilon
    0x1F1D,  // -> capital epsilon with dasia and oxia
    0x0397,  // capital eta
    0x1F2D,  // -> capital eta with dasia and oxia
    0x0399,  // capital iota
    0x1F3D,  // -> capital iota with dasia and oxia
    0x039F,  // capital omicron
    0x1F4D,  // -> capital omicron with dasia and oxia
    0x03A5,  // capital upsilon
    0x1F5D,  // -> capital upsilon with dasia and oxia
    0x03A9,  // capital omega
    0x1F6D,  // -> capital omega with dasia and oxia
    0x03B1,  // letter alpha
    0x1F05,  // -> letter alpha with dasia and oxia
    0x03B5,  // letter epsilon
    0x1F15,  // -> letter epsilon with dasia and oxia
    0x03B7,  // letter eta
    0x1F25,  // -> letter eta with dasia and oxia
    0x03B9,  // letter iota
    0x1F35,  // -> letter iota with dasia and oxia
    0x03BF,  // letter omicron
    0x1F45,  // -> letter omicron with dasia and oxia
    0x03C5,  // letter upsilon
    0x1F55,  // -> letter upsilon with dasia and oxia
    0x03C9,  // letter omega
    0x1F65,  // -> letter omega with dasia and oxia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2A28:
    //   prefix:
    //     Dead<combining acute accent>
    //     Compose
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000D,          // number of entries
    0x0391,  // capital alpha
    0x1F0C,  // -> capital alpha with psili and oxia
    0x0395,  // capital epsilon
    0x1F1C,  // -> capital epsilon with psili and oxia
    0x0397,  // capital eta
    0x1F2C,  // -> capital eta with psili and oxia
    0x0399,  // capital iota
    0x1F3C,  // -> capital iota with psili and oxia
    0x039F,  // capital omicron
    0x1F4C,  // -> capital omicron with psili and oxia
    0x03A9,  // capital omega
    0x1F6C,  // -> capital omega with psili and oxia
    0x03B1,  // letter alpha
    0x1F04,  // -> letter alpha with psili and oxia
    0x03B5,  // letter epsilon
    0x1F14,  // -> letter epsilon with psili and oxia
    0x03B7,  // letter eta
    0x1F24,  // -> letter eta with psili and oxia
    0x03B9,  // letter iota
    0x1F34,  // -> letter iota with psili and oxia
    0x03BF,  // letter omicron
    0x1F44,  // -> letter omicron with psili and oxia
    0x03C5,  // letter upsilon
    0x1F54,  // -> letter upsilon with psili and oxia
    0x03C9,  // letter omega
    0x1F64,  // -> letter omega with psili and oxia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2A46:
    //   prefix:
    //     Dead<combining acute accent>
    //     Compose
    //     <plus sign>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EDA,  // -> capital o with horn and acute
    0x0055,  // capital u
    0x1EE8,  // -> capital u with horn and acute
    0x006F,  // letter o
    0x1EDB,  // -> letter o with horn and acute
    0x0075,  // letter u
    0x1EE9,  // -> letter u with horn and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2A52:
    //   prefix:
    //     Dead<combining acute accent>
    //     Compose
    //     <comma>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0043,  // capital c
    0x1E08,  // -> capital c with cedilla and acute
    0x0063,  // letter c
    0x1E09,  // -> letter c with cedilla and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2A5A:
    //   prefix:
    //     Dead<combining acute accent>
    //     Compose
    //     <solidus>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x01FE,  // -> capital o with stroke and acute
    0x006F,  // letter o
    0x01FF,  // -> letter o with stroke and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2A62:
    //   prefix:
    //     Dead<combining acute accent>
    //     Compose
    //     <latin capital letter u>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EAE,  // -> capital a with breve and acute
    0x0061,  // letter a
    0x1EAF,  // -> letter a with breve and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2A6A:
    //   prefix:
    //     Dead<combining acute accent>
    //     Compose
    //     <circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EA4,  // -> capital a with circumflex and acute
    0x0045,  // capital e
    0x1EBE,  // -> capital e with circumflex and acute
    0x004F,  // capital o
    0x1ED0,  // -> capital o with circumflex and acute
    0x0061,  // letter a
    0x1EA5,  // -> letter a with circumflex and acute
    0x0065,  // letter e
    0x1EBF,  // -> letter e with circumflex and acute
    0x006F,  // letter o
    0x1ED1,  // -> letter o with circumflex and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2A7A:
    //   prefix:
    //     Dead<combining acute accent>
    //     Compose
    //     <low line>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0045,  // capital e
    0x1E16,  // -> capital e with macron and acute
    0x004F,  // capital o
    0x1E52,  // -> capital o with macron and acute
    0x0065,  // letter e
    0x1E17,  // -> letter e with macron and acute
    0x006F,  // letter o
    0x1E53,  // -> letter o with macron and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2A86:
    //   prefix:
    //     Dead<combining acute accent>
    //     Compose
    //     <latin small letter b>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EAE,  // -> capital a with breve and acute
    0x0061,  // letter a
    0x1EAF,  // -> letter a with breve and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2A8E:
    //   prefix:
    //     Dead<combining acute accent>
    //     Compose
    //     <latin small letter o>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x01FA,  // -> capital a with ring above and acute
    0x0061,  // letter a
    0x01FB,  // -> letter a with ring above and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2A96:
    //   prefix:
    //     Dead<combining acute accent>
    //     Compose
    //     <tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1E4C,  // -> capital o with tilde and acute
    0x0055,  // capital u
    0x1E78,  // -> capital u with tilde and acute
    0x006F,  // letter o
    0x1E4D,  // -> letter o with tilde and acute
    0x0075,  // letter u
    0x1E79,  // -> letter u with tilde and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2AA2:
    //   prefix:
    //     Dead<combining acute accent>
    //     Compose
    //     <macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0045,  // capital e
    0x1E16,  // -> capital e with macron and acute
    0x004F,  // capital o
    0x1E52,  // -> capital o with macron and acute
    0x0065,  // letter e
    0x1E17,  // -> letter e with macron and acute
    0x006F,  // letter o
    0x1E53,  // -> letter o with macron and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2AAE:
    //   prefix:
    //     Dead<combining acute accent>
    //     Compose
    //     <cedilla>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0043,  // capital c
    0x1E08,  // -> capital c with cedilla and acute
    0x0063,  // letter c
    0x1E09,  // -> letter c with cedilla and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2AB6:
    //   prefix:
    //     Dead<combining acute accent>
    //     Dead<combining circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EA4,  // -> capital a with circumflex and acute
    0x0045,  // capital e
    0x1EBE,  // -> capital e with circumflex and acute
    0x004F,  // capital o
    0x1ED0,  // -> capital o with circumflex and acute
    0x0061,  // letter a
    0x1EA5,  // -> letter a with circumflex and acute
    0x0065,  // letter e
    0x1EBF,  // -> letter e with circumflex and acute
    0x006F,  // letter o
    0x1ED1,  // -> letter o with circumflex and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2AC6:
    //   prefix:
    //     Dead<combining acute accent>
    //     Dead<combining tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1E4C,  // -> capital o with tilde and acute
    0x0055,  // capital u
    0x1E78,  // -> capital u with tilde and acute
    0x006F,  // letter o
    0x1E4D,  // -> letter o with tilde and acute
    0x0075,  // letter u
    0x1E79,  // -> letter u with tilde and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2AD2:
    //   prefix:
    //     Dead<combining acute accent>
    //     Dead<combining macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0045,  // capital e
    0x1E16,  // -> capital e with macron and acute
    0x004F,  // capital o
    0x1E52,  // -> capital o with macron and acute
    0x0065,  // letter e
    0x1E17,  // -> letter e with macron and acute
    0x006F,  // letter o
    0x1E53,  // -> letter o with macron and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2ADE:
    //   prefix:
    //     Dead<combining acute accent>
    //     Dead<combining breve>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EAE,  // -> capital a with breve and acute
    0x0061,  // letter a
    0x1EAF,  // -> letter a with breve and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2AE6:
    //   prefix:
    //     Dead<combining acute accent>
    //     Dead<combining dot above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0053,  // capital s
    0x1E64,  // -> capital s with acute and dot above
    0x0073,  // letter s
    0x1E65,  // -> letter s with acute and dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2AEE:
    //   prefix:
    //     Dead<combining acute accent>
    //     Dead<combining diaeresis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0007,          // number of entries
    0x0020,  // space
    0x0385,  // -> dialytika tonos
    0x0049,  // capital i
    0x1E2E,  // -> capital i with diaeresis and acute
    0x0055,  // capital u
    0x01D7,  // -> capital u with diaeresis and acute
    0x0069,  // letter i
    0x1E2F,  // -> letter i with diaeresis and acute
    0x0075,  // letter u
    0x01D8,  // -> letter u with diaeresis and acute
    0x03B9,  // letter iota
    0x0390,  // -> letter iota with dialytika and tonos
    0x03C5,  // letter upsilon
    0x03B0,  // -> letter upsilon with dialytika and tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2B00:
    //   prefix:
    //     Dead<combining acute accent>
    //     Dead<combining ring above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x01FA,  // -> capital a with ring above and acute
    0x0061,  // letter a
    0x01FB,  // -> letter a with ring above and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2B08:
    //   prefix:
    //     Dead<combining acute accent>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000D,          // number of entries
    0x0391,  // capital alpha
    0x1F0C,  // -> capital alpha with psili and oxia
    0x0395,  // capital epsilon
    0x1F1C,  // -> capital epsilon with psili and oxia
    0x0397,  // capital eta
    0x1F2C,  // -> capital eta with psili and oxia
    0x0399,  // capital iota
    0x1F3C,  // -> capital iota with psili and oxia
    0x039F,  // capital omicron
    0x1F4C,  // -> capital omicron with psili and oxia
    0x03A9,  // capital omega
    0x1F6C,  // -> capital omega with psili and oxia
    0x03B1,  // letter alpha
    0x1F04,  // -> letter alpha with psili and oxia
    0x03B5,  // letter epsilon
    0x1F14,  // -> letter epsilon with psili and oxia
    0x03B7,  // letter eta
    0x1F24,  // -> letter eta with psili and oxia
    0x03B9,  // letter iota
    0x1F34,  // -> letter iota with psili and oxia
    0x03BF,  // letter omicron
    0x1F44,  // -> letter omicron with psili and oxia
    0x03C5,  // letter upsilon
    0x1F54,  // -> letter upsilon with psili and oxia
    0x03C9,  // letter omega
    0x1F64,  // -> letter omega with psili and oxia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2B26:
    //   prefix:
    //     Dead<combining acute accent>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000E,          // number of entries
    0x0391,  // capital alpha
    0x1F0D,  // -> capital alpha with dasia and oxia
    0x0395,  // capital epsilon
    0x1F1D,  // -> capital epsilon with dasia and oxia
    0x0397,  // capital eta
    0x1F2D,  // -> capital eta with dasia and oxia
    0x0399,  // capital iota
    0x1F3D,  // -> capital iota with dasia and oxia
    0x039F,  // capital omicron
    0x1F4D,  // -> capital omicron with dasia and oxia
    0x03A5,  // capital upsilon
    0x1F5D,  // -> capital upsilon with dasia and oxia
    0x03A9,  // capital omega
    0x1F6D,  // -> capital omega with dasia and oxia
    0x03B1,  // letter alpha
    0x1F05,  // -> letter alpha with dasia and oxia
    0x03B5,  // letter epsilon
    0x1F15,  // -> letter epsilon with dasia and oxia
    0x03B7,  // letter eta
    0x1F25,  // -> letter eta with dasia and oxia
    0x03B9,  // letter iota
    0x1F35,  // -> letter iota with dasia and oxia
    0x03BF,  // letter omicron
    0x1F45,  // -> letter omicron with dasia and oxia
    0x03C5,  // letter upsilon
    0x1F55,  // -> letter upsilon with dasia and oxia
    0x03C9,  // letter omega
    0x1F65,  // -> letter omega with dasia and oxia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2B46:
    //   prefix:
    //     Dead<combining acute accent>
    //     Dead<combining horn>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EDA,  // -> capital o with horn and acute
    0x0055,  // capital u
    0x1EE8,  // -> capital u with horn and acute
    0x006F,  // letter o
    0x1EDB,  // -> letter o with horn and acute
    0x0075,  // letter u
    0x1EE9,  // -> letter u with horn and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2B52:
    //   prefix:
    //     Dead<combining acute accent>
    //     Dead<combining cedilla>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0043,  // capital c
    0x1E08,  // -> capital c with cedilla and acute
    0x0063,  // letter c
    0x1E09,  // -> letter c with cedilla and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2B5A:
    //   prefix:
    //     Dead<combining acute accent>
    //     Dead<combining long solidus overlay>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x01FE,  // -> capital o with stroke and acute
    0x006F,  // letter o
    0x01FF,  // -> letter o with stroke and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2B62:
    //   prefix:
    //     Dead<combining circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0050,          // number of entries
    0x0020,  // space
    0x00B2,  // -> superscript two
    0x0028,  // left parenthesis
    0x207D,  // -> superscript left parenthesis
    0x0029,  // right parenthesis
    0x207E,  // -> superscript right parenthesis
    0x002B,  // plus sign
    0x207A,  // -> superscript plus sign
    0x002D,  // hyphen-minus
    0x207B,  // -> superscript minus
    0x0030,  // digit zero
    0x2070,  // -> superscript zero
    0x0031,  // digit one
    0x00B9,  // -> superscript one
    0x0032,  // digit two
    0x00B2,  // -> superscript two
    0x0033,  // digit three
    0x00B3,  // -> superscript three
    0x0034,  // digit four
    0x2074,  // -> superscript four
    0x0035,  // digit five
    0x2075,  // -> superscript five
    0x0036,  // digit six
    0x2076,  // -> superscript six
    0x0037,  // digit seven
    0x2077,  // -> superscript seven
    0x0038,  // digit eight
    0x2078,  // -> superscript eight
    0x0039,  // digit nine
    0x2079,  // -> superscript nine
    0x003D,  // equals sign
    0x207C,  // -> superscript equals sign
    0x0041,  // capital a
    0x00C2,  // -> capital a with circumflex
    0x0043,  // capital c
    0x0108,  // -> capital c with circumflex
    0x0045,  // capital e
    0x00CA,  // -> capital e with circumflex
    0x0047,  // capital g
    0x011C,  // -> capital g with circumflex
    0x0048,  // capital h
    0x0124,  // -> capital h with circumflex
    0x0049,  // capital i
    0x00CE,  // -> capital i with circumflex
    0x004A,  // capital j
    0x0134,  // -> capital j with circumflex
    0x004F,  // capital o
    0x00D4,  // -> capital o with circumflex
    0x0053,  // capital s
    0x015C,  // -> capital s with circumflex
    0x0055,  // capital u
    0x00DB,  // -> capital u with circumflex
    0x0057,  // capital w
    0x0174,  // -> capital w with circumflex
    0x0059,  // capital y
    0x0176,  // -> capital y with circumflex
    0x005A,  // capital z
    0x1E90,  // -> capital z with circumflex
    0x0061,  // letter a
    0x00E2,  // -> letter a with circumflex
    0x0063,  // letter c
    0x0109,  // -> letter c with circumflex
    0x0065,  // letter e
    0x00EA,  // -> letter e with circumflex
    0x0067,  // letter g
    0x011D,  // -> letter g with circumflex
    0x0068,  // letter h
    0x0125,  // -> letter h with circumflex
    0x0069,  // letter i
    0x00EE,  // -> letter i with circumflex
    0x006A,  // letter j
    0x0135,  // -> letter j with circumflex
    0x006F,  // letter o
    0x00F4,  // -> letter o with circumflex
    0x0073,  // letter s
    0x015D,  // -> letter s with circumflex
    0x0075,  // letter u
    0x00FB,  // -> letter u with circumflex
    0x0077,  // letter w
    0x0175,  // -> letter w with circumflex
    0x0079,  // letter y
    0x0177,  // -> letter y with circumflex
    0x007A,  // letter z
    0x1E91,  // -> letter z with circumflex
    0x00A0,  // no-break space
    0x0302,  // -> combining circumflex accent
    0x00C0,  // capital a with grave
    0x1EA6,  // -> capital a with circumflex and grave
    0x00C1,  // capital a with acute
    0x1EA4,  // -> capital a with circumflex and acute
    0x00C3,  // capital a with tilde
    0x1EAA,  // -> capital a with circumflex and tilde
    0x00C8,  // capital e with grave
    0x1EC0,  // -> capital e with circumflex and grave
    0x00C9,  // capital e with acute
    0x1EBE,  // -> capital e with circumflex and acute
    0x00D2,  // capital o with grave
    0x1ED2,  // -> capital o with circumflex and grave
    0x00D3,  // capital o with acute
    0x1ED0,  // -> capital o with circumflex and acute
    0x00D5,  // capital o with tilde
    0x1ED6,  // -> capital o with circumflex and tilde
    0x00E0,  // letter a with grave
    0x1EA7,  // -> letter a with circumflex and grave
    0x00E1,  // letter a with acute
    0x1EA5,  // -> letter a with circumflex and acute
    0x00E3,  // letter a with tilde
    0x1EAB,  // -> letter a with circumflex and tilde
    0x00E8,  // letter e with grave
    0x1EC1,  // -> letter e with circumflex and grave
    0x00E9,  // letter e with acute
    0x1EBF,  // -> letter e with circumflex and acute
    0x00F2,  // letter o with grave
    0x1ED3,  // -> letter o with circumflex and grave
    0x00F3,  // letter o with acute
    0x1ED1,  // -> letter o with circumflex and acute
    0x00F5,  // letter o with tilde
    0x1ED7,  // -> letter o with circumflex and tilde
    0x1EA0,  // capital a with dot below
    0x1EAC,  // -> capital a with circumflex and dot below
    0x1EA1,  // letter a with dot below
    0x1EAD,  // -> letter a with circumflex and dot below
    0x1EB8,  // capital e with dot below
    0x1EC6,  // -> capital e with circumflex and dot below
    0x1EB9,  // letter e with dot below
    0x1EC7,  // -> letter e with circumflex and dot below
    0x1ECC,  // capital o with dot below
    0x1ED8,  // -> capital o with circumflex and dot below
    0x1ECD,  // letter o with dot below
    0x1ED9,  // -> letter o with circumflex and dot below
    0x2212,  // minus sign
    0x207B,  // -> superscript minus
    0x4E00,  // cjk unified ideograph-4e00
    0x3192,  // -> ideographic annotation one mark
    0x4E01,  // cjk unified ideograph-4e01
    0x319C,  // -> ideographic annotation fourth mark
    0x4E09,  // cjk unified ideograph-4e09
    0x3194,  // -> ideographic annotation three mark
    0x4E0A,  // cjk unified ideograph-4e0a
    0x3196,  // -> ideographic annotation top mark
    0x4E0B,  // cjk unified ideograph-4e0b
    0x3198,  // -> ideographic annotation bottom mark
    0x4E19,  // cjk unified ideograph-4e19
    0x319B,  // -> ideographic annotation third mark
    0x4E2D,  // cjk unified ideograph-4e2d
    0x3197,  // -> ideographic annotation middle mark
    0x4E59,  // cjk unified ideograph-4e59
    0x319A,  // -> ideographic annotation second mark
    0x4E8C,  // cjk unified ideograph-4e8c
    0x3193,  // -> ideographic annotation two mark
    0x4EBA,  // cjk unified ideograph-4eba
    0x319F,  // -> ideographic annotation man mark
    0x56DB,  // cjk unified ideograph-56db
    0x3195,  // -> ideographic annotation four mark
    0x5730,  // cjk unified ideograph-5730
    0x319E,  // -> ideographic annotation earth mark
    0x5929,  // cjk unified ideograph-5929
    0x319D,  // -> ideographic annotation heaven mark
    0x7532,  // cjk unified ideograph-7532
    0x3199,  // -> ideographic annotation first mark
    //   internal dead_key table
    0x0006,          // number of entries
    0x0000,  // U+0000
    0x2C14,
    0x0300,  // combining grave accent
    0x2C7C,
    0x0301,  // combining acute accent
    0x2C8C,
    0x0303,  // combining tilde
    0x2C9C,
    0x0309,  // combining hook above
    0x2CAC,
    0x0323,  // combining dot below
    0x2CBC,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x0302,  // combining circumflex accent
    0x005E,  // -> circumflex accent

    // offset 0x2C14:
    //   prefix:
    //     Dead<combining circumflex accent>
    //     Compose
    //   internal character table
    0x0006,          // number of entries
    0x0021,  // exclamation mark
    0x2C24,
    0x0053,  // capital s
    0x2C34,
    0x0054,  // capital t
    0x2C3C,
    0x005F,  // low line
    0x2C44,
    0x0073,  // letter s
    0x2C6C,
    0x0074,  // letter t
    0x2C74,
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2C24:
    //   prefix:
    //     Dead<combining circumflex accent>
    //     Compose
    //     <exclamation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EAC,  // -> capital a with circumflex and dot below
    0x0045,  // capital e
    0x1EC6,  // -> capital e with circumflex and dot below
    0x004F,  // capital o
    0x1ED8,  // -> capital o with circumflex and dot below
    0x0061,  // letter a
    0x1EAD,  // -> letter a with circumflex and dot below
    0x0065,  // letter e
    0x1EC7,  // -> letter e with circumflex and dot below
    0x006F,  // letter o
    0x1ED9,  // -> letter o with circumflex and dot below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2C34:
    //   prefix:
    //     Dead<combining circumflex accent>
    //     Compose
    //     <latin capital letter s>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004D,  // capital m
    0x2120,  // -> service mark
    0x006D,  // letter m
    0x2120,  // -> service mark
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2C3C:
    //   prefix:
    //     Dead<combining circumflex accent>
    //     Compose
    //     <latin capital letter t>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004D,  // capital m
    0x2122,  // -> trade mark sign
    0x006D,  // letter m
    0x2122,  // -> trade mark sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2C44:
    //   prefix:
    //     Dead<combining circumflex accent>
    //     Compose
    //     <low line>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0012,          // number of entries
    0x0061,  // letter a
    0x00AA,  // -> feminine ordinal indicator
    0x0068,  // letter h
    0x02B0,  // -> modifier small h
    0x0069,  // letter i
    0x2071,  // -> superscript latin small i
    0x006A,  // letter j
    0x02B2,  // -> modifier small j
    0x006C,  // letter l
    0x02E1,  // -> modifier small l
    0x006E,  // letter n
    0x207F,  // -> superscript latin small n
    0x006F,  // letter o
    0x00BA,  // -> masculine ordinal indicator
    0x0072,  // letter r
    0x02B3,  // -> modifier small r
    0x0073,  // letter s
    0x02E2,  // -> modifier small s
    0x0077,  // letter w
    0x02B7,  // -> modifier small w
    0x0078,  // letter x
    0x02E3,  // -> modifier small x
    0x0079,  // letter y
    0x02B8,  // -> modifier small y
    0x0263,  // letter gamma
    0x02E0,  // -> modifier small gamma
    0x0266,  // letter h with hook
    0x02B1,  // -> modifier small h with hook
    0x0279,  // letter turned r
    0x02B4,  // -> modifier small turned r
    0x027B,  // letter turned r with hook
    0x02B5,  // -> modifier small turned r with hook
    0x0281,  // letter small capital inverted r
    0x02B6,  // -> modifier small capital inverted r
    0x0295,  // letter pharyngeal voiced fricative
    0x02E4,  // -> modifier small reversed glottal stop
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2C6C:
    //   prefix:
    //     Dead<combining circumflex accent>
    //     Compose
    //     <latin small letter s>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004D,  // capital m
    0x2120,  // -> service mark
    0x006D,  // letter m
    0x2120,  // -> service mark
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2C74:
    //   prefix:
    //     Dead<combining circumflex accent>
    //     Compose
    //     <latin small letter t>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004D,  // capital m
    0x2122,  // -> trade mark sign
    0x006D,  // letter m
    0x2122,  // -> trade mark sign
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2C7C:
    //   prefix:
    //     Dead<combining circumflex accent>
    //     Dead<combining grave accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EA6,  // -> capital a with circumflex and grave
    0x0045,  // capital e
    0x1EC0,  // -> capital e with circumflex and grave
    0x004F,  // capital o
    0x1ED2,  // -> capital o with circumflex and grave
    0x0061,  // letter a
    0x1EA7,  // -> letter a with circumflex and grave
    0x0065,  // letter e
    0x1EC1,  // -> letter e with circumflex and grave
    0x006F,  // letter o
    0x1ED3,  // -> letter o with circumflex and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2C8C:
    //   prefix:
    //     Dead<combining circumflex accent>
    //     Dead<combining acute accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EA4,  // -> capital a with circumflex and acute
    0x0045,  // capital e
    0x1EBE,  // -> capital e with circumflex and acute
    0x004F,  // capital o
    0x1ED0,  // -> capital o with circumflex and acute
    0x0061,  // letter a
    0x1EA5,  // -> letter a with circumflex and acute
    0x0065,  // letter e
    0x1EBF,  // -> letter e with circumflex and acute
    0x006F,  // letter o
    0x1ED1,  // -> letter o with circumflex and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2C9C:
    //   prefix:
    //     Dead<combining circumflex accent>
    //     Dead<combining tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EAA,  // -> capital a with circumflex and tilde
    0x0045,  // capital e
    0x1EC4,  // -> capital e with circumflex and tilde
    0x004F,  // capital o
    0x1ED6,  // -> capital o with circumflex and tilde
    0x0061,  // letter a
    0x1EAB,  // -> letter a with circumflex and tilde
    0x0065,  // letter e
    0x1EC5,  // -> letter e with circumflex and tilde
    0x006F,  // letter o
    0x1ED7,  // -> letter o with circumflex and tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2CAC:
    //   prefix:
    //     Dead<combining circumflex accent>
    //     Dead<combining hook above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EA8,  // -> capital a with circumflex and hook above
    0x0045,  // capital e
    0x1EC2,  // -> capital e with circumflex and hook above
    0x004F,  // capital o
    0x1ED4,  // -> capital o with circumflex and hook above
    0x0061,  // letter a
    0x1EA9,  // -> letter a with circumflex and hook above
    0x0065,  // letter e
    0x1EC3,  // -> letter e with circumflex and hook above
    0x006F,  // letter o
    0x1ED5,  // -> letter o with circumflex and hook above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2CBC:
    //   prefix:
    //     Dead<combining circumflex accent>
    //     Dead<combining dot below>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EAC,  // -> capital a with circumflex and dot below
    0x0045,  // capital e
    0x1EC6,  // -> capital e with circumflex and dot below
    0x004F,  // capital o
    0x1ED8,  // -> capital o with circumflex and dot below
    0x0061,  // letter a
    0x1EAD,  // -> letter a with circumflex and dot below
    0x0065,  // letter e
    0x1EC7,  // -> letter e with circumflex and dot below
    0x006F,  // letter o
    0x1ED9,  // -> letter o with circumflex and dot below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2CCC:
    //   prefix:
    //     Dead<combining tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0043,          // number of entries
    0x0020,  // space
    0x007E,  // -> tilde
    0x003C,  // less-than sign
    0x2272,  // -> less-than or equivalent to
    0x003D,  // equals sign
    0x2243,  // -> asymptotically equal to
    0x003E,  // greater-than sign
    0x2273,  // -> greater-than or equivalent to
    0x0041,  // capital a
    0x00C3,  // -> capital a with tilde
    0x0045,  // capital e
    0x1EBC,  // -> capital e with tilde
    0x0049,  // capital i
    0x0128,  // -> capital i with tilde
    0x004E,  // capital n
    0x00D1,  // -> capital n with tilde
    0x004F,  // capital o
    0x00D5,  // -> capital o with tilde
    0x0055,  // capital u
    0x0168,  // -> capital u with tilde
    0x0056,  // capital v
    0x1E7C,  // -> capital v with tilde
    0x0059,  // capital y
    0x1EF8,  // -> capital y with tilde
    0x0061,  // letter a
    0x00E3,  // -> letter a with tilde
    0x0065,  // letter e
    0x1EBD,  // -> letter e with tilde
    0x0069,  // letter i
    0x0129,  // -> letter i with tilde
    0x006E,  // letter n
    0x00F1,  // -> letter n with tilde
    0x006F,  // letter o
    0x00F5,  // -> letter o with tilde
    0x0075,  // letter u
    0x0169,  // -> letter u with tilde
    0x0076,  // letter v
    0x1E7D,  // -> letter v with tilde
    0x0079,  // letter y
    0x1EF9,  // -> letter y with tilde
    0x00A0,  // no-break space
    0x0303,  // -> combining tilde
    0x00C2,  // capital a with circumflex
    0x1EAA,  // -> capital a with circumflex and tilde
    0x00CA,  // capital e with circumflex
    0x1EC4,  // -> capital e with circumflex and tilde
    0x00D3,  // capital o with acute
    0x1E4C,  // -> capital o with tilde and acute
    0x00D4,  // capital o with circumflex
    0x1ED6,  // -> capital o with circumflex and tilde
    0x00D6,  // capital o with diaeresis
    0x1E4E,  // -> capital o with tilde and diaeresis
    0x00DA,  // capital u with acute
    0x1E78,  // -> capital u with tilde and acute
    0x00E2,  // letter a with circumflex
    0x1EAB,  // -> letter a with circumflex and tilde
    0x00EA,  // letter e with circumflex
    0x1EC5,  // -> letter e with circumflex and tilde
    0x00F3,  // letter o with acute
    0x1E4D,  // -> letter o with tilde and acute
    0x00F4,  // letter o with circumflex
    0x1ED7,  // -> letter o with circumflex and tilde
    0x00F6,  // letter o with diaeresis
    0x1E4F,  // -> letter o with tilde and diaeresis
    0x00FA,  // letter u with acute
    0x1E79,  // -> letter u with tilde and acute
    0x0102,  // capital a with breve
    0x1EB4,  // -> capital a with breve and tilde
    0x0103,  // letter a with breve
    0x1EB5,  // -> letter a with breve and tilde
    0x0104,  // capital a with ogonek
    0x1EE1,  // -> letter o with horn and tilde
    0x014C,  // capital o with macron
    0x022C,  // -> capital o with tilde and macron
    0x014D,  // letter o with macron
    0x022D,  // -> letter o with tilde and macron
    0x017B,  // capital z with dot above
    0x1EEE,  // -> capital u with horn and tilde
    0x01A0,  // capital o with horn
    0x1EE0,  // -> capital o with horn and tilde
    0x01B0,  // letter u with horn
    0x1EEF,  // -> letter u with horn and tilde
    0x03B1,  // letter alpha
    0x1FB6,  // -> letter alpha with perispomeni
    0x03B7,  // letter eta
    0x1FC6,  // -> letter eta with perispomeni
    0x03B9,  // letter iota
    0x1FD6,  // -> letter iota with perispomeni
    0x03C5,  // letter upsilon
    0x1FE6,  // -> letter upsilon with perispomeni
    0x03C9,  // letter omega
    0x1FF6,  // -> letter omega with perispomeni
    0x03CA,  // letter iota with dialytika
    0x1FD7,  // -> letter iota with dialytika and perispomeni
    0x03CB,  // letter upsilon with dialytika
    0x1FE7,  // -> letter upsilon with dialytika and perispomeni
    0x1F00,  // letter alpha with psili
    0x1F06,  // -> letter alpha with psili and perispomeni
    0x1F01,  // letter alpha with dasia
    0x1F07,  // -> letter alpha with dasia and perispomeni
    0x1F08,  // capital alpha with psili
    0x1F0E,  // -> capital alpha with psili and perispomeni
    0x1F09,  // capital alpha with dasia
    0x1F0F,  // -> capital alpha with dasia and perispomeni
    0x1F20,  // letter eta with psili
    0x1F26,  // -> letter eta with psili and perispomeni
    0x1F21,  // letter eta with dasia
    0x1F27,  // -> letter eta with dasia and perispomeni
    0x1F28,  // capital eta with psili
    0x1F2E,  // -> capital eta with psili and perispomeni
    0x1F29,  // capital eta with dasia
    0x1F2F,  // -> capital eta with dasia and perispomeni
    0x1F30,  // letter iota with psili
    0x1F36,  // -> letter iota with psili and perispomeni
    0x1F31,  // letter iota with dasia
    0x1F37,  // -> letter iota with dasia and perispomeni
    0x1F38,  // capital iota with psili
    0x1F3E,  // -> capital iota with psili and perispomeni
    0x1F39,  // capital iota with dasia
    0x1F3F,  // -> capital iota with dasia and perispomeni
    0x1F50,  // letter upsilon with psili
    0x1F56,  // -> letter upsilon with psili and perispomeni
    0x1F51,  // letter upsilon with dasia
    0x1F57,  // -> letter upsilon with dasia and perispomeni
    0x1F59,  // capital upsilon with dasia
    0x1F5F,  // -> capital upsilon with dasia and perispomeni
    0x1F60,  // letter omega with psili
    0x1F66,  // -> letter omega with psili and perispomeni
    0x1F61,  // letter omega with dasia
    0x1F67,  // -> letter omega with dasia and perispomeni
    0x1F68,  // capital omega with psili
    0x1F6E,  // -> capital omega with psili and perispomeni
    0x1F69,  // capital omega with dasia
    0x1F6F,  // -> capital omega with dasia and perispomeni
    //   internal dead_key table
    0x0009,          // number of entries
    0x0000,  // U+0000
    0x2D6A,
    0x0301,  // combining acute accent
    0x2DDE,
    0x0302,  // combining circumflex accent
    0x2DEA,
    0x0304,  // combining macron
    0x2DFA,
    0x0306,  // combining breve
    0x2E02,
    0x0308,  // combining diaeresis
    0x2E0A,
    0x0313,  // combining comma above
    0x2E16,
    0x0314,  // combining reversed comma above
    0x2E2C,
    0x031B,  // combining horn
    0x2E44,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x0303,  // combining tilde
    0x007E,  // -> tilde

    // offset 0x2D6A:
    //   prefix:
    //     Dead<combining tilde>
    //     Compose
    //   internal character table
    0x0007,          // number of entries
    0x0022,  // quotation mark
    0x2D7C,
    0x0028,  // left parenthesis
    0x2D84,
    0x0029,  // right parenthesis
    0x2D9C,
    0x002B,  // plus sign
    0x2DB2,
    0x0055,  // capital u
    0x2DBE,
    0x005E,  // circumflex accent
    0x2DC6,
    0x0062,  // letter b
    0x2DD6,
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2D7C:
    //   prefix:
    //     Dead<combining tilde>
    //     Compose
    //     <quotation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x03B9,  // letter iota
    0x1FD7,  // -> letter iota with dialytika and perispomeni
    0x03C5,  // letter upsilon
    0x1FE7,  // -> letter upsilon with dialytika and perispomeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2D84:
    //   prefix:
    //     Dead<combining tilde>
    //     Compose
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000A,          // number of entries
    0x0391,  // capital alpha
    0x1F0F,  // -> capital alpha with dasia and perispomeni
    0x0397,  // capital eta
    0x1F2F,  // -> capital eta with dasia and perispomeni
    0x0399,  // capital iota
    0x1F3F,  // -> capital iota with dasia and perispomeni
    0x03A5,  // capital upsilon
    0x1F5F,  // -> capital upsilon with dasia and perispomeni
    0x03A9,  // capital omega
    0x1F6F,  // -> capital omega with dasia and perispomeni
    0x03B1,  // letter alpha
    0x1F07,  // -> letter alpha with dasia and perispomeni
    0x03B7,  // letter eta
    0x1F27,  // -> letter eta with dasia and perispomeni
    0x03B9,  // letter iota
    0x1F37,  // -> letter iota with dasia and perispomeni
    0x03C5,  // letter upsilon
    0x1F57,  // -> letter upsilon with dasia and perispomeni
    0x03C9,  // letter omega
    0x1F67,  // -> letter omega with dasia and perispomeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2D9C:
    //   prefix:
    //     Dead<combining tilde>
    //     Compose
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0009,          // number of entries
    0x0391,  // capital alpha
    0x1F0E,  // -> capital alpha with psili and perispomeni
    0x0397,  // capital eta
    0x1F2E,  // -> capital eta with psili and perispomeni
    0x0399,  // capital iota
    0x1F3E,  // -> capital iota with psili and perispomeni
    0x03A9,  // capital omega
    0x1F6E,  // -> capital omega with psili and perispomeni
    0x03B1,  // letter alpha
    0x1F06,  // -> letter alpha with psili and perispomeni
    0x03B7,  // letter eta
    0x1F26,  // -> letter eta with psili and perispomeni
    0x03B9,  // letter iota
    0x1F36,  // -> letter iota with psili and perispomeni
    0x03C5,  // letter upsilon
    0x1F56,  // -> letter upsilon with psili and perispomeni
    0x03C9,  // letter omega
    0x1F66,  // -> letter omega with psili and perispomeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2DB2:
    //   prefix:
    //     Dead<combining tilde>
    //     Compose
    //     <plus sign>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EE0,  // -> capital o with horn and tilde
    0x0055,  // capital u
    0x1EEE,  // -> capital u with horn and tilde
    0x006F,  // letter o
    0x1EE1,  // -> letter o with horn and tilde
    0x0075,  // letter u
    0x1EEF,  // -> letter u with horn and tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2DBE:
    //   prefix:
    //     Dead<combining tilde>
    //     Compose
    //     <latin capital letter u>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB4,  // -> capital a with breve and tilde
    0x0061,  // letter a
    0x1EB5,  // -> letter a with breve and tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2DC6:
    //   prefix:
    //     Dead<combining tilde>
    //     Compose
    //     <circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EAA,  // -> capital a with circumflex and tilde
    0x0045,  // capital e
    0x1EC4,  // -> capital e with circumflex and tilde
    0x004F,  // capital o
    0x1ED6,  // -> capital o with circumflex and tilde
    0x0061,  // letter a
    0x1EAB,  // -> letter a with circumflex and tilde
    0x0065,  // letter e
    0x1EC5,  // -> letter e with circumflex and tilde
    0x006F,  // letter o
    0x1ED7,  // -> letter o with circumflex and tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2DD6:
    //   prefix:
    //     Dead<combining tilde>
    //     Compose
    //     <latin small letter b>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB4,  // -> capital a with breve and tilde
    0x0061,  // letter a
    0x1EB5,  // -> letter a with breve and tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2DDE:
    //   prefix:
    //     Dead<combining tilde>
    //     Dead<combining acute accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1E4C,  // -> capital o with tilde and acute
    0x0055,  // capital u
    0x1E78,  // -> capital u with tilde and acute
    0x006F,  // letter o
    0x1E4D,  // -> letter o with tilde and acute
    0x0075,  // letter u
    0x1E79,  // -> letter u with tilde and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2DEA:
    //   prefix:
    //     Dead<combining tilde>
    //     Dead<combining circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EAA,  // -> capital a with circumflex and tilde
    0x0045,  // capital e
    0x1EC4,  // -> capital e with circumflex and tilde
    0x004F,  // capital o
    0x1ED6,  // -> capital o with circumflex and tilde
    0x0061,  // letter a
    0x1EAB,  // -> letter a with circumflex and tilde
    0x0065,  // letter e
    0x1EC5,  // -> letter e with circumflex and tilde
    0x006F,  // letter o
    0x1ED7,  // -> letter o with circumflex and tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2DFA:
    //   prefix:
    //     Dead<combining tilde>
    //     Dead<combining macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x022C,  // -> capital o with tilde and macron
    0x006F,  // letter o
    0x022D,  // -> letter o with tilde and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2E02:
    //   prefix:
    //     Dead<combining tilde>
    //     Dead<combining breve>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB4,  // -> capital a with breve and tilde
    0x0061,  // letter a
    0x1EB5,  // -> letter a with breve and tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2E0A:
    //   prefix:
    //     Dead<combining tilde>
    //     Dead<combining diaeresis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1E4E,  // -> capital o with tilde and diaeresis
    0x006F,  // letter o
    0x1E4F,  // -> letter o with tilde and diaeresis
    0x03B9,  // letter iota
    0x1FD7,  // -> letter iota with dialytika and perispomeni
    0x03C5,  // letter upsilon
    0x1FE7,  // -> letter upsilon with dialytika and perispomeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2E16:
    //   prefix:
    //     Dead<combining tilde>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0009,          // number of entries
    0x0391,  // capital alpha
    0x1F0E,  // -> capital alpha with psili and perispomeni
    0x0397,  // capital eta
    0x1F2E,  // -> capital eta with psili and perispomeni
    0x0399,  // capital iota
    0x1F3E,  // -> capital iota with psili and perispomeni
    0x03A9,  // capital omega
    0x1F6E,  // -> capital omega with psili and perispomeni
    0x03B1,  // letter alpha
    0x1F06,  // -> letter alpha with psili and perispomeni
    0x03B7,  // letter eta
    0x1F26,  // -> letter eta with psili and perispomeni
    0x03B9,  // letter iota
    0x1F36,  // -> letter iota with psili and perispomeni
    0x03C5,  // letter upsilon
    0x1F56,  // -> letter upsilon with psili and perispomeni
    0x03C9,  // letter omega
    0x1F66,  // -> letter omega with psili and perispomeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2E2C:
    //   prefix:
    //     Dead<combining tilde>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000A,          // number of entries
    0x0391,  // capital alpha
    0x1F0F,  // -> capital alpha with dasia and perispomeni
    0x0397,  // capital eta
    0x1F2F,  // -> capital eta with dasia and perispomeni
    0x0399,  // capital iota
    0x1F3F,  // -> capital iota with dasia and perispomeni
    0x03A5,  // capital upsilon
    0x1F5F,  // -> capital upsilon with dasia and perispomeni
    0x03A9,  // capital omega
    0x1F6F,  // -> capital omega with dasia and perispomeni
    0x03B1,  // letter alpha
    0x1F07,  // -> letter alpha with dasia and perispomeni
    0x03B7,  // letter eta
    0x1F27,  // -> letter eta with dasia and perispomeni
    0x03B9,  // letter iota
    0x1F37,  // -> letter iota with dasia and perispomeni
    0x03C5,  // letter upsilon
    0x1F57,  // -> letter upsilon with dasia and perispomeni
    0x03C9,  // letter omega
    0x1F67,  // -> letter omega with dasia and perispomeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2E44:
    //   prefix:
    //     Dead<combining tilde>
    //     Dead<combining horn>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EE0,  // -> capital o with horn and tilde
    0x0055,  // capital u
    0x1EEE,  // -> capital u with horn and tilde
    0x006F,  // letter o
    0x1EE1,  // -> letter o with horn and tilde
    0x0075,  // letter u
    0x1EEF,  // -> letter u with horn and tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2E50:
    //   prefix:
    //     Dead<combining macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0038,          // number of entries
    0x0020,  // space
    0x00AF,  // -> macron
    0x0041,  // capital a
    0x0100,  // -> capital a with macron
    0x0045,  // capital e
    0x0112,  // -> capital e with macron
    0x0047,  // capital g
    0x1E20,  // -> capital g with macron
    0x0049,  // capital i
    0x012A,  // -> capital i with macron
    0x004F,  // capital o
    0x014C,  // -> capital o with macron
    0x0055,  // capital u
    0x016A,  // -> capital u with macron
    0x0056,  // capital v
    0x01D5,  // -> capital u with diaeresis and macron
    0x0059,  // capital y
    0x0232,  // -> capital y with macron
    0x0061,  // letter a
    0x0101,  // -> letter a with macron
    0x0065,  // letter e
    0x0113,  // -> letter e with macron
    0x0067,  // letter g
    0x1E21,  // -> letter g with macron
    0x0069,  // letter i
    0x012B,  // -> letter i with macron
    0x006F,  // letter o
    0x014D,  // -> letter o with macron
    0x0075,  // letter u
    0x016B,  // -> letter u with macron
    0x0076,  // letter v
    0x01D6,  // -> letter u with diaeresis and macron
    0x0079,  // letter y
    0x0233,  // -> letter y with macron
    0x00A0,  // no-break space
    0x0304,  // -> combining macron
    0x00C4,  // capital a with diaeresis
    0x01DE,  // -> capital a with diaeresis and macron
    0x00C6,  // capital ae
    0x01E2,  // -> capital ae with macron
    0x00C8,  // capital e with grave
    0x1E14,  // -> capital e with macron and grave
    0x00C9,  // capital e with acute
    0x1E16,  // -> capital e with macron and acute
    0x00D2,  // capital o with grave
    0x1E50,  // -> capital o with macron and grave
    0x00D3,  // capital o with acute
    0x1E52,  // -> capital o with macron and acute
    0x00D5,  // capital o with tilde
    0x022C,  // -> capital o with tilde and macron
    0x00D6,  // capital o with diaeresis
    0x022A,  // -> capital o with diaeresis and macron
    0x00DC,  // capital u with diaeresis
    0x01D5,  // -> capital u with diaeresis and macron
    0x00E4,  // letter a with diaeresis
    0x01DF,  // -> letter a with diaeresis and macron
    0x00E6,  // letter ae
    0x01E3,  // -> letter ae with macron
    0x00E8,  // letter e with grave
    0x1E15,  // -> letter e with macron and grave
    0x00E9,  // letter e with acute
    0x1E17,  // -> letter e with macron and acute
    0x00F2,  // letter o with grave
    0x1E51,  // -> letter o with macron and grave
    0x00F3,  // letter o with acute
    0x1E53,  // -> letter o with macron and acute
    0x00F5,  // letter o with tilde
    0x022D,  // -> letter o with tilde and macron
    0x00F6,  // letter o with diaeresis
    0x022B,  // -> letter o with diaeresis and macron
    0x00FC,  // letter u with diaeresis
    0x01D6,  // -> letter u with diaeresis and macron
    0x0119,  // letter e with ogonek
    0x01EC,  // -> capital o with ogonek and macron
    0x01EB,  // letter o with ogonek
    0x01ED,  // -> letter o with ogonek and macron
    0x0226,  // capital a with dot above
    0x01E0,  // -> capital a with dot above and macron
    0x0227,  // letter a with dot above
    0x01E1,  // -> letter a with dot above and macron
    0x022E,  // capital o with dot above
    0x0230,  // -> capital o with dot above and macron
    0x022F,  // letter o with dot above
    0x0231,  // -> letter o with dot above and macron
    0x0391,  // capital alpha
    0x1FB9,  // -> capital alpha with macron
    0x0399,  // capital iota
    0x1FD9,  // -> capital iota with macron
    0x03A5,  // capital upsilon
    0x1FE9,  // -> capital upsilon with macron
    0x03B1,  // letter alpha
    0x1FB1,  // -> letter alpha with macron
    0x03B9,  // letter iota
    0x1FD1,  // -> letter iota with macron
    0x03C5,  // letter upsilon
    0x1FE1,  // -> letter upsilon with macron
    0x0418,  // cyrillic capital i
    0x04E2,  // -> cyrillic capital i with macron
    0x0423,  // cyrillic capital u
    0x04EE,  // -> cyrillic capital u with macron
    0x0438,  // cyrillic small i
    0x04E3,  // -> cyrillic small i with macron
    0x0443,  // cyrillic small u
    0x04EF,  // -> cyrillic small u with macron
    0x1E36,  // capital l with dot below
    0x1E38,  // -> capital l with dot below and macron
    0x1E37,  // letter l with dot below
    0x1E39,  // -> letter l with dot below and macron
    0x1E5A,  // capital r with dot below
    0x1E5C,  // -> capital r with dot below and macron
    0x1E5B,  // letter r with dot below
    0x1E5D,  // -> letter r with dot below and macron
    //   internal dead_key table
    0x0008,          // number of entries
    0x0000,  // U+0000
    0x2ED6,
    0x0300,  // combining grave accent
    0x2F1C,
    0x0301,  // combining acute accent
    0x2F28,
    0x0303,  // combining tilde
    0x2F34,
    0x0307,  // combining dot above
    0x2F3C,
    0x0308,  // combining diaeresis
    0x2F48,
    0x0323,  // combining dot below
    0x2F58,
    0x0328,  // combining ogonek
    0x2F64,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x0304,  // combining macron
    0x00AF,  // -> macron

    // offset 0x2ED6:
    //   prefix:
    //     Dead<combining macron>
    //     Compose
    //   internal character table
    0x0005,          // number of entries
    0x0021,  // exclamation mark
    0x2EE4,
    0x0022,  // quotation mark
    0x2EF0,
    0x002E,  // full stop
    0x2F00,
    0x003B,  // semicolon
    0x2F0C,
    0x007E,  // tilde
    0x2F14,
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2EE4:
    //   prefix:
    //     Dead<combining macron>
    //     Compose
    //     <exclamation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004C,  // capital l
    0x1E38,  // -> capital l with dot below and macron
    0x0052,  // capital r
    0x1E5C,  // -> capital r with dot below and macron
    0x006C,  // letter l
    0x1E39,  // -> letter l with dot below and macron
    0x0072,  // letter r
    0x1E5D,  // -> letter r with dot below and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2EF0:
    //   prefix:
    //     Dead<combining macron>
    //     Compose
    //     <quotation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x01DE,  // -> capital a with diaeresis and macron
    0x004F,  // capital o
    0x022A,  // -> capital o with diaeresis and macron
    0x0055,  // capital u
    0x01D5,  // -> capital u with diaeresis and macron
    0x0061,  // letter a
    0x01DF,  // -> letter a with diaeresis and macron
    0x006F,  // letter o
    0x022B,  // -> letter o with diaeresis and macron
    0x0075,  // letter u
    0x01D6,  // -> letter u with diaeresis and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2F00:
    //   prefix:
    //     Dead<combining macron>
    //     Compose
    //     <full stop>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0041,  // capital a
    0x01E0,  // -> capital a with dot above and macron
    0x004F,  // capital o
    0x0230,  // -> capital o with dot above and macron
    0x0061,  // letter a
    0x01E1,  // -> letter a with dot above and macron
    0x006F,  // letter o
    0x0231,  // -> letter o with dot above and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2F0C:
    //   prefix:
    //     Dead<combining macron>
    //     Compose
    //     <semicolon>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x01EC,  // -> capital o with ogonek and macron
    0x006F,  // letter o
    0x01ED,  // -> letter o with ogonek and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2F14:
    //   prefix:
    //     Dead<combining macron>
    //     Compose
    //     <tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x022C,  // -> capital o with tilde and macron
    0x006F,  // letter o
    0x022D,  // -> letter o with tilde and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2F1C:
    //   prefix:
    //     Dead<combining macron>
    //     Dead<combining grave accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0045,  // capital e
    0x1E14,  // -> capital e with macron and grave
    0x004F,  // capital o
    0x1E50,  // -> capital o with macron and grave
    0x0065,  // letter e
    0x1E15,  // -> letter e with macron and grave
    0x006F,  // letter o
    0x1E51,  // -> letter o with macron and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2F28:
    //   prefix:
    //     Dead<combining macron>
    //     Dead<combining acute accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0045,  // capital e
    0x1E16,  // -> capital e with macron and acute
    0x004F,  // capital o
    0x1E52,  // -> capital o with macron and acute
    0x0065,  // letter e
    0x1E17,  // -> letter e with macron and acute
    0x006F,  // letter o
    0x1E53,  // -> letter o with macron and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2F34:
    //   prefix:
    //     Dead<combining macron>
    //     Dead<combining tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x022C,  // -> capital o with tilde and macron
    0x006F,  // letter o
    0x022D,  // -> letter o with tilde and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2F3C:
    //   prefix:
    //     Dead<combining macron>
    //     Dead<combining dot above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0041,  // capital a
    0x01E0,  // -> capital a with dot above and macron
    0x004F,  // capital o
    0x0230,  // -> capital o with dot above and macron
    0x0061,  // letter a
    0x01E1,  // -> letter a with dot above and macron
    0x006F,  // letter o
    0x0231,  // -> letter o with dot above and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2F48:
    //   prefix:
    //     Dead<combining macron>
    //     Dead<combining diaeresis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x01DE,  // -> capital a with diaeresis and macron
    0x004F,  // capital o
    0x022A,  // -> capital o with diaeresis and macron
    0x0055,  // capital u
    0x01D5,  // -> capital u with diaeresis and macron
    0x0061,  // letter a
    0x01DF,  // -> letter a with diaeresis and macron
    0x006F,  // letter o
    0x022B,  // -> letter o with diaeresis and macron
    0x0075,  // letter u
    0x01D6,  // -> letter u with diaeresis and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2F58:
    //   prefix:
    //     Dead<combining macron>
    //     Dead<combining dot below>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004C,  // capital l
    0x1E38,  // -> capital l with dot below and macron
    0x0052,  // capital r
    0x1E5C,  // -> capital r with dot below and macron
    0x006C,  // letter l
    0x1E39,  // -> letter l with dot below and macron
    0x0072,  // letter r
    0x1E5D,  // -> letter r with dot below and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2F64:
    //   prefix:
    //     Dead<combining macron>
    //     Dead<combining ogonek>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x01EC,  // -> capital o with ogonek and macron
    0x006F,  // letter o
    0x01ED,  // -> letter o with ogonek and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2F6C:
    //   prefix:
    //     Dead<combining breve>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0028,          // number of entries
    0x0020,  // space
    0x02D8,  // -> breve
    0x0041,  // capital a
    0x0102,  // -> capital a with breve
    0x0045,  // capital e
    0x0114,  // -> capital e with breve
    0x0047,  // capital g
    0x011E,  // -> capital g with breve
    0x0049,  // capital i
    0x012C,  // -> capital i with breve
    0x004F,  // capital o
    0x014E,  // -> capital o with breve
    0x0055,  // capital u
    0x016C,  // -> capital u with breve
    0x0061,  // letter a
    0x0103,  // -> letter a with breve
    0x0065,  // letter e
    0x0115,  // -> letter e with breve
    0x0067,  // letter g
    0x011F,  // -> letter g with breve
    0x0069,  // letter i
    0x012D,  // -> letter i with breve
    0x006F,  // letter o
    0x014F,  // -> letter o with breve
    0x0075,  // letter u
    0x016D,  // -> letter u with breve
    0x00A0,  // no-break space
    0x0306,  // -> combining breve
    0x00C0,  // capital a with grave
    0x1EB0,  // -> capital a with breve and grave
    0x00C1,  // capital a with acute
    0x1EAE,  // -> capital a with breve and acute
    0x00C3,  // capital a with tilde
    0x1EB4,  // -> capital a with breve and tilde
    0x00E0,  // letter a with grave
    0x1EB1,  // -> letter a with breve and grave
    0x00E1,  // letter a with acute
    0x1EAF,  // -> letter a with breve and acute
    0x00E3,  // letter a with tilde
    0x1EB5,  // -> letter a with breve and tilde
    0x0228,  // capital e with cedilla
    0x1E1C,  // -> capital e with cedilla and breve
    0x0229,  // letter e with cedilla
    0x1E1D,  // -> letter e with cedilla and breve
    0x0391,  // capital alpha
    0x1FB8,  // -> capital alpha with vrachy
    0x0399,  // capital iota
    0x1FD8,  // -> capital iota with vrachy
    0x03A5,  // capital upsilon
    0x1FE8,  // -> capital upsilon with vrachy
    0x03B1,  // letter alpha
    0x1FB0,  // -> letter alpha with vrachy
    0x03B9,  // letter iota
    0x1FD0,  // -> letter iota with vrachy
    0x03C5,  // letter upsilon
    0x1FE0,  // -> letter upsilon with vrachy
    0x0410,  // cyrillic capital a
    0x04D0,  // -> cyrillic capital a with breve
    0x0415,  // cyrillic capital ie
    0x04D6,  // -> cyrillic capital ie with breve
    0x0416,  // cyrillic capital zhe
    0x04C1,  // -> cyrillic capital zhe with breve
    0x0418,  // cyrillic capital i
    0x0419,  // -> cyrillic capital short i
    0x0423,  // cyrillic capital u
    0x040E,  // -> cyrillic capital short u
    0x0430,  // cyrillic small a
    0x04D1,  // -> cyrillic small a with breve
    0x0435,  // cyrillic small ie
    0x04D7,  // -> cyrillic small ie with breve
    0x0436,  // cyrillic small zhe
    0x04C2,  // -> cyrillic small zhe with breve
    0x0438,  // cyrillic small i
    0x0439,  // -> cyrillic small short i
    0x0443,  // cyrillic small u
    0x045E,  // -> cyrillic small short u
    0x1EA0,  // capital a with dot below
    0x1EB6,  // -> capital a with breve and dot below
    0x1EA1,  // letter a with dot below
    0x1EB7,  // -> letter a with breve and dot below
    //   internal dead_key table
    0x0007,          // number of entries
    0x0000,  // U+0000
    0x2FD0,
    0x0300,  // combining grave accent
    0x2FF2,
    0x0301,  // combining acute accent
    0x2FFA,
    0x0303,  // combining tilde
    0x3002,
    0x0309,  // combining hook above
    0x300A,
    0x0323,  // combining dot below
    0x3012,
    0x0327,  // combining cedilla
    0x301A,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x0306,  // combining breve
    0x02D8,  // -> breve

    // offset 0x2FD0:
    //   prefix:
    //     Dead<combining breve>
    //     Compose
    //   internal character table
    0x0003,          // number of entries
    0x0021,  // exclamation mark
    0x2FDA,
    0x002C,  // comma
    0x2FE2,
    0x00B8,  // cedilla
    0x2FEA,
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2FDA:
    //   prefix:
    //     Dead<combining breve>
    //     Compose
    //     <exclamation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB6,  // -> capital a with breve and dot below
    0x0061,  // letter a
    0x1EB7,  // -> letter a with breve and dot below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2FE2:
    //   prefix:
    //     Dead<combining breve>
    //     Compose
    //     <comma>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0045,  // capital e
    0x1E1C,  // -> capital e with cedilla and breve
    0x0065,  // letter e
    0x1E1D,  // -> letter e with cedilla and breve
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2FEA:
    //   prefix:
    //     Dead<combining breve>
    //     Compose
    //     <cedilla>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0045,  // capital e
    0x1E1C,  // -> capital e with cedilla and breve
    0x0065,  // letter e
    0x1E1D,  // -> letter e with cedilla and breve
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2FF2:
    //   prefix:
    //     Dead<combining breve>
    //     Dead<combining grave accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB0,  // -> capital a with breve and grave
    0x0061,  // letter a
    0x1EB1,  // -> letter a with breve and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x2FFA:
    //   prefix:
    //     Dead<combining breve>
    //     Dead<combining acute accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EAE,  // -> capital a with breve and acute
    0x0061,  // letter a
    0x1EAF,  // -> letter a with breve and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3002:
    //   prefix:
    //     Dead<combining breve>
    //     Dead<combining tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB4,  // -> capital a with breve and tilde
    0x0061,  // letter a
    0x1EB5,  // -> letter a with breve and tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x300A:
    //   prefix:
    //     Dead<combining breve>
    //     Dead<combining hook above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB2,  // -> capital a with breve and hook above
    0x0061,  // letter a
    0x1EB3,  // -> letter a with breve and hook above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3012:
    //   prefix:
    //     Dead<combining breve>
    //     Dead<combining dot below>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB6,  // -> capital a with breve and dot below
    0x0061,  // letter a
    0x1EB7,  // -> letter a with breve and dot below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x301A:
    //   prefix:
    //     Dead<combining breve>
    //     Dead<combining cedilla>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0045,  // capital e
    0x1E1C,  // -> capital e with cedilla and breve
    0x0065,  // letter e
    0x1E1D,  // -> letter e with cedilla and breve
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3022:
    //   prefix:
    //     Dead<combining dot above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0038,          // number of entries
    0x0020,  // space
    0x02D9,  // -> dot above
    0x0041,  // capital a
    0x0226,  // -> capital a with dot above
    0x0042,  // capital b
    0x1E02,  // -> capital b with dot above
    0x0043,  // capital c
    0x010A,  // -> capital c with dot above
    0x0044,  // capital d
    0x1E0A,  // -> capital d with dot above
    0x0045,  // capital e
    0x0116,  // -> capital e with dot above
    0x0046,  // capital f
    0x1E1E,  // -> capital f with dot above
    0x0047,  // capital g
    0x0120,  // -> capital g with dot above
    0x0048,  // capital h
    0x1E22,  // -> capital h with dot above
    0x0049,  // capital i
    0x0130,  // -> capital i with dot above
    0x004C,  // capital l
    0x013F,  // -> capital l with middle dot
    0x004D,  // capital m
    0x1E40,  // -> capital m with dot above
    0x004E,  // capital n
    0x1E44,  // -> capital n with dot above
    0x004F,  // capital o
    0x022E,  // -> capital o with dot above
    0x0050,  // capital p
    0x1E56,  // -> capital p with dot above
    0x0052,  // capital r
    0x1E58,  // -> capital r with dot above
    0x0053,  // capital s
    0x1E60,  // -> capital s with dot above
    0x0054,  // capital t
    0x1E6A,  // -> capital t with dot above
    0x0057,  // capital w
    0x1E86,  // -> capital w with dot above
    0x0058,  // capital x
    0x1E8A,  // -> capital x with dot above
    0x0059,  // capital y
    0x1E8E,  // -> capital y with dot above
    0x005A,  // capital z
    0x017B,  // -> capital z with dot above
    0x0061,  // letter a
    0x0227,  // -> letter a with dot above
    0x0062,  // letter b
    0x1E03,  // -> letter b with dot above
    0x0063,  // letter c
    0x010B,  // -> letter c with dot above
    0x0064,  // letter d
    0x1E0B,  // -> letter d with dot above
    0x0065,  // letter e
    0x0117,  // -> letter e with dot above
    0x0066,  // letter f
    0x1E1F,  // -> letter f with dot above
    0x0067,  // letter g
    0x0121,  // -> letter g with dot above
    0x0068,  // letter h
    0x1E23,  // -> letter h with dot above
    0x0069,  // letter i
    0x0131,  // -> letter dotless i
    0x006A,  // letter j
    0x0237,  // -> letter dotless j
    0x006C,  // letter l
    0x0140,  // -> letter l with middle dot
    0x006D,  // letter m
    0x1E41,  // -> letter m with dot above
    0x006E,  // letter n
    0x1E45,  // -> letter n with dot above
    0x006F,  // letter o
    0x022F,  // -> letter o with dot above
    0x0070,  // letter p
    0x1E57,  // -> letter p with dot above
    0x0072,  // letter r
    0x1E59,  // -> letter r with dot above
    0x0073,  // letter s
    0x1E61,  // -> letter s with dot above
    0x0074,  // letter t
    0x1E6B,  // -> letter t with dot above
    0x0077,  // letter w
    0x1E87,  // -> letter w with dot above
    0x0078,  // letter x
    0x1E8B,  // -> letter x with dot above
    0x0079,  // letter y
    0x1E8F,  // -> letter y with dot above
    0x007A,  // letter z
    0x017C,  // -> letter z with dot above
    0x00A0,  // no-break space
    0x0307,  // -> combining dot above
    0x0100,  // capital a with macron
    0x01E0,  // -> capital a with dot above and macron
    0x0101,  // letter a with macron
    0x01E1,  // -> letter a with dot above and macron
    0x014C,  // capital o with macron
    0x0230,  // -> capital o with dot above and macron
    0x014D,  // letter o with macron
    0x0231,  // -> letter o with dot above and macron
    0x015A,  // capital s with acute
    0x1E64,  // -> capital s with acute and dot above
    0x015B,  // letter s with acute
    0x1E65,  // -> letter s with acute and dot above
    0x0160,  // capital s with caron
    0x1E66,  // -> capital s with caron and dot above
    0x0161,  // letter s with caron
    0x1E67,  // -> letter s with caron and dot above
    0x017F,  // letter long s
    0x1E9B,  // -> letter long s with dot above
    0x1E62,  // capital s with dot below
    0x1E68,  // -> capital s with dot below and dot above
    0x1E63,  // letter s with dot below
    0x1E69,  // -> letter s with dot below and dot above
    //   internal dead_key table
    0x0006,          // number of entries
    0x0000,  // U+0000
    0x30A4,
    0x0301,  // combining acute accent
    0x30D0,
    0x0304,  // combining macron
    0x30D8,
    0x030C,  // combining caron
    0x30E4,
    0x0323,  // combining dot below
    0x30EC,
    0x0338,  // combining long solidus overlay
    0x30F4,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x0307,  // combining dot above
    0x02D9,  // -> dot above

    // offset 0x30A4:
    //   prefix:
    //     Dead<combining dot above>
    //     Compose
    //   internal character table
    0x0004,          // number of entries
    0x0021,  // exclamation mark
    0x30B0,
    0x0027,  // apostrophe
    0x30B8,
    0x0063,  // letter c
    0x30C0,
    0x00B4,  // acute accent
    0x30C8,
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x30B0:
    //   prefix:
    //     Dead<combining dot above>
    //     Compose
    //     <exclamation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0053,  // capital s
    0x1E68,  // -> capital s with dot below and dot above
    0x0073,  // letter s
    0x1E69,  // -> letter s with dot below and dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x30B8:
    //   prefix:
    //     Dead<combining dot above>
    //     Compose
    //     <apostrophe>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0053,  // capital s
    0x1E64,  // -> capital s with acute and dot above
    0x0073,  // letter s
    0x1E65,  // -> letter s with acute and dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x30C0:
    //   prefix:
    //     Dead<combining dot above>
    //     Compose
    //     <latin small letter c>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0053,  // capital s
    0x1E66,  // -> capital s with caron and dot above
    0x0073,  // letter s
    0x1E67,  // -> letter s with caron and dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x30C8:
    //   prefix:
    //     Dead<combining dot above>
    //     Compose
    //     <acute accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0053,  // capital s
    0x1E64,  // -> capital s with acute and dot above
    0x0073,  // letter s
    0x1E65,  // -> letter s with acute and dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x30D0:
    //   prefix:
    //     Dead<combining dot above>
    //     Dead<combining acute accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0053,  // capital s
    0x1E64,  // -> capital s with acute and dot above
    0x0073,  // letter s
    0x1E65,  // -> letter s with acute and dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x30D8:
    //   prefix:
    //     Dead<combining dot above>
    //     Dead<combining macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x0041,  // capital a
    0x01E0,  // -> capital a with dot above and macron
    0x004F,  // capital o
    0x0230,  // -> capital o with dot above and macron
    0x0061,  // letter a
    0x01E1,  // -> letter a with dot above and macron
    0x006F,  // letter o
    0x0231,  // -> letter o with dot above and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x30E4:
    //   prefix:
    //     Dead<combining dot above>
    //     Dead<combining caron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0053,  // capital s
    0x1E66,  // -> capital s with caron and dot above
    0x0073,  // letter s
    0x1E67,  // -> letter s with caron and dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x30EC:
    //   prefix:
    //     Dead<combining dot above>
    //     Dead<combining dot below>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0053,  // capital s
    0x1E68,  // -> capital s with dot below and dot above
    0x0073,  // letter s
    0x1E69,  // -> letter s with dot below and dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x30F4:
    //   prefix:
    //     Dead<combining dot above>
    //     Dead<combining long solidus overlay>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x006A,  // letter j
    0x025F,  // -> letter dotless j with stroke
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x30FA:
    //   prefix:
    //     Dead<combining diaeresis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0045,          // number of entries
    0x0020,  // space
    0x0022,  // -> quotation mark
    0x0027,  // apostrophe
    0x0344,  // -> combining greek dialytika tonos
    0x0041,  // capital a
    0x00C4,  // -> capital a with diaeresis
    0x0045,  // capital e
    0x00CB,  // -> capital e with diaeresis
    0x0048,  // capital h
    0x1E26,  // -> capital h with diaeresis
    0x0049,  // capital i
    0x00CF,  // -> capital i with diaeresis
    0x004F,  // capital o
    0x00D6,  // -> capital o with diaeresis
    0x0055,  // capital u
    0x00DC,  // -> capital u with diaeresis
    0x0057,  // capital w
    0x1E84,  // -> capital w with diaeresis
    0x0058,  // capital x
    0x1E8C,  // -> capital x with diaeresis
    0x0059,  // capital y
    0x0178,  // -> capital y with diaeresis
    0x0061,  // letter a
    0x00E4,  // -> letter a with diaeresis
    0x0065,  // letter e
    0x00EB,  // -> letter e with diaeresis
    0x0068,  // letter h
    0x1E27,  // -> letter h with diaeresis
    0x0069,  // letter i
    0x00EF,  // -> letter i with diaeresis
    0x006F,  // letter o
    0x00F6,  // -> letter o with diaeresis
    0x0074,  // letter t
    0x1E97,  // -> letter t with diaeresis
    0x0075,  // letter u
    0x00FC,  // -> letter u with diaeresis
    0x0077,  // letter w
    0x1E85,  // -> letter w with diaeresis
    0x0078,  // letter x
    0x1E8D,  // -> letter x with diaeresis
    0x0079,  // letter y
    0x00FF,  // -> letter y with diaeresis
    0x00A0,  // no-break space
    0x0308,  // -> combining diaeresis
    0x00B4,  // acute accent
    0x0344,  // -> combining greek dialytika tonos
    0x00CD,  // capital i with acute
    0x1E2E,  // -> capital i with diaeresis and acute
    0x00D5,  // capital o with tilde
    0x1E4E,  // -> capital o with tilde and diaeresis
    0x00D9,  // capital u with grave
    0x01DB,  // -> capital u with diaeresis and grave
    0x00DA,  // capital u with acute
    0x01D7,  // -> capital u with diaeresis and acute
    0x00ED,  // letter i with acute
    0x1E2F,  // -> letter i with diaeresis and acute
    0x00F5,  // letter o with tilde
    0x1E4F,  // -> letter o with tilde and diaeresis
    0x00F9,  // letter u with grave
    0x01DC,  // -> letter u with diaeresis and grave
    0x00FA,  // letter u with acute
    0x01D8,  // -> letter u with diaeresis and acute
    0x0100,  // capital a with macron
    0x01DE,  // -> capital a with diaeresis and macron
    0x0101,  // letter a with macron
    0x01DF,  // -> letter a with diaeresis and macron
    0x014C,  // capital o with macron
    0x022A,  // -> capital o with diaeresis and macron
    0x014D,  // letter o with macron
    0x022B,  // -> letter o with diaeresis and macron
    0x016A,  // capital u with macron
    0x1E7A,  // -> capital u with macron and diaeresis
    0x016B,  // letter u with macron
    0x1E7B,  // -> letter u with macron and diaeresis
    0x01D3,  // capital u with caron
    0x01D9,  // -> capital u with diaeresis and caron
    0x01D4,  // letter u with caron
    0x01DA,  // -> letter u with diaeresis and caron
    0x0399,  // capital iota
    0x03AA,  // -> capital iota with dialytika
    0x03A5,  // capital upsilon
    0x03AB,  // -> capital upsilon with dialytika
    0x03B9,  // letter iota
    0x03CA,  // -> letter iota with dialytika
    0x03C5,  // letter upsilon
    0x03CB,  // -> letter upsilon with dialytika
    0x0406,  // cyrillic capital byelorussian-ukrainian i
    0x0407,  // -> cyrillic capital yi
    0x0410,  // cyrillic capital a
    0x04D2,  // -> cyrillic capital a with diaeresis
    0x0415,  // cyrillic capital ie
    0x0401,  // -> cyrillic capital io
    0x0416,  // cyrillic capital zhe
    0x04DC,  // -> cyrillic capital zhe with diaeresis
    0x0417,  // cyrillic capital ze
    0x04DE,  // -> cyrillic capital ze with diaeresis
    0x0418,  // cyrillic capital i
    0x04E4,  // -> cyrillic capital i with diaeresis
    0x041E,  // cyrillic capital o
    0x04E6,  // -> cyrillic capital o with diaeresis
    0x0423,  // cyrillic capital u
    0x04F0,  // -> cyrillic capital u with diaeresis
    0x0427,  // cyrillic capital che
    0x04F4,  // -> cyrillic capital che with diaeresis
    0x042B,  // cyrillic capital yeru
    0x04F8,  // -> cyrillic capital yeru with diaeresis
    0x042D,  // cyrillic capital e
    0x04EC,  // -> cyrillic capital e with diaeresis
    0x0430,  // cyrillic small a
    0x04D3,  // -> cyrillic small a with diaeresis
    0x0435,  // cyrillic small ie
    0x0451,  // -> cyrillic small io
    0x0436,  // cyrillic small zhe
    0x04DD,  // -> cyrillic small zhe with diaeresis
    0x0437,  // cyrillic small ze
    0x04DF,  // -> cyrillic small ze with diaeresis
    0x0438,  // cyrillic small i
    0x04E5,  // -> cyrillic small i with diaeresis
    0x043E,  // cyrillic small o
    0x04E7,  // -> cyrillic small o with diaeresis
    0x0443,  // cyrillic small u
    0x04F1,  // -> cyrillic small u with diaeresis
    0x0447,  // cyrillic small che
    0x04F5,  // -> cyrillic small che with diaeresis
    0x044B,  // cyrillic small yeru
    0x04F9,  // -> cyrillic small yeru with diaeresis
    0x044D,  // cyrillic small e
    0x04ED,  // -> cyrillic small e with diaeresis
    0x0456,  // cyrillic small byelorussian-ukrainian i
    0x0457,  // -> cyrillic small yi
    0x04E8,  // cyrillic capital barred o
    0x04EA,  // -> cyrillic capital barred o with diaeresis
    0x04E9,  // cyrillic small barred o
    0x04EB,  // -> cyrillic small barred o with diaeresis
    0x30EA,  // katakana ri
    0x04DA,  // -> cyrillic capital schwa with diaeresis
    0x30EB,  // katakana ru
    0x04DB,  // -> cyrillic small schwa with diaeresis
    //   internal dead_key table
    0x0006,          // number of entries
    0x0000,  // U+0000
    0x3196,
    0x0300,  // combining grave accent
    0x31B8,
    0x0301,  // combining acute accent
    0x31C0,
    0x0303,  // combining tilde
    0x31D2,
    0x0304,  // combining macron
    0x31DA,
    0x030C,  // combining caron
    0x31EA,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x0308,  // combining diaeresis
    0x00A8,  // -> diaeresis

    // offset 0x3196:
    //   prefix:
    //     Dead<combining diaeresis>
    //     Compose
    //   internal character table
    0x0003,          // number of entries
    0x005F,  // low line
    0x31A0,
    0x007E,  // tilde
    0x31A8,
    0x00AF,  // macron
    0x31B0,
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x31A0:
    //   prefix:
    //     Dead<combining diaeresis>
    //     Compose
    //     <low line>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0055,  // capital u
    0x1E7A,  // -> capital u with macron and diaeresis
    0x0075,  // letter u
    0x1E7B,  // -> letter u with macron and diaeresis
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x31A8:
    //   prefix:
    //     Dead<combining diaeresis>
    //     Compose
    //     <tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x1E4E,  // -> capital o with tilde and diaeresis
    0x006F,  // letter o
    0x1E4F,  // -> letter o with tilde and diaeresis
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x31B0:
    //   prefix:
    //     Dead<combining diaeresis>
    //     Compose
    //     <macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0055,  // capital u
    0x1E7A,  // -> capital u with macron and diaeresis
    0x0075,  // letter u
    0x1E7B,  // -> letter u with macron and diaeresis
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x31B8:
    //   prefix:
    //     Dead<combining diaeresis>
    //     Dead<combining grave accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0055,  // capital u
    0x01DB,  // -> capital u with diaeresis and grave
    0x0075,  // letter u
    0x01DC,  // -> letter u with diaeresis and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x31C0:
    //   prefix:
    //     Dead<combining diaeresis>
    //     Dead<combining acute accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0007,          // number of entries
    0x0020,  // space
    0x0385,  // -> dialytika tonos
    0x0049,  // capital i
    0x1E2E,  // -> capital i with diaeresis and acute
    0x0055,  // capital u
    0x01D7,  // -> capital u with diaeresis and acute
    0x0069,  // letter i
    0x1E2F,  // -> letter i with diaeresis and acute
    0x0075,  // letter u
    0x01D8,  // -> letter u with diaeresis and acute
    0x03B9,  // letter iota
    0x0390,  // -> letter iota with dialytika and tonos
    0x03C5,  // letter upsilon
    0x03B0,  // -> letter upsilon with dialytika and tonos
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x31D2:
    //   prefix:
    //     Dead<combining diaeresis>
    //     Dead<combining tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x1E4E,  // -> capital o with tilde and diaeresis
    0x006F,  // letter o
    0x1E4F,  // -> letter o with tilde and diaeresis
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x31DA:
    //   prefix:
    //     Dead<combining diaeresis>
    //     Dead<combining macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x01DE,  // -> capital a with diaeresis and macron
    0x004F,  // capital o
    0x022A,  // -> capital o with diaeresis and macron
    0x0055,  // capital u
    0x1E7A,  // -> capital u with macron and diaeresis
    0x0061,  // letter a
    0x01DF,  // -> letter a with diaeresis and macron
    0x006F,  // letter o
    0x022B,  // -> letter o with diaeresis and macron
    0x0075,  // letter u
    0x1E7B,  // -> letter u with macron and diaeresis
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x31EA:
    //   prefix:
    //     Dead<combining diaeresis>
    //     Dead<combining caron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0055,  // capital u
    0x01D9,  // -> capital u with diaeresis and caron
    0x0075,  // letter u
    0x01DA,  // -> letter u with diaeresis and caron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x31F2:
    //   prefix:
    //     Dead<combining hook above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x003B,          // number of entries
    0x0020,  // space
    0x0309,  // -> combining hook above
    0x0041,  // capital a
    0x1EA2,  // -> capital a with hook above
    0x0042,  // capital b
    0x0181,  // -> capital b with hook
    0x0043,  // capital c
    0x0187,  // -> capital c with hook
    0x0044,  // capital d
    0x018A,  // -> capital d with hook
    0x0045,  // capital e
    0x1EBA,  // -> capital e with hook above
    0x0046,  // capital f
    0x0191,  // -> capital f with hook
    0x0047,  // capital g
    0x0193,  // -> capital g with hook
    0x0049,  // capital i
    0x1EC8,  // -> capital i with hook above
    0x004B,  // capital k
    0x0198,  // -> capital k with hook
    0x004D,  // capital m
    0x2C6E,  // -> capital m with hook
    0x004E,  // capital n
    0x019D,  // -> capital n with left hook
    0x004F,  // capital o
    0x1ECE,  // -> capital o with hook above
    0x0050,  // capital p
    0x01A4,  // -> capital p with hook
    0x0054,  // capital t
    0x01AC,  // -> capital t with hook
    0x0055,  // capital u
    0x1EE6,  // -> capital u with hook above
    0x0056,  // capital v
    0x01B2,  // -> capital v with hook
    0x0057,  // capital w
    0x2C72,  // -> capital w with hook
    0x0059,  // capital y
    0x1EF6,  // -> capital y with hook above
    0x005A,  // capital z
    0x0224,  // -> capital z with hook
    0x0061,  // letter a
    0x1EA3,  // -> letter a with hook above
    0x0062,  // letter b
    0x0253,  // -> letter b with hook
    0x0063,  // letter c
    0x0188,  // -> letter c with hook
    0x0064,  // letter d
    0x0257,  // -> letter d with hook
    0x0065,  // letter e
    0x1EBB,  // -> letter e with hook above
    0x0066,  // letter f
    0x0192,  // -> letter f with hook
    0x0067,  // letter g
    0x0260,  // -> letter g with hook
    0x0068,  // letter h
    0x0266,  // -> letter h with hook
    0x0069,  // letter i
    0x1EC9,  // -> letter i with hook above
    0x006B,  // letter k
    0x0199,  // -> letter k with hook
    0x006D,  // letter m
    0x0271,  // -> letter m with hook
    0x006E,  // letter n
    0x0272,  // -> letter n with left hook
    0x006F,  // letter o
    0x1ECF,  // -> letter o with hook above
    0x0070,  // letter p
    0x01A5,  // -> letter p with hook
    0x0071,  // letter q
    0x02A0,  // -> letter q with hook
    0x0073,  // letter s
    0x0282,  // -> letter s with hook
    0x0074,  // letter t
    0x01AD,  // -> letter t with hook
    0x0075,  // letter u
    0x1EE7,  // -> letter u with hook above
    0x0076,  // letter v
    0x028B,  // -> letter v with hook
    0x0077,  // letter w
    0x2C73,  // -> letter w with hook
    0x0079,  // letter y
    0x1EF7,  // -> letter y with hook above
    0x007A,  // letter z
    0x0225,  // -> letter z with hook
    0x00A0,  // no-break space
    0x0309,  // -> combining hook above
    0x00C2,  // capital a with circumflex
    0x1EA8,  // -> capital a with circumflex and hook above
    0x00CA,  // capital e with circumflex
    0x1EC2,  // -> capital e with circumflex and hook above
    0x00D4,  // capital o with circumflex
    0x1ED4,  // -> capital o with circumflex and hook above
    0x00E2,  // letter a with circumflex
    0x1EA9,  // -> letter a with circumflex and hook above
    0x00EA,  // letter e with circumflex
    0x1EC3,  // -> letter e with circumflex and hook above
    0x00F4,  // letter o with circumflex
    0x1ED5,  // -> letter o with circumflex and hook above
    0x0102,  // capital a with breve
    0x1EB2,  // -> capital a with breve and hook above
    0x0103,  // letter a with breve
    0x1EB3,  // -> letter a with breve and hook above
    0x0104,  // capital a with ogonek
    0x1EDF,  // -> letter o with horn and hook above
    0x017B,  // capital z with dot above
    0x1EEC,  // -> capital u with horn and hook above
    0x01A0,  // capital o with horn
    0x1EDE,  // -> capital o with horn and hook above
    0x01B0,  // letter u with horn
    0x1EED,  // -> letter u with horn and hook above
    0x0256,  // letter d with tail
    0x1D91,  // -> letter d with hook and tail
    0x025C,  // letter reversed open e
    0x025D,  // -> letter reversed open e with hook
    0x025F,  // letter dotless j with stroke
    0x0284,  // -> letter dotless j with stroke and hook
    0x0279,  // letter turned r
    0x027B,  // -> letter turned r with hook
    //   internal dead_key table
    0x0004,          // number of entries
    0x0000,  // U+0000
    0x3276,
    0x0302,  // combining circumflex accent
    0x32AE,
    0x0306,  // combining breve
    0x32BE,
    0x031B,  // combining horn
    0x32C6,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x0309,  // combining hook above
    0x0309,  // -> combining hook above

    // offset 0x3276:
    //   prefix:
    //     Dead<combining hook above>
    //     Compose
    //   internal character table
    0x0004,          // number of entries
    0x002B,  // plus sign
    0x3282,
    0x0055,  // capital u
    0x328E,
    0x005E,  // circumflex accent
    0x3296,
    0x0062,  // letter b
    0x32A6,
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3282:
    //   prefix:
    //     Dead<combining hook above>
    //     Compose
    //     <plus sign>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EDE,  // -> capital o with horn and hook above
    0x0055,  // capital u
    0x1EEC,  // -> capital u with horn and hook above
    0x006F,  // letter o
    0x1EDF,  // -> letter o with horn and hook above
    0x0075,  // letter u
    0x1EED,  // -> letter u with horn and hook above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x328E:
    //   prefix:
    //     Dead<combining hook above>
    //     Compose
    //     <latin capital letter u>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB2,  // -> capital a with breve and hook above
    0x0061,  // letter a
    0x1EB3,  // -> letter a with breve and hook above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3296:
    //   prefix:
    //     Dead<combining hook above>
    //     Compose
    //     <circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EA8,  // -> capital a with circumflex and hook above
    0x0045,  // capital e
    0x1EC2,  // -> capital e with circumflex and hook above
    0x004F,  // capital o
    0x1ED4,  // -> capital o with circumflex and hook above
    0x0061,  // letter a
    0x1EA9,  // -> letter a with circumflex and hook above
    0x0065,  // letter e
    0x1EC3,  // -> letter e with circumflex and hook above
    0x006F,  // letter o
    0x1ED5,  // -> letter o with circumflex and hook above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x32A6:
    //   prefix:
    //     Dead<combining hook above>
    //     Compose
    //     <latin small letter b>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB2,  // -> capital a with breve and hook above
    0x0061,  // letter a
    0x1EB3,  // -> letter a with breve and hook above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x32AE:
    //   prefix:
    //     Dead<combining hook above>
    //     Dead<combining circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EA8,  // -> capital a with circumflex and hook above
    0x0045,  // capital e
    0x1EC2,  // -> capital e with circumflex and hook above
    0x004F,  // capital o
    0x1ED4,  // -> capital o with circumflex and hook above
    0x0061,  // letter a
    0x1EA9,  // -> letter a with circumflex and hook above
    0x0065,  // letter e
    0x1EC3,  // -> letter e with circumflex and hook above
    0x006F,  // letter o
    0x1ED5,  // -> letter o with circumflex and hook above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x32BE:
    //   prefix:
    //     Dead<combining hook above>
    //     Dead<combining breve>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB2,  // -> capital a with breve and hook above
    0x0061,  // letter a
    0x1EB3,  // -> letter a with breve and hook above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x32C6:
    //   prefix:
    //     Dead<combining hook above>
    //     Dead<combining horn>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EDE,  // -> capital o with horn and hook above
    0x0055,  // capital u
    0x1EEC,  // -> capital u with horn and hook above
    0x006F,  // letter o
    0x1EDF,  // -> letter o with horn and hook above
    0x0075,  // letter u
    0x1EED,  // -> letter u with horn and hook above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x32D2:
    //   prefix:
    //     Dead<combining ring above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000A,          // number of entries
    0x0020,  // space
    0x00B0,  // -> degree sign
    0x0041,  // capital a
    0x00C5,  // -> capital a with ring above
    0x0055,  // capital u
    0x016E,  // -> capital u with ring above
    0x0061,  // letter a
    0x00E5,  // -> letter a with ring above
    0x0075,  // letter u
    0x016F,  // -> letter u with ring above
    0x0077,  // letter w
    0x1E98,  // -> letter w with ring above
    0x0079,  // letter y
    0x1E99,  // -> letter y with ring above
    0x00A0,  // no-break space
    0x030A,  // -> combining ring above
    0x00C1,  // capital a with acute
    0x01FA,  // -> capital a with ring above and acute
    0x00E1,  // letter a with acute
    0x01FB,  // -> letter a with ring above and acute
    //   internal dead_key table
    0x0001,          // number of entries
    0x0301,  // combining acute accent
    0x32EE,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x030A,  // combining ring above
    0x00B0,  // -> degree sign

    // offset 0x32EE:
    //   prefix:
    //     Dead<combining ring above>
    //     Dead<combining acute accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x01FA,  // -> capital a with ring above and acute
    0x0061,  // letter a
    0x01FB,  // -> letter a with ring above and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x32F6:
    //   prefix:
    //     Dead<combining double acute accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0008,          // number of entries
    0x0020,  // space
    0x02DD,  // -> double acute accent
    0x004F,  // capital o
    0x0150,  // -> capital o with double acute
    0x0055,  // capital u
    0x0170,  // -> capital u with double acute
    0x006F,  // letter o
    0x0151,  // -> letter o with double acute
    0x0075,  // letter u
    0x0171,  // -> letter u with double acute
    0x00A0,  // no-break space
    0x030B,  // -> combining double acute accent
    0x0423,  // cyrillic capital u
    0x04F2,  // -> cyrillic capital u with double acute
    0x0443,  // cyrillic small u
    0x04F3,  // -> cyrillic small u with double acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0001,          // number of entries
    0x030B,  // combining double acute accent
    0x02DD,  // -> double acute accent

    // offset 0x330C:
    //   prefix:
    //     Dead<combining caron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0039,          // number of entries
    0x0020,  // space
    0x02C7,  // -> caron
    0x0028,  // left parenthesis
    0x208D,  // -> subscript left parenthesis
    0x0029,  // right parenthesis
    0x208E,  // -> subscript right parenthesis
    0x002B,  // plus sign
    0x208A,  // -> subscript plus sign
    0x002D,  // hyphen-minus
    0x208B,  // -> subscript minus
    0x0030,  // digit zero
    0x2080,  // -> subscript zero
    0x0031,  // digit one
    0x2081,  // -> subscript one
    0x0032,  // digit two
    0x2082,  // -> subscript two
    0x0033,  // digit three
    0x2083,  // -> subscript three
    0x0034,  // digit four
    0x2084,  // -> subscript four
    0x0035,  // digit five
    0x2085,  // -> subscript five
    0x0036,  // digit six
    0x2086,  // -> subscript six
    0x0037,  // digit seven
    0x2087,  // -> subscript seven
    0x0038,  // digit eight
    0x2088,  // -> subscript eight
    0x0039,  // digit nine
    0x2089,  // -> subscript nine
    0x003D,  // equals sign
    0x208C,  // -> subscript equals sign
    0x0041,  // capital a
    0x01CD,  // -> capital a with caron
    0x0043,  // capital c
    0x010C,  // -> capital c with caron
    0x0044,  // capital d
    0x010E,  // -> capital d with caron
    0x0045,  // capital e
    0x011A,  // -> capital e with caron
    0x0047,  // capital g
    0x01E6,  // -> capital g with caron
    0x0048,  // capital h
    0x021E,  // -> capital h with caron
    0x0049,  // capital i
    0x01CF,  // -> capital i with caron
    0x004B,  // capital k
    0x01E8,  // -> capital k with caron
    0x004C,  // capital l
    0x013D,  // -> capital l with caron
    0x004E,  // capital n
    0x0147,  // -> capital n with caron
    0x004F,  // capital o
    0x01D1,  // -> capital o with caron
    0x0052,  // capital r
    0x0158,  // -> capital r with caron
    0x0053,  // capital s
    0x0160,  // -> capital s with caron
    0x0054,  // capital t
    0x0164,  // -> capital t with caron
    0x0055,  // capital u
    0x01D3,  // -> capital u with caron
    0x0056,  // capital v
    0x01D9,  // -> capital u with diaeresis and caron
    0x005A,  // capital z
    0x017D,  // -> capital z with caron
    0x0061,  // letter a
    0x01CE,  // -> letter a with caron
    0x0063,  // letter c
    0x010D,  // -> letter c with caron
    0x0064,  // letter d
    0x010F,  // -> letter d with caron
    0x0065,  // letter e
    0x011B,  // -> letter e with caron
    0x0067,  // letter g
    0x01E7,  // -> letter g with caron
    0x0068,  // letter h
    0x021F,  // -> letter h with caron
    0x0069,  // letter i
    0x01D0,  // -> letter i with caron
    0x006A,  // letter j
    0x01F0,  // -> letter j with caron
    0x006B,  // letter k
    0x01E9,  // -> letter k with caron
    0x006C,  // letter l
    0x013E,  // -> letter l with caron
    0x006E,  // letter n
    0x0148,  // -> letter n with caron
    0x006F,  // letter o
    0x01D2,  // -> letter o with caron
    0x0072,  // letter r
    0x0159,  // -> letter r with caron
    0x0073,  // letter s
    0x0161,  // -> letter s with caron
    0x0074,  // letter t
    0x0165,  // -> letter t with caron
    0x0075,  // letter u
    0x01D4,  // -> letter u with caron
    0x0076,  // letter v
    0x01DA,  // -> letter u with diaeresis and caron
    0x007A,  // letter z
    0x017E,  // -> letter z with caron
    0x00A0,  // no-break space
    0x030C,  // -> combining caron
    0x00DC,  // capital u with diaeresis
    0x01D9,  // -> capital u with diaeresis and caron
    0x00FC,  // letter u with diaeresis
    0x01DA,  // -> letter u with diaeresis and caron
    0x0148,  // letter n with caron
    0x01C5,  // -> capital d with small z with caron
    0x0292,  // letter ezh
    0x01EF,  // -> letter ezh with caron
    0x02C7,  // caron
    0x01EE,  // -> capital ezh with caron
    //   internal dead_key table
    0x0003,          // number of entries
    0x0000,  // U+0000
    0x338A,
    0x0307,  // combining dot above
    0x3398,
    0x0308,  // combining diaeresis
    0x33A0,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x030C,  // combining caron
    0x02C7,  // -> caron

    // offset 0x338A:
    //   prefix:
    //     Dead<combining caron>
    //     Compose
    //   internal character table
    0x0001,          // number of entries
    0x0022,  // quotation mark
    0x3390,
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3390:
    //   prefix:
    //     Dead<combining caron>
    //     Compose
    //     <quotation mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0055,  // capital u
    0x01D9,  // -> capital u with diaeresis and caron
    0x0075,  // letter u
    0x01DA,  // -> letter u with diaeresis and caron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3398:
    //   prefix:
    //     Dead<combining caron>
    //     Dead<combining dot above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0053,  // capital s
    0x1E66,  // -> capital s with caron and dot above
    0x0073,  // letter s
    0x1E67,  // -> letter s with caron and dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x33A0:
    //   prefix:
    //     Dead<combining caron>
    //     Dead<combining diaeresis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0055,  // capital u
    0x01D9,  // -> capital u with diaeresis and caron
    0x0075,  // letter u
    0x01DA,  // -> letter u with diaeresis and caron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x33A8:
    //   prefix:
    //     Dead<combining double grave accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000E,          // number of entries
    0x0041,  // capital a
    0x0200,  // -> capital a with double grave
    0x0045,  // capital e
    0x0204,  // -> capital e with double grave
    0x0049,  // capital i
    0x0208,  // -> capital i with double grave
    0x004F,  // capital o
    0x020C,  // -> capital o with double grave
    0x0052,  // capital r
    0x0210,  // -> capital r with double grave
    0x0055,  // capital u
    0x0214,  // -> capital u with double grave
    0x0061,  // letter a
    0x0201,  // -> letter a with double grave
    0x0065,  // letter e
    0x0205,  // -> letter e with double grave
    0x0069,  // letter i
    0x0209,  // -> letter i with double grave
    0x006F,  // letter o
    0x020D,  // -> letter o with double grave
    0x0072,  // letter r
    0x0211,  // -> letter r with double grave
    0x0075,  // letter u
    0x0215,  // -> letter u with double grave
    0x0474,  // cyrillic capital izhitsa
    0x0476,  // -> cyrillic capital izhitsa with double grave accent
    0x0475,  // cyrillic small izhitsa
    0x0477,  // -> cyrillic small izhitsa with double grave accent
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x33C8:
    //   prefix:
    //     Dead<combining inverted breve>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000C,          // number of entries
    0x0041,  // capital a
    0x0202,  // -> capital a with inverted breve
    0x0045,  // capital e
    0x0206,  // -> capital e with inverted breve
    0x0049,  // capital i
    0x020A,  // -> capital i with inverted breve
    0x004F,  // capital o
    0x020E,  // -> capital o with inverted breve
    0x0052,  // capital r
    0x0212,  // -> capital r with inverted breve
    0x0055,  // capital u
    0x0216,  // -> capital u with inverted breve
    0x0061,  // letter a
    0x0203,  // -> letter a with inverted breve
    0x0065,  // letter e
    0x0207,  // -> letter e with inverted breve
    0x0069,  // letter i
    0x020B,  // -> letter i with inverted breve
    0x006F,  // letter o
    0x020F,  // -> letter o with inverted breve
    0x0072,  // letter r
    0x0213,  // -> letter r with inverted breve
    0x0075,  // letter u
    0x0217,  // -> letter u with inverted breve
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x33E4:
    //   prefix:
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000E,          // number of entries
    0x0391,  // capital alpha
    0x1F08,  // -> capital alpha with psili
    0x0395,  // capital epsilon
    0x1F18,  // -> capital epsilon with psili
    0x0397,  // capital eta
    0x1F28,  // -> capital eta with psili
    0x0399,  // capital iota
    0x1F38,  // -> capital iota with psili
    0x039F,  // capital omicron
    0x1F48,  // -> capital omicron with psili
    0x03A9,  // capital omega
    0x1F68,  // -> capital omega with psili
    0x03B1,  // letter alpha
    0x1F00,  // -> letter alpha with psili
    0x03B5,  // letter epsilon
    0x1F10,  // -> letter epsilon with psili
    0x03B7,  // letter eta
    0x1F20,  // -> letter eta with psili
    0x03B9,  // letter iota
    0x1F30,  // -> letter iota with psili
    0x03BF,  // letter omicron
    0x1F40,  // -> letter omicron with psili
    0x03C1,  // letter rho
    0x1FE4,  // -> letter rho with psili
    0x03C5,  // letter upsilon
    0x1F50,  // -> letter upsilon with psili
    0x03C9,  // letter omega
    0x1F60,  // -> letter omega with psili
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3404:
    //   prefix:
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0010,          // number of entries
    0x0391,  // capital alpha
    0x1F09,  // -> capital alpha with dasia
    0x0395,  // capital epsilon
    0x1F19,  // -> capital epsilon with dasia
    0x0397,  // capital eta
    0x1F29,  // -> capital eta with dasia
    0x0399,  // capital iota
    0x1F39,  // -> capital iota with dasia
    0x039F,  // capital omicron
    0x1F49,  // -> capital omicron with dasia
    0x03A1,  // capital rho
    0x1FEC,  // -> capital rho with dasia
    0x03A5,  // capital upsilon
    0x1F59,  // -> capital upsilon with dasia
    0x03A9,  // capital omega
    0x1F69,  // -> capital omega with dasia
    0x03B1,  // letter alpha
    0x1F01,  // -> letter alpha with dasia
    0x03B5,  // letter epsilon
    0x1F11,  // -> letter epsilon with dasia
    0x03B7,  // letter eta
    0x1F21,  // -> letter eta with dasia
    0x03B9,  // letter iota
    0x1F31,  // -> letter iota with dasia
    0x03BF,  // letter omicron
    0x1F41,  // -> letter omicron with dasia
    0x03C1,  // letter rho
    0x1FE5,  // -> letter rho with dasia
    0x03C5,  // letter upsilon
    0x1F51,  // -> letter upsilon with dasia
    0x03C9,  // letter omega
    0x1F61,  // -> letter omega with dasia
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3428:
    //   prefix:
    //     Dead<combining horn>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0012,          // number of entries
    0x0020,  // space
    0x031B,  // -> combining horn
    0x004F,  // capital o
    0x01A0,  // -> capital o with horn
    0x0055,  // capital u
    0x01AF,  // -> capital u with horn
    0x006F,  // letter o
    0x01A1,  // -> letter o with horn
    0x0075,  // letter u
    0x01B0,  // -> letter u with horn
    0x00A0,  // no-break space
    0x031B,  // -> combining horn
    0x00D2,  // capital o with grave
    0x1EDC,  // -> capital o with horn and grave
    0x00D3,  // capital o with acute
    0x1EDA,  // -> capital o with horn and acute
    0x00D5,  // capital o with tilde
    0x1EE0,  // -> capital o with horn and tilde
    0x00D9,  // capital u with grave
    0x1EEA,  // -> capital u with horn and grave
    0x00DA,  // capital u with acute
    0x1EE8,  // -> capital u with horn and acute
    0x00F2,  // letter o with grave
    0x1EDD,  // -> letter o with horn and grave
    0x00F3,  // letter o with acute
    0x1EDB,  // -> letter o with horn and acute
    0x00F5,  // letter o with tilde
    0x1EE1,  // -> letter o with horn and tilde
    0x00F9,  // letter u with grave
    0x1EEB,  // -> letter u with horn and grave
    0x00FA,  // letter u with acute
    0x1EE9,  // -> letter u with horn and acute
    0x0168,  // capital u with tilde
    0x1EEE,  // -> capital u with horn and tilde
    0x0169,  // letter u with tilde
    0x1EEF,  // -> letter u with horn and tilde
    //   internal dead_key table
    0x0005,          // number of entries
    0x0300,  // combining grave accent
    0x345C,
    0x0301,  // combining acute accent
    0x3468,
    0x0303,  // combining tilde
    0x3474,
    0x0309,  // combining hook above
    0x3480,
    0x0323,  // combining dot below
    0x348C,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x031B,  // combining horn
    0x031B,  // -> combining horn

    // offset 0x345C:
    //   prefix:
    //     Dead<combining horn>
    //     Dead<combining grave accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EDC,  // -> capital o with horn and grave
    0x0055,  // capital u
    0x1EEA,  // -> capital u with horn and grave
    0x006F,  // letter o
    0x1EDD,  // -> letter o with horn and grave
    0x0075,  // letter u
    0x1EEB,  // -> letter u with horn and grave
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3468:
    //   prefix:
    //     Dead<combining horn>
    //     Dead<combining acute accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EDA,  // -> capital o with horn and acute
    0x0055,  // capital u
    0x1EE8,  // -> capital u with horn and acute
    0x006F,  // letter o
    0x1EDB,  // -> letter o with horn and acute
    0x0075,  // letter u
    0x1EE9,  // -> letter u with horn and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3474:
    //   prefix:
    //     Dead<combining horn>
    //     Dead<combining tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EE0,  // -> capital o with horn and tilde
    0x0055,  // capital u
    0x1EEE,  // -> capital u with horn and tilde
    0x006F,  // letter o
    0x1EE1,  // -> letter o with horn and tilde
    0x0075,  // letter u
    0x1EEF,  // -> letter u with horn and tilde
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3480:
    //   prefix:
    //     Dead<combining horn>
    //     Dead<combining hook above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EDE,  // -> capital o with horn and hook above
    0x0055,  // capital u
    0x1EEC,  // -> capital u with horn and hook above
    0x006F,  // letter o
    0x1EDF,  // -> letter o with horn and hook above
    0x0075,  // letter u
    0x1EED,  // -> letter u with horn and hook above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x348C:
    //   prefix:
    //     Dead<combining horn>
    //     Dead<combining dot below>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EE2,  // -> capital o with horn and dot below
    0x0055,  // capital u
    0x1EF0,  // -> capital u with horn and dot below
    0x006F,  // letter o
    0x1EE3,  // -> letter o with horn and dot below
    0x0075,  // letter u
    0x1EF1,  // -> letter u with horn and dot below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3498:
    //   prefix:
    //     Dead<combining dot below>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0037,          // number of entries
    0x0020,  // space
    0x0323,  // -> combining dot below
    0x002B,  // plus sign
    0x2A25,  // -> plus sign with dot below
    0x002D,  // hyphen-minus
    0x2A2A,  // -> minus sign with dot below
    0x003D,  // equals sign
    0x2A66,  // -> equals sign with dot below
    0x0041,  // capital a
    0x1EA0,  // -> capital a with dot below
    0x0042,  // capital b
    0x1E04,  // -> capital b with dot below
    0x0044,  // capital d
    0x1E0C,  // -> capital d with dot below
    0x0045,  // capital e
    0x1EB8,  // -> capital e with dot below
    0x0048,  // capital h
    0x1E24,  // -> capital h with dot below
    0x0049,  // capital i
    0x1ECA,  // -> capital i with dot below
    0x004B,  // capital k
    0x1E32,  // -> capital k with dot below
    0x004C,  // capital l
    0x1E36,  // -> capital l with dot below
    0x004D,  // capital m
    0x1E42,  // -> capital m with dot below
    0x004E,  // capital n
    0x1E46,  // -> capital n with dot below
    0x004F,  // capital o
    0x1ECC,  // -> capital o with dot below
    0x0052,  // capital r
    0x1E5A,  // -> capital r with dot below
    0x0053,  // capital s
    0x1E62,  // -> capital s with dot below
    0x0054,  // capital t
    0x1E6C,  // -> capital t with dot below
    0x0055,  // capital u
    0x1EE4,  // -> capital u with dot below
    0x0056,  // capital v
    0x1E7E,  // -> capital v with dot below
    0x0057,  // capital w
    0x1E88,  // -> capital w with dot below
    0x0059,  // capital y
    0x1EF4,  // -> capital y with dot below
    0x005A,  // capital z
    0x1E92,  // -> capital z with dot below
    0x0061,  // letter a
    0x1EA1,  // -> letter a with dot below
    0x0062,  // letter b
    0x1E05,  // -> letter b with dot below
    0x0064,  // letter d
    0x1E0D,  // -> letter d with dot below
    0x0065,  // letter e
    0x1EB9,  // -> letter e with dot below
    0x0068,  // letter h
    0x1E25,  // -> letter h with dot below
    0x0069,  // letter i
    0x1ECB,  // -> letter i with dot below
    0x006B,  // letter k
    0x1E33,  // -> letter k with dot below
    0x006C,  // letter l
    0x1E37,  // -> letter l with dot below
    0x006D,  // letter m
    0x1E43,  // -> letter m with dot below
    0x006E,  // letter n
    0x1E47,  // -> letter n with dot below
    0x006F,  // letter o
    0x1ECD,  // -> letter o with dot below
    0x0072,  // letter r
    0x1E5B,  // -> letter r with dot below
    0x0073,  // letter s
    0x1E63,  // -> letter s with dot below
    0x0074,  // letter t
    0x1E6D,  // -> letter t with dot below
    0x0075,  // letter u
    0x1EE5,  // -> letter u with dot below
    0x0076,  // letter v
    0x1E7F,  // -> letter v with dot below
    0x0077,  // letter w
    0x1E89,  // -> letter w with dot below
    0x0079,  // letter y
    0x1EF5,  // -> letter y with dot below
    0x007A,  // letter z
    0x1E93,  // -> letter z with dot below
    0x00A0,  // no-break space
    0x0323,  // -> combining dot below
    0x00C2,  // capital a with circumflex
    0x1EAC,  // -> capital a with circumflex and dot below
    0x00CA,  // capital e with circumflex
    0x1EC6,  // -> capital e with circumflex and dot below
    0x00D4,  // capital o with circumflex
    0x1ED8,  // -> capital o with circumflex and dot below
    0x00E2,  // letter a with circumflex
    0x1EAD,  // -> letter a with circumflex and dot below
    0x00EA,  // letter e with circumflex
    0x1EC7,  // -> letter e with circumflex and dot below
    0x00F4,  // letter o with circumflex
    0x1ED9,  // -> letter o with circumflex and dot below
    0x0102,  // capital a with breve
    0x1EB6,  // -> capital a with breve and dot below
    0x0103,  // letter a with breve
    0x1EB7,  // -> letter a with breve and dot below
    0x0104,  // capital a with ogonek
    0x1EE3,  // -> letter o with horn and dot below
    0x017B,  // capital z with dot above
    0x1EF0,  // -> capital u with horn and dot below
    0x01A0,  // capital o with horn
    0x1EE2,  // -> capital o with horn and dot below
    0x01B0,  // letter u with horn
    0x1EF1,  // -> letter u with horn and dot below
    //   internal dead_key table
    0x0006,          // number of entries
    0x0000,  // U+0000
    0x3518,
    0x0302,  // combining circumflex accent
    0x352A,
    0x0304,  // combining macron
    0x353A,
    0x0306,  // combining breve
    0x3546,
    0x0307,  // combining dot above
    0x354E,
    0x031B,  // combining horn
    0x3556,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x0323,  // combining dot below
    0x0323,  // -> combining dot below

    // offset 0x3518:
    //   prefix:
    //     Dead<combining dot below>
    //     Compose
    //   internal character table
    0x0001,          // number of entries
    0x002B,  // plus sign
    0x351E,
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x351E:
    //   prefix:
    //     Dead<combining dot below>
    //     Compose
    //     <plus sign>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EE2,  // -> capital o with horn and dot below
    0x0055,  // capital u
    0x1EF0,  // -> capital u with horn and dot below
    0x006F,  // letter o
    0x1EE3,  // -> letter o with horn and dot below
    0x0075,  // letter u
    0x1EF1,  // -> letter u with horn and dot below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x352A:
    //   prefix:
    //     Dead<combining dot below>
    //     Dead<combining circumflex accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0041,  // capital a
    0x1EAC,  // -> capital a with circumflex and dot below
    0x0045,  // capital e
    0x1EC6,  // -> capital e with circumflex and dot below
    0x004F,  // capital o
    0x1ED8,  // -> capital o with circumflex and dot below
    0x0061,  // letter a
    0x1EAD,  // -> letter a with circumflex and dot below
    0x0065,  // letter e
    0x1EC7,  // -> letter e with circumflex and dot below
    0x006F,  // letter o
    0x1ED9,  // -> letter o with circumflex and dot below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x353A:
    //   prefix:
    //     Dead<combining dot below>
    //     Dead<combining macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004C,  // capital l
    0x1E38,  // -> capital l with dot below and macron
    0x0052,  // capital r
    0x1E5C,  // -> capital r with dot below and macron
    0x006C,  // letter l
    0x1E39,  // -> letter l with dot below and macron
    0x0072,  // letter r
    0x1E5D,  // -> letter r with dot below and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3546:
    //   prefix:
    //     Dead<combining dot below>
    //     Dead<combining breve>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0041,  // capital a
    0x1EB6,  // -> capital a with breve and dot below
    0x0061,  // letter a
    0x1EB7,  // -> letter a with breve and dot below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x354E:
    //   prefix:
    //     Dead<combining dot below>
    //     Dead<combining dot above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0053,  // capital s
    0x1E68,  // -> capital s with dot below and dot above
    0x0073,  // letter s
    0x1E69,  // -> letter s with dot below and dot above
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3556:
    //   prefix:
    //     Dead<combining dot below>
    //     Dead<combining horn>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0004,          // number of entries
    0x004F,  // capital o
    0x1EE2,  // -> capital o with horn and dot below
    0x0055,  // capital u
    0x1EF0,  // -> capital u with horn and dot below
    0x006F,  // letter o
    0x1EE3,  // -> letter o with horn and dot below
    0x0075,  // letter u
    0x1EF1,  // -> letter u with horn and dot below
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3562:
    //   prefix:
    //     Dead<combining cedilla>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x001D,          // number of entries
    0x0020,  // space
    0x00B8,  // -> cedilla
    0x0043,  // capital c
    0x00C7,  // -> capital c with cedilla
    0x0044,  // capital d
    0x1E10,  // -> capital d with cedilla
    0x0045,  // capital e
    0x0228,  // -> capital e with cedilla
    0x0047,  // capital g
    0x0122,  // -> capital g with cedilla
    0x0048,  // capital h
    0x1E28,  // -> capital h with cedilla
    0x004B,  // capital k
    0x0136,  // -> capital k with cedilla
    0x004C,  // capital l
    0x013B,  // -> capital l with cedilla
    0x004E,  // capital n
    0x0145,  // -> capital n with cedilla
    0x0052,  // capital r
    0x0156,  // -> capital r with cedilla
    0x0053,  // capital s
    0x015E,  // -> capital s with cedilla
    0x0054,  // capital t
    0x0162,  // -> capital t with cedilla
    0x0063,  // letter c
    0x00E7,  // -> letter c with cedilla
    0x0064,  // letter d
    0x1E11,  // -> letter d with cedilla
    0x0065,  // letter e
    0x0229,  // -> letter e with cedilla
    0x0067,  // letter g
    0x0123,  // -> letter g with cedilla
    0x0068,  // letter h
    0x1E29,  // -> letter h with cedilla
    0x006B,  // letter k
    0x0137,  // -> letter k with cedilla
    0x006C,  // letter l
    0x013C,  // -> letter l with cedilla
    0x006E,  // letter n
    0x0146,  // -> letter n with cedilla
    0x0072,  // letter r
    0x0157,  // -> letter r with cedilla
    0x0073,  // letter s
    0x015F,  // -> letter s with cedilla
    0x0074,  // letter t
    0x0163,  // -> letter t with cedilla
    0x00A0,  // no-break space
    0x0327,  // -> combining cedilla
    0x00A2,  // cent sign
    0x20B5,  // -> cedi sign
    0x0106,  // capital c with acute
    0x1E08,  // -> capital c with cedilla and acute
    0x0107,  // letter c with acute
    0x1E09,  // -> letter c with cedilla and acute
    0x0114,  // capital e with breve
    0x1E1C,  // -> capital e with cedilla and breve
    0x0115,  // letter e with breve
    0x1E1D,  // -> letter e with cedilla and breve
    //   internal dead_key table
    0x0002,          // number of entries
    0x0301,  // combining acute accent
    0x35A6,
    0x0306,  // combining breve
    0x35AE,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x0327,  // combining cedilla
    0x00B8,  // -> cedilla

    // offset 0x35A6:
    //   prefix:
    //     Dead<combining cedilla>
    //     Dead<combining acute accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0043,  // capital c
    0x1E08,  // -> capital c with cedilla and acute
    0x0063,  // letter c
    0x1E09,  // -> letter c with cedilla and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x35AE:
    //   prefix:
    //     Dead<combining cedilla>
    //     Dead<combining breve>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x0045,  // capital e
    0x1E1C,  // -> capital e with cedilla and breve
    0x0065,  // letter e
    0x1E1D,  // -> letter e with cedilla and breve
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x35B6:
    //   prefix:
    //     Dead<combining ogonek>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000E,          // number of entries
    0x0020,  // space
    0x02DB,  // -> ogonek
    0x0041,  // capital a
    0x0104,  // -> capital a with ogonek
    0x0045,  // capital e
    0x0118,  // -> capital e with ogonek
    0x0049,  // capital i
    0x012E,  // -> capital i with ogonek
    0x004F,  // capital o
    0x01EA,  // -> capital o with ogonek
    0x0055,  // capital u
    0x0172,  // -> capital u with ogonek
    0x0061,  // letter a
    0x0105,  // -> letter a with ogonek
    0x0065,  // letter e
    0x0119,  // -> letter e with ogonek
    0x0069,  // letter i
    0x012F,  // -> letter i with ogonek
    0x006F,  // letter o
    0x01EB,  // -> letter o with ogonek
    0x0075,  // letter u
    0x0173,  // -> letter u with ogonek
    0x00A0,  // no-break space
    0x0328,  // -> combining ogonek
    0x014C,  // capital o with macron
    0x01EC,  // -> capital o with ogonek and macron
    0x014D,  // letter o with macron
    0x01ED,  // -> letter o with ogonek and macron
    //   internal dead_key table
    0x0001,          // number of entries
    0x0304,  // combining macron
    0x35DA,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x0328,  // combining ogonek
    0x02DB,  // -> ogonek

    // offset 0x35DA:
    //   prefix:
    //     Dead<combining ogonek>
    //     Dead<combining macron>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x01EC,  // -> capital o with ogonek and macron
    0x006F,  // letter o
    0x01ED,  // -> letter o with ogonek and macron
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x35E2:
    //   prefix:
    //     Dead<combining long solidus overlay>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x002E,          // number of entries
    0x0020,  // space
    0x002F,  // -> solidus
    0x0032,  // digit two
    0x01BB,  // -> letter two with stroke
    0x003C,  // less-than sign
    0x226E,  // -> not less-than
    0x003D,  // equals sign
    0x2260,  // -> not equal to
    0x003E,  // greater-than sign
    0x226F,  // -> not greater-than
    0x0041,  // capital a
    0x023A,  // -> capital a with stroke
    0x0042,  // capital b
    0x0243,  // -> capital b with stroke
    0x0043,  // capital c
    0x023B,  // -> capital c with stroke
    0x0044,  // capital d
    0x0110,  // -> capital d with stroke
    0x0045,  // capital e
    0x0246,  // -> capital e with stroke
    0x0047,  // capital g
    0x01E4,  // -> capital g with stroke
    0x0048,  // capital h
    0x0126,  // -> capital h with stroke
    0x0049,  // capital i
    0x0197,  // -> capital i with stroke
    0x004A,  // capital j
    0x0248,  // -> capital j with stroke
    0x004C,  // capital l
    0x0141,  // -> capital l with stroke
    0x004F,  // capital o
    0x00D8,  // -> capital o with stroke
    0x0050,  // capital p
    0x2C63,  // -> capital p with stroke
    0x0052,  // capital r
    0x024C,  // -> capital r with stroke
    0x0054,  // capital t
    0x0166,  // -> capital t with stroke
    0x0055,  // capital u
    0x0244,  // -> capital u bar
    0x0059,  // capital y
    0x024E,  // -> capital y with stroke
    0x005A,  // capital z
    0x01B5,  // -> capital z with stroke
    0x0061,  // letter a
    0x2C65,  // -> letter a with stroke
    0x0062,  // letter b
    0x0180,  // -> letter b with stroke
    0x0063,  // letter c
    0x023C,  // -> letter c with stroke
    0x0064,  // letter d
    0x0111,  // -> letter d with stroke
    0x0065,  // letter e
    0x0247,  // -> letter e with stroke
    0x0067,  // letter g
    0x01E5,  // -> letter g with stroke
    0x0068,  // letter h
    0x0127,  // -> letter h with stroke
    0x0069,  // letter i
    0x0268,  // -> letter i with stroke
    0x006A,  // letter j
    0x0249,  // -> letter j with stroke
    0x006C,  // letter l
    0x0142,  // -> letter l with stroke
    0x006F,  // letter o
    0x00F8,  // -> letter o with stroke
    0x0070,  // letter p
    0x1D7D,  // -> letter p with stroke
    0x0072,  // letter r
    0x024D,  // -> letter r with stroke
    0x0074,  // letter t
    0x0167,  // -> letter t with stroke
    0x0075,  // letter u
    0x0289,  // -> letter u bar
    0x0079,  // letter y
    0x024F,  // -> letter y with stroke
    0x007A,  // letter z
    0x01B6,  // -> letter z with stroke
    0x00A0,  // no-break space
    0x0338,  // -> combining long solidus overlay
    0x00D3,  // capital o with acute
    0x01FE,  // -> capital o with stroke and acute
    0x00F3,  // letter o with acute
    0x01FF,  // -> letter o with stroke and acute
    0x0237,  // letter dotless j
    0x025F,  // -> letter dotless j with stroke
    0x0269,  // letter iota
    0x1D7C,  // -> letter iota with stroke
    0x2264,  // less-than or equal to
    0x2270,  // -> neither less-than nor equal to
    0x2265,  // greater-than or equal to
    0x2271,  // -> neither greater-than nor equal to
    //   internal dead_key table
    0x0002,          // number of entries
    0x0301,  // combining acute accent
    0x3648,
    0x0307,  // combining dot above
    0x3650,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x0338,  // combining long solidus overlay
    0x002F,  // -> solidus

    // offset 0x3648:
    //   prefix:
    //     Dead<combining long solidus overlay>
    //     Dead<combining acute accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0002,          // number of entries
    0x004F,  // capital o
    0x01FE,  // -> capital o with stroke and acute
    0x006F,  // letter o
    0x01FF,  // -> letter o with stroke and acute
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3650:
    //   prefix:
    //     Dead<combining long solidus overlay>
    //     Dead<combining dot above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0001,          // number of entries
    0x006A,  // letter j
    0x025F,  // -> letter dotless j with stroke
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3656:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0040,          // number of entries
    0x0020,  // space
    0x037A,  // -> ypogegrammeni
    0x0391,  // capital alpha
    0x1FBC,  // -> capital alpha with prosgegrammeni
    0x0397,  // capital eta
    0x1FCC,  // -> capital eta with prosgegrammeni
    0x03A9,  // capital omega
    0x1FFC,  // -> capital omega with prosgegrammeni
    0x03AC,  // letter alpha with tonos
    0x1FB4,  // -> letter alpha with oxia and ypogegrammeni
    0x03AE,  // letter eta with tonos
    0x1FC4,  // -> letter eta with oxia and ypogegrammeni
    0x03B1,  // letter alpha
    0x1FB3,  // -> letter alpha with ypogegrammeni
    0x03B7,  // letter eta
    0x1FC3,  // -> letter eta with ypogegrammeni
    0x03C9,  // letter omega
    0x1FF3,  // -> letter omega with ypogegrammeni
    0x03CE,  // letter omega with tonos
    0x1FF4,  // -> letter omega with oxia and ypogegrammeni
    0x1F00,  // letter alpha with psili
    0x1F80,  // -> letter alpha with psili and ypogegrammeni
    0x1F01,  // letter alpha with dasia
    0x1F81,  // -> letter alpha with dasia and ypogegrammeni
    0x1F02,  // letter alpha with psili and varia
    0x1F82,  // -> letter alpha with psili and varia and ypogegrammeni
    0x1F03,  // letter alpha with dasia and varia
    0x1F83,  // -> letter alpha with dasia and varia and ypogegrammeni
    0x1F04,  // letter alpha with psili and oxia
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x1F05,  // letter alpha with dasia and oxia
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x1F06,  // letter alpha with psili and perispomeni
    0x1F86,  // -> letter alpha with psili and perispomeni and ypogegrammeni
    0x1F07,  // letter alpha with dasia and perispomeni
    0x1F87,  // -> letter alpha with dasia and perispomeni and ypogegrammeni
    0x1F08,  // capital alpha with psili
    0x1F88,  // -> capital alpha with psili and prosgegrammeni
    0x1F09,  // capital alpha with dasia
    0x1F89,  // -> capital alpha with dasia and prosgegrammeni
    0x1F0A,  // capital alpha with psili and varia
    0x1F8A,  // -> capital alpha with psili and varia and prosgegrammeni
    0x1F0B,  // capital alpha with dasia and varia
    0x1F8B,  // -> capital alpha with dasia and varia and prosgegrammeni
    0x1F0C,  // capital alpha with psili and oxia
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x1F0D,  // capital alpha with dasia and oxia
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x1F0E,  // capital alpha with psili and perispomeni
    0x1F8E,  // -> capital alpha with psili and perispomeni and prosgegrammeni
    0x1F0F,  // capital alpha with dasia and perispomeni
    0x1F8F,  // -> capital alpha with dasia and perispomeni and prosgegrammeni
    0x1F20,  // letter eta with psili
    0x1F90,  // -> letter eta with psili and ypogegrammeni
    0x1F21,  // letter eta with dasia
    0x1F91,  // -> letter eta with dasia and ypogegrammeni
    0x1F22,  // letter eta with psili and varia
    0x1F92,  // -> letter eta with psili and varia and ypogegrammeni
    0x1F23,  // letter eta with dasia and varia
    0x1F93,  // -> letter eta with dasia and varia and ypogegrammeni
    0x1F24,  // letter eta with psili and oxia
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x1F25,  // letter eta with dasia and oxia
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x1F26,  // letter eta with psili and perispomeni
    0x1F96,  // -> letter eta with psili and perispomeni and ypogegrammeni
    0x1F27,  // letter eta with dasia and perispomeni
    0x1F97,  // -> letter eta with dasia and perispomeni and ypogegrammeni
    0x1F28,  // capital eta with psili
    0x1F98,  // -> capital eta with psili and prosgegrammeni
    0x1F29,  // capital eta with dasia
    0x1F99,  // -> capital eta with dasia and prosgegrammeni
    0x1F2A,  // capital eta with psili and varia
    0x1F9A,  // -> capital eta with psili and varia and prosgegrammeni
    0x1F2B,  // capital eta with dasia and varia
    0x1F9B,  // -> capital eta with dasia and varia and prosgegrammeni
    0x1F2C,  // capital eta with psili and oxia
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x1F2D,  // capital eta with dasia and oxia
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x1F2E,  // capital eta with psili and perispomeni
    0x1F9E,  // -> capital eta with psili and perispomeni and prosgegrammeni
    0x1F2F,  // capital eta with dasia and perispomeni
    0x1F9F,  // -> capital eta with dasia and perispomeni and prosgegrammeni
    0x1F60,  // letter omega with psili
    0x1FA0,  // -> letter omega with psili and ypogegrammeni
    0x1F61,  // letter omega with dasia
    0x1FA1,  // -> letter omega with dasia and ypogegrammeni
    0x1F62,  // letter omega with psili and varia
    0x1FA2,  // -> letter omega with psili and varia and ypogegrammeni
    0x1F63,  // letter omega with dasia and varia
    0x1FA3,  // -> letter omega with dasia and varia and ypogegrammeni
    0x1F64,  // letter omega with psili and oxia
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    0x1F65,  // letter omega with dasia and oxia
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    0x1F66,  // letter omega with psili and perispomeni
    0x1FA6,  // -> letter omega with psili and perispomeni and ypogegrammeni
    0x1F67,  // letter omega with dasia and perispomeni
    0x1FA7,  // -> letter omega with dasia and perispomeni and ypogegrammeni
    0x1F68,  // capital omega with psili
    0x1FA8,  // -> capital omega with psili and prosgegrammeni
    0x1F69,  // capital omega with dasia
    0x1FA9,  // -> capital omega with dasia and prosgegrammeni
    0x1F6A,  // capital omega with psili and varia
    0x1FAA,  // -> capital omega with psili and varia and prosgegrammeni
    0x1F6B,  // capital omega with dasia and varia
    0x1FAB,  // -> capital omega with dasia and varia and prosgegrammeni
    0x1F6C,  // capital omega with psili and oxia
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x1F6D,  // capital omega with dasia and oxia
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    0x1F6E,  // capital omega with psili and perispomeni
    0x1FAE,  // -> capital omega with psili and perispomeni and prosgegrammeni
    0x1F6F,  // capital omega with dasia and perispomeni
    0x1FAF,  // -> capital omega with dasia and perispomeni and prosgegrammeni
    0x1F70,  // letter alpha with varia
    0x1FB2,  // -> letter alpha with varia and ypogegrammeni
    0x1F74,  // letter eta with varia
    0x1FC2,  // -> letter eta with varia and ypogegrammeni
    0x1F7C,  // letter omega with varia
    0x1FF2,  // -> letter omega with varia and ypogegrammeni
    0x1FB6,  // letter alpha with perispomeni
    0x1FB7,  // -> letter alpha with perispomeni and ypogegrammeni
    0x1FC6,  // letter eta with perispomeni
    0x1FC7,  // -> letter eta with perispomeni and ypogegrammeni
    0x1FF6,  // letter omega with perispomeni
    0x1FF7,  // -> letter omega with perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0006,          // number of entries
    0x0000,  // U+0000
    0x36E8,
    0x0300,  // combining grave accent
    0x38C0,
    0x0301,  // combining acute accent
    0x3930,
    0x0303,  // combining tilde
    0x39A0,
    0x0313,  // combining comma above
    0x3A10,
    0x0314,  // combining reversed comma above
    0x3A20,
    //   leaf dead_key table
    0x0001,          // number of entries
    0x0345,  // combining greek ypogegrammeni
    0x037A,  // -> ypogegrammeni

    // offset 0x36E8:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //   internal character table
    0x0006,          // number of entries
    0x0027,  // apostrophe
    0x36F8,
    0x0028,  // left parenthesis
    0x3762,
    0x0029,  // right parenthesis
    0x3772,
    0x0060,  // grave accent
    0x3782,
    0x007E,  // tilde
    0x37EC,
    0x00B4,  // acute accent
    0x3856,
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x36F8:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <apostrophe>
    //   internal character table
    0x0002,          // number of entries
    0x0028,  // left parenthesis
    0x3722,
    0x0029,  // right parenthesis
    0x3732,
    //   leaf character table
    0x000F,          // number of entries
    0x03B1,  // letter alpha
    0x1FB4,  // -> letter alpha with oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1FC4,  // -> letter eta with oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FF4,  // -> letter omega with oxia and ypogegrammeni
    0x1F00,  // letter alpha with psili
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x1F01,  // letter alpha with dasia
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x1F08,  // capital alpha with psili
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x1F09,  // capital alpha with dasia
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x1F20,  // letter eta with psili
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x1F21,  // letter eta with dasia
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x1F28,  // capital eta with psili
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x1F29,  // capital eta with dasia
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x1F60,  // letter omega with psili
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    0x1F61,  // letter omega with dasia
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    0x1F68,  // capital omega with psili
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x1F69,  // capital omega with dasia
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    //   internal dead_key table
    0x0002,          // number of entries
    0x0313,  // combining comma above
    0x3742,
    0x0314,  // combining reversed comma above
    0x3752,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3722:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <apostrophe>
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3732:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <apostrophe>
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3742:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <apostrophe>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3752:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <apostrophe>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3762:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F89,  // -> capital alpha with dasia and prosgegrammeni
    0x0397,  // capital eta
    0x1F99,  // -> capital eta with dasia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FA9,  // -> capital omega with dasia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F81,  // -> letter alpha with dasia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F91,  // -> letter eta with dasia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA1,  // -> letter omega with dasia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3772:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F88,  // -> capital alpha with psili and prosgegrammeni
    0x0397,  // capital eta
    0x1F98,  // -> capital eta with psili and prosgegrammeni
    0x03A9,  // capital omega
    0x1FA8,  // -> capital omega with psili and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F80,  // -> letter alpha with psili and ypogegrammeni
    0x03B7,  // letter eta
    0x1F90,  // -> letter eta with psili and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA0,  // -> letter omega with psili and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3782:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <grave accent>
    //   internal character table
    0x0002,          // number of entries
    0x0028,  // left parenthesis
    0x37AC,
    0x0029,  // right parenthesis
    0x37BC,
    //   leaf character table
    0x000F,          // number of entries
    0x03B1,  // letter alpha
    0x1FB2,  // -> letter alpha with varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1FC2,  // -> letter eta with varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FF2,  // -> letter omega with varia and ypogegrammeni
    0x1F00,  // letter alpha with psili
    0x1F82,  // -> letter alpha with psili and varia and ypogegrammeni
    0x1F01,  // letter alpha with dasia
    0x1F83,  // -> letter alpha with dasia and varia and ypogegrammeni
    0x1F08,  // capital alpha with psili
    0x1F8A,  // -> capital alpha with psili and varia and prosgegrammeni
    0x1F09,  // capital alpha with dasia
    0x1F8B,  // -> capital alpha with dasia and varia and prosgegrammeni
    0x1F20,  // letter eta with psili
    0x1F92,  // -> letter eta with psili and varia and ypogegrammeni
    0x1F21,  // letter eta with dasia
    0x1F93,  // -> letter eta with dasia and varia and ypogegrammeni
    0x1F28,  // capital eta with psili
    0x1F9A,  // -> capital eta with psili and varia and prosgegrammeni
    0x1F29,  // capital eta with dasia
    0x1F9B,  // -> capital eta with dasia and varia and prosgegrammeni
    0x1F60,  // letter omega with psili
    0x1FA2,  // -> letter omega with psili and varia and ypogegrammeni
    0x1F61,  // letter omega with dasia
    0x1FA3,  // -> letter omega with dasia and varia and ypogegrammeni
    0x1F68,  // capital omega with psili
    0x1FAA,  // -> capital omega with psili and varia and prosgegrammeni
    0x1F69,  // capital omega with dasia
    0x1FAB,  // -> capital omega with dasia and varia and prosgegrammeni
    //   internal dead_key table
    0x0002,          // number of entries
    0x0313,  // combining comma above
    0x37CC,
    0x0314,  // combining reversed comma above
    0x37DC,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x37AC:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <grave accent>
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8B,  // -> capital alpha with dasia and varia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9B,  // -> capital eta with dasia and varia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAB,  // -> capital omega with dasia and varia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F83,  // -> letter alpha with dasia and varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F93,  // -> letter eta with dasia and varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA3,  // -> letter omega with dasia and varia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x37BC:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <grave accent>
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8A,  // -> capital alpha with psili and varia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9A,  // -> capital eta with psili and varia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAA,  // -> capital omega with psili and varia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F82,  // -> letter alpha with psili and varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F92,  // -> letter eta with psili and varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA2,  // -> letter omega with psili and varia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x37CC:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <grave accent>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8A,  // -> capital alpha with psili and varia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9A,  // -> capital eta with psili and varia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAA,  // -> capital omega with psili and varia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F82,  // -> letter alpha with psili and varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F92,  // -> letter eta with psili and varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA2,  // -> letter omega with psili and varia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x37DC:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <grave accent>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8B,  // -> capital alpha with dasia and varia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9B,  // -> capital eta with dasia and varia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAB,  // -> capital omega with dasia and varia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F83,  // -> letter alpha with dasia and varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F93,  // -> letter eta with dasia and varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA3,  // -> letter omega with dasia and varia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x37EC:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <tilde>
    //   internal character table
    0x0002,          // number of entries
    0x0028,  // left parenthesis
    0x3816,
    0x0029,  // right parenthesis
    0x3826,
    //   leaf character table
    0x000F,          // number of entries
    0x03B1,  // letter alpha
    0x1FB7,  // -> letter alpha with perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1FC7,  // -> letter eta with perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FF7,  // -> letter omega with perispomeni and ypogegrammeni
    0x1F00,  // letter alpha with psili
    0x1F86,  // -> letter alpha with psili and perispomeni and ypogegrammeni
    0x1F01,  // letter alpha with dasia
    0x1F87,  // -> letter alpha with dasia and perispomeni and ypogegrammeni
    0x1F08,  // capital alpha with psili
    0x1F8E,  // -> capital alpha with psili and perispomeni and prosgegrammeni
    0x1F09,  // capital alpha with dasia
    0x1F8F,  // -> capital alpha with dasia and perispomeni and prosgegrammeni
    0x1F20,  // letter eta with psili
    0x1F96,  // -> letter eta with psili and perispomeni and ypogegrammeni
    0x1F21,  // letter eta with dasia
    0x1F97,  // -> letter eta with dasia and perispomeni and ypogegrammeni
    0x1F28,  // capital eta with psili
    0x1F9E,  // -> capital eta with psili and perispomeni and prosgegrammeni
    0x1F29,  // capital eta with dasia
    0x1F9F,  // -> capital eta with dasia and perispomeni and prosgegrammeni
    0x1F60,  // letter omega with psili
    0x1FA6,  // -> letter omega with psili and perispomeni and ypogegrammeni
    0x1F61,  // letter omega with dasia
    0x1FA7,  // -> letter omega with dasia and perispomeni and ypogegrammeni
    0x1F68,  // capital omega with psili
    0x1FAE,  // -> capital omega with psili and perispomeni and prosgegrammeni
    0x1F69,  // capital omega with dasia
    0x1FAF,  // -> capital omega with dasia and perispomeni and prosgegrammeni
    //   internal dead_key table
    0x0002,          // number of entries
    0x0313,  // combining comma above
    0x3836,
    0x0314,  // combining reversed comma above
    0x3846,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3816:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <tilde>
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8F,  // -> capital alpha with dasia and perispomeni and prosgegrammeni
    0x0397,  // capital eta
    0x1F9F,  // -> capital eta with dasia and perispomeni and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAF,  // -> capital omega with dasia and perispomeni and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F87,  // -> letter alpha with dasia and perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1F97,  // -> letter eta with dasia and perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA7,  // -> letter omega with dasia and perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3826:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <tilde>
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8E,  // -> capital alpha with psili and perispomeni and prosgegrammeni
    0x0397,  // capital eta
    0x1F9E,  // -> capital eta with psili and perispomeni and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAE,  // -> capital omega with psili and perispomeni and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F86,  // -> letter alpha with psili and perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1F96,  // -> letter eta with psili and perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA6,  // -> letter omega with psili and perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3836:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <tilde>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8E,  // -> capital alpha with psili and perispomeni and prosgegrammeni
    0x0397,  // capital eta
    0x1F9E,  // -> capital eta with psili and perispomeni and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAE,  // -> capital omega with psili and perispomeni and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F86,  // -> letter alpha with psili and perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1F96,  // -> letter eta with psili and perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA6,  // -> letter omega with psili and perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3846:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <tilde>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8F,  // -> capital alpha with dasia and perispomeni and prosgegrammeni
    0x0397,  // capital eta
    0x1F9F,  // -> capital eta with dasia and perispomeni and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAF,  // -> capital omega with dasia and perispomeni and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F87,  // -> letter alpha with dasia and perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1F97,  // -> letter eta with dasia and perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA7,  // -> letter omega with dasia and perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3856:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <acute accent>
    //   internal character table
    0x0002,          // number of entries
    0x0028,  // left parenthesis
    0x3880,
    0x0029,  // right parenthesis
    0x3890,
    //   leaf character table
    0x000F,          // number of entries
    0x03B1,  // letter alpha
    0x1FB4,  // -> letter alpha with oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1FC4,  // -> letter eta with oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FF4,  // -> letter omega with oxia and ypogegrammeni
    0x1F00,  // letter alpha with psili
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x1F01,  // letter alpha with dasia
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x1F08,  // capital alpha with psili
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x1F09,  // capital alpha with dasia
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x1F20,  // letter eta with psili
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x1F21,  // letter eta with dasia
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x1F28,  // capital eta with psili
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x1F29,  // capital eta with dasia
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x1F60,  // letter omega with psili
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    0x1F61,  // letter omega with dasia
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    0x1F68,  // capital omega with psili
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x1F69,  // capital omega with dasia
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    //   internal dead_key table
    0x0002,          // number of entries
    0x0313,  // combining comma above
    0x38A0,
    0x0314,  // combining reversed comma above
    0x38B0,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3880:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <acute accent>
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3890:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <acute accent>
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x38A0:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <acute accent>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x38B0:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Compose
    //     <acute accent>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x38C0:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining grave accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000F,          // number of entries
    0x03B1,  // letter alpha
    0x1FB2,  // -> letter alpha with varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1FC2,  // -> letter eta with varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FF2,  // -> letter omega with varia and ypogegrammeni
    0x1F00,  // letter alpha with psili
    0x1F82,  // -> letter alpha with psili and varia and ypogegrammeni
    0x1F01,  // letter alpha with dasia
    0x1F83,  // -> letter alpha with dasia and varia and ypogegrammeni
    0x1F08,  // capital alpha with psili
    0x1F8A,  // -> capital alpha with psili and varia and prosgegrammeni
    0x1F09,  // capital alpha with dasia
    0x1F8B,  // -> capital alpha with dasia and varia and prosgegrammeni
    0x1F20,  // letter eta with psili
    0x1F92,  // -> letter eta with psili and varia and ypogegrammeni
    0x1F21,  // letter eta with dasia
    0x1F93,  // -> letter eta with dasia and varia and ypogegrammeni
    0x1F28,  // capital eta with psili
    0x1F9A,  // -> capital eta with psili and varia and prosgegrammeni
    0x1F29,  // capital eta with dasia
    0x1F9B,  // -> capital eta with dasia and varia and prosgegrammeni
    0x1F60,  // letter omega with psili
    0x1FA2,  // -> letter omega with psili and varia and ypogegrammeni
    0x1F61,  // letter omega with dasia
    0x1FA3,  // -> letter omega with dasia and varia and ypogegrammeni
    0x1F68,  // capital omega with psili
    0x1FAA,  // -> capital omega with psili and varia and prosgegrammeni
    0x1F69,  // capital omega with dasia
    0x1FAB,  // -> capital omega with dasia and varia and prosgegrammeni
    //   internal dead_key table
    0x0003,          // number of entries
    0x0000,  // U+0000
    0x38E8,
    0x0313,  // combining comma above
    0x3910,
    0x0314,  // combining reversed comma above
    0x3920,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x38E8:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining grave accent>
    //     Compose
    //   internal character table
    0x0002,          // number of entries
    0x0028,  // left parenthesis
    0x38F0,
    0x0029,  // right parenthesis
    0x3900,
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x38F0:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining grave accent>
    //     Compose
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8B,  // -> capital alpha with dasia and varia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9B,  // -> capital eta with dasia and varia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAB,  // -> capital omega with dasia and varia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F83,  // -> letter alpha with dasia and varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F93,  // -> letter eta with dasia and varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA3,  // -> letter omega with dasia and varia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3900:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining grave accent>
    //     Compose
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8A,  // -> capital alpha with psili and varia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9A,  // -> capital eta with psili and varia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAA,  // -> capital omega with psili and varia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F82,  // -> letter alpha with psili and varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F92,  // -> letter eta with psili and varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA2,  // -> letter omega with psili and varia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3910:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining grave accent>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8A,  // -> capital alpha with psili and varia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9A,  // -> capital eta with psili and varia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAA,  // -> capital omega with psili and varia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F82,  // -> letter alpha with psili and varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F92,  // -> letter eta with psili and varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA2,  // -> letter omega with psili and varia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3920:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining grave accent>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8B,  // -> capital alpha with dasia and varia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9B,  // -> capital eta with dasia and varia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAB,  // -> capital omega with dasia and varia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F83,  // -> letter alpha with dasia and varia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F93,  // -> letter eta with dasia and varia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA3,  // -> letter omega with dasia and varia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3930:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining acute accent>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000F,          // number of entries
    0x03B1,  // letter alpha
    0x1FB4,  // -> letter alpha with oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1FC4,  // -> letter eta with oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FF4,  // -> letter omega with oxia and ypogegrammeni
    0x1F00,  // letter alpha with psili
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x1F01,  // letter alpha with dasia
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x1F08,  // capital alpha with psili
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x1F09,  // capital alpha with dasia
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x1F20,  // letter eta with psili
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x1F21,  // letter eta with dasia
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x1F28,  // capital eta with psili
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x1F29,  // capital eta with dasia
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x1F60,  // letter omega with psili
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    0x1F61,  // letter omega with dasia
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    0x1F68,  // capital omega with psili
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x1F69,  // capital omega with dasia
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    //   internal dead_key table
    0x0003,          // number of entries
    0x0000,  // U+0000
    0x3958,
    0x0313,  // combining comma above
    0x3980,
    0x0314,  // combining reversed comma above
    0x3990,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3958:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining acute accent>
    //     Compose
    //   internal character table
    0x0002,          // number of entries
    0x0028,  // left parenthesis
    0x3960,
    0x0029,  // right parenthesis
    0x3970,
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3960:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining acute accent>
    //     Compose
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3970:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining acute accent>
    //     Compose
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3980:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining acute accent>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8C,  // -> capital alpha with psili and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9C,  // -> capital eta with psili and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAC,  // -> capital omega with psili and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F84,  // -> letter alpha with psili and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F94,  // -> letter eta with psili and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA4,  // -> letter omega with psili and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3990:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining acute accent>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8D,  // -> capital alpha with dasia and oxia and prosgegrammeni
    0x0397,  // capital eta
    0x1F9D,  // -> capital eta with dasia and oxia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAD,  // -> capital omega with dasia and oxia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F85,  // -> letter alpha with dasia and oxia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F95,  // -> letter eta with dasia and oxia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA5,  // -> letter omega with dasia and oxia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x39A0:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining tilde>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000F,          // number of entries
    0x03B1,  // letter alpha
    0x1FB7,  // -> letter alpha with perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1FC7,  // -> letter eta with perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FF7,  // -> letter omega with perispomeni and ypogegrammeni
    0x1F00,  // letter alpha with psili
    0x1F86,  // -> letter alpha with psili and perispomeni and ypogegrammeni
    0x1F01,  // letter alpha with dasia
    0x1F87,  // -> letter alpha with dasia and perispomeni and ypogegrammeni
    0x1F08,  // capital alpha with psili
    0x1F8E,  // -> capital alpha with psili and perispomeni and prosgegrammeni
    0x1F09,  // capital alpha with dasia
    0x1F8F,  // -> capital alpha with dasia and perispomeni and prosgegrammeni
    0x1F20,  // letter eta with psili
    0x1F96,  // -> letter eta with psili and perispomeni and ypogegrammeni
    0x1F21,  // letter eta with dasia
    0x1F97,  // -> letter eta with dasia and perispomeni and ypogegrammeni
    0x1F28,  // capital eta with psili
    0x1F9E,  // -> capital eta with psili and perispomeni and prosgegrammeni
    0x1F29,  // capital eta with dasia
    0x1F9F,  // -> capital eta with dasia and perispomeni and prosgegrammeni
    0x1F60,  // letter omega with psili
    0x1FA6,  // -> letter omega with psili and perispomeni and ypogegrammeni
    0x1F61,  // letter omega with dasia
    0x1FA7,  // -> letter omega with dasia and perispomeni and ypogegrammeni
    0x1F68,  // capital omega with psili
    0x1FAE,  // -> capital omega with psili and perispomeni and prosgegrammeni
    0x1F69,  // capital omega with dasia
    0x1FAF,  // -> capital omega with dasia and perispomeni and prosgegrammeni
    //   internal dead_key table
    0x0003,          // number of entries
    0x0000,  // U+0000
    0x39C8,
    0x0313,  // combining comma above
    0x39F0,
    0x0314,  // combining reversed comma above
    0x3A00,
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x39C8:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining tilde>
    //     Compose
    //   internal character table
    0x0002,          // number of entries
    0x0028,  // left parenthesis
    0x39D0,
    0x0029,  // right parenthesis
    0x39E0,
    //   leaf character table
    0x0000,          // number of entries
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x39D0:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining tilde>
    //     Compose
    //     <left parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8F,  // -> capital alpha with dasia and perispomeni and prosgegrammeni
    0x0397,  // capital eta
    0x1F9F,  // -> capital eta with dasia and perispomeni and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAF,  // -> capital omega with dasia and perispomeni and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F87,  // -> letter alpha with dasia and perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1F97,  // -> letter eta with dasia and perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA7,  // -> letter omega with dasia and perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x39E0:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining tilde>
    //     Compose
    //     <right parenthesis>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8E,  // -> capital alpha with psili and perispomeni and prosgegrammeni
    0x0397,  // capital eta
    0x1F9E,  // -> capital eta with psili and perispomeni and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAE,  // -> capital omega with psili and perispomeni and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F86,  // -> letter alpha with psili and perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1F96,  // -> letter eta with psili and perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA6,  // -> letter omega with psili and perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x39F0:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining tilde>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8E,  // -> capital alpha with psili and perispomeni and prosgegrammeni
    0x0397,  // capital eta
    0x1F9E,  // -> capital eta with psili and perispomeni and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAE,  // -> capital omega with psili and perispomeni and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F86,  // -> letter alpha with psili and perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1F96,  // -> letter eta with psili and perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA6,  // -> letter omega with psili and perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3A00:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining tilde>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F8F,  // -> capital alpha with dasia and perispomeni and prosgegrammeni
    0x0397,  // capital eta
    0x1F9F,  // -> capital eta with dasia and perispomeni and prosgegrammeni
    0x03A9,  // capital omega
    0x1FAF,  // -> capital omega with dasia and perispomeni and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F87,  // -> letter alpha with dasia and perispomeni and ypogegrammeni
    0x03B7,  // letter eta
    0x1F97,  // -> letter eta with dasia and perispomeni and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA7,  // -> letter omega with dasia and perispomeni and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3A10:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F88,  // -> capital alpha with psili and prosgegrammeni
    0x0397,  // capital eta
    0x1F98,  // -> capital eta with psili and prosgegrammeni
    0x03A9,  // capital omega
    0x1FA8,  // -> capital omega with psili and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F80,  // -> letter alpha with psili and ypogegrammeni
    0x03B7,  // letter eta
    0x1F90,  // -> letter eta with psili and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA0,  // -> letter omega with psili and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3A20:
    //   prefix:
    //     Dead<combining greek ypogegrammeni>
    //     Dead<combining reversed comma above>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0006,          // number of entries
    0x0391,  // capital alpha
    0x1F89,  // -> capital alpha with dasia and prosgegrammeni
    0x0397,  // capital eta
    0x1F99,  // -> capital eta with dasia and prosgegrammeni
    0x03A9,  // capital omega
    0x1FA9,  // -> capital omega with dasia and prosgegrammeni
    0x03B1,  // letter alpha
    0x1F81,  // -> letter alpha with dasia and ypogegrammeni
    0x03B7,  // letter eta
    0x1F91,  // -> letter eta with dasia and ypogegrammeni
    0x03C9,  // letter omega
    0x1FA1,  // -> letter omega with dasia and ypogegrammeni
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3A30:
    //   prefix:
    //     Dead<combining katakana-hiragana voiced sound mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x0030,          // number of entries
    0x3046,  // hiragana u
    0x3094,  // -> hiragana vu
    0x304B,  // hiragana ka
    0x304C,  // -> hiragana ga
    0x304D,  // hiragana ki
    0x304E,  // -> hiragana gi
    0x304F,  // hiragana ku
    0x3050,  // -> hiragana gu
    0x3051,  // hiragana ke
    0x3052,  // -> hiragana ge
    0x3053,  // hiragana ko
    0x3054,  // -> hiragana go
    0x3055,  // hiragana sa
    0x3056,  // -> hiragana za
    0x3057,  // hiragana si
    0x3058,  // -> hiragana zi
    0x3059,  // hiragana su
    0x305A,  // -> hiragana zu
    0x305B,  // hiragana se
    0x305C,  // -> hiragana ze
    0x305D,  // hiragana so
    0x305E,  // -> hiragana zo
    0x305F,  // hiragana ta
    0x3060,  // -> hiragana da
    0x3061,  // hiragana ti
    0x3062,  // -> hiragana di
    0x3064,  // hiragana tu
    0x3065,  // -> hiragana du
    0x3066,  // hiragana te
    0x3067,  // -> hiragana de
    0x3068,  // hiragana to
    0x3069,  // -> hiragana do
    0x306F,  // hiragana ha
    0x3070,  // -> hiragana ba
    0x3072,  // hiragana hi
    0x3073,  // -> hiragana bi
    0x3075,  // hiragana hu
    0x3076,  // -> hiragana bu
    0x3078,  // hiragana he
    0x3079,  // -> hiragana be
    0x307B,  // hiragana ho
    0x307C,  // -> hiragana bo
    0x309D,  // hiragana iteration mark
    0x309E,  // -> hiragana voiced iteration mark
    0x30A6,  // katakana u
    0x30F4,  // -> katakana vu
    0x30AB,  // katakana ka
    0x30AC,  // -> katakana ga
    0x30AD,  // katakana ki
    0x30AE,  // -> katakana gi
    0x30AF,  // katakana ku
    0x30B0,  // -> katakana gu
    0x30B1,  // katakana ke
    0x30B2,  // -> katakana ge
    0x30B3,  // katakana ko
    0x30B4,  // -> katakana go
    0x30B5,  // katakana sa
    0x30B6,  // -> katakana za
    0x30B7,  // katakana si
    0x30B8,  // -> katakana zi
    0x30B9,  // katakana su
    0x30BA,  // -> katakana zu
    0x30BB,  // katakana se
    0x30BC,  // -> katakana ze
    0x30BD,  // katakana so
    0x30BE,  // -> katakana zo
    0x30BF,  // katakana ta
    0x30C0,  // -> katakana da
    0x30C1,  // katakana ti
    0x30C2,  // -> katakana di
    0x30C4,  // katakana tu
    0x30C5,  // -> katakana du
    0x30C6,  // katakana te
    0x30C7,  // -> katakana de
    0x30C8,  // katakana to
    0x30C9,  // -> katakana do
    0x30CF,  // katakana ha
    0x30D0,  // -> katakana ba
    0x30D2,  // katakana hi
    0x30D3,  // -> katakana bi
    0x30D5,  // katakana hu
    0x30D6,  // -> katakana bu
    0x30D8,  // katakana he
    0x30D9,  // -> katakana be
    0x30DB,  // katakana ho
    0x30DC,  // -> katakana bo
    0x30EF,  // katakana wa
    0x30F7,  // -> katakana va
    0x30F0,  // katakana wi
    0x30F8,  // -> katakana vi
    0x30F1,  // katakana we
    0x30F9,  // -> katakana ve
    0x30F2,  // katakana wo
    0x30FA,  // -> katakana vo
    0x30FD,  // katakana iteration mark
    0x30FE,  // -> katakana voiced iteration mark
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries

    // offset 0x3A94:
    //   prefix:
    //     Dead<combining katakana-hiragana semi-voiced sound mark>
    //   internal character table
    0x0000,          // number of entries
    //   leaf character table
    0x000A,          // number of entries
    0x306F,  // hiragana ha
    0x3071,  // -> hiragana pa
    0x3072,  // hiragana hi
    0x3074,  // -> hiragana pi
    0x3075,  // hiragana hu
    0x3077,  // -> hiragana pu
    0x3078,  // hiragana he
    0x307A,  // -> hiragana pe
    0x307B,  // hiragana ho
    0x307D,  // -> hiragana po
    0x30CF,  // katakana ha
    0x30D1,  // -> katakana pa
    0x30D2,  // katakana hi
    0x30D4,  // -> katakana pi
    0x30D5,  // katakana hu
    0x30D7,  // -> katakana pu
    0x30D8,  // katakana he
    0x30DA,  // -> katakana pe
    0x30DB,  // katakana ho
    0x30DD,  // -> katakana po
    //   internal dead_key table
    0x0000,          // number of entries
    //   leaf dead_key table
    0x0000,          // number of entries
};

static const ui::TreeComposeChecker::CompositionData kCompositions = {
  5, // maximum sequence length
  15020, // tree array entries
  kCompositionsTree
};

#endif  // CHARACTER_COMPOSER_DATA_H_
