## RabbitMQ 3.7.23

RabbitMQ `3.7.23` is a maintenance release.
RabbitMQ `3.7.x` series is supported [through March 2020](https://www.rabbitmq.com/versions.html).

### Erlang/OTP Compatibility Notes

Per the new Erlang version support policy in effect starting with January 2019,
this release [**no longer supports Erlang/OTP 20.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ).
Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `21.3.x` and `22.x`.

### Compatibility Notes

#### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release **and upgrading Erlang to 21.x or later** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade
and compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades
and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### MQTT Plugin

#### Enhancements

 * Throughput improvements ranging from 14 to 60 percent depending on workload.

   GitHub issue: [rabbitmq/rabbitmq-server#2168](https://github.com/rabbitmq/rabbitmq-server/issues/2168)


### AMQP 1.0 Plugin

#### Enhancements

 * Throughput improvements.

   GitHub issue: [rabbitmq/rabbitmq-server#2168](https://github.com/rabbitmq/rabbitmq-server/issues/2168)


### STOMP Plugin

#### Enhancements

 * Throughput improvements.

   GitHub issue: [rabbitmq/rabbitmq-server#2168](https://github.com/rabbitmq/rabbitmq-server/issues/2168)


### Web STOMP Plugin

#### Enhancements

 * Clients now can authenticate using an x.509 (TLS) certificate.

   GitHub issue: [rabbitmq/rabbitmq-web-stomp#116](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/116)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-server-3.7.23.tar.xz`.
