// Generated by re2zig
// re2zig $INPUT -o $OUTPUT

const std = @import("std");

const yymaxfill = 1;


fn lex(str: []const u8) !i32 {
    // Create a copy of the input string padded with yymaxfill zeroes at the end.
    var yyinput = try std.testing.allocator.alloc(u8, str.len + yymaxfill);
    defer std.testing.allocator.free(yyinput);
    std.mem.copy(u8, yyinput[0..], str);
    std.mem.copy(u8, yyinput[str.len..], &[_]u8{0} ** yymaxfill); // zero padding

    var yycursor: usize = 0;
    var yylimit: usize = yyinput.len;
    var count: i32 = 0;

    loop: while (true) {
        
    var yych: u8 = 0;
    var yystate: u32 = 0;
    yyl: while (true) {
        switch (yystate) {
            0 => {
                if (yylimit <= yycursor) { return -1; }
                yych = yyinput[yycursor];
                yycursor += 1;
                switch (yych) {
                    0x00 => {
                        yystate = 1;
                        continue :yyl;
                    },
                    0x20 => {
                        yystate = 3;
                        continue :yyl;
                    },
                    0x27 => {
                        yystate = 5;
                        continue :yyl;
                    },
                    else => {
                        yystate = 2;
                        continue :yyl;
                    },
                }
            },
            1 => { 
                // Check that it is the sentinel, not some unexpected null.
                return if (yycursor - 1 == str.len) count else -1;
 },
            2 => { return -1; },
            3 => {
                if (yylimit <= yycursor) { return -1; }
                yych = yyinput[yycursor];
                switch (yych) {
                    0x20 => {
                        yycursor += 1;
                        yystate = 3;
                        continue :yyl;
                    },
                    else => {
                        yystate = 4;
                        continue :yyl;
                    },
                }
            },
            4 => { continue :loop; },
            5 => {
                if (yylimit <= yycursor) { return -1; }
                yych = yyinput[yycursor];
                yycursor += 1;
                switch (yych) {
                    0x27 => {
                        yystate = 6;
                        continue :yyl;
                    },
                    0x5C => {
                        yystate = 7;
                        continue :yyl;
                    },
                    else => {
                        yystate = 5;
                        continue :yyl;
                    },
                }
            },
            6 => { count += 1; continue :loop; },
            7 => {
                if (yylimit <= yycursor) { return -1; }
                yycursor += 1;
                yystate = 5;
                continue :yyl;
            },
            else => { @panic("internal lexer error"); },
        }
    }

    }
}

test {
    try std.testing.expectEqual(lex(""), 0);
    try std.testing.expectEqual(lex("'qu\x00tes' 'are' 'fine: \\'' "), 3);
    try std.testing.expectEqual(lex("'unterminated\\'"), -1);
    try std.testing.expectEqual(lex("'unexpected \x00 null\\'"), -1);
}
