/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_RDDS.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	Cfg_FctGetopt cfg_rdDynString, cfg_clDynString

	read will return the characters until '\0' is reached. Then
	permanently EOF.
	close will free both the argument structure and the string itself.

ob(ject): cfg_clDynString
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Close a dynamic string
he(ader files): 
lo(ng description): Implements the "close" function for a dynamically
	allocated string. The string itself will be freed.
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_rdds.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <portable.h>
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_RDDS.C 1.6 2001/02/27 01:28:07 ska Exp ska $";
#endif

int cfg_rdDynString(struct Cfg_Getopt * const optstru)
{	struct Cfg_ArgDynString *p;

	DBG_ENTER("cfg_rdDynString", Suppl_cmdline)

	assert(optstru);
	assert(C(_stk));

	if((p = S(getArg)) != 0) {
		assert(p->cfg_a_p);
		if(*p->cfg_a_p)
			DBG_RETURN_BC( *p->cfg_a_p++)
	}

	DBG_RETURN_C( EOF)
}

void cfg_clDynString(struct Cfg_Getopt * const optstru)
{	struct Cfg_ArgDynString *p;

	DBG_ENTER("cfg_clDynString", Suppl_cmdline)

	assert(optstru);
	assert(C(_stk));

	if((p = S(getArg)) != 0) {
		assert(p->cfg_a_string);
		chkHeap
		free(p->cfg_a_string);
		free(p);
		chkHeap
	}

	chkHeap
	DBG_EXIT
}
