/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIECS.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgEraseCurSection(void);

	Enter write mode with the current section opened, ready to
	write new values into.

ob(ject): cfgEraseCurSetcion
su(bsystem): inifile/2
sh(ort description): Erase the current section and open the section for writing
lo(ng description): Erase the current section (meaning: delete all values
 of this section), then open the INI file for writing. When the INI file is
 successfully closed, only the current section was modified.
re(lated to):
fi(le): cfgiecs.c
in(itialized by):

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"
#include "supplio.h"
#include "dynstr.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIECS.C 1.3 1999/12/13 02:22:21 ska Exp ska $";
#endif

int cfgEraseCurSection(void)
{	int rv;

	DBG_ENTER("cfgEraseCurSection", Suppl_inifile2)

	chkHeap
	if(!hasFile(usrini))	/* no file --> no section --> is deleted */
		DBG_RETURN_I( CFG_ERR_NONE)

	if((rv = cfgi_wrSecOpen(aS(usrini.cfgi_pos), 0)) == CFG_ERR_NONE
	 && (rv = cfgi_wrSetCurKey()) == CFG_ERR_NONE) {
		chkHeap
		/* Copy any immedately following comments */
		while((rv = cfgi_brkNxtVal(usrini.cfgi_fp)) == CFG_ERR_COMMENT
		 || rv == CFG_ERR_LINE) {
			chkHeap
			/* When the brkVal() function cannot find a valid value,
				it leaves the line unmodified */
			fputs(I(buf), cfgi_ini);			/* just duplicate */
		}
		chkHeap
		if(rv == CFG_ERR_END)
			rv = CFG_ERR_NONE;
	}
	chkHeap

	DBG_RETURN_I( rv)
}
