/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ec2.model.DiskImage;
import com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImportInstanceRequest
extends AmazonWebServiceRequest {
    private Boolean dryRun;
    private String description;
    private ImportInstanceLaunchSpecification launchSpecification;
    private List<DiskImage> diskImages;
    private String platform;

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public ImportInstanceRequest withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImportInstanceRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public ImportInstanceLaunchSpecification getLaunchSpecification() {
        return this.launchSpecification;
    }

    public void setLaunchSpecification(ImportInstanceLaunchSpecification launchSpecification) {
        this.launchSpecification = launchSpecification;
    }

    public ImportInstanceRequest withLaunchSpecification(ImportInstanceLaunchSpecification launchSpecification) {
        this.launchSpecification = launchSpecification;
        return this;
    }

    public List<DiskImage> getDiskImages() {
        if (this.diskImages == null) {
            this.diskImages = new ArrayList<DiskImage>();
        }
        return this.diskImages;
    }

    public void setDiskImages(Collection<DiskImage> diskImages) {
        if (diskImages == null) {
            this.diskImages = null;
            return;
        }
        ArrayList<DiskImage> diskImagesCopy = new ArrayList<DiskImage>(diskImages.size());
        diskImagesCopy.addAll(diskImages);
        this.diskImages = diskImagesCopy;
    }

    public ImportInstanceRequest withDiskImages(DiskImage ... diskImages) {
        if (this.getDiskImages() == null) {
            this.setDiskImages(new ArrayList<DiskImage>(diskImages.length));
        }
        for (DiskImage value : diskImages) {
            this.getDiskImages().add(value);
        }
        return this;
    }

    public ImportInstanceRequest withDiskImages(Collection<DiskImage> diskImages) {
        if (diskImages == null) {
            this.diskImages = null;
        } else {
            ArrayList<DiskImage> diskImagesCopy = new ArrayList<DiskImage>(diskImages.size());
            diskImagesCopy.addAll(diskImages);
            this.diskImages = diskImagesCopy;
        }
        return this;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public ImportInstanceRequest withPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dryRun != null) {
            sb.append("DryRun: " + this.dryRun + ", ");
        }
        if (this.description != null) {
            sb.append("Description: " + this.description + ", ");
        }
        if (this.launchSpecification != null) {
            sb.append("LaunchSpecification: " + this.launchSpecification + ", ");
        }
        if (this.diskImages != null) {
            sb.append("DiskImages: " + this.diskImages + ", ");
        }
        if (this.platform != null) {
            sb.append("Platform: " + this.platform + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isDryRun() == null ? 0 : this.isDryRun().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchSpecification() == null ? 0 : this.getLaunchSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getDiskImages() == null ? 0 : ((Object)this.getDiskImages()).hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceRequest)) {
            return false;
        }
        ImportInstanceRequest other = (ImportInstanceRequest)((Object)obj);
        if (other.isDryRun() == null ^ this.isDryRun() == null) {
            return false;
        }
        if (other.isDryRun() != null && !other.isDryRun().equals(this.isDryRun())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getLaunchSpecification() == null ^ this.getLaunchSpecification() == null) {
            return false;
        }
        if (other.getLaunchSpecification() != null && !other.getLaunchSpecification().equals(this.getLaunchSpecification())) {
            return false;
        }
        if (other.getDiskImages() == null ^ this.getDiskImages() == null) {
            return false;
        }
        if (other.getDiskImages() != null && !((Object)other.getDiskImages()).equals(this.getDiskImages())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        return other.getPlatform() == null || other.getPlatform().equals(this.getPlatform());
    }
}

