/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.util.Platform;

final class WindowLikeContainerLocations {
    private static final int MAXIMIZE_BUTTON_OFFSET = Platform.isOSX() ? 25 : (Platform.isWindows() ? -20 : 0);

    @RunsInCurrentThread
    static Point closeLocationOf(Container c) {
        Insets insets = c.getInsets();
        if (Platform.isOSX()) {
            return new Point(insets.left + 15, insets.top / 2);
        }
        return new Point(c.getWidth() - insets.right - 10, insets.top / 2);
    }

    @RunsInCurrentThread
    static Point maximizeLocationOf(Container c) {
        Point p = WindowLikeContainerLocations.iconifyLocationOf(c);
        p.x += MAXIMIZE_BUTTON_OFFSET;
        return p;
    }

    @RunsInCurrentThread
    static Point iconifyLocationOf(Container c) {
        Insets insets = c.getInsets();
        Point p = new Point();
        p.y = insets.top / 2;
        if (Platform.isOSX()) {
            p.x = 35;
        }
        if (Platform.isWindows()) {
            int offset = Platform.isWindowsXP() ? 64 : 45;
            p.x = c.getWidth() - insets.right - offset;
        }
        return p;
    }

    private WindowLikeContainerLocations() {
    }
}

