/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.Jpeg2000Module;
import edu.harvard.hul.ois.jhove.module.jpeg2000.AssociationBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BPCCBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHeader;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CaptureResolutionBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ChannelDefBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamRegBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ColorGroupBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ColorSpecBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CompOptionsBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ComponentMapBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ComposLayerHdrBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CompositionBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ContCodestreamBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.DDResolutionBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.DataEntryURLBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.DefaultBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.DesiredReproBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.DigSignatureBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.FragmentListBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.FragmentTableBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.GTSOBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.IPRBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ImageHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.InstructionSetBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2HeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.LabelBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.NumberListBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.OpacityBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.PaletteBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ROIBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ReaderRequirementsBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ResolutionBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.UUIDBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.UUIDInfoBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.UUIDListBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.XMLBox;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class JP2Box
extends BoxHolder {
    protected long startBytesRead;
    protected long _bytesRead;
    protected List associations;
    protected static final String noJP2Hdr = "Other boxes may not occur before JP2 Header";
    protected static final String DESCRIPTION_NAME = "Description";

    public JP2Box(RandomAccessFile randomAccessFile) {
        super(randomAccessFile);
        this.init(null);
    }

    public JP2Box(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile);
        this.init(boxHolder);
    }

    protected void init(BoxHolder boxHolder) {
        this._parentBox = boxHolder instanceof JP2Box ? (JP2Box)boxHolder : null;
        this._bytesRead = 0L;
        this.associations = new LinkedList();
    }

    public void setModule(Jpeg2000Module jpeg2000Module) {
        this._module = jpeg2000Module;
    }

    public void setBoxHeader(BoxHeader boxHeader) {
        this._boxHeader = boxHeader;
        this.bytesLeft = this._boxHeader.getDataLength();
    }

    public void setRepInfo(RepInfo repInfo) {
        this._repInfo = repInfo;
    }

    public void setDataInputStream(DataInputStream dataInputStream) {
        this._dstrm = dataInputStream;
    }

    public void setRandomAccessFile(RandomAccessFile randomAccessFile) {
        this._raf = randomAccessFile;
    }

    public static JP2Box boxMaker(String string, BoxHolder boxHolder) {
        JP2Box jP2Box = null;
        RandomAccessFile randomAccessFile = null;
        if (boxHolder != null) {
            randomAccessFile = boxHolder._raf;
        }
        jP2Box = "jp2h".equals(string) ? new JP2HeaderBox(randomAccessFile, boxHolder) : ("asoc".equals(string) ? new AssociationBox(randomAccessFile, boxHolder) : ("bpcc".equals(string) ? new BPCCBox(randomAccessFile, boxHolder) : ("chck".equals(string) ? new DigSignatureBox(randomAccessFile, boxHolder) : ("cdef".equals(string) ? new ChannelDefBox(randomAccessFile, boxHolder) : ("cgrp".equals(string) ? new ColorGroupBox(randomAccessFile, boxHolder) : ("cmap".equals(string) ? new ComponentMapBox(randomAccessFile, boxHolder) : ("colr".equals(string) ? new ColorSpecBox(randomAccessFile, boxHolder) : ("comp".equals(string) ? new CompositionBox(randomAccessFile, boxHolder) : ("copt".equals(string) ? new CompOptionsBox(randomAccessFile, boxHolder) : ("creg".equals(string) ? new CodestreamRegBox(randomAccessFile, boxHolder) : ("drep".equals(string) ? new DesiredReproBox(randomAccessFile, boxHolder) : ("flst".equals(string) ? new FragmentListBox(randomAccessFile, boxHolder) : ("ftbl".equals(string) ? new FragmentTableBox(randomAccessFile, boxHolder) : ("gtso".equals(string) ? new GTSOBox(randomAccessFile, boxHolder) : ("inst".equals(string) ? new InstructionSetBox(randomAccessFile, boxHolder) : ("ihdr".equals(string) ? new ImageHeaderBox(randomAccessFile, boxHolder) : ("jp2c".equals(string) ? new ContCodestreamBox(randomAccessFile, boxHolder) : ("jpch".equals(string) ? new CodestreamHeaderBox(randomAccessFile, boxHolder) : ("jplh".equals(string) ? new ComposLayerHdrBox(randomAccessFile, boxHolder) : ("jp2i".equals(string) ? new IPRBox(randomAccessFile, boxHolder) : ("lbl ".equals(string) ? new LabelBox(randomAccessFile, boxHolder) : ("nlst".equals(string) ? new NumberListBox(randomAccessFile, boxHolder) : ("opct".equals(string) ? new OpacityBox(randomAccessFile, boxHolder) : ("pclr".equals(string) ? new PaletteBox(randomAccessFile, boxHolder) : ("res ".equals(string) ? new ResolutionBox(randomAccessFile, boxHolder) : ("roid".equals(string) ? new ROIBox(randomAccessFile, boxHolder) : ("resc".equals(string) ? new CaptureResolutionBox(randomAccessFile, boxHolder) : ("resd".equals(string) ? new DDResolutionBox(randomAccessFile, boxHolder) : ("rreq".equals(string) ? new ReaderRequirementsBox(randomAccessFile, boxHolder) : ("uinf".equals(string) ? new UUIDInfoBox(randomAccessFile, boxHolder) : ("ulst".equals(string) ? new UUIDListBox(randomAccessFile, boxHolder) : ("url ".equals(string) ? new DataEntryURLBox(randomAccessFile, boxHolder) : ("uuid".equals(string) ? new UUIDBox(randomAccessFile, boxHolder) : ("xml ".equals(string) ? new XMLBox(randomAccessFile, boxHolder) : new DefaultBox(randomAccessFile)))))))))))))))))))))))))))))))))));
        return jP2Box;
    }

    protected void initBytesRead() {
        this.startBytesRead = this._module.getFilePos();
    }

    protected void finalizeBytesRead() {
        this._bytesRead = this._module.getFilePos() - this.startBytesRead;
    }

    public abstract boolean readBox() throws IOException;

    public int getBytesRead() {
        return (int)this._bytesRead;
    }

    public void skipBox() throws IOException {
        this.initBytesRead();
        if (this._boxHeader.getLength() != 0L) {
            this._module.skipBytes(this._dstrm, (int)this._boxHeader.getDataLength(), this._module);
        }
        this.finalizeBytesRead();
    }

    protected void addAssociation(Property property) {
        this.associations.add(property);
    }

    protected void wrongBoxSize() {
        this._repInfo.setMessage((Message)new ErrorMessage("Incorrect Box size for " + this.getSelfPropName(), this._module.getFilePos()));
        this._repInfo.setWellFormed(false);
    }

    protected void wrongBoxContext() {
        this._repInfo.setMessage((Message)new ErrorMessage("Invalid context for " + this.getSelfPropName(), this._module.getFilePos()));
        this._repInfo.setWellFormed(false);
    }

    protected void emptyBox() {
        this._repInfo.setMessage((Message)new ErrorMessage("Box is empty", "Box type = " + this.getSelfPropName(), this._module.getFilePos()));
        this._repInfo.setWellFormed(false);
    }

    protected Property makeAssocProperty() {
        if (this.associations.isEmpty()) {
            return null;
        }
        return new Property("Associations", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this.associations);
    }

    protected Property selfDescProperty() {
        ArrayList<Property> arrayList = new ArrayList<Property>(2);
        String string = this.getSelfPropName();
        if (string == null) {
            return null;
        }
        arrayList.add(new Property("Name", PropertyType.STRING, (Object)string));
        Property property = this.getSelfPropDesc();
        if (property != null) {
            arrayList.add(property);
        }
        return new Property("Box", PropertyType.PROPERTY, PropertyArity.LIST, arrayList);
    }

    @Override
    protected String getSelfPropName() {
        return null;
    }

    protected Property getSelfPropDesc() {
        return null;
    }

    protected long getLength() {
        return this._boxHeader.getLength();
    }
}

