#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 BetaRays
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Metal Slug 3
# send your bug reports to contact@dotslashplay.it
###

script_version=20230930.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='metal-slug-3'
GAME_NAME='Metal Slug 3'

## This game used to be available DRM-free from humblebundle.com,
## but they dropped it in favour of a Windows-only Steam key.
ARCHIVE_BASE_1='MetalSlug3_jan2016.sh'
ARCHIVE_BASE_1_MD5='a6854b31e7757f447c9c05281b28f57a'
ARCHIVE_BASE_1_SIZE='110000'
ARCHIVE_BASE_1_VERSION='1.0-humble1601'

ARCHIVE_BASE_0='MetalSlug3-Linux-2014-06-09.sh'
ARCHIVE_BASE_0_MD5='a8a3aee4e3438d2d6d5bab23236e43a3'
ARCHIVE_BASE_0_SIZE='83000'
ARCHIVE_BASE_0_VERSION='1.0-humble140609'

CONTENT_PATH_DEFAULT='data'
CONTENT_LIBS_BIN32_PATH="${CONTENT_PATH_DEFAULT}/x86/lib"
CONTENT_LIBS_BIN32_FILES='
libRocketControls.so.1
libRocketCore.so.1
libRocketDebugger.so.1'
CONTENT_LIBS_BIN64_PATH="${CONTENT_PATH_DEFAULT}/x86_64/lib64"
CONTENT_LIBS_BIN64_FILES='
libRocketControls.so.1
libRocketCore.so.1
libRocketDebugger.so.1'
CONTENT_GAME_BIN32_PATH="${CONTENT_PATH_DEFAULT}/x86"
CONTENT_GAME_BIN32_FILES='
NeogeoEmu.bin.x86'
CONTENT_GAME_BIN64_PATH="${CONTENT_PATH_DEFAULT}/x86_64"
CONTENT_GAME_BIN64_FILES='
NeogeoEmu.bin.x86_64'
CONTENT_GAME_DATA_PATH="${CONTENT_PATH_DEFAULT}/noarch"
CONTENT_GAME_DATA_FILES='
*.brm
*.dat
*.ini
*.png
*.rcss
*.rml
*.tga
*.ttf
*.txt
*.xor
*.wav
*.zip'

APP_MAIN_EXE_BIN32='NeogeoEmu.bin.x86'
APP_MAIN_EXE_BIN32_0='MetalSlug3.bin.x86'
APP_MAIN_EXE_BIN64='NeogeoEmu.bin.x86_64'
APP_MAIN_EXE_BIN64_0='MetalSlug3.bin.x86_64'
APP_MAIN_ICON='noarch/MetalSlug3.png'
APP_MAIN_ICON_0='icon.png'

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN64_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN32_DEPS="$PKG_BIN_DEPS"
PKG_BIN64_DEPS="$PKG_BIN_DEPS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libfreetype.so.6
libgcc_s.so.1
libm.so.6
libpthread.so.0
libSDL2-2.0.so.0
libstdc++.so.6'
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Write launchers

PKG='PKG_BIN32'
launchers_write
PKG='PKG_BIN64'
launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
