/*
 *	colourKeyFrameDialog.h -Colour property keyframe selection dialog
 *	Copyright (C) 2015, D Haley 

 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.

 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.

 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
// -*- C++ -*- generated by wxGlade 0.6.5 on Fri Sep 14 09:37:57 2012
#ifndef COLOURKEYFRAMEDIALOG_H
#define COLOURKEYFRAMEDIALOG_H


#include <wx/wx.h>
// begin wxGlade: ::dependencies
#include <wx/statline.h>

// end wxGlade



// begin wxGlade: ::extracode
// end wxGlade


class ColourKeyFrameDialog: public wxDialog {
public:
	// begin wxGlade: ColourKeyFrameDialog::ids
	// end wxGlade

	ColourKeyFrameDialog(wxWindow* parent, int id, const wxString& title, const wxPoint& pos=wxDefaultPosition, const wxSize& size=wxDefaultSize, long style=wxDEFAULT_DIALOG_STYLE);

	size_t getTransitionMode() const { return transitionMode;};

	//Get the staring colour as a hex string
	std::string getStartValue() const;
	//Get the ending colour as a hex string
	std::string getEndValue() const;

	size_t getStartFrame() const ;

	size_t getEndFrame() const ;
private:
	// begin wxGlade: ColourKeyFrameDialog::methods
	void set_properties();
	void do_layout();
	// end wxGlade

	//Starting red, green and blue values for transition
	unsigned char startRed,startGreen, startBlue;
	unsigned char endRed,endGreen, endBlue;
	size_t startFrame,endFrame;
	size_t transitionMode;
	
	bool startFrameOK,endFrameOK;

	//!Update the OK button's enabled/disabled state 
	// based upon text field validity
	void updateOKButton();
	//!Update the colour chooser buttons appearance
	void updateButtonColours();

protected:
	// begin wxGlade: ColourKeyFrameDialog::attributes
	wxStaticBox* sizerMainArea_staticbox;
	wxStaticText* labelTransition;
	wxComboBox* comboTransition;
	wxStaticText* labelFrameStart;
	wxTextCtrl* textFrameStart;
	wxStaticText* labelFrameEnd;
	wxTextCtrl* textFrameEnd;
	wxStaticLine* verticalLine;
	wxStaticText* labelStartVal;
	wxButton* btnStartColour;
	wxStaticText* labelFinalVal;
	wxButton* btnEndColour;
	wxButton* buttonCancel;
	wxButton* buttonOK;
	// end wxGlade

	DECLARE_EVENT_TABLE();

public:
	virtual void OnComboTransition(wxCommandEvent &event); // wxGlade: <event_handler>
	virtual void OnTextStartFrame(wxCommandEvent &event); // wxGlade: <event_handler>
	virtual void OnTextEndFrame(wxCommandEvent &event); // wxGlade: <event_handler>
	virtual void OnBtnStartColour(wxCommandEvent &event); // wxGlade: <event_handler>
	virtual void OnBtnEndColour(wxCommandEvent &event); // wxGlade: <event_handler>
}; // wxGlade: end class


#endif // COLOURKEYFRAMEDIALOG_H
