
C THIS ROUTINE SETS UP THE FINAL SET OF SYMMETRY ADAPTED COORDINATES,
C AFTER THE REMOVAL OF TRANSLATIONAL AND (OPTIONALLY) ROTATIONAL
C DEGREES OF FREEDOM

c INPUT
c integer NATOM
c integer NIRREP
c char*4  TYPE

c OUTPUT
c double  SCRIN(*)
c double  SCROUT(*)
c integer ISCRIN(*)
c integer ISCROUT(*)
c char*8  LABEL(NIRREP)

c RECORDS
c get TYPE//'SYMQ'
c get TYPE//'SYQT'
c get TYPE//'NSYQ'
c get TYPE//'LABL'
c get 'LINEAR'
c get ROTREC(IXYZ)
c get TRAREC(IXYZ)
c put 'NVIBSYM'
c put TYPE//'SYMQ'
c put TYPE//'SYQT'
c put 'NUMVIBRT'

      SUBROUTINE COLLECT(NATOM,NIRREP,SCRIN,SCROUT,
     &                   ISCRIN,ISCROUT,LABEL,TYPE)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

      DIMENSION SCRIN(*),SCROUT(*),ISCRIN(*),ISCROUT(*)
      CHARACTER*8 LABEL(NIRREP)
      CHARACTER*4 TYPE

      CHARACTER*8 ROTREC(3),TRAREC(3)
      DIMENSION NVIBSYM(20)

      COMMON /MACHSP/ IINTLN,IFLTLN,IINTFP,IALONE,IBITWD
      LOGICAL          ENERONLY,GRADONLY,ROTPROJ,RAMAN,GMTRYOPT,
     &                 SNPTGRAD
      COMMON /CONTROL/ ENERONLY,GRADONLY,ROTPROJ,RAMAN,GMTRYOPT,
     &                 SNPTGRAD 

      DATA TOL/1.D-8/
      DATA ROTREC /'ROTVECX ','ROTVECY ','ROTVECZ '/
      DATA TRAREC /'TRAVECX ','TRAVECY ','TRAVECZ '/

      IPOSOUT=0
      NSIZE=3*NATOM

c   o read in symmetry adapted coordinates and their symmetries
      CALL GETREC(20,'JOBARC',TYPE//'SYMQ',NSIZE*NSIZE*IINTFP,SCRIN)
      CALL GETREC(20,'JOBARC',TYPE//'SYQT',NSIZE,ISCRIN)
      CALL GETREC(20,'JOBARC',TYPE//'NSYQ',1,NCOORD)
      CALL GETREC(20,'JOBARC',TYPE//'LABL',NIRREP*IINTFP,LABEL)
      CALL GETREC(20,'JOBARC','LINEAR  ',1,ILINEAR)

c   o loop over coordinates and remove zero entries
      CALL IZERO(NVIBSYM,NIRREP)
      DO IPOSIN=1,NCOORD
         LOCIN=1+(IPOSIN-1)*NSIZE
         X=DNRM2(NSIZE,SCRIN(LOCIN),1)
         IF (X.GT.TOL) THEN
            IPOSOUT=IPOSOUT+1
            LOCOUT=1+(IPOSOUT-1)*NSIZE
            CALL DCOPY(NSIZE,SCRIN(LOCIN),1,SCROUT(LOCOUT),1)
            ISCROUT(IPOSOUT)=ISCRIN(IPOSIN)
            NVIBSYM(ISCROUT(IPOSOUT))=NVIBSYM(ISCROUT(IPOSOUT))+1
         END IF
      END DO

      NMODE=IPOSOUT

      ILOC=IPOSOUT*NSIZE+1

c   o put rotations and translations in rest of matrix
      IF (ROTPROJ) THEN
         ITOP=3-ILINEAR
         DO IXYZ=1,ITOP
            CALL GETREC(20,'JOBARC',ROTREC(IXYZ),NSIZE*IINTFP,
     &                  SCROUT(ILOC))
            ILOC=ILOC+NSIZE
         END DO
      END IF
      DO IXYZ=1,3
         CALL GETREC(20,'JOBARC',TRAREC(IXYZ),NSIZE*IINTFP,SCROUT(ILOC))
         ILOC=ILOC+NSIZE
      END DO

      CALL PUTREC(20,'JOBARC','NVIBSYM ',NIRREP,NVIBSYM)
      CALL PUTREC(20,'JOBARC',TYPE//'SYMQ',NSIZE*NCOORD*IINTFP,SCROUT)
      CALL PUTREC(20,'JOBARC',TYPE//'SYQT',NSIZE,ISCROUT)
      CALL PUTREC(20,'JOBARC','NUMVIBRT',1,NMODE)

      RETURN
      END

