if(NAME MATCHES "_APK_")
	set(APK ON)
	set(PRESET ci-android-apk)
elseif(NAME MATCHES "_AAR_")
	set(AAR ON)
	set(PRESET ci-android-aar)
else()
	step(${CMAKE_COMMAND} -DDIST_DIR=${T_DIST_DIR} -P ${CMAKE_DIR}/Merge.cmake)

	if(RELEASE)
		set(files *-sources.jar *.aar *.pom)
		foreach(file ${files})
			file(GLOB file "${T_DIST_DIR}/${file}")
			step(gpg --batch --passphrase $ENV{GPG_PSW} --pinentry-mode loopback -a --detach-sig -u $ENV{GPG_ID} ${file})
		endforeach()
	endif()

	if(NOT REVIEW)
		step(${CMAKE_COMMAND} -DCMD=DEPLOY_NEXUS -DPUBLISH=$ENV{PUBLISH} -P ${CMAKE_DIR}/cmd.cmake CHDIR ${T_DIST_DIR})
	endif()
	return()
endif()

if(REVIEW)
	set(PRESET ${PRESET}-review)
endif()

step(${T_CFG} --preset ${PRESET})
step(${T_BUILD})

if(APK)
	step(${T_TARGET} apk)
	step(${T_TARGET} verify.signature)
	step(${T_TARGET} dump.apk)
elseif(AAR)
	step(${T_TARGET} aar)
endif()

if(NOT RELEASE)
	step(${T_CTEST})
endif()
