{***********************************************************

Project:    C-evo External Map Generator
Copyright:  1999-2023 P Blackman
License:    GPLv3+

Numeric Settings for UI controls

***********************************************************}


procedure TFrmInterface.RG_LandMassChanged(Sender: TObject);
begin
    with Sender AS TRadioGroup do
        case ItemIndex of
            0: SE_OceanLevel.Value := 8;
            1: SE_OceanLevel.Value := 20;
            2: SE_OceanLevel.Value := 32;
            3: SE_OceanLevel.Value := 44;
            4: SE_OceanLevel.Value := 60;
            5: SE_OceanLevel.Value := 80;
            6: ;
        end;
end;

procedure TFrmInterface.RG_MountainsChanged(Sender: TObject);
begin
    with Sender AS TRadioGroup do
        case ItemIndex of
            0: SE_MountainLevel.Value := 0;
            1: SE_MountainLevel.Value := 5;
            2: SE_MountainLevel.Value := 10;
            3: SE_MountainLevel.Value := 15;
            4: SE_MountainLevel.Value := 20;
            5: ;
        end;
end;

procedure TFrmInterface.RG_AgeChanged(Sender: TObject);
begin
    with Sender AS TRadioGroup do
        case ItemIndex of
            0: SpinDim.Value := 2;
            1: SpinDim.Value := 3;
            2: SpinDim.Value := 4;
            3: SpinDim.Value := 5;
            4: SpinDim.Value := 6;
        end;
end;

procedure TFrmInterface.RG_SizeChanged(Sender: TObject);
begin
    with Sender AS TRadioGroup do
        case ItemIndex of
            0: SpinWave.Value := 8;
            1: SpinWave.Value := 12;
            2: SpinWave.Value := 16;
            3: SpinWave.Value := 22;
            4: SpinWave.Value := 28;
        end;
end;


{ Event handlers for Temperature Radio Groups }
procedure TFrmInterface.AdjustTempEqat(RG: TRadioGroup; Bias: TSpinEdit);
begin
    case RG.ItemIndex of
        0: Bias.Value := 85;
        1: Bias.Value := 70;
        2: Bias.Value := 55;
        3: Bias.Value := 40;
        4: Bias.Value := 25;
    end;
end;

procedure TFrmInterface.AdjustTempPole(RG: TRadioGroup; Bias: TSpinEdit);
begin
    case RG.ItemIndex of
        0: Bias.Value := 75;
        1: Bias.Value := 60;
        2: Bias.Value := 45;
        3: Bias.Value := 30;
        4: Bias.Value := 15;
    end;
end;

{ Event handler for Weather Radio Groups }
procedure TFrmInterface.AdjustRain(RG: TRadioGroup; Bias: TSpinEdit);
begin
    case RG.ItemIndex of
        0: Bias.Value := 30;
        1: Bias.Value := 45;
        2: Bias.Value := 60;
        3: Bias.Value := 75;
        4: Bias.Value := 90;
    end;
end;

procedure TFrmInterface.RG_RiversChanged(Sender: TObject);
begin
    with Sender AS tRadioGroup do
        case ItemIndex of
            0: SpinWater.Value := 30;
            1: SpinWater.Value := 50;
            2: SpinWater.Value := 70;
        end;
end;

procedure TFrmInterface.AdjustMapSize;
begin
    with RG_MapSize do
    begin
        case ItemIndex of
            0:
            begin
                SpinHeight.Value := 46;
                SpinWidth.Value  := 30;
            end;
            1:
            begin
                SpinHeight.Value := 52;
                SpinWidth.Value  := 40;
            end;
            2:
            begin
                SpinHeight.Value := 60;
                SpinWidth.Value  := 50;
            end;
            3:
            begin
                SpinHeight.Value := 70;
                SpinWidth.Value  := 60;
            end;
            4:
            begin
                SpinHeight.Value := 82;
                SpinWidth.Value  := 75;
            end;
            5:
            begin
                SpinHeight.Value := 90;
                SpinWidth.Value  := 84;
            end;
            6:
            begin
                SpinHeight.Value := 96;
                SpinWidth.Value  := 100;
            end;
            7:
            begin
                SpinHeight.Value := 120;
                SpinWidth.Value  := 105;
            end;
            8:
            begin
                SpinHeight.Value := 132;
                SpinWidth.Value  := 126;
            end;
        else
            ;
        end;
    end;
end;
