/*
 * Copyright 2002 Sun Microsystems, Inc.  All rights reserved.
 *
 * Use is subject to the GNU Lesser General Public License, Version 2.1,
 * February 1999, which is contained in the read-me file named
 * "README_GNU_LGPL." This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU
 * Lesser General Public License as published by the Free Software
 * Foundation; either version 2.1 of the License, or (at your
 * option) any later version. This library is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA.
 *
 * read functions for the lcd. we handle both buttons and 
 * reading from the panel. */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include "lcdutils.h"
#include "lcd_private.h"

int lcd_getdisplay(void *lcd_private, char **line1, char **line2, int *buttons) {
	struct lcd_private *lcd = lcd_private;
	
	if (!lcd || (lcd->fd < 0))
		return -1;
	
	ioctl(lcd->fd, LCD_Read, &lcd->display);
	if (line1) 
		*line1 = lcd->display.line1;
	if (line2)
		*line2 = lcd->display.line2;
	if (buttons)
		*buttons = lcd->display.buttons;
	return 0;
}

int lcd_readbutton(void *lcd_private) {
	struct lcd_private *lcd = lcd_private;
	
	if (!lcd || (lcd->fd < 0)) 
		return -1;
	
	ioctl(lcd->fd, BUTTON_Read, &lcd->display);
	return lcd->display.buttons;
}


int lcd_getbutton(void *lcd_private) {
	struct lcd_private *lcd = lcd_private;
	int i;
	
	if (!lcd || (lcd->fd < 0)) 
		return -2;
	
	return read(lcd->fd, &i, 1);
}
