/*
 *  Copyright 2011 Wolfgang Koller - http://www.gofg.at/
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#ifndef CORDOVA_H_DJJKASDM44
#define CORDOVA_H_DJJKASDM44

#include <QtCore>
#include <cassert>

#include "cplugin.h"

class QQuickView;
class QQuickItem;

class Cordova: public QObject {
    Q_OBJECT
    Q_PROPERTY(QString mainUrl READ mainUrl CONSTANT)

public:
    explicit Cordova(QDir wwwDir, QQuickItem *item, QObject *parent = nullptr);

    QString mainUrl() const;
    QObject *topLevelEventsReceiver();
    QQuickItem *rootObject();
    QString get_app_dir();

    void pushViewState(const QString &state);
    void popViewState(const QString &state);
    void confirmBox(int scId, const QString &message, const QString &title,  const QString &button1Name, const QString &button2Name, const QString &button3Name) {
        assert(!m_alertCallback);
        m_alertCallback = scId;
        emit confirm(message, title, button1Name, button2Name, button3Name);
    }
    void promptBox(int scId, const QString &message, const QString &title,  const QString &button1Name, const QString &button2Name, const QString &button3Name, const QString &defaultText) {
        assert(!m_alertCallback);
        m_alertCallback = scId;
        emit prompt(message, title, button1Name, button2Name, button3Name, defaultText);
    }
    void notificationDialogButtonPressed(int buttonId, const QString &text) {
        this->execJS(QString("Cordova.callback(%1, %2, atob('%3'));").arg(m_alertCallback).arg(buttonId).arg(QString(text.toUtf8().toBase64())));
        m_alertCallback = 0;
    }
    QString getSplashscreenPath();
signals:
    void confirm(const QString &message, const QString &title, const QString &button1Name, const QString &button2Name, const QString &button3Name);
    void prompt(const QString &message, const QString &title, const QString &button1Name, const QString &button2Name, const QString &button3Name, const QString &defaultText);
    void javaScriptExecNeeded(const QString &js);
    void pluginWantsToBeAdded(const QString &pluginName, QObject *pluginObject, const QString &pluginShortName);

public slots:
    void loadFinished(bool ok);
    void execJS(const QString &js);
    void setTitle(const QString &title);

private:
    int m_alertCallback;

    void initPlugins(QList<QString> requiredPlugins);
    QList<QString> getRequiredPluginNames(const QDir &xmlDir);

    QQuickItem *m_item;
    QList<QSharedPointer<CPlugin>> m_plugins;

    QDir m_www;
    QString m_mainUrl;
    QList<QString> m_states;
    Q_DISABLE_COPY(Cordova)
};

#endif
