#!/usr/bin/env bash

. lib

rm -rf garbage
mkdir garbage
cd garbage
darcs init
echo gobbledygook >> _darcs/format
cd ..

rm -rf future
mkdir future
cd future
darcs init
touch titi
darcs add titi
darcs record -am titi
cat > _darcs/format <<EOF
hashed|gobbledygook
darcs-2
EOF
cd ..

# check the rules for reading and writing

## garbage repo: we don't understand anything
rm -rf temp1
not darcs get garbage temp1 2> log
grep -i "read repository.*unknown format" log

# pull from garbage repo
rm -rf temp1
mkdir temp1
cd temp1
darcs init
not darcs pull ../garbage 2> log
grep -i "read repository.*unknown format" log
cd ..

# apply in garbage repo
rm -rf temp1
mkdir temp1
cd temp1
darcs init
darcs changes --context > empty-context
darcs tag -m "just a patch"
darcs send -a --context=empty-context -o ../bundle.dpatch .
cd ../garbage
not darcs apply ../bundle.dpatch 2> log
grep -i "read repository.*unknown format" log
cd ..

# add in garbage repo
cd garbage
touch toto
not darcs add toto 2> log
grep -i "read repository.*unknown format" log
cd ..

# rebase suspend in garbage repo
cd garbage
not darcs rebase suspend --last=1 2> log
grep -i "read repository.*unknown format" log
# issue2650
not grep 'Unknown format' _darcs/format
cd ..


## future repo: we don't understand one
#  alternative of a line of format
#  only look at future vs darcs2

skip-formats darcs-1

# get future repo: ok
# --to-match is needed because of bug###
rm -rf temp1
darcs get future temp1 --to-match "name titi"
cd temp1
darcs changes
touch toto
darcs add toto
darcs record -am 'blah'
cd ..

# pull from future repo: ok
rm -rf temp1
mkdir temp1
cd temp1
darcs init
darcs pull ../future -a
darcs changes | grep titi
cd ..

# apply in future repo: !ok
rm -rf temp1
mkdir temp1
cd temp1
darcs init
darcs changes --context > empty-context
darcs tag -m "just a patch"
darcs send -a --context=empty-context -o ../bundle.dpatch .
cd ../future
not darcs apply ../bundle.dpatch 2> log
cat log
grep -i "write repository.*unknown format" log
cd ..

# record in future repo: !ok
cd future
touch toto
not darcs add toto 2> log
grep -i "write repository.*unknown format" log
cd ..

# rebase suspend in future repo
cd future
not darcs rebase suspend --last=1 2> log
grep -i "write repository.*unknown format" log
# issue2650
not grep 'Unknown format' _darcs/format
cd ..
