//
// C++ Implementation: filelog
//
// Description: 
//
//
// Author: Arsenij Vodjanov <arsenij@gmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "filelog.h"

#define FLOG_ENABLE

// This should be retrieved from gui settings
#define FLOG_FILE_NAME "/tmp/backend.log"

using namespace std;

FileLog::FileLog() : fos(FLOG_FILE_NAME) { 
	fos << "--- Starting Log ----" << endl;
}

void FileLog::info(const boost::format& fmt)
{
#ifdef FLOG_ENABLE
 	fos << fmt << endl;
#endif
}

void FileLog::error(const boost::format& fmt)
{
#ifdef FLOG_ENABLE
 	fos << fmt << endl;
#endif
}

void FileLog::warn(const boost::format& fmt)
{
#ifdef FLOG_ENABLE
 	fos << fmt << endl;
#endif
}


void FileLog::debug(const boost::format& fmt,int level)
{
#ifdef FLOG_ENABLE
	if(level <= debugLevel ) 	
		fos << fmt << endl;
#endif
}

FileLog::~FileLog()
{
#ifdef FLOG_ENABLE
	fos << "--- Ending Log ----" << endl;
	fos.flush();
	fos.close();
#endif
}


