//
// C++ Interface: log
//
// Description: 
//
//
// Author: Rikard Björklind <olof@linux.nu>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef LOG_H__
#define LOG_H__


#include <boost/format.hpp>
//! Logging interface
class Log
{
    public:
		Log() {debugLevel=1000;}
        virtual void info(const boost::format& fmt) = 0;
        virtual void error(const boost::format& fmt) = 0;
        virtual void warn(const boost::format& fmt) = 0;
        virtual void debug(const boost::format& fmt,int level=1) = 0;
		void setLevel(int l) {debugLevel=l;}
		virtual ~Log() {}
	protected:
		int debugLevel;
};

extern Log* logger;


#endif
