/*
    Copyright (C) 2008-2010 Stefan Haller

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef DBUS_SERVER_H
#define DBUS_SERVER_H

#include <config.h>
#include <glib.h>

#ifdef USE_DBUS
#include <dbus/dbus-glib.h>

typedef struct {
    GObject parent;
    DBusGProxy *proxy;
} DBusServer;

typedef struct {
    GObjectClass parent_class;
} DBusServerClass;

enum
{
	SIGNAL_CHANGED,
	LAST_SIGNAL
};

void init_dbus();
void free_dbus();

gboolean dbus_server_next(DBusServer * self, GError ** error);
gboolean dbus_server_previous(DBusServer * self, GError ** error);

void emit_changed(const gchar * filename);

#endif
#endif
