.\" Copyright (c) 1995 Jim Van Zandt <jrv@vanzandt.mv.com> and aeb
.\" Sun Feb 26 11:46:23 MET 1995
.\"
.\" This is free documentation; you can redistribute it and/or
.\" modify it under the terms of the GNU General Public License as
.\" published by the Free Software Foundation; either version 2 of
.\" the License, or (at your option) any later version.
.\"
.\" The GNU General Public License's references to "object code"
.\" and "executables" are to be interpreted as the output of any
.\" document formatting or typesetting system, including
.\" intermediate and printed output.
.\"
.\" This manual is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public
.\" License along with this manual; if not, write to the Free
.\" Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111,
.\" USA.
.\"
.\" Modified, Sun Feb 26 15:04:20 1995, faith@cs.unc.edu
.\" Modified, Thu Apr 20 22:08:17 1995, jrv@vanzandt.mv.com
.\" Modified, Mon Sep 18 22:32:47 1995, hpa@storm.net (H. Peter Anvin)
.\" FIXME The following are not documented:
.\"     KDFONTOP (since 2.1.111)
.\"     KDGKBDIACRUC (since 2.6.24)
.\"     KDSKBDIACR
.\"     KDSKBDIACRUC (since 2.6.24)
.\"     KDKBDREP (since 2.1.113)
.\"     KDMAPDISP (not implemented as at 2.6.27)
.\"     KDUNMAPDISP (not implemented as at 2.6.27)
.\"     VT_LOCKSWITCH (since 1.3.47, needs CAP_SYS_TTY_CONFIG)
.\"     VT_UNLOCKSWITCH (since 1.3.47, needs CAP_SYS_TTY_CONFIG)
.\"     VT_GETHIFONTMASK (since 2.6.18)
.\"
.TH CONSOLE_IOCTL 4 2009-02-28 "Linux" "Linux Programmer's Manual"
.SH NAME
console_ioctl \- ioctl's for console terminal and virtual consoles
.SH DESCRIPTION
The following Linux-specific
.BR ioctl (2)
requests are supported.
Each requires a third argument, assumed here to be \fIargp\fP.
.IP \fBKDGETLED\fP
Get state of LEDs.
\fIargp\fP points to a \fIchar\fP.
The lower three bits
of \fI*argp\fP are set to the state of the LEDs, as follows:

.TS
l l l.
LED_CAP 	0x04	caps lock led
LEC_NUM 	0x02	num lock led
LED_SCR 	0x01	scroll lock led
.TE

.IP \fBKDSETLED\fP
Set the LEDs.
The LEDs are set to correspond to the lower three bits of
\fIargp\fP.
However, if a higher order bit is set,
the LEDs revert to normal: displaying the state of the
keyboard functions of caps lock, num lock, and scroll lock.
.LP
Before 1.1.54, the LEDs just reflected the state of the corresponding
keyboard flags, and KDGETLED/KDSETLED would also change the keyboard
flags.
Since 1.1.54 the leds can be made to display arbitrary
information, but by default they display the keyboard flags.
The following two ioctl's are used to access the keyboard flags.
.IP \fBKDGKBLED\fP
Get keyboard flags CapsLock, NumLock, ScrollLock (not lights).
\fIargp\fP points to a char which is set to the flag state.
The low order three bits (mask 0x7) get the current flag state,
and the low order bits of the next nibble (mask 0x70) get
the default flag state.
(Since 1.1.54.)
.IP \fBKDSKBLED\fP
Set keyboard flags CapsLock, NumLock, ScrollLock (not lights).
\fIargp\fP has the desired flag state.
The low order three bits (mask 0x7) have the flag state,
and the low order bits of the next nibble (mask 0x70) have
the default flag state.
(Since 1.1.54.)
.IP \fBKDGKBTYPE\fP
Get keyboard type.
This returns the value KB_101, defined as 0x02.
.IP \fBKDADDIO\fP
Add I/O port as valid.
Equivalent to \fIioperm(arg,1,1)\fP.
.IP \fBKDDELIO\fP
Delete I/O port as valid.
Equivalent to \fIioperm(arg,1,0)\fP.
.IP \fBKDENABIO\fP
Enable I/O to video board.
Equivalent to \fIioperm(0x3b4, 0x3df-0x3b4+1, 1)\fP.
.IP \fBKDDISABIO\fP
Disable I/O to video board.
Equivalent to \fIioperm(0x3b4, 0x3df-0x3b4+1, 0)\fP.
.IP \fBKDSETMODE\fP
Set text/graphics mode.
\fIargp\fP is one of these:

.TS
l l.
KD_TEXT    	0x00
KD_GRAPHICS	0x01
.TE

.IP \fBKDGETMODE\fP
Get text/graphics mode.
\fIargp\fP points to a \fIlong\fP which is set to one
of the above values.
.IP \fBKDMKTONE\fP
Generate tone of specified length.
The lower 16 bits of \fIargp\fP specify the period in clock cycles,
and the upper 16 bits give the duration in msec.
If the duration is zero, the sound is turned off.
Control returns immediately.
For example, \fIargp\fP = (125<<16) + 0x637 would specify
the beep normally associated with a ctrl-G.
(Thus since 0.99pl1; broken in 2.1.49-50.)
.IP \fBKIOCSOUND\fP
Start or stop sound generation.
The lower 16 bits of
\fIargp\fP specify the period in clock cycles
(that is, \fIargp\fP = 1193180/frequency).
\fIargp\fP = 0 turns sound off.
In either case, control returns immediately.
.IP \fBGIO_CMAP\fP
Get the current default color map from kernel.
\fIargp\fP points to
a 48-byte array.
(Since 1.3.3.)
.IP \fBPIO_CMAP\fP
Change the default text-mode color map.
\fIargp\fP points to a
48-byte array which contains, in order, the Red, Green, and Blue
values for the 16 available screen colors: 0 is off, and 255 is full
intensity.
The default colors are, in order: black, dark red, dark
green, brown, dark blue, dark purple, dark cyan, light grey, dark
grey, bright red, bright green, yellow, bright blue, bright purple,
bright cyan and white.
(Since 1.3.3.)
.IP \fBGIO_FONT\fP
Gets 256-character screen font in expanded form.
\fIargp\fP points to an 8192 byte array.
Fails with error code \fBEINVAL\fP if the
currently loaded font is a 512-character font, or if the console is
not in text mode.
.IP \fBGIO_FONTX\fP
Gets screen font and associated information.
\fIargp\fP points to a
\fIstruct consolefontdesc\fP (see \fBPIO_FONTX\fP).
On call, the
\fIcharcount\fP field should be set to the maximum number of
characters that would fit in the buffer pointed to by \fIchardata\fP.
On return, the \fIcharcount\fP and \fIcharheight\fP are filled with
the respective data for the currently loaded font, and the
\fIchardata\fP array contains the font data if the initial value of
\fIcharcount\fP indicated enough space was available; otherwise the
buffer is untouched and \fIerrno\fP is set to \fBENOMEM\fP.
(Since 1.3.1.)
.IP \fBPIO_FONT\fP
Sets 256-character screen font.
Load font into the EGA/VGA character
generator.
\fIargp\fP points to a 8192 byte map, with 32 bytes per
character.
Only first \fIN\fP of them are used for an 8x\fIN\fP font
(0 < \fIN\fP <= 32).
This call also invalidates the Unicode mapping.
.IP \fBPIO_FONTX\fP
Sets screen font and associated rendering information.
\fIargp\fP
points to a

.RS
.nf
.ft CW
struct consolefontdesc {
    unsigned short charcount;  /* characters in font
                                  (256 or 512) */
    unsigned short charheight; /* scan lines per
                                  character (1-32) */
    char          *chardata;   /* font data in
                                  expanded form */
};
.ft
.fi
.RE

If necessary, the screen will be appropriately resized, and
\fBSIGWINCH\fP sent to the appropriate processes.
This call also invalidates the Unicode mapping.
(Since 1.3.1.)
.IP \fBPIO_FONTRESET\fP
Resets the screen font, size and Unicode mapping to the bootup
defaults.
\fIargp\fP is unused, but should be set to NULL to
ensure compatibility with future versions of Linux.
(Since 1.3.28.)
.IP \fBGIO_SCRNMAP\fP
Get screen mapping from kernel.
\fIargp\fP points to an area of size
E_TABSZ, which is loaded with the font positions used to display each
character.
This call is likely to return useless information if the
currently loaded font is more than 256 characters.
.IP \fBGIO_UNISCRNMAP\fP
Get full Unicode screen mapping from kernel.
\fIargp\fP points to an
area of size E_TABSZ*sizeof(unsigned short), which is loaded with the
Unicodes each character represent.
A special set of Unicodes,
starting at U+F000, are used to represent "direct to font" mappings.
(Since 1.3.1.)
.IP \fBPIO_SCRNMAP\fP
Loads the "user definable" (fourth) table in the kernel which maps
bytes into console screen symbols.
\fIargp\fP points to an area of
size E_TABSZ.
.IP \fBPIO_UNISCRNMAP\fP
Loads the "user definable" (fourth) table in the kernel which maps
bytes into Unicodes, which are then translated into screen symbols
according to the currently loaded Unicode-to-font map.
Special Unicodes starting at U+F000 can be used to map directly to the font
symbols.
(Since 1.3.1.)
.IP \fBGIO_UNIMAP\fP
Get Unicode-to-font mapping from kernel.
\fIargp\fP points to a

.RS
.nf
.ft CW
struct unimapdesc {
    unsigned short  entry_ct;
    struct unipair *entries;
};
.ft
.fi
.RE

where \fIentries\fP points to an array of

.RS
.nf
.ft CW
struct unipair {
    unsigned short unicode;
    unsigned short fontpos;
};
.ft
.fi
.RE

(Since 1.1.92.)
.IP \fBPIO_UNIMAP\fP
Put unicode-to-font mapping in kernel.
    \fIargp\fP points to a
\fIstruct unimapdesc\fP.
(Since 1.1.92)
.IP \fBPIO_UNIMAPCLR\fP
Clear table, possibly advise hash algorithm.
\fIargp\fP points to a

.RS
.nf
.ft CW
struct unimapinit {
    unsigned short advised_hashsize;  /* 0 if no opinion */
    unsigned short advised_hashstep;  /* 0 if no opinion */
    unsigned short advised_hashlevel; /* 0 if no opinion */
};
.ft
.fi
.RE

(Since 1.1.92.)
.IP \fBKDGKBMODE\fP
Gets current keyboard mode.
\fIargp\fP points to a \fIlong\fP which is set to one
of these:

.TS
l l.
K_RAW      	0x00
K_XLATE    	0x01
K_MEDIUMRAW	0x02
K_UNICODE  	0x03
.TE

.IP \fBKDSKBMODE\fP
Sets current keyboard mode.
\fIargp\fP is a \fIlong\fP equal to one of the above values.
.IP \fBKDGKBMETA\fP
Gets meta key handling mode.
\fIargp\fP points to a \fIlong\fP which is
set to one of these:

.TS
l l l.
K_METABIT  	0x03	set high order bit
K_ESCPREFIX	0x04	escape prefix
.TE

.IP \fBKDSKBMETA\fP
Sets meta key handling mode.
\fIargp\fP is a \fIlong\fP equal to one of the above values.
.IP \fBKDGKBENT\fP
Gets one entry in key translation table (keycode to action code).
\fIargp\fP points to a

.RS
.nf
.ft CW
struct kbentry {
    unsigned char  kb_table;
    unsigned char  kb_index;
    unsigned short kb_value;
};
.ft
.fi
.RE

with the first two members filled in:
\fIkb_table\fP selects the key table (0 <= \fIkb_table\fP < MAX_NR_KEYMAPS),
and \fIkb_index\fP is the keycode (0 <= \fIkb_index\fP < NR_KEYS).
\fIkb_value\fP is set to the corresponding action code,
or K_HOLE if there is no such key,
or K_NOSUCHMAP if \fIkb_table\fP is invalid.
.IP \fBKDSKBENT\fP
Sets one entry in translation table.
\fIargp\fP points to
a \fIstruct kbentry\fP.
.IP \fBKDGKBSENT\fP
Gets one function key string.
\fIargp\fP points to a

.RS
.nf
.ft CW
struct kbsentry {
    unsigned char kb_func;
    unsigned char kb_string[512];
};
.ft
.fi
.RE

\fIkb_string\fP is set to the (null-terminated) string corresponding to
the \fIkb_func\fPth function key action code.
.IP \fBKDSKBSENT\fP
Sets one function key string entry.
\fIargp\fP points to
a \fIstruct kbsentry\fP.
.IP \fBKDGKBDIACR\fP
Read kernel accent table.
\fIargp\fP points to a

.RS
.nf
.ft CW
struct kbdiacrs {
    unsigned int   kb_cnt;
    struct kbdiacr kbdiacr[256];
};
.ft
.fi
.RE

where \fIkb_cnt\fP is the number of entries in the array, each of which
is a

.RS
.nf
.ft CW
struct kbdiacr {
    unsigned char diacr;
    unsigned char base;
    unsigned char result;
};
.ft
.fi
.RE
.IP \fBKDGETKEYCODE\fP
Read kernel keycode table entry (scan code to keycode).
\fIargp\fP points to a

.RS
.nf
.ft CW
struct kbkeycode {
    unsigned int scancode;
    unsigned int keycode;
};
.ft
.fi
.RE

\fIkeycode\fP is set to correspond to the given \fIscancode\fP.
(89 <= \fIscancode\fP <= 255 only.
For 1 <= \fIscancode\fP <= 88, \fIkeycode\fP==\fIscancode\fP.)
(Since 1.1.63.)
.IP \fBKDSETKEYCODE\fP
Write kernel keycode table entry.
\fIargp\fP points to
a \fIstruct kbkeycode\fP.
(Since 1.1.63.)
.IP \fBKDSIGACCEPT\fP
The calling process indicates its willingness to accept the signal
\fIargp\fP when it is generated by pressing an appropriate key combination.
(1 <= \fIargp\fP <= NSIG).
(See spawn_console() in linux/drivers/char/keyboard.c.)
.IP \fBVT_OPENQRY\fP
Returns the first available (non-opened) console.
\fIargp\fP points to an \fIint\fP which is set to the
number of the vt (1 <= \fI*argp\fP <= MAX_NR_CONSOLES).
.IP \fBVT_GETMODE\fP
Get mode of active vt.
\fIargp\fP points to a

.RS
.nf
.ft CW
struct vt_mode {
    char  mode;    /* vt mode */
    char  waitv;   /* if set, hang on writes if not active */
    short relsig;  /* signal to raise on release req */
    short acqsig;  /* signal to raise on acquisition */
    short frsig;   /* unused (set to 0) */
};
.ft
.fi
.RE

which is set to the mode of the active vt.
\fImode\fP is set to one of these values:

.TS
l l.
VT_AUTO   	auto vt switching
VT_PROCESS	process controls switching
VT_ACKACQ 	acknowledge switch
.TE

.IP \fBVT_SETMODE\fP
Set mode of active vt.
\fIargp\fP points to
a \fIstruct vt_mode\fP.
.IP \fBVT_GETSTATE\fP
Get global vt state info.
\fIargp\fP points to a

.RS
.nf
.ft CW
struct vt_stat {
    unsigned short v_active;  /* active vt */
    unsigned short v_signal;  /* signal to send */
    unsigned short v_state;   /* vt bit mask */
};
.ft
.fi
.RE

For each vt in use, the corresponding bit in the \fIv_state\fP member is set.
(Kernels 1.0 through 1.1.92.)
.IP \fBVT_RELDISP\fP
Release a display.
.IP \fBVT_ACTIVATE\fP
Switch to vt \fIargp\fP (1 <= \fIargp\fP <= MAX_NR_CONSOLES).
.IP \fBVT_WAITACTIVE\fP
Wait until vt \fIargp\fP has been activated.
.IP \fBVT_DISALLOCATE\fP
Deallocate the memory associated with vt \fIargp\fP.
(Since 1.1.54.)
.IP \fBVT_RESIZE\fP
Set the kernel's idea of screensize.
\fIargp\fP points to a

.RS
.nf
.ft CW
struct vt_sizes {
    unsigned short v_rows;       /* # rows */
    unsigned short v_cols;       /* # columns */
    unsigned short v_scrollsize; /* no longer used */
};
.ft
.fi
.RE

Note that this does not change the videomode.
See
.BR resizecons (8).
(Since 1.1.54.)
.IP \fBVT_RESIZEX\fP
Set the kernel's idea of various screen parameters.
\fIargp\fP points to a

.RS
.nf
.ft CW
struct vt_consize {
    unsigned short v_rows;  /* number of rows */
    unsigned short v_cols;  /* number of columns */
    unsigned short v_vlin;  /* number of pixel rows
                               on screen */
    unsigned short v_clin;  /* number of pixel rows
                               per character */
    unsigned short v_vcol;  /* number of pixel columns
                               on screen */
    unsigned short v_ccol;  /* number of pixel columns
                               per character */
};
.ft
.fi
.RE

Any parameter may be set to zero, indicating "no change", but if
multiple parameters are set, they must be self-consistent.
Note that this does not change the videomode.
See
.BR resizecons (8).
(Since 1.3.3.)
.PP
The action of the following ioctls depends on the first byte in the struct
pointed to by \fIargp\fP, referred to here as the \fIsubcode\fP.
These are legal only for the superuser or the owner of the current tty.
.IP "\fBTIOCLINUX, subcode=0\fP"
Dump the screen.
Disappeared in 1.1.92.  (With kernel 1.1.92 or later, read from
/dev/vcsN or /dev/vcsaN instead.)
.IP "\fBTIOCLINUX, subcode=1\fP"
Get task information.
Disappeared in 1.1.92.
.IP "\fBTIOCLINUX, subcode=2\fP"
Set selection.
\fIargp\fP points to a
.RS
.nf
.ft CW

struct {
   char  subcode;
   short xs, ys, xe, ye;
   short sel_mode;
};

.ft
.fi
.RE
\fIxs\fP and \fIys\fP are the starting column and row.
\fIxe\fP and \fIye\fP are the ending
column and row.
(Upper left corner is row=column=1.)
\fIsel_mode\fP is 0 for character-by-character selection,
1 for word-by-word selection,
or 2 for line-by-line selection.
The indicated screen characters are highlighted and saved
in the static array sel_buffer in devices/char/console.c.
.IP "\fBTIOCLINUX, subcode=3\fP"
Paste selection.
The characters in the selection buffer are
written to \fIfd\fP.
.IP "\fBTIOCLINUX, subcode=4\fP"
Unblank the screen.
.IP "\fBTIOCLINUX, subcode=5\fP"
Sets contents of a 256-bit look up table defining characters in a "word",
for word-by-word selection.
(Since 1.1.32.)
.IP "\fBTIOCLINUX, subcode=6\fP"
\fIargp\fP points to a char which is set to the value of the kernel
variable \fIshift_state\fP.
(Since 1.1.32.)
.IP "\fBTIOCLINUX, subcode=7\fP"
\fIargp\fP points to a char which is set to the value of the kernel
variable \fIreport_mouse\fP.
(Since 1.1.33.)
.IP "\fBTIOCLINUX, subcode=8\fP"
Dump screen width and height, cursor position, and all the
character-attribute pairs.
(Kernels 1.1.67 through 1.1.91 only.
With kernel 1.1.92 or later, read from /dev/vcsa* instead.)
.IP "\fBTIOCLINUX, subcode=9\fP"
Restore screen width and height, cursor position, and all the
character-attribute pairs.
(Kernels 1.1.67 through 1.1.91 only.
With kernel 1.1.92 or later, write to /dev/vcsa* instead.)
.IP "\fBTIOCLINUX, subcode=10\fP"
Handles the Power Saving
feature of the new generation of monitors.
VESA screen blanking mode is set to \fIargp\fP[1], which governs what
screen blanking does:

    \fI0\fP: Screen blanking is disabled.

    \fI1\fP: The current video adapter
register settings are saved, then the controller is programmed to turn off
the vertical synchronization pulses.
This puts the monitor into "standby" mode.
If your monitor has an Off_Mode timer, then
it will eventually power down by itself.

    \fI2\fP: The current
settings are saved, then both the vertical and horizontal
synchronization pulses are turned off.
This puts the monitor into "off" mode.
If your monitor has no Off_Mode timer,
or if you want your monitor to power down immediately when the
blank_timer times out, then you choose this option.
(\fICaution:\fP Powering down frequently will damage the monitor.)

(Since 1.1.76.)
.SH "RETURN VALUE"
On success, 0 is returned.
On error \-1 is returned, and \fIerrno\fP is set.
.SH ERRORS
\fIerrno\fP may take on these values:
.TP
.B EBADF
The file descriptor is invalid.
.TP
.B ENOTTY
The file descriptor is not associated with a character special device,
or the specified request does not apply to it.
.TP
.B EINVAL
The file descriptor or \fIargp\fP is invalid.
.TP
.B EPERM
Insufficient permission.
.SH NOTES
.BR Warning :
Do not regard this man page as documentation of the Linux console ioctl's.
This is provided for the curious only, as an alternative to reading the
source.
Ioctl's are undocumented Linux internals, liable to be changed
without warning.
(And indeed, this page more or less describes the
situation as of kernel version 1.1.94;
there are many minor and not-so-minor
differences with earlier versions.)

Very often, ioctl's are introduced for communication between the
kernel and one particular well-known program (fdisk, hdparm, setserial,
tunelp, loadkeys, selection, setfont, etc.), and their behavior will be
changed when required by this particular program.

Programs using these ioctl's will not be portable to other versions
of UNIX, will not work on older versions of Linux, and will not work
on future versions of Linux.

Use POSIX functions.
.SH "SEE ALSO"
.BR dumpkeys (1),
.BR kbd_mode (1),
.BR loadkeys (1),
.BR mknod (1),
.BR setleds (1),
.BR setmetamode (1),
.BR execve (2),
.BR fcntl (2),
.BR ioperm (2),
.BR termios (3),
.BR console (4),
.BR console_codes (4),
.BR mt (4),
.BR sd (4),
.BR tty (4),
.BR tty_ioctl (4),
.BR ttyS (4),
.BR vcs (4),
.BR vcsa (4),
.BR charsets (7),
.BR mapscrn (8),
.BR resizecons (8),
.BR setfont (8),
.IR /usr/include/linux/kd.h ,
.I /usr/include/linux/vt.h
.SH COLOPHON
This page is part of release 3.35 of the Linux
.I man-pages
project.
A description of the project,
and information about reporting bugs,
can be found at
http://man7.org/linux/man-pages/.
