/**
 * Copyright (c) 2005-2013 by Appcelerator, Inc. All Rights Reserved.
 * Licensed under the terms of the Eclipse Public License (EPL).
 * Please see the license.txt included with this distribution for details.
 * Any modifications to this file must keep this entire header intact.
 */
/*
 * Created on Mar 11, 2005
 *
 * @author Fabio Zadrozny
 */
package org.python.pydev.editor.codecompletion;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.Document;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IToken;
import org.python.pydev.core.TestDependent;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.editor.codecompletion.revisited.CodeCompletionTestsBase;
import org.python.pydev.editor.codecompletion.revisited.CompletionState;
import org.python.pydev.editor.codecompletion.revisited.modules.CompiledModule;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;

/**
 * @author Fabio Zadrozny
 */
public class PyCodeCompletion2Test extends CodeCompletionTestsBase {

    public static void main(String[] args) {
        junit.textui.TestRunner.run(PyCodeCompletion2Test.class);
    }

    /*
     * @see TestCase#setUp()
     */
    public void setUp() throws Exception {
        super.setUp();
        CompiledModule.COMPILED_MODULES_ENABLED = false;
        this.restorePythonPath(TestDependent.GetCompletePythonLib(true) +
                "|" + TestDependent.PYTHON_PIL_PACKAGES,
                false);
        this.restorePythonPath(false);
        codeCompletion = new PyCodeCompletion();
        PyCodeCompletion.onCompletionRecursionException = new ICallback<Object, CompletionRecursionException>() {

            public Object call(CompletionRecursionException e) {
                throw new RuntimeException("Recursion error:" + Log.getExceptionStr(e));
            }

        };
    }

    public void testSelfOrClsCompletion() throws Exception {
        String s = "" +
                "class B:\n" +
                "    def m2(self):\n" +
                "        pass\n" +
                "\n" +
                "class A:\n"
                +
                "    m1 = B()\n" +
                "    def foo(self):\n" +
                "        self.m1." +
                "";

        SystemPythonNature nature = new SystemPythonNature(PyCodeCompletion2Test.nature.getRelatedInterpreterManager());
        PySelection ps = new PySelection(new Document(s), s.length() - 1);
        ICompletionState state = new CompletionState(ps.getStartLineIndex(), ps.getAbsoluteCursorOffset()
                - ps.getStartLine().getOffset(), null, nature, "");
        CompletionRequest request = new CompletionRequest(null, nature, ps.getDoc(), "self.m1",
                ps.getAbsoluteCursorOffset(), 0, new PyCodeCompletion(), "");
        List<IToken> selfCompletions = new ArrayList<IToken>();
        PyCodeCompletion.getSelfOrClsCompletions(request, selfCompletions, state, false, false, "self.m1");
        assertEquals(1, selfCompletions.size());
        assertEquals("m2", selfCompletions.get(0).getRepresentation());

    }
}
