# -*- coding: utf-8 -*-
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2002  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
#
#
# ======================================================================
# Modules Python
# Modules Eficas

from desMCListAjout import Ui_DMCListAjout
from PyQt4.QtGui import *
from PyQt4.QtCore import *
from qtCommun import QTPanel



class DMCListAjout(Ui_DMCListAjout,QDialog):
   def __init__(self,parent ,modal ) :
       QDialog.__init__(self,parent)
       if hasattr(parent,"leLayout"):
          parent.leLayout.removeWidget(parent.leLayout.widgetActive)
          parent.leLayout.widgetActive.close()
          parent.leLayout.addWidget(self)
          parent.leLayout.widgetActive=self
       else:
          parent.partieDroite=QWidget()
          parent.leLayout=QGridLayout(parent.partieDroite)
          parent.leLayout.addWidget(self)
          parent.addWidget(parent.partieDroite)
          parent.leLayout.widgetActive=self
       self.setupUi(self)

# Import des panels

class MonMCListAjoutPanel(DMCListAjout,QTPanel):
  """
  Classe dfinissant le panel associ aux mots-cls qui demandent
   l'utilisateur de choisir une seule valeur parmi une liste de valeurs
  discrtes
  """
  def __init__(self,node,parent = None,name = None,fl = 0):
        #print "MonMCListAjoutPanel"
        DMCListAjout.__init__(self,parent,fl)
        QTPanel.__init__(self,node,parent)
        monMCFact=self.node.item.get_nom()
        self.MCFacteur.setText(QString(monMCFact))
        self.MCFacteur.setAlignment(Qt.AlignHCenter)
        self.connecterSignaux()

  def connecterSignaux(self):
        self.connect(self.bAjout,SIGNAL("clicked()"),self.BAjoutClicked)

  def BAjoutClicked(self):
        self.node.treeParent.append_child(self.node.item.get_nom())


