/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class PrefixQuery
extends Query {
    private Term prefix;

    public PrefixQuery(Term prefix) {
        this.prefix = prefix;
    }

    public Term getPrefix() {
        return this.prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query rewrite(IndexReader reader) throws IOException {
        BooleanQuery query = new BooleanQuery();
        TermEnum enumerator = reader.terms(this.prefix);
        try {
            Term term;
            String prefixText = this.prefix.text();
            String prefixField = this.prefix.field();
            while ((term = enumerator.term()) != null && term.text().startsWith(prefixText) && term.field() == prefixField) {
                TermQuery tq = new TermQuery(term);
                tq.setBoost(this.getBoost());
                query.add(tq, false, false);
                if (enumerator.next()) continue;
                break;
            }
        }
        finally {
            enumerator.close();
        }
        return query;
    }

    public Query combine(Query[] queries) {
        return Query.mergeBooleanQueries(queries);
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.prefix.field().equals(field)) {
            buffer.append(this.prefix.field());
            buffer.append(":");
        }
        buffer.append(this.prefix.text());
        buffer.append('*');
        if (this.getBoost() != 1.0f) {
            buffer.append("^");
            buffer.append(Float.toString(this.getBoost()));
        }
        return buffer.toString();
    }
}

