/* $Id: emergency.c,v 1.4 2001/04/22 15:20:38 japh Exp $
 * emergency.c  -- fancylogin emergency-handling
 *
 *             fancylogin uses ncurses to display a colorful login-
 *             screen with input-masks.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Written by Richard Bergmair.
 * ANSI-conformance testing by Andreas Krennmair
 */



#include <malloc.h>
#include <unistd.h>

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include "environment.h"
#include "limits.h"
#include "log_message.h"
#include "fancy.h"
#include "emergency.h"





void fatal(void);


/*****************************************************************************/
/* fatal: should be called for fatal errors.                                 */
/*****************************************************************************/

void
fatal (void)
{
  close_prompt ();
 
#ifdef EXECUTE_EMERGENCY_LOGIN
  for (;;)
    {
      execl (EMERGENCY_LOGIN, EMERGENCY_LOGIN, NULL);
      log_message (1, "Because of a found NULL pointer, I tried to execute "
                      "the emergency login (" EMERGENCY_LOGIN 
		      "), which failed.");
      sleep (5*60);
    }
#endif
}



/*****************************************************************************/
/* (c) Copyright 1999-2000 Richard Bergmair, 2000-2001 Andreas Krennmair     */
/*****************************************************************************/
