/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xmlrpc.AuthenticatedXmlRpcHandler;
import org.apache.xmlrpc.Invoker;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;

public class XmlRpcServer {
    Hashtable handlers;
    Stack pool = new Stack();
    int workers = 0;

    public XmlRpcServer() {
        this.handlers = new Hashtable();
    }

    public void addHandler(String string, Object object) {
        if (object instanceof XmlRpcHandler || object instanceof AuthenticatedXmlRpcHandler) {
            this.handlers.put(string, object);
        } else if (object != null) {
            this.handlers.put(string, new Invoker(object));
        }
    }

    public void removeHandler(String string) {
        this.handlers.remove(string);
    }

    public byte[] execute(InputStream inputStream) {
        return this.execute(inputStream, null, null);
    }

    public byte[] execute(InputStream inputStream, String string, String string2) {
        Worker worker = this.getWorker();
        byte[] byArray = worker.execute(inputStream, string, string2);
        this.pool.push(worker);
        return byArray;
    }

    private final Worker getWorker() {
        try {
            return (Worker)this.pool.pop();
        }
        catch (EmptyStackException emptyStackException) {
            if (this.workers < 100) {
                ++this.workers;
                return new Worker();
            }
            throw new RuntimeException("System overload");
        }
    }

    class Worker
    extends XmlRpc {
        Vector inParams;
        Object outParam;
        byte[] result;
        StringBuffer strbuf;

        Worker() {
        }

        public byte[] execute(InputStream inputStream, String string, String string2) {
            this.inParams = new Vector();
            if (this.strbuf == null) {
                this.strbuf = new StringBuffer();
            } else {
                this.strbuf.setLength(0);
            }
            long l = System.currentTimeMillis();
            try {
                this.parse(inputStream);
                if (XmlRpc.debug) {
                    System.err.println("method name: " + this.methodName);
                    System.err.println("inparams: " + this.inParams);
                }
                if (this.errorLevel > 0) {
                    throw new Exception(this.errorMsg);
                }
                Object var6_5 = null;
                String string3 = null;
                int n = this.methodName.lastIndexOf(46);
                if (n > -1 && (var6_5 = XmlRpcServer.this.handlers.get(string3 = this.methodName.substring(0, n))) != null) {
                    this.methodName = this.methodName.substring(n + 1);
                }
                if (var6_5 == null) {
                    var6_5 = XmlRpcServer.this.handlers.get("$default");
                }
                if (var6_5 == null) {
                    if (n > -1) {
                        throw new Exception("RPC handler object \"" + string3 + "\" not found and no default handler registered.");
                    }
                    throw new Exception("RPC handler object not found for \"" + this.methodName + "\": no default handler registered.");
                }
                this.outParam = var6_5 instanceof AuthenticatedXmlRpcHandler ? ((AuthenticatedXmlRpcHandler)var6_5).execute(this.methodName, this.inParams, string, string2) : ((XmlRpcHandler)var6_5).execute(this.methodName, this.inParams);
                if (XmlRpc.debug) {
                    System.err.println("outparam = " + this.outParam);
                }
                XmlRpc.XmlWriter xmlWriter = new XmlRpc.XmlWriter(this.strbuf);
                this.writeResponse(this.outParam, xmlWriter);
                this.result = xmlWriter.getBytes();
            }
            catch (Exception exception) {
                if (XmlRpc.debug) {
                    exception.printStackTrace();
                }
                XmlRpc.XmlWriter xmlWriter = new XmlRpc.XmlWriter(this.strbuf);
                String string4 = exception.toString();
                int n = exception instanceof XmlRpcException ? ((XmlRpcException)exception).code : 0;
                try {
                    this.writeError(n, string4, xmlWriter);
                }
                catch (XmlRpcException xmlRpcException) {
                    // empty catch block
                }
                try {
                    this.result = xmlWriter.getBytes();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.err.println("XmlRpcServer.execute: " + unsupportedEncodingException);
                    this.result = xmlWriter.toString().getBytes();
                }
            }
            if (XmlRpc.debug) {
                System.err.println("Spent " + (System.currentTimeMillis() - l) + " millis in request");
            }
            return this.result;
        }

        void objectParsed(Object object) {
            this.inParams.addElement(object);
        }

        void writeResponse(Object object, XmlRpc.XmlWriter xmlWriter) throws XmlRpcException {
            xmlWriter.startElement("methodResponse");
            xmlWriter.startElement("params");
            xmlWriter.startElement("param");
            this.writeObject(object, xmlWriter);
            xmlWriter.endElement("param");
            xmlWriter.endElement("params");
            xmlWriter.endElement("methodResponse");
        }

        void writeError(int n, String string, XmlRpc.XmlWriter xmlWriter) throws XmlRpcException {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("faultCode", new Integer(n));
            hashtable.put("faultString", string);
            xmlWriter.startElement("methodResponse");
            xmlWriter.startElement("fault");
            this.writeObject(hashtable, xmlWriter);
            xmlWriter.endElement("fault");
            xmlWriter.endElement("methodResponse");
        }
    }
}

