#define XERR
#include "modules.ih"

Modules::Modules()
{
    Arg const &arg = Arg::instance();

    if (string dir = arg[0]; dir != ".")
    {
        fs::current_path(dir, s_errorCode);
        if (s_errorCode)
            throw Exception{} << "can't chdir to " << dir;

    }

    if (not arg.option('c'))
        d_colors = " -fdiagnostics-color=never ";

    d_dependencies = arg.option('d');       // show the dependencies

    if (d_dependencies or not arg.option('V'))
        imsg.off();
        
    if (not arg.option(&d_interface_cc, 'm'))
        d_interface_cc = "module.cc";

    if (not arg.option('s'))
        d_location = "../tmp/o/";
    
    if (char const *std = getenv("ICMAKE_CXXFLAGS"); std != 0)
        d_std = std;

    pushCwd();
    createDir("gcm.cache");                 // may already exist
    createDirs("tmp/o");                    // may already exist
    createSymlink("/usr", "gcm.cache/usr");
        
}
