/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) 2020 - 2024 Intel Corporation
 */

#ifndef IPU7_ISYS_CSI2_REG_H
#define IPU7_ISYS_CSI2_REG_H

/* IS main regs base */
#define IS_MAIN_BASE				(0x240000)
#define IS_MAIN_S2B_BASE			(IS_MAIN_BASE + 0x22000)
#define IS_MAIN_B2O_BASE			(IS_MAIN_BASE + 0x26000)
#define IS_MAIN_ISD_M0_BASE			(IS_MAIN_BASE + 0x2b000)
#define IS_MAIN_ISD_M1_BASE			(IS_MAIN_BASE + 0x2b100)
#define IS_MAIN_ISD_INT_BASE			(IS_MAIN_BASE + 0x2b200)
#define IS_MAIN_GDA_BASE			(IS_MAIN_BASE + 0x32000)
#define IS_MAIN_GPREGS_MAIN_BASE		(IS_MAIN_BASE + 0x32500)
#define IS_MAIN_IRQ_CTRL_BASE			(IS_MAIN_BASE + 0x32700)
#define IS_MAIN_PWM_CTRL_BASE			(IS_MAIN_BASE + 0x32b00)

#define S2B_IRQ_COMMON_0_CTL_STATUS		(IS_MAIN_S2B_BASE + 0x1c)
#define S2B_IRQ_COMMON_0_CTL_CLEAR		(IS_MAIN_S2B_BASE + 0x20)
#define S2B_IRQ_COMMON_0_CTL_ENABLE		(IS_MAIN_S2B_BASE + 0x24)
#define S2B_IID_IRQ_CTL_STATUS(iid)		(IS_MAIN_S2B_BASE + 0x94 + \
						 0x100 * (iid))

#define B2O_IRQ_COMMON_0_CTL_STATUS		(IS_MAIN_B2O_BASE + 0x30)
#define B2O_IRQ_COMMON_0_CTL_CLEAR		(IS_MAIN_B2O_BASE + 0x34)
#define B2O_IRQ_COMMON_0_CTL_ENABLE		(IS_MAIN_B2O_BASE + 0x38)
#define B2O_IID_IRQ_CTL_STATUS(oid)		(IS_MAIN_B2O_BASE + 0x3dc + \
						 0x200 * (oid))

#define ISD_M0_IRQ_CTL_STATUS			(IS_MAIN_ISD_M0_BASE + 0x1c)
#define ISD_M0_IRQ_CTL_CLEAR			(IS_MAIN_ISD_M0_BASE + 0x20)
#define ISD_M0_IRQ_CTL_ENABLE			(IS_MAIN_ISD_M0_BASE + 0x24)

#define ISD_M1_IRQ_CTL_STATUS			(IS_MAIN_ISD_M1_BASE + 0x1c)
#define ISD_M1_IRQ_CTL_CLEAR			(IS_MAIN_ISD_M1_BASE + 0x20)
#define ISD_M1_IRQ_CTL_ENABLE			(IS_MAIN_ISD_M1_BASE + 0x24)

#define ISD_INT_IRQ_CTL_STATUS			(IS_MAIN_ISD_INT_BASE + 0x1c)
#define ISD_INT_IRQ_CTL_CLEAR			(IS_MAIN_ISD_INT_BASE + 0x20)
#define ISD_INT_IRQ_CTL_ENABLE			(IS_MAIN_ISD_INT_BASE + 0x24)

#define GDA_IRQ_CTL_STATUS			(IS_MAIN_GDA_BASE + 0x1c)
#define GDA_IRQ_CTL_CLEAR			(IS_MAIN_GDA_BASE + 0x20)
#define GDA_IRQ_CTL_ENABLE			(IS_MAIN_GDA_BASE + 0x24)

#define IS_MAIN_IRQ_CTL_EDGE			(IS_MAIN_IRQ_CTRL_BASE + 0x0)
#define IS_MAIN_IRQ_CTL_MASK			(IS_MAIN_IRQ_CTRL_BASE + 0x4)
#define IS_MAIN_IRQ_CTL_STATUS			(IS_MAIN_IRQ_CTRL_BASE + 0x8)
#define IS_MAIN_IRQ_CTL_CLEAR			(IS_MAIN_IRQ_CTRL_BASE + 0xc)
#define IS_MAIN_IRQ_CTL_ENABLE			(IS_MAIN_IRQ_CTRL_BASE + 0x10)
#define IS_MAIN_IRQ_CTL_LEVEL_NOT_PULSE		(IS_MAIN_IRQ_CTRL_BASE + 0x14)

/* IS IO regs base */
#define IS_PHY_NUM				(4)
#define IS_IO_BASE				(0x280000)

/* dwc csi cdphy registers */
#define IS_IO_CDPHY_BASE(i)			(IS_IO_BASE + 0x10000 * (i))
#define PPI_STARTUP_RW_COMMON_DPHY_0			0x1800
#define PPI_STARTUP_RW_COMMON_DPHY_1			0x1802
#define PPI_STARTUP_RW_COMMON_DPHY_2			0x1804
#define PPI_STARTUP_RW_COMMON_DPHY_3			0x1806
#define PPI_STARTUP_RW_COMMON_DPHY_4			0x1808
#define PPI_STARTUP_RW_COMMON_DPHY_5			0x180a
#define PPI_STARTUP_RW_COMMON_DPHY_6			0x180c
#define PPI_STARTUP_RW_COMMON_DPHY_7			0x180e
#define PPI_STARTUP_RW_COMMON_DPHY_8			0x1810
#define PPI_STARTUP_RW_COMMON_DPHY_9			0x1812
#define PPI_STARTUP_RW_COMMON_DPHY_A			0x1814
#define PPI_STARTUP_RW_COMMON_DPHY_10			0x1820
#define PPI_STARTUP_RW_COMMON_STARTUP_1_1		0x1822
#define PPI_STARTUP_RW_COMMON_STARTUP_1_2		0x1824
#define PPI_CALIBCTRL_RW_COMMON_CALIBCTRL_2_0		0x1840
#define PPI_CALIBCTRL_R_COMMON_CALIBCTRL_2_1		0x1842
#define PPI_CALIBCTRL_R_COMMON_CALIBCTRL_2_2		0x1844
#define PPI_CALIBCTRL_R_COMMON_CALIBCTRL_2_3		0x1846
#define PPI_CALIBCTRL_R_COMMON_CALIBCTRL_2_4		0x1848
#define PPI_CALIBCTRL_R_COMMON_CALIBCTRL_2_5		0x184a
#define PPI_CALIBCTRL_RW_COMMON_BG_0			0x184c
#define PPI_CALIBCTRL_RW_COMMON_CALIBCTRL_2_7		0x184e
#define PPI_CALIBCTRL_RW_ADC_CFG_0			0x1850
#define PPI_CALIBCTRL_RW_ADC_CFG_1			0x1852
#define PPI_CALIBCTRL_R_ADC_DEBUG			0x1854
#define PPI_RW_LPDCOCAL_TOP_OVERRIDE			0x1c00
#define PPI_RW_LPDCOCAL_TIMEBASE			0x1c02
#define PPI_RW_LPDCOCAL_NREF				0x1c04
#define PPI_RW_LPDCOCAL_NREF_RANGE			0x1c06
#define PPI_RW_LPDCOCAL_NREF_TRIGGER_MAN		0x1c08
#define PPI_RW_LPDCOCAL_TWAIT_CONFIG			0x1c0a
#define PPI_RW_LPDCOCAL_VT_CONFIG			0x1c0c
#define PPI_R_LPDCOCAL_DEBUG_RB				0x1c0e
#define PPI_RW_LPDCOCAL_COARSE_CFG			0x1c10
#define PPI_R_LPDCOCAL_DEBUG_COARSE_RB			0x1c12
#define PPI_R_LPDCOCAL_DEBUG_COARSE_MEAS_0_RB		0x1c14
#define PPI_R_LPDCOCAL_DEBUG_COARSE_MEAS_1_RB		0x1c16
#define PPI_R_LPDCOCAL_DEBUG_COARSE_FWORD_RB		0x1c18
#define PPI_R_LPDCOCAL_DEBUG_MEASURE_CURR_ERROR		0x1c1a
#define PPI_R_LPDCOCAL_DEBUG_MEASURE_LAST_ERROR		0x1c1c
#define PPI_R_LPDCOCAL_DEBUG_VT				0x1c1e
#define PPI_RW_LB_TIMEBASE_CONFIG			0x1c20
#define PPI_RW_LB_STARTCMU_CONFIG			0x1c22
#define PPI_R_LBPULSE_COUNTER_RB			0x1c24
#define PPI_R_LB_START_CMU_RB				0x1c26
#define PPI_RW_LB_DPHY_BURST_START			0x1c28
#define PPI_RW_LB_CPHY_BURST_START			0x1c2a
#define PPI_RW_DDLCAL_CFG_0				0x1c40
#define PPI_RW_DDLCAL_CFG_1				0x1c42
#define PPI_RW_DDLCAL_CFG_2				0x1c44
#define PPI_RW_DDLCAL_CFG_3				0x1c46
#define PPI_RW_DDLCAL_CFG_4				0x1c48
#define PPI_RW_DDLCAL_CFG_5				0x1c4a
#define PPI_RW_DDLCAL_CFG_6				0x1c4c
#define PPI_RW_DDLCAL_CFG_7				0x1c4e
#define PPI_R_DDLCAL_DEBUG_0				0x1c50
#define PPI_R_DDLCAL_DEBUG_1				0x1c52
#define PPI_RW_PARITY_TEST				0x1c60
#define PPI_RW_STARTUP_OVR_0				0x1c62
#define PPI_RW_STARTUP_STATE_OVR_1			0x1c64
#define PPI_RW_DTB_SELECTOR				0x1c66
#define PPI_RW_DPHY_CLK_SPARE				0x1c6a
#define PPI_RW_COMMON_CFG				0x1c6c
#define PPI_RW_TERMCAL_CFG_0				0x1c80
#define PPI_R_TERMCAL_DEBUG_0				0x1c82
#define PPI_RW_TERMCAL_CTRL_0				0x1c84
#define PPI_RW_OFFSETCAL_CFG_0				0x1ca0
#define PPI_R_OFFSETCAL_DEBUG_LANE0			0x1ca2
#define PPI_R_OFFSETCAL_DEBUG_LANE1			0x1ca4
#define PPI_R_OFFSETCAL_DEBUG_LANE2			0x1ca6
#define PPI_R_OFFSETCAL_DEBUG_LANE3			0x1ca8
#define PPI_R_OFFSETCAL_DEBUG_LANE4			0x1caa
#define PPI_RW_HSDCOCAL_CFG_O				0x1d00
#define PPI_RW_HSDCOCAL_CFG_1				0x1d02
#define PPI_RW_HSDCOCAL_CFG_2				0x1d04
#define PPI_RW_HSDCOCAL_CFG_3				0x1d06
#define PPI_RW_HSDCOCAL_CFG_4				0x1d08
#define PPI_RW_HSDCOCAL_CFG_5				0x1d0a
#define PPI_RW_HSDCOCAL_CFG_6				0x1d0c
#define PPI_RW_HSDCOCAL_CFG_7				0x1d0e
#define PPI_RW_HSDCOCAL_CFG_8				0x1d10
#define PPI_R_HSDCOCAL_DEBUG_RB				0x1d12
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_0	0x2000
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_1	0x2002
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_2	0x2004
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_3	0x2006
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_4	0x2008
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_5	0x200a
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_6	0x200c
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_7	0x200e
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_8	0x2010
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE0_OVR_0_9	0x2012
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE0_OVR_0_10	0x2014
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE0_OVR_0_11	0x2016
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE0_OVR_0_12	0x2018
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE0_OVR_0_13	0x201a
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE0_OVR_0_14	0x201c
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE0_OVR_0_15	0x201e
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_0	0x2020
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_1	0x2022
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_2	0x2024
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_3	0x2026
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_4	0x2028
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_5	0x202a
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_6	0x202c
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_7	0x202e
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_8	0x2030
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_9	0x2032
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_1_10	0x2034
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_1_11	0x2036
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_1_12	0x2038
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_1_13	0x203a
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_1_14	0x203c
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_1_15	0x203e
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_0		0x2040
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_1		0x2042
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_2		0x2044
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_3		0x2046
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_4		0x2048
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_5		0x204a
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_6		0x204c
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_7		0x204e
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_8		0x2050
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_9		0x2052
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_10		0x2054
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_11		0x2056
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_12		0x2058
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_13		0x205a
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_14		0x205c
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_15		0x205e
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_3_0		0x2060
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_3_1		0x2062
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_3_2		0x2064
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_3_3		0x2066
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_3_4		0x2068
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_3_5		0x206a
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_3_6		0x206c
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_3_7		0x206e
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_3_8		0x2070
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_3_9		0x2072
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_3_10		0x2074
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_3_11		0x2076
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_3_12		0x2078
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_3_13		0x207a
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_3_14		0x207c
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_3_15		0x207e
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_4_0		0x2080
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_4_1		0x2082
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_4_2		0x2084
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_4_3		0x2086
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_4_4		0x2088
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_5_0	0x20a0
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_5_1	0x20a2
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_5_2	0x20a4
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_5_3	0x20a6
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_5_4	0x20a8
#define CORE_DIG_RW_TRIO0_0				0x2100
#define CORE_DIG_RW_TRIO0_1				0x2102
#define CORE_DIG_RW_TRIO0_2				0x2104
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_0	0x2400
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_1	0x2402
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_2	0x2404
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_3	0x2406
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_4	0x2408
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_5	0x240a
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_6	0x240c
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_7	0x240e
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_8	0x2410
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE1_OVR_0_9	0x2412
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE1_OVR_0_10	0x2414
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE1_OVR_0_11	0x2416
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE1_OVR_0_12	0x2418
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE1_OVR_0_13	0x241a
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE1_OVR_0_14	0x241c
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE1_OVR_0_15	0x241e
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_0	0x2420
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_1	0x2422
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_2	0x2424
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_3	0x2426
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_4	0x2428
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_5	0x242a
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_6	0x242c
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_7	0x242e
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_8	0x2430
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_9	0x2432
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_1_10	0x2434
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_1_11	0x2436
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_1_12	0x2438
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_1_13	0x243a
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_1_14	0x243c
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_1_15	0x243e
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_0		0x2440
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_1		0x2442
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_2		0x2444
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_3		0x2446
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_4		0x2448
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_5		0x244a
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_6		0x244c
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_7		0x244e
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_8		0x2450
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_9		0x2452
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_10		0x2454
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_11		0x2456
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_12		0x2458
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_13		0x245a
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_14		0x245c
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_15		0x245e
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_3_0		0x2460
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_3_1		0x2462
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_3_2		0x2464
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_3_3		0x2466
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_3_4		0x2468
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_3_5		0x246a
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_3_6		0x246c
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_3_7		0x246e
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_3_8		0x2470
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_3_9		0x2472
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_3_10		0x2474
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_3_11		0x2476
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_3_12		0x2478
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_3_13		0x247a
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_3_14		0x247c
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_3_15		0x247e
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_4_0		0x2480
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_4_1		0x2482
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_4_2		0x2484
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_4_3		0x2486
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_4_4		0x2488
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_5_0	0x24a0
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_5_1	0x24a2
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_5_2	0x24a4
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_5_3	0x24a6
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_5_4	0x24a8
#define CORE_DIG_RW_TRIO1_0				0x2500
#define CORE_DIG_RW_TRIO1_1				0x2502
#define CORE_DIG_RW_TRIO1_2				0x2504
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_0	0x2800
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_1	0x2802
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_2	0x2804
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_3	0x2806
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_4	0x2808
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_5	0x280a
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_6	0x280c
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_7	0x280e
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_8	0x2810
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE2_OVR_0_9	0x2812
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE2_OVR_0_10	0x2814
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE2_OVR_0_11	0x2816
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE2_OVR_0_12	0x2818
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE2_OVR_0_13	0x281a
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE2_OVR_0_14	0x281c
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE2_OVR_0_15	0x281e
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_0	0x2820
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_1	0x2822
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_2	0x2824
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_3	0x2826
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_4	0x2828
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_5	0x282a
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_6	0x282c
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_7	0x282e
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_8	0x2830
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_9	0x2832
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_1_10	0x2834
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_1_11	0x2836
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_1_12	0x2838
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_1_13	0x283a
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_1_14	0x283c
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_1_15	0x283e
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_0		0x2840
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_1		0x2842
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_2		0x2844
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_3		0x2846
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_4		0x2848
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_5		0x284a
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_6		0x284c
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_7		0x284e
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_8		0x2850
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_9		0x2852
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_10		0x2854
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_11		0x2856
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_12		0x2858
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_13		0x285a
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_14		0x285c
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_15		0x285e
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_3_0		0x2860
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_3_1		0x2862
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_3_2		0x2864
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_3_3		0x2866
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_3_4		0x2868
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_3_5		0x286a
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_3_6		0x286c
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_3_7		0x286e
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_3_8		0x2870
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_3_9		0x2872
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_3_10		0x2874
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_3_11		0x2876
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_3_12		0x2878
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_3_13		0x287a
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_3_14		0x287c
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_3_15		0x287e
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_4_0		0x2880
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_4_1		0x2882
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_4_2		0x2884
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_4_3		0x2886
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_4_4		0x2888
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_5_0	0x28a0
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_5_1	0x28a2
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_5_2	0x28a4
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_5_3	0x28a6
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_5_4	0x28a8
#define CORE_DIG_RW_TRIO2_0				0x2900
#define CORE_DIG_RW_TRIO2_1				0x2902
#define CORE_DIG_RW_TRIO2_2				0x2904
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_0	0x2c00
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_1	0x2c02
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_2	0x2c04
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_3	0x2c06
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_4	0x2c08
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_5	0x2c0a
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_6	0x2c0c
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_7	0x2c0e
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_8	0x2c10
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE3_OVR_0_9	0x2c12
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE3_OVR_0_10	0x2c14
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE3_OVR_0_11	0x2c16
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE3_OVR_0_12	0x2c18
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE3_OVR_0_13	0x2c1a
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE3_OVR_0_14	0x2c1c
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE3_OVR_0_15	0x2c1e
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_0		0x2c40
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_1		0x2c42
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_2		0x2c44
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_3		0x2c46
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_4		0x2c48
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_5		0x2c4a
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_6		0x2c4c
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_7		0x2c4e
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_8		0x2c50
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_9		0x2c52
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_10		0x2c54
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_11		0x2c56
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_12		0x2c58
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_13		0x2c5a
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_14		0x2c5c
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_15		0x2c5e
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_3_0		0x2c60
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_3_1		0x2c62
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_3_2		0x2c64
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_3_3		0x2c66
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_3_4		0x2c68
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_3_5		0x2c6a
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_3_6		0x2c6c
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_3_7		0x2c6e
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_3_8		0x2c70
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_3_9		0x2c72
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_3_10		0x2c74
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_3_11		0x2c76
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_3_12		0x2c78
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_3_13		0x2c7a
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_3_14		0x2c7c
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_3_15		0x2c7e
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_4_0		0x2c80
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_4_1		0x2c82
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_4_2		0x2c84
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_4_3		0x2c86
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_4_4		0x2c88
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_0		0x3040
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_1		0x3042
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_2		0x3044
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_3		0x3046
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_4		0x3048
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_5		0x304a
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_6		0x304c
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_7		0x304e
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_8		0x3050
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_9		0x3052
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_10		0x3054
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_11		0x3056
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_12		0x3058
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_13		0x305a
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_14		0x305c
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_15		0x305e
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_3_0		0x3060
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_3_1		0x3062
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_3_2		0x3064
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_3_3		0x3066
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_3_4		0x3068
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_3_5		0x306a
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_3_6		0x306c
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_3_7		0x306e
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_3_8		0x3070
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_3_9		0x3072
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_3_10		0x3074
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_3_11		0x3076
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_3_12		0x3078
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_3_13		0x307a
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_3_14		0x307c
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_3_15		0x307e
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_4_0		0x3080
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_4_1		0x3082
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_4_2		0x3084
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_4_3		0x3086
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_4_4		0x3088
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_CLK_OVR_0_0		0x3400
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_CLK_OVR_0_1		0x3402
#define CORE_DIG_IOCTRL_R_DPHY_PPI_CLK_OVR_0_2		0x3404
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_0		0x3800
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_1		0x3802
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_2		0x3804
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_3		0x3806
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_4		0x3808
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_5		0x380a
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_6		0x380c
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_7		0x380e
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_8		0x3810
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_9		0x3812
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_10		0x3814
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_0_11		0x3816
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_0_12		0x3818
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_0_13		0x381a
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_0_14		0x381c
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_0_15		0x381e
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_1_0		0x3820
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_1_1		0x3822
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_1_2		0x3824
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_1_3		0x3826
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_1_4		0x3828
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_0		0x3840
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_1		0x3842
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_2		0x3844
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_3		0x3846
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_4		0x3848
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_5		0x384a
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_6		0x384c
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_7		0x384e
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_8		0x3850
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_9		0x3852
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_10		0x3854
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_11		0x3856
#define CORE_DIG_IOCTRL_R_AFE_CB_CTRL_2_12		0x3858
#define CORE_DIG_IOCTRL_R_AFE_CB_CTRL_2_13		0x385a
#define CORE_DIG_IOCTRL_R_AFE_CB_CTRL_2_14		0x385c
#define CORE_DIG_IOCTRL_R_AFE_CB_CTRL_2_15		0x385e
#define CORE_DIG_IOCTRL_R_AFE_CB_CTRL_3_0		0x3860
#define CORE_DIG_RW_COMMON_0				0x3880
#define CORE_DIG_RW_COMMON_1				0x3882
#define CORE_DIG_RW_COMMON_2				0x3884
#define CORE_DIG_RW_COMMON_3				0x3886
#define CORE_DIG_RW_COMMON_4				0x3888
#define CORE_DIG_RW_COMMON_5				0x388a
#define CORE_DIG_RW_COMMON_6				0x388c
#define CORE_DIG_RW_COMMON_7				0x388e
#define CORE_DIG_RW_COMMON_8				0x3890
#define CORE_DIG_RW_COMMON_9				0x3892
#define CORE_DIG_RW_COMMON_10				0x3894
#define CORE_DIG_RW_COMMON_11				0x3896
#define CORE_DIG_RW_COMMON_12				0x3898
#define CORE_DIG_RW_COMMON_13				0x389a
#define CORE_DIG_RW_COMMON_14				0x389c
#define CORE_DIG_RW_COMMON_15				0x389e
#define CORE_DIG_ANACTRL_RW_COMMON_ANACTRL_0		0x39e0
#define CORE_DIG_ANACTRL_RW_COMMON_ANACTRL_1		0x39e2
#define CORE_DIG_ANACTRL_RW_COMMON_ANACTRL_2		0x39e4
#define CORE_DIG_ANACTRL_RW_COMMON_ANACTRL_3		0x39e6
#define CORE_DIG_COMMON_RW_DESKEW_FINE_MEM		0x3fe0
#define CORE_DIG_COMMON_R_DESKEW_FINE_MEM		0x3fe2
#define PPI_RW_DPHY_LANE0_LBERT_0			0x4000
#define PPI_RW_DPHY_LANE0_LBERT_1			0x4002
#define PPI_R_DPHY_LANE0_LBERT_0			0x4004
#define PPI_R_DPHY_LANE0_LBERT_1			0x4006
#define PPI_RW_DPHY_LANE0_SPARE				0x4008
#define PPI_RW_DPHY_LANE1_LBERT_0			0x4400
#define PPI_RW_DPHY_LANE1_LBERT_1			0x4402
#define PPI_R_DPHY_LANE1_LBERT_0			0x4404
#define PPI_R_DPHY_LANE1_LBERT_1			0x4406
#define PPI_RW_DPHY_LANE1_SPARE				0x4408
#define PPI_RW_DPHY_LANE2_LBERT_0			0x4800
#define PPI_RW_DPHY_LANE2_LBERT_1			0x4802
#define PPI_R_DPHY_LANE2_LBERT_0			0x4804
#define PPI_R_DPHY_LANE2_LBERT_1			0x4806
#define PPI_RW_DPHY_LANE2_SPARE				0x4808
#define PPI_RW_DPHY_LANE3_LBERT_0			0x4c00
#define PPI_RW_DPHY_LANE3_LBERT_1			0x4c02
#define PPI_R_DPHY_LANE3_LBERT_0			0x4c04
#define PPI_R_DPHY_LANE3_LBERT_1			0x4c06
#define PPI_RW_DPHY_LANE3_SPARE				0x4c08
#define CORE_DIG_DLANE_0_RW_CFG_0			0x6000
#define CORE_DIG_DLANE_0_RW_CFG_1			0x6002
#define CORE_DIG_DLANE_0_RW_CFG_2			0x6004
#define CORE_DIG_DLANE_0_RW_LP_0			0x6080
#define CORE_DIG_DLANE_0_RW_LP_1			0x6082
#define CORE_DIG_DLANE_0_RW_LP_2			0x6084
#define CORE_DIG_DLANE_0_R_LP_0				0x60a0
#define CORE_DIG_DLANE_0_R_LP_1				0x60a2
#define CORE_DIG_DLANE_0_R_HS_TX_0			0x60e0
#define CORE_DIG_DLANE_0_RW_HS_RX_0			0x6100
#define CORE_DIG_DLANE_0_RW_HS_RX_1			0x6102
#define CORE_DIG_DLANE_0_RW_HS_RX_2			0x6104
#define CORE_DIG_DLANE_0_RW_HS_RX_3			0x6106
#define CORE_DIG_DLANE_0_RW_HS_RX_4			0x6108
#define CORE_DIG_DLANE_0_RW_HS_RX_5			0x610a
#define CORE_DIG_DLANE_0_RW_HS_RX_6			0x610c
#define CORE_DIG_DLANE_0_RW_HS_RX_7			0x610e
#define CORE_DIG_DLANE_0_RW_HS_RX_8			0x6110
#define CORE_DIG_DLANE_0_RW_HS_RX_9			0x6112
#define CORE_DIG_DLANE_0_R_HS_RX_0			0x6120
#define CORE_DIG_DLANE_0_R_HS_RX_1			0x6122
#define CORE_DIG_DLANE_0_R_HS_RX_2			0x6124
#define CORE_DIG_DLANE_0_R_HS_RX_3			0x6126
#define CORE_DIG_DLANE_0_R_HS_RX_4			0x6128
#define CORE_DIG_DLANE_0_RW_HS_TX_0			0x6200
#define CORE_DIG_DLANE_0_RW_HS_TX_1			0x6202
#define CORE_DIG_DLANE_0_RW_HS_TX_2			0x6204
#define CORE_DIG_DLANE_0_RW_HS_TX_3			0x6206
#define CORE_DIG_DLANE_0_RW_HS_TX_4			0x6208
#define CORE_DIG_DLANE_0_RW_HS_TX_5			0x620a
#define CORE_DIG_DLANE_0_RW_HS_TX_6			0x620c
#define CORE_DIG_DLANE_0_RW_HS_TX_7			0x620e
#define CORE_DIG_DLANE_0_RW_HS_TX_8			0x6210
#define CORE_DIG_DLANE_0_RW_HS_TX_9			0x6212
#define CORE_DIG_DLANE_0_RW_HS_TX_10			0x6214
#define CORE_DIG_DLANE_0_RW_HS_TX_11			0x6216
#define CORE_DIG_DLANE_0_RW_HS_TX_12			0x6218
#define CORE_DIG_DLANE_1_RW_CFG_0			0x6400
#define CORE_DIG_DLANE_1_RW_CFG_1			0x6402
#define CORE_DIG_DLANE_1_RW_CFG_2			0x6404
#define CORE_DIG_DLANE_1_RW_LP_0			0x6480
#define CORE_DIG_DLANE_1_RW_LP_1			0x6482
#define CORE_DIG_DLANE_1_RW_LP_2			0x6484
#define CORE_DIG_DLANE_1_R_LP_0				0x64a0
#define CORE_DIG_DLANE_1_R_LP_1				0x64a2
#define CORE_DIG_DLANE_1_R_HS_TX_0			0x64e0
#define CORE_DIG_DLANE_1_RW_HS_RX_0			0x6500
#define CORE_DIG_DLANE_1_RW_HS_RX_1			0x6502
#define CORE_DIG_DLANE_1_RW_HS_RX_2			0x6504
#define CORE_DIG_DLANE_1_RW_HS_RX_3			0x6506
#define CORE_DIG_DLANE_1_RW_HS_RX_4			0x6508
#define CORE_DIG_DLANE_1_RW_HS_RX_5			0x650a
#define CORE_DIG_DLANE_1_RW_HS_RX_6			0x650c
#define CORE_DIG_DLANE_1_RW_HS_RX_7			0x650e
#define CORE_DIG_DLANE_1_RW_HS_RX_8			0x6510
#define CORE_DIG_DLANE_1_RW_HS_RX_9			0x6512
#define CORE_DIG_DLANE_1_R_HS_RX_0			0x6520
#define CORE_DIG_DLANE_1_R_HS_RX_1			0x6522
#define CORE_DIG_DLANE_1_R_HS_RX_2			0x6524
#define CORE_DIG_DLANE_1_R_HS_RX_3			0x6526
#define CORE_DIG_DLANE_1_R_HS_RX_4			0x6528
#define CORE_DIG_DLANE_1_RW_HS_TX_0			0x6600
#define CORE_DIG_DLANE_1_RW_HS_TX_1			0x6602
#define CORE_DIG_DLANE_1_RW_HS_TX_2			0x6604
#define CORE_DIG_DLANE_1_RW_HS_TX_3			0x6606
#define CORE_DIG_DLANE_1_RW_HS_TX_4			0x6608
#define CORE_DIG_DLANE_1_RW_HS_TX_5			0x660a
#define CORE_DIG_DLANE_1_RW_HS_TX_6			0x660c
#define CORE_DIG_DLANE_1_RW_HS_TX_7			0x660e
#define CORE_DIG_DLANE_1_RW_HS_TX_8			0x6610
#define CORE_DIG_DLANE_1_RW_HS_TX_9			0x6612
#define CORE_DIG_DLANE_1_RW_HS_TX_10			0x6614
#define CORE_DIG_DLANE_1_RW_HS_TX_11			0x6616
#define CORE_DIG_DLANE_1_RW_HS_TX_12			0x6618
#define CORE_DIG_DLANE_2_RW_CFG_0			0x6800
#define CORE_DIG_DLANE_2_RW_CFG_1			0x6802
#define CORE_DIG_DLANE_2_RW_CFG_2			0x6804
#define CORE_DIG_DLANE_2_RW_LP_0			0x6880
#define CORE_DIG_DLANE_2_RW_LP_1			0x6882
#define CORE_DIG_DLANE_2_RW_LP_2			0x6884
#define CORE_DIG_DLANE_2_R_LP_0				0x68a0
#define CORE_DIG_DLANE_2_R_LP_1				0x68a2
#define CORE_DIG_DLANE_2_R_HS_TX_0			0x68e0
#define CORE_DIG_DLANE_2_RW_HS_RX_0			0x6900
#define CORE_DIG_DLANE_2_RW_HS_RX_1			0x6902
#define CORE_DIG_DLANE_2_RW_HS_RX_2			0x6904
#define CORE_DIG_DLANE_2_RW_HS_RX_3			0x6906
#define CORE_DIG_DLANE_2_RW_HS_RX_4			0x6908
#define CORE_DIG_DLANE_2_RW_HS_RX_5			0x690a
#define CORE_DIG_DLANE_2_RW_HS_RX_6			0x690c
#define CORE_DIG_DLANE_2_RW_HS_RX_7			0x690e
#define CORE_DIG_DLANE_2_RW_HS_RX_8			0x6910
#define CORE_DIG_DLANE_2_RW_HS_RX_9			0x6912
#define CORE_DIG_DLANE_2_R_HS_RX_0			0x6920
#define CORE_DIG_DLANE_2_R_HS_RX_1			0x6922
#define CORE_DIG_DLANE_2_R_HS_RX_2			0x6924
#define CORE_DIG_DLANE_2_R_HS_RX_3			0x6926
#define CORE_DIG_DLANE_2_R_HS_RX_4			0x6928
#define CORE_DIG_DLANE_2_RW_HS_TX_0			0x6a00
#define CORE_DIG_DLANE_2_RW_HS_TX_1			0x6a02
#define CORE_DIG_DLANE_2_RW_HS_TX_2			0x6a04
#define CORE_DIG_DLANE_2_RW_HS_TX_3			0x6a06
#define CORE_DIG_DLANE_2_RW_HS_TX_4			0x6a08
#define CORE_DIG_DLANE_2_RW_HS_TX_5			0x6a0a
#define CORE_DIG_DLANE_2_RW_HS_TX_6			0x6a0c
#define CORE_DIG_DLANE_2_RW_HS_TX_7			0x6a0e
#define CORE_DIG_DLANE_2_RW_HS_TX_8			0x6a10
#define CORE_DIG_DLANE_2_RW_HS_TX_9			0x6a12
#define CORE_DIG_DLANE_2_RW_HS_TX_10			0x6a14
#define CORE_DIG_DLANE_2_RW_HS_TX_11			0x6a16
#define CORE_DIG_DLANE_2_RW_HS_TX_12			0x6a18
#define CORE_DIG_DLANE_3_RW_CFG_0			0x6c00
#define CORE_DIG_DLANE_3_RW_CFG_1			0x6c02
#define CORE_DIG_DLANE_3_RW_CFG_2			0x6c04
#define CORE_DIG_DLANE_3_RW_LP_0			0x6c80
#define CORE_DIG_DLANE_3_RW_LP_1			0x6c82
#define CORE_DIG_DLANE_3_RW_LP_2			0x6c84
#define CORE_DIG_DLANE_3_R_LP_0				0x6ca0
#define CORE_DIG_DLANE_3_R_LP_1				0x6ca2
#define CORE_DIG_DLANE_3_R_HS_TX_0			0x6ce0
#define CORE_DIG_DLANE_3_RW_HS_RX_0			0x6d00
#define CORE_DIG_DLANE_3_RW_HS_RX_1			0x6d02
#define CORE_DIG_DLANE_3_RW_HS_RX_2			0x6d04
#define CORE_DIG_DLANE_3_RW_HS_RX_3			0x6d06
#define CORE_DIG_DLANE_3_RW_HS_RX_4			0x6d08
#define CORE_DIG_DLANE_3_RW_HS_RX_5			0x6d0a
#define CORE_DIG_DLANE_3_RW_HS_RX_6			0x6d0c
#define CORE_DIG_DLANE_3_RW_HS_RX_7			0x6d0e
#define CORE_DIG_DLANE_3_RW_HS_RX_8			0x6d10
#define CORE_DIG_DLANE_3_RW_HS_RX_9			0x6d12
#define CORE_DIG_DLANE_3_R_HS_RX_0			0x6d20
#define CORE_DIG_DLANE_3_R_HS_RX_1			0x6d22
#define CORE_DIG_DLANE_3_R_HS_RX_2			0x6d24
#define CORE_DIG_DLANE_3_R_HS_RX_3			0x6d26
#define CORE_DIG_DLANE_3_R_HS_RX_4			0x6d28
#define CORE_DIG_DLANE_3_RW_HS_TX_0			0x6e00
#define CORE_DIG_DLANE_3_RW_HS_TX_1			0x6e02
#define CORE_DIG_DLANE_3_RW_HS_TX_2			0x6e04
#define CORE_DIG_DLANE_3_RW_HS_TX_3			0x6e06
#define CORE_DIG_DLANE_3_RW_HS_TX_4			0x6e08
#define CORE_DIG_DLANE_3_RW_HS_TX_5			0x6e0a
#define CORE_DIG_DLANE_3_RW_HS_TX_6			0x6e0c
#define CORE_DIG_DLANE_3_RW_HS_TX_7			0x6e0e
#define CORE_DIG_DLANE_3_RW_HS_TX_8			0x6e10
#define CORE_DIG_DLANE_3_RW_HS_TX_9			0x6e12
#define CORE_DIG_DLANE_3_RW_HS_TX_10			0x6e14
#define CORE_DIG_DLANE_3_RW_HS_TX_11			0x6e16
#define CORE_DIG_DLANE_3_RW_HS_TX_12			0x6e18
#define CORE_DIG_DLANE_CLK_RW_CFG_0			0x7000
#define CORE_DIG_DLANE_CLK_RW_CFG_1			0x7002
#define CORE_DIG_DLANE_CLK_RW_CFG_2			0x7004
#define CORE_DIG_DLANE_CLK_RW_LP_0			0x7080
#define CORE_DIG_DLANE_CLK_RW_LP_1			0x7082
#define CORE_DIG_DLANE_CLK_RW_LP_2			0x7084
#define CORE_DIG_DLANE_CLK_R_LP_0			0x70a0
#define CORE_DIG_DLANE_CLK_R_LP_1			0x70a2
#define CORE_DIG_DLANE_CLK_R_HS_TX_0			0x70e0
#define CORE_DIG_DLANE_CLK_RW_HS_RX_0			0x7100
#define CORE_DIG_DLANE_CLK_RW_HS_RX_1			0x7102
#define CORE_DIG_DLANE_CLK_RW_HS_RX_2			0x7104
#define CORE_DIG_DLANE_CLK_RW_HS_RX_3			0x7106
#define CORE_DIG_DLANE_CLK_RW_HS_RX_4			0x7108
#define CORE_DIG_DLANE_CLK_RW_HS_RX_5			0x710a
#define CORE_DIG_DLANE_CLK_RW_HS_RX_6			0x710c
#define CORE_DIG_DLANE_CLK_RW_HS_RX_7			0x710e
#define CORE_DIG_DLANE_CLK_RW_HS_RX_8			0x7110
#define CORE_DIG_DLANE_CLK_RW_HS_RX_9			0x7112
#define CORE_DIG_DLANE_CLK_R_HS_RX_0			0x7120
#define CORE_DIG_DLANE_CLK_R_HS_RX_1			0x7122
#define CORE_DIG_DLANE_CLK_R_HS_RX_2			0x7124
#define CORE_DIG_DLANE_CLK_R_HS_RX_3			0x7126
#define CORE_DIG_DLANE_CLK_R_HS_RX_4			0x7128
#define CORE_DIG_DLANE_CLK_RW_HS_TX_0			0x7200
#define CORE_DIG_DLANE_CLK_RW_HS_TX_1			0x7202
#define CORE_DIG_DLANE_CLK_RW_HS_TX_2			0x7204
#define CORE_DIG_DLANE_CLK_RW_HS_TX_3			0x7206
#define CORE_DIG_DLANE_CLK_RW_HS_TX_4			0x7208
#define CORE_DIG_DLANE_CLK_RW_HS_TX_5			0x720a
#define CORE_DIG_DLANE_CLK_RW_HS_TX_6			0x720c
#define CORE_DIG_DLANE_CLK_RW_HS_TX_7			0x720e
#define CORE_DIG_DLANE_CLK_RW_HS_TX_8			0x7210
#define CORE_DIG_DLANE_CLK_RW_HS_TX_9			0x7212
#define CORE_DIG_DLANE_CLK_RW_HS_TX_10			0x7214
#define CORE_DIG_DLANE_CLK_RW_HS_TX_11			0x7216
#define CORE_DIG_DLANE_CLK_RW_HS_TX_12			0x7218
#define PPI_RW_CPHY_TRIO0_LBERT_0			0x8000
#define PPI_RW_CPHY_TRIO0_LBERT_1			0x8002
#define PPI_R_CPHY_TRIO0_LBERT_0			0x8004
#define PPI_R_CPHY_TRIO0_LBERT_1			0x8006
#define PPI_RW_CPHY_TRIO0_SPARE				0x8008
#define PPI_RW_CPHY_TRIO1_LBERT_0			0x8400
#define PPI_RW_CPHY_TRIO1_LBERT_1			0x8402
#define PPI_R_CPHY_TRIO1_LBERT_0			0x8404
#define PPI_R_CPHY_TRIO1_LBERT_1			0x8406
#define PPI_RW_CPHY_TRIO1_SPARE				0x8408
#define PPI_RW_CPHY_TRIO2_LBERT_0			0x8800
#define PPI_RW_CPHY_TRIO2_LBERT_1			0x8802
#define PPI_R_CPHY_TRIO2_LBERT_0			0x8804
#define PPI_R_CPHY_TRIO2_LBERT_1			0x8806
#define PPI_RW_CPHY_TRIO2_SPARE				0x8808
#define CORE_DIG_CLANE_0_RW_CFG_0			0xa000
#define CORE_DIG_CLANE_0_RW_CFG_2			0xa004
#define CORE_DIG_CLANE_0_RW_LP_0			0xa080
#define CORE_DIG_CLANE_0_RW_LP_1			0xa082
#define CORE_DIG_CLANE_0_RW_LP_2			0xa084
#define CORE_DIG_CLANE_0_R_LP_0				0xa0a0
#define CORE_DIG_CLANE_0_R_LP_1				0xa0a2
#define CORE_DIG_CLANE_0_RW_HS_RX_0			0xa100
#define CORE_DIG_CLANE_0_RW_HS_RX_1			0xa102
#define CORE_DIG_CLANE_0_RW_HS_RX_2			0xa104
#define CORE_DIG_CLANE_0_RW_HS_RX_3			0xa106
#define CORE_DIG_CLANE_0_RW_HS_RX_4			0xa108
#define CORE_DIG_CLANE_0_RW_HS_RX_5			0xa10a
#define CORE_DIG_CLANE_0_RW_HS_RX_6			0xa10c
#define CORE_DIG_CLANE_0_R_RX_0				0xa120
#define CORE_DIG_CLANE_0_R_RX_1				0xa122
#define CORE_DIG_CLANE_0_R_TX_0				0xa124
#define CORE_DIG_CLANE_0_R_RX_2				0xa126
#define CORE_DIG_CLANE_0_R_RX_3				0xa128
#define CORE_DIG_CLANE_0_RW_HS_TX_0			0xa200
#define CORE_DIG_CLANE_0_RW_HS_TX_1			0xa202
#define CORE_DIG_CLANE_0_RW_HS_TX_2			0xa204
#define CORE_DIG_CLANE_0_RW_HS_TX_3			0xa206
#define CORE_DIG_CLANE_0_RW_HS_TX_4			0xa208
#define CORE_DIG_CLANE_0_RW_HS_TX_5			0xa20a
#define CORE_DIG_CLANE_0_RW_HS_TX_6			0xa20c
#define CORE_DIG_CLANE_0_RW_HS_TX_7			0xa20e
#define CORE_DIG_CLANE_0_RW_HS_TX_8			0xa210
#define CORE_DIG_CLANE_0_RW_HS_TX_9			0xa212
#define CORE_DIG_CLANE_0_RW_HS_TX_10			0xa214
#define CORE_DIG_CLANE_0_RW_HS_TX_11			0xa216
#define CORE_DIG_CLANE_0_RW_HS_TX_12			0xa218
#define CORE_DIG_CLANE_0_RW_HS_TX_13			0xa21a
#define CORE_DIG_CLANE_1_RW_CFG_0			0xa400
#define CORE_DIG_CLANE_1_RW_CFG_2			0xa404
#define CORE_DIG_CLANE_1_RW_LP_0			0xa480
#define CORE_DIG_CLANE_1_RW_LP_1			0xa482
#define CORE_DIG_CLANE_1_RW_LP_2			0xa484
#define CORE_DIG_CLANE_1_R_LP_0				0xa4a0
#define CORE_DIG_CLANE_1_R_LP_1				0xa4a2
#define CORE_DIG_CLANE_1_RW_HS_RX_0			0xa500
#define CORE_DIG_CLANE_1_RW_HS_RX_1			0xa502
#define CORE_DIG_CLANE_1_RW_HS_RX_2			0xa504
#define CORE_DIG_CLANE_1_RW_HS_RX_3			0xa506
#define CORE_DIG_CLANE_1_RW_HS_RX_4			0xa508
#define CORE_DIG_CLANE_1_RW_HS_RX_5			0xa50a
#define CORE_DIG_CLANE_1_RW_HS_RX_6			0xa50c
#define CORE_DIG_CLANE_1_R_RX_0				0xa520
#define CORE_DIG_CLANE_1_R_RX_1				0xa522
#define CORE_DIG_CLANE_1_R_TX_0				0xa524
#define CORE_DIG_CLANE_1_R_RX_2				0xa526
#define CORE_DIG_CLANE_1_R_RX_3				0xa528
#define CORE_DIG_CLANE_1_RW_HS_TX_0			0xa600
#define CORE_DIG_CLANE_1_RW_HS_TX_1			0xa602
#define CORE_DIG_CLANE_1_RW_HS_TX_2			0xa604
#define CORE_DIG_CLANE_1_RW_HS_TX_3			0xa606
#define CORE_DIG_CLANE_1_RW_HS_TX_4			0xa608
#define CORE_DIG_CLANE_1_RW_HS_TX_5			0xa60a
#define CORE_DIG_CLANE_1_RW_HS_TX_6			0xa60c
#define CORE_DIG_CLANE_1_RW_HS_TX_7			0xa60e
#define CORE_DIG_CLANE_1_RW_HS_TX_8			0xa610
#define CORE_DIG_CLANE_1_RW_HS_TX_9			0xa612
#define CORE_DIG_CLANE_1_RW_HS_TX_10			0xa614
#define CORE_DIG_CLANE_1_RW_HS_TX_11			0xa616
#define CORE_DIG_CLANE_1_RW_HS_TX_12			0xa618
#define CORE_DIG_CLANE_1_RW_HS_TX_13			0xa61a
#define CORE_DIG_CLANE_2_RW_CFG_0			0xa800
#define CORE_DIG_CLANE_2_RW_CFG_2			0xa804
#define CORE_DIG_CLANE_2_RW_LP_0			0xa880
#define CORE_DIG_CLANE_2_RW_LP_1			0xa882
#define CORE_DIG_CLANE_2_RW_LP_2			0xa884
#define CORE_DIG_CLANE_2_R_LP_0				0xa8a0
#define CORE_DIG_CLANE_2_R_LP_1				0xa8a2
#define CORE_DIG_CLANE_2_RW_HS_RX_0			0xa900
#define CORE_DIG_CLANE_2_RW_HS_RX_1			0xa902
#define CORE_DIG_CLANE_2_RW_HS_RX_2			0xa904
#define CORE_DIG_CLANE_2_RW_HS_RX_3			0xa906
#define CORE_DIG_CLANE_2_RW_HS_RX_4			0xa908
#define CORE_DIG_CLANE_2_RW_HS_RX_5			0xa90a
#define CORE_DIG_CLANE_2_RW_HS_RX_6			0xa90c
#define CORE_DIG_CLANE_2_R_RX_0				0xa920
#define CORE_DIG_CLANE_2_R_RX_1				0xa922
#define CORE_DIG_CLANE_2_R_TX_0				0xa924
#define CORE_DIG_CLANE_2_R_RX_2				0xa926
#define CORE_DIG_CLANE_2_R_RX_3				0xa928
#define CORE_DIG_CLANE_2_RW_HS_TX_0			0xaa00
#define CORE_DIG_CLANE_2_RW_HS_TX_1			0xaa02
#define CORE_DIG_CLANE_2_RW_HS_TX_2			0xaa04
#define CORE_DIG_CLANE_2_RW_HS_TX_3			0xaa06
#define CORE_DIG_CLANE_2_RW_HS_TX_4			0xaa08
#define CORE_DIG_CLANE_2_RW_HS_TX_5			0xaa0a
#define CORE_DIG_CLANE_2_RW_HS_TX_6			0xaa0c
#define CORE_DIG_CLANE_2_RW_HS_TX_7			0xaa0e
#define CORE_DIG_CLANE_2_RW_HS_TX_8			0xaa10
#define CORE_DIG_CLANE_2_RW_HS_TX_9			0xaa12
#define CORE_DIG_CLANE_2_RW_HS_TX_10			0xaa14
#define CORE_DIG_CLANE_2_RW_HS_TX_11			0xaa16
#define CORE_DIG_CLANE_2_RW_HS_TX_12			0xaa18
#define CORE_DIG_CLANE_2_RW_HS_TX_13			0xaa1a

/* dwc csi host controller registers */
#define IS_IO_CSI2_HOST_BASE(i)			(IS_IO_BASE + 0x40000 + \
						 0x2000 * (i))
#define VERSION					0x0
#define N_LANES					0x4
#define CSI2_RESETN				0x8
#define INT_ST_MAIN				0xc
#define DATA_IDS_1				0x10
#define DATA_IDS_2				0x14
#define CDPHY_MODE				0x1c
#define DATA_IDS_VC_1				0x30
#define DATA_IDS_VC_2				0x34
#define PHY_SHUTDOWNZ				0x40
#define DPHY_RSTZ				0x44
#define PHY_RX					0x48
#define PHY_STOPSTATE				0x4c
#define PHY_TEST_CTRL0				0x50
#define PHY_TEST_CTRL1				0x54
#define PPI_PG_PATTERN_VRES			0x60
#define PPI_PG_PATTERN_HRES			0x64
#define PPI_PG_CONFIG				0x68
#define PPI_PG_ENABLE				0x6c
#define PPI_PG_STATUS				0x70
#define VC_EXTENSION				0xc8
#define PHY_CAL					0xcc
#define INT_ST_PHY_FATAL			0xe0
#define INT_MSK_PHY_FATAL			0xe4
#define INT_FORCE_PHY_FATAL			0xe8
#define INT_ST_PKT_FATAL			0xf0
#define INT_MSK_PKT_FATAL			0xf4
#define INT_FORCE_PKT_FATAL			0xf8
#define INT_ST_PHY				0x110
#define INT_MSK_PHY				0x114
#define INT_FORCE_PHY				0x118
#define INT_ST_LINE				0x130
#define INT_MSK_LINE				0x134
#define INT_FORCE_LINE				0x138
#define INT_ST_BNDRY_FRAME_FATAL		0x280
#define INT_MSK_BNDRY_FRAME_FATAL		0x284
#define INT_FORCE_BNDRY_FRAME_FATAL		0x288
#define INT_ST_SEQ_FRAME_FATAL			0x290
#define INT_MSK_SEQ_FRAME_FATAL			0x294
#define INT_FORCE_SEQ_FRAME_FATAL		0x298
#define INT_ST_CRC_FRAME_FATAL			0x2a0
#define INT_MSK_CRC_FRAME_FATAL			0x2a4
#define INT_FORCE_CRC_FRAME_FATAL		0x2a8
#define INT_ST_PLD_CRC_FATAL			0x2b0
#define INT_MSK_PLD_CRC_FATAL			0x2b4
#define INT_FORCE_PLD_CRC_FATAL			0x2b8
#define INT_ST_DATA_ID				0x2c0
#define INT_MSK_DATA_ID				0x2c4
#define INT_FORCE_DATA_ID			0x2c8
#define INT_ST_ECC_CORRECTED			0x2d0
#define INT_MSK_ECC_CORRECTED			0x2d4
#define INT_FORCE_ECC_CORRECTED			0x2d8
#define SCRAMBLING				0x300
#define SCRAMBLING_SEED1			0x304
#define SCRAMBLING_SEED2			0x308
#define SCRAMBLING_SEED3			0x30c
#define SCRAMBLING_SEED4			0x310
#define SCRAMBLING				0x300

#define IS_IO_CSI2_ADPL_PORT_BASE(i)		(IS_IO_BASE + 0x40800 + \
						 0x2000 * (i))
#define CSI2_ADPL_INPUT_MODE			0x0
#define CSI2_ADPL_CSI_RX_ERR_IRQ_CLEAR_EN	0x4
#define CSI2_ADPL_CSI_RX_ERR_IRQ_CLEAR_ADDR	0x8
#define CSI2_ADPL_CSI_RX_ERR_IRQ_STATUS		0xc
#define CSI2_ADPL_IRQ_CTL_COMMON_STATUS		0xa4
#define CSI2_ADPL_IRQ_CTL_COMMON_CLEAR		0xa8
#define CSI2_ADPL_IRQ_CTL_COMMON_ENABLE		0xac
#define CSI2_ADPL_IRQ_CTL_FS_STATUS		0xbc
#define CSI2_ADPL_IRQ_CTL_FS_CLEAR		0xc0
#define CSI2_ADPL_IRQ_CTL_FS_ENABLE		0xc4
#define CSI2_ADPL_IRQ_CTL_FE_STATUS		0xc8
#define CSI2_ADPL_IRQ_CTL_FE_CLEAR		0xcc
#define CSI2_ADPL_IRQ_CTL_FE_ENABLE		0xd0

/* software control the legacy csi irq */
#define IS_IO_CSI2_ERR_LEGACY_IRQ_CTL_BASE(i)	(IS_IO_BASE + 0x40c00 + \
						 0x2000 * (i))
#define IS_IO_CSI2_SYNC_LEGACY_IRQ_CTL_BASE(i)	(IS_IO_BASE + 0x40d00 + \
						 0x2000 * (i))
#define IS_IO_CSI2_LEGACY_IRQ_CTRL_BASE		(IS_IO_BASE + 0x49000)
#define IS_IO_CSI2_IRQ_CTRL_BASE		(IS_IO_BASE + 0x4e100)

#define IRQ_CTL_EDGE				0x0
#define IRQ_CTL_MASK				0x4
#define IRQ_CTL_STATUS				0x8
#define IRQ_CTL_CLEAR				0xc
#define IRQ_CTL_ENABLE				0x10
/* FE irq for PTL */
#define IRQ1_CTL_MASK				0x14
#define IRQ1_CTL_STATUS				0x18
#define IRQ1_CTL_CLEAR				0x1c
#define IRQ1_CTL_ENABLE				0x20

/* software to set the clock gate to use the port or mgc */
#define IS_IO_GPREGS_BASE			(IS_IO_BASE + 0x49200)
#define SRST_PORT_ARB				0x0
#define SRST_MGC				0x4
#define SRST_WIDTH_CONV				0x8
#define SRST_CSI_IRQ				0xc
#define SRST_CSI_LEGACY_IRQ			0x10
#define CLK_EN_TXCLKESC				0x14
#define CLK_DIV_FACTOR_IS_CLK			0x18
#define CLK_DIV_FACTOR_APB_CLK			0x1c
#define CSI_PORT_CLK_GATE			0x20
#define CSI_PORTAB_AGGREGATION			0x24
#define MGC_CLK_GATE				0x2c
#define CG_CTRL_BITS				0x3c
#define SPARE_RW				0xf8
#define SPARE_RO				0xfc

#define IS_IO_CSI2_MPF_PORT_BASE(i)		(IS_IO_BASE + 0x53000 + \
						 0x1000 * (i))
#define MPF_16_IRQ_CNTRL_STATUS			0x238
#define MPF_16_IRQ_CNTRL_CLEAR			0x23c
#define MPF_16_IRQ_CNTRL_ENABLE			0x240

/* software config the phy */
#define IS_IO_CSI2_GPREGS_BASE(i)		(IS_IO_BASE + 0x53400 + \
						 0x1000 * (i))
#define CSI_ADAPT_LAYER_SRST		0x0
#define MPF_SRST_RST			0x4
#define CSI_ERR_IRQ_CTRL_SRST		0x8
#define CSI_SYNC_RC_SRST		0xc
#define CSI_CG_CTRL_BITS		0x10
#define SOC_CSI2HOST_SELECT		0x14
#define PHY_RESET			0x18
#define PHY_SHUTDOWN			0x1c
#define PHY_MODE			0x20
#define PHY_READY			0x24
#define PHY_CLK_LANE_FORCE_CONTROL	0x28
#define PHY_CLK_LANE_CONTROL		0x2c
#define PHY_CLK_LANE_STATUS		0x30
#define PHY_LANE_RX_ESC_REQ		0x34
#define PHY_LANE_RX_ESC_DATA		0x38
#define PHY_LANE_TURNDISABLE		0x3c
#define PHY_LANE_DIRECTION		0x40
#define PHY_LANE_FORCE_CONTROL		0x44
#define PHY_LANE_CONTROL_EN		0x48
#define PHY_LANE_CONTROL_DATAWIDTH	0x4c
#define PHY_LANE_STATUS			0x50
#define PHY_LANE_ERR			0x54
#define PHY_LANE_RXALP			0x58
#define PHY_LANE_RXALP_NIBBLE		0x5c
#define PHY_PARITY_ERROR		0x60
#define PHY_DEBUG_REGS_CLK_GATE_EN	0x64
#define SPARE_RW			0xf8
#define SPARE_RO			0xfc

/* software not touch */
#define PORT_ARB_BASE				(IS_IO_BASE + 0x4e000)
#define PORT_ARB_IRQ_CTL_STATUS			0x4
#define PORT_ARB_IRQ_CTL_CLEAR			0x8
#define PORT_ARB_IRQ_CTL_ENABLE			0xc

#define MGC_PPC					4
#define MGC_DTYPE_RAW(i)			(((i) - 8) / 2)
#define IS_IO_MGC_BASE				(IS_IO_BASE + 0x48000)
#define MGC_KICK				0x0
#define MGC_ASYNC_STOP				0x4
#define MGC_PORT_OFFSET				0x100
#define MGC_CSI_PORT_MAP(i)			(0x8 + (i) * 0x4)
#define MGC_MG_PORT(i)				(IS_IO_MGC_BASE +	\
						 (i) * MGC_PORT_OFFSET)
/* per mgc instance */
#define MGC_MG_CSI_ADAPT_LAYER_TYPE		0x28
#define MGC_MG_MODE				0x2c
#define MGC_MG_INIT_COUNTER			0x30
#define MGC_MG_MIPI_VC				0x34
#define MGC_MG_MIPI_DTYPES			0x38
#define MGC_MG_MULTI_DTYPES_MODE		0x3c
#define MGC_MG_NOF_FRAMES			0x40
#define MGC_MG_FRAME_DIM			0x44
#define MGC_MG_HBLANK				0x48
#define MGC_MG_VBLANK				0x4c
#define MGC_MG_TPG_MODE				0x50
#define MGC_MG_TPG_R0				0x54
#define MGC_MG_TPG_G0				0x58
#define MGC_MG_TPG_B0				0x5c
#define MGC_MG_TPG_R1				0x60
#define MGC_MG_TPG_G1				0x64
#define MGC_MG_TPG_B1				0x68
#define MGC_MG_TPG_FACTORS			0x6c
#define MGC_MG_TPG_MASKS			0x70
#define MGC_MG_TPG_XY_MASK			0x74
#define MGC_MG_TPG_TILE_DIM			0x78
#define MGC_MG_PRBS_LFSR_INIT_0			0x7c
#define MGC_MG_PRBS_LFSR_INIT_1			0x80
#define MGC_MG_SYNC_STOP_POINT			0x84
#define MGC_MG_SYNC_STOP_POINT_LOC		0x88
#define MGC_MG_ERR_INJECT			0x8c
#define MGC_MG_ERR_LOCATION			0x90
#define MGC_MG_DTO_SPEED_CTRL_EN		0x94
#define MGC_MG_DTO_SPEED_CTRL_INCR_VAL		0x98
#define MGC_MG_HOR_LOC_STTS			0x9c
#define MGC_MG_VER_LOC_STTS			0xa0
#define MGC_MG_FRAME_NUM_STTS			0xa4
#define MGC_MG_BUSY_STTS			0xa8
#define MGC_MG_STOPPED_STTS			0xac
/* tile width and height in pixels for Chess board and Color palette */
#define MGC_TPG_TILE_WIDTH			64
#define MGC_TPG_TILE_HEIGHT			64

#define IPU_CSI_PORT_A_ADDR_OFFSET		0x0
#define IPU_CSI_PORT_B_ADDR_OFFSET		0x0
#define IPU_CSI_PORT_C_ADDR_OFFSET		0x0
#define IPU_CSI_PORT_D_ADDR_OFFSET		0x0

/*
 * 0 - CSI RX Port 0 interrupt;
 * 1 - MPF Port 0 interrupt;
 * 2 - CSI RX Port 1 interrupt;
 * 3 - MPF Port 1 interrupt;
 * 4 - CSI RX Port 2 interrupt;
 * 5 - MPF Port 2 interrupt;
 * 6 - CSI RX Port 3 interrupt;
 * 7 - MPF Port 3 interrupt;
 * 8 - Port ARB FIFO 0 overflow;
 * 9 - Port ARB FIFO 1 overflow;
 * 10 - Port ARB FIFO 2 overflow;
 * 11 - Port ARB FIFO 3 overflow;
 * 12 - isys_cfgnoc_err_probe_intl;
 * 13-15 - reserved
 */
#define IPU7_CSI_IS_IO_IRQ_MASK		0xffff

/* Adapter layer irq */
#define IPU7_CSI_ADPL_IRQ_MASK		0xffff

/* sw irq from legacy irq control
 * legacy irq status
 * IPU7
 * 0 - CSI Port 0 error interrupt
 * 1 - CSI Port 0 sync interrupt
 * 2 - CSI Port 1 error interrupt
 * 3 - CSI Port 1 sync interrupt
 * 4 - CSI Port 2 error interrupt
 * 5 - CSI Port 2 sync interrupt
 * 6 - CSI Port 3 error interrupt
 * 7 - CSI Port 3 sync interrupt
 * IPU7P5
 * 0 - CSI Port 0 error interrupt
 * 1 - CSI Port 0 fs interrupt
 * 2 - CSI Port 0 fe interrupt
 * 3 - CSI Port 1 error interrupt
 * 4 - CSI Port 1 fs interrupt
 * 5 - CSI Port 1 fe interrupt
 * 6 - CSI Port 2 error interrupt
 * 7 - CSI Port 2 fs interrupt
 * 8 - CSI Port 2 fe interrupt
 */
#define IPU7_CSI_RX_LEGACY_IRQ_MASK		0x1ff

/* legacy error status per port
 * 0 - Error handler FIFO full;
 * 1 - Reserved Short Packet encoding detected;
 * 2 - Reserved Long Packet encoding detected;
 * 3 - Received packet is too short (fewer data words than specified in header);
 * 4 - Received packet is too long (more data words than specified in header);
 * 5 - Short packet discarded due to errors;
 * 6 - Long packet discarded due to errors;
 * 7 - CSI Combo Rx interrupt;
 * 8 - IDI CDC FIFO overflow; remaining bits are reserved and tied to 0;
 */
#define IPU7_CSI_RX_ERROR_IRQ_MASK		0xfff

/*
 * 0 - VC0 frame start received
 * 1 - VC0 frame end received
 * 2 - VC1 frame start received
 * 3 - VC1 frame end received
 * 4 - VC2 frame start received
 * 5 - VC2 frame end received
 * 6 - VC3 frame start received
 * 7 - VC3 frame end received
 * 8 - VC4 frame start received
 * 9 - VC4 frame end received
 * 10 - VC5 frame start received
 * 11 - VC5 frame end received
 * 12 - VC6 frame start received
 * 13 - VC6 frame end received
 * 14 - VC7 frame start received
 * 15 - VC7 frame end received
 * 16 - VC8 frame start received
 * 17 - VC8 frame end received
 * 18 - VC9 frame start received
 * 19 - VC9 frame end received
 * 20 - VC10 frame start received
 * 21 - VC10 frame end received
 * 22 - VC11 frame start received
 * 23 - VC11 frame end received
 * 24 - VC12 frame start received
 * 25 - VC12 frame end received
 * 26 - VC13 frame start received
 * 27 - VC13 frame end received
 * 28 - VC14 frame start received
 * 29 - VC14 frame end received
 * 30 - VC15 frame start received
 * 31 - VC15 frame end received
 */

#define IPU7_CSI_RX_SYNC_IRQ_MASK		0 /* 0xffffffff */
#define IPU7P5_CSI_RX_SYNC_FE_IRQ_MASK		0 /* 0xffffffff */

#define CSI_RX_NUM_ERRORS_IN_IRQ		12
#define CSI_RX_NUM_SYNC_IN_IRQ			32

enum CSI_FE_MODE_TYPE {
	CSI_FE_DPHY_MODE = 0,
	CSI_FE_CPHY_MODE = 1,
};

enum CSI_FE_INPUT_MODE {
	CSI_SENSOR_INPUT = 0,
	CSI_MIPIGEN_INPUT = 1,
};

enum MGC_CSI_ADPL_TYPE {
	MGC_MAPPED_2_LANES = 0,
	MGC_MAPPED_4_LANES = 1,
};

enum CSI2HOST_SELECTION {
	CSI2HOST_SEL_SOC = 0,
	CSI2HOST_SEL_CSI2HOST = 1,
};

#define IPU7_ISYS_LEGACY_IRQ_CSI2(port)		(0x3 << (port))
#define IPU7P5_ISYS_LEGACY_IRQ_CSI2(port)	(0x7 << (port))

/* ---------------------------------------------------------------- */
#define CSI_REG_BASE			0x220000
#define CSI_REG_BASE_PORT(id)		((id) * 0x1000)

/* CSI Port Genral Purpose Registers */
#define CSI_REG_PORT_GPREG_SRST                 0x0
#define CSI_REG_PORT_GPREG_CSI2_SLV_REG_SRST    0x4
#define CSI_REG_PORT_GPREG_CSI2_PORT_CONTROL    0x8

#define CSI_RX_NUM_IRQ				32

#define IPU7_CSI_RX_SYNC_FS_VC		0x55555555
#define IPU7_CSI_RX_SYNC_FE_VC		0xaaaaaaaa
#define IPU7P5_CSI_RX_SYNC_FS_VC	0xffff
#define IPU7P5_CSI_RX_SYNC_FE_VC	0xffff

#endif /* IPU7_ISYS_CSI2_REG_H */
