/*
 * Jalview - A Sequence Alignment Editor and Viewer (2.11.4.0)
 * Copyright (C) 2024 The Jalview Authors
 * 
 * This file is part of Jalview.
 * 
 * Jalview is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 *  
 * Jalview is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty 
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Jalview.  If not, see <http://www.gnu.org/licenses/>.
 * The Jalview Authors are detailed in the 'AUTHORS' file.
 */
package jalview.io.gff;

/**
 * A factory class that returns a model of the Sequence Ontology. By default a
 * hard-coded subset is used (for the applet, or testing), or setInstance() can
 * be used to set full Ontology data.
 * 
 * @author gmcarstairs
 *
 */
public class SequenceOntologyFactory
{
  private static SequenceOntologyI instance;

  public static synchronized SequenceOntologyI getInstance()
  {
    if (instance == null)
    {
      instance = new SequenceOntologyLite();
    }
    return instance;
  }

  public static void setInstance(SequenceOntologyI so)
  {
    instance = so;
  }
}
