/*
 * Decompiled with CFR 0.152.
 */
package org.freshcookies.security.policy;

import java.io.FilePermission;
import java.net.URL;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.security.cert.Certificate;
import java.util.PropertyPermission;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.SubjectDomainCombiner;
import junit.framework.TestCase;
import org.freshcookies.security.AllTests;
import org.freshcookies.security.policy.GenericPrincipal;
import org.freshcookies.security.policy.LocalPolicy;
import org.freshcookies.security.policy.PolicyReader;

public class LocalPolicyTest
extends TestCase {
    private LocalPolicy p = null;
    private ProtectionDomain pd = null;
    static /* synthetic */ Class class$0;

    protected void setUp() throws Exception {
        super.setUp();
        this.p = new LocalPolicy(AllTests.TEST_POLICY);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.freshcookies.security.policy.LocalPolicyTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.pd = clazz.getProtectionDomain();
    }

    public void testImplies() throws Exception {
        LocalPolicyTest.assertFalse((boolean)this.p.implies(this.pd, new FilePermission("${java.home}/lib/security/java.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(this.pd, new PropertyPermission("java.version", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(this.pd, new RuntimePermission("stopThread")));
        URL buildClasses = new URL("file:${user.home}/workspace/freshcookies-security/target/classes/-");
        URL testClasses = new URL("file:${user.home}/workspace/freshcookies-security/target-test/");
        CodeSource buildCodeSource = new CodeSource(buildClasses, null);
        CodeSource testCodeSource = new CodeSource(testClasses, null);
        Permissions NO_PERMS = new Permissions();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.freshcookies.security.policy.LocalPolicyTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassLoader cl = clazz.getClassLoader();
        ProtectionDomain caller = new ProtectionDomain(buildCodeSource, NO_PERMS, cl, null);
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new RuntimePermission("setSecurityManager")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new SecurityPermission("getPolicy")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("${java.home}/lib/security/java.policy", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("${user.home}/.java.policy", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("${user.home}/workspace/freshcookies-security/etc/keystore.jks", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("${user.home}/workspace/freshcookies-security/etc/test.policy", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new PropertyPermission("user.home", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new PropertyPermission("java.home", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new PropertyPermission("java.security.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new RuntimePermission("accessClassInPackage.java.io")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new AuthPermission("doAsPrivileged")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users/foo", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users", "read,write")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users/arj", "write")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users/arj/foo/-", "write")));
        PolicyReader reader = new PolicyReader(AllTests.TEST_POLICY);
        reader.read();
        KeyStore ks = reader.getKeyStore();
        Certificate cert = ks.getCertificate("testsigner");
        LocalPolicyTest.assertNotNull((Object)cert);
        CodeSource testSignedSource = new CodeSource(null, new Certificate[]{cert});
        Subject subject = new Subject();
        subject.getPrincipals().add(new GenericPrincipal("Foo"));
        subject.getPrincipals().add(new GenericPrincipal("Bar"));
        caller = this.combine(subject, new ProtectionDomain(testSignedSource, NO_PERMS, cl, null));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new RuntimePermission("setSecurityManager")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new SecurityPermission("getPolicy")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("${java.home}/lib/security/java.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("${user.home}/.java.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("${user.home}/workspace/freshcookies-security/etc/keystore.jks", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("${user.home}/workspace/freshcookies-security/etc/test.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new PropertyPermission("user.home", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new PropertyPermission("java.home", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new PropertyPermission("java.security.policy", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new RuntimePermission("accessClassInPackage.java.io")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new AuthPermission("doAsPrivileged")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users/foo", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users", "read,write")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users/arj", "write")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users/arj/foo/-", "write")));
        caller = new ProtectionDomain(testCodeSource, NO_PERMS, cl, null);
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new RuntimePermission("setSecurityManager")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new SecurityPermission("getPolicy")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("${java.home}/lib/security/java.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("${user.home}/.java.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("${user.home}/workspace/freshcookies-security/etc/keystore.jks", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("${user.home}/workspace/freshcookies-security/etc/test.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new PropertyPermission("user.home", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new PropertyPermission("java.home", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new PropertyPermission("java.security.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new RuntimePermission("accessClassInPackage.java.io")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new AuthPermission("doAsPrivileged")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users/foo", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users", "read,write")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users/arj", "write")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users/arj/foo/-", "write")));
        subject = new Subject();
        subject.getPrincipals().add(new GenericPrincipal("Kevin Soo Hoo"));
        subject.getPrincipals().add(new GenericPrincipal("Dan Geer"));
        caller = this.combine(subject, new ProtectionDomain(testCodeSource, NO_PERMS, cl, null));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new RuntimePermission("setSecurityManager")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new SecurityPermission("getPolicy")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("${java.home}/lib/security/java.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("${user.home}/.java.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("${user.home}/workspace/freshcookies-security/etc/keystore.jks", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("${user.home}/workspace/freshcookies-security/etc/test.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new PropertyPermission("user.home", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new PropertyPermission("java.home", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new PropertyPermission("java.security.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new RuntimePermission("accessClassInPackage.java.io")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new AuthPermission("doAsPrivileged")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("/Users/foo", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users", "read,write")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users/arj", "write")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users/arj/foo/-", "write")));
        subject = new Subject();
        subject.getPrincipals().add(new GenericPrincipal("Andrew Jaquith"));
        caller = this.combine(subject, new ProtectionDomain(testCodeSource, NO_PERMS, cl, null));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new RuntimePermission("setSecurityManager")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new SecurityPermission("getPolicy")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("${java.home}/lib/security/java.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("${user.home}/.java.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("${user.home}/workspace/freshcookies-security/etc/keystore.jks", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("${user.home}/workspace/freshcookies-security/etc/test.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new PropertyPermission("user.home", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new PropertyPermission("java.home", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new PropertyPermission("java.security.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new RuntimePermission("accessClassInPackage.java.io")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new AuthPermission("doAsPrivileged")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users/foo", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("/Users", "read,write")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("/Users/arj", "write")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("/Users/arj/foo/-", "write")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("/Users", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("/Users", "write")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("/Users/arj/foo/*", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("/Users/arj/foo/*", "write")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("/Users/arj/foo/test", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("/Users/arj/foo/test", "write")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("/Users/arj/foo/test/file", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("/Users/arj/foo/test/file", "write")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users/arj/foo/", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users/arj/foo/", "write")));
    }

    public void testImpliesSM() throws Exception {
        AllTests.startSecurityManager();
        LocalPolicyTest.assertFalse((boolean)this.p.implies(this.pd, new FilePermission("${java.home}/lib/security/java.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(this.pd, new PropertyPermission("java.version", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(this.pd, new RuntimePermission("stopThread")));
        URL buildClasses = new URL("file:${user.home}/workspace/freshcookies-security/target/classes/-");
        CodeSource buildCodeSource = new CodeSource(buildClasses, null);
        Permissions NO_PERMS = new Permissions();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.freshcookies.security.policy.LocalPolicyTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassLoader cl = clazz.getClassLoader();
        ProtectionDomain caller = new ProtectionDomain(buildCodeSource, NO_PERMS, cl, null);
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new RuntimePermission("setSecurityManager")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new SecurityPermission("getPolicy")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("${java.home}/lib/security/java.policy", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("${user.home}/.java.policy", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("${user.home}/workspace/freshcookies-security/etc/keystore.jks", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new FilePermission("${user.home}/workspace/freshcookies-security/etc/test.policy", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new PropertyPermission("user.home", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new PropertyPermission("java.home", "read")));
        LocalPolicyTest.assertTrue((boolean)this.p.implies(caller, new PropertyPermission("java.security.policy", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new RuntimePermission("accessClassInPackage.java.io")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new AuthPermission("doAsPrivileged")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users/foo", "read")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users", "read,write")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users/arj", "write")));
        LocalPolicyTest.assertFalse((boolean)this.p.implies(caller, new FilePermission("/Users/arj/foo/-", "write")));
        AllTests.stopSecurityManager();
    }

    private ProtectionDomain combine(Subject subject, ProtectionDomain thisPd) {
        SubjectDomainCombiner combiner = new SubjectDomainCombiner(subject);
        ProtectionDomain[] oldPds = new ProtectionDomain[]{thisPd};
        ProtectionDomain[] newPds = new ProtectionDomain[1];
        newPds = combiner.combine(oldPds, newPds);
        return newPds[0];
    }
}

