/*
 * %kadu copyright begin%
 * Copyright 2009, 2011 Piotr Galiszewski (piotr.galiszewski@kadu.im)
 * Copyright 2009, 2010 Rafał Malinowski (rafal.przemyslaw.malinowski@gmail.com)
 * Copyright 2010 Bartosz Brachaczek (b.brachaczek@gmail.com)
 * %kadu copyright end%
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "notify-event.h"

NotifyEvent::NotifyEvent(const QString &name, NotifyEvent::CallbackRequirement isCallbackRequired, const char *description) :
		Name(name), IsCallbackRequired(isCallbackRequired), Description(description)
{
	int index = Name.indexOf("/");
	Category = (index > 0) ? Name.left(index) : QString();
}

bool NotifyEvent::operator == (const NotifyEvent &compare)
{
	return Name == compare.Name;
}
