/*
 * Decompiled with CFR 0.152.
 */
package net.noha.tools.ant.yuicompressor.tasks;

import java.io.File;
import net.noha.tools.ant.yuicompressor.tasks.FileType;

public class CompressionStatistics {
    private long fromBytes = 0L;
    private long toBytes = 0L;
    private long fileCount = 0L;
    private long jsFromBytes = 0L;
    private long jsToBytes = 0L;
    private long jsFileCount = 0L;
    private long cssFromBytes = 0L;
    private long cssToBytes = 0L;
    private long cssFileCount = 0L;

    public String getFileStats(File inFile, File outFile, FileType fileType) {
        this.fromBytes += inFile.length();
        this.toBytes += outFile.length();
        ++this.fileCount;
        if (fileType.equals((Object)FileType.JS_FILE)) {
            this.jsFromBytes += inFile.length();
            this.jsToBytes += outFile.length();
            ++this.jsFileCount;
        } else {
            this.cssFromBytes += inFile.length();
            this.cssToBytes += outFile.length();
            ++this.cssFileCount;
        }
        int percentage = (int)Math.floor((double)outFile.length() / (double)inFile.length() * 100.0);
        return "[" + percentage + "%] " + inFile.getName() + " [" + inFile.length() + "] ---> " + outFile.getName() + " [" + outFile.length() + "]";
    }

    public String getTotalStats() {
        if (this.fileCount == 0L) {
            return "No files to compress, or all files already up to date";
        }
        int percentage = (int)Math.floor((double)this.toBytes / (double)this.fromBytes * 100.0);
        long fromKBytes = (long)Math.floor((double)this.fromBytes / 1024.0);
        long toKBytes = (long)Math.floor((double)this.toBytes / 1024.0);
        long saved = fromKBytes - toKBytes;
        return "Compressed " + this.fileCount + " files to " + percentage + "% (" + fromKBytes + "KB to " + toKBytes + "KB, saving " + saved + "KB)";
    }

    public String getJsStats() {
        if (this.jsFileCount == 0L) {
            return "[JavaScript] No files to compress, or all files already up to date";
        }
        int percentage = (int)Math.floor((double)this.jsToBytes / (double)this.jsFromBytes * 100.0);
        long fromKBytes = (long)Math.floor((double)this.jsFromBytes / 1024.0);
        long toKBytes = (long)Math.floor((double)this.jsToBytes / 1024.0);
        long saved = fromKBytes - toKBytes;
        return "[JavaScript] Compressed " + this.jsFileCount + " files to " + percentage + "% (" + fromKBytes + "KB to " + toKBytes + "KB, saving " + saved + "KB)";
    }

    public String getCssStats() {
        if (this.cssFileCount == 0L) {
            return "[CSS] No files to compress, or all files already up to date";
        }
        int percentage = (int)Math.floor((double)this.cssToBytes / (double)this.cssFromBytes * 100.0);
        long fromKBytes = (long)Math.floor((double)this.cssFromBytes / 1024.0);
        long toKBytes = (long)Math.floor((double)this.cssToBytes / 1024.0);
        long saved = fromKBytes - toKBytes;
        return "[CSS] Compressed " + this.cssFileCount + " files to " + percentage + "% (" + fromKBytes + "KB to " + toKBytes + "KB, saving " + saved + "KB)";
    }
}

