/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "profilesmartcardoptions.h"

#include <QtGui/QCheckBox>
#include <QtGui/QLabel>
#include <QtGui/QSpinBox>

#include <kcombobox.h>
#include <klineedit.h>
#include <klocale.h>
#include <kurlrequester.h>

#include "widgetnotifyhelper.h"

ProfileSmartcardOptions::ProfileSmartcardOptions(QWidget *parent) : QWidget(parent)
{
    setupUi(this);
    QObject::connect(UsePkcs11ProvidersCheckBox, SIGNAL(toggled(bool)), this, SLOT(usePkcs11ProvidersToggled(bool)));
    QObject::connect(UseSmartcardCheckBox, SIGNAL(toggled(bool)), this, SLOT(useSmartcardToggled(bool)));
    WidgetNotifyHelper h;
    h.setupChangedAction(this);
    dialogModified = false;
}


ProfileSmartcardOptions::~ProfileSmartcardOptions()
{}

void ProfileSmartcardOptions::usePkcs11ProvidersToggled(bool)
{
    if (UsePkcs11ProvidersCheckBox->isChecked())
        Pkcs11ProvidersURLRequester->setEnabled(true);
    else
        Pkcs11ProvidersURLRequester->setEnabled(false);
}

void ProfileSmartcardOptions::useSmartcardToggled(bool)
{
    if (UseSmartcardCheckBox->isChecked())
        SmartcardGroupBox->setEnabled(true);
    else
        SmartcardGroupBox->setEnabled(false);
}

void ProfileSmartcardOptions::idTypeToggled()
{
//  if (Pkcs11IdTypeComboBox->currentIndex() == 0)
//   IdLabel->setText(i18n("ID"));
//  else if (Pkcs11IdTypeComboBox->currentIndex() == 1)
//   IdLabel->setText(i18n("Label"));
//  else
//   IdLabel->setText(i18n("Description"));
}

void ProfileSmartcardOptions::dialogChanged()
{
    dialogModified = true;
}







