package latexDraw.figures.properties;

import java.awt.Shape;

/** 
 * This class define a properties of figures : if the figure can have 
 * double boundaries, then these methods allows the user to get the two of 
 * three borders of the double boundaries (the third boundary is the classic
 * borders of the figure).
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 01/20/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public interface DoubleBoundaryable
{
	/**
	 * Allows to get the two others borders of the double boundary
	 * @param classicBord The initial border
	 * @return The two others borders of the double boundary (shape[0] is the
	 * bigger of the two borders).
	 */
	public Shape[] getDbleBoundariesOutside(Shape classicBord);
	
	
	
	/**
	 * Allows to get the two others borders of the double boundary
	 * @param classicBord The initial border
	 * @return The two others borders of the double boundary (shape[0] is the
	 * bigger of the two borders).
	 */
	public Shape[] getDbleBoundariesInside(Shape classicBord);
	
	
	
	/**
	 * Allows to get the two others borders of the double boundary
	 * @param classicBord The initial border
	 * @return The two others borders of the double boundary (shape[0] is the
	 * bigger of the two borders).
	 */
	public Shape[] getDbleBoundariesMiddle(Shape classicBord);
	
	
	
	
	/**
	 * Allows to get the two others borders of the figure according to the position
	 * of the borders: inside, outside or in the middle.
	 * @return The two others borders
	 */
	public Shape[] getDbleBoundariesOutInOrMiddle(Shape classicBord);
}
