/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.views;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.lisaac.ldt.LisaacPlugin;
import org.lisaac.ldt.editors.LisaacEditor;
import org.lisaac.ldt.model.LisaacModel;
import org.lisaac.ldt.model.items.Prototype;
import org.lisaac.ldt.outline.OutlineContentProvider;
import org.lisaac.ldt.outline.OutlineItem;
import org.lisaac.ldt.outline.OutlineLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LisaacOutlineView
extends ContentOutlinePage
implements IDocumentListener {
    private static final long UPDATE_DELAY = 1500L;
    private IDocumentProvider documentProvider;
    private AbstractDecoratedTextEditor textEditor;
    private IDocument document;
    private Timer updateTimer;

    public LisaacOutlineView(IDocumentProvider documentProvider, AbstractDecoratedTextEditor textEditor) {
        this.documentProvider = documentProvider;
        this.textEditor = textEditor;
        this.createTimer();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new OutlineContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.createActions();
        this.document = this.getDocument();
        if (this.document != null) {
            this.document.addDocumentListener((IDocumentListener)this);
        }
        this.update();
    }

    private void createActions() {
        Action sortByName = new Action("Sort by name", 2){
            ViewerSorter sortByNameSorter;

            public void setAlphaSort(boolean doSort) {
                if (this.sortByNameSorter == null) {
                    this.sortByNameSorter = new ViewerSorter(){

                        public int compare(Viewer viewer, Object e1, Object e2) {
                            return ((Comparable)e1).compareTo(e2);
                        }
                    };
                }
                LisaacOutlineView.this.getTreeViewer().setSorter(doSort ? this.sortByNameSorter : null);
            }

            public void run() {
                this.setAlphaSort(this.isChecked());
            }
        };
        sortByName.run();
        Action sortBySection = new Action("Sort by Section", 2){

            public void run() {
                OutlineItem.showSections = this.isChecked();
                LisaacOutlineView.this.getTreeViewer().refresh();
                LisaacOutlineView.this.getTreeViewer().expandAll();
            }
        };
        sortBySection.setChecked(true);
        try {
            sortByName.setImageDescriptor(LisaacPlugin.getImageDescriptor("/icons/alphab_sort_co.gif"));
            sortBySection.setImageDescriptor(LisaacPlugin.getImageDescriptor("/icons/sections_co.gif"));
        }
        catch (Exception exception) {}
        IActionBars actionBars = this.getSite().getActionBars();
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        toolbarManager.add((IAction)sortByName);
        toolbarManager.add((IAction)sortBySection);
    }

    public IDocument getDocument() {
        if (this.document == null) {
            this.document = this.documentProvider.getDocument((Object)this.textEditor.getEditorInput());
        }
        return this.document;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        TreeSelection selection;
        Object selectedElement;
        ISelection abstractSelection = event.getSelection();
        IDocument document = this.getDocument();
        if (document != null && abstractSelection != null && abstractSelection instanceof TreeSelection && (selectedElement = (selection = (TreeSelection)abstractSelection).getFirstElement()) != null && selectedElement instanceof OutlineItem) {
            OutlineItem item = (OutlineItem)selectedElement;
            this.textEditor.selectAndReveal(item.startOffset(), item.length());
        }
    }

    public void setInput(Object input) {
        if (!this.getTreeViewer().getControl().isDisposed()) {
            this.getTreeViewer().setInput(input);
            this.getTreeViewer().expandAll();
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.document = event.getDocument();
        this.update();
    }

    public List<OutlineItem> getSourceOutline(IProject project, String filename) throws CoreException {
        Prototype prototype;
        LisaacModel model = LisaacModel.getModel(project);
        if (model != null && (prototype = model.getPrototype(LisaacModel.extractPrototypeName(filename))) != null) {
            return prototype.getOutlineItems();
        }
        return null;
    }

    private void createTimer() {
        this.updateTimer = new Timer("org.lisaac.ldt.outlinetimer");
    }

    public void update() {
        this.updateTimer.cancel();
        this.updateTimer.purge();
        this.createTimer();
        OutlineUpdateTask updateTask = new OutlineUpdateTask();
        this.updateTimer.schedule((TimerTask)updateTask, 1500L);
    }

    class OutlineUpdateTask
    extends TimerTask {
        public void run() {
            IDocument document = LisaacOutlineView.this.getDocument();
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (document != null && LisaacOutlineView.this.textEditor instanceof LisaacEditor) {
                IProject project = ((LisaacEditor)LisaacOutlineView.this.textEditor).getProject();
                String filename = ((LisaacEditor)LisaacOutlineView.this.textEditor).getFileName();
                try {
                    final List<OutlineItem> items = LisaacOutlineView.this.getSourceOutline(project, filename);
                    display.asyncExec(new Runnable(){

                        public void run() {
                            if (items != null) {
                                LisaacOutlineView.this.setInput(items.toArray(new OutlineItem[items.size()]));
                                ((LisaacEditor)LisaacOutlineView.this.textEditor).refreshPresentation();
                            }
                        }
                    });
                }
                catch (CoreException coreException) {}
            }
        }
    }
}

