#ifndef _LAUNCHER_H
#define _LAUNCHER_H

#include <string>

#include "applet.h"

class Launcher : public Applet {
  public:
    Launcher(AppletWindowParams params);
    virtual ~Launcher(){}
    void LoadApps(const std::string& apps_path, const std::string& icons_path);
    void DrawApps();
    void SetAppWidth(int w);
    void SetAppHeight(int h);
    void SetMarginTop(int x);
    void SetMarginBottom(int x);
    void SetMarginSide(int x);
    virtual AppAction OnMousePress(int x, int y);
 
    virtual void OnRotate(Rotation rot);

  private:
    struct App {
	std::string name;
	std::string icon;
	std::string exec;
    };

    int app_width, app_height, margin_top, margin_bottom, margin_side;

    bool LoadDesktopFile(const std::string& path, App& app);

    std::vector<App> apps;
};

#endif 
