; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2             | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512f          | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512f,avx512vl | FileCheck %s --check-prefixes=AVX512,AVX512VL

define <4 x float> @fadd_v4f32(<4 x i1> %b, <4 x float> noundef %x, <4 x float> noundef %y) {
; AVX2-LABEL: fadd_v4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm3 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX2-NEXT:    vblendvps %xmm0, %xmm2, %xmm3, %xmm0
; AVX2-NEXT:    vaddps %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fadd_v4f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} xmm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX512F-NEXT:    vmovaps %zmm2, %zmm0 {%k1}
; AVX512F-NEXT:    vaddps %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fadd_v4f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vaddps %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovaps %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x float> %y, <4 x float> <float -0.0, float -0.0, float -0.0, float -0.0>
  %r = fadd <4 x float> %x, %s
  ret <4 x float> %r
}

define <8 x float> @fadd_v8f32_commute(<8 x i1> %b, <8 x float> noundef %x, <8 x float> noundef %y) {
; AVX2-LABEL: fadd_v8f32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX2-NEXT:    vblendvps %ymm0, %ymm2, %ymm3, %ymm0
; AVX2-NEXT:    vaddps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fadd_v8f32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} ymm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX512F-NEXT:    vmovaps %zmm2, %zmm0 {%k1}
; AVX512F-NEXT:    vaddps %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fadd_v8f32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vaddps %ymm2, %ymm1, %ymm1 {%k1}
; AVX512VL-NEXT:    vmovaps %ymm1, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x float> %y, <8 x float> <float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0>
  %r = fadd <8 x float> %s, %x
  ret <8 x float> %r
}

define <16 x float> @fadd_v16f32_swap(<16 x i1> %b, <16 x float> noundef %x, <16 x float> noundef %y) {
; AVX2-LABEL: fadd_v16f32_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm6 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX2-NEXT:    vblendvps %ymm5, %ymm6, %ymm3, %ymm3
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vblendvps %ymm0, %ymm6, %ymm4, %ymm4
; AVX2-NEXT:    vaddps %ymm3, %ymm1, %ymm0
; AVX2-NEXT:    vaddps %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fadd_v16f32_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vaddps %zmm2, %zmm1, %zmm0
; AVX512-NEXT:    vmovaps %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x float> <float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0>, <16 x float> %y
  %r = fadd <16 x float> %x, %s
  ret <16 x float> %r
}

define <16 x float> @fadd_v16f32_commute_swap(<16 x i1> %b, <16 x float> noundef %x, <16 x float> noundef %y) {
; AVX2-LABEL: fadd_v16f32_commute_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm6 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX2-NEXT:    vblendvps %ymm5, %ymm6, %ymm3, %ymm3
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vblendvps %ymm0, %ymm6, %ymm4, %ymm4
; AVX2-NEXT:    vaddps %ymm1, %ymm3, %ymm0
; AVX2-NEXT:    vaddps %ymm2, %ymm4, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fadd_v16f32_commute_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vaddps %zmm2, %zmm1, %zmm0
; AVX512-NEXT:    vmovaps %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x float> <float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0>, <16 x float> %y
  %r = fadd <16 x float> %s, %x
  ret <16 x float> %r
}

define <4 x float> @fsub_v4f32(<4 x i1> %b, <4 x float> noundef %x, <4 x float> noundef %y) {
; AVX2-LABEL: fsub_v4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vsubps %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fsub_v4f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovaps %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vsubps %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fsub_v4f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vsubps %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovaps %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x float> %y, <4 x float> zeroinitializer
  %r = fsub <4 x float> %x, %s
  ret <4 x float> %r
}

; negative test - fsub is not commutative; there is no identity constant for operand 0

define <8 x float> @fsub_v8f32_commute(<8 x i1> %b, <8 x float> noundef %x, <8 x float> noundef %y) {
; AVX2-LABEL: fsub_v8f32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vsubps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fsub_v8f32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovaps %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vsubps %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fsub_v8f32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vmovaps %ymm2, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vsubps %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x float> %y, <8 x float> zeroinitializer
  %r = fsub <8 x float> %s, %x
  ret <8 x float> %r
}

define <16 x float> @fsub_v16f32_swap(<16 x i1> %b, <16 x float> noundef %x, <16 x float> noundef %y) {
; AVX2-LABEL: fsub_v16f32_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vsubps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vsubps %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fsub_v16f32_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vsubps %zmm2, %zmm1, %zmm0
; AVX512-NEXT:    vmovaps %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x float> zeroinitializer, <16 x float> %y
  %r = fsub <16 x float> %x, %s
  ret <16 x float> %r
}

; negative test - fsub is not commutative; there is no identity constant for operand 0

define <16 x float> @fsub_v16f32_commute_swap(<16 x i1> %b, <16 x float> noundef %x, <16 x float> noundef %y) {
; AVX2-LABEL: fsub_v16f32_commute_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vsubps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vsubps %ymm2, %ymm4, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fsub_v16f32_commute_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vmovaps %zmm2, %zmm0 {%k1} {z}
; AVX512-NEXT:    vsubps %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x float> zeroinitializer, <16 x float> %y
  %r = fsub <16 x float> %s, %x
  ret <16 x float> %r
}

define <4 x float> @fmul_v4f32(<4 x i1> %b, <4 x float> noundef %x, <4 x float> noundef %y) {
; AVX2-LABEL: fmul_v4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm3 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %xmm0, %xmm2, %xmm3, %xmm0
; AVX2-NEXT:    vmulps %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fmul_v4f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} xmm0 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX512F-NEXT:    vmovaps %zmm2, %zmm0 {%k1}
; AVX512F-NEXT:    vmulps %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fmul_v4f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vmulps %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovaps %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x float> %y, <4 x float> <float 1.0, float 1.0, float 1.0, float 1.0>
  %r = fmul <4 x float> %x, %s
  ret <4 x float> %r
}

define <8 x float> @fmul_v8f32_commute(<8 x i1> %b, <8 x float> noundef %x, <8 x float> noundef %y) {
; AVX2-LABEL: fmul_v8f32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %ymm0, %ymm2, %ymm3, %ymm0
; AVX2-NEXT:    vmulps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fmul_v8f32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} ymm0 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX512F-NEXT:    vmovaps %zmm2, %zmm0 {%k1}
; AVX512F-NEXT:    vmulps %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fmul_v8f32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vmulps %ymm2, %ymm1, %ymm1 {%k1}
; AVX512VL-NEXT:    vmovaps %ymm1, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x float> %y, <8 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>
  %r = fmul <8 x float> %s, %x
  ret <8 x float> %r
}

define <16 x float> @fmul_v16f32_swap(<16 x i1> %b, <16 x float> noundef %x, <16 x float> noundef %y) {
; AVX2-LABEL: fmul_v16f32_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %ymm5, %ymm6, %ymm3, %ymm3
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vblendvps %ymm0, %ymm6, %ymm4, %ymm4
; AVX2-NEXT:    vmulps %ymm3, %ymm1, %ymm0
; AVX2-NEXT:    vmulps %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fmul_v16f32_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vmulps %zmm2, %zmm1, %zmm0
; AVX512-NEXT:    vmovaps %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>, <16 x float> %y
  %r = fmul <16 x float> %x, %s
  ret <16 x float> %r
}

define <16 x float> @fmul_v16f32_commute_swap(<16 x i1> %b, <16 x float> noundef %x, <16 x float> noundef %y) {
; AVX2-LABEL: fmul_v16f32_commute_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %ymm5, %ymm6, %ymm3, %ymm3
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vblendvps %ymm0, %ymm6, %ymm4, %ymm4
; AVX2-NEXT:    vmulps %ymm1, %ymm3, %ymm0
; AVX2-NEXT:    vmulps %ymm2, %ymm4, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fmul_v16f32_commute_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vmulps %zmm2, %zmm1, %zmm0
; AVX512-NEXT:    vmovaps %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>, <16 x float> %y
  %r = fmul <16 x float> %s, %x
  ret <16 x float> %r
}

define <4 x float> @fdiv_v4f32(<4 x i1> %b, <4 x float> noundef %x, <4 x float> noundef %y) {
; AVX2-LABEL: fdiv_v4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm3 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %xmm0, %xmm2, %xmm3, %xmm0
; AVX2-NEXT:    vdivps %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fdiv_v4f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} xmm0 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX512F-NEXT:    vmovaps %zmm2, %zmm0 {%k1}
; AVX512F-NEXT:    vdivps %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fdiv_v4f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vdivps %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovaps %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x float> %y, <4 x float> <float 1.0, float 1.0, float 1.0, float 1.0>
  %r = fdiv <4 x float> %x, %s
  ret <4 x float> %r
}

define <8 x float> @fdiv_v8f32_commute(<8 x i1> %b, <8 x float> noundef %x, <8 x float> noundef %y) {
; AVX2-LABEL: fdiv_v8f32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %ymm0, %ymm2, %ymm3, %ymm0
; AVX2-NEXT:    vdivps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fdiv_v8f32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} ymm0 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX512F-NEXT:    vmovaps %zmm2, %zmm0 {%k1}
; AVX512F-NEXT:    vdivps %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fdiv_v8f32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vbroadcastss {{.*#+}} ymm0 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX512VL-NEXT:    vmovaps %ymm2, %ymm0 {%k1}
; AVX512VL-NEXT:    vdivps %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x float> %y, <8 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>
  %r = fdiv <8 x float> %s, %x
  ret <8 x float> %r
}

define <16 x float> @fdiv_v16f32_swap(<16 x i1> %b, <16 x float> noundef %x, <16 x float> noundef %y) {
; AVX2-LABEL: fdiv_v16f32_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %ymm5, %ymm6, %ymm3, %ymm3
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vblendvps %ymm0, %ymm6, %ymm4, %ymm4
; AVX2-NEXT:    vdivps %ymm3, %ymm1, %ymm0
; AVX2-NEXT:    vdivps %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fdiv_v16f32_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vdivps %zmm2, %zmm1, %zmm0
; AVX512-NEXT:    vmovaps %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>, <16 x float> %y
  %r = fdiv <16 x float> %x, %s
  ret <16 x float> %r
}

define <16 x float> @fdiv_v16f32_commute_swap(<16 x i1> %b, <16 x float> noundef %x, <16 x float> noundef %y) {
; AVX2-LABEL: fdiv_v16f32_commute_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %ymm5, %ymm6, %ymm3, %ymm3
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vblendvps %ymm0, %ymm6, %ymm4, %ymm4
; AVX2-NEXT:    vdivps %ymm1, %ymm3, %ymm0
; AVX2-NEXT:    vdivps %ymm2, %ymm4, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fdiv_v16f32_commute_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vbroadcastss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2 {%k1}
; AVX512-NEXT:    vdivps %zmm1, %zmm2, %zmm0
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>, <16 x float> %y
  %r = fdiv <16 x float> %s, %x
  ret <16 x float> %r
}

define <8 x float> @fadd_v8f32_cast_cond(i8 noundef zeroext %pb, <8 x float> noundef %x, <8 x float> noundef %y) {
; AVX2-LABEL: fadd_v8f32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX2-NEXT:    vblendvps %ymm2, %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vaddps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fadd_v8f32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} ymm2 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX512F-NEXT:    vmovaps %zmm1, %zmm2 {%k1}
; AVX512F-NEXT:    vaddps %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fadd_v8f32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x float> %y, <8 x float> <float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0>
  %r = fadd <8 x float> %x, %s
  ret <8 x float> %r
}

define <8 x double> @fadd_v8f64_cast_cond(i8 noundef zeroext %pb, <8 x double> noundef %x, <8 x double> noundef %y) {
; AVX2-LABEL: fadd_v8f64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX2-NEXT:    vblendvpd %ymm5, %ymm3, %ymm6, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vblendvpd %ymm4, %ymm2, %ymm6, %ymm2
; AVX2-NEXT:    vaddpd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vaddpd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fadd_v8f64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vaddpd %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x double> %y, <8 x double> <double -0.0, double -0.0, double -0.0, double -0.0, double -0.0, double -0.0, double -0.0, double -0.0>
  %r = fadd <8 x double> %x, %s
  ret <8 x double> %r
}

define <8 x float> @fsub_v8f32_cast_cond(i8 noundef zeroext %pb, <8 x float> noundef %x, <8 x float> noundef %y) {
; AVX2-LABEL: fsub_v8f32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vsubps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fsub_v8f32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vmovaps %zmm1, %zmm1 {%k1} {z}
; AVX512F-NEXT:    vsubps %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fsub_v8f32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vsubps %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x float> %y, <8 x float> zeroinitializer
  %r = fsub <8 x float> %x, %s
  ret <8 x float> %r
}

define <8 x double> @fsub_v8f64_cast_cond(i8 noundef zeroext %pb, <8 x double> noundef %x, <8 x double> noundef %y) {
; AVX2-LABEL: fsub_v8f64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpand %ymm3, %ymm5, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpand %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vsubpd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vsubpd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fsub_v8f64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vsubpd %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x double> %y, <8 x double> zeroinitializer
  %r = fsub <8 x double> %x, %s
  ret <8 x double> %r
}

define <8 x float> @fmul_v8f32_cast_cond(i8 noundef zeroext %pb, <8 x float> noundef %x, <8 x float> noundef %y) {
; AVX2-LABEL: fmul_v8f32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %ymm2, %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vmulps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fmul_v8f32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} ymm2 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX512F-NEXT:    vmovaps %zmm1, %zmm2 {%k1}
; AVX512F-NEXT:    vmulps %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fmul_v8f32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vmulps %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x float> %y, <8 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>
  %r = fmul <8 x float> %x, %s
  ret <8 x float> %r
}

define <8 x double> @fmul_v8f64_cast_cond(i8 noundef zeroext %pb, <8 x double> noundef %x, <8 x double> noundef %y) {
; AVX2-LABEL: fmul_v8f64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvpd %ymm5, %ymm3, %ymm6, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vblendvpd %ymm4, %ymm2, %ymm6, %ymm2
; AVX2-NEXT:    vmulpd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vmulpd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fmul_v8f64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vmulpd %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x double> %y, <8 x double> <double 1.0, double 1.0, double 1.0, double 1.0, double 1.0, double 1.0, double 1.0, double 1.0>
  %r = fmul <8 x double> %x, %s
  ret <8 x double> %r
}

define <8 x float> @fdiv_v8f32_cast_cond(i8 noundef zeroext %pb, <8 x float> noundef %x, <8 x float> noundef %y) {
; AVX2-LABEL: fdiv_v8f32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %ymm2, %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vdivps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fdiv_v8f32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} ymm2 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX512F-NEXT:    vmovaps %zmm1, %zmm2 {%k1}
; AVX512F-NEXT:    vdivps %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fdiv_v8f32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vdivps %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x float> %y, <8 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>
  %r = fdiv <8 x float> %x, %s
  ret <8 x float> %r
}

define <8 x double> @fdiv_v8f64_cast_cond(i8 noundef zeroext %pb, <8 x double> noundef %x, <8 x double> noundef %y) {
; AVX2-LABEL: fdiv_v8f64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvpd %ymm5, %ymm3, %ymm6, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vblendvpd %ymm4, %ymm2, %ymm6, %ymm2
; AVX2-NEXT:    vdivpd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vdivpd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fdiv_v8f64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vdivpd %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x double> %y, <8 x double> <double 1.0, double 1.0, double 1.0, double 1.0, double 1.0, double 1.0, double 1.0, double 1.0>
  %r = fdiv <8 x double> %x, %s
  ret <8 x double> %r
}

define <4 x i32> @add_v4i32(<4 x i1> %b, <4 x i32> noundef %x, <4 x i32> noundef %y) {
; AVX2-LABEL: add_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: add_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: add_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpaddd %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x i32> %y, <4 x i32> zeroinitializer
  %r = add <4 x i32> %x, %s
  ret <4 x i32> %r
}

define <8 x i32> @add_v8i32_commute(<8 x i1> %b, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; AVX2-LABEL: add_v8i32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: add_v8i32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: add_v8i32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vpaddd %ymm2, %ymm1, %ymm1 {%k1}
; AVX512VL-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = add <8 x i32> %s, %x
  ret <8 x i32> %r
}

define <8 x i32> @add_v8i32_cast_cond(i8 noundef zeroext %pb, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; AVX2-LABEL: add_v8i32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: add_v8i32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm1, %zmm1 {%k1} {z}
; AVX512F-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: add_v8i32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpaddd %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = add <8 x i32> %x, %s
  ret <8 x i32> %r
}

define <8 x i64> @add_v8i64_cast_cond(i8 noundef zeroext %pb, <8 x i64> noundef %x, <8 x i64> noundef %y) {
; AVX2-LABEL: add_v8i64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpand %ymm3, %ymm5, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpand %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: add_v8i64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vpaddq %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i64> %y, <8 x i64> zeroinitializer
  %r = add <8 x i64> %x, %s
  ret <8 x i64> %r
}

define <4 x i32> @sub_v4i32(<4 x i1> %b, <4 x i32> noundef %x, <4 x i32> noundef %y) {
; AVX2-LABEL: sub_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpsubd %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: sub_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpsubd %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: sub_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpsubd %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x i32> %y, <4 x i32> zeroinitializer
  %r = sub <4 x i32> %x, %s
  ret <4 x i32> %r
}

; negative test - sub is not commutative; there is no identity constant for operand 0

define <8 x i32> @sub_v8i32_commute(<8 x i1> %b, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; AVX2-LABEL: sub_v8i32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: sub_v8i32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: sub_v8i32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vmovdqa32 %ymm2, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = sub <8 x i32> %s, %x
  ret <8 x i32> %r
}

define <16 x i32> @sub_v16i32_swap(<16 x i1> %b, <16 x i32> noundef %x, <16 x i32> noundef %y) {
; AVX2-LABEL: sub_v16i32_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsubd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsubd %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sub_v16i32_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vpsubd %zmm2, %zmm1, %zmm0
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x i32> zeroinitializer, <16 x i32> %y
  %r = sub <16 x i32> %x, %s
  ret <16 x i32> %r
}

; negative test - sub is not commutative; there is no identity constant for operand 0

define <16 x i32> @sub_v16i32_commute_swap(<16 x i1> %b, <16 x i32> noundef %x, <16 x i32> noundef %y) {
; AVX2-LABEL: sub_v16i32_commute_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsubd %ymm2, %ymm4, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sub_v16i32_commute_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512-NEXT:    vpsubd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x i32> zeroinitializer, <16 x i32> %y
  %r = sub <16 x i32> %s, %x
  ret <16 x i32> %r
}

define <8 x i32> @sub_v8i32_cast_cond(i8 noundef zeroext %pb, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; AVX2-LABEL: sub_v8i32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: sub_v8i32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm1, %zmm1 {%k1} {z}
; AVX512F-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: sub_v8i32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpsubd %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = sub <8 x i32> %x, %s
  ret <8 x i32> %r
}

define <8 x i64> @sub_v8i64_cast_cond(i8 noundef zeroext %pb, <8 x i64> noundef %x, <8 x i64> noundef %y) {
; AVX2-LABEL: sub_v8i64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpand %ymm3, %ymm5, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpand %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpsubq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsubq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sub_v8i64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i64> %y, <8 x i64> zeroinitializer
  %r = sub <8 x i64> %x, %s
  ret <8 x i64> %r
}

define <4 x i32> @mul_v4i32(<4 x i1> %b, <4 x i32> noundef %x, <4 x i32> noundef %y) {
; AVX2-LABEL: mul_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm3 = [1,1,1,1]
; AVX2-NEXT:    vblendvps %xmm0, %xmm2, %xmm3, %xmm0
; AVX2-NEXT:    vpmulld %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: mul_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} xmm0 = [1,1,1,1]
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1}
; AVX512F-NEXT:    vpmulld %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: mul_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpmulld %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x i32> %y, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %r = mul <4 x i32> %x, %s
  ret <4 x i32> %r
}

define <8 x i32> @mul_v8i32_commute(<8 x i1> %b, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; AVX2-LABEL: mul_v8i32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1]
; AVX2-NEXT:    vblendvps %ymm0, %ymm2, %ymm3, %ymm0
; AVX2-NEXT:    vpmulld %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: mul_v8i32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} ymm0 = [1,1,1,1,1,1,1,1]
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1}
; AVX512F-NEXT:    vpmulld %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: mul_v8i32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vpmulld %ymm2, %ymm1, %ymm1 {%k1}
; AVX512VL-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %r = mul <8 x i32> %s, %x
  ret <8 x i32> %r
}

define <8 x i32> @mul_v8i32_cast_cond(i8 noundef zeroext %pb, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; AVX2-LABEL: mul_v8i32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1]
; AVX2-NEXT:    vblendvps %ymm2, %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vpmulld %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: mul_v8i32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} ymm2 = [1,1,1,1,1,1,1,1]
; AVX512F-NEXT:    vmovdqa32 %zmm1, %zmm2 {%k1}
; AVX512F-NEXT:    vpmulld %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: mul_v8i32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpmulld %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %r = mul <8 x i32> %x, %s
  ret <8 x i32> %r
}

define <8 x i64> @mul_v8i64_cast_cond(i8 noundef zeroext %pb, <8 x i64> noundef %x, <8 x i64> noundef %y) {
; AVX2-LABEL: mul_v8i64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [1,1,1,1]
; AVX2-NEXT:    vblendvpd %ymm5, %ymm3, %ymm6, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vblendvpd %ymm4, %ymm2, %ymm6, %ymm2
; AVX2-NEXT:    vpsrlq $32, %ymm0, %ymm4
; AVX2-NEXT:    vpmuludq %ymm2, %ymm4, %ymm4
; AVX2-NEXT:    vpsrlq $32, %ymm2, %ymm5
; AVX2-NEXT:    vpmuludq %ymm5, %ymm0, %ymm5
; AVX2-NEXT:    vpaddq %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpsllq $32, %ymm4, %ymm4
; AVX2-NEXT:    vpmuludq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddq %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlq $32, %ymm1, %ymm2
; AVX2-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX2-NEXT:    vpmuludq %ymm4, %ymm1, %ymm4
; AVX2-NEXT:    vpaddq %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX2-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddq %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: mul_v8i64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vpsrlq $32, %zmm1, %zmm2
; AVX512-NEXT:    vpmuludq %zmm2, %zmm0, %zmm2
; AVX512-NEXT:    vpsrlq $32, %zmm0, %zmm3
; AVX512-NEXT:    vpmuludq %zmm1, %zmm3, %zmm3
; AVX512-NEXT:    vpaddq %zmm3, %zmm2, %zmm2
; AVX512-NEXT:    vpsllq $32, %zmm2, %zmm2
; AVX512-NEXT:    vpmuludq %zmm1, %zmm0, %zmm1
; AVX512-NEXT:    vpaddq %zmm2, %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i64> %y, <8 x i64> <i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1>
  %r = mul <8 x i64> %x, %s
  ret <8 x i64> %r
}

define <4 x i32> @shl_v4i32(<4 x i1> %b, <4 x i32> noundef %x, <4 x i32> noundef %y) {
; AVX2-LABEL: shl_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpsllvd %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: shl_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpsllvd %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shl_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpsllvd %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x i32> %y, <4 x i32> zeroinitializer
  %r = shl <4 x i32> %x, %s
  ret <4 x i32> %r
}

; negative test - shl is not commutative; there is no identity constant for operand 0

define <8 x i32> @shl_v8i32_commute(<8 x i1> %b, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; AVX2-LABEL: shl_v8i32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: shl_v8i32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shl_v8i32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vmovdqa32 %ymm2, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = shl <8 x i32> %s, %x
  ret <8 x i32> %r
}

define <16 x i32> @shl_v16i32_swap(<16 x i1> %b, <16 x i32> noundef %x, <16 x i32> noundef %y) {
; AVX2-LABEL: shl_v16i32_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsllvd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsllvd %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: shl_v16i32_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vpsllvd %zmm2, %zmm1, %zmm0
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x i32> zeroinitializer, <16 x i32> %y
  %r = shl <16 x i32> %x, %s
  ret <16 x i32> %r
}

; negative test - shl is not commutative; there is no identity constant for operand 0

define <16 x i32> @shl_v16i32_commute_swap(<16 x i1> %b, <16 x i32> noundef %x, <16 x i32> noundef %y) {
; AVX2-LABEL: shl_v16i32_commute_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsllvd %ymm2, %ymm4, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: shl_v16i32_commute_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512-NEXT:    vpsllvd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x i32> zeroinitializer, <16 x i32> %y
  %r = shl <16 x i32> %s, %x
  ret <16 x i32> %r
}

define <8 x i32> @shl_v8i32_cast_cond(i8 noundef zeroext %pb, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; AVX2-LABEL: shl_v8i32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: shl_v8i32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm1, %zmm1 {%k1} {z}
; AVX512F-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shl_v8i32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = shl <8 x i32> %x, %s
  ret <8 x i32> %r
}

define <8 x i64> @shl_v8i64_cast_cond(i8 noundef zeroext %pb, <8 x i64> noundef %x, <8 x i64> noundef %y) {
; AVX2-LABEL: shl_v8i64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpand %ymm3, %ymm5, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpand %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpsllvq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllvq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: shl_v8i64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vpsllvq %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i64> %y, <8 x i64> zeroinitializer
  %r = shl <8 x i64> %x, %s
  ret <8 x i64> %r
}

define <4 x i32> @lshr_v4i32(<4 x i1> %b, <4 x i32> noundef %x, <4 x i32> noundef %y) {
; AVX2-LABEL: lshr_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpsrlvd %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: lshr_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpsrlvd %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: lshr_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpsrlvd %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x i32> %y, <4 x i32> zeroinitializer
  %r = lshr <4 x i32> %x, %s
  ret <4 x i32> %r
}

; negative test - lshr is not commutative; there is no identity constant for operand 0

define <8 x i32> @lshr_v8i32_commute(<8 x i1> %b, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; AVX2-LABEL: lshr_v8i32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: lshr_v8i32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: lshr_v8i32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vmovdqa32 %ymm2, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = lshr <8 x i32> %s, %x
  ret <8 x i32> %r
}

define <16 x i32> @lshr_v16i32_swap(<16 x i1> %b, <16 x i32> noundef %x, <16 x i32> noundef %y) {
; AVX2-LABEL: lshr_v16i32_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlvd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlvd %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: lshr_v16i32_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vpsrlvd %zmm2, %zmm1, %zmm0
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x i32> zeroinitializer, <16 x i32> %y
  %r = lshr <16 x i32> %x, %s
  ret <16 x i32> %r
}

; negative test - lshr is not commutative; there is no identity constant for operand 0

define <16 x i32> @lshr_v16i32_commute_swap(<16 x i1> %b, <16 x i32> noundef %x, <16 x i32> noundef %y) {
; AVX2-LABEL: lshr_v16i32_commute_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlvd %ymm2, %ymm4, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: lshr_v16i32_commute_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512-NEXT:    vpsrlvd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x i32> zeroinitializer, <16 x i32> %y
  %r = lshr <16 x i32> %s, %x
  ret <16 x i32> %r
}

define <8 x i32> @lshr_v8i32_cast_cond(i8 noundef zeroext %pb, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; AVX2-LABEL: lshr_v8i32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: lshr_v8i32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm1, %zmm1 {%k1} {z}
; AVX512F-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: lshr_v8i32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = lshr <8 x i32> %x, %s
  ret <8 x i32> %r
}

define <8 x i64> @lshr_v8i64_cast_cond(i8 noundef zeroext %pb, <8 x i64> noundef %x, <8 x i64> noundef %y) {
; AVX2-LABEL: lshr_v8i64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpand %ymm3, %ymm5, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpand %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpsrlvq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlvq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: lshr_v8i64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vpsrlvq %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i64> %y, <8 x i64> zeroinitializer
  %r = lshr <8 x i64> %x, %s
  ret <8 x i64> %r
}

define <4 x i32> @ashr_v4i32(<4 x i1> %b, <4 x i32> noundef %x, <4 x i32> noundef %y) {
; AVX2-LABEL: ashr_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpsravd %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: ashr_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpsravd %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: ashr_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpsravd %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x i32> %y, <4 x i32> zeroinitializer
  %r = ashr <4 x i32> %x, %s
  ret <4 x i32> %r
}

; negative test - ashr is not commutative; there is no identity constant for operand 0

define <8 x i32> @ashr_v8i32_commute(<8 x i1> %b, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; AVX2-LABEL: ashr_v8i32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsravd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: ashr_v8i32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpsravd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: ashr_v8i32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vmovdqa32 %ymm2, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpsravd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = ashr <8 x i32> %s, %x
  ret <8 x i32> %r
}

define <16 x i32> @ashr_v16i32_swap(<16 x i1> %b, <16 x i32> noundef %x, <16 x i32> noundef %y) {
; AVX2-LABEL: ashr_v16i32_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsravd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsravd %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ashr_v16i32_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vpsravd %zmm2, %zmm1, %zmm0
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x i32> zeroinitializer, <16 x i32> %y
  %r = ashr <16 x i32> %x, %s
  ret <16 x i32> %r
}

; negative test - ashr is not commutative; there is no identity constant for operand 0

define <16 x i32> @ashr_v16i32_commute_swap(<16 x i1> %b, <16 x i32> noundef %x, <16 x i32> noundef %y) {
; AVX2-LABEL: ashr_v16i32_commute_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsravd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsravd %ymm2, %ymm4, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ashr_v16i32_commute_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512-NEXT:    vpsravd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x i32> zeroinitializer, <16 x i32> %y
  %r = ashr <16 x i32> %s, %x
  ret <16 x i32> %r
}

define <8 x i32> @ashr_v8i32_cast_cond(i8 noundef zeroext %pb, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; AVX2-LABEL: ashr_v8i32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpsravd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: ashr_v8i32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm1, %zmm1 {%k1} {z}
; AVX512F-NEXT:    vpsravd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: ashr_v8i32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpsravd %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = ashr <8 x i32> %x, %s
  ret <8 x i32> %r
}

define <8 x i64> @ashr_v8i64_cast_cond(i8 noundef zeroext %pb, <8 x i64> noundef %x, <8 x i64> noundef %y) {
; AVX2-LABEL: ashr_v8i64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpand %ymm3, %ymm5, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpand %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpsrlvq %ymm2, %ymm4, %ymm5
; AVX2-NEXT:    vpsrlvq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpsubq %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlvq %ymm3, %ymm4, %ymm2
; AVX2-NEXT:    vpsrlvq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ashr_v8i64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vpsravq %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i64> %y, <8 x i64> zeroinitializer
  %r = ashr <8 x i64> %x, %s
  ret <8 x i64> %r
}

define <8 x i64> @select_sdiv_neutral_constant_v8i64(<8 x i1> %b, <8 x i64> %x, <8 x i64> %y) {
; AVX2-LABEL: select_sdiv_neutral_constant_v8i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} xmm5 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX2-NEXT:    vpslld $31, %xmm5, %xmm5
; AVX2-NEXT:    vpmovsxdq %xmm5, %ymm5
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [1,1,1,1]
; AVX2-NEXT:    vblendvpd %ymm5, %ymm6, %ymm3, %ymm5
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vblendvpd %ymm0, %ymm6, %ymm4, %ymm3
; AVX2-NEXT:    vextractf128 $1, %ymm5, %xmm0
; AVX2-NEXT:    vpextrq $1, %xmm0, %rcx
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm4
; AVX2-NEXT:    vpextrq $1, %xmm4, %rax
; AVX2-NEXT:    cqto
; AVX2-NEXT:    idivq %rcx
; AVX2-NEXT:    vmovq %rax, %xmm6
; AVX2-NEXT:    vmovq %xmm0, %rcx
; AVX2-NEXT:    vmovq %xmm4, %rax
; AVX2-NEXT:    cqto
; AVX2-NEXT:    idivq %rcx
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm6[0]
; AVX2-NEXT:    vpextrq $1, %xmm5, %rcx
; AVX2-NEXT:    vpextrq $1, %xmm1, %rax
; AVX2-NEXT:    cqto
; AVX2-NEXT:    idivq %rcx
; AVX2-NEXT:    vmovq %rax, %xmm4
; AVX2-NEXT:    vmovq %xmm5, %rcx
; AVX2-NEXT:    vmovq %xmm1, %rax
; AVX2-NEXT:    cqto
; AVX2-NEXT:    idivq %rcx
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm4[0]
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-NEXT:    vextractf128 $1, %ymm3, %xmm1
; AVX2-NEXT:    vpextrq $1, %xmm1, %rcx
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm4
; AVX2-NEXT:    vpextrq $1, %xmm4, %rax
; AVX2-NEXT:    cqto
; AVX2-NEXT:    idivq %rcx
; AVX2-NEXT:    vmovq %rax, %xmm5
; AVX2-NEXT:    vmovq %xmm1, %rcx
; AVX2-NEXT:    vmovq %xmm4, %rax
; AVX2-NEXT:    cqto
; AVX2-NEXT:    idivq %rcx
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm5[0]
; AVX2-NEXT:    vpextrq $1, %xmm3, %rcx
; AVX2-NEXT:    vpextrq $1, %xmm2, %rax
; AVX2-NEXT:    cqto
; AVX2-NEXT:    idivq %rcx
; AVX2-NEXT:    vmovq %rax, %xmm4
; AVX2-NEXT:    vmovq %xmm3, %rcx
; AVX2-NEXT:    vmovq %xmm2, %rax
; AVX2-NEXT:    cqto
; AVX2-NEXT:    idivq %rcx
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm4[0]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: select_sdiv_neutral_constant_v8i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpbroadcastq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2 {%k1}
; AVX512F-NEXT:    vextracti32x4 $3, %zmm2, %xmm0
; AVX512F-NEXT:    vpextrq $1, %xmm0, %rcx
; AVX512F-NEXT:    vextracti32x4 $3, %zmm1, %xmm3
; AVX512F-NEXT:    vpextrq $1, %xmm3, %rax
; AVX512F-NEXT:    cqto
; AVX512F-NEXT:    idivq %rcx
; AVX512F-NEXT:    vmovq %rax, %xmm4
; AVX512F-NEXT:    vmovq %xmm0, %rcx
; AVX512F-NEXT:    vmovq %xmm3, %rax
; AVX512F-NEXT:    cqto
; AVX512F-NEXT:    idivq %rcx
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm4[0]
; AVX512F-NEXT:    vextracti32x4 $2, %zmm2, %xmm3
; AVX512F-NEXT:    vpextrq $1, %xmm3, %rcx
; AVX512F-NEXT:    vextracti32x4 $2, %zmm1, %xmm4
; AVX512F-NEXT:    vpextrq $1, %xmm4, %rax
; AVX512F-NEXT:    cqto
; AVX512F-NEXT:    idivq %rcx
; AVX512F-NEXT:    vmovq %rax, %xmm5
; AVX512F-NEXT:    vmovq %xmm3, %rcx
; AVX512F-NEXT:    vmovq %xmm4, %rax
; AVX512F-NEXT:    cqto
; AVX512F-NEXT:    idivq %rcx
; AVX512F-NEXT:    vmovq %rax, %xmm3
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm5[0]
; AVX512F-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512F-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512F-NEXT:    vpextrq $1, %xmm3, %rcx
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm4
; AVX512F-NEXT:    vpextrq $1, %xmm4, %rax
; AVX512F-NEXT:    cqto
; AVX512F-NEXT:    idivq %rcx
; AVX512F-NEXT:    vmovq %rax, %xmm5
; AVX512F-NEXT:    vmovq %xmm3, %rcx
; AVX512F-NEXT:    vmovq %xmm4, %rax
; AVX512F-NEXT:    cqto
; AVX512F-NEXT:    idivq %rcx
; AVX512F-NEXT:    vmovq %rax, %xmm3
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm5[0]
; AVX512F-NEXT:    vpextrq $1, %xmm2, %rcx
; AVX512F-NEXT:    vpextrq $1, %xmm1, %rax
; AVX512F-NEXT:    cqto
; AVX512F-NEXT:    idivq %rcx
; AVX512F-NEXT:    vmovq %rax, %xmm4
; AVX512F-NEXT:    vmovq %xmm2, %rcx
; AVX512F-NEXT:    vmovq %xmm1, %rax
; AVX512F-NEXT:    cqto
; AVX512F-NEXT:    idivq %rcx
; AVX512F-NEXT:    vmovq %rax, %xmm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm4[0]
; AVX512F-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: select_sdiv_neutral_constant_v8i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vpbroadcastq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2 {%k1}
; AVX512VL-NEXT:    vextracti32x4 $3, %zmm2, %xmm0
; AVX512VL-NEXT:    vpextrq $1, %xmm0, %rcx
; AVX512VL-NEXT:    vextracti32x4 $3, %zmm1, %xmm3
; AVX512VL-NEXT:    vpextrq $1, %xmm3, %rax
; AVX512VL-NEXT:    cqto
; AVX512VL-NEXT:    idivq %rcx
; AVX512VL-NEXT:    vmovq %rax, %xmm4
; AVX512VL-NEXT:    vmovq %xmm0, %rcx
; AVX512VL-NEXT:    vmovq %xmm3, %rax
; AVX512VL-NEXT:    cqto
; AVX512VL-NEXT:    idivq %rcx
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm4[0]
; AVX512VL-NEXT:    vextracti32x4 $2, %zmm2, %xmm3
; AVX512VL-NEXT:    vpextrq $1, %xmm3, %rcx
; AVX512VL-NEXT:    vextracti32x4 $2, %zmm1, %xmm4
; AVX512VL-NEXT:    vpextrq $1, %xmm4, %rax
; AVX512VL-NEXT:    cqto
; AVX512VL-NEXT:    idivq %rcx
; AVX512VL-NEXT:    vmovq %rax, %xmm5
; AVX512VL-NEXT:    vmovq %xmm3, %rcx
; AVX512VL-NEXT:    vmovq %xmm4, %rax
; AVX512VL-NEXT:    cqto
; AVX512VL-NEXT:    idivq %rcx
; AVX512VL-NEXT:    vmovq %rax, %xmm3
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm5[0]
; AVX512VL-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512VL-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512VL-NEXT:    vpextrq $1, %xmm3, %rcx
; AVX512VL-NEXT:    vextracti128 $1, %ymm1, %xmm4
; AVX512VL-NEXT:    vpextrq $1, %xmm4, %rax
; AVX512VL-NEXT:    cqto
; AVX512VL-NEXT:    idivq %rcx
; AVX512VL-NEXT:    vmovq %rax, %xmm5
; AVX512VL-NEXT:    vmovq %xmm3, %rcx
; AVX512VL-NEXT:    vmovq %xmm4, %rax
; AVX512VL-NEXT:    cqto
; AVX512VL-NEXT:    idivq %rcx
; AVX512VL-NEXT:    vmovq %rax, %xmm3
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm5[0]
; AVX512VL-NEXT:    vpextrq $1, %xmm2, %rcx
; AVX512VL-NEXT:    vpextrq $1, %xmm1, %rax
; AVX512VL-NEXT:    cqto
; AVX512VL-NEXT:    idivq %rcx
; AVX512VL-NEXT:    vmovq %rax, %xmm4
; AVX512VL-NEXT:    vmovq %xmm2, %rcx
; AVX512VL-NEXT:    vmovq %xmm1, %rax
; AVX512VL-NEXT:    cqto
; AVX512VL-NEXT:    idivq %rcx
; AVX512VL-NEXT:    vmovq %rax, %xmm1
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm4[0]
; AVX512VL-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512VL-NEXT:    retq
  %sel = select <8 x i1> %b, <8 x i64> <i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1>, <8 x i64> %y
  %r = sdiv <8 x i64> %x, %sel
  ret <8 x i64> %r
}
