
#ifndef _DPU_ANT_MESSAGES
#define _DPU_ANT_MESSAGES

#define C_MAX_ANT_DATA 10


typedef enum
{
  rNUL,rA,rB,rC,rD,rE,rF,rG,rH,rJ,rK,
  rL,rM,rN,rS,rT,rU,rV,rX,rY,rZ,
  rAA,rAB,rAC,rAD,rAE,rAF,rAG,rAH,rAJ,rAK,rAL
}T_REV_STATE;

typedef struct
{
  int antennaVer;
  int serialNo;
  T_REV_STATE revState;
}M_ANTENNA_IDENT;


typedef struct
{
}M_REQ_ANTENNA_IDENT;

typedef struct t_ant_ori_element_type {
  double azim;
  double tilt;
  double roll;
} t_ant_ori_element;

typedef struct {
  int hour;
  int min;
  int sec;
  int hundred_sec;
} t_ins_attitude_time;

typedef struct {
  t_ant_ori_element     ant_ori;
  t_ins_attitude_time   time;
} m_ins_attitude_data;






typedef enum {
  ant_ttu_inactive = 0
} m_ant_ttu_inactive;

typedef enum {
  ant_service_position = 0
} m_ant_service_position;

typedef enum {
  ant_not_in_ftp = 0,
  ant_in_ftp
} m_ant_in_ftp;

typedef enum {
  ant_not_in_lock = 0,
  ant_in_lock
} m_ant_in_lock;

typedef enum {
  ant_not_in_opz = 0,
  ant_in_opz
} m_ant_in_opz;

typedef enum {
  ant_not_in_new_ori = 0,
  ant_in_new_ori
} m_ant_in_new_ori;

typedef struct {
  bool ant_in_orp;
  double orp_azim;
  double orp_tilt;
} m_ant_in_orp;

typedef struct {
  bool  measured_ant_ori_table[C_MAX_ANT_DATA];
  double             time_meas_points[C_MAX_ANT_DATA];
} m_ant_ori;

typedef struct {
  double Min_Elevation; // --INS ori in mradians
  double Max_Elevation; // --INS ori in mradians
  double Min_Azimuth;   // --INS ori in mradians
  double Max_Azimuth;   // --INS ori in mradians
  double Min_Roll;      // --INS ori in mradians
  double Max_Roll;      // --INS ori in mradians
  bool Valid; // Set to false in DBC before limits are received from ttu_ins
} m_ant_ori_limits;

typedef struct {
  double        ant_time;
  double        ant_ori;
  bool          major_change;
} m_ant_ori_chg;


typedef struct m_ant_ORP_ori_type {
  double azim;
  double tilt;           //  Unit radians  -C_PI_HALF..C_PI_HALF
} m_ant_ORP_ori;

typedef struct m_ant_temp_type {
  double temp;
} m_ant_temp;

typedef struct {
} m_req_ant_orp_ori;

typedef struct {
  bool req_ant_ori_chg;
  bool req_ant_status;
  bool req_ant_temp;
  bool req_eres_values;
} m_req_ant_status;

typedef struct {
} m_req_ant_temp;

typedef struct {
} m_req_ant_ori_chg;


typedef enum {
  in_lock = 0,
  in_ftp,
  raising_or_folding,
  cs_panel_active,
  in_opz,
  in_orp,
  turning,
  turning_aborted,
  in_new_ori,
  in_service_position,
  in_ttu_inactive
} t_position_status;


typedef struct {
  t_position_status position_status;
  bool         position_error;
} m_ant_position_status;


typedef struct {
} m_req_ant_position_status;

typedef struct {
  double new_azim;
  double new_tilt;
  double new_roll;
} m_req_ant_to_new_ori;

typedef struct {
  double orp_azim;
  double orp_tilt;
} m_req_ant_to_orp;

typedef struct {
  bool active;
} m_cs_active;

typedef struct {
} m_ant_turning_aborted;


typedef struct
{
  int SysProcId;
  int TaskId;
  int InetAddr;
  int MsgId;
  int MsgLength;
} T_MsgInfo;


typedef enum {none,
              mortar,
              tube,
              rocket,
              small_arms,
              manual } t_weapon_class;

typedef enum {no_caliber,
	      light,
	      heavy} t_caliber_tag;


typedef struct {
  t_weapon_class weapon_class;
  t_caliber_tag  caliber;
  int            confidence;
} t_weapon_type;


#endif /* _DPU_ANT_MESSAGES */
