
#include <glib.h>
#include "libindicate/listener.h"

static gboolean passed = TRUE;
static GMainLoop * mainloop = NULL;
static gint tests = 0;

static void
string_cb (IndicateListener * listener, IndicateListenerServer * server, IndicateListenerIndicator * indicator, gchar * property, const gchar * propertydata, gpointer data)
{
	g_debug("Got string property '%s' value '%s'", property, propertydata);
	if (g_strcmp0(propertydata, (gchar *)data)) {
		passed = FALSE;
		g_debug("\tExpecting '%s'", (gchar *)data);
	}
	tests--;
	if (tests == 0) {
		g_main_loop_quit(mainloop);
	}
	return;
}

static void
int_cb (IndicateListener * listener, IndicateListenerServer * server, IndicateListenerIndicator * indicator, gchar * property, gint propertydata, gpointer data)
{
	g_debug("Got int property '%s' value '%d'", property, propertydata);
	if (propertydata != GPOINTER_TO_INT(data)) {
		passed = FALSE;
		g_debug("\tExpecting '%d'", GPOINTER_TO_INT(data));
	}
	tests--;
	if (tests == 0) {
		g_main_loop_quit(mainloop);
	}
	return;
}

static void
bool_cb (IndicateListener * listener, IndicateListenerServer * server, IndicateListenerIndicator * indicator, gchar * property, gboolean propertydata, gpointer data)
{
	g_debug("Got bool property '%s' value '%d'", property, propertydata);
	if (propertydata != GPOINTER_TO_INT(data)) {
		passed = FALSE;
		g_debug("\tExpecting '%d'", GPOINTER_TO_INT(data));
	}
	tests--;
	if (tests == 0) {
		g_main_loop_quit(mainloop);
	}
	return;
}

static void
indicator_added (IndicateListener * listener, IndicateListenerServer * server, IndicateListenerIndicator * indicator, gpointer data)
{
	g_debug("Indicator Added:   %s %d", INDICATE_LISTENER_SERVER_DBUS_NAME(server), indicate_listener_indicator_get_id(indicator));

	indicate_listener_get_property(listener, server, indicator, "string-value", string_cb, "my-value");
	tests++;
	indicate_listener_get_property_int(listener, server, indicator, "int-value", int_cb, GINT_TO_POINTER(42));
	tests++;
	indicate_listener_get_property_bool(listener, server, indicator, "bool-value", bool_cb, GINT_TO_POINTER(TRUE));
	tests++;
	indicate_listener_get_property_bool(listener, server, indicator, "no-bool-value", bool_cb, GINT_TO_POINTER(FALSE));
	tests++;

	return;
}

static gboolean
failed_cb (gpointer data)
{
	g_debug("Failed to get a server in 5 seconds.");
	passed = FALSE;
	g_main_loop_quit(mainloop);
	return FALSE;
}

int
main (int argc, char * argv)
{
	g_type_init();

	IndicateListener * listener = indicate_listener_ref_default();

	g_signal_connect(listener, INDICATE_LISTENER_SIGNAL_INDICATOR_ADDED, G_CALLBACK(indicator_added), NULL);

	g_timeout_add_seconds(5, failed_cb, NULL);

	mainloop = g_main_loop_new(NULL, FALSE);
	g_main_loop_run(mainloop);

	return !passed;
}
