/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.lock;

import java.util.concurrent.locks.Lock;

/**
 * Simple lock that does not differentiate read and write lock. All locks are obtained FIFO.
 * This class is used as a delegate for LockStrategy
 * is transaction isolation level.
 *
 * @author <a href="mailto:bwang00@sourceforge.net">Ben Wang</a> July 15, 2003
 * @version $Revision: 5665 $
 */
public class SimpleLock
{
   //    Log log=LogFactory.getLog(getClass());
   private final SemaphoreLock sem_;

   public SimpleLock()
   {
      sem_ = new SemaphoreLock(1);
   }

   /**
    * @see org.jboss.cache.lock.LockStrategy#readLock()
    */
   public Lock readLock()
   {
      return sem_;
   }

   /**
    * @see org.jboss.cache.lock.LockStrategy#upgradeLockAttempt(long)
    */
   public Lock upgradeLockAttempt(long msecs)
   {
      return sem_;
   }

   /**
    * @see org.jboss.cache.lock.LockStrategy#writeLock()
    */
   public Lock writeLock()
   {
      return sem_;
   }
}
