/* ----- decode/761xint32, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_761xint32_checksums[] = {
  "c44672011469bac0b95caf7c0a019fdbbb6e3437688ab8332bfa9c3edeec0596",
  "9e000f8f58d6ec16a4dd0b362923affd79dc56ed6e049b457d851a56f9206551",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_761xint32_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_761xint32_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_761xint32_ITEMBYTES

static void *storage_decode_761xint32_x;
static unsigned char *test_decode_761xint32_x;
static void *storage_decode_761xint32_s;
static unsigned char *test_decode_761xint32_s;
static void *storage_decode_761xint32_x2;
static unsigned char *test_decode_761xint32_x2;
static void *storage_decode_761xint32_s2;
static unsigned char *test_decode_761xint32_s2;

#define precomputed_decode_761xint32_NUM 4

static const uint32_t precomputed_decode_761xint32_x[precomputed_decode_761xint32_NUM][crypto_decode_ITEMS] = {
  {590432927,161948024,2545355283,3629069256,1777008730,1900035730,1037119783,1359481818,1056690203,2113017457,3913137535,1241751237,2965953726,1655433506,1130093746,1383972463,326159109,867189002,337008865,589176544,775079623,3859648075,2841504127,3131469193,4053862696,2136551252,4078319236,3132863148,374901787,2148883121,2712217277,3336738460,2870946145,224976484,172743031,3143924628,1636567238,3521900627,3197584577,3005789098,1613622940,4263637947,1529388051,2026887717,972911095,1676918996,2771167736,3478609275,838716137,2480154398,62059327,106977777,126634852,2963035622,1726051210,4269123905,3607782225,4250546239,1476984409,353343601,1145308762,1749312962,606060957,2179039433,3339890177,1963538970,3032441618,4009271832,450986084,2163723146,1882919658,1987280015,4193443994,4098625435,3548875107,1856154682,1442883769,3754745450,1415345895,3627536700,4190352699,1192490074,2379148467,1983364530,3785468867,2145441895,3053677807,2550969239,2904686205,4241549772,1523592294,2537070247,3444381412,2257234222,4145019915,1775641669,252153421,3141289584,193501986,1858102389,541334141,4250302776,411678321,4255686022,1611687330,2786230504,3143543249,3739923395,3074514207,3336530078,1909152749,1825560854,1886111002,3612170270,2684044700,1019442990,2287541572,3186664925,978341127,1436249738,343290163,1408118828,2366405077,1535386921,533326601,527001216,928381126,2387285197,906382390,703724276,3894386194,3049492766,1795909206,3417867134,58812672,3810725553,2663099205,1681957586,3834915372,1710907774,1590615558,3634076706,3324296916,3292411328,4026986011,1940051015,3116033310,1375562301,3790630943,3907431735,1731667722,4048133851,2179526236,2199160280,3460250022,764906511,307632753,3672368343,1887863976,494273563,1577330543,3008802294,1352016660,892299480,4006339822,2290509473,4022271435,1990333295,3217229393,1612960252,3846164321,4016611668,3769523754,1137762204,2750023394,3161134718,3383091303,842060450,322980468,1824748605,373714940,1446860254,95618804,3330481888,116440670,1711818967,2930712698,1154756465,1532994559,2263587215,3848932234,1291892776,2002863534,3830051011,1123898763,2575559437,1417347405,3619226584,1144608335,1087436339,544566361,1644454377,2512068741,2887155541,1659649401,1555788905,3752245308,1172071481,1776204440,3770363134,1100621304,686410109,950123689,3462268276,516897517,1956428975,702795132,994404278,3096917543,51762753,1627686350,3517653902,719372139,1704264571,1153089081,1505102329,696200069,1384035573,3363356389,2239423285,2869857606,2339142348,2403936489,2216565668,2153578302,523153065,2453071075,3226975380,102878671,758779684,4005765506,2578758909,2580931660,1415313701,1656031971,1479789127,3374729398,3755419723,3022333455,1117721081,1578870257,809430470,3467146712,2965837411,4188044293,2561909917,1943415588,1740278026,3072965476,1172681000,657679127,2651923060,187229211,3390590297,1160813170,1839573277,4033300832,1882659158,69880479,3788733238,823306728,2566249029,2931007457,1625099411,1361350829,54860478,3307819580,1966435391,2707340459,1648686468,1954737646,3653221224,2395403245,4133538329,889515259,3423432404,3789628553,430237923,2941966664,1163263806,2022575,2490042454,1840329157,1245235169,2295970348,3390205083,612171040,361924985,545933929,2759273818,2244921777,1389458968,388444387,2217914823,562239857,2820722557,2802908733,1643875929,2790473556,837054910,2244399207,2052351063,1203332659,2594567158,3115124861,72918335,1849322676,2338679224,3147516260,2062745595,2352819045,498298794,990718149,75146734,1925848441,2671236329,134696429,2323799748,1854023580,856415489,7289060,2810492235,3817790308,1506748767,1533881749,1256709972,1225570442,3203490311,4263986600,4181975671,3807989959,1257291288,3969147048,1630350103,2083415327,242440906,3829142867,658000001,2703085529,3917959804,3385674607,2474785619,2666764613,2067165688,2967387575,1214322718,1421419755,2949857815,3144039683,2030158807,2819688948,3541952186,4048982049,384866328,1713638836,2332945697,3166259322,1386339364,1106391724,3553468457,2070875012,757195042,1041412246,3240003597,3113101756,694130853,1348670148,3240212529,1051568416,4027046777,523814577,2586235133,3379646507,1664596733,616301009,3215491073,1729274537,3761271314,983897958,3609988106,3080960479,1077507162,1750539354,569156915,3130721115,1303808435,3859882399,3437963897,4271066816,3229105587,941820046,2340442022,2686097338,3505779817,2599005141,1801314229,1129646843,3729177989,2494648046,584173932,2504228592,3585305679,826142134,3872493675,732780013,882494337,464519831,177531070,3492798994,3946211851,4290575526,51445734,3481385283,1747558749,556899487,2868094604,2323783289,579019445,2682907199,558117702,3455443241,3353541517,3693196827,1760246348,3989921770,2322474794,3667378932,4247407813,4278028352,1839416128,3807870347,4052480455,913200386,238813075,3298570698,3637590449,2152131004,3574004809,4052593100,3705070054,3307008311,2326264337,2280590464,375757286,2496116428,1203631486,3741120186,2553261985,772241371,1530409847,414648222,1917699820,246934495,2342058094,3998504095,3403837830,3106369925,2594680452,3646648014,4162623655,555477387,2478024549,2464624172,4083863167,2659949957,3070208910,3065647124,1499506703,2127624029,688509516,895792243,1025829920,1202040188,1045275351,346276780,1955009384,590275444,1033869110,1261844647,1419219993,1657444586,2910303114,1014046355,914807587,4182863018,3532558081,2233354836,766286141,974722265,1871581290,2104978138,3456439595,3001103550,1711463419,2486169132,2615149856,1035185619,2302791800,885957193,1041719453,2742898757,590726399,1757986908,3220599416,746614197,301438377,2613313810,3703862625,4070656605,634398198,552981092,1315947208,1697911034,4210004329,726528101,1186092249,841950173,4265203713,406571018,1431388251,385337060,2281565491,2556854317,2396252769,2065202201,625656764,3825018433,936491536,3828088707,2592738885,3734216547,3395694112,748120706,4253493245,229097171,1287608789,931959995,3529808577,4162868549,1324709398,2441114154,2823637143,244371637,34688063,3192352792,3672006206,3273248099,1913551500,2406131555,3570686243,351504393,2524067274,4020252147,880680679,2768111522,36412229,2727448789,1051622382,3572197435,79102607,3217566527,1190627317,1342364035,744087429,3791500202,3330113470,2919538247,3451106699,629385746,1916241465,33502328,472823729,2536244402,2430353096,980688406,3347261549,2032577458,3467050249,1356683500,989026777,1076873650,2300369514,1212519249,62690530,826646009,3952288904,1173897247,3516273931,10852368,2518936828,660032404,104716741,1251476361,3656293191,2009050785,1768514869,2971775014,1767407318,2585582449,2824885065,2720887510,1935985901,476157745,469636741,4106268447,2937611884,814380266,3529185633,2268294231,387635238,518318962,1854445023,659631850,3793431819,1775466454,1401718155,594087933,903917305,1579811314,740770043,2614981066,700121537,4251075471,819513097,3557664894,2365498889,28831503,18364892,4160195454,296537284,2855881801,720586344,16148208,53820138,3982803543,1038757224,2881950568,2161256365,1165450463,4000571875,677317858,1981316198,3693797326,1614356057,1663108575,1406732941,830170228,276468014,1061519185,3031700643,1948715908,698424459,3465336670,2860394561,3966966723,2057409386,38603811,517583154,3894996370,553206982,3058790264,3349008677,1928316912,3843919034,3435916824,705772814,627396748,1896280213,1801023215,3543749545,1227283217,3622124863,1892835137,2601107723,1258067126,2686355887,946842500,4235149919,239854895,1945194045,2997275396,3402696928,1063059574,3891746446,2388422467,1455831581,471439939,1357512942,3454534699,773688997,3769239202,3909278857,2465287009,2916603763,2161795285,2521137443,2505958892,1700861051,2284321539,3389250832,2494769609,345107189,1180455993,3421748549,2760202015,1746789438,316759457,738563238,1380250052,581500354,4189826855,3568021830,4148648007,2009101893,3086060439,1325776212,1466690780,3616477845,3398177267,2855043554,3069067815,3607001288,2373747375,2921836081,1088750551,3417622496,3877174511,263212225,2827743139,899978221,3764967047,1515907538,3695814977,674716771,142580724,388570703,3248214926,3312675906,840230655,1006254227,2203028493,692523383,3078926049,394220546,2812347387,324857540,994230637,3008929736,3420629827,2926370587,3456585912},
  {837711435,2195098881,1972469638,2945802036,2874088094,2899005424,3936748048,1136569473,2445864271,2049583813,3347344778,3751693460,3686962313,3361368611,3461964294,278990296,2852159544,902469286,2956604587,2947506187,4170710017,755592822,1222500766,2311699767,3981008313,4159893251,3358932009,1212212485,1293556700,258586060,2373154584,3304411607,1353090589,1390154664,1850848203,1350560439,1710736643,4179964328,2451216260,920519205,2833270426,3995695897,479295996,231735141,2376365499,2015157233,937660382,3300216962,2873514879,2004065903,847819192,3229444211,2094503432,2112008093,4287318185,3411618306,1899172219,3874270921,58486904,1289605579,570103043,2906616114,3966262615,4021973517,3111772922,350519282,2549815580,1811394606,236870803,690502433,2340758666,1526726679,507271841,4040293543,1051329555,3234488633,3606011802,1463108725,284185602,632569962,3110067136,1367949528,452067898,3494413252,2218420542,3907328281,2837492027,2993290980,919312095,1319814157,2539916581,1604715219,4082687938,1610734969,821250437,1222515214,2301503637,1195523211,2225237513,4293978190,3504501489,4278368667,3395823773,809296599,77699733,3606404350,3163671171,496701790,3901853820,3372304442,3552289346,2681572481,1884220728,129969602,3960699809,1219601256,2081990308,4165561571,2828615967,80705943,273084962,1409311634,3699925533,3074695756,2294321116,3666757375,3172537201,3277933756,1261224866,493982137,3031490317,2225961524,1232639418,2203038590,1203536185,332892041,2526309432,529687821,627224673,1483202889,1024736011,522740492,2292758585,2659877949,3320008497,2131858609,3471296184,2220478662,3727745599,3591805920,410927534,1760641616,1933484291,2976774006,1011206929,962524671,3321752795,3149684935,1253412681,1121714870,1131382397,884335434,1112848955,1950417287,1257670257,3033946946,889531080,2272273008,3706748974,1993112330,879635164,1594746952,3038558979,3255997691,4246103800,1921928399,3085544956,349634178,4147850882,1231505397,4064392095,3311744987,2802079490,1902758551,2862352868,1559355485,1465123872,635212303,954094746,1504774105,3530301377,3349950035,1887133496,4186420813,4003613508,2175426654,1625780199,2041979840,843605692,3052569735,4243198083,4195538616,2643696846,3659639800,2223150714,2439940141,1899156582,2952064487,3435020815,4284658208,761428536,3068658760,1013391971,2851465318,2573190684,2341289073,3058694852,3775291429,4186908920,2641067984,4197790706,1218556688,1961454119,2950105622,2661758099,3197340041,3192660843,2083571925,1284240057,883632913,1411400190,1213418539,3469718328,3613880624,2749776903,1859939118,281640181,2979466768,3221433591,3241374861,2329841699,1146033712,3803768477,1914690709,2316695766,2333071786,2951779686,2759951416,4291363211,3784646446,739604578,492435451,4269240852,4223324401,3517355870,1450678658,719463233,3606037921,2519832738,2140847029,363481307,2316433065,2398697327,624237049,293437456,2529319586,3856484066,579105434,2569994636,2268988873,4207568371,3652961148,98852495,1107020182,3727329932,2520725071,1358671179,526226281,2876022373,2602802583,756059868,3823831381,701873628,3635599151,4041131097,756926204,3090732680,2469694104,2430344160,2480795572,2989890835,4076741821,754768596,1209216524,900532964,784205824,2412359075,3111912465,3859206458,3385175935,695069565,526740325,4100115973,2990054507,3178571989,4120079665,3937977698,1379434837,945907908,3265940353,48112405,2551842969,2692065708,2469517688,1432877074,4025152463,2580496531,1230684118,976640130,2129982401,1423142990,3282471974,3002459603,2056192757,1382141784,913375333,1633904996,572094603,2155140023,1573925503,3229395122,3340578589,2746936338,2264379715,1226720677,3326173995,927032090,56060772,3026486801,3294508048,490811061,1786877298,2766150814,3063971793,4174773354,3237526695,2670023492,1473498050,3761821016,3875423197,562293060,1570006732,1510445583,2242990127,4292970070,2680955382,841152363,1040194667,2633437628,2441555979,18863438,939910223,3044466289,3949083742,2082007377,1188313906,3100013632,959547165,3247215424,3049340170,881379636,2882428682,3954509390,22941242,1829305835,3121228804,3019513682,2331128429,239443050,3307424103,115347413,3030191585,1589362517,2558540621,534402136,3809225548,454436657,1168610247,3483878009,2694721128,3923763679,195606156,823610771,781345658,41173306,2115891817,2170483059,3682310690,2209573505,1656049189,1347177146,2098406888,4256084268,3543120094,1507606972,2583979160,1127638877,2496620932,917764589,3690028632,3966374807,2108480033,3900323752,3278284639,3253784273,3885159581,2450289881,2139923473,1011088366,3326171287,4205599290,2044808481,3626206257,1249302202,3502017708,2211123201,2495405337,238674077,226699940,4186276994,1619270350,4068640617,2841366962,2755085910,1356560682,3957446416,3269673665,92551485,1865652496,3766311252,206598300,3271547717,3112016582,1074971647,649307610,4064947354,1626481002,222378201,2618851954,1685639619,461425089,1978631094,620705601,4048740257,1086095645,2835037259,1810291689,47335478,2522047322,257479162,938814003,1129478992,1806087137,3271962902,3571319046,1298527586,1335300414,4038404401,2420055080,3488669761,2244170212,242783426,1679094683,3997604241,3508258286,275545761,2934851841,2209182767,4113104494,4014879284,2632679732,2818726463,546157385,686613666,3832897321,1466095606,1212530862,466784676,3018492542,1887854556,2114235417,1867394893,1444093347,256584843,3501496273,2060310792,2093593058,96890872,1708280641,4224733730,3742475526,1878540135,2165184100,422300357,2256728621,1380622810,1624801331,2109114475,851312517,3655950926,996435388,556224725,2752760885,1019002990,2876443525,2363426532,648959747,270263535,3281922624,2315549649,3750902956,3009600508,2924960444,1764254800,2580054674,1360154888,3402636884,862495440,478547185,3684586057,3189922316,3520539936,4102294831,3862028207,977992219,1876304203,1146069348,3846447844,3356062902,3694402678,3987534406,3121322552,2048133188,3341501382,3120943389,3848805106,414137902,3697247641,1933807466,3960118995,3521325001,195347102,3284454448,1237302826,1305491249,4118639358,421881408,365612460,3528537775,511947973,1269876775,668903208,2580292775,3374914128,2065044890,2422174106,3085903107,2899106126,4268666453,908597289,3442883881,506205184,2114168191,3669279476,698822824,1407405237,1886827798,98470934,1200911593,2624638031,812065940,452157128,1956076236,31249171,2020085481,798979928,872911293,2034467102,3309782104,1426065676,1911273546,3887006864,2250350259,3964744398,2898268535,623143075,2575347753,2732367932,3114680244,4105579512,699984022,2204640571,91376576,3519180154,2981377387,2674775152,4000567837,4011986837,2394896162,2195866530,3107409415,1417832216,3648284891,3129941992,1768204966,2265927290,3228061766,1905604297,694432492,1020929192,2193736676,3508551009,3547504872,963763397,1909420247,3775786915,1104869119,719653540,341941250,1371635594,1192689019,280408179,890988217,4174238687,2759581089,1825571609,4201336356,4011711355,1586430646,698928408,3013168841,1964356867,2795419403,2178334110,3353565259,2869090072,1160425063,1722810356,1158398981,3121476570,1226743223,3397107049,37269795,1050578392,636226938,3638170917,2935231983,3306219886,1024839833,1989678613,369113191,1325668447,4055395460,3536844887,4252811606,3152093481,35162194,3796329169,2660996080,2409100395,3075237887,2219426452,1323717896,2521657948,3819579019,1851195171,2636590096,1668534103,122581138,4207606851,2453952449,4194911933,1473671996,1935472973,1802342635,2144191743,3977788979,2061017458,1876573546,3151725562,3628414440,3631570460,1032288323,2550702852,2283104356,3673128498,1685794350,1767727931,843329308,674567576,2679930925,4207220769,3578331147,3333237275,3786650766,3518656471,1185552368,3314043502,776146383,208161638,600190469,14162702,1388498119,3504282905,1393870820,1550251097,2016394331,2443046389,1222785692,3067466402,2697970102,1109937818,2756512949,554188155,3914901256,2257363097,3773484148,3482831174,190797957,2243172836,1784166350,2834138113,3609241669,4161011605,1108524132,3764517954,1953482202,181599728,3896048423,3997629195,3808800706,2907901109,3142830732,2184988254,4240806438,2753860357,1634484877,4005702336,2942420982,3267364676,1714610665,2379017308,1959443917,2423642398,3350062114,60649697,915255827,407209861,2068204558,1621480349,1698841737},
  {3069227513,3087035690,2206017245,537950066,322743116,2584928328,3681955344,2693615033,945724485,281743886,1557846836,149164174,1378588841,1960965272,1216078141,985662440,3222177264,340400220,1156501625,2840892356,4234055632,516168025,1552358220,102747554,506002214,200102339,1022118075,980716057,2177223556,596949411,3902581728,1275090699,1458908716,3221976395,850870745,2782185490,3404154303,2671571246,3478785669,1925749970,3942454989,4037960050,394794080,1138599490,3259026052,2011137089,3772484442,559960819,58348421,3830851241,481959630,3639121289,3440492806,3037125170,1911201088,1325519840,897530643,4180842374,3549554996,3102445507,178333338,2516516980,561173591,3581461212,689677273,3881514902,3303902000,3251095967,2837417513,1965713586,124952947,1838767928,2821562837,91905950,2662302176,531167187,3999240540,4173203209,697295989,690078870,3188008905,2158434573,1677534786,3333234526,1007319286,861965163,2590038189,1424697653,1784637726,3271579376,3732332327,935014780,212017101,327761192,546522733,399012403,2006923894,1750385175,2570858779,123124556,376377614,339489863,4087175871,3178708752,1386025769,4011698299,1166474312,3334335113,2754710050,3771535168,27167665,1436915240,4200916894,993223398,2293065406,1300000736,1003366480,4133144497,3767783870,429710720,2038879171,2392434270,3072270978,2314739356,2922232064,924786738,2106403828,3635302583,2009809937,1852544333,3998274183,1932120765,1185049116,2219327159,1618295870,4028673860,1184564083,248999102,1125915330,1792892439,117835205,1184976043,3343665360,3086466338,3056570673,3461424716,3245519508,1702099071,3845045854,339647697,2675336990,3545777406,1844073819,1228358868,3243084736,1778685392,975888706,1794138407,235719173,185964970,3890766982,4227845218,3115639403,607439926,2162934142,1072854714,298158207,505242354,1688769023,1482605163,1175068903,4002218875,1261219946,1420552230,2724477982,4047723942,189501089,3908438289,2736207149,377777286,1572896044,153451547,3371368512,1934165582,2479476704,3740985139,1595277944,2614622912,1440854494,2457930193,3321450401,1485668146,1341970995,2737222141,2111169034,3821807976,1192084015,80849096,3960062066,2278846881,1461719265,2485201046,3213451669,2203392686,1215139731,4167386395,859019927,3618167208,1636911266,2200791366,548609863,1594364840,4211446076,1599808385,2532453724,3159011850,1010252016,544855641,2855904079,1993371266,2014966839,3734815975,4182598046,663629313,708058438,646992556,1199548962,3109515469,3645626615,2511835144,286281833,2562934612,1893317326,368221940,2427390033,1426251722,2529332628,4139082291,1975725388,3413209591,3530063408,3655424197,2143015228,2461167503,333557526,498603806,515621502,2112161906,3294641926,780714541,162058362,299139456,1530170772,1952437097,46814978,1665086635,4089603010,1909166234,661372737,2440096955,1188926893,4027675045,55587875,58913061,3924397555,4271163554,589698143,3296112964,2976515241,2702862793,1941232503,1468326435,1304806951,3106021124,3429230193,2381263404,3016924514,4139706544,973136653,523940004,3962852859,806824532,640346191,1077480086,3903684681,3730769008,2992790709,1112814669,3745998052,4224895918,1494674873,1457852847,4236442483,3014883029,262109214,206998575,2891899706,2483102975,505371091,2817236339,1135187304,258726610,2962720420,1216976699,3097914980,2115726412,3780613507,3840682670,4063759212,2007001522,3591173823,3593187197,3375070019,439542198,2672506939,325679764,1355718446,1555216233,1439869855,2247605911,231865410,1258936478,807314048,2747044825,3491088748,4059233725,1162436591,1132792457,215524691,883305083,1757945884,456983133,1537864271,499299190,2296783812,489476980,3518184642,4034397900,3270614756,3096242015,2934495501,596610255,3519964772,1312261615,1325555202,1596587089,2386559232,3658926359,496429942,411538330,1936708596,4241339669,3347731979,3871237464,4231143058,729351734,1457364769,2289364038,363828809,1630824300,2998043036,4231488974,1186425641,857448514,2882790647,2407302902,1059244730,1822402541,998805888,16204448,1178609527,2748808942,297375183,4187072761,2317875716,632062522,3561158194,4246601265,1795324457,2874824880,3050877937,2506601089,2740773968,800773844,2166896563,733461731,1822102190,3802422121,2569077410,3207487028,3059809300,1958164037,410409347,1203725089,335279715,3264921802,290281518,2321776728,3678621751,197208800,2846273807,2717407389,1229451458,2713530889,250385298,1384696302,3216974032,2054048272,971169099,2027447593,918340265,3924534927,3639037169,2207521150,361265567,470894676,1167768856,3458084186,1605598286,1695176285,1439809339,4015161042,1239052365,4161771296,3200755712,1629457373,423091026,2265603063,1174636902,2041291337,1678818894,3495778109,2142008396,3039311068,2966966935,2373660591,2170373981,2679117152,950574087,682681328,1387034276,2036868550,1964303853,100046104,4034314450,1401965107,1917768497,4171904618,1248478464,4129673457,681415127,2433763818,1505206379,100540786,3881201434,1736302594,3059571296,2330951114,2741407356,3423024426,758364644,2338447571,2181622105,4025661920,874462065,1247664559,3606576806,1662497400,230836908,2078936630,3425157630,2311101934,1236573777,250049458,1050121345,1595396114,2582190254,3014192478,1647043101,4187090724,3580428691,1660037727,1846416981,526485164,818450550,2486081439,2270172330,494205532,1099993182,3001730853,724761734,2315201673,2383094530,1189970930,1868188868,1370398187,2857431330,3729998491,1415574812,951417650,1877857713,2224903334,4068342606,1226168925,2061543656,4289784392,3023823499,2577793926,2130195991,3096550894,3770211661,3208113019,2051349133,1473358371,2110375674,1881577292,431562317,2311639659,1705144255,175673422,1374818584,1705873365,334822472,3220615112,3229572060,3987068460,1556857896,2760371432,4017121572,2814859576,2184943458,76388717,2707695643,3504403270,1728107266,3385288745,3330855319,199254519,2181023088,3253877161,2115301431,2090368029,4195383155,142407623,1786118455,3814810541,3840863693,4043721836,296227852,3707470485,2485423627,240084038,286013563,1173073318,1528722356,1384349624,2204553747,777994522,2425454527,2747494366,800789493,420354625,272173976,2252684001,2532666429,2181809512,3463074298,3699637705,554606288,1853438502,3248088648,1113770121,929301954,1979896382,1655699671,3154889123,2525617449,2694380524,1780203726,285312485,3776265099,3830713922,2568616750,1681564157,4133232156,317562005,2471668509,1077241871,3047090261,2874384976,2784533979,495599270,2981897568,1875709218,1547420657,2305312616,201127879,3048337653,3102044554,3384574707,4093452329,2548046449,182819,4206921261,997101094,3043570086,402022053,2891189830,3961554819,4134997339,1187937661,1021638424,581015406,2732740095,2357577946,1512531967,3817692295,2683300142,3916051274,4063755370,3561805512,1021129209,3306840054,1633990745,305672104,539098239,575125749,4010157427,3716835524,1442272689,2143839860,842428807,4003548052,2543644951,4004733313,810717909,406248228,1442791234,4063730676,2491580281,1496170468,1924546473,1694192294,2910775426,4062224413,3797084370,4264603344,370572976,2569594771,1606562315,776201647,560580372,1736246377,1130369791,2966854580,3983529625,1682957611,371126757,3931295571,473069320,1694981779,59527676,2567381957,2679521677,210574830,2920418972,2590834955,232011315,3875613083,3860168580,876556021,2468603251,2045822080,891303826,394285534,501279213,3577319187,370111846,2538888077,932608013,3830499286,1286437180,784555179,3036857353,1011472303,102543961,1946967469,3888543947,1063339135,1117654213,1064341070,3223651103,4177745006,1632699903,1917291583,1057300644,1991172316,853137573,3996846970,4074408498,237065907,443588954,1690200742,1399152103,3680537670,551107891,2249969805,1362905957,293672112,1670486862,3829028199,3211389766,3305009318,3433857389,888631707,2759318205,2622466425,3605602524,965737924,1120341802,641012935,45135423,2956888399,3488213857,1696620891,1798332212,1359066628,982872508,1578211155,3679846626,3389891073,1245597686,1333089349,901007420,4171823161,3066179065,839236669,3972322347,3968077457,1955869174,2845043759,2173005972,459626831,1761865168,3006003996,2305892131,2879709702,3392265072,1308964997,1006708556,2053132345,2242832654,1757367534,1174738363,1418194192,2380422426,2408628165,2413448522,2980706606,1246569363,1707756124},
  {4060810561,841997183,3893284512,1978980984,448913324,4214905397,3269789337,812642587,3033328373,2059167739,2347174148,968932817,2752985081,3709097154,1106052130,3444834120,2495869691,4025064784,4224092004,2442951286,3208313956,1925918421,3912974737,1422254200,4203191617,1780606075,117759015,12771402,3928800293,2910458010,2286071733,3817475565,80283276,548322962,214883440,4245969646,2021438477,2018862915,2552885146,3842453627,1415043972,2331803167,2938237445,3298292771,3419347521,3645800044,173256198,784716108,373103056,594972213,1409426627,1829277768,3919851402,3799011467,106450341,2869673219,2115625800,2076398173,4084652631,869531739,2520528948,3890990633,3373103019,2317345064,1822509923,2447885630,1682726265,1242510154,123612540,3504646824,469755449,77421049,1281095720,3691868831,2881842960,1709438585,2049641298,3305501023,2534903851,1535760500,100797632,1227068129,76689123,1790804456,3690579349,1949684294,2977588371,114819086,2133563274,490144681,2219822188,3380247713,1731615273,1549920957,1173485841,2953817971,1527788182,2641496055,1488473022,1397842004,210975802,718876571,407625473,2240539283,2642968501,3962143494,2057087077,667838014,3076924647,3249748851,917899431,945902125,4096371312,2173207488,2387830664,3188451424,1492172770,706311747,568803548,3142176816,1557618173,1992316451,4108042580,3456142138,2937247811,3252574017,2356414679,989457714,3008755177,1509068838,3642499931,2942109063,2702725590,2945228750,626600397,3951455994,1437149590,1794860382,3441503432,1644068373,1959170384,189658098,3203724450,342054150,4016252250,2819216374,3343687707,2337155262,3092727486,1369957998,2389929963,1160939876,1354898560,3505671330,1165467458,2588488020,73064388,3040568017,988697677,3243697835,3774008109,1593887748,1079380580,1730523116,3991391368,1199996553,1096460516,1244597246,2496192659,990392539,2619645539,1693493897,1026236349,3221913884,2285097821,245950570,1223285423,4239533564,2009756714,2793617544,1291026899,663418014,2365231518,718976943,1963424658,575143016,148780501,4267158158,2718580490,3132317020,2386079086,1975559916,1768658481,2293525171,2534309000,2029702471,141043891,466924053,3785485457,842813251,3997555861,584418325,2278684753,1088859875,4264500129,1072036437,2654291737,3417573774,4191711308,2458999923,3904347457,1335049193,1095830581,12162001,4120810535,534551519,3713901968,1630025365,3846122356,2883434655,3136638903,3259066262,1044250131,556713944,1996013403,3590260326,2893408776,2967128410,2975432589,319018731,32711571,4278541106,4130707312,1473089573,1372963019,325974964,948209471,2376805995,3591149967,368782471,3570428337,4267977054,1383411079,1929425926,1521817345,204387707,4220063449,357738668,1349281189,3508945531,2649804343,3039464732,3729820324,1560894271,4022634573,2803851389,919413725,2131651090,736415978,1846707082,2595795542,17682047,241473180,4082607182,3171352481,4192729665,1050274113,2295221176,4190209140,116063495,257550372,1056865154,4265140872,2564895776,44020718,3829164726,877047791,3682570746,4235009611,210204791,4127052506,913147579,2869270127,1396644898,3164219364,3121629177,3870932612,363806521,2282258507,2284145926,1275268925,3079610584,3474651225,910691901,1627430267,1369728602,1569996868,3193727020,598643674,383769995,3431062555,3169306458,2440059824,275623205,2036256199,1066241167,469776229,1720051233,2430428640,2131195048,4038689752,1779481929,3358126185,1939264749,894463945,4160387659,2015310905,3347793475,1970393619,3547962775,3984009224,707404105,1185366531,2693753140,1505940117,4039434616,1971573481,1677025717,864747377,1666901973,2252603058,244194450,3036054852,1564857192,2857201624,2768150426,2045196465,1910825358,1784459233,1299591711,1535539731,604489337,939413127,159398139,1747341218,2797126911,1494857570,667957356,2194319485,2429346623,2640847194,2048276095,3639370742,2498562035,2509907980,246228177,1127681137,3318590912,1616242087,1962297778,3469888544,1167486157,2074979054,1727954489,999097883,992551776,3441021240,44643958,2610033131,2970817930,490776706,2923837301,4101895925,2628711375,780419859,2646570475,2748006557,308167614,3162089736,687550161,2111913443,1881766374,359502104,352036884,2874340965,2557761634,1522066025,1175918054,2443776933,803651975,196171103,1855857249,2331945166,2200408351,731154038,337987614,803166479,1555551095,3962286751,506017276,865751951,3907799966,1657133304,1613407392,1755316026,2208351199,4017158239,4110545415,552737435,2669111407,2993683797,3867421755,4220094025,4140893916,2714740250,3509632602,2795031183,2453261732,2503343475,1630253150,2539793917,963894696,1558895702,338020778,1741313619,3612359420,3738035515,2105284421,3151124338,1353613500,254896732,1649431374,3317909706,671575121,3810768185,2344304728,1566940006,3276646165,3820434079,2910079395,154910719,2580415203,3153426287,3332141521,997250762,447537083,3607110963,1443171362,2128224055,2580943901,858474788,1720985934,976846262,1294269273,4099345409,3189112019,424980461,1741224596,4206644982,1754621644,861663046,1268699444,970571936,3229308984,336651459,112658662,787203059,2997088888,1457707482,1552610582,1221036605,1621552542,2923306000,3620693255,1657234448,4172727345,2286747279,2043533720,3574230079,2589344302,1937277819,919857190,128019371,3745044430,1666238260,1465099484,3906150353,2578158038,761244335,3608799555,1612573919,104964040,3664453949,2813798900,571244933,3079515394,1922727196,4062802500,2551061423,1135544366,1952769040,1259887867,279496397,81868270,2645085908,2472505173,636249014,2403209421,2605150496,719064239,1912138855,1195677536,3277848414,58567943,1569953444,149442881,3660334778,2768532579,247118636,420345593,852836790,1806191508,757918386,3834068385,3543303411,1752705168,682152357,3949390974,3314089671,2778835083,3921781444,2072038049,2667052504,2544995018,816226412,4250608866,3520776277,3588541804,193436804,3308168218,17788889,2913326811,749033653,3699560072,1309944418,3130741914,2992771297,1448820212,3534242026,1305265717,4255500927,4212041281,656785227,4096908563,730816197,4275421976,467778326,3858264322,556337470,789466732,368498253,3609217007,128049226,1397321310,538045463,3973587891,1862757107,739410254,1462324202,1931739481,4241125251,2252465597,1152664314,2480663980,2994726966,2938098680,172168461,904361314,2498989244,1574410105,2268107461,2981085263,195784341,3134381074,1731956250,2656732422,2615961864,1248953932,3020568344,4063347663,3933187246,855908049,3166523770,1480090601,2836609991,1093688096,1384412899,3587458918,483772477,3282738804,445473633,1407397287,3092881273,1584916739,2746244915,2204442285,2257285361,2036509750,1645697869,1368198083,2835820265,3655294044,2100195016,262747600,590742355,872207529,1520762991,2477302552,1248734102,378230534,1955668826,2967984886,756316799,1185753444,3845731806,19294587,2737420020,3498396426,2226789466,723047045,3878595834,1903456558,2236612195,1725759002,2375010376,3232013174,1517492285,319740258,1570660438,2705790494,238089799,433707794,92594919,4078095069,3856887357,2196672987,3373993695,2043067101,3778518250,1182955134,2002844074,4075986909,50588958,407770012,2563865772,878424092,2265279066,2729331558,1073494238,3069995055,1343629935,591519053,199138944,16753680,2567276112,3237463914,2040592739,988457274,320748907,2562918732,1300176589,961673947,916310903,116358138,1688733924,3207986467,357060373,1075795501,1844353971,3887978582,1021028929,2074640833,3666644249,4255461629,4117730823,2650979331,3413132091,2676899485,2981020003,732874251,3084537662,3194855425,2831864063,290997105,3549572595,4200497093,3437462452,449424222,806780766,3272168555,3428145549,2862032679,3482426365,2788160266,3417701299,4067150826,4261580470,1458718409,1263115160,2755311971,4119783302,2886525389,3633872750,1224373678,3183382882,3560872741,3216580653,1240718111,4066228089,599428360,1981299135,3263031296,4073895810,1820446234,666981433,1201208563,3647175997,1788295099,1987295260,3665743433,3994386674,1637250737,1243364764,3279851881,2593831653,1222190997,2367400723,412810493,3842145646,3790980543,3164839260,2524617209,4198840643,3481217308,3492174523,3730729994,2316279760,3905047250,1851470647,1304937346,4027707309,3229158058,4240110751,1926114207,293693331,476248373,205519577,3361719626,2767900214,1737612796,1820340961},
} ;

static const unsigned char precomputed_decode_761xint32_s[precomputed_decode_761xint32_NUM][crypto_decode_STRBYTES] = {
  {159,74,49,35,120,33,167,9,19,10,183,151,200,51,79,216,90,0,235,105,146,62,64,113,39,49,209,61,218,11,8,81,27,208,251,62,113,22,242,125,127,189,61,233,197,158,3,74,190,220,200,176,34,233,171,98,178,220,91,67,111,190,125,82,5,203,112,19,10,65,176,51,225,88,22,20,224,30,30,35,199,198,50,46,75,142,13,230,127,233,93,169,137,109,166,186,40,9,161,241,84,47,89,127,132,54,22,243,172,178,187,186,27,140,88,22,177,90,21,128,189,38,169,161,156,150,226,198,97,41,31,171,100,222,104,13,119,217,75,10,148,123,100,187,198,8,140,97,83,240,235,209,193,68,151,190,170,179,40,179,156,238,45,96,187,243,33,254,19,156,40,91,37,218,207,120,247,113,253,57,212,192,243,99,248,169,44,165,123,93,87,207,233,202,253,49,30,39,212,147,63,243,178,3,241,89,96,6,100,75,140,7,230,85,156,176,138,115,225,102,65,169,117,254,81,99,10,215,63,48,90,253,89,254,8,88,113,152,15,21,90,6,68,68,194,101,68,104,157,193,31,36,201,128,225,129,1,174,18,199,26,58,9,117,18,99,191,180,24,162,248,238,100,128,225,26,138,203,247,128,234,18,59,112,143,124,115,118,154,224,242,249,155,15,76,244,99,137,135,211,58,172,162,110,185,168,0,86,106,222,204,223,231,118,92,84,60,209,55,216,59,181,195,249,90,244,19,71,179,236,206,141,178,189,55,118,195,171,161,225,103,216,224,127,239,108,3,182,151,179,12,152,125,254,33,173,204,233,208,252,102,44,208,90,167,158,56,151,228,22,77,205,46,169,138,134,11,252,15,247,69,36,214,105,77,142,7,15,112,70,60,187,34,155,136,11,117,100,192,110,125,26,68,32,56,121,86,253,113,182,137,24,134,157,168,253,162,101,16,96,232,128,18,166,209,169,94,187,195,179,234,222,31,93,65,183,158,104,223,198,237,91,203,113,22,217,207,108,26,197,107,112,30,88,77,215,156,69,251,159,46,119,195,60,68,29,89,136,221,165,240,189,7,77,80,58,138,110,155,85,51,49,118,20,44,48,238,83,213,121,12,141,41,37,132,91,9,235,201,31,128,102,105,31,198,248,85,55,205,20,75,142,54,76,6,54,244,250,241,41,18,158,31,232,30,145,195,181,86,102,11,107,126,131,184,203,0,105,129,3,177,14,35,227,69,171,187,158,210,162,64,100,44,42,148,228,126,97,250,101,6,222,206,94,34,156,155,216,212,190,36,198,192,53,62,196,27,238,6,240,71,212,162,115,30,229,186,185,61,106,253,81,31,112,240,225,55,173,230,232,10,39,55,103,219,158,73,241,92,238,232,129,216,133,20,131,166,57,63,206,15,140,151,45,113,26,86,18,215,228,227,218,168,132,134,112,27,4,118,29,111,39,4,94,246,173,86,179,20,35,150,80,216,104,47,53,238,228,203,238,161,102,134,136,203,253,190,239,111,19,162,118,81,6,195,191,252,209,35,96,97,207,63,229,84,161,104,239,42,94,174,224,156,223,208,67,226,6,234,163,126,22,107,188,103,224,165,201,162,210,48,50,116,74,64,19,61,116,195,108,252,111,70,22,222,85,61,86,244,6,179,5,224,30,131,198,94,190,240,6,215,72,8,102,122,32,175,174,113,47,212,68,255,163,95,91,143,153,235,134,138,11,106,229,40,184,0,77,174,69,97,119,195,240,73,228,139,85,253,66,13,235,131,153,77,1,123,84,216,3,185,215,79,86,57,68,51,246,208,64,89,108,117,32,233,97,4,98,133,32,187,149,85,127,22,172,121,61,236,98,105,116,187,92,60,184,166,223,57,100,220,69,152,186,222,105,254,44,187,224,248,37,154,65,125,201,233,40,169,188,161,56,116,5,94,206,237,58,207,30,175,188,156,116,124,205,227,41,182,103,69,59,39,54,151,184,65,214,21,3,206,133,4,97,142,35,171,209,107,191,224,42,123,3,149,101,57,190,186,68,249,9,182,89,133,43,127,41,245,180,126,82,229,190,120,200,53,227,122,133,70,141,14,171,204,122,108,139,233,40,73,143,164,27,30,132,62,255,92,128,169,174,46,31,227,228,54,146,148,188,87,192,207,205,33,6,36,15,58,45,130,33,195,238,253,188,180,153,76,228,213,153,37,249,91,84,227,10,181,98,71,202,51,88,182,72,38,201,75,40,215,223,15,38,37,180,249,17,159,66,241,165,27,94,198,237,62,48,216,117,168,206,99,22,199,176,5,124,160,249,157,164,179,152,36,43,214,115,10,137,186,103,100,187,41,183,40,177,229,69,23,99,51,39,116,34,17,158,27,228,40,11,89,77,24,202,114,154,48,69,29,169,165,109,96,73,103,240,86,25,55,112,159,74,42,4,54,123,211,225,232,169,18,49,69,218,245,152,225,159,179,174,147,12,221,96,173,144,36,81,190,26,69,3,60,82,41,197,63,108,53,117,171,188,94,161,132,245,68,98,238,237,130,116,104,187,191,217,237,243,198,142,25,202,96,246,251,236,4,53,212,110,13,204,137,36,225,225,227,232,164,25,72,217,90,175,62,255,85,69,175,220,30,0,86,8,107,148,197,49,177,109,225,199,56,74,44,186,217,136,155,108,18,202,32,253,124,36,121,137,146,21,105,74,138,32,90,45,119,164,177,201,206,133,24,118,209,82,227,48,39,23,199,177,50,132,113,25,131,33,125,207,32,168,61,254,16,167,89,142,251,97,84,63,83,166,190,113,228,49,103,208,198,133,87,100,84,122,51,102,185,71,246,243,165,154,125,8,173,185,63,165,88,4,180,108,58,110,184,105,101,139,100,73,155,187,251,255,242,122,101,43,61,140,170,111,179,29,197,40,13,59,238,165,122,4,121,29,202,114,233,212,55,159,237,77,7,8,196,94,130,138,156,39,130,110,1,221,11,51,228,56,111,0,75,181,132,167,100,219,142,227,95,41,207,89,149,45,109,91,84,223,231,74,138,184,12,73,7,98,241,190,168,69,39,254,119,226,67,249,199,80,249,226,24,190,240,74,168,96,148,236,23,43,45,97,31,101,46,124,202,90,115,14,83,21,60,228,129,72,56,39,217,207,29,161,124,82,135,233,111,75,205,201,83,59,130,147,69,153,243,158,248,113,54,123,183,189,222,176,30,24,97,72,235,36,185,84,23,66,211,175,3,61,102,187,215,195,1,121,244,9,17,168,186,230,29,211,33,144,86,241,24,152,240,22,180,13,36,102,33,237,13,139,122,72,185,188,36,220,161,82,172,50,242,65,41,160,205,211,132,11,111,123,34,225,33,45,150,176,18,62,13,136,30,193,188,41,142,185,165,152,95,41,196,18,99,80,49,184,33,193,32,169,173,62,121,219,7,240,177,198,56,31,253,208,38,154,43,80,113,201,253,186,55,99,209,1,188,36,1,128,168,191,169,162,18,103,18,114,48,224,102,23,165,58,10,12,44,215,223,185,163,183,90,116,57,64,90,28,87,104,51,165,236,33,91,3,155,186,179,137,182,77,159,33,17,230,121,42,235,204,192,78,147,254,179,61,120,192,142,8,35,56,166,79,128,139,186,151,26,160,105,244,245,208,213,171,233,154,181,223,93,107,251,10,85,67,133,189,70,222,238,78,177,148,108,201,209,34,240,126,67,149,79,108,179,213,182,237,61,49,107,144,209,230,237,85,173,43,129,203,153,52,151,2,176,27,190,232,148,10,18,226,47,208,11,106,54,235,166,252,188,255,230,255,16,3,67,185,129,207,93,161,41,104,159,156,49,33,140,166,243,170,121,30,130,138,181,34,131,34,63,234,233,159,70,51,68,33,41,225,245,205,141,251,226,199,27,182,33,220,76,58,235,104,234,95,209,237,42,39,110,138,244,194,151,218,197,76,42,253,64,136,253,254,64,67,163,109,139,125,247,226,199,241,139,241,2,85,110,54,147,255,59,14,202,49,156,196,177,57,209,216,188,233,70,128,73,252,6,213,204,169,141,241,230,225,214,220,55,241,28,197,17,250,167,138,128,12,239,135,230,153,101,22,204,182,199,148,126,245,189,71,186,246,252,222,161,175,47,152,219,119,7,46,119,51,56,91,158,7,183,24,236,198,77,114,223,235,183,14,110,248,152,139,159,84,84,238,134,113,226,202,133,113,39,185,132,174,167,154,206,110,91,217,167,152,28,248,139,233,27,33,101,167,179,147,44,46,231,146,127,206,106,243,133,157,139,158,142,171,255,182,20,16,186,182,15,168,96,89,93,247,208,126,76,210,9,41,115,180,100,53,32,236,36,61,124,173,165,71,215,162,77,62,172,195,163,20,104,19,135,116,116,227,46,35,54,151,159,61,167,56,54,75,25,148,151,84,234,152,202,98,138,179,119,173,147,30,113,60,35,219,134,54,170,108,81,249,1,143,142,210,84,74,30,133,61,153,172,45,217,20,25,58,106,16,142,111,218,106,119,125,43,21,5,206,190,52,225,178,251,219,2,102,44,238,47,148,32,5,224,155,211,173,179,61,120,208,65,137,73,162,206,52,157,96,23,62,69,80,125,163,255,196,53,35,92,192,200,104,120,114,246,191,181,109,128,44,169,149,247,17,18,1,196,155,97,117,196,220,93,74,161,242,246,37,208,37,100,210,245,32,200,194,111,78,250,16,52,101,105,145,239,250,101,240,77,43,217,84,178,70,221,35,47,50,1,216,57,254,10,200,59,24,91,64,81,85,228,198,247,22,51,237,253,135,45,128,102,152,97,234,211,142,25,124,24,123,188,195,74,37,65,38,253,227,16,186,209,55,131,255,43,228,69,14,138,154,99,159,147,222,32,46,102,202,130,106,151,44,253,39,135,253,211,190,167,13,213,89,191,76,187,148,140,55,193,154,100,210,69,85,32,248,22,118,245,78,42,114,128,145,151,72,77,168,181,208,144,14,63,76,17,2,24,112,71,190,62,94,222,218,99,205,25,195,140,122,14,114,99,167,106,143,35,89,212,212,9,136,243,20,202,53,114,150,243,45,160,239,231,30,126,52,162,7,254,164,69,155,43,2,213,144,145,162,238,123,174,62,59,104,235,212,143,2,183,4,63,43,200,191,245,135,247,70,131,217,2,80,133,223,89,44,170,179,253,225,190,127,125,198,71,158,4,174,139,181,179,205,18,170,131,37,57,134,55,114,120,52,255,1,177,183,46,28,178,4,44,151,200,62,220,144,22,30,116,58,109,40,131,199,178,171,38,121,9,253,166,206,236,88,221,80,217,89,243,58,178,201,47,64,106,218,28,137,81,147,69,72,226,148,188,3,249,157,69,49,136,36,147,235,31,64,248,69,11,21,150,209,16,152,165,0,252,236,35,150,148,75,87,39,197,217,61,6,137,3,152,74,71,155,238,217,161,174,191,119,53,101,105,105,38,176,33,177,214,126,88,105,113,219,28,154,73,83,96,168,214,114,45,162,237,204,100,115,49,151,97,28,133,22,254,27,31,175,192,244,108,102,24,175,234,116,138,48,97,25,91,210,87,108,51,135,38,216,26,23,114,235,228,30,223,149,136,110,234,46,81,39,11,45,27,226,214,119,211,105,139,133,140,83,253,15,105,35,249,174,224,53,242,1,42,94,251,64,39,44,202,113,221,155,193,1,187,41,143,67,98,253,9,199,216,48,126,168,13,212,9,166,254,140,15,239,183,1,220,57,24,1,126,139,247,247,196,204,172,17,73,76,57,170,104,70,243,42,240,102,246,0,234,58,53,3,87,194,100,237,104,45,234,61,104,19,199,171,173,39,210,128,223,92,119,69,227,225,115,238,226,12,95,40,102,124,24,118,206,223,42,220,89,30,57,96,223,5,33,99,141,10,217,83,116,100,123,49,46,145,122,16,81,127,69,63,163,20,180,180,132,11,39,116,139,28,161,41,94,215,140,206,65,40,126,170,195,27,115,236,106,147,161,122,35,12,77,2,50,177,217,30,146,237,40,232,198,68,249,32,120,111,81,182,37,209,157,199,240,199,239,114,186,140,29,229,24,238,203,204,14,61,17,42,140,80,101,37,149,240,6,113,239,110,89,107,169,83,57,211,17,219,38,73,63,61,229,215,65,95,210,112,11,193,9,155,182,148,252,74,175,137,30,160,132,171,111,56,95,66,111,252,47,229,75,14,61,78,241,115,4,203,166,178,224,8,209,202,118,0,93,63,142,86,247,231,67,111,92,142,29,58,198,86,67,154,25,28,238,0,234,80,43,4,232,205,165,142,29,46,162,6,170,224,137,220,2,233,97,75,241,146,115,215,215,173,213,96,218,128,35,129,69,150,236,229,93,149,123,20,97,101,3,251,39,136,16,221,3,202,201,41,179,148,245,234,145,20,57,84,92,70,69,189,243,203,31,87,133,164,62,228,29,104,161,93,225,18,166,148,5,44,196,241,68,82,194,253,168,34,39,175,187,249,70,177,171,212,71,88,71,247,69,118,192,119,151,139,241,183,84,189,5,79,220,236,107,87,149,18,143,215,243,17,140,202,226,129,44,170,39,66,238,182,200,120,254,214,175,130,124,141,49,174,39,174,215,3,229,64,224,199,180,203,239,252,24,231,193,76,176,15,163,239,139,168,237,147,164,53,135,214,104,224,210,233,90,90,65,169,73,220,99,92,55,40,244,155,127,8,79,30,41,23,142,211,155,193,66,108,115,197,255,230,20,50,147,56,250,59,13,140,79,131,119,17,71,41,225,174,132,183,2,84,127,23,251,3,161,167,196,238,92,19,109,193,66,59,200,159,88,179,67,171,226,203,27,223,108,174,184,80,7,206},
  {75,118,238,49,1,141,214,130,134,127,145,117,52,95,149,175,158,26,79,171,240,79,203,172,16,2,166,234,129,172,190,67,79,237,200,145,197,42,42,122,138,109,132,199,148,76,158,223,137,148,194,219,35,106,90,200,6,98,89,206,216,13,161,16,56,128,0,170,166,150,202,53,171,52,58,176,11,96,175,175,1,252,151,248,118,110,9,45,158,225,221,72,55,189,201,137,185,93,73,237,3,239,242,247,41,60,53,200,5,229,64,72,220,27,26,77,204,181,105,15,24,119,115,141,215,81,245,196,29,134,166,80,168,19,220,82,203,179,81,110,183,234,127,80,3,197,247,101,168,49,37,249,132,151,26,146,37,2,222,54,154,70,224,168,25,123,41,238,252,121,145,28,101,255,207,13,187,117,164,141,241,219,28,120,222,143,227,55,130,80,181,196,127,91,70,171,111,158,115,119,184,177,136,50,115,104,125,192,8,150,215,124,157,175,226,125,169,72,139,255,2,42,89,203,123,17,51,113,201,174,236,230,120,112,124,3,203,209,221,76,3,21,251,33,50,113,63,173,87,93,104,236,13,114,186,239,250,226,121,185,242,127,228,20,28,25,251,151,46,176,247,107,147,92,30,14,33,59,40,41,138,36,133,139,23,0,0,91,161,90,60,30,167,252,209,240,19,4,170,62,57,97,202,192,154,95,239,214,117,68,53,87,2,84,240,16,106,64,180,37,192,219,95,185,216,64,137,81,58,2,242,26,196,131,72,208,62,105,58,132,25,25,229,232,59,177,32,169,228,254,105,178,223,150,203,54,13,196,170,78,37,13,100,151,211,2,166,95,194,223,88,243,121,221,1,96,133,73,243,48,14,26,222,72,149,40,46,137,139,60,66,71,9,110,162,132,78,232,240,255,241,114,226,208,155,185,2,255,157,40,104,202,215,226,60,48,149,154,161,4,254,92,245,214,131,202,145,188,94,17,155,29,124,144,145,232,58,72,1,201,66,162,187,211,129,140,213,159,56,237,78,112,194,45,191,7,161,123,19,236,104,163,177,72,164,166,24,124,227,108,73,248,31,65,153,168,151,121,207,4,34,242,70,16,146,99,0,84,29,98,136,220,76,34,68,183,220,143,192,136,255,70,142,218,113,19,25,189,188,76,97,195,162,195,44,75,185,145,113,29,13,223,176,180,52,122,173,132,186,149,120,73,126,179,79,131,57,129,188,71,137,135,215,19,56,108,148,150,13,101,146,31,97,176,98,37,73,225,103,88,11,59,20,61,12,99,40,31,57,184,168,136,61,132,138,158,49,79,227,197,177,148,17,127,184,198,231,206,198,208,89,132,63,226,48,222,224,155,22,214,174,65,126,24,80,66,241,104,3,161,62,115,118,247,109,177,17,203,69,60,255,245,94,57,219,236,253,197,199,96,188,187,73,143,181,74,182,2,220,66,125,134,111,67,74,227,181,52,59,186,84,66,135,1,65,116,113,134,246,74,66,91,214,180,200,42,5,53,112,34,112,135,46,128,240,220,10,123,204,118,220,42,110,52,72,232,13,95,3,187,28,181,251,148,18,194,248,102,22,253,207,76,142,114,252,173,233,183,130,254,214,20,130,46,59,247,245,71,103,73,159,179,65,242,219,55,101,197,2,87,4,167,151,202,105,113,228,9,156,170,93,224,241,92,32,4,84,87,15,146,220,37,154,84,222,56,217,7,177,89,193,31,108,210,83,46,172,199,56,95,123,112,77,182,135,249,68,75,162,238,94,96,170,129,231,111,231,96,192,35,182,121,188,102,72,50,135,132,242,181,131,16,234,252,184,214,18,250,206,156,147,157,248,171,33,218,122,150,130,132,45,136,110,145,102,212,50,113,231,237,244,175,15,66,190,204,32,178,98,255,56,122,98,45,72,4,232,182,99,34,103,60,102,232,245,169,28,198,95,153,113,60,141,139,196,250,79,182,37,96,6,225,248,40,143,249,208,127,107,157,242,51,53,250,16,179,161,72,39,106,233,116,22,10,215,175,147,52,167,158,137,137,147,190,107,35,76,190,213,200,48,124,185,242,139,76,17,43,171,52,254,65,32,84,43,76,83,72,56,179,207,206,48,113,103,215,7,68,230,163,46,107,220,110,245,124,201,16,16,14,151,177,247,44,3,192,141,116,51,193,35,144,222,138,48,22,79,68,157,230,184,226,149,220,31,114,214,248,21,138,170,217,15,139,102,149,240,175,56,132,129,164,139,1,201,255,46,31,149,225,98,120,21,44,251,247,89,29,20,114,119,254,241,208,186,251,94,151,166,209,130,153,119,86,65,35,226,42,161,197,239,214,162,152,49,150,181,187,154,127,219,72,170,21,169,246,17,138,111,55,249,142,249,25,53,37,16,128,125,17,162,90,194,150,226,70,221,229,154,114,132,34,140,1,47,153,201,5,62,135,243,101,202,250,124,195,187,217,143,94,228,5,150,201,251,65,140,138,42,222,79,54,63,150,75,173,251,80,105,147,93,31,101,158,108,171,151,157,35,155,220,142,16,45,85,9,235,227,220,189,213,41,47,215,178,216,89,196,222,240,252,198,29,45,136,214,56,184,152,138,52,147,224,27,220,144,180,239,221,147,19,29,54,178,189,36,254,242,212,218,252,44,12,46,19,72,228,10,173,53,0,8,190,46,163,173,201,143,17,4,124,185,58,209,6,230,127,175,197,201,125,235,109,41,101,107,101,31,5,206,98,244,107,156,56,178,213,40,117,189,49,109,147,245,98,197,184,234,85,129,56,82,196,104,97,56,129,75,170,194,21,35,222,2,153,8,26,152,172,169,117,160,120,217,49,147,18,248,103,85,207,243,234,239,147,64,207,153,214,191,90,73,130,88,54,58,193,243,244,126,78,112,211,84,38,140,166,195,211,229,245,178,245,2,143,122,88,207,97,82,101,0,113,54,100,105,99,97,139,120,25,34,183,211,116,128,127,50,208,93,178,168,124,192,29,47,29,199,18,236,186,163,67,177,247,134,165,69,30,73,43,99,65,198,26,99,65,55,100,107,87,3,17,134,100,180,16,52,94,196,181,46,65,29,114,149,129,106,158,28,224,164,209,127,160,182,106,252,213,248,167,188,248,192,68,83,37,159,194,203,211,87,88,213,56,224,221,67,254,230,68,233,131,33,204,102,148,93,15,146,7,90,47,80,177,133,86,134,225,255,246,33,204,159,107,247,34,50,107,28,0,62,188,17,247,156,11,48,135,145,78,213,31,1,79,228,5,56,113,222,118,181,94,60,98,235,81,233,24,124,50,59,212,70,64,116,198,184,29,135,49,57,64,147,140,193,10,61,193,181,52,201,136,52,10,95,206,171,78,6,181,235,58,14,94,1,235,253,8,109,4,44,10,186,82,31,250,179,109,50,242,138,106,156,69,14,103,73,35,197,213,15,224,6,225,13,157,180,85,191,187,94,77,59,128,152,88,84,218,31,76,43,12,227,49,39,22,27,199,147,167,69,121,194,167,207,104,46,158,160,223,225,223,233,140,182,168,11,147,77,23,49,122,99,146,46,58,65,116,2,105,242,29,126,115,241,94,129,34,154,123,219,129,106,179,131,37,78,181,98,186,74,76,80,232,37,19,125,44,177,174,253,222,184,47,211,188,65,220,89,152,100,4,154,93,103,54,67,132,105,207,148,237,249,179,54,88,94,241,219,151,19,106,236,33,218,172,125,168,55,122,232,95,167,102,195,209,206,240,193,157,212,146,231,217,116,12,146,17,164,140,127,238,251,67,60,151,88,65,198,58,90,172,250,33,77,225,121,49,132,35,216,186,214,118,74,172,140,188,208,1,16,203,131,25,221,188,148,157,224,57,14,164,42,131,13,130,132,133,249,206,26,132,96,105,135,130,242,178,209,91,169,86,70,55,164,42,121,219,80,16,215,225,235,193,66,227,194,61,57,132,5,16,153,51,111,84,89,125,224,156,112,80,12,69,219,255,194,198,154,125,185,255,195,18,64,218,165,179,38,154,44,74,242,106,33,242,96,217,56,65,13,114,130,24,156,195,209,120,100,193,201,128,27,182,131,239,117,65,55,255,36,161,223,82,241,29,129,188,64,75,60,251,168,233,219,230,107,54,72,210,2,90,99,83,150,250,209,88,15,51,42,245,55,80,123,82,67,225,179,166,107,22,49,6,195,6,1,222,212,98,245,101,77,62,17,151,79,49,41,181,240,40,28,63,144,65,224,240,207,228,81,195,133,194,148,120,14,155,243,20,100,145,153,70,238,238,197,27,209,161,126,108,16,1,73,238,174,47,116,173,131,110,254,40,245,52,50,78,239,52,129,235,156,63,90,2,168,73,179,141,32,162,228,236,40,41,95,117,228,246,215,98,87,174,192,69,72,164,145,210,27,126,138,234,179,220,95,134,112,25,172,4,126,77,47,78,111,163,29,19,86,139,44,75,15,209,151,180,208,8,217,205,122,226,177,201,124,248,111,198,5,65,75,210,101,34,82,208,251,6,165,17,223,103,63,248,111,100,22,14,129,197,202,43,25,45,242,130,134,218,161,74,82,51,128,216,96,107,136,182,125,133,255,189,50,78,98,233,217,188,101,100,59,213,80,39,33,53,204,19,164,110,192,188,60,133,11,115,171,228,6,223,140,3,87,174,38,239,228,27,16,64,42,158,195,209,123,4,138,172,60,146,223,252,219,98,179,188,90,87,174,80,100,40,105,146,130,200,153,8,81,18,81,84,30,208,202,208,162,104,51,241,12,134,28,73,82,158,219,12,90,34,190,32,45,215,209,47,13,132,244,175,223,49,230,27,250,74,58,75,33,214,111,100,161,79,68,228,34,68,229,182,116,9,200,118,28,52,220,70,242,172,237,56,154,11,186,68,8,20,122,198,67,43,199,29,209,5,186,242,26,104,229,46,62,175,24,153,133,95,220,106,143,67,115,211,158,10,236,201,39,227,209,158,194,164,11,48,204,196,195,42,190,191,73,49,55,208,77,254,114,125,245,64,102,37,25,172,205,202,21,175,54,81,210,197,180,131,30,39,200,176,75,40,167,222,39,167,36,204,153,80,26,41,201,154,21,22,123,154,113,95,144,3,37,239,183,78,217,204,172,85,174,110,254,41,24,40,54,41,61,54,205,0,20,44,30,127,165,3,126,244,194,180,218,168,48,167,41,181,76,227,83,22,181,118,112,22,140,222,5,233,116,148,71,79,204,112,156,148,36,103,48,200,94,243,26,204,90,151,116,19,211,220,1,233,14,104,120,88,119,159,47,189,145,7,52,30,129,67,121,88,68,71,197,12,9,0,85,74,184,235,113,144,4,175,231,179,158,33,134,206,50,81,236,119,17,192,172,163,104,36,37,41,176,128,153,60,160,220,162,180,63,166,185,248,43,182,244,150,232,184,41,59,37,104,131,192,75,114,5,122,109,194,209,107,53,180,177,112,212,109,159,29,210,115,238,149,15,34,239,34,55,191,142,162,67,226,130,7,78,55,185,24,103,130,84,219,104,116,217,232,31,143,186,166,170,100,105,122,78,15,135,70,80,104,192,201,54,149,113,236,50,100,41,168,36,218,60,228,195,193,130,97,61,32,209,232,160,114,211,197,220,113,57,215,112,207,113,163,239,13,225,255,246,218,65,164,10,229,42,2,156,97,20,138,127,193,81,123,253,22,71,115,176,182,16,185,102,27,53,223,211,205,248,161,221,123,164,25,3,208,108,36,78,107,250,123,219,29,239,182,2,143,94,24,205,168,41,201,78,153,179,3,181,21,117,11,183,158,166,158,189,214,129,75,88,227,199,24,215,2,171,103,174,42,69,244,255,175,102,5,196,11,69,218,243,13,186,183,157,30,73,105,189,123,202,35,177,56,2,216,141,158,62,122,13,236,37,37,21,218,216,239,21,244,174,110,233,16,197,153,208,21,61,21,22,152,118,103,56,0,22,95,24,4,79,132,108,184,241,87,248,207,210,86,193,124,253,41,33,225,187,82,136,24,2,209,98,71,226,240,147,155,158,107,244,151,143,255,103,76,183,148,194,73,132,8,85,230,78,92,114,77,150,139,38,170,227,35,255,86,110,16,44,39,157,87,207,115,99,146,112,78,7,67,252,202,250,193,87,68,146,189,70,9,250,60,115,214,87,77,249,92,115,235,144,109,107,255,196,205,127,51,62,24,237,114,161,216,122,106,61,218,111,250,131,219,187,232,53,69,216,28,94,117,216,67,120,135,61,4,163,8,152,100,104,21,136,50,126,239,218,46,46,123,100,59,99,93,105,28,47,68,50,152,21,53,40,45,128,188,159,33,24,197,250,11,0,73,213,27,42,173,198,142,180,179,225,215,111,186,209,240,23,170,70,110,74,136,197,207,13,67,46,102,75,104,12,5,46,198,35,14,27,216,0,199,204,194,82,25,29,223,208,228,199,20,83,89,244,102,92,91,188,47,120,245,237,157,145,156,58,226,72,162,210,213,182,182,193,207,160,154,78,40,66,181,12,77,164,123,61,8,33,8,167,88,233,153,160,140,134,116,204,234,224,70,201,151,207,133,88,95,11,228,25,180,133,206,55,88,106,1,132,237,168,69,168,32,215,149,255,3,248,100,188,18,66,66,252,97,224,218,197,111,116,240,253,210,10,39,251,56,232,11,251,70,238,194,175,5,227,181,12,83,173,140,202,83,187,94,70,60,130,38,146,197,252,5,147,36,164,141,66,108,97,192,42,194,238,246,199,97,175,68,7,192,194,233,225,50,102,92,236,204,141,205,189,202,116,30,217,117,144,34,228,173,199,225,112,157,3,19,178,141,54,133,135,69,24,14,76,70,123,157,211,165,96,137,68,66,101},
  {249,177,240,182,42,109,0,184,221,38,125,131,114,119,16,32,76,171,60,19,72,224,18,154,16,46,118,219,185,77,141,160,69,156,94,56,14,18,203,16,52,219,218,92,142,16,228,8,169,152,43,82,152,244,225,116,61,225,123,72,232,3,192,58,240,133,14,192,92,24,74,20,121,208,238,68,196,147,84,169,208,143,94,252,89,25,196,30,76,27,135,92,162,205,31,6,38,251,40,30,195,81,237,11,187,72,236,60,25,138,116,58,132,203,197,129,163,185,148,35,224,171,156,232,11,87,0,76,44,46,245,86,75,117,11,192,217,65,183,50,18,200,212,165,191,69,231,202,46,241,60,159,133,14,90,207,210,156,200,114,205,22,253,234,114,97,174,240,96,20,136,23,66,166,221,67,132,202,64,194,65,132,223,119,90,139,219,224,243,82,96,33,133,83,122,3,169,38,86,228,206,30,186,28,137,149,232,216,6,193,17,205,50,218,6,181,64,157,234,113,224,211,1,79,19,59,127,53,134,151,50,249,52,233,145,211,195,143,235,184,154,38,161,10,116,0,255,149,87,212,114,33,220,194,120,213,217,163,27,41,150,55,91,231,48,139,237,196,159,201,199,193,41,142,31,169,178,104,42,117,115,161,114,7,56,95,153,109,213,161,45,168,158,95,122,5,224,129,175,158,211,247,168,31,92,145,95,238,9,7,190,248,117,228,143,41,150,196,33,41,201,39,5,190,13,25,167,128,66,38,253,99,94,31,173,198,246,120,10,60,107,139,96,51,173,216,96,154,53,41,235,84,30,105,95,106,240,86,0,195,39,223,118,222,124,49,187,55,205,31,163,12,40,61,137,19,109,70,147,32,51,114,200,23,118,58,159,119,23,194,84,104,27,49,60,153,76,187,86,7,14,17,111,22,71,52,60,20,191,90,157,243,16,63,119,189,41,19,157,82,123,168,29,239,72,252,134,69,137,234,189,198,34,138,49,164,64,15,205,224,177,139,158,1,40,150,165,85,158,231,100,250,230,98,51,59,190,102,173,136,224,111,124,77,80,40,206,59,177,199,90,246,190,209,147,224,128,221,156,25,195,211,134,121,94,166,153,142,130,34,31,183,156,30,248,137,0,185,45,174,50,32,31,55,244,43,141,125,183,80,174,216,17,68,203,119,77,149,107,110,135,210,80,238,189,210,41,115,28,106,162,70,183,62,72,132,62,60,117,96,68,175,32,240,115,3,155,70,190,108,215,14,194,26,28,67,23,94,221,106,197,5,6,7,171,76,161,70,208,72,76,199,34,189,247,183,49,145,47,182,76,38,81,206,148,178,114,193,127,248,115,101,94,190,46,229,209,156,62,20,30,103,118,159,254,68,88,211,91,85,234,109,212,68,55,73,192,139,77,193,208,149,4,106,66,225,42,58,39,97,240,106,5,202,12,14,170,153,21,11,134,100,232,231,98,204,255,251,107,226,180,185,54,204,52,36,126,193,235,128,186,118,242,63,127,136,197,17,242,98,29,30,255,145,168,100,107,194,94,88,231,32,10,70,123,3,141,238,106,176,44,75,38,232,171,84,30,60,100,162,166,93,67,241,161,142,75,11,17,9,246,232,45,53,23,163,134,108,132,22,44,125,192,93,27,124,37,9,64,0,243,200,78,6,73,115,224,207,201,147,51,231,250,222,120,2,22,95,192,250,215,155,222,177,225,85,209,9,129,146,161,79,249,197,50,127,141,88,51,218,252,79,253,177,38,163,10,226,213,125,104,41,204,227,47,194,13,71,200,168,209,4,114,192,9,236,161,113,212,135,225,16,32,87,150,40,33,148,149,97,137,191,174,26,85,131,147,143,109,72,27,69,101,248,151,154,51,51,168,217,168,215,162,72,145,97,70,105,45,131,71,31,179,32,168,19,8,95,60,145,5,251,129,35,91,95,92,45,242,150,10,178,74,188,240,56,55,60,89,214,121,32,79,163,57,170,130,110,208,118,55,244,25,120,231,196,156,222,158,97,77,249,1,46,142,39,70,29,52,42,172,82,144,38,34,170,127,71,205,112,87,185,247,216,75,217,8,144,183,149,105,80,16,17,84,71,195,152,206,186,217,112,244,158,242,21,81,8,175,144,202,223,2,85,148,141,194,150,51,98,181,246,76,45,195,117,247,113,113,203,48,126,104,210,197,88,225,217,60,209,187,127,143,111,178,146,22,175,225,19,30,23,184,29,126,194,187,30,114,8,229,125,6,63,96,196,45,194,136,46,122,208,168,9,128,129,212,17,148,141,52,91,105,211,95,116,2,87,202,2,171,52,63,99,194,99,194,243,154,144,203,113,65,191,107,39,187,236,112,145,173,149,221,70,165,113,17,240,35,52,80,3,37,241,130,3,243,141,233,233,162,200,148,254,95,20,38,35,68,177,118,196,169,4,106,177,201,105,26,161,119,219,180,115,35,226,132,87,39,198,197,77,4,31,34,185,113,230,101,204,44,50,239,141,98,157,210,179,176,232,190,246,13,227,0,58,164,176,58,31,251,85,52,236,84,42,23,48,79,232,42,38,150,10,57,64,73,128,173,232,112,4,95,222,181,92,98,178,77,52,84,66,228,100,71,223,174,203,210,251,185,237,22,89,175,17,229,86,115,251,130,252,213,118,179,179,30,120,159,15,47,140,86,12,58,227,94,172,255,36,1,148,211,89,31,30,115,157,235,167,104,149,169,67,210,218,107,15,164,134,151,176,59,151,137,72,100,110,166,184,76,108,27,126,131,149,87,225,174,42,236,228,108,11,56,242,178,105,160,119,191,246,12,214,125,175,43,214,67,123,43,201,182,225,50,26,59,56,75,159,148,122,105,19,46,159,206,80,105,183,178,92,159,171,210,85,151,190,247,133,66,252,209,13,158,216,9,75,128,162,30,48,217,147,188,163,108,201,21,208,189,253,242,241,239,95,73,69,137,10,133,67,83,165,216,12,123,42,166,52,28,32,200,104,93,2,61,27,79,242,169,91,118,179,194,29,196,35,230,136,116,211,44,29,194,60,179,209,204,6,120,240,228,158,241,194,95,231,140,184,13,217,232,174,207,140,143,35,100,102,206,209,239,133,55,78,2,94,2,79,81,252,41,95,0,1,64,142,23,201,22,218,118,235,150,29,154,147,135,24,244,211,111,115,21,181,205,252,11,86,138,199,88,101,190,230,146,30,50,252,54,6,121,43,33,159,221,86,70,236,116,136,73,150,175,21,108,103,52,97,156,129,178,178,206,101,55,252,41,107,183,70,66,160,27,51,247,228,211,171,246,134,124,143,186,202,34,63,237,167,159,108,128,145,136,59,160,66,247,0,119,39,64,70,238,126,215,163,207,149,185,17,249,168,145,249,4,250,39,138,58,130,172,37,50,246,66,212,49,254,29,253,41,122,2,107,176,88,90,171,241,179,216,181,129,178,103,149,80,228,92,163,212,214,186,47,179,55,40,129,227,188,183,43,174,18,155,108,105,91,164,226,162,2,33,153,52,94,46,191,20,252,96,182,69,54,183,116,131,89,118,24,33,99,191,71,99,246,251,19,202,192,154,194,46,88,77,17,88,128,99,138,55,80,67,219,224,42,193,11,15,177,166,169,157,88,248,161,194,240,71,73,9,50,189,161,146,147,236,14,238,201,136,82,208,32,191,191,16,74,110,122,75,221,226,57,41,101,216,120,169,194,188,54,143,166,235,233,241,76,231,216,126,25,148,131,159,121,136,21,84,72,17,28,24,189,154,69,90,45,30,206,78,124,179,95,93,86,10,101,59,191,209,85,210,126,82,239,77,112,218,73,32,151,15,248,0,168,199,190,221,139,31,97,82,219,55,25,247,91,10,135,102,137,3,70,73,162,171,121,78,190,16,100,61,87,93,208,76,116,172,127,220,52,40,181,151,82,216,176,175,47,123,141,93,71,93,129,96,21,176,159,7,156,168,56,240,227,176,40,164,118,172,82,198,37,104,121,237,229,20,117,24,149,246,5,210,192,118,240,51,74,144,83,49,211,78,114,106,54,170,248,0,69,106,74,241,208,37,246,215,145,157,40,234,73,16,145,107,160,183,89,114,33,254,5,26,111,86,231,2,224,125,103,96,90,93,182,202,125,239,138,124,142,102,163,42,53,7,204,228,185,51,45,211,224,97,139,89,233,8,130,224,185,242,239,113,59,31,52,175,217,93,74,166,254,247,214,120,178,23,99,172,74,194,13,54,14,234,123,254,193,39,204,238,157,192,137,81,158,180,73,178,115,231,14,129,148,151,62,18,208,23,95,174,24,233,153,94,237,168,179,29,226,43,98,36,239,145,249,147,1,105,213,95,42,242,98,85,22,14,110,172,134,97,31,118,144,200,48,159,151,46,148,170,20,80,135,92,250,116,29,94,144,144,65,37,199,234,178,134,252,50,43,137,44,255,137,2,35,11,142,242,131,237,70,196,76,90,111,235,157,174,81,34,241,80,170,155,66,83,222,28,245,95,84,50,123,181,56,177,213,237,111,166,84,157,132,78,251,125,242,93,218,21,73,232,168,224,122,72,234,176,255,139,226,59,180,134,3,166,153,23,54,248,126,238,157,145,184,77,221,184,224,123,235,55,191,141,26,69,122,35,170,209,87,250,198,201,125,76,151,38,112,77,30,185,25,107,210,200,137,191,111,162,101,78,144,120,10,24,17,242,81,213,143,173,101,72,252,244,19,200,175,246,191,220,91,127,192,44,214,165,237,40,196,203,92,232,236,135,164,36,105,112,239,56,89,199,167,98,151,59,130,109,153,141,4,27,40,100,161,70,243,224,208,2,211,0,103,41,104,199,201,151,209,136,198,247,97,224,11,112,197,255,129,169,57,242,193,55,240,20,126,29,124,152,124,115,119,16,250,199,247,124,8,55,1,118,106,173,99,97,227,205,237,238,228,108,76,6,241,12,20,168,17,149,130,251,220,11,142,36,148,70,100,79,14,123,56,12,17,166,173,235,69,180,115,30,91,184,127,131,82,19,210,102,131,26,65,95,46,191,127,145,144,222,111,195,163,245,19,187,47,65,26,14,25,152,11,57,16,225,58,69,134,61,108,245,150,104,197,11,130,250,81,106,206,201,253,131,220,208,158,14,33,38,58,121,110,72,230,153,193,137,200,98,66,194,5,100,55,62,210,2,118,215,248,175,98,163,201,11,188,41,221,137,150,236,251,152,160,206,192,27,106,229,133,1,17,139,59,21,225,66,14,84,228,46,251,25,153,253,161,58,100,28,30,92,246,149,156,237,18,29,171,82,147,15,104,53,64,85,232,158,181,80,162,83,171,219,157,248,165,166,62,138,29,96,37,188,177,34,13,205,111,241,195,59,92,104,71,104,137,199,247,252,11,245,240,177,181,138,113,229,184,243,130,188,201,41,32,253,243,113,26,224,151,35,202,2,0,45,134,192,250,38,142,110,59,166,49,105,181,165,94,246,23,70,14,84,172,131,135,32,236,91,13,119,246,125,125,206,70,24,247,228,60,110,151,161,34,255,77,226,162,218,200,133,140,255,103,39,90,135,92,141,227,46,233,239,159,74,51,106,233,106,252,55,242,200,214,76,212,249,49,221,60,246,95,26,197,89,184,100,97,168,47,56,18,127,252,33,32,245,184,71,34,115,37,6,239,196,104,138,221,177,85,247,85,116,102,200,127,135,113,54,50,148,75,161,238,23,241,156,151,129,97,179,238,213,146,82,48,36,219,54,24,66,63,255,85,244,155,55,242,121,127,130,148,228,191,45,89,169,63,182,114,166,82,251,100,130,232,126,173,29,160,32,242,210,232,82,226,208,174,48,254,176,126,22,22,147,231,40,153,11,50,194,95,175,229,67,46,20,199,105,33,105,4,125,103,255,18,96,67,180,155,214,176,153,214,111,237,43,229,79,100,229,241,30,22,83,207,82,234,8,119,50,28,147,94,7,101,252,81,140,3,197,35,7,153,141,65,182,159,238,29,141,12,156,14,18,174,11,1,109,154,51,54,212,13,155,41,1,231,132,127,21,230,245,46,63,52,115,229,35,147,128,196,240,121,146,55,32,53,222,81,128,23,237,233,224,29,19,143,57,213,102,117,15,22,141,91,84,151,13,120,150,55,214,199,80,228,60,121,173,76,171,92,195,46,9,196,2,181,175,215,73,60,89,178,28,6,173,93,12,116,203,120,198,231,127,68,97,63,197,12,158,66,78,142,112,63,31,3,37,192,110,84,3,249,255,5,81,97,63,140,71,114,164,32,5,63,220,224,174,118,165,216,217,50,122,11,59,238,50,138,218,242,179,86,33,14,90,161,112,26,166,106,190,100,231,93,101,83,70,140,96,219,51,61,217,32,141,208,27,134,101,75,60,81,176,20,129,17,78,155,145,99,103,85,58,228,70,235,105,191,166,112,254,196,109,129,172,204,155,113,247,52,189,218,119,164,121,169,79,156,220,32,233,214,196,253,143,57,42,15,199,66,199,20,53,38,63,182,176,2,79,137,62,176,97,235,233,207,91,97,32,101,52,95,48,107,4,182,1,81,188,113,149,58,83,151,17,94,226,0,86,219,1,162,13,202,246,79,62,74,69,84,117,79,60,72,180,53,57,248,168,248,249,45,194,182,61,188,5,50,43,212,196,236,145,14,132,236,246,49,148,116,47,236,147,169,148,112,133,129,79,89,101,27,208,237,3,105,28,251,43,179,35,31,113,137,6,226,164,171,112,219,49,202,133,56,5,78,76,39,1,60,57,80,96,122,14,233,174,133,238,76,191,104,187,21,5,70,16,237,135,84,26,93,226,141,197,191,144,143,74,77,218,143,46,249,169,177,147,35,77,74,92,74,202,101},
  {65,13,11,242,127,219,47,50,160,206,14,232,120,218,244,117,172,223,193,26,53,90,58,251,153,6,229,194,27,241,111,48,245,234,204,180,251,103,188,122,4,9,231,139,209,189,192,57,249,55,23,164,194,84,20,221,34,4,237,65,72,255,83,205,251,242,195,148,80,157,233,239,100,135,198,251,118,122,156,145,100,252,58,191,213,46,203,114,145,65,59,233,120,224,197,84,65,157,135,250,123,228,33,106,39,220,4,7,74,224,194,0,37,188,44,234,154,16,122,173,181,175,66,136,237,13,138,227,140,6,201,4,146,190,174,32,112,220,206,12,238,90,20,253,13,180,124,120,67,103,85,120,154,239,41,152,123,48,7,229,132,219,87,84,31,126,252,138,5,242,33,175,35,244,151,196,65,26,207,203,108,126,78,217,6,174,83,10,76,209,197,46,208,25,61,22,53,142,118,35,195,36,2,84,72,144,8,109,138,47,164,233,139,80,112,226,165,77,88,6,3,189,11,171,72,227,25,126,93,82,195,123,87,218,118,243,91,0,212,51,52,56,60,150,41,206,235,231,171,119,13,201,40,225,31,138,99,75,161,108,62,197,231,145,121,93,76,100,74,51,15,74,124,45,94,7,168,170,228,208,57,230,255,27,249,89,157,4,40,248,91,76,159,114,13,220,16,111,197,171,121,246,227,101,82,11,43,122,95,241,5,197,43,144,23,151,116,216,137,91,192,12,2,6,225,146,35,73,227,46,146,4,232,129,189,106,149,197,249,219,70,210,53,116,147,100,122,177,14,0,216,6,138,151,43,127,169,3,55,29,108,204,79,132,161,124,122,201,41,90,54,103,189,234,97,92,17,249,241,69,115,175,15,176,150,50,16,91,247,7,114,157,190,75,184,88,84,96,81,83,58,60,147,12,155,47,217,42,1,223,75,24,147,234,139,133,181,127,136,157,6,131,41,236,101,168,156,122,62,102,206,39,231,36,102,183,115,59,179,193,167,8,182,54,45,82,97,56,112,170,41,244,192,131,136,129,136,103,83,142,96,232,11,190,226,191,240,88,67,118,25,42,220,64,231,33,48,208,73,187,253,93,215,92,35,86,192,118,84,193,219,244,58,139,0,206,67,216,18,175,65,87,222,193,215,8,116,140,50,237,249,58,233,245,85,179,38,144,242,89,91,35,28,217,135,5,93,175,214,81,24,161,206,159,140,175,205,41,89,37,250,110,134,235,150,41,169,85,94,101,251,106,200,44,33,205,21,126,254,97,80,145,198,116,242,243,77,11,162,244,244,190,6,85,99,20,90,37,99,239,246,211,9,168,27,160,76,199,190,40,78,139,190,70,87,184,110,230,167,81,235,111,115,142,100,137,50,69,128,28,194,80,162,76,244,208,66,159,119,69,84,49,73,154,196,223,90,4,209,98,59,181,77,84,238,58,171,230,86,193,45,203,242,224,4,204,0,95,100,10,86,64,236,175,37,103,136,204,231,237,137,126,134,71,228,168,90,65,254,11,47,74,147,224,200,148,219,48,8,59,99,158,36,156,137,170,240,100,189,31,43,61,28,129,10,192,93,211,51,136,106,232,168,14,175,218,233,72,252,37,178,252,42,116,202,119,136,56,131,166,211,129,243,76,158,244,138,39,158,145,250,140,175,183,218,42,146,123,7,117,104,252,71,34,213,53,222,8,142,170,87,254,10,63,10,162,92,93,179,186,110,173,56,142,236,166,192,117,49,150,107,105,179,106,180,136,136,124,14,151,71,205,250,120,179,40,104,8,21,178,212,27,145,236,161,225,67,79,60,50,149,220,69,238,21,132,213,34,81,248,209,135,227,174,230,64,161,27,47,254,85,250,229,63,25,71,53,158,142,9,180,203,76,112,216,249,115,92,145,146,65,157,183,232,233,59,147,79,53,12,81,65,209,147,185,0,39,148,158,245,223,155,220,31,144,165,93,221,149,54,40,97,116,43,63,229,159,184,221,171,183,79,245,186,150,103,65,194,19,254,61,62,216,199,46,33,91,191,248,118,102,6,255,213,8,234,117,172,90,201,218,176,141,127,89,177,235,214,3,19,147,35,243,1,50,91,5,255,112,151,53,246,37,144,205,87,203,192,213,81,180,251,109,19,63,135,132,56,107,46,171,141,143,153,12,214,135,44,251,21,177,105,208,212,94,41,100,254,135,45,117,82,6,180,0,115,1,23,181,90,123,181,46,12,217,14,137,251,172,168,82,21,165,101,108,80,123,66,38,209,55,206,240,157,28,141,42,181,164,138,80,222,63,91,9,93,77,136,196,239,125,96,31,167,221,35,205,54,18,106,14,127,234,208,228,43,138,131,18,110,86,178,184,154,127,206,13,1,156,150,100,14,78,164,87,243,161,255,6,189,65,250,231,249,65,233,153,62,184,75,206,136,116,132,193,249,7,253,234,6,36,232,89,15,130,123,254,62,136,226,56,254,32,52,225,152,238,179,159,2,182,106,60,228,239,175,70,52,250,145,127,219,75,30,109,252,119,120,135,12,218,210,253,245,187,134,109,54,111,150,5,171,34,28,63,83,228,39,154,188,249,71,16,186,132,190,185,230,57,63,175,21,75,128,8,136,6,77,37,136,61,15,3,76,216,32,143,183,89,248,26,207,61,14,72,54,123,157,0,97,90,102,164,81,68,64,148,93,44,104,92,190,218,147,174,35,139,221,223,22,27,220,129,204,90,199,231,188,176,91,112,145,37,173,109,16,199,205,94,121,143,140,141,63,101,55,0,28,33,230,133,102,224,101,221,144,168,116,7,127,216,131,185,240,73,189,16,106,105,240,40,200,237,212,150,115,201,111,80,53,75,122,250,247,57,52,31,120,67,70,139,199,19,210,113,117,151,157,121,211,8,40,119,237,73,33,42,42,3,66,167,70,52,105,143,160,149,210,194,89,120,225,196,240,233,210,131,117,181,97,245,99,113,255,138,51,213,231,90,99,178,254,67,134,146,28,142,14,68,133,246,180,104,211,69,93,216,111,77,170,154,159,254,164,177,56,231,121,142,225,228,113,225,175,92,106,31,50,118,77,19,122,134,91,121,198,7,36,135,78,254,55,251,56,128,9,162,79,38,104,255,196,184,166,98,183,25,89,108,56,208,39,125,168,202,130,63,227,204,144,90,33,104,157,127,54,22,122,246,99,236,216,243,7,237,148,12,40,154,149,209,36,173,14,113,12,55,67,192,173,205,197,167,229,85,96,178,73,246,116,32,76,210,206,205,108,150,69,238,170,173,123,57,126,254,102,27,6,141,59,96,35,41,59,56,209,25,205,118,54,169,2,235,241,145,155,138,21,19,177,130,168,64,29,117,55,70,174,245,246,125,244,207,243,174,156,19,67,132,46,235,117,191,157,157,64,203,163,190,67,94,18,8,169,121,188,209,46,251,40,227,61,225,125,230,121,41,112,24,145,109,21,20,168,251,20,101,246,82,171,98,88,116,152,105,226,184,90,230,21,23,70,165,19,169,145,135,193,230,47,95,85,177,11,97,34,158,110,206,168,254,138,31,145,39,131,118,134,148,43,30,72,37,20,15,89,223,47,119,211,183,92,159,178,43,236,252,53,41,30,143,83,154,51,158,75,236,232,248,216,197,98,160,164,42,96,58,255,159,104,223,195,160,131,95,248,112,239,7,242,1,245,155,26,242,32,111,104,23,159,85,253,111,178,59,44,132,230,73,134,137,251,220,6,209,246,26,166,207,161,90,190,48,209,143,202,152,166,164,205,57,146,115,253,53,149,94,176,43,97,253,45,98,151,168,221,115,57,86,220,234,92,170,201,37,20,83,86,202,103,252,58,80,215,59,229,205,222,69,23,124,125,114,87,210,187,188,128,174,80,92,106,49,15,78,83,80,98,202,72,195,197,81,108,7,40,57,181,35,227,88,64,187,139,102,155,101,93,21,167,77,195,159,50,183,227,163,73,116,173,255,191,59,9,227,2,206,153,111,119,245,187,209,113,156,198,202,214,112,59,187,223,172,26,51,37,0,215,34,12,5,86,55,31,218,126,29,20,214,153,36,73,43,51,78,41,148,102,182,125,57,58,89,251,36,77,1,12,87,244,211,252,21,190,237,175,84,25,148,250,200,103,246,78,188,250,204,102,149,104,70,239,91,51,52,209,158,75,160,192,217,57,56,88,123,192,195,228,16,20,230,8,183,6,243,195,235,46,120,242,163,178,218,217,226,86,22,245,138,92,61,138,199,72,158,237,166,96,16,28,62,174,7,101,207,215,16,100,199,98,49,196,182,248,143,254,76,136,152,217,205,121,63,108,10,213,46,66,86,154,123,131,120,115,38,232,211,54,171,107,161,7,206,215,56,223,52,199,80,99,220,164,83,87,209,31,211,232,214,145,171,153,175,170,95,45,67,233,25,215,223,236,29,96,200,159,65,6,61,33,107,218,244,41,183,167,133,129,12,34,2,173,141,183,28,125,154,114,68,114,41,242,175,27,14,152,46,8,175,67,16,228,100,116,251,92,24,75,205,198,168,16,238,53,225,4,212,206,168,157,85,111,95,147,182,99,236,37,205,16,62,143,32,113,71,155,175,12,220,42,103,236,248,113,96,151,68,71,94,255,95,195,7,173,125,3,164,150,147,93,65,81,232,8,186,70,44,218,99,116,4,165,44,187,186,14,249,246,13,25,182,65,213,50,148,75,168,107,178,234,44,45,161,61,135,228,243,132,50,211,144,40,120,104,165,209,168,40,126,236,102,235,199,254,136,197,139,168,161,165,196,162,193,233,161,202,128,123,216,253,247,158,202,138,177,151,108,160,166,48,226,36,91,253,85,200,218,209,108,205,228,213,132,156,135,11,26,164,46,197,217,111,15,1,219,214,165,173,181,88,165,44,136,206,130,220,98,42,20,78,154,84,155,186,225,16,98,178,244,61,91,86,234,64,168,210,53,198,204,77,127,202,165,253,65,166,14,251,75,191,37,39,19,221,49,244,197,94,143,43,24,195,213,254,22,187,225,27,2,113,248,229,62,9,41,33,108,78,14,47,77,214,246,21,239,71,32,215,74,224,161,7,94,110,73,83,23,236,17,32,179,35,216,236,243,106,7,111,78,129,18,44,234,75,41,87,89,1,36,115,131,111,202,252,189,229,65,134,250,66,180,68,172,237,219,147,54,232,127,178,248,211,31,175,13,21,67,10,98,117,231,53,188,140,243,148,121,151,215,93,197,146,48,135,79,192,175,177,149,110,171,11,18,220,210,186,26,142,59,103,6,133,90,158,8,105,236,155,76,134,113,74,24,55,10,180,207,195,49,242,174,172,111,234,209,30,4,51,122,81,189,188,233,99,56,88,199,59,19,169,32,91,48,65,227,118,132,82,102,71,212,213,61,200,213,28,116,158,170,195,97,99,141,26,167,45,227,83,121,159,89,184,3,233,119,94,51,95,176,163,173,30,101,131,241,112,139,134,54,172,98,121,77,91,23,98,195,11,141,81,233,46,7,169,92,92,223,217,200,110,46,125,208,53,169,15,83,3,54,35,169,212,252,51,111,0,165,90,24,163,168,147,150,43,110,74,6,87,139,22,90,35,145,116,246,218,231,176,127,122,20,45,100,41,173,70,222,53,57,229,123,105,38,1,244,182,41,163,10,75,133,208,90,28,186,132,133,210,24,43,250,172,46,231,46,113,116,113,99,254,79,133,26,254,220,102,72,200,143,141,118,155,164,192,61,24,115,90,98,217,14,19,86,96,158,93,30,22,71,161,71,246,48,14,18,219,217,25,231,226,132,5,221,202,18,243,61,110,227,229,219,145,238,130,223,14,27,201,221,186,198,121,234,156,55,225,126,118,130,70,170,249,96,119,221,159,242,242,30,237,3,3,156,19,78,24,172,124,209,152,28,176,91,52,90,106,5,135,102,75,174,162,222,56,252,63,47,104,252,182,111,42,22,80,77,221,65,35,128,158,222,11,16,164,255,0,80,134,5,153,106,199,247,192,99,249,160,121,58,169,234,58,107,61,30,19,76,9,195,152,205,30,127,77,219,250,81,57,119,203,157,54,250,123,239,6,228,8,168,100,35,253,53,191,21,79,72,21,45,86,31,64,179,155,238,109,86,216,189,231,65,170,219,60,193,129,168,123,25,141,140,218,253,48,165,253,7,150,111,245,3,188,2,158,59,67,112,203,157,62,142,159,99,193,174,177,11,198,174,43,62,79,218,183,1,160,109,190,255,208,202,168,113,67,88,17,243,45,146,211,197,127,94,250,180,131,227,204,94,171,201,26,94,127,22,48,107,84,9,195,141,89,85,204,39,39,151,170,253,155,145,207,10,243,47,166,179,251,181,203,234,203,107,242,182,142,2,254,201,70,242,86,152,155,73,75,99,185,58,164,134,231,142,245,205,225,12,172,110,127,152,216,174,117,250,72,98,145,190,189,37,155,62,212,45,32,185,191,31,219,243,73,121,183,93,242,8,141,186,35,191,57,24,118,0,232,125,194,130,183,210,242,26,206,129,108,57,84,193,39,243,252,152,71,61,125,99,217,187,55,151,106,28,184,115,118,73,206,126,218,242,128,21,238,177,118,150,97,156,61,28,74,105,145,126,195,229,186,154,154,149,39,217,72,19,171,27,141,253,252,154,24,110,125,2,229,191,197,245,225,92,157,163,188,249,153,122,150,67,57,69,250,28,41,127,207,187,90,38,208,10,108,94,222,208,159,15,138,210,74,194,232,55,51,91,110,130,195,199,77,173,239,17,240,170,10,121,192,159,244,186,252,159,43,206,114,147,103,129,17,53,249,98,28,217,250,63,12,74,197,95,200,54,206,250,164,252,221,145,103,225,50,128,108},
} ;

static void test_decode_761xint32_impl(long long impl)
{
  unsigned char *x = test_decode_761xint32_x;
  unsigned char *s = test_decode_761xint32_s;
  unsigned char *x2 = test_decode_761xint32_x2;
  unsigned char *s2 = test_decode_761xint32_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_761xint32_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_761xint32(impl);
    printf("decode_761xint32 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_761xint32_implementation(impl),ntruprime_dispatch_decode_761xint32_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_761xint32;
    printf("decode_761xint32 selected implementation %s compiler %s\n",ntruprime_decode_761xint32_implementation(),ntruprime_decode_761xint32_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_761xint32_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_761xint32_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_761xint32_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_761xint32_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_761xint32_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_761xint32_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_761xint32(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"761xint32")) return;
  storage_decode_761xint32_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_761xint32_x = aligned(storage_decode_761xint32_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_761xint32_s = callocplus(crypto_decode_STRBYTES);
  test_decode_761xint32_s = aligned(storage_decode_761xint32_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_761xint32_x2 = callocplus(maxalloc);
  test_decode_761xint32_x2 = aligned(storage_decode_761xint32_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_761xint32_s2 = callocplus(maxalloc);
  test_decode_761xint32_s2 = aligned(storage_decode_761xint32_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_761xint32 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_761xint32();++impl)
      forked(test_decode_761xint32_impl,impl);
    ++test_decode_761xint32_x;
    ++test_decode_761xint32_s;
    ++test_decode_761xint32_x2;
    ++test_decode_761xint32_s2;
  }
  free(storage_decode_761xint32_s2);
  free(storage_decode_761xint32_x2);
  free(storage_decode_761xint32_s);
  free(storage_decode_761xint32_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

