
macro(find_qt_libs mgl_qt_major mgl_qt_ver qt_lib_req qt_lib_add)
	set(CMAKE_AUTOMOC ON)
	set(CMAKE_AUTOUIC ON)
	set(CMAKE_INCLUDE_CURRENT_DIR ON)
        set(MGL_HAVE_QT ON)
        set(MGL_QT_FOUND)
        set(MGL_QT_NOTFOUND)
        set(MGL_QT_LIBS)

        find_package(Qt${mgl_qt_major} ${mgl_qt_ver} QUIET COMPONENTS ${ARGN})
        foreach(mgl_qt_lib ${ARGN})
                if(NOT Qt${mgl_qt_major}${mgl_qt_lib}_FOUND)
                        list(APPEND MGL_QT_NOTFOUND Qt${mgl_qt_major}::${mgl_qt_lib})
                        set(MGL_HAVE_QT OFF)
                else(NOT Qt${mgl_qt_major}${mgl_qt_lib}_FOUND)
                        list(APPEND MGL_QT_FOUND Qt${mgl_qt_major}::${mgl_qt_lib})
                endif(NOT Qt${mgl_qt_major}${mgl_qt_lib}_FOUND)
        endforeach(mgl_qt_lib ${ARGN})
#        message("Libraries in found list ${MGL_QT_FOUND}")
#        message("Libraries in not found list ${MGL_QT_NOTFOUND}")
        if(MGL_HAVE_QT)
                if(${qt_lib_add})
                        set(MGL_QT_LIBS ${MGL_QT_FOUND})
                endif(${qt_lib_add})
        else(MGL_HAVE_QT)
                if(${qt_lib_req})
                        message(SEND_ERROR "Couldn't find the following Qt libraries ${MGL_QT_NOTFOUND}.")
                else(${qt_lib_req})
                        message("Couldn't find the following Qt libraries ${MGL_QT_NOTFOUND}.")
                endif(${qt_lib_req})
        endif(MGL_HAVE_QT)
#        message("Libraries list ${MGL_QT_LIBS}")
endmacro()

macro(mgl_add_qt_lib mgl_qt_major mgl_asqt)
#        message("Libraries list ${MGL_QT_LIBS}")
        mgl_add_lib(qt${mgl_qt_major} ${MGL_QT_FILES})
        target_link_libraries(mgl-qt${mgl_qt_major} mgl ${MGL_QT_LIBS})
        target_link_libraries(mgl-qt${mgl_qt_major}-static mgl-static ${MGL_QT_LIBS})

        if(${mgl_asqt})
                mgl_add_lib(qt ${MGL_QT_FILES})
                target_link_libraries(mgl-qt mgl ${MGL_QT_LIBS})
                target_link_libraries(mgl-qt-static mgl-static ${MGL_QT_LIBS})
                set_target_properties(mgl-qt PROPERTIES mgl_qt_major ${mgl_qt_major})
                if(${mgl_qt_major} STREQUAL "4")
                        set_target_properties(mgl-qt PROPERTIES mgl_qt_major "${mgl_qt_major}" mgl_qt_version "${mgl_qt4_version}" mgl_qt_components "${mgl_qt4_components}" mgl_qt_components_wk "${mgl_qt4_components_wk}" mgl_qt_components_we "${mgl_qt4_components_we}")
                endif(${mgl_qt_major} STREQUAL "4")
                if(${mgl_qt_major} STREQUAL "5")
                        set_target_properties(mgl-qt PROPERTIES mgl_qt_major "${mgl_qt_major}" mgl_qt_version "${mgl_qt5_version}" mgl_qt_components "${mgl_qt5_components}" mgl_qt_components_wk "${mgl_qt5_components_wk}" mgl_qt_components_we "${mgl_qt5_components_we}")
                endif(${mgl_qt_major} STREQUAL "5")
                if(${mgl_qt_major} STREQUAL "6")
                        set_target_properties(mgl-qt PROPERTIES mgl_qt_major "${mgl_qt_major}" mgl_qt_version "${mgl_qt6_version}" mgl_qt_components "${mgl_qt6_components}" mgl_qt_components_wk "${mgl_qt6_components_wk}" mgl_qt_components_we "${mgl_qt6_components_we}")
                endif(${mgl_qt_major} STREQUAL "6")
        endif(${mgl_asqt})

        if(enable-dep-dll)
                get_target_property(mgl_qt_loc Qt${mgl_qt_major}::QWindowsIntegrationPlugin LOCATION)
                install(CODE "SET(mgl_qt_loc \"${mgl_qt_loc}\")")
                install(CODE "SET(CMAKE_INSTALL_PREFIX \"${CMAKE_INSTALL_PREFIX}\")")
                message("Installing: ${mgl_qt_loc}")
                file(COPY ${mgl_qt_loc} DESTINATION "${CMAKE_INSTALL_PREFIX}/bin/plugins/platforms")
        endif(enable-dep-dll)
endmacro()
